import { EventEmitter } from 'stream';
import { PolicyRoomRevision } from './PolicyListRevision';
import { PolicyRoomRevisionIssuer } from './PolicyListRevisionIssuer';
import { PolicyRoomManager } from './PolicyRoomManger';
import { PolicyRuleEvent } from '../MatrixTypes/PolicyEvents';
import { Redaction } from '../MatrixTypes/Redaction';
import { MatrixRoomID } from '@the-draupnir-project/matrix-basic-types';
import { LiteralPolicyRule } from './PolicyRule';
/**
 * A standard implementation of PolicyRoomRevisionIssuer.
 */
export declare class StandardPolicyRoomRevisionIssuer extends EventEmitter implements PolicyRoomRevisionIssuer {
    readonly room: MatrixRoomID;
    currentRevision: PolicyRoomRevision;
    private readonly batcher;
    /**
     * Creates a new StandardPolicyRoomRevisionIssuer, you shouldn't have to use this,
     * instead use the `PolicyRoomManager`.
     * @see {@link PolicyRoomManager}.
     * @param room The matrix room to issue revisions for.
     * @param currentRevision The current revision for the room, can be blank.
     * @param policyListManager The policy list manager to use to fetch room state with.
     */
    constructor(room: MatrixRoomID, currentRevision: PolicyRoomRevision, policyListManager: PolicyRoomManager);
    updateForStateEvent(event: PolicyRuleEvent): void;
    updateForRedactionEvent(event: Redaction): void;
    updateForRevealedPolicies(policies: LiteralPolicyRule[]): void;
    unregisterListeners(): void;
}
//# sourceMappingURL=StandardPolicyRoomRevisionIssuer.d.ts.map