import { PowerLevelPermission } from '../../Client/PowerLevelsMirror';
import { DescriptionMeta } from '../DescriptionMeta';
import { CapabilityInterfaceDescription } from './CapabilityInterface';
import { Capability, CapabilityProviderDescription } from './CapabilityProvider';
export type CapabilityInterfaceSet<TCapabilitySet extends CapabilitySet = CapabilitySet> = Record<keyof TCapabilitySet, CapabilityInterfaceDescription>;
export type CapabilityProviderSet<TCapabilitySet extends CapabilitySet = CapabilitySet> = Record<keyof TCapabilitySet, CapabilityProviderDescription>;
export type CapabilitySet<Names extends string = string> = Record<Names, Capability>;
export type GenericCapabilityDescription<TCapabilitySet extends CapabilitySet = CapabilitySet> = Record<keyof TCapabilitySet, string>;
export declare function initializeCapabilitySet<Context = unknown>(protectionDescription: DescriptionMeta, capabilityDescriptions: CapabilityProviderSet, context: Context): CapabilitySet;
export declare function capabilitySetEventPermissions(set: CapabilitySet): string[];
export declare function capabilitySetPermissions(set: CapabilitySet): PowerLevelPermission[];
export declare function capabilitySetStatePermissions(set: CapabilitySet): string[];
//# sourceMappingURL=CapabilitySet.d.ts.map