import { EventEmitter } from 'events';
import { PolicyListRevisionIssuer } from '../PolicyList/PolicyListRevisionIssuer';
import { PolicyListRevision } from '../PolicyList/PolicyListRevision';
import { StandardPolicyListRevision } from '../PolicyList/StandardPolicyListRevision';
import { PolicyRuleChange } from '../PolicyList/PolicyRuleChange';
import { MatrixRoomID } from '@the-draupnir-project/matrix-basic-types';
export interface DirectPropagationPolicyListRevisionIssuer extends PolicyListRevisionIssuer {
    addIssuer(issuer: PolicyListRevisionIssuer): void;
    removeIssuer(issuer: PolicyListRevisionIssuer): void;
    unregisterListeners(): void;
    readonly references: MatrixRoomID[];
}
export type PolicyFilter = (change: PolicyRuleChange) => boolean;
export declare class StandardDirectPropagationPolicyListRevisionIssuer extends EventEmitter implements DirectPropagationPolicyListRevisionIssuer {
    private readonly filter?;
    private revision;
    private revisionListener;
    private readonly policyListRevisionIssuers;
    constructor(issuers: PolicyListRevisionIssuer[], filter?: PolicyFilter | undefined);
    private filterChanges;
    handleRevision(_newRevision: PolicyListRevision, unfilteredChanges: PolicyRuleChange[]): void;
    get currentRevision(): StandardPolicyListRevision;
    unregisterListeners(): void;
    get references(): MatrixRoomID[];
    previewIncorperationOfRevision(revision: PolicyListRevision): PolicyRuleChange[];
    previewRemovalOfRevision(revision: PolicyListRevision): PolicyRuleChange[];
    private addIssuers;
    addIssuer(issuer: PolicyListRevisionIssuer): void;
    removeIssuer(issuer: PolicyListRevisionIssuer): void;
}
//# sourceMappingURL=DirectPropagationPolicyListRevisionIssuer.d.ts.map