"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RoomMessageBodyMixinDescription = void 0;
const StandardMixinExtractor_1 = require("../EventMixinExtraction/StandardMixinExtractor");
const hasOwn_1 = require("../hasOwn");
exports.RoomMessageBodyMixinDescription = Object.freeze({
    name: 'm.room.message body mixin',
    description: 'Extracts the body property from content that looks like a m.room.message',
    properties: ['body'],
    parser(content) {
        if (!(0, hasOwn_1.hasOwn)(content, 'body')) {
            return undefined;
        }
        if (typeof content.body === 'string') {
            return {
                description: this,
                isErroneous: false,
                body: content.body,
            };
        }
        return (0, StandardMixinExtractor_1.ErroneousMixin)(this, 'The body property is not a string.');
    },
});
//# sourceMappingURL=RoomMessageBodyMixin.js.map