"use strict";
// Copyright 2022 - 2024 Gnuxie <Gnuxie@protonmail.com>
// Copyright 2019 - 2021 The Matrix.org Foundation C.I.C.
//
// SPDX-License-Identifier: AFL-3.0 AND Apache-2.0
//
// SPDX-FileAttributionText: <text>
// This modified file incorporates work from mjolnir
// https://github.com/matrix-org/mjolnir
// </text>
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeCommandDispatcherTimelineListener = makeCommandDispatcherTimelineListener;
const matrix_protection_suite_1 = require("matrix-protection-suite");
const log = new matrix_protection_suite_1.Logger("ManagementRoom");
function makeCommandDispatcherTimelineListener(managementRoom, client, dispatcher) {
    const managementRoomID = managementRoom.toRoomIDOrAlias();
    return function (roomID, event) {
        if (roomID !== managementRoomID) {
            return;
        }
        if (matrix_protection_suite_1.Value.Check(matrix_protection_suite_1.RoomMessage, event) &&
            matrix_protection_suite_1.Value.Check(matrix_protection_suite_1.TextMessageContent, event.content)) {
            if (event.content.body ===
                "** Unable to decrypt: The sender's device has not sent us the keys for this message. **") {
                log.info(`Unable to decrypt an event ${event.event_id} from ${event.sender} in the management room ${managementRoom.toPermalink()}.`);
                void (0, matrix_protection_suite_1.Task)(client.unstableApis
                    .addReactionToEvent(roomID, event.event_id, "⚠")
                    .then((_) => (0, matrix_protection_suite_1.Ok)(undefined)));
                void (0, matrix_protection_suite_1.Task)(client.unstableApis
                    .addReactionToEvent(roomID, event.event_id, "UISI")
                    .then((_) => (0, matrix_protection_suite_1.Ok)(undefined)));
                void (0, matrix_protection_suite_1.Task)(client.unstableApis
                    .addReactionToEvent(roomID, event.event_id, "🚨")
                    .then((_) => (0, matrix_protection_suite_1.Ok)(undefined)));
                return;
            }
            dispatcher.handleCommandMessageEvent({
                event,
                roomID,
            }, event.content.body);
        }
    };
}
//# sourceMappingURL=ManagementRoom.js.map