"use strict";
// SPDX-FileCopyrightText: 2024 Gnuxie <Gnuxie@protonmail.com>
//
// SPDX-License-Identifier: AFL-3.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.SafeModeRestartCommand = void 0;
const interface_manager_1 = require("@the-draupnir-project/interface-manager");
const SafeModeAdaptor_1 = require("./SafeModeAdaptor");
exports.SafeModeRestartCommand = (0, interface_manager_1.describeCommand)({
    summary: "Restart Draupnir, quitting safe mode.",
    parameters: [],
    async executor({ safeModeToggle, }) {
        return safeModeToggle.switchToDraupnir({ sendStatusOnStart: true });
    },
});
SafeModeAdaptor_1.SafeModeInterfaceAdaptor.describeRenderer(exports.SafeModeRestartCommand, {
    isAlwaysSupposedToUseDefaultRenderer: true,
});
//# sourceMappingURL=RestartDraupnirCommand.js.map