#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 5552
#define LARGE_STATE_COUNT 3425
#define SYMBOL_COUNT 656
#define ALIAS_COUNT 6
#define TOKEN_COUNT 364
#define EXTERNAL_TOKEN_COUNT 18
#define FIELD_COUNT 28
#define MAX_ALIAS_SEQUENCE_LENGTH 11
#define PRODUCTION_ID_COUNT 73

enum ts_symbol_identifiers {
  sym_identifier = 1,
  sym_comment = 2,
  anon_sym_LPAREN_STAR = 3,
  anon_sym_STAR_RPAREN = 4,
  aux_sym_block_comment_text_token1 = 5,
  aux_sym_block_comment_text_token2 = 6,
  aux_sym_block_comment_text_token3 = 7,
  aux_sym_block_comment_text_token4 = 8,
  anon_sym_MODULE = 9,
  anon_sym_DASH_DASH_DASH_DASH = 10,
  aux_sym_single_line_token1 = 11,
  anon_sym_EQ_EQ_EQ_EQ = 12,
  aux_sym_double_line_token1 = 13,
  anon_sym_EQ_EQ = 14,
  anon_sym_u225c = 15,
  anon_sym_BSLASHin = 16,
  anon_sym_u2208 = 17,
  anon_sym_LT_DASH = 18,
  anon_sym_u27f5 = 19,
  anon_sym_u2190 = 20,
  anon_sym_BSLASHA = 21,
  anon_sym_BSLASHforall = 22,
  anon_sym_u2200 = 23,
  anon_sym_BSLASHE = 24,
  anon_sym_BSLASHexists = 25,
  anon_sym_u2203 = 26,
  sym_temporal_forall = 27,
  sym_temporal_exists = 28,
  anon_sym_PIPE_DASH_GT = 29,
  anon_sym_u27fc = 30,
  anon_sym_u21a6 = 31,
  anon_sym_DASH_GT = 32,
  anon_sym_u27f6 = 33,
  anon_sym_u2192 = 34,
  anon_sym_LT_LT = 35,
  anon_sym_u3008 = 36,
  anon_sym_u27e8 = 37,
  anon_sym_GT_GT = 38,
  anon_sym_u3009 = 39,
  anon_sym_u27e9 = 40,
  anon_sym_GT_GT_ = 41,
  anon_sym_u3009_ = 42,
  anon_sym_u27e9_ = 43,
  anon_sym_LBRACK_RBRACK = 44,
  anon_sym_u25a1 = 45,
  anon_sym_COLON = 46,
  anon_sym_AT = 47,
  anon_sym_COLON_COLON = 48,
  anon_sym_u2237 = 49,
  sym_placeholder = 50,
  anon_sym_SLASH_BSLASH = 51,
  anon_sym_u2227 = 52,
  anon_sym_BSLASH_SLASH = 53,
  anon_sym_u2228 = 54,
  anon_sym_EXTENDS = 55,
  anon_sym_COMMA = 56,
  anon_sym_LOCAL = 57,
  anon_sym_VARIABLE = 58,
  anon_sym_VARIABLES = 59,
  anon_sym_CONSTANT = 60,
  anon_sym_CONSTANTS = 61,
  anon_sym_RECURSIVE = 62,
  anon_sym_LPAREN = 63,
  anon_sym_RPAREN = 64,
  anon_sym_LBRACK = 65,
  anon_sym_RBRACK = 66,
  anon_sym_INSTANCE = 67,
  anon_sym_WITH = 68,
  anon_sym_BANG = 69,
  aux_sym_child_id_token1 = 70,
  anon_sym_LAMBDA = 71,
  sym_real_number = 72,
  anon_sym_BSLASHb = 73,
  anon_sym_BSLASHB = 74,
  aux_sym_binary_number_token1 = 75,
  anon_sym_BSLASHo = 76,
  anon_sym_BSLASHO = 77,
  aux_sym_octal_number_token1 = 78,
  anon_sym_BSLASHh = 79,
  anon_sym_BSLASHH = 80,
  aux_sym_hex_number_token1 = 81,
  anon_sym_DQUOTE = 82,
  aux_sym_string_token1 = 83,
  anon_sym_DQUOTE2 = 84,
  sym_escape_char = 85,
  anon_sym_TRUE = 86,
  anon_sym_FALSE = 87,
  sym_string_set = 88,
  sym_boolean_set = 89,
  anon_sym_Nat = 90,
  anon_sym_u2115 = 91,
  anon_sym_Int = 92,
  anon_sym_u2124 = 93,
  anon_sym_Real = 94,
  anon_sym_u211d = 95,
  anon_sym_CHOOSE = 96,
  anon_sym_LBRACE = 97,
  anon_sym_RBRACE = 98,
  anon_sym_DOT = 99,
  anon_sym_EXCEPT = 100,
  anon_sym_EQ = 101,
  anon_sym_RBRACK_ = 102,
  anon_sym_WF_ = 103,
  anon_sym_SF_ = 104,
  anon_sym_IF = 105,
  anon_sym_THEN = 106,
  anon_sym_ELSE = 107,
  anon_sym_CASE = 108,
  anon_sym_OTHER = 109,
  anon_sym_LET = 110,
  anon_sym_IN = 111,
  anon_sym_BSLASHlnot = 112,
  anon_sym_BSLASHneg = 113,
  anon_sym_TILDE = 114,
  anon_sym_u00ac = 115,
  sym_union = 116,
  sym_powerset = 117,
  sym_domain = 118,
  anon_sym_DASH = 119,
  sym_negative_dot = 120,
  sym_enabled = 121,
  sym_unchanged = 122,
  anon_sym_LT_GT = 123,
  anon_sym_u22c4 = 124,
  anon_sym_u25c7 = 125,
  anon_sym_EQ_GT = 126,
  anon_sym_u27f9 = 127,
  anon_sym_u21d2 = 128,
  anon_sym_DASH_PLUS_DASH_GT = 129,
  anon_sym_u21f8 = 130,
  anon_sym_u2945 = 131,
  anon_sym_BSLASHequiv = 132,
  anon_sym_u2261 = 133,
  anon_sym_LT_EQ_GT = 134,
  anon_sym_u27fa = 135,
  anon_sym_u21d4 = 136,
  anon_sym_TILDE_GT = 137,
  anon_sym_u21dd = 138,
  anon_sym_u219d = 139,
  anon_sym_BSLASHland = 140,
  anon_sym_BSLASHlor = 141,
  anon_sym_COLON_EQ = 142,
  anon_sym_u2254 = 143,
  anon_sym_COLON_COLON_EQ = 144,
  anon_sym_u2a74 = 145,
  anon_sym_SLASH_EQ = 146,
  anon_sym_POUND = 147,
  anon_sym_u2260 = 148,
  anon_sym_LT = 149,
  sym_gt = 150,
  anon_sym_LT_EQ = 151,
  anon_sym_EQ_LT = 152,
  anon_sym_BSLASHleq = 153,
  anon_sym_u2264 = 154,
  anon_sym_GT_EQ = 155,
  anon_sym_BSLASHgeq = 156,
  anon_sym_u2265 = 157,
  anon_sym_BSLASHapprox = 158,
  anon_sym_u2248 = 159,
  anon_sym_PIPE_DASH = 160,
  anon_sym_u22a2 = 161,
  anon_sym_PIPE_EQ = 162,
  anon_sym_u22a8 = 163,
  anon_sym_DASH_PIPE = 164,
  anon_sym_u22a3 = 165,
  anon_sym_EQ_PIPE = 166,
  anon_sym_u2ae4 = 167,
  anon_sym_BSLASHasymp = 168,
  anon_sym_u224d = 169,
  anon_sym_BSLASHcong = 170,
  anon_sym_u2245 = 171,
  anon_sym_BSLASHdoteq = 172,
  anon_sym_u2250 = 173,
  anon_sym_BSLASHgg = 174,
  anon_sym_u226b = 175,
  anon_sym_BSLASHll = 176,
  anon_sym_u226a = 177,
  anon_sym_BSLASHnotin = 178,
  anon_sym_u2209 = 179,
  anon_sym_BSLASHprec = 180,
  anon_sym_u227a = 181,
  anon_sym_BSLASHsucc = 182,
  anon_sym_u227b = 183,
  anon_sym_BSLASHpreceq = 184,
  anon_sym_u2aaf = 185,
  anon_sym_BSLASHsucceq = 186,
  anon_sym_u2ab0 = 187,
  anon_sym_BSLASHpropto = 188,
  anon_sym_u221d = 189,
  anon_sym_BSLASHsim = 190,
  anon_sym_u223c = 191,
  anon_sym_BSLASHsimeq = 192,
  anon_sym_u2243 = 193,
  anon_sym_BSLASHsqsubset = 194,
  anon_sym_u228f = 195,
  anon_sym_BSLASHsqsupset = 196,
  anon_sym_u2290 = 197,
  anon_sym_BSLASHsqsubseteq = 198,
  anon_sym_u2291 = 199,
  anon_sym_BSLASHsqsupseteq = 200,
  anon_sym_u2292 = 201,
  anon_sym_BSLASHsubset = 202,
  anon_sym_u2282 = 203,
  anon_sym_BSLASHsupset = 204,
  anon_sym_u2283 = 205,
  anon_sym_BSLASHsubseteq = 206,
  anon_sym_u2286 = 207,
  anon_sym_BSLASHsupseteq = 208,
  anon_sym_u2287 = 209,
  sym_compose = 210,
  sym_map_to = 211,
  sym_map_from = 212,
  sym_setminus = 213,
  anon_sym_BSLASHcap = 214,
  anon_sym_BSLASHintersect = 215,
  anon_sym_u2229 = 216,
  anon_sym_BSLASHcup = 217,
  anon_sym_BSLASHunion = 218,
  anon_sym_u222a = 219,
  anon_sym_DOT_DOT = 220,
  anon_sym_u2025 = 221,
  anon_sym_DOT_DOT_DOT = 222,
  anon_sym_u2026 = 223,
  anon_sym_PLUS = 224,
  sym_plusplus = 225,
  anon_sym_BSLASHoplus = 226,
  anon_sym_LPAREN_PLUS_RPAREN = 227,
  anon_sym_u2295 = 228,
  anon_sym_BSLASHominus = 229,
  anon_sym_LPAREN_DASH_RPAREN = 230,
  anon_sym_u2296 = 231,
  sym_mod = 232,
  sym_modmod = 233,
  sym_vert = 234,
  anon_sym_PIPE_PIPE = 235,
  anon_sym_u2016 = 236,
  sym_minusminus = 237,
  sym_amp = 238,
  sym_ampamp = 239,
  anon_sym_BSLASHodot = 240,
  anon_sym_LPAREN_DOT_RPAREN = 241,
  anon_sym_u2299 = 242,
  anon_sym_BSLASHoslash = 243,
  anon_sym_LPAREN_SLASH_RPAREN = 244,
  anon_sym_u2298 = 245,
  anon_sym_BSLASHotimes = 246,
  anon_sym_LPAREN_BSLASHX_RPAREN = 247,
  anon_sym_u2297 = 248,
  sym_mul = 249,
  sym_mulmul = 250,
  sym_slash = 251,
  sym_slashslash = 252,
  anon_sym_BSLASHbigcirc = 253,
  anon_sym_u25ef = 254,
  anon_sym_BSLASHbullet = 255,
  anon_sym_u25cf = 256,
  anon_sym_BSLASHdiv = 257,
  anon_sym_u00f7 = 258,
  anon_sym_BSLASHcirc = 259,
  anon_sym_u2218 = 260,
  anon_sym_BSLASHstar = 261,
  anon_sym_u22c6 = 262,
  anon_sym_u203c = 263,
  sym_hashhash = 264,
  sym_dol = 265,
  sym_doldol = 266,
  anon_sym_QMARK_QMARK = 267,
  anon_sym_u2047 = 268,
  anon_sym_BSLASHsqcap = 269,
  anon_sym_u2293 = 270,
  anon_sym_BSLASHsqcup = 271,
  anon_sym_u2294 = 272,
  anon_sym_BSLASHuplus = 273,
  anon_sym_u228e = 274,
  anon_sym_BSLASHX = 275,
  anon_sym_BSLASHtimes = 276,
  anon_sym_u00d7 = 277,
  anon_sym_BSLASHwr = 278,
  anon_sym_u2240 = 279,
  anon_sym_BSLASHcdot = 280,
  anon_sym_u22c5 = 281,
  sym_pow = 282,
  sym_powpow = 283,
  anon_sym_CARET_PLUS = 284,
  anon_sym_u207a = 285,
  sym_asterisk = 286,
  sym_sup_hash = 287,
  sym_prime = 288,
  anon_sym_ASSUME = 289,
  anon_sym_ASSUMPTION = 290,
  anon_sym_AXIOM = 291,
  anon_sym_THEOREM = 292,
  anon_sym_PROPOSITION = 293,
  anon_sym_LEMMA = 294,
  anon_sym_COROLLARY = 295,
  anon_sym_PROVE = 296,
  anon_sym_NEW = 297,
  anon_sym_STATE = 298,
  anon_sym_ACTION = 299,
  anon_sym_TEMPORAL = 300,
  anon_sym_PROOF = 301,
  anon_sym_BY = 302,
  anon_sym_ONLY = 303,
  anon_sym_OBVIOUS = 304,
  anon_sym_OMITTED = 305,
  anon_sym_DEFINE = 306,
  anon_sym_HAVE = 307,
  anon_sym_WITNESS = 308,
  anon_sym_TAKE = 309,
  anon_sym_SUFFICES = 310,
  anon_sym_PICK = 311,
  anon_sym_QED = 312,
  anon_sym_USE = 313,
  anon_sym_HIDE = 314,
  anon_sym_DEF = 315,
  anon_sym_DEFS = 316,
  aux_sym_proof_step_id_token1 = 317,
  anon_sym_GT = 318,
  aux_sym_proof_step_id_token2 = 319,
  aux_sym_proof_step_id_token3 = 320,
  aux_sym_proof_step_ref_token1 = 321,
  aux_sym_proof_step_ref_token2 = 322,
  anon_sym_end = 323,
  anon_sym_algorithm = 324,
  anon_sym_SEMI = 325,
  anon_sym_DASH_DASHalgorithm = 326,
  anon_sym_DASH_DASHfair = 327,
  anon_sym_define = 328,
  anon_sym_macro = 329,
  anon_sym_procedure = 330,
  anon_sym_fair = 331,
  anon_sym_process = 332,
  anon_sym_variable = 333,
  anon_sym_variables = 334,
  anon_sym_begin = 335,
  anon_sym_if = 336,
  anon_sym_then = 337,
  anon_sym_elsif = 338,
  anon_sym_else = 339,
  anon_sym_while = 340,
  anon_sym_do = 341,
  anon_sym_either = 342,
  anon_sym_or = 343,
  anon_sym_with = 344,
  anon_sym_await = 345,
  anon_sym_when = 346,
  anon_sym_print = 347,
  anon_sym_assert = 348,
  sym_pcal_skip = 349,
  sym_pcal_return = 350,
  anon_sym_goto = 351,
  anon_sym_call = 352,
  sym_leading_extramodular_text = 353,
  sym_trailing_extramodular_text = 354,
  sym__indent = 355,
  sym__bullet = 356,
  sym__dedent = 357,
  sym__begin_proof = 358,
  sym__begin_proof_step = 359,
  sym__notify_pcal_algorithm_start = 360,
  sym__notify_pcal_algorithm_end = 361,
  sym__double_excl = 362,
  sym__error_sentinel = 363,
  sym_source_file = 364,
  sym_block_comment = 365,
  sym_block_comment_text = 366,
  sym_module = 367,
  sym_single_line = 368,
  sym_double_line = 369,
  sym_def_eq = 370,
  sym_set_in = 371,
  sym_gets = 372,
  sym_forall = 373,
  sym_exists = 374,
  sym_all_map_to = 375,
  sym_maps_to = 376,
  sym_langle_bracket = 377,
  sym_rangle_bracket = 378,
  sym_rangle_bracket_sub = 379,
  sym_case_box = 380,
  sym_case_arrow = 381,
  sym_colon = 382,
  sym_address = 383,
  sym_label_as = 384,
  sym_bullet_conj = 385,
  sym_bullet_disj = 386,
  sym_extends = 387,
  sym__unit = 388,
  sym_local_definition = 389,
  sym__definition = 390,
  sym_variable_declaration = 391,
  sym_constant_declaration = 392,
  sym_recursive_declaration = 393,
  sym_operator_declaration = 394,
  sym__id_or_op_declaration = 395,
  sym_operator_definition = 396,
  sym_function_definition = 397,
  sym_instance = 398,
  sym_substitution = 399,
  sym__op_or_expr = 400,
  sym__op = 401,
  sym_subexpr_prefix = 402,
  sym_subexpr_component = 403,
  sym_bound_op = 404,
  sym_bound_nonfix_op = 405,
  sym_subexpr_tree_nav = 406,
  sym_child_id = 407,
  sym_operator_args = 408,
  sym_lambda = 409,
  sym_module_definition = 410,
  sym__expr = 411,
  sym__subscript_expr = 412,
  sym_prefixed_op = 413,
  sym__number = 414,
  sym_nat_number = 415,
  sym_binary_number = 416,
  sym_octal_number = 417,
  sym_hex_number = 418,
  sym_string = 419,
  sym_boolean = 420,
  sym__number_set = 421,
  sym__primitive_value_set = 422,
  sym_nat_number_set = 423,
  sym_int_number_set = 424,
  sym_real_number_set = 425,
  sym_label = 426,
  sym_subexpression = 427,
  sym_parentheses = 428,
  sym_bounded_quantification = 429,
  sym_unbounded_quantification = 430,
  sym_choose = 431,
  sym_finite_set_literal = 432,
  sym_set_filter = 433,
  sym_set_map = 434,
  sym_quantifier_bound = 435,
  sym_restricted_quantifier_bound = 436,
  sym_tuple_of_identifiers = 437,
  sym_function_evaluation = 438,
  sym_function_literal = 439,
  sym_set_of_functions = 440,
  sym_record_literal = 441,
  sym_set_of_records = 442,
  sym_record_value = 443,
  sym_except = 444,
  sym_except_update = 445,
  sym_except_update_specifier = 446,
  sym_except_update_record_field = 447,
  sym_except_update_fn_appl = 448,
  sym_prev_func_val = 449,
  sym_tuple_literal = 450,
  sym_step_expr_or_stutter = 451,
  sym_step_expr_no_stutter = 452,
  sym_fairness = 453,
  sym_if_then_else = 454,
  sym_case = 455,
  sym_case_arm = 456,
  sym_other_arm = 457,
  sym_let_in = 458,
  sym_conj_list = 459,
  sym_conj_item = 460,
  sym_disj_list = 461,
  sym_disj_item = 462,
  sym_lnot = 463,
  sym_negative = 464,
  sym_always = 465,
  sym_eventually = 466,
  sym_prefix_op_symbol = 467,
  sym_bound_prefix_op = 468,
  sym_implies = 469,
  sym_plus_arrow = 470,
  sym_equiv = 471,
  sym_iff = 472,
  sym_leads_to = 473,
  sym_land = 474,
  sym_lor = 475,
  sym_assign = 476,
  sym_bnf_rule = 477,
  sym_eq = 478,
  sym_neq = 479,
  sym_lt = 480,
  sym_leq = 481,
  sym_geq = 482,
  sym_approx = 483,
  sym_rs_ttile = 484,
  sym_rd_ttile = 485,
  sym_ls_ttile = 486,
  sym_ld_ttile = 487,
  sym_asymp = 488,
  sym_cong = 489,
  sym_doteq = 490,
  sym_gg = 491,
  sym_ll = 492,
  sym_in = 493,
  sym_notin = 494,
  sym_prec = 495,
  sym_succ = 496,
  sym_preceq = 497,
  sym_succeq = 498,
  sym_propto = 499,
  sym_sim = 500,
  sym_simeq = 501,
  sym_sqsubset = 502,
  sym_sqsupset = 503,
  sym_sqsubseteq = 504,
  sym_sqsupseteq = 505,
  sym_subset = 506,
  sym_supset = 507,
  sym_subseteq = 508,
  sym_supseteq = 509,
  sym_cap = 510,
  sym_cup = 511,
  sym_dots_2 = 512,
  sym_dots_3 = 513,
  sym_plus = 514,
  sym_oplus = 515,
  sym_ominus = 516,
  sym_vertvert = 517,
  sym_minus = 518,
  sym_odot = 519,
  sym_oslash = 520,
  sym_otimes = 521,
  sym_bigcirc = 522,
  sym_bullet = 523,
  sym_div = 524,
  sym_circ = 525,
  sym_star = 526,
  sym_excl = 527,
  sym_qq = 528,
  sym_sqcap = 529,
  sym_sqcup = 530,
  sym_uplus = 531,
  sym_times = 532,
  sym_wr = 533,
  sym_cdot = 534,
  sym_infix_op_symbol = 535,
  sym_bound_infix_op = 536,
  sym_sup_plus = 537,
  sym_postfix_op_symbol = 538,
  sym_bound_postfix_op = 539,
  sym_assumption = 540,
  sym_theorem = 541,
  sym_assume_prove = 542,
  sym_inner_assume_prove = 543,
  sym_new = 544,
  sym_statement_level = 545,
  sym__proof = 546,
  sym_terminal_proof = 547,
  sym_non_terminal_proof = 548,
  sym_proof_step = 549,
  sym_definition_proof_step = 550,
  sym_have_proof_step = 551,
  sym_witness_proof_step = 552,
  sym_take_proof_step = 553,
  sym_suffices_proof_step = 554,
  sym_case_proof_step = 555,
  sym_pick_proof_step = 556,
  sym__bound_or_identifier_list = 557,
  sym_qed_step = 558,
  sym_use_or_hide = 559,
  sym_use_body = 560,
  sym_use_body_expr = 561,
  sym_use_body_def = 562,
  sym_module_ref = 563,
  sym_proof_step_id = 564,
  sym_proof_step_ref = 565,
  sym_pcal_algorithm = 566,
  sym__pcal_p_algorithm = 567,
  sym__pcal_c_algorithm = 568,
  sym_pcal_algorithm_start = 569,
  sym_fair = 570,
  sym_pcal_p_definitions = 571,
  sym_pcal_c_definitions = 572,
  sym_pcal_p_macro = 573,
  sym_pcal_c_macro = 574,
  sym_pcal_macro_decl = 575,
  sym_pcal_p_procedure = 576,
  sym_pcal_c_procedure = 577,
  sym_pcal_proc_decl = 578,
  sym_pcal_p_process = 579,
  sym_pcal_c_process = 580,
  sym_pcal_var_decls = 581,
  sym_pcal_var_decl = 582,
  sym_pcal_proc_var_decls = 583,
  sym_pcal_proc_var_decl = 584,
  sym_pcal_p_algorithm_body = 585,
  sym__pcal_p_stmts = 586,
  sym_pcal_c_algorithm_body = 587,
  sym__pcal_p_stmt = 588,
  sym__pcal_c_stmt = 589,
  sym__pcal_label = 590,
  sym__pcal_p_unlabeled_stmt = 591,
  sym__pcal_c_unlabeled_stmt = 592,
  sym_pcal_assign = 593,
  sym_pcal_lhs = 594,
  sym_pcal_p_if = 595,
  sym_pcal_c_if = 596,
  sym_pcal_p_while = 597,
  sym_pcal_c_while = 598,
  sym_pcal_p_either = 599,
  sym_pcal_c_either = 600,
  sym_pcal_p_with = 601,
  sym_pcal_c_with = 602,
  sym__pcal_with_vars = 603,
  sym_pcal_await = 604,
  sym_pcal_print = 605,
  sym_pcal_assert = 606,
  sym_pcal_goto = 607,
  sym_pcal_proc_call = 608,
  sym_pcal_macro_call = 609,
  aux_sym_source_file_repeat1 = 610,
  aux_sym_source_file_repeat2 = 611,
  aux_sym_block_comment_repeat1 = 612,
  aux_sym_block_comment_text_repeat1 = 613,
  aux_sym_extends_repeat1 = 614,
  aux_sym_variable_declaration_repeat1 = 615,
  aux_sym_constant_declaration_repeat1 = 616,
  aux_sym_operator_declaration_repeat1 = 617,
  aux_sym_function_definition_repeat1 = 618,
  aux_sym_instance_repeat1 = 619,
  aux_sym_subexpr_prefix_repeat1 = 620,
  aux_sym_bound_op_repeat1 = 621,
  aux_sym_string_repeat1 = 622,
  aux_sym_finite_set_literal_repeat1 = 623,
  aux_sym_record_literal_repeat1 = 624,
  aux_sym_set_of_records_repeat1 = 625,
  aux_sym_except_repeat1 = 626,
  aux_sym_except_update_specifier_repeat1 = 627,
  aux_sym_case_repeat1 = 628,
  aux_sym_let_in_repeat1 = 629,
  aux_sym_conj_list_repeat1 = 630,
  aux_sym_disj_list_repeat1 = 631,
  aux_sym_assume_prove_repeat1 = 632,
  aux_sym_non_terminal_proof_repeat1 = 633,
  aux_sym_definition_proof_step_repeat1 = 634,
  aux_sym_use_body_expr_repeat1 = 635,
  aux_sym_use_body_def_repeat1 = 636,
  aux_sym__pcal_p_algorithm_repeat1 = 637,
  aux_sym__pcal_p_algorithm_repeat2 = 638,
  aux_sym__pcal_p_algorithm_repeat3 = 639,
  aux_sym__pcal_c_algorithm_repeat1 = 640,
  aux_sym__pcal_c_algorithm_repeat2 = 641,
  aux_sym__pcal_c_algorithm_repeat3 = 642,
  aux_sym_pcal_p_definitions_repeat1 = 643,
  aux_sym_pcal_macro_decl_repeat1 = 644,
  aux_sym_pcal_proc_decl_repeat1 = 645,
  aux_sym_pcal_var_decls_repeat1 = 646,
  aux_sym_pcal_proc_var_decls_repeat1 = 647,
  aux_sym__pcal_p_stmts_repeat1 = 648,
  aux_sym_pcal_c_algorithm_body_repeat1 = 649,
  aux_sym_pcal_assign_repeat1 = 650,
  aux_sym_pcal_lhs_repeat1 = 651,
  aux_sym_pcal_p_if_repeat1 = 652,
  aux_sym_pcal_p_either_repeat1 = 653,
  aux_sym_pcal_c_either_repeat1 = 654,
  aux_sym__pcal_with_vars_repeat1 = 655,
  alias_sym_header_line = 656,
  alias_sym_identifier_ref = 657,
  alias_sym_pcal_end_either = 658,
  alias_sym_pcal_end_if = 659,
  alias_sym_pcal_end_while = 660,
  alias_sym_pcal_end_with = 661,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_comment] = "comment",
  [anon_sym_LPAREN_STAR] = "(*",
  [anon_sym_STAR_RPAREN] = "*)",
  [aux_sym_block_comment_text_token1] = "block_comment_text_token1",
  [aux_sym_block_comment_text_token2] = "block_comment_text_token2",
  [aux_sym_block_comment_text_token3] = "block_comment_text_token3",
  [aux_sym_block_comment_text_token4] = "block_comment_text_token4",
  [anon_sym_MODULE] = "MODULE",
  [anon_sym_DASH_DASH_DASH_DASH] = "----",
  [aux_sym_single_line_token1] = "single_line_token1",
  [anon_sym_EQ_EQ_EQ_EQ] = "====",
  [aux_sym_double_line_token1] = "double_line_token1",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_u225c] = "\u225c",
  [anon_sym_BSLASHin] = "\\in",
  [anon_sym_u2208] = "\u2208",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_u27f5] = "\u27f5",
  [anon_sym_u2190] = "\u2190",
  [anon_sym_BSLASHA] = "\\A",
  [anon_sym_BSLASHforall] = "\\forall",
  [anon_sym_u2200] = "\u2200",
  [anon_sym_BSLASHE] = "\\E",
  [anon_sym_BSLASHexists] = "\\exists",
  [anon_sym_u2203] = "\u2203",
  [sym_temporal_forall] = "temporal_forall",
  [sym_temporal_exists] = "temporal_exists",
  [anon_sym_PIPE_DASH_GT] = "|->",
  [anon_sym_u27fc] = "\u27fc",
  [anon_sym_u21a6] = "\u21a6",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_u27f6] = "\u27f6",
  [anon_sym_u2192] = "\u2192",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_u3008] = "\u3008",
  [anon_sym_u27e8] = "\u27e8",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_u3009] = "\u3009",
  [anon_sym_u27e9] = "\u27e9",
  [anon_sym_GT_GT_] = ">>_",
  [anon_sym_u3009_] = "\u3009_",
  [anon_sym_u27e9_] = "\u27e9_",
  [anon_sym_LBRACK_RBRACK] = "[]",
  [anon_sym_u25a1] = "\u25a1",
  [anon_sym_COLON] = ":",
  [anon_sym_AT] = "@",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_u2237] = "\u2237",
  [sym_placeholder] = "placeholder",
  [anon_sym_SLASH_BSLASH] = "/\\",
  [anon_sym_u2227] = "\u2227",
  [anon_sym_BSLASH_SLASH] = "\\/",
  [anon_sym_u2228] = "\u2228",
  [anon_sym_EXTENDS] = "EXTENDS",
  [anon_sym_COMMA] = ",",
  [anon_sym_LOCAL] = "LOCAL",
  [anon_sym_VARIABLE] = "VARIABLE",
  [anon_sym_VARIABLES] = "VARIABLES",
  [anon_sym_CONSTANT] = "CONSTANT",
  [anon_sym_CONSTANTS] = "CONSTANTS",
  [anon_sym_RECURSIVE] = "RECURSIVE",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_INSTANCE] = "INSTANCE",
  [anon_sym_WITH] = "WITH",
  [anon_sym_BANG] = "!",
  [aux_sym_child_id_token1] = "child_id_token1",
  [anon_sym_LAMBDA] = "LAMBDA",
  [sym_real_number] = "real_number",
  [anon_sym_BSLASHb] = "format",
  [anon_sym_BSLASHB] = "format",
  [aux_sym_binary_number_token1] = "value",
  [anon_sym_BSLASHo] = "\\o",
  [anon_sym_BSLASHO] = "format",
  [aux_sym_octal_number_token1] = "value",
  [anon_sym_BSLASHh] = "format",
  [anon_sym_BSLASHH] = "format",
  [aux_sym_hex_number_token1] = "value",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token1] = "string_token1",
  [anon_sym_DQUOTE2] = "\"",
  [sym_escape_char] = "escape_char",
  [anon_sym_TRUE] = "TRUE",
  [anon_sym_FALSE] = "FALSE",
  [sym_string_set] = "string_set",
  [sym_boolean_set] = "boolean_set",
  [anon_sym_Nat] = "Nat",
  [anon_sym_u2115] = "\u2115",
  [anon_sym_Int] = "Int",
  [anon_sym_u2124] = "\u2124",
  [anon_sym_Real] = "Real",
  [anon_sym_u211d] = "\u211d",
  [anon_sym_CHOOSE] = "CHOOSE",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_DOT] = ".",
  [anon_sym_EXCEPT] = "EXCEPT",
  [anon_sym_EQ] = "=",
  [anon_sym_RBRACK_] = "]_",
  [anon_sym_WF_] = "WF_",
  [anon_sym_SF_] = "SF_",
  [anon_sym_IF] = "IF",
  [anon_sym_THEN] = "THEN",
  [anon_sym_ELSE] = "ELSE",
  [anon_sym_CASE] = "CASE",
  [anon_sym_OTHER] = "OTHER",
  [anon_sym_LET] = "LET",
  [anon_sym_IN] = "IN",
  [anon_sym_BSLASHlnot] = "\\lnot",
  [anon_sym_BSLASHneg] = "\\neg",
  [anon_sym_TILDE] = "~",
  [anon_sym_u00ac] = "\u00ac",
  [sym_union] = "union",
  [sym_powerset] = "powerset",
  [sym_domain] = "domain",
  [anon_sym_DASH] = "-",
  [sym_negative_dot] = "negative",
  [sym_enabled] = "enabled",
  [sym_unchanged] = "unchanged",
  [anon_sym_LT_GT] = "<>",
  [anon_sym_u22c4] = "\u22c4",
  [anon_sym_u25c7] = "\u25c7",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_u27f9] = "\u27f9",
  [anon_sym_u21d2] = "\u21d2",
  [anon_sym_DASH_PLUS_DASH_GT] = "-+->",
  [anon_sym_u21f8] = "\u21f8",
  [anon_sym_u2945] = "\u2945",
  [anon_sym_BSLASHequiv] = "\\equiv",
  [anon_sym_u2261] = "\u2261",
  [anon_sym_LT_EQ_GT] = "<=>",
  [anon_sym_u27fa] = "\u27fa",
  [anon_sym_u21d4] = "\u21d4",
  [anon_sym_TILDE_GT] = "~>",
  [anon_sym_u21dd] = "\u21dd",
  [anon_sym_u219d] = "\u219d",
  [anon_sym_BSLASHland] = "\\land",
  [anon_sym_BSLASHlor] = "\\lor",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_u2254] = "\u2254",
  [anon_sym_COLON_COLON_EQ] = "::=",
  [anon_sym_u2a74] = "\u2a74",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_POUND] = "#",
  [anon_sym_u2260] = "\u2260",
  [anon_sym_LT] = "<",
  [sym_gt] = "gt",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_LT] = "=<",
  [anon_sym_BSLASHleq] = "\\leq",
  [anon_sym_u2264] = "\u2264",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_BSLASHgeq] = "\\geq",
  [anon_sym_u2265] = "\u2265",
  [anon_sym_BSLASHapprox] = "\\approx",
  [anon_sym_u2248] = "\u2248",
  [anon_sym_PIPE_DASH] = "|-",
  [anon_sym_u22a2] = "\u22a2",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_u22a8] = "\u22a8",
  [anon_sym_DASH_PIPE] = "-|",
  [anon_sym_u22a3] = "\u22a3",
  [anon_sym_EQ_PIPE] = "=|",
  [anon_sym_u2ae4] = "\u2ae4",
  [anon_sym_BSLASHasymp] = "\\asymp",
  [anon_sym_u224d] = "\u224d",
  [anon_sym_BSLASHcong] = "\\cong",
  [anon_sym_u2245] = "\u2245",
  [anon_sym_BSLASHdoteq] = "\\doteq",
  [anon_sym_u2250] = "\u2250",
  [anon_sym_BSLASHgg] = "\\gg",
  [anon_sym_u226b] = "\u226b",
  [anon_sym_BSLASHll] = "\\ll",
  [anon_sym_u226a] = "\u226a",
  [anon_sym_BSLASHnotin] = "\\notin",
  [anon_sym_u2209] = "\u2209",
  [anon_sym_BSLASHprec] = "\\prec",
  [anon_sym_u227a] = "\u227a",
  [anon_sym_BSLASHsucc] = "\\succ",
  [anon_sym_u227b] = "\u227b",
  [anon_sym_BSLASHpreceq] = "\\preceq",
  [anon_sym_u2aaf] = "\u2aaf",
  [anon_sym_BSLASHsucceq] = "\\succeq",
  [anon_sym_u2ab0] = "\u2ab0",
  [anon_sym_BSLASHpropto] = "\\propto",
  [anon_sym_u221d] = "\u221d",
  [anon_sym_BSLASHsim] = "\\sim",
  [anon_sym_u223c] = "\u223c",
  [anon_sym_BSLASHsimeq] = "\\simeq",
  [anon_sym_u2243] = "\u2243",
  [anon_sym_BSLASHsqsubset] = "\\sqsubset",
  [anon_sym_u228f] = "\u228f",
  [anon_sym_BSLASHsqsupset] = "\\sqsupset",
  [anon_sym_u2290] = "\u2290",
  [anon_sym_BSLASHsqsubseteq] = "\\sqsubseteq",
  [anon_sym_u2291] = "\u2291",
  [anon_sym_BSLASHsqsupseteq] = "\\sqsupseteq",
  [anon_sym_u2292] = "\u2292",
  [anon_sym_BSLASHsubset] = "\\subset",
  [anon_sym_u2282] = "\u2282",
  [anon_sym_BSLASHsupset] = "\\supset",
  [anon_sym_u2283] = "\u2283",
  [anon_sym_BSLASHsubseteq] = "\\subseteq",
  [anon_sym_u2286] = "\u2286",
  [anon_sym_BSLASHsupseteq] = "\\supseteq",
  [anon_sym_u2287] = "\u2287",
  [sym_compose] = "compose",
  [sym_map_to] = "map_to",
  [sym_map_from] = "map_from",
  [sym_setminus] = "setminus",
  [anon_sym_BSLASHcap] = "\\cap",
  [anon_sym_BSLASHintersect] = "\\intersect",
  [anon_sym_u2229] = "\u2229",
  [anon_sym_BSLASHcup] = "\\cup",
  [anon_sym_BSLASHunion] = "\\union",
  [anon_sym_u222a] = "\u222a",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_u2025] = "\u2025",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_u2026] = "\u2026",
  [anon_sym_PLUS] = "+",
  [sym_plusplus] = "plusplus",
  [anon_sym_BSLASHoplus] = "\\oplus",
  [anon_sym_LPAREN_PLUS_RPAREN] = "(+)",
  [anon_sym_u2295] = "\u2295",
  [anon_sym_BSLASHominus] = "\\ominus",
  [anon_sym_LPAREN_DASH_RPAREN] = "(-)",
  [anon_sym_u2296] = "\u2296",
  [sym_mod] = "mod",
  [sym_modmod] = "modmod",
  [sym_vert] = "vert",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_u2016] = "\u2016",
  [sym_minusminus] = "minusminus",
  [sym_amp] = "amp",
  [sym_ampamp] = "ampamp",
  [anon_sym_BSLASHodot] = "\\odot",
  [anon_sym_LPAREN_DOT_RPAREN] = "(.)",
  [anon_sym_u2299] = "\u2299",
  [anon_sym_BSLASHoslash] = "\\oslash",
  [anon_sym_LPAREN_SLASH_RPAREN] = "(/)",
  [anon_sym_u2298] = "\u2298",
  [anon_sym_BSLASHotimes] = "\\otimes",
  [anon_sym_LPAREN_BSLASHX_RPAREN] = "(\\X)",
  [anon_sym_u2297] = "\u2297",
  [sym_mul] = "mul",
  [sym_mulmul] = "mulmul",
  [sym_slash] = "slash",
  [sym_slashslash] = "slashslash",
  [anon_sym_BSLASHbigcirc] = "\\bigcirc",
  [anon_sym_u25ef] = "\u25ef",
  [anon_sym_BSLASHbullet] = "\\bullet",
  [anon_sym_u25cf] = "\u25cf",
  [anon_sym_BSLASHdiv] = "\\div",
  [anon_sym_u00f7] = "\u00f7",
  [anon_sym_BSLASHcirc] = "\\circ",
  [anon_sym_u2218] = "\u2218",
  [anon_sym_BSLASHstar] = "\\star",
  [anon_sym_u22c6] = "\u22c6",
  [anon_sym_u203c] = "\u203c",
  [sym_hashhash] = "hashhash",
  [sym_dol] = "dol",
  [sym_doldol] = "doldol",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [anon_sym_u2047] = "\u2047",
  [anon_sym_BSLASHsqcap] = "\\sqcap",
  [anon_sym_u2293] = "\u2293",
  [anon_sym_BSLASHsqcup] = "\\sqcup",
  [anon_sym_u2294] = "\u2294",
  [anon_sym_BSLASHuplus] = "\\uplus",
  [anon_sym_u228e] = "\u228e",
  [anon_sym_BSLASHX] = "\\X",
  [anon_sym_BSLASHtimes] = "\\times",
  [anon_sym_u00d7] = "\u00d7",
  [anon_sym_BSLASHwr] = "\\wr",
  [anon_sym_u2240] = "\u2240",
  [anon_sym_BSLASHcdot] = "\\cdot",
  [anon_sym_u22c5] = "\u22c5",
  [sym_pow] = "pow",
  [sym_powpow] = "powpow",
  [anon_sym_CARET_PLUS] = "^+",
  [anon_sym_u207a] = "\u207a",
  [sym_asterisk] = "asterisk",
  [sym_sup_hash] = "sup_hash",
  [sym_prime] = "prime",
  [anon_sym_ASSUME] = "ASSUME",
  [anon_sym_ASSUMPTION] = "ASSUMPTION",
  [anon_sym_AXIOM] = "AXIOM",
  [anon_sym_THEOREM] = "THEOREM",
  [anon_sym_PROPOSITION] = "PROPOSITION",
  [anon_sym_LEMMA] = "LEMMA",
  [anon_sym_COROLLARY] = "COROLLARY",
  [anon_sym_PROVE] = "PROVE",
  [anon_sym_NEW] = "NEW",
  [anon_sym_STATE] = "STATE",
  [anon_sym_ACTION] = "ACTION",
  [anon_sym_TEMPORAL] = "TEMPORAL",
  [anon_sym_PROOF] = "PROOF",
  [anon_sym_BY] = "BY",
  [anon_sym_ONLY] = "ONLY",
  [anon_sym_OBVIOUS] = "OBVIOUS",
  [anon_sym_OMITTED] = "OMITTED",
  [anon_sym_DEFINE] = "DEFINE",
  [anon_sym_HAVE] = "HAVE",
  [anon_sym_WITNESS] = "WITNESS",
  [anon_sym_TAKE] = "TAKE",
  [anon_sym_SUFFICES] = "SUFFICES",
  [anon_sym_PICK] = "PICK",
  [anon_sym_QED] = "QED",
  [anon_sym_USE] = "USE",
  [anon_sym_HIDE] = "HIDE",
  [anon_sym_DEF] = "DEF",
  [anon_sym_DEFS] = "DEFS",
  [aux_sym_proof_step_id_token1] = "level",
  [anon_sym_GT] = ">",
  [aux_sym_proof_step_id_token2] = "name",
  [aux_sym_proof_step_id_token3] = "proof_step_id_token3",
  [aux_sym_proof_step_ref_token1] = "level",
  [aux_sym_proof_step_ref_token2] = "name",
  [anon_sym_end] = "end",
  [anon_sym_algorithm] = "algorithm",
  [anon_sym_SEMI] = ";",
  [anon_sym_DASH_DASHalgorithm] = "--algorithm",
  [anon_sym_DASH_DASHfair] = "--fair",
  [anon_sym_define] = "define",
  [anon_sym_macro] = "macro",
  [anon_sym_procedure] = "procedure",
  [anon_sym_fair] = "fair",
  [anon_sym_process] = "process",
  [anon_sym_variable] = "variable",
  [anon_sym_variables] = "variables",
  [anon_sym_begin] = "begin",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_elsif] = "elsif",
  [anon_sym_else] = "else",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_either] = "either",
  [anon_sym_or] = "or",
  [anon_sym_with] = "with",
  [anon_sym_await] = "await",
  [anon_sym_when] = "when",
  [anon_sym_print] = "print",
  [anon_sym_assert] = "assert",
  [sym_pcal_skip] = "pcal_skip",
  [sym_pcal_return] = "pcal_return",
  [anon_sym_goto] = "goto",
  [anon_sym_call] = "call",
  [sym_leading_extramodular_text] = "extramodular_text",
  [sym_trailing_extramodular_text] = "extramodular_text",
  [sym__indent] = "_indent",
  [sym__bullet] = "_bullet",
  [sym__dedent] = "_dedent",
  [sym__begin_proof] = "_begin_proof",
  [sym__begin_proof_step] = "_begin_proof_step",
  [sym__notify_pcal_algorithm_start] = "_notify_pcal_algorithm_start",
  [sym__notify_pcal_algorithm_end] = "_notify_pcal_algorithm_end",
  [sym__double_excl] = "!!",
  [sym__error_sentinel] = "_error_sentinel",
  [sym_source_file] = "source_file",
  [sym_block_comment] = "block_comment",
  [sym_block_comment_text] = "block_comment_text",
  [sym_module] = "module",
  [sym_single_line] = "single_line",
  [sym_double_line] = "double_line",
  [sym_def_eq] = "def_eq",
  [sym_set_in] = "set_in",
  [sym_gets] = "gets",
  [sym_forall] = "forall",
  [sym_exists] = "exists",
  [sym_all_map_to] = "all_map_to",
  [sym_maps_to] = "maps_to",
  [sym_langle_bracket] = "langle_bracket",
  [sym_rangle_bracket] = "rangle_bracket",
  [sym_rangle_bracket_sub] = "rangle_bracket_sub",
  [sym_case_box] = "case_box",
  [sym_case_arrow] = "case_arrow",
  [sym_colon] = "colon",
  [sym_address] = "address",
  [sym_label_as] = "label_as",
  [sym_bullet_conj] = "bullet_conj",
  [sym_bullet_disj] = "bullet_disj",
  [sym_extends] = "extends",
  [sym__unit] = "_unit",
  [sym_local_definition] = "local_definition",
  [sym__definition] = "_definition",
  [sym_variable_declaration] = "variable_declaration",
  [sym_constant_declaration] = "constant_declaration",
  [sym_recursive_declaration] = "recursive_declaration",
  [sym_operator_declaration] = "operator_declaration",
  [sym__id_or_op_declaration] = "_id_or_op_declaration",
  [sym_operator_definition] = "operator_definition",
  [sym_function_definition] = "function_definition",
  [sym_instance] = "instance",
  [sym_substitution] = "substitution",
  [sym__op_or_expr] = "_op_or_expr",
  [sym__op] = "_op",
  [sym_subexpr_prefix] = "subexpr_prefix",
  [sym_subexpr_component] = "subexpr_component",
  [sym_bound_op] = "bound_op",
  [sym_bound_nonfix_op] = "bound_nonfix_op",
  [sym_subexpr_tree_nav] = "subexpr_tree_nav",
  [sym_child_id] = "child_id",
  [sym_operator_args] = "operator_args",
  [sym_lambda] = "lambda",
  [sym_module_definition] = "module_definition",
  [sym__expr] = "_expr",
  [sym__subscript_expr] = "_subscript_expr",
  [sym_prefixed_op] = "prefixed_op",
  [sym__number] = "_number",
  [sym_nat_number] = "nat_number",
  [sym_binary_number] = "binary_number",
  [sym_octal_number] = "octal_number",
  [sym_hex_number] = "hex_number",
  [sym_string] = "string",
  [sym_boolean] = "boolean",
  [sym__number_set] = "_number_set",
  [sym__primitive_value_set] = "_primitive_value_set",
  [sym_nat_number_set] = "nat_number_set",
  [sym_int_number_set] = "int_number_set",
  [sym_real_number_set] = "real_number_set",
  [sym_label] = "label",
  [sym_subexpression] = "subexpression",
  [sym_parentheses] = "parentheses",
  [sym_bounded_quantification] = "bounded_quantification",
  [sym_unbounded_quantification] = "unbounded_quantification",
  [sym_choose] = "choose",
  [sym_finite_set_literal] = "finite_set_literal",
  [sym_set_filter] = "set_filter",
  [sym_set_map] = "set_map",
  [sym_quantifier_bound] = "quantifier_bound",
  [sym_restricted_quantifier_bound] = "quantifier_bound",
  [sym_tuple_of_identifiers] = "tuple_of_identifiers",
  [sym_function_evaluation] = "function_evaluation",
  [sym_function_literal] = "function_literal",
  [sym_set_of_functions] = "set_of_functions",
  [sym_record_literal] = "record_literal",
  [sym_set_of_records] = "set_of_records",
  [sym_record_value] = "record_value",
  [sym_except] = "except",
  [sym_except_update] = "except_update",
  [sym_except_update_specifier] = "except_update_specifier",
  [sym_except_update_record_field] = "except_update_record_field",
  [sym_except_update_fn_appl] = "except_update_fn_appl",
  [sym_prev_func_val] = "prev_func_val",
  [sym_tuple_literal] = "tuple_literal",
  [sym_step_expr_or_stutter] = "step_expr_or_stutter",
  [sym_step_expr_no_stutter] = "step_expr_no_stutter",
  [sym_fairness] = "fairness",
  [sym_if_then_else] = "if_then_else",
  [sym_case] = "case",
  [sym_case_arm] = "case_arm",
  [sym_other_arm] = "other_arm",
  [sym_let_in] = "let_in",
  [sym_conj_list] = "conj_list",
  [sym_conj_item] = "conj_item",
  [sym_disj_list] = "disj_list",
  [sym_disj_item] = "disj_item",
  [sym_lnot] = "lnot",
  [sym_negative] = "negative",
  [sym_always] = "always",
  [sym_eventually] = "eventually",
  [sym_prefix_op_symbol] = "prefix_op_symbol",
  [sym_bound_prefix_op] = "bound_prefix_op",
  [sym_implies] = "implies",
  [sym_plus_arrow] = "plus_arrow",
  [sym_equiv] = "equiv",
  [sym_iff] = "iff",
  [sym_leads_to] = "leads_to",
  [sym_land] = "land",
  [sym_lor] = "lor",
  [sym_assign] = "assign",
  [sym_bnf_rule] = "bnf_rule",
  [sym_eq] = "eq",
  [sym_neq] = "neq",
  [sym_lt] = "lt",
  [sym_leq] = "leq",
  [sym_geq] = "geq",
  [sym_approx] = "approx",
  [sym_rs_ttile] = "rs_ttile",
  [sym_rd_ttile] = "rd_ttile",
  [sym_ls_ttile] = "ls_ttile",
  [sym_ld_ttile] = "ld_ttile",
  [sym_asymp] = "asymp",
  [sym_cong] = "cong",
  [sym_doteq] = "doteq",
  [sym_gg] = "gg",
  [sym_ll] = "ll",
  [sym_in] = "in",
  [sym_notin] = "notin",
  [sym_prec] = "prec",
  [sym_succ] = "succ",
  [sym_preceq] = "preceq",
  [sym_succeq] = "succeq",
  [sym_propto] = "propto",
  [sym_sim] = "sim",
  [sym_simeq] = "simeq",
  [sym_sqsubset] = "sqsubset",
  [sym_sqsupset] = "sqsupset",
  [sym_sqsubseteq] = "sqsubseteq",
  [sym_sqsupseteq] = "sqsupseteq",
  [sym_subset] = "subset",
  [sym_supset] = "supset",
  [sym_subseteq] = "subseteq",
  [sym_supseteq] = "supseteq",
  [sym_cap] = "cap",
  [sym_cup] = "cup",
  [sym_dots_2] = "dots_2",
  [sym_dots_3] = "dots_3",
  [sym_plus] = "plus",
  [sym_oplus] = "oplus",
  [sym_ominus] = "ominus",
  [sym_vertvert] = "vertvert",
  [sym_minus] = "minus",
  [sym_odot] = "odot",
  [sym_oslash] = "oslash",
  [sym_otimes] = "otimes",
  [sym_bigcirc] = "bigcirc",
  [sym_bullet] = "bullet",
  [sym_div] = "div",
  [sym_circ] = "circ",
  [sym_star] = "star",
  [sym_excl] = "excl",
  [sym_qq] = "qq",
  [sym_sqcap] = "sqcap",
  [sym_sqcup] = "sqcup",
  [sym_uplus] = "uplus",
  [sym_times] = "times",
  [sym_wr] = "wr",
  [sym_cdot] = "cdot",
  [sym_infix_op_symbol] = "infix_op_symbol",
  [sym_bound_infix_op] = "bound_infix_op",
  [sym_sup_plus] = "sup_plus",
  [sym_postfix_op_symbol] = "postfix_op_symbol",
  [sym_bound_postfix_op] = "bound_postfix_op",
  [sym_assumption] = "assumption",
  [sym_theorem] = "theorem",
  [sym_assume_prove] = "assume_prove",
  [sym_inner_assume_prove] = "inner_assume_prove",
  [sym_new] = "new",
  [sym_statement_level] = "statement_level",
  [sym__proof] = "_proof",
  [sym_terminal_proof] = "terminal_proof",
  [sym_non_terminal_proof] = "non_terminal_proof",
  [sym_proof_step] = "proof_step",
  [sym_definition_proof_step] = "definition_proof_step",
  [sym_have_proof_step] = "have_proof_step",
  [sym_witness_proof_step] = "witness_proof_step",
  [sym_take_proof_step] = "take_proof_step",
  [sym_suffices_proof_step] = "suffices_proof_step",
  [sym_case_proof_step] = "case_proof_step",
  [sym_pick_proof_step] = "pick_proof_step",
  [sym__bound_or_identifier_list] = "_bound_or_identifier_list",
  [sym_qed_step] = "qed_step",
  [sym_use_or_hide] = "use_or_hide",
  [sym_use_body] = "use_body",
  [sym_use_body_expr] = "use_body_expr",
  [sym_use_body_def] = "use_body_def",
  [sym_module_ref] = "module_ref",
  [sym_proof_step_id] = "proof_step_id",
  [sym_proof_step_ref] = "proof_step_ref",
  [sym_pcal_algorithm] = "pcal_algorithm",
  [sym__pcal_p_algorithm] = "_pcal_p_algorithm",
  [sym__pcal_c_algorithm] = "_pcal_c_algorithm",
  [sym_pcal_algorithm_start] = "pcal_algorithm_start",
  [sym_fair] = "fair",
  [sym_pcal_p_definitions] = "pcal_definitions",
  [sym_pcal_c_definitions] = "pcal_definitions",
  [sym_pcal_p_macro] = "pcal_macro",
  [sym_pcal_c_macro] = "pcal_macro",
  [sym_pcal_macro_decl] = "pcal_macro_decl",
  [sym_pcal_p_procedure] = "pcal_procedure",
  [sym_pcal_c_procedure] = "pcal_procedure",
  [sym_pcal_proc_decl] = "pcal_proc_decl",
  [sym_pcal_p_process] = "pcal_process",
  [sym_pcal_c_process] = "pcal_process",
  [sym_pcal_var_decls] = "pcal_var_decls",
  [sym_pcal_var_decl] = "pcal_var_decl",
  [sym_pcal_proc_var_decls] = "pcal_proc_var_decls",
  [sym_pcal_proc_var_decl] = "pcal_proc_var_decl",
  [sym_pcal_p_algorithm_body] = "pcal_algorithm_body",
  [sym__pcal_p_stmts] = "_pcal_p_stmts",
  [sym_pcal_c_algorithm_body] = "pcal_algorithm_body",
  [sym__pcal_p_stmt] = "_pcal_p_stmt",
  [sym__pcal_c_stmt] = "_pcal_c_stmt",
  [sym__pcal_label] = "_pcal_label",
  [sym__pcal_p_unlabeled_stmt] = "_pcal_p_unlabeled_stmt",
  [sym__pcal_c_unlabeled_stmt] = "_pcal_c_unlabeled_stmt",
  [sym_pcal_assign] = "pcal_assign",
  [sym_pcal_lhs] = "pcal_lhs",
  [sym_pcal_p_if] = "pcal_if",
  [sym_pcal_c_if] = "pcal_if",
  [sym_pcal_p_while] = "pcal_while",
  [sym_pcal_c_while] = "pcal_while",
  [sym_pcal_p_either] = "pcal_either",
  [sym_pcal_c_either] = "pcal_either",
  [sym_pcal_p_with] = "pcal_with",
  [sym_pcal_c_with] = "pcal_with",
  [sym__pcal_with_vars] = "_pcal_with_vars",
  [sym_pcal_await] = "pcal_await",
  [sym_pcal_print] = "pcal_print",
  [sym_pcal_assert] = "pcal_assert",
  [sym_pcal_goto] = "pcal_goto",
  [sym_pcal_proc_call] = "pcal_proc_call",
  [sym_pcal_macro_call] = "pcal_macro_call",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_source_file_repeat2] = "source_file_repeat2",
  [aux_sym_block_comment_repeat1] = "block_comment_repeat1",
  [aux_sym_block_comment_text_repeat1] = "block_comment_text_repeat1",
  [aux_sym_extends_repeat1] = "extends_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_constant_declaration_repeat1] = "constant_declaration_repeat1",
  [aux_sym_operator_declaration_repeat1] = "operator_declaration_repeat1",
  [aux_sym_function_definition_repeat1] = "function_definition_repeat1",
  [aux_sym_instance_repeat1] = "instance_repeat1",
  [aux_sym_subexpr_prefix_repeat1] = "subexpr_prefix_repeat1",
  [aux_sym_bound_op_repeat1] = "bound_op_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_finite_set_literal_repeat1] = "finite_set_literal_repeat1",
  [aux_sym_record_literal_repeat1] = "record_literal_repeat1",
  [aux_sym_set_of_records_repeat1] = "set_of_records_repeat1",
  [aux_sym_except_repeat1] = "except_repeat1",
  [aux_sym_except_update_specifier_repeat1] = "except_update_specifier_repeat1",
  [aux_sym_case_repeat1] = "case_repeat1",
  [aux_sym_let_in_repeat1] = "let_in_repeat1",
  [aux_sym_conj_list_repeat1] = "conj_list_repeat1",
  [aux_sym_disj_list_repeat1] = "disj_list_repeat1",
  [aux_sym_assume_prove_repeat1] = "assume_prove_repeat1",
  [aux_sym_non_terminal_proof_repeat1] = "non_terminal_proof_repeat1",
  [aux_sym_definition_proof_step_repeat1] = "definition_proof_step_repeat1",
  [aux_sym_use_body_expr_repeat1] = "use_body_expr_repeat1",
  [aux_sym_use_body_def_repeat1] = "use_body_def_repeat1",
  [aux_sym__pcal_p_algorithm_repeat1] = "_pcal_p_algorithm_repeat1",
  [aux_sym__pcal_p_algorithm_repeat2] = "_pcal_p_algorithm_repeat2",
  [aux_sym__pcal_p_algorithm_repeat3] = "_pcal_p_algorithm_repeat3",
  [aux_sym__pcal_c_algorithm_repeat1] = "_pcal_c_algorithm_repeat1",
  [aux_sym__pcal_c_algorithm_repeat2] = "_pcal_c_algorithm_repeat2",
  [aux_sym__pcal_c_algorithm_repeat3] = "_pcal_c_algorithm_repeat3",
  [aux_sym_pcal_p_definitions_repeat1] = "pcal_p_definitions_repeat1",
  [aux_sym_pcal_macro_decl_repeat1] = "pcal_macro_decl_repeat1",
  [aux_sym_pcal_proc_decl_repeat1] = "pcal_proc_decl_repeat1",
  [aux_sym_pcal_var_decls_repeat1] = "pcal_var_decls_repeat1",
  [aux_sym_pcal_proc_var_decls_repeat1] = "pcal_proc_var_decls_repeat1",
  [aux_sym__pcal_p_stmts_repeat1] = "_pcal_p_stmts_repeat1",
  [aux_sym_pcal_c_algorithm_body_repeat1] = "pcal_c_algorithm_body_repeat1",
  [aux_sym_pcal_assign_repeat1] = "pcal_assign_repeat1",
  [aux_sym_pcal_lhs_repeat1] = "pcal_lhs_repeat1",
  [aux_sym_pcal_p_if_repeat1] = "pcal_p_if_repeat1",
  [aux_sym_pcal_p_either_repeat1] = "pcal_p_either_repeat1",
  [aux_sym_pcal_c_either_repeat1] = "pcal_c_either_repeat1",
  [aux_sym__pcal_with_vars_repeat1] = "_pcal_with_vars_repeat1",
  [alias_sym_header_line] = "header_line",
  [alias_sym_identifier_ref] = "identifier_ref",
  [alias_sym_pcal_end_either] = "pcal_end_either",
  [alias_sym_pcal_end_if] = "pcal_end_if",
  [alias_sym_pcal_end_while] = "pcal_end_while",
  [alias_sym_pcal_end_with] = "pcal_end_with",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_comment] = sym_comment,
  [anon_sym_LPAREN_STAR] = anon_sym_LPAREN_STAR,
  [anon_sym_STAR_RPAREN] = anon_sym_STAR_RPAREN,
  [aux_sym_block_comment_text_token1] = aux_sym_block_comment_text_token1,
  [aux_sym_block_comment_text_token2] = aux_sym_block_comment_text_token2,
  [aux_sym_block_comment_text_token3] = aux_sym_block_comment_text_token3,
  [aux_sym_block_comment_text_token4] = aux_sym_block_comment_text_token4,
  [anon_sym_MODULE] = anon_sym_MODULE,
  [anon_sym_DASH_DASH_DASH_DASH] = anon_sym_DASH_DASH_DASH_DASH,
  [aux_sym_single_line_token1] = aux_sym_single_line_token1,
  [anon_sym_EQ_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ_EQ,
  [aux_sym_double_line_token1] = aux_sym_double_line_token1,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_u225c] = anon_sym_u225c,
  [anon_sym_BSLASHin] = anon_sym_BSLASHin,
  [anon_sym_u2208] = anon_sym_u2208,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_u27f5] = anon_sym_u27f5,
  [anon_sym_u2190] = anon_sym_u2190,
  [anon_sym_BSLASHA] = anon_sym_BSLASHA,
  [anon_sym_BSLASHforall] = anon_sym_BSLASHforall,
  [anon_sym_u2200] = anon_sym_u2200,
  [anon_sym_BSLASHE] = anon_sym_BSLASHE,
  [anon_sym_BSLASHexists] = anon_sym_BSLASHexists,
  [anon_sym_u2203] = anon_sym_u2203,
  [sym_temporal_forall] = sym_temporal_forall,
  [sym_temporal_exists] = sym_temporal_exists,
  [anon_sym_PIPE_DASH_GT] = anon_sym_PIPE_DASH_GT,
  [anon_sym_u27fc] = anon_sym_u27fc,
  [anon_sym_u21a6] = anon_sym_u21a6,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_u27f6] = anon_sym_u27f6,
  [anon_sym_u2192] = anon_sym_u2192,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_u3008] = anon_sym_u3008,
  [anon_sym_u27e8] = anon_sym_u27e8,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_u3009] = anon_sym_u3009,
  [anon_sym_u27e9] = anon_sym_u27e9,
  [anon_sym_GT_GT_] = anon_sym_GT_GT_,
  [anon_sym_u3009_] = anon_sym_u3009_,
  [anon_sym_u27e9_] = anon_sym_u27e9_,
  [anon_sym_LBRACK_RBRACK] = anon_sym_LBRACK_RBRACK,
  [anon_sym_u25a1] = anon_sym_u25a1,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_u2237] = anon_sym_u2237,
  [sym_placeholder] = sym_placeholder,
  [anon_sym_SLASH_BSLASH] = anon_sym_SLASH_BSLASH,
  [anon_sym_u2227] = anon_sym_u2227,
  [anon_sym_BSLASH_SLASH] = anon_sym_BSLASH_SLASH,
  [anon_sym_u2228] = anon_sym_u2228,
  [anon_sym_EXTENDS] = anon_sym_EXTENDS,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_LOCAL] = anon_sym_LOCAL,
  [anon_sym_VARIABLE] = anon_sym_VARIABLE,
  [anon_sym_VARIABLES] = anon_sym_VARIABLES,
  [anon_sym_CONSTANT] = anon_sym_CONSTANT,
  [anon_sym_CONSTANTS] = anon_sym_CONSTANTS,
  [anon_sym_RECURSIVE] = anon_sym_RECURSIVE,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_INSTANCE] = anon_sym_INSTANCE,
  [anon_sym_WITH] = anon_sym_WITH,
  [anon_sym_BANG] = anon_sym_BANG,
  [aux_sym_child_id_token1] = aux_sym_child_id_token1,
  [anon_sym_LAMBDA] = anon_sym_LAMBDA,
  [sym_real_number] = sym_real_number,
  [anon_sym_BSLASHb] = anon_sym_BSLASHb,
  [anon_sym_BSLASHB] = anon_sym_BSLASHb,
  [aux_sym_binary_number_token1] = aux_sym_binary_number_token1,
  [anon_sym_BSLASHo] = anon_sym_BSLASHo,
  [anon_sym_BSLASHO] = anon_sym_BSLASHb,
  [aux_sym_octal_number_token1] = aux_sym_binary_number_token1,
  [anon_sym_BSLASHh] = anon_sym_BSLASHb,
  [anon_sym_BSLASHH] = anon_sym_BSLASHb,
  [aux_sym_hex_number_token1] = aux_sym_binary_number_token1,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [anon_sym_DQUOTE2] = anon_sym_DQUOTE,
  [sym_escape_char] = sym_escape_char,
  [anon_sym_TRUE] = anon_sym_TRUE,
  [anon_sym_FALSE] = anon_sym_FALSE,
  [sym_string_set] = sym_string_set,
  [sym_boolean_set] = sym_boolean_set,
  [anon_sym_Nat] = anon_sym_Nat,
  [anon_sym_u2115] = anon_sym_u2115,
  [anon_sym_Int] = anon_sym_Int,
  [anon_sym_u2124] = anon_sym_u2124,
  [anon_sym_Real] = anon_sym_Real,
  [anon_sym_u211d] = anon_sym_u211d,
  [anon_sym_CHOOSE] = anon_sym_CHOOSE,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_EXCEPT] = anon_sym_EXCEPT,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_RBRACK_] = anon_sym_RBRACK_,
  [anon_sym_WF_] = anon_sym_WF_,
  [anon_sym_SF_] = anon_sym_SF_,
  [anon_sym_IF] = anon_sym_IF,
  [anon_sym_THEN] = anon_sym_THEN,
  [anon_sym_ELSE] = anon_sym_ELSE,
  [anon_sym_CASE] = anon_sym_CASE,
  [anon_sym_OTHER] = anon_sym_OTHER,
  [anon_sym_LET] = anon_sym_LET,
  [anon_sym_IN] = anon_sym_IN,
  [anon_sym_BSLASHlnot] = anon_sym_BSLASHlnot,
  [anon_sym_BSLASHneg] = anon_sym_BSLASHneg,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_u00ac] = anon_sym_u00ac,
  [sym_union] = sym_union,
  [sym_powerset] = sym_powerset,
  [sym_domain] = sym_domain,
  [anon_sym_DASH] = anon_sym_DASH,
  [sym_negative_dot] = sym_negative,
  [sym_enabled] = sym_enabled,
  [sym_unchanged] = sym_unchanged,
  [anon_sym_LT_GT] = anon_sym_LT_GT,
  [anon_sym_u22c4] = anon_sym_u22c4,
  [anon_sym_u25c7] = anon_sym_u25c7,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_u27f9] = anon_sym_u27f9,
  [anon_sym_u21d2] = anon_sym_u21d2,
  [anon_sym_DASH_PLUS_DASH_GT] = anon_sym_DASH_PLUS_DASH_GT,
  [anon_sym_u21f8] = anon_sym_u21f8,
  [anon_sym_u2945] = anon_sym_u2945,
  [anon_sym_BSLASHequiv] = anon_sym_BSLASHequiv,
  [anon_sym_u2261] = anon_sym_u2261,
  [anon_sym_LT_EQ_GT] = anon_sym_LT_EQ_GT,
  [anon_sym_u27fa] = anon_sym_u27fa,
  [anon_sym_u21d4] = anon_sym_u21d4,
  [anon_sym_TILDE_GT] = anon_sym_TILDE_GT,
  [anon_sym_u21dd] = anon_sym_u21dd,
  [anon_sym_u219d] = anon_sym_u219d,
  [anon_sym_BSLASHland] = anon_sym_BSLASHland,
  [anon_sym_BSLASHlor] = anon_sym_BSLASHlor,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_u2254] = anon_sym_u2254,
  [anon_sym_COLON_COLON_EQ] = anon_sym_COLON_COLON_EQ,
  [anon_sym_u2a74] = anon_sym_u2a74,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_u2260] = anon_sym_u2260,
  [anon_sym_LT] = anon_sym_LT,
  [sym_gt] = sym_gt,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_LT] = anon_sym_EQ_LT,
  [anon_sym_BSLASHleq] = anon_sym_BSLASHleq,
  [anon_sym_u2264] = anon_sym_u2264,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_BSLASHgeq] = anon_sym_BSLASHgeq,
  [anon_sym_u2265] = anon_sym_u2265,
  [anon_sym_BSLASHapprox] = anon_sym_BSLASHapprox,
  [anon_sym_u2248] = anon_sym_u2248,
  [anon_sym_PIPE_DASH] = anon_sym_PIPE_DASH,
  [anon_sym_u22a2] = anon_sym_u22a2,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_u22a8] = anon_sym_u22a8,
  [anon_sym_DASH_PIPE] = anon_sym_DASH_PIPE,
  [anon_sym_u22a3] = anon_sym_u22a3,
  [anon_sym_EQ_PIPE] = anon_sym_EQ_PIPE,
  [anon_sym_u2ae4] = anon_sym_u2ae4,
  [anon_sym_BSLASHasymp] = anon_sym_BSLASHasymp,
  [anon_sym_u224d] = anon_sym_u224d,
  [anon_sym_BSLASHcong] = anon_sym_BSLASHcong,
  [anon_sym_u2245] = anon_sym_u2245,
  [anon_sym_BSLASHdoteq] = anon_sym_BSLASHdoteq,
  [anon_sym_u2250] = anon_sym_u2250,
  [anon_sym_BSLASHgg] = anon_sym_BSLASHgg,
  [anon_sym_u226b] = anon_sym_u226b,
  [anon_sym_BSLASHll] = anon_sym_BSLASHll,
  [anon_sym_u226a] = anon_sym_u226a,
  [anon_sym_BSLASHnotin] = anon_sym_BSLASHnotin,
  [anon_sym_u2209] = anon_sym_u2209,
  [anon_sym_BSLASHprec] = anon_sym_BSLASHprec,
  [anon_sym_u227a] = anon_sym_u227a,
  [anon_sym_BSLASHsucc] = anon_sym_BSLASHsucc,
  [anon_sym_u227b] = anon_sym_u227b,
  [anon_sym_BSLASHpreceq] = anon_sym_BSLASHpreceq,
  [anon_sym_u2aaf] = anon_sym_u2aaf,
  [anon_sym_BSLASHsucceq] = anon_sym_BSLASHsucceq,
  [anon_sym_u2ab0] = anon_sym_u2ab0,
  [anon_sym_BSLASHpropto] = anon_sym_BSLASHpropto,
  [anon_sym_u221d] = anon_sym_u221d,
  [anon_sym_BSLASHsim] = anon_sym_BSLASHsim,
  [anon_sym_u223c] = anon_sym_u223c,
  [anon_sym_BSLASHsimeq] = anon_sym_BSLASHsimeq,
  [anon_sym_u2243] = anon_sym_u2243,
  [anon_sym_BSLASHsqsubset] = anon_sym_BSLASHsqsubset,
  [anon_sym_u228f] = anon_sym_u228f,
  [anon_sym_BSLASHsqsupset] = anon_sym_BSLASHsqsupset,
  [anon_sym_u2290] = anon_sym_u2290,
  [anon_sym_BSLASHsqsubseteq] = anon_sym_BSLASHsqsubseteq,
  [anon_sym_u2291] = anon_sym_u2291,
  [anon_sym_BSLASHsqsupseteq] = anon_sym_BSLASHsqsupseteq,
  [anon_sym_u2292] = anon_sym_u2292,
  [anon_sym_BSLASHsubset] = anon_sym_BSLASHsubset,
  [anon_sym_u2282] = anon_sym_u2282,
  [anon_sym_BSLASHsupset] = anon_sym_BSLASHsupset,
  [anon_sym_u2283] = anon_sym_u2283,
  [anon_sym_BSLASHsubseteq] = anon_sym_BSLASHsubseteq,
  [anon_sym_u2286] = anon_sym_u2286,
  [anon_sym_BSLASHsupseteq] = anon_sym_BSLASHsupseteq,
  [anon_sym_u2287] = anon_sym_u2287,
  [sym_compose] = sym_compose,
  [sym_map_to] = sym_map_to,
  [sym_map_from] = sym_map_from,
  [sym_setminus] = sym_setminus,
  [anon_sym_BSLASHcap] = anon_sym_BSLASHcap,
  [anon_sym_BSLASHintersect] = anon_sym_BSLASHintersect,
  [anon_sym_u2229] = anon_sym_u2229,
  [anon_sym_BSLASHcup] = anon_sym_BSLASHcup,
  [anon_sym_BSLASHunion] = anon_sym_BSLASHunion,
  [anon_sym_u222a] = anon_sym_u222a,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_u2025] = anon_sym_u2025,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_u2026] = anon_sym_u2026,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [sym_plusplus] = sym_plusplus,
  [anon_sym_BSLASHoplus] = anon_sym_BSLASHoplus,
  [anon_sym_LPAREN_PLUS_RPAREN] = anon_sym_LPAREN_PLUS_RPAREN,
  [anon_sym_u2295] = anon_sym_u2295,
  [anon_sym_BSLASHominus] = anon_sym_BSLASHominus,
  [anon_sym_LPAREN_DASH_RPAREN] = anon_sym_LPAREN_DASH_RPAREN,
  [anon_sym_u2296] = anon_sym_u2296,
  [sym_mod] = sym_mod,
  [sym_modmod] = sym_modmod,
  [sym_vert] = sym_vert,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_u2016] = anon_sym_u2016,
  [sym_minusminus] = sym_minusminus,
  [sym_amp] = sym_amp,
  [sym_ampamp] = sym_ampamp,
  [anon_sym_BSLASHodot] = anon_sym_BSLASHodot,
  [anon_sym_LPAREN_DOT_RPAREN] = anon_sym_LPAREN_DOT_RPAREN,
  [anon_sym_u2299] = anon_sym_u2299,
  [anon_sym_BSLASHoslash] = anon_sym_BSLASHoslash,
  [anon_sym_LPAREN_SLASH_RPAREN] = anon_sym_LPAREN_SLASH_RPAREN,
  [anon_sym_u2298] = anon_sym_u2298,
  [anon_sym_BSLASHotimes] = anon_sym_BSLASHotimes,
  [anon_sym_LPAREN_BSLASHX_RPAREN] = anon_sym_LPAREN_BSLASHX_RPAREN,
  [anon_sym_u2297] = anon_sym_u2297,
  [sym_mul] = sym_mul,
  [sym_mulmul] = sym_mulmul,
  [sym_slash] = sym_slash,
  [sym_slashslash] = sym_slashslash,
  [anon_sym_BSLASHbigcirc] = anon_sym_BSLASHbigcirc,
  [anon_sym_u25ef] = anon_sym_u25ef,
  [anon_sym_BSLASHbullet] = anon_sym_BSLASHbullet,
  [anon_sym_u25cf] = anon_sym_u25cf,
  [anon_sym_BSLASHdiv] = anon_sym_BSLASHdiv,
  [anon_sym_u00f7] = anon_sym_u00f7,
  [anon_sym_BSLASHcirc] = anon_sym_BSLASHcirc,
  [anon_sym_u2218] = anon_sym_u2218,
  [anon_sym_BSLASHstar] = anon_sym_BSLASHstar,
  [anon_sym_u22c6] = anon_sym_u22c6,
  [anon_sym_u203c] = anon_sym_u203c,
  [sym_hashhash] = sym_hashhash,
  [sym_dol] = sym_dol,
  [sym_doldol] = sym_doldol,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_u2047] = anon_sym_u2047,
  [anon_sym_BSLASHsqcap] = anon_sym_BSLASHsqcap,
  [anon_sym_u2293] = anon_sym_u2293,
  [anon_sym_BSLASHsqcup] = anon_sym_BSLASHsqcup,
  [anon_sym_u2294] = anon_sym_u2294,
  [anon_sym_BSLASHuplus] = anon_sym_BSLASHuplus,
  [anon_sym_u228e] = anon_sym_u228e,
  [anon_sym_BSLASHX] = anon_sym_BSLASHX,
  [anon_sym_BSLASHtimes] = anon_sym_BSLASHtimes,
  [anon_sym_u00d7] = anon_sym_u00d7,
  [anon_sym_BSLASHwr] = anon_sym_BSLASHwr,
  [anon_sym_u2240] = anon_sym_u2240,
  [anon_sym_BSLASHcdot] = anon_sym_BSLASHcdot,
  [anon_sym_u22c5] = anon_sym_u22c5,
  [sym_pow] = sym_pow,
  [sym_powpow] = sym_powpow,
  [anon_sym_CARET_PLUS] = anon_sym_CARET_PLUS,
  [anon_sym_u207a] = anon_sym_u207a,
  [sym_asterisk] = sym_asterisk,
  [sym_sup_hash] = sym_sup_hash,
  [sym_prime] = sym_prime,
  [anon_sym_ASSUME] = anon_sym_ASSUME,
  [anon_sym_ASSUMPTION] = anon_sym_ASSUMPTION,
  [anon_sym_AXIOM] = anon_sym_AXIOM,
  [anon_sym_THEOREM] = anon_sym_THEOREM,
  [anon_sym_PROPOSITION] = anon_sym_PROPOSITION,
  [anon_sym_LEMMA] = anon_sym_LEMMA,
  [anon_sym_COROLLARY] = anon_sym_COROLLARY,
  [anon_sym_PROVE] = anon_sym_PROVE,
  [anon_sym_NEW] = anon_sym_NEW,
  [anon_sym_STATE] = anon_sym_STATE,
  [anon_sym_ACTION] = anon_sym_ACTION,
  [anon_sym_TEMPORAL] = anon_sym_TEMPORAL,
  [anon_sym_PROOF] = anon_sym_PROOF,
  [anon_sym_BY] = anon_sym_BY,
  [anon_sym_ONLY] = anon_sym_ONLY,
  [anon_sym_OBVIOUS] = anon_sym_OBVIOUS,
  [anon_sym_OMITTED] = anon_sym_OMITTED,
  [anon_sym_DEFINE] = anon_sym_DEFINE,
  [anon_sym_HAVE] = anon_sym_HAVE,
  [anon_sym_WITNESS] = anon_sym_WITNESS,
  [anon_sym_TAKE] = anon_sym_TAKE,
  [anon_sym_SUFFICES] = anon_sym_SUFFICES,
  [anon_sym_PICK] = anon_sym_PICK,
  [anon_sym_QED] = anon_sym_QED,
  [anon_sym_USE] = anon_sym_USE,
  [anon_sym_HIDE] = anon_sym_HIDE,
  [anon_sym_DEF] = anon_sym_DEF,
  [anon_sym_DEFS] = anon_sym_DEFS,
  [aux_sym_proof_step_id_token1] = aux_sym_proof_step_id_token1,
  [anon_sym_GT] = anon_sym_GT,
  [aux_sym_proof_step_id_token2] = aux_sym_proof_step_id_token2,
  [aux_sym_proof_step_id_token3] = aux_sym_proof_step_id_token3,
  [aux_sym_proof_step_ref_token1] = aux_sym_proof_step_id_token1,
  [aux_sym_proof_step_ref_token2] = aux_sym_proof_step_id_token2,
  [anon_sym_end] = anon_sym_end,
  [anon_sym_algorithm] = anon_sym_algorithm,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_DASH_DASHalgorithm] = anon_sym_DASH_DASHalgorithm,
  [anon_sym_DASH_DASHfair] = anon_sym_DASH_DASHfair,
  [anon_sym_define] = anon_sym_define,
  [anon_sym_macro] = anon_sym_macro,
  [anon_sym_procedure] = anon_sym_procedure,
  [anon_sym_fair] = anon_sym_fair,
  [anon_sym_process] = anon_sym_process,
  [anon_sym_variable] = anon_sym_variable,
  [anon_sym_variables] = anon_sym_variables,
  [anon_sym_begin] = anon_sym_begin,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_elsif] = anon_sym_elsif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_either] = anon_sym_either,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_when] = anon_sym_when,
  [anon_sym_print] = anon_sym_print,
  [anon_sym_assert] = anon_sym_assert,
  [sym_pcal_skip] = sym_pcal_skip,
  [sym_pcal_return] = sym_pcal_return,
  [anon_sym_goto] = anon_sym_goto,
  [anon_sym_call] = anon_sym_call,
  [sym_leading_extramodular_text] = sym_leading_extramodular_text,
  [sym_trailing_extramodular_text] = sym_leading_extramodular_text,
  [sym__indent] = sym__indent,
  [sym__bullet] = sym__bullet,
  [sym__dedent] = sym__dedent,
  [sym__begin_proof] = sym__begin_proof,
  [sym__begin_proof_step] = sym__begin_proof_step,
  [sym__notify_pcal_algorithm_start] = sym__notify_pcal_algorithm_start,
  [sym__notify_pcal_algorithm_end] = sym__notify_pcal_algorithm_end,
  [sym__double_excl] = sym__double_excl,
  [sym__error_sentinel] = sym__error_sentinel,
  [sym_source_file] = sym_source_file,
  [sym_block_comment] = sym_block_comment,
  [sym_block_comment_text] = sym_block_comment_text,
  [sym_module] = sym_module,
  [sym_single_line] = sym_single_line,
  [sym_double_line] = sym_double_line,
  [sym_def_eq] = sym_def_eq,
  [sym_set_in] = sym_set_in,
  [sym_gets] = sym_gets,
  [sym_forall] = sym_forall,
  [sym_exists] = sym_exists,
  [sym_all_map_to] = sym_all_map_to,
  [sym_maps_to] = sym_maps_to,
  [sym_langle_bracket] = sym_langle_bracket,
  [sym_rangle_bracket] = sym_rangle_bracket,
  [sym_rangle_bracket_sub] = sym_rangle_bracket_sub,
  [sym_case_box] = sym_case_box,
  [sym_case_arrow] = sym_case_arrow,
  [sym_colon] = sym_colon,
  [sym_address] = sym_address,
  [sym_label_as] = sym_label_as,
  [sym_bullet_conj] = sym_bullet_conj,
  [sym_bullet_disj] = sym_bullet_disj,
  [sym_extends] = sym_extends,
  [sym__unit] = sym__unit,
  [sym_local_definition] = sym_local_definition,
  [sym__definition] = sym__definition,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_constant_declaration] = sym_constant_declaration,
  [sym_recursive_declaration] = sym_recursive_declaration,
  [sym_operator_declaration] = sym_operator_declaration,
  [sym__id_or_op_declaration] = sym__id_or_op_declaration,
  [sym_operator_definition] = sym_operator_definition,
  [sym_function_definition] = sym_function_definition,
  [sym_instance] = sym_instance,
  [sym_substitution] = sym_substitution,
  [sym__op_or_expr] = sym__op_or_expr,
  [sym__op] = sym__op,
  [sym_subexpr_prefix] = sym_subexpr_prefix,
  [sym_subexpr_component] = sym_subexpr_component,
  [sym_bound_op] = sym_bound_op,
  [sym_bound_nonfix_op] = sym_bound_nonfix_op,
  [sym_subexpr_tree_nav] = sym_subexpr_tree_nav,
  [sym_child_id] = sym_child_id,
  [sym_operator_args] = sym_operator_args,
  [sym_lambda] = sym_lambda,
  [sym_module_definition] = sym_module_definition,
  [sym__expr] = sym__expr,
  [sym__subscript_expr] = sym__subscript_expr,
  [sym_prefixed_op] = sym_prefixed_op,
  [sym__number] = sym__number,
  [sym_nat_number] = sym_nat_number,
  [sym_binary_number] = sym_binary_number,
  [sym_octal_number] = sym_octal_number,
  [sym_hex_number] = sym_hex_number,
  [sym_string] = sym_string,
  [sym_boolean] = sym_boolean,
  [sym__number_set] = sym__number_set,
  [sym__primitive_value_set] = sym__primitive_value_set,
  [sym_nat_number_set] = sym_nat_number_set,
  [sym_int_number_set] = sym_int_number_set,
  [sym_real_number_set] = sym_real_number_set,
  [sym_label] = sym_label,
  [sym_subexpression] = sym_subexpression,
  [sym_parentheses] = sym_parentheses,
  [sym_bounded_quantification] = sym_bounded_quantification,
  [sym_unbounded_quantification] = sym_unbounded_quantification,
  [sym_choose] = sym_choose,
  [sym_finite_set_literal] = sym_finite_set_literal,
  [sym_set_filter] = sym_set_filter,
  [sym_set_map] = sym_set_map,
  [sym_quantifier_bound] = sym_quantifier_bound,
  [sym_restricted_quantifier_bound] = sym_quantifier_bound,
  [sym_tuple_of_identifiers] = sym_tuple_of_identifiers,
  [sym_function_evaluation] = sym_function_evaluation,
  [sym_function_literal] = sym_function_literal,
  [sym_set_of_functions] = sym_set_of_functions,
  [sym_record_literal] = sym_record_literal,
  [sym_set_of_records] = sym_set_of_records,
  [sym_record_value] = sym_record_value,
  [sym_except] = sym_except,
  [sym_except_update] = sym_except_update,
  [sym_except_update_specifier] = sym_except_update_specifier,
  [sym_except_update_record_field] = sym_except_update_record_field,
  [sym_except_update_fn_appl] = sym_except_update_fn_appl,
  [sym_prev_func_val] = sym_prev_func_val,
  [sym_tuple_literal] = sym_tuple_literal,
  [sym_step_expr_or_stutter] = sym_step_expr_or_stutter,
  [sym_step_expr_no_stutter] = sym_step_expr_no_stutter,
  [sym_fairness] = sym_fairness,
  [sym_if_then_else] = sym_if_then_else,
  [sym_case] = sym_case,
  [sym_case_arm] = sym_case_arm,
  [sym_other_arm] = sym_other_arm,
  [sym_let_in] = sym_let_in,
  [sym_conj_list] = sym_conj_list,
  [sym_conj_item] = sym_conj_item,
  [sym_disj_list] = sym_disj_list,
  [sym_disj_item] = sym_disj_item,
  [sym_lnot] = sym_lnot,
  [sym_negative] = sym_negative,
  [sym_always] = sym_always,
  [sym_eventually] = sym_eventually,
  [sym_prefix_op_symbol] = sym_prefix_op_symbol,
  [sym_bound_prefix_op] = sym_bound_prefix_op,
  [sym_implies] = sym_implies,
  [sym_plus_arrow] = sym_plus_arrow,
  [sym_equiv] = sym_equiv,
  [sym_iff] = sym_iff,
  [sym_leads_to] = sym_leads_to,
  [sym_land] = sym_land,
  [sym_lor] = sym_lor,
  [sym_assign] = sym_assign,
  [sym_bnf_rule] = sym_bnf_rule,
  [sym_eq] = sym_eq,
  [sym_neq] = sym_neq,
  [sym_lt] = sym_lt,
  [sym_leq] = sym_leq,
  [sym_geq] = sym_geq,
  [sym_approx] = sym_approx,
  [sym_rs_ttile] = sym_rs_ttile,
  [sym_rd_ttile] = sym_rd_ttile,
  [sym_ls_ttile] = sym_ls_ttile,
  [sym_ld_ttile] = sym_ld_ttile,
  [sym_asymp] = sym_asymp,
  [sym_cong] = sym_cong,
  [sym_doteq] = sym_doteq,
  [sym_gg] = sym_gg,
  [sym_ll] = sym_ll,
  [sym_in] = sym_in,
  [sym_notin] = sym_notin,
  [sym_prec] = sym_prec,
  [sym_succ] = sym_succ,
  [sym_preceq] = sym_preceq,
  [sym_succeq] = sym_succeq,
  [sym_propto] = sym_propto,
  [sym_sim] = sym_sim,
  [sym_simeq] = sym_simeq,
  [sym_sqsubset] = sym_sqsubset,
  [sym_sqsupset] = sym_sqsupset,
  [sym_sqsubseteq] = sym_sqsubseteq,
  [sym_sqsupseteq] = sym_sqsupseteq,
  [sym_subset] = sym_subset,
  [sym_supset] = sym_supset,
  [sym_subseteq] = sym_subseteq,
  [sym_supseteq] = sym_supseteq,
  [sym_cap] = sym_cap,
  [sym_cup] = sym_cup,
  [sym_dots_2] = sym_dots_2,
  [sym_dots_3] = sym_dots_3,
  [sym_plus] = sym_plus,
  [sym_oplus] = sym_oplus,
  [sym_ominus] = sym_ominus,
  [sym_vertvert] = sym_vertvert,
  [sym_minus] = sym_minus,
  [sym_odot] = sym_odot,
  [sym_oslash] = sym_oslash,
  [sym_otimes] = sym_otimes,
  [sym_bigcirc] = sym_bigcirc,
  [sym_bullet] = sym_bullet,
  [sym_div] = sym_div,
  [sym_circ] = sym_circ,
  [sym_star] = sym_star,
  [sym_excl] = sym_excl,
  [sym_qq] = sym_qq,
  [sym_sqcap] = sym_sqcap,
  [sym_sqcup] = sym_sqcup,
  [sym_uplus] = sym_uplus,
  [sym_times] = sym_times,
  [sym_wr] = sym_wr,
  [sym_cdot] = sym_cdot,
  [sym_infix_op_symbol] = sym_infix_op_symbol,
  [sym_bound_infix_op] = sym_bound_infix_op,
  [sym_sup_plus] = sym_sup_plus,
  [sym_postfix_op_symbol] = sym_postfix_op_symbol,
  [sym_bound_postfix_op] = sym_bound_postfix_op,
  [sym_assumption] = sym_assumption,
  [sym_theorem] = sym_theorem,
  [sym_assume_prove] = sym_assume_prove,
  [sym_inner_assume_prove] = sym_inner_assume_prove,
  [sym_new] = sym_new,
  [sym_statement_level] = sym_statement_level,
  [sym__proof] = sym__proof,
  [sym_terminal_proof] = sym_terminal_proof,
  [sym_non_terminal_proof] = sym_non_terminal_proof,
  [sym_proof_step] = sym_proof_step,
  [sym_definition_proof_step] = sym_definition_proof_step,
  [sym_have_proof_step] = sym_have_proof_step,
  [sym_witness_proof_step] = sym_witness_proof_step,
  [sym_take_proof_step] = sym_take_proof_step,
  [sym_suffices_proof_step] = sym_suffices_proof_step,
  [sym_case_proof_step] = sym_case_proof_step,
  [sym_pick_proof_step] = sym_pick_proof_step,
  [sym__bound_or_identifier_list] = sym__bound_or_identifier_list,
  [sym_qed_step] = sym_qed_step,
  [sym_use_or_hide] = sym_use_or_hide,
  [sym_use_body] = sym_use_body,
  [sym_use_body_expr] = sym_use_body_expr,
  [sym_use_body_def] = sym_use_body_def,
  [sym_module_ref] = sym_module_ref,
  [sym_proof_step_id] = sym_proof_step_id,
  [sym_proof_step_ref] = sym_proof_step_ref,
  [sym_pcal_algorithm] = sym_pcal_algorithm,
  [sym__pcal_p_algorithm] = sym__pcal_p_algorithm,
  [sym__pcal_c_algorithm] = sym__pcal_c_algorithm,
  [sym_pcal_algorithm_start] = sym_pcal_algorithm_start,
  [sym_fair] = sym_fair,
  [sym_pcal_p_definitions] = sym_pcal_p_definitions,
  [sym_pcal_c_definitions] = sym_pcal_p_definitions,
  [sym_pcal_p_macro] = sym_pcal_p_macro,
  [sym_pcal_c_macro] = sym_pcal_p_macro,
  [sym_pcal_macro_decl] = sym_pcal_macro_decl,
  [sym_pcal_p_procedure] = sym_pcal_p_procedure,
  [sym_pcal_c_procedure] = sym_pcal_p_procedure,
  [sym_pcal_proc_decl] = sym_pcal_proc_decl,
  [sym_pcal_p_process] = sym_pcal_p_process,
  [sym_pcal_c_process] = sym_pcal_p_process,
  [sym_pcal_var_decls] = sym_pcal_var_decls,
  [sym_pcal_var_decl] = sym_pcal_var_decl,
  [sym_pcal_proc_var_decls] = sym_pcal_proc_var_decls,
  [sym_pcal_proc_var_decl] = sym_pcal_proc_var_decl,
  [sym_pcal_p_algorithm_body] = sym_pcal_p_algorithm_body,
  [sym__pcal_p_stmts] = sym__pcal_p_stmts,
  [sym_pcal_c_algorithm_body] = sym_pcal_p_algorithm_body,
  [sym__pcal_p_stmt] = sym__pcal_p_stmt,
  [sym__pcal_c_stmt] = sym__pcal_c_stmt,
  [sym__pcal_label] = sym__pcal_label,
  [sym__pcal_p_unlabeled_stmt] = sym__pcal_p_unlabeled_stmt,
  [sym__pcal_c_unlabeled_stmt] = sym__pcal_c_unlabeled_stmt,
  [sym_pcal_assign] = sym_pcal_assign,
  [sym_pcal_lhs] = sym_pcal_lhs,
  [sym_pcal_p_if] = sym_pcal_p_if,
  [sym_pcal_c_if] = sym_pcal_p_if,
  [sym_pcal_p_while] = sym_pcal_p_while,
  [sym_pcal_c_while] = sym_pcal_p_while,
  [sym_pcal_p_either] = sym_pcal_p_either,
  [sym_pcal_c_either] = sym_pcal_p_either,
  [sym_pcal_p_with] = sym_pcal_p_with,
  [sym_pcal_c_with] = sym_pcal_p_with,
  [sym__pcal_with_vars] = sym__pcal_with_vars,
  [sym_pcal_await] = sym_pcal_await,
  [sym_pcal_print] = sym_pcal_print,
  [sym_pcal_assert] = sym_pcal_assert,
  [sym_pcal_goto] = sym_pcal_goto,
  [sym_pcal_proc_call] = sym_pcal_proc_call,
  [sym_pcal_macro_call] = sym_pcal_macro_call,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_source_file_repeat2] = aux_sym_source_file_repeat2,
  [aux_sym_block_comment_repeat1] = aux_sym_block_comment_repeat1,
  [aux_sym_block_comment_text_repeat1] = aux_sym_block_comment_text_repeat1,
  [aux_sym_extends_repeat1] = aux_sym_extends_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_constant_declaration_repeat1] = aux_sym_constant_declaration_repeat1,
  [aux_sym_operator_declaration_repeat1] = aux_sym_operator_declaration_repeat1,
  [aux_sym_function_definition_repeat1] = aux_sym_function_definition_repeat1,
  [aux_sym_instance_repeat1] = aux_sym_instance_repeat1,
  [aux_sym_subexpr_prefix_repeat1] = aux_sym_subexpr_prefix_repeat1,
  [aux_sym_bound_op_repeat1] = aux_sym_bound_op_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_finite_set_literal_repeat1] = aux_sym_finite_set_literal_repeat1,
  [aux_sym_record_literal_repeat1] = aux_sym_record_literal_repeat1,
  [aux_sym_set_of_records_repeat1] = aux_sym_set_of_records_repeat1,
  [aux_sym_except_repeat1] = aux_sym_except_repeat1,
  [aux_sym_except_update_specifier_repeat1] = aux_sym_except_update_specifier_repeat1,
  [aux_sym_case_repeat1] = aux_sym_case_repeat1,
  [aux_sym_let_in_repeat1] = aux_sym_let_in_repeat1,
  [aux_sym_conj_list_repeat1] = aux_sym_conj_list_repeat1,
  [aux_sym_disj_list_repeat1] = aux_sym_disj_list_repeat1,
  [aux_sym_assume_prove_repeat1] = aux_sym_assume_prove_repeat1,
  [aux_sym_non_terminal_proof_repeat1] = aux_sym_non_terminal_proof_repeat1,
  [aux_sym_definition_proof_step_repeat1] = aux_sym_definition_proof_step_repeat1,
  [aux_sym_use_body_expr_repeat1] = aux_sym_use_body_expr_repeat1,
  [aux_sym_use_body_def_repeat1] = aux_sym_use_body_def_repeat1,
  [aux_sym__pcal_p_algorithm_repeat1] = aux_sym__pcal_p_algorithm_repeat1,
  [aux_sym__pcal_p_algorithm_repeat2] = aux_sym__pcal_p_algorithm_repeat2,
  [aux_sym__pcal_p_algorithm_repeat3] = aux_sym__pcal_p_algorithm_repeat3,
  [aux_sym__pcal_c_algorithm_repeat1] = aux_sym__pcal_c_algorithm_repeat1,
  [aux_sym__pcal_c_algorithm_repeat2] = aux_sym__pcal_c_algorithm_repeat2,
  [aux_sym__pcal_c_algorithm_repeat3] = aux_sym__pcal_c_algorithm_repeat3,
  [aux_sym_pcal_p_definitions_repeat1] = aux_sym_pcal_p_definitions_repeat1,
  [aux_sym_pcal_macro_decl_repeat1] = aux_sym_pcal_macro_decl_repeat1,
  [aux_sym_pcal_proc_decl_repeat1] = aux_sym_pcal_proc_decl_repeat1,
  [aux_sym_pcal_var_decls_repeat1] = aux_sym_pcal_var_decls_repeat1,
  [aux_sym_pcal_proc_var_decls_repeat1] = aux_sym_pcal_proc_var_decls_repeat1,
  [aux_sym__pcal_p_stmts_repeat1] = aux_sym__pcal_p_stmts_repeat1,
  [aux_sym_pcal_c_algorithm_body_repeat1] = aux_sym_pcal_c_algorithm_body_repeat1,
  [aux_sym_pcal_assign_repeat1] = aux_sym_pcal_assign_repeat1,
  [aux_sym_pcal_lhs_repeat1] = aux_sym_pcal_lhs_repeat1,
  [aux_sym_pcal_p_if_repeat1] = aux_sym_pcal_p_if_repeat1,
  [aux_sym_pcal_p_either_repeat1] = aux_sym_pcal_p_either_repeat1,
  [aux_sym_pcal_c_either_repeat1] = aux_sym_pcal_c_either_repeat1,
  [aux_sym__pcal_with_vars_repeat1] = aux_sym__pcal_with_vars_repeat1,
  [alias_sym_header_line] = alias_sym_header_line,
  [alias_sym_identifier_ref] = alias_sym_identifier_ref,
  [alias_sym_pcal_end_either] = alias_sym_pcal_end_either,
  [alias_sym_pcal_end_if] = alias_sym_pcal_end_if,
  [alias_sym_pcal_end_while] = alias_sym_pcal_end_while,
  [alias_sym_pcal_end_with] = alias_sym_pcal_end_with,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_block_comment_text_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_comment_text_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_comment_text_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_comment_text_token4] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_MODULE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_single_line_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_double_line_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u225c] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2208] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u27f5] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2190] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHforall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2200] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHexists] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2203] = {
    .visible = true,
    .named = false,
  },
  [sym_temporal_forall] = {
    .visible = true,
    .named = true,
  },
  [sym_temporal_exists] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u27fc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u21a6] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u27f6] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2192] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u3008] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u27e8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u3009] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u27e9] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u3009_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u27e9_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u25a1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2237] = {
    .visible = true,
    .named = false,
  },
  [sym_placeholder] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SLASH_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2227] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2228] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EXTENDS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LOCAL] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_VARIABLE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_VARIABLES] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CONSTANT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CONSTANTS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RECURSIVE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_INSTANCE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_WITH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_child_id_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LAMBDA] = {
    .visible = true,
    .named = false,
  },
  [sym_real_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHb] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHB] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_binary_number_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHO] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_octal_number_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHh] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHH] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_hex_number_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE2] = {
    .visible = true,
    .named = false,
  },
  [sym_escape_char] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_TRUE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_FALSE] = {
    .visible = true,
    .named = false,
  },
  [sym_string_set] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_set] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_Nat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2115] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2124] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Real] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u211d] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CHOOSE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EXCEPT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_WF_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SF_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_IF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_THEN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ELSE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CASE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_OTHER] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_IN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlnot] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHneg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u00ac] = {
    .visible = true,
    .named = false,
  },
  [sym_union] = {
    .visible = true,
    .named = true,
  },
  [sym_powerset] = {
    .visible = true,
    .named = true,
  },
  [sym_domain] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [sym_negative_dot] = {
    .visible = true,
    .named = true,
  },
  [sym_enabled] = {
    .visible = true,
    .named = true,
  },
  [sym_unchanged] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u22c4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u25c7] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u27f9] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u21d2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_PLUS_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u21f8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2945] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHequiv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2261] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u27fa] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u21d4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u21dd] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u219d] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHland] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2254] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2a74] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2260] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [sym_gt] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHleq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2264] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHgeq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2265] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHapprox] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2248] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u22a2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u22a8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u22a3] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2ae4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHasymp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u224d] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2245] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdoteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2250] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHgg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u226b] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHll] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u226a] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnotin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2209] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHprec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u227a] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsucc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u227b] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpreceq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2aaf] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsucceq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2ab0] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpropto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u221d] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsim] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u223c] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsimeq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2243] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqsubset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u228f] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqsupset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2290] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqsubseteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2291] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqsupseteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2292] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2282] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsupset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2283] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubseteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2286] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsupseteq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2287] = {
    .visible = true,
    .named = false,
  },
  [sym_compose] = {
    .visible = true,
    .named = true,
  },
  [sym_map_to] = {
    .visible = true,
    .named = true,
  },
  [sym_map_from] = {
    .visible = true,
    .named = true,
  },
  [sym_setminus] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHcap] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHintersect] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2229] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcup] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHunion] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u222a] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2025] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2026] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [sym_plusplus] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHoplus] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_PLUS_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2295] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHominus] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_DASH_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2296] = {
    .visible = true,
    .named = false,
  },
  [sym_mod] = {
    .visible = true,
    .named = true,
  },
  [sym_modmod] = {
    .visible = true,
    .named = true,
  },
  [sym_vert] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2016] = {
    .visible = true,
    .named = false,
  },
  [sym_minusminus] = {
    .visible = true,
    .named = true,
  },
  [sym_amp] = {
    .visible = true,
    .named = true,
  },
  [sym_ampamp] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHodot] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_DOT_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2299] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHoslash] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_SLASH_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2298] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHotimes] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_BSLASHX_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2297] = {
    .visible = true,
    .named = false,
  },
  [sym_mul] = {
    .visible = true,
    .named = true,
  },
  [sym_mulmul] = {
    .visible = true,
    .named = true,
  },
  [sym_slash] = {
    .visible = true,
    .named = true,
  },
  [sym_slashslash] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHbigcirc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u25ef] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHbullet] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u25cf] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdiv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u00f7] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcirc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2218] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHstar] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u22c6] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u203c] = {
    .visible = true,
    .named = false,
  },
  [sym_hashhash] = {
    .visible = true,
    .named = true,
  },
  [sym_dol] = {
    .visible = true,
    .named = true,
  },
  [sym_doldol] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2047] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqcap] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2293] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsqcup] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2294] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHuplus] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u228e] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHX] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHtimes] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u00d7] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHwr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2240] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcdot] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u22c5] = {
    .visible = true,
    .named = false,
  },
  [sym_pow] = {
    .visible = true,
    .named = true,
  },
  [sym_powpow] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_CARET_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u207a] = {
    .visible = true,
    .named = false,
  },
  [sym_asterisk] = {
    .visible = true,
    .named = true,
  },
  [sym_sup_hash] = {
    .visible = true,
    .named = true,
  },
  [sym_prime] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ASSUME] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ASSUMPTION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AXIOM] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_THEOREM] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PROPOSITION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LEMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COROLLARY] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PROVE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NEW] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STATE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ACTION] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TEMPORAL] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PROOF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BY] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ONLY] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_OBVIOUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_OMITTED] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DEFINE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_HAVE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_WITNESS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TAKE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SUFFICES] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PICK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QED] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_USE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_HIDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DEF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DEFS] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_proof_step_id_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_proof_step_id_token2] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_proof_step_id_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_proof_step_ref_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_proof_step_ref_token2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_algorithm] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASHalgorithm] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASHfair] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_define] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_macro] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_procedure] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fair] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_process] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_variable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_variables] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_begin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elsif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_either] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_when] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_print] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [sym_pcal_skip] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_return] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_goto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_call] = {
    .visible = true,
    .named = false,
  },
  [sym_leading_extramodular_text] = {
    .visible = true,
    .named = true,
  },
  [sym_trailing_extramodular_text] = {
    .visible = true,
    .named = true,
  },
  [sym__indent] = {
    .visible = false,
    .named = true,
  },
  [sym__bullet] = {
    .visible = false,
    .named = true,
  },
  [sym__dedent] = {
    .visible = false,
    .named = true,
  },
  [sym__begin_proof] = {
    .visible = false,
    .named = true,
  },
  [sym__begin_proof_step] = {
    .visible = false,
    .named = true,
  },
  [sym__notify_pcal_algorithm_start] = {
    .visible = false,
    .named = true,
  },
  [sym__notify_pcal_algorithm_end] = {
    .visible = false,
    .named = true,
  },
  [sym__double_excl] = {
    .visible = true,
    .named = false,
  },
  [sym__error_sentinel] = {
    .visible = false,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment_text] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym_single_line] = {
    .visible = true,
    .named = true,
  },
  [sym_double_line] = {
    .visible = true,
    .named = true,
  },
  [sym_def_eq] = {
    .visible = true,
    .named = true,
  },
  [sym_set_in] = {
    .visible = true,
    .named = true,
  },
  [sym_gets] = {
    .visible = true,
    .named = true,
  },
  [sym_forall] = {
    .visible = true,
    .named = true,
  },
  [sym_exists] = {
    .visible = true,
    .named = true,
  },
  [sym_all_map_to] = {
    .visible = true,
    .named = true,
  },
  [sym_maps_to] = {
    .visible = true,
    .named = true,
  },
  [sym_langle_bracket] = {
    .visible = true,
    .named = true,
  },
  [sym_rangle_bracket] = {
    .visible = true,
    .named = true,
  },
  [sym_rangle_bracket_sub] = {
    .visible = true,
    .named = true,
  },
  [sym_case_box] = {
    .visible = true,
    .named = true,
  },
  [sym_case_arrow] = {
    .visible = true,
    .named = true,
  },
  [sym_colon] = {
    .visible = true,
    .named = true,
  },
  [sym_address] = {
    .visible = true,
    .named = true,
  },
  [sym_label_as] = {
    .visible = true,
    .named = true,
  },
  [sym_bullet_conj] = {
    .visible = true,
    .named = true,
  },
  [sym_bullet_disj] = {
    .visible = true,
    .named = true,
  },
  [sym_extends] = {
    .visible = true,
    .named = true,
  },
  [sym__unit] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_local_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__definition] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_recursive_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__id_or_op_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_operator_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_instance] = {
    .visible = true,
    .named = true,
  },
  [sym_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym__op_or_expr] = {
    .visible = false,
    .named = true,
  },
  [sym__op] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_subexpr_prefix] = {
    .visible = true,
    .named = true,
  },
  [sym_subexpr_component] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_op] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_nonfix_op] = {
    .visible = true,
    .named = true,
  },
  [sym_subexpr_tree_nav] = {
    .visible = true,
    .named = true,
  },
  [sym_child_id] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_args] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda] = {
    .visible = true,
    .named = true,
  },
  [sym_module_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__expr] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__subscript_expr] = {
    .visible = false,
    .named = true,
  },
  [sym_prefixed_op] = {
    .visible = true,
    .named = true,
  },
  [sym__number] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_nat_number] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_number] = {
    .visible = true,
    .named = true,
  },
  [sym_octal_number] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_number] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym__number_set] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__primitive_value_set] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_nat_number_set] = {
    .visible = true,
    .named = true,
  },
  [sym_int_number_set] = {
    .visible = true,
    .named = true,
  },
  [sym_real_number_set] = {
    .visible = true,
    .named = true,
  },
  [sym_label] = {
    .visible = true,
    .named = true,
  },
  [sym_subexpression] = {
    .visible = true,
    .named = true,
  },
  [sym_parentheses] = {
    .visible = true,
    .named = true,
  },
  [sym_bounded_quantification] = {
    .visible = true,
    .named = true,
  },
  [sym_unbounded_quantification] = {
    .visible = true,
    .named = true,
  },
  [sym_choose] = {
    .visible = true,
    .named = true,
  },
  [sym_finite_set_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_set_filter] = {
    .visible = true,
    .named = true,
  },
  [sym_set_map] = {
    .visible = true,
    .named = true,
  },
  [sym_quantifier_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_restricted_quantifier_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_of_identifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_function_evaluation] = {
    .visible = true,
    .named = true,
  },
  [sym_function_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_set_of_functions] = {
    .visible = true,
    .named = true,
  },
  [sym_record_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_set_of_records] = {
    .visible = true,
    .named = true,
  },
  [sym_record_value] = {
    .visible = true,
    .named = true,
  },
  [sym_except] = {
    .visible = true,
    .named = true,
  },
  [sym_except_update] = {
    .visible = true,
    .named = true,
  },
  [sym_except_update_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_except_update_record_field] = {
    .visible = true,
    .named = true,
  },
  [sym_except_update_fn_appl] = {
    .visible = true,
    .named = true,
  },
  [sym_prev_func_val] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_step_expr_or_stutter] = {
    .visible = true,
    .named = true,
  },
  [sym_step_expr_no_stutter] = {
    .visible = true,
    .named = true,
  },
  [sym_fairness] = {
    .visible = true,
    .named = true,
  },
  [sym_if_then_else] = {
    .visible = true,
    .named = true,
  },
  [sym_case] = {
    .visible = true,
    .named = true,
  },
  [sym_case_arm] = {
    .visible = true,
    .named = true,
  },
  [sym_other_arm] = {
    .visible = true,
    .named = true,
  },
  [sym_let_in] = {
    .visible = true,
    .named = true,
  },
  [sym_conj_list] = {
    .visible = true,
    .named = true,
  },
  [sym_conj_item] = {
    .visible = true,
    .named = true,
  },
  [sym_disj_list] = {
    .visible = true,
    .named = true,
  },
  [sym_disj_item] = {
    .visible = true,
    .named = true,
  },
  [sym_lnot] = {
    .visible = true,
    .named = true,
  },
  [sym_negative] = {
    .visible = true,
    .named = true,
  },
  [sym_always] = {
    .visible = true,
    .named = true,
  },
  [sym_eventually] = {
    .visible = true,
    .named = true,
  },
  [sym_prefix_op_symbol] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_prefix_op] = {
    .visible = true,
    .named = true,
  },
  [sym_implies] = {
    .visible = true,
    .named = true,
  },
  [sym_plus_arrow] = {
    .visible = true,
    .named = true,
  },
  [sym_equiv] = {
    .visible = true,
    .named = true,
  },
  [sym_iff] = {
    .visible = true,
    .named = true,
  },
  [sym_leads_to] = {
    .visible = true,
    .named = true,
  },
  [sym_land] = {
    .visible = true,
    .named = true,
  },
  [sym_lor] = {
    .visible = true,
    .named = true,
  },
  [sym_assign] = {
    .visible = true,
    .named = true,
  },
  [sym_bnf_rule] = {
    .visible = true,
    .named = true,
  },
  [sym_eq] = {
    .visible = true,
    .named = true,
  },
  [sym_neq] = {
    .visible = true,
    .named = true,
  },
  [sym_lt] = {
    .visible = true,
    .named = true,
  },
  [sym_leq] = {
    .visible = true,
    .named = true,
  },
  [sym_geq] = {
    .visible = true,
    .named = true,
  },
  [sym_approx] = {
    .visible = true,
    .named = true,
  },
  [sym_rs_ttile] = {
    .visible = true,
    .named = true,
  },
  [sym_rd_ttile] = {
    .visible = true,
    .named = true,
  },
  [sym_ls_ttile] = {
    .visible = true,
    .named = true,
  },
  [sym_ld_ttile] = {
    .visible = true,
    .named = true,
  },
  [sym_asymp] = {
    .visible = true,
    .named = true,
  },
  [sym_cong] = {
    .visible = true,
    .named = true,
  },
  [sym_doteq] = {
    .visible = true,
    .named = true,
  },
  [sym_gg] = {
    .visible = true,
    .named = true,
  },
  [sym_ll] = {
    .visible = true,
    .named = true,
  },
  [sym_in] = {
    .visible = true,
    .named = true,
  },
  [sym_notin] = {
    .visible = true,
    .named = true,
  },
  [sym_prec] = {
    .visible = true,
    .named = true,
  },
  [sym_succ] = {
    .visible = true,
    .named = true,
  },
  [sym_preceq] = {
    .visible = true,
    .named = true,
  },
  [sym_succeq] = {
    .visible = true,
    .named = true,
  },
  [sym_propto] = {
    .visible = true,
    .named = true,
  },
  [sym_sim] = {
    .visible = true,
    .named = true,
  },
  [sym_simeq] = {
    .visible = true,
    .named = true,
  },
  [sym_sqsubset] = {
    .visible = true,
    .named = true,
  },
  [sym_sqsupset] = {
    .visible = true,
    .named = true,
  },
  [sym_sqsubseteq] = {
    .visible = true,
    .named = true,
  },
  [sym_sqsupseteq] = {
    .visible = true,
    .named = true,
  },
  [sym_subset] = {
    .visible = true,
    .named = true,
  },
  [sym_supset] = {
    .visible = true,
    .named = true,
  },
  [sym_subseteq] = {
    .visible = true,
    .named = true,
  },
  [sym_supseteq] = {
    .visible = true,
    .named = true,
  },
  [sym_cap] = {
    .visible = true,
    .named = true,
  },
  [sym_cup] = {
    .visible = true,
    .named = true,
  },
  [sym_dots_2] = {
    .visible = true,
    .named = true,
  },
  [sym_dots_3] = {
    .visible = true,
    .named = true,
  },
  [sym_plus] = {
    .visible = true,
    .named = true,
  },
  [sym_oplus] = {
    .visible = true,
    .named = true,
  },
  [sym_ominus] = {
    .visible = true,
    .named = true,
  },
  [sym_vertvert] = {
    .visible = true,
    .named = true,
  },
  [sym_minus] = {
    .visible = true,
    .named = true,
  },
  [sym_odot] = {
    .visible = true,
    .named = true,
  },
  [sym_oslash] = {
    .visible = true,
    .named = true,
  },
  [sym_otimes] = {
    .visible = true,
    .named = true,
  },
  [sym_bigcirc] = {
    .visible = true,
    .named = true,
  },
  [sym_bullet] = {
    .visible = true,
    .named = true,
  },
  [sym_div] = {
    .visible = true,
    .named = true,
  },
  [sym_circ] = {
    .visible = true,
    .named = true,
  },
  [sym_star] = {
    .visible = true,
    .named = true,
  },
  [sym_excl] = {
    .visible = true,
    .named = true,
  },
  [sym_qq] = {
    .visible = true,
    .named = true,
  },
  [sym_sqcap] = {
    .visible = true,
    .named = true,
  },
  [sym_sqcup] = {
    .visible = true,
    .named = true,
  },
  [sym_uplus] = {
    .visible = true,
    .named = true,
  },
  [sym_times] = {
    .visible = true,
    .named = true,
  },
  [sym_wr] = {
    .visible = true,
    .named = true,
  },
  [sym_cdot] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_op_symbol] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_infix_op] = {
    .visible = true,
    .named = true,
  },
  [sym_sup_plus] = {
    .visible = true,
    .named = true,
  },
  [sym_postfix_op_symbol] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_postfix_op] = {
    .visible = true,
    .named = true,
  },
  [sym_assumption] = {
    .visible = true,
    .named = true,
  },
  [sym_theorem] = {
    .visible = true,
    .named = true,
  },
  [sym_assume_prove] = {
    .visible = true,
    .named = true,
  },
  [sym_inner_assume_prove] = {
    .visible = true,
    .named = true,
  },
  [sym_new] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_level] = {
    .visible = true,
    .named = true,
  },
  [sym__proof] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_terminal_proof] = {
    .visible = true,
    .named = true,
  },
  [sym_non_terminal_proof] = {
    .visible = true,
    .named = true,
  },
  [sym_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_definition_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_have_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_witness_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_take_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_suffices_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_case_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym_pick_proof_step] = {
    .visible = true,
    .named = true,
  },
  [sym__bound_or_identifier_list] = {
    .visible = false,
    .named = true,
  },
  [sym_qed_step] = {
    .visible = true,
    .named = true,
  },
  [sym_use_or_hide] = {
    .visible = true,
    .named = true,
  },
  [sym_use_body] = {
    .visible = true,
    .named = true,
  },
  [sym_use_body_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_use_body_def] = {
    .visible = true,
    .named = true,
  },
  [sym_module_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_proof_step_id] = {
    .visible = true,
    .named = true,
  },
  [sym_proof_step_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_algorithm] = {
    .visible = true,
    .named = true,
  },
  [sym__pcal_p_algorithm] = {
    .visible = false,
    .named = true,
  },
  [sym__pcal_c_algorithm] = {
    .visible = false,
    .named = true,
  },
  [sym_pcal_algorithm_start] = {
    .visible = true,
    .named = true,
  },
  [sym_fair] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_p_definitions] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_c_definitions] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_p_macro] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_c_macro] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_macro_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_p_procedure] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_c_procedure] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_proc_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_p_process] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_c_process] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_var_decls] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_var_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_proc_var_decls] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_proc_var_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_p_algorithm_body] = {
    .visible = true,
    .named = true,
  },
  [sym__pcal_p_stmts] = {
    .visible = false,
    .named = true,
  },
  [sym_pcal_c_algorithm_body] = {
    .visible = true,
    .named = true,
  },
  [sym__pcal_p_stmt] = {
    .visible = false,
    .named = true,
  },
  [sym__pcal_c_stmt] = {
    .visible = false,
    .named = true,
  },
  [sym__pcal_label] = {
    .visible = false,
    .named = true,
  },
  [sym__pcal_p_unlabeled_stmt] = {
    .visible = false,
    .named = true,
  },
  [sym__pcal_c_unlabeled_stmt] = {
    .visible = false,
    .named = true,
  },
  [sym_pcal_assign] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_lhs] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_p_if] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_c_if] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_p_while] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_c_while] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_p_either] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_c_either] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_p_with] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_c_with] = {
    .visible = true,
    .named = true,
  },
  [sym__pcal_with_vars] = {
    .visible = false,
    .named = true,
  },
  [sym_pcal_await] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_print] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_assert] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_goto] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_proc_call] = {
    .visible = true,
    .named = true,
  },
  [sym_pcal_macro_call] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_source_file_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_comment_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_comment_text_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extends_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constant_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_operator_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_instance_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_subexpr_prefix_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_bound_op_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_finite_set_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_set_of_records_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_except_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_except_update_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_let_in_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_conj_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_disj_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_assume_prove_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_non_terminal_proof_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_definition_proof_step_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_use_body_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_use_body_def_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pcal_p_algorithm_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pcal_p_algorithm_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pcal_p_algorithm_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pcal_c_algorithm_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pcal_c_algorithm_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pcal_c_algorithm_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_p_definitions_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_macro_decl_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_proc_decl_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_var_decls_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_proc_var_decls_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pcal_p_stmts_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_c_algorithm_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_assign_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_lhs_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_p_if_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_p_either_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pcal_c_either_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__pcal_with_vars_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_header_line] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_identifier_ref] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_pcal_end_either] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_pcal_end_if] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_pcal_end_while] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_pcal_end_with] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_assumption = 1,
  field_bound = 2,
  field_conclusion = 3,
  field_definition = 4,
  field_definitions = 5,
  field_else = 6,
  field_expr_to_update = 7,
  field_expression = 8,
  field_filter = 9,
  field_generator = 10,
  field_if = 11,
  field_intro = 12,
  field_label = 13,
  field_lhs = 14,
  field_map = 15,
  field_name = 16,
  field_new_val = 17,
  field_op = 18,
  field_parameter = 19,
  field_prefix = 20,
  field_proof = 21,
  field_quantifier = 22,
  field_rhs = 23,
  field_set = 24,
  field_statement = 25,
  field_symbol = 26,
  field_then = 27,
  field_update_specifier = 28,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_assumption] = "assumption",
  [field_bound] = "bound",
  [field_conclusion] = "conclusion",
  [field_definition] = "definition",
  [field_definitions] = "definitions",
  [field_else] = "else",
  [field_expr_to_update] = "expr_to_update",
  [field_expression] = "expression",
  [field_filter] = "filter",
  [field_generator] = "generator",
  [field_if] = "if",
  [field_intro] = "intro",
  [field_label] = "label",
  [field_lhs] = "lhs",
  [field_map] = "map",
  [field_name] = "name",
  [field_new_val] = "new_val",
  [field_op] = "op",
  [field_parameter] = "parameter",
  [field_prefix] = "prefix",
  [field_proof] = "proof",
  [field_quantifier] = "quantifier",
  [field_rhs] = "rhs",
  [field_set] = "set",
  [field_statement] = "statement",
  [field_symbol] = "symbol",
  [field_then] = "then",
  [field_update_specifier] = "update_specifier",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [4] = {.index = 1, .length = 1},
  [5] = {.index = 2, .length = 2},
  [6] = {.index = 4, .length = 1},
  [7] = {.index = 5, .length = 1},
  [9] = {.index = 6, .length = 2},
  [10] = {.index = 8, .length = 2},
  [11] = {.index = 8, .length = 2},
  [12] = {.index = 10, .length = 2},
  [13] = {.index = 12, .length = 2},
  [14] = {.index = 14, .length = 3},
  [15] = {.index = 17, .length = 2},
  [17] = {.index = 19, .length = 3},
  [18] = {.index = 22, .length = 2},
  [19] = {.index = 24, .length = 3},
  [20] = {.index = 27, .length = 1},
  [21] = {.index = 28, .length = 1},
  [22] = {.index = 29, .length = 2},
  [23] = {.index = 31, .length = 4},
  [24] = {.index = 35, .length = 4},
  [25] = {.index = 39, .length = 3},
  [26] = {.index = 35, .length = 4},
  [27] = {.index = 42, .length = 2},
  [28] = {.index = 44, .length = 2},
  [29] = {.index = 46, .length = 3},
  [30] = {.index = 49, .length = 1},
  [31] = {.index = 50, .length = 3},
  [32] = {.index = 53, .length = 2},
  [33] = {.index = 55, .length = 1},
  [34] = {.index = 56, .length = 2},
  [35] = {.index = 58, .length = 2},
  [36] = {.index = 60, .length = 5},
  [37] = {.index = 65, .length = 3},
  [38] = {.index = 68, .length = 2},
  [39] = {.index = 70, .length = 5},
  [40] = {.index = 75, .length = 4},
  [41] = {.index = 70, .length = 5},
  [42] = {.index = 79, .length = 1},
  [43] = {.index = 80, .length = 2},
  [44] = {.index = 82, .length = 2},
  [45] = {.index = 84, .length = 4},
  [46] = {.index = 88, .length = 3},
  [47] = {.index = 91, .length = 6},
  [48] = {.index = 97, .length = 2},
  [49] = {.index = 99, .length = 5},
  [50] = {.index = 104, .length = 3},
  [51] = {.index = 107, .length = 3},
  [52] = {.index = 110, .length = 3},
  [53] = {.index = 113, .length = 2},
  [54] = {.index = 115, .length = 2},
  [55] = {.index = 117, .length = 6},
  [56] = {.index = 123, .length = 3},
  [57] = {.index = 126, .length = 1},
  [58] = {.index = 127, .length = 3},
  [59] = {.index = 130, .length = 2},
  [60] = {.index = 113, .length = 2},
  [61] = {.index = 132, .length = 1},
  [62] = {.index = 133, .length = 1},
  [63] = {.index = 133, .length = 1},
  [64] = {.index = 133, .length = 1},
  [65] = {.index = 55, .length = 1},
  [66] = {.index = 134, .length = 2},
  [67] = {.index = 136, .length = 2},
  [68] = {.index = 138, .length = 1},
  [69] = {.index = 133, .length = 1},
  [70] = {.index = 139, .length = 2},
  [71] = {.index = 141, .length = 1},
  [72] = {.index = 142, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0, .inherited = true},
  [1] =
    {field_statement, 1},
  [2] =
    {field_definition, 2},
    {field_name, 0},
  [4] =
    {field_name, 1},
  [5] =
    {field_name, 0},
  [6] =
    {field_rhs, 1},
    {field_symbol, 0},
  [8] =
    {field_op, 1},
    {field_prefix, 0},
  [10] =
    {field_lhs, 0},
    {field_symbol, 1},
  [12] =
    {field_proof, 2},
    {field_statement, 1},
  [14] =
    {field_definition, 3},
    {field_name, 1},
    {field_parameter, 0},
  [17] =
    {field_expression, 2},
    {field_name, 0},
  [19] =
    {field_lhs, 0},
    {field_rhs, 2},
    {field_symbol, 1},
  [22] =
    {field_name, 1},
    {field_statement, 3},
  [24] =
    {field_definition, 3},
    {field_name, 0},
    {field_parameter, 1},
  [27] =
    {field_label, 1, .inherited = true},
  [28] =
    {field_label, 0, .inherited = true},
  [29] =
    {field_intro, 0},
    {field_set, 2},
  [31] =
    {field_definition, 4},
    {field_name, 1},
    {field_parameter, 0},
    {field_parameter, 2},
  [35] =
    {field_name, 0},
    {field_parameter, 1},
    {field_parameter, 2},
    {field_parameter, 3},
  [39] =
    {field_expression, 3},
    {field_intro, 1},
    {field_quantifier, 0},
  [42] =
    {field_expression, 3},
    {field_intro, 1},
  [44] =
    {field_definitions, 1},
    {field_expression, 3},
  [46] =
    {field_bound, 1},
    {field_expression, 3},
    {field_quantifier, 0},
  [49] =
    {field_symbol, 0},
  [50] =
    {field_name, 1},
    {field_proof, 4},
    {field_statement, 3},
  [53] =
    {field_assumption, 1},
    {field_conclusion, 3},
  [55] =
    {field_name, 2},
  [56] =
    {field_label, 0},
    {field_label, 1},
  [58] =
    {field_label, 0, .inherited = true},
    {field_label, 1, .inherited = true},
  [60] =
    {field_definition, 5},
    {field_name, 0},
    {field_parameter, 1},
    {field_parameter, 2},
    {field_parameter, 3},
  [65] =
    {field_intro, 0},
    {field_intro, 1},
    {field_set, 3},
  [68] =
    {field_definition, 5},
    {field_name, 0},
  [70] =
    {field_name, 0},
    {field_parameter, 1},
    {field_parameter, 2},
    {field_parameter, 3},
    {field_parameter, 4},
  [75] =
    {field_expression, 4},
    {field_intro, 1},
    {field_intro, 2},
    {field_quantifier, 0},
  [79] =
    {field_expr_to_update, 1},
  [80] =
    {field_generator, 3},
    {field_map, 1},
  [82] =
    {field_filter, 3},
    {field_generator, 1},
  [84] =
    {field_bound, 1},
    {field_bound, 2},
    {field_expression, 4},
    {field_quantifier, 0},
  [88] =
    {field_assumption, 1},
    {field_assumption, 2},
    {field_conclusion, 4},
  [91] =
    {field_definition, 6},
    {field_name, 0},
    {field_parameter, 1},
    {field_parameter, 2},
    {field_parameter, 3},
    {field_parameter, 4},
  [97] =
    {field_definition, 6},
    {field_name, 0},
  [99] =
    {field_expression, 5},
    {field_name, 0},
    {field_parameter, 1},
    {field_parameter, 2},
    {field_parameter, 3},
  [104] =
    {field_expression, 5},
    {field_intro, 1},
    {field_set, 3},
  [107] =
    {field_generator, 3},
    {field_generator, 4},
    {field_map, 1},
  [110] =
    {field_else, 5},
    {field_if, 1},
    {field_then, 3},
  [113] =
    {field_label, 1, .inherited = true},
    {field_label, 2, .inherited = true},
  [115] =
    {field_name, 1},
    {field_parameter, 3},
  [117] =
    {field_expression, 6},
    {field_name, 0},
    {field_parameter, 1},
    {field_parameter, 2},
    {field_parameter, 3},
    {field_parameter, 4},
  [123] =
    {field_new_val, 3},
    {field_update_specifier, 0},
    {field_update_specifier, 1},
  [126] =
    {field_parameter, 1},
  [127] =
    {field_name, 1},
    {field_parameter, 3},
    {field_parameter, 4, .inherited = true},
  [130] =
    {field_parameter, 0, .inherited = true},
    {field_parameter, 1, .inherited = true},
  [132] =
    {field_label, 4, .inherited = true},
  [133] =
    {field_label, 3, .inherited = true},
  [134] =
    {field_label, 3, .inherited = true},
    {field_label, 4, .inherited = true},
  [136] =
    {field_label, 4, .inherited = true},
    {field_label, 6, .inherited = true},
  [138] =
    {field_name, 3},
  [139] =
    {field_label, 3, .inherited = true},
    {field_label, 5, .inherited = true},
  [141] =
    {field_name, 4},
  [142] =
    {field_label, 3, .inherited = true},
    {field_label, 4, .inherited = true},
    {field_label, 6, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [2] = {
    [1] = alias_sym_identifier_ref,
  },
  [3] = {
    [0] = alias_sym_identifier_ref,
  },
  [8] = {
    [0] = anon_sym_BSLASHb,
  },
  [10] = {
    [1] = alias_sym_identifier_ref,
  },
  [16] = {
    [2] = alias_sym_identifier_ref,
  },
  [26] = {
    [0] = alias_sym_identifier_ref,
  },
  [33] = {
    [0] = alias_sym_header_line,
    [3] = alias_sym_header_line,
  },
  [41] = {
    [0] = alias_sym_identifier_ref,
  },
  [49] = {
    [2] = alias_sym_identifier_ref,
  },
  [55] = {
    [2] = alias_sym_identifier_ref,
  },
  [60] = {
    [3] = alias_sym_pcal_end_either,
  },
  [62] = {
    [4] = alias_sym_pcal_end_if,
  },
  [63] = {
    [4] = alias_sym_pcal_end_while,
  },
  [64] = {
    [4] = alias_sym_pcal_end_with,
  },
  [66] = {
    [5] = alias_sym_pcal_end_if,
  },
  [70] = {
    [6] = alias_sym_pcal_end_if,
  },
  [72] = {
    [7] = alias_sym_pcal_end_if,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_single_line, 2,
    sym_single_line,
    alias_sym_header_line,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 2,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 6,
  [9] = 9,
  [10] = 9,
  [11] = 7,
  [12] = 12,
  [13] = 13,
  [14] = 13,
  [15] = 13,
  [16] = 13,
  [17] = 17,
  [18] = 18,
  [19] = 17,
  [20] = 17,
  [21] = 18,
  [22] = 18,
  [23] = 23,
  [24] = 23,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 27,
  [29] = 27,
  [30] = 25,
  [31] = 23,
  [32] = 25,
  [33] = 33,
  [34] = 33,
  [35] = 35,
  [36] = 35,
  [37] = 33,
  [38] = 35,
  [39] = 7,
  [40] = 40,
  [41] = 9,
  [42] = 6,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 44,
  [48] = 46,
  [49] = 44,
  [50] = 43,
  [51] = 6,
  [52] = 7,
  [53] = 9,
  [54] = 54,
  [55] = 46,
  [56] = 44,
  [57] = 6,
  [58] = 7,
  [59] = 9,
  [60] = 60,
  [61] = 54,
  [62] = 45,
  [63] = 63,
  [64] = 63,
  [65] = 46,
  [66] = 54,
  [67] = 44,
  [68] = 54,
  [69] = 54,
  [70] = 54,
  [71] = 54,
  [72] = 54,
  [73] = 54,
  [74] = 54,
  [75] = 54,
  [76] = 54,
  [77] = 54,
  [78] = 54,
  [79] = 54,
  [80] = 54,
  [81] = 54,
  [82] = 82,
  [83] = 43,
  [84] = 63,
  [85] = 82,
  [86] = 43,
  [87] = 46,
  [88] = 82,
  [89] = 43,
  [90] = 63,
  [91] = 82,
  [92] = 43,
  [93] = 63,
  [94] = 82,
  [95] = 43,
  [96] = 63,
  [97] = 82,
  [98] = 43,
  [99] = 63,
  [100] = 82,
  [101] = 43,
  [102] = 63,
  [103] = 82,
  [104] = 43,
  [105] = 63,
  [106] = 82,
  [107] = 43,
  [108] = 63,
  [109] = 82,
  [110] = 43,
  [111] = 63,
  [112] = 82,
  [113] = 43,
  [114] = 63,
  [115] = 82,
  [116] = 43,
  [117] = 63,
  [118] = 82,
  [119] = 82,
  [120] = 63,
  [121] = 82,
  [122] = 43,
  [123] = 63,
  [124] = 82,
  [125] = 43,
  [126] = 63,
  [127] = 43,
  [128] = 46,
  [129] = 44,
  [130] = 63,
  [131] = 131,
  [132] = 7,
  [133] = 9,
  [134] = 134,
  [135] = 135,
  [136] = 131,
  [137] = 134,
  [138] = 135,
  [139] = 131,
  [140] = 134,
  [141] = 135,
  [142] = 134,
  [143] = 135,
  [144] = 131,
  [145] = 134,
  [146] = 134,
  [147] = 135,
  [148] = 131,
  [149] = 134,
  [150] = 135,
  [151] = 131,
  [152] = 134,
  [153] = 135,
  [154] = 131,
  [155] = 6,
  [156] = 135,
  [157] = 131,
  [158] = 134,
  [159] = 135,
  [160] = 131,
  [161] = 134,
  [162] = 135,
  [163] = 131,
  [164] = 134,
  [165] = 135,
  [166] = 131,
  [167] = 134,
  [168] = 135,
  [169] = 131,
  [170] = 134,
  [171] = 135,
  [172] = 131,
  [173] = 134,
  [174] = 135,
  [175] = 131,
  [176] = 134,
  [177] = 135,
  [178] = 131,
  [179] = 134,
  [180] = 131,
  [181] = 6,
  [182] = 7,
  [183] = 9,
  [184] = 135,
  [185] = 134,
  [186] = 186,
  [187] = 187,
  [188] = 186,
  [189] = 189,
  [190] = 190,
  [191] = 187,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 189,
  [196] = 190,
  [197] = 187,
  [198] = 198,
  [199] = 187,
  [200] = 189,
  [201] = 201,
  [202] = 194,
  [203] = 193,
  [204] = 189,
  [205] = 187,
  [206] = 194,
  [207] = 189,
  [208] = 190,
  [209] = 198,
  [210] = 190,
  [211] = 194,
  [212] = 194,
  [213] = 194,
  [214] = 190,
  [215] = 194,
  [216] = 194,
  [217] = 194,
  [218] = 194,
  [219] = 194,
  [220] = 194,
  [221] = 194,
  [222] = 194,
  [223] = 194,
  [224] = 194,
  [225] = 194,
  [226] = 198,
  [227] = 6,
  [228] = 6,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 9,
  [233] = 230,
  [234] = 234,
  [235] = 231,
  [236] = 6,
  [237] = 231,
  [238] = 231,
  [239] = 230,
  [240] = 231,
  [241] = 231,
  [242] = 230,
  [243] = 231,
  [244] = 231,
  [245] = 7,
  [246] = 230,
  [247] = 6,
  [248] = 7,
  [249] = 9,
  [250] = 6,
  [251] = 7,
  [252] = 9,
  [253] = 6,
  [254] = 7,
  [255] = 9,
  [256] = 6,
  [257] = 7,
  [258] = 9,
  [259] = 6,
  [260] = 7,
  [261] = 9,
  [262] = 6,
  [263] = 7,
  [264] = 9,
  [265] = 6,
  [266] = 7,
  [267] = 9,
  [268] = 9,
  [269] = 6,
  [270] = 7,
  [271] = 230,
  [272] = 6,
  [273] = 7,
  [274] = 9,
  [275] = 6,
  [276] = 7,
  [277] = 9,
  [278] = 6,
  [279] = 7,
  [280] = 9,
  [281] = 231,
  [282] = 230,
  [283] = 231,
  [284] = 6,
  [285] = 7,
  [286] = 9,
  [287] = 6,
  [288] = 231,
  [289] = 230,
  [290] = 7,
  [291] = 230,
  [292] = 9,
  [293] = 230,
  [294] = 294,
  [295] = 231,
  [296] = 230,
  [297] = 7,
  [298] = 230,
  [299] = 9,
  [300] = 300,
  [301] = 231,
  [302] = 231,
  [303] = 231,
  [304] = 230,
  [305] = 230,
  [306] = 230,
  [307] = 230,
  [308] = 231,
  [309] = 7,
  [310] = 9,
  [311] = 311,
  [312] = 312,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 321,
  [322] = 322,
  [323] = 323,
  [324] = 324,
  [325] = 325,
  [326] = 326,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 338,
  [339] = 339,
  [340] = 314,
  [341] = 341,
  [342] = 342,
  [343] = 311,
  [344] = 344,
  [345] = 345,
  [346] = 312,
  [347] = 313,
  [348] = 316,
  [349] = 317,
  [350] = 318,
  [351] = 319,
  [352] = 321,
  [353] = 353,
  [354] = 354,
  [355] = 341,
  [356] = 325,
  [357] = 326,
  [358] = 327,
  [359] = 328,
  [360] = 329,
  [361] = 330,
  [362] = 331,
  [363] = 332,
  [364] = 333,
  [365] = 334,
  [366] = 335,
  [367] = 336,
  [368] = 337,
  [369] = 338,
  [370] = 339,
  [371] = 314,
  [372] = 341,
  [373] = 342,
  [374] = 311,
  [375] = 342,
  [376] = 312,
  [377] = 313,
  [378] = 316,
  [379] = 317,
  [380] = 318,
  [381] = 319,
  [382] = 321,
  [383] = 311,
  [384] = 325,
  [385] = 326,
  [386] = 327,
  [387] = 328,
  [388] = 329,
  [389] = 330,
  [390] = 331,
  [391] = 332,
  [392] = 333,
  [393] = 334,
  [394] = 335,
  [395] = 336,
  [396] = 337,
  [397] = 338,
  [398] = 339,
  [399] = 314,
  [400] = 341,
  [401] = 342,
  [402] = 311,
  [403] = 312,
  [404] = 313,
  [405] = 316,
  [406] = 317,
  [407] = 318,
  [408] = 319,
  [409] = 321,
  [410] = 325,
  [411] = 326,
  [412] = 327,
  [413] = 328,
  [414] = 329,
  [415] = 330,
  [416] = 331,
  [417] = 332,
  [418] = 333,
  [419] = 334,
  [420] = 335,
  [421] = 336,
  [422] = 337,
  [423] = 338,
  [424] = 339,
  [425] = 314,
  [426] = 341,
  [427] = 342,
  [428] = 311,
  [429] = 312,
  [430] = 313,
  [431] = 316,
  [432] = 317,
  [433] = 318,
  [434] = 319,
  [435] = 321,
  [436] = 325,
  [437] = 326,
  [438] = 327,
  [439] = 328,
  [440] = 329,
  [441] = 330,
  [442] = 331,
  [443] = 332,
  [444] = 333,
  [445] = 334,
  [446] = 335,
  [447] = 336,
  [448] = 337,
  [449] = 338,
  [450] = 339,
  [451] = 314,
  [452] = 341,
  [453] = 342,
  [454] = 311,
  [455] = 312,
  [456] = 313,
  [457] = 316,
  [458] = 317,
  [459] = 318,
  [460] = 319,
  [461] = 321,
  [462] = 325,
  [463] = 326,
  [464] = 327,
  [465] = 328,
  [466] = 329,
  [467] = 330,
  [468] = 331,
  [469] = 332,
  [470] = 333,
  [471] = 334,
  [472] = 335,
  [473] = 336,
  [474] = 337,
  [475] = 338,
  [476] = 339,
  [477] = 314,
  [478] = 341,
  [479] = 342,
  [480] = 311,
  [481] = 312,
  [482] = 313,
  [483] = 316,
  [484] = 317,
  [485] = 318,
  [486] = 319,
  [487] = 321,
  [488] = 488,
  [489] = 325,
  [490] = 326,
  [491] = 327,
  [492] = 328,
  [493] = 329,
  [494] = 330,
  [495] = 331,
  [496] = 332,
  [497] = 333,
  [498] = 334,
  [499] = 335,
  [500] = 336,
  [501] = 337,
  [502] = 338,
  [503] = 339,
  [504] = 314,
  [505] = 341,
  [506] = 342,
  [507] = 311,
  [508] = 312,
  [509] = 313,
  [510] = 316,
  [511] = 317,
  [512] = 318,
  [513] = 319,
  [514] = 321,
  [515] = 515,
  [516] = 516,
  [517] = 325,
  [518] = 326,
  [519] = 327,
  [520] = 328,
  [521] = 329,
  [522] = 330,
  [523] = 331,
  [524] = 332,
  [525] = 333,
  [526] = 334,
  [527] = 335,
  [528] = 336,
  [529] = 337,
  [530] = 338,
  [531] = 339,
  [532] = 314,
  [533] = 341,
  [534] = 342,
  [535] = 311,
  [536] = 312,
  [537] = 313,
  [538] = 316,
  [539] = 317,
  [540] = 318,
  [541] = 319,
  [542] = 321,
  [543] = 543,
  [544] = 325,
  [545] = 326,
  [546] = 327,
  [547] = 328,
  [548] = 329,
  [549] = 330,
  [550] = 331,
  [551] = 332,
  [552] = 333,
  [553] = 334,
  [554] = 335,
  [555] = 336,
  [556] = 337,
  [557] = 338,
  [558] = 339,
  [559] = 314,
  [560] = 341,
  [561] = 342,
  [562] = 311,
  [563] = 312,
  [564] = 313,
  [565] = 316,
  [566] = 317,
  [567] = 318,
  [568] = 319,
  [569] = 321,
  [570] = 570,
  [571] = 571,
  [572] = 325,
  [573] = 326,
  [574] = 327,
  [575] = 328,
  [576] = 329,
  [577] = 330,
  [578] = 331,
  [579] = 332,
  [580] = 333,
  [581] = 334,
  [582] = 335,
  [583] = 336,
  [584] = 337,
  [585] = 338,
  [586] = 339,
  [587] = 314,
  [588] = 341,
  [589] = 342,
  [590] = 311,
  [591] = 312,
  [592] = 313,
  [593] = 593,
  [594] = 316,
  [595] = 317,
  [596] = 318,
  [597] = 319,
  [598] = 321,
  [599] = 599,
  [600] = 600,
  [601] = 326,
  [602] = 325,
  [603] = 326,
  [604] = 327,
  [605] = 328,
  [606] = 329,
  [607] = 330,
  [608] = 331,
  [609] = 332,
  [610] = 333,
  [611] = 334,
  [612] = 335,
  [613] = 336,
  [614] = 337,
  [615] = 338,
  [616] = 339,
  [617] = 314,
  [618] = 341,
  [619] = 342,
  [620] = 311,
  [621] = 312,
  [622] = 313,
  [623] = 316,
  [624] = 317,
  [625] = 318,
  [626] = 319,
  [627] = 321,
  [628] = 628,
  [629] = 629,
  [630] = 325,
  [631] = 326,
  [632] = 327,
  [633] = 328,
  [634] = 329,
  [635] = 330,
  [636] = 331,
  [637] = 332,
  [638] = 333,
  [639] = 334,
  [640] = 335,
  [641] = 336,
  [642] = 337,
  [643] = 338,
  [644] = 339,
  [645] = 314,
  [646] = 341,
  [647] = 342,
  [648] = 648,
  [649] = 312,
  [650] = 313,
  [651] = 316,
  [652] = 317,
  [653] = 318,
  [654] = 319,
  [655] = 321,
  [656] = 325,
  [657] = 326,
  [658] = 327,
  [659] = 328,
  [660] = 329,
  [661] = 330,
  [662] = 331,
  [663] = 332,
  [664] = 333,
  [665] = 334,
  [666] = 335,
  [667] = 336,
  [668] = 337,
  [669] = 338,
  [670] = 339,
  [671] = 314,
  [672] = 341,
  [673] = 342,
  [674] = 311,
  [675] = 312,
  [676] = 313,
  [677] = 316,
  [678] = 317,
  [679] = 318,
  [680] = 319,
  [681] = 321,
  [682] = 312,
  [683] = 683,
  [684] = 313,
  [685] = 685,
  [686] = 686,
  [687] = 687,
  [688] = 315,
  [689] = 689,
  [690] = 690,
  [691] = 691,
  [692] = 692,
  [693] = 693,
  [694] = 694,
  [695] = 695,
  [696] = 327,
  [697] = 328,
  [698] = 698,
  [699] = 699,
  [700] = 324,
  [701] = 316,
  [702] = 702,
  [703] = 515,
  [704] = 628,
  [705] = 317,
  [706] = 687,
  [707] = 318,
  [708] = 319,
  [709] = 488,
  [710] = 516,
  [711] = 329,
  [712] = 712,
  [713] = 713,
  [714] = 629,
  [715] = 689,
  [716] = 716,
  [717] = 698,
  [718] = 718,
  [719] = 315,
  [720] = 320,
  [721] = 330,
  [722] = 722,
  [723] = 723,
  [724] = 331,
  [725] = 699,
  [726] = 324,
  [727] = 515,
  [728] = 628,
  [729] = 320,
  [730] = 687,
  [731] = 718,
  [732] = 732,
  [733] = 488,
  [734] = 516,
  [735] = 712,
  [736] = 713,
  [737] = 737,
  [738] = 629,
  [739] = 689,
  [740] = 740,
  [741] = 698,
  [742] = 718,
  [743] = 315,
  [744] = 320,
  [745] = 745,
  [746] = 332,
  [747] = 693,
  [748] = 321,
  [749] = 687,
  [750] = 750,
  [751] = 488,
  [752] = 516,
  [753] = 712,
  [754] = 713,
  [755] = 629,
  [756] = 689,
  [757] = 698,
  [758] = 718,
  [759] = 315,
  [760] = 320,
  [761] = 333,
  [762] = 334,
  [763] = 763,
  [764] = 764,
  [765] = 765,
  [766] = 315,
  [767] = 320,
  [768] = 335,
  [769] = 769,
  [770] = 770,
  [771] = 771,
  [772] = 772,
  [773] = 773,
  [774] = 336,
  [775] = 775,
  [776] = 776,
  [777] = 777,
  [778] = 337,
  [779] = 338,
  [780] = 325,
  [781] = 488,
  [782] = 516,
  [783] = 543,
  [784] = 326,
  [785] = 327,
  [786] = 328,
  [787] = 329,
  [788] = 330,
  [789] = 331,
  [790] = 332,
  [791] = 333,
  [792] = 334,
  [793] = 335,
  [794] = 336,
  [795] = 337,
  [796] = 338,
  [797] = 797,
  [798] = 648,
  [799] = 712,
  [800] = 713,
  [801] = 339,
  [802] = 314,
  [803] = 341,
  [804] = 342,
  [805] = 311,
  [806] = 345,
  [807] = 325,
  [808] = 808,
  [809] = 692,
  [810] = 797,
  [811] = 811,
  [812] = 812,
  [813] = 813,
  [814] = 814,
  [815] = 322,
  [816] = 344,
  [817] = 353,
  [818] = 354,
  [819] = 683,
  [820] = 685,
  [821] = 345,
  [822] = 629,
  [823] = 692,
  [824] = 797,
  [825] = 811,
  [826] = 812,
  [827] = 813,
  [828] = 814,
  [829] = 322,
  [830] = 344,
  [831] = 712,
  [832] = 353,
  [833] = 354,
  [834] = 683,
  [835] = 685,
  [836] = 345,
  [837] = 699,
  [838] = 692,
  [839] = 797,
  [840] = 811,
  [841] = 812,
  [842] = 813,
  [843] = 814,
  [844] = 322,
  [845] = 344,
  [846] = 312,
  [847] = 353,
  [848] = 354,
  [849] = 683,
  [850] = 685,
  [851] = 345,
  [852] = 692,
  [853] = 797,
  [854] = 811,
  [855] = 812,
  [856] = 813,
  [857] = 814,
  [858] = 322,
  [859] = 344,
  [860] = 353,
  [861] = 354,
  [862] = 683,
  [863] = 685,
  [864] = 345,
  [865] = 313,
  [866] = 692,
  [867] = 797,
  [868] = 811,
  [869] = 812,
  [870] = 813,
  [871] = 814,
  [872] = 322,
  [873] = 344,
  [874] = 713,
  [875] = 353,
  [876] = 354,
  [877] = 683,
  [878] = 685,
  [879] = 345,
  [880] = 315,
  [881] = 689,
  [882] = 692,
  [883] = 797,
  [884] = 811,
  [885] = 812,
  [886] = 813,
  [887] = 814,
  [888] = 322,
  [889] = 344,
  [890] = 353,
  [891] = 354,
  [892] = 683,
  [893] = 685,
  [894] = 345,
  [895] = 698,
  [896] = 692,
  [897] = 797,
  [898] = 811,
  [899] = 812,
  [900] = 813,
  [901] = 814,
  [902] = 322,
  [903] = 344,
  [904] = 316,
  [905] = 353,
  [906] = 354,
  [907] = 683,
  [908] = 685,
  [909] = 345,
  [910] = 317,
  [911] = 318,
  [912] = 692,
  [913] = 797,
  [914] = 811,
  [915] = 812,
  [916] = 813,
  [917] = 814,
  [918] = 322,
  [919] = 344,
  [920] = 319,
  [921] = 353,
  [922] = 354,
  [923] = 683,
  [924] = 685,
  [925] = 345,
  [926] = 320,
  [927] = 692,
  [928] = 797,
  [929] = 811,
  [930] = 812,
  [931] = 813,
  [932] = 814,
  [933] = 322,
  [934] = 344,
  [935] = 718,
  [936] = 353,
  [937] = 354,
  [938] = 683,
  [939] = 685,
  [940] = 345,
  [941] = 321,
  [942] = 692,
  [943] = 797,
  [944] = 811,
  [945] = 812,
  [946] = 813,
  [947] = 814,
  [948] = 322,
  [949] = 344,
  [950] = 353,
  [951] = 354,
  [952] = 683,
  [953] = 685,
  [954] = 345,
  [955] = 692,
  [956] = 797,
  [957] = 811,
  [958] = 812,
  [959] = 813,
  [960] = 814,
  [961] = 322,
  [962] = 344,
  [963] = 353,
  [964] = 354,
  [965] = 683,
  [966] = 685,
  [967] = 345,
  [968] = 968,
  [969] = 969,
  [970] = 692,
  [971] = 797,
  [972] = 811,
  [973] = 812,
  [974] = 813,
  [975] = 814,
  [976] = 322,
  [977] = 344,
  [978] = 339,
  [979] = 353,
  [980] = 354,
  [981] = 683,
  [982] = 685,
  [983] = 345,
  [984] = 325,
  [985] = 692,
  [986] = 797,
  [987] = 811,
  [988] = 812,
  [989] = 813,
  [990] = 814,
  [991] = 322,
  [992] = 344,
  [993] = 326,
  [994] = 353,
  [995] = 354,
  [996] = 683,
  [997] = 685,
  [998] = 345,
  [999] = 327,
  [1000] = 692,
  [1001] = 797,
  [1002] = 811,
  [1003] = 812,
  [1004] = 813,
  [1005] = 814,
  [1006] = 322,
  [1007] = 344,
  [1008] = 328,
  [1009] = 353,
  [1010] = 354,
  [1011] = 683,
  [1012] = 685,
  [1013] = 345,
  [1014] = 329,
  [1015] = 330,
  [1016] = 692,
  [1017] = 797,
  [1018] = 811,
  [1019] = 812,
  [1020] = 813,
  [1021] = 814,
  [1022] = 322,
  [1023] = 344,
  [1024] = 331,
  [1025] = 353,
  [1026] = 354,
  [1027] = 683,
  [1028] = 685,
  [1029] = 345,
  [1030] = 332,
  [1031] = 797,
  [1032] = 811,
  [1033] = 812,
  [1034] = 813,
  [1035] = 814,
  [1036] = 344,
  [1037] = 683,
  [1038] = 685,
  [1039] = 333,
  [1040] = 334,
  [1041] = 335,
  [1042] = 336,
  [1043] = 337,
  [1044] = 338,
  [1045] = 339,
  [1046] = 314,
  [1047] = 341,
  [1048] = 342,
  [1049] = 311,
  [1050] = 811,
  [1051] = 812,
  [1052] = 813,
  [1053] = 814,
  [1054] = 808,
  [1055] = 648,
  [1056] = 808,
  [1057] = 648,
  [1058] = 808,
  [1059] = 648,
  [1060] = 808,
  [1061] = 648,
  [1062] = 808,
  [1063] = 648,
  [1064] = 808,
  [1065] = 648,
  [1066] = 808,
  [1067] = 648,
  [1068] = 808,
  [1069] = 648,
  [1070] = 808,
  [1071] = 648,
  [1072] = 808,
  [1073] = 648,
  [1074] = 808,
  [1075] = 648,
  [1076] = 808,
  [1077] = 648,
  [1078] = 808,
  [1079] = 648,
  [1080] = 808,
  [1081] = 648,
  [1082] = 808,
  [1083] = 648,
  [1084] = 515,
  [1085] = 1085,
  [1086] = 1085,
  [1087] = 1085,
  [1088] = 1085,
  [1089] = 1085,
  [1090] = 1085,
  [1091] = 1085,
  [1092] = 1085,
  [1093] = 1085,
  [1094] = 1085,
  [1095] = 1085,
  [1096] = 1085,
  [1097] = 1085,
  [1098] = 1085,
  [1099] = 1085,
  [1100] = 1085,
  [1101] = 1101,
  [1102] = 1101,
  [1103] = 1103,
  [1104] = 1103,
  [1105] = 1105,
  [1106] = 1106,
  [1107] = 1107,
  [1108] = 1107,
  [1109] = 1105,
  [1110] = 1110,
  [1111] = 1111,
  [1112] = 1112,
  [1113] = 1111,
  [1114] = 1112,
  [1115] = 1110,
  [1116] = 1111,
  [1117] = 1111,
  [1118] = 1111,
  [1119] = 1112,
  [1120] = 1112,
  [1121] = 1111,
  [1122] = 1112,
  [1123] = 1111,
  [1124] = 1112,
  [1125] = 1112,
  [1126] = 1112,
  [1127] = 1112,
  [1128] = 1111,
  [1129] = 1112,
  [1130] = 1111,
  [1131] = 1111,
  [1132] = 1112,
  [1133] = 1112,
  [1134] = 1112,
  [1135] = 1112,
  [1136] = 1111,
  [1137] = 1112,
  [1138] = 1111,
  [1139] = 1112,
  [1140] = 1111,
  [1141] = 1110,
  [1142] = 1110,
  [1143] = 1111,
  [1144] = 1110,
  [1145] = 1111,
  [1146] = 1110,
  [1147] = 1112,
  [1148] = 1110,
  [1149] = 1110,
  [1150] = 1110,
  [1151] = 1110,
  [1152] = 1111,
  [1153] = 1110,
  [1154] = 1110,
  [1155] = 1110,
  [1156] = 1110,
  [1157] = 1110,
  [1158] = 1110,
  [1159] = 1111,
  [1160] = 1160,
  [1161] = 1161,
  [1162] = 1162,
  [1163] = 1163,
  [1164] = 1164,
  [1165] = 1165,
  [1166] = 1166,
  [1167] = 1167,
  [1168] = 1168,
  [1169] = 1169,
  [1170] = 1170,
  [1171] = 1171,
  [1172] = 1172,
  [1173] = 1173,
  [1174] = 1163,
  [1175] = 1175,
  [1176] = 1164,
  [1177] = 1165,
  [1178] = 1167,
  [1179] = 1179,
  [1180] = 1180,
  [1181] = 1181,
  [1182] = 1182,
  [1183] = 1183,
  [1184] = 1184,
  [1185] = 1185,
  [1186] = 1186,
  [1187] = 1187,
  [1188] = 1188,
  [1189] = 1189,
  [1190] = 1172,
  [1191] = 1191,
  [1192] = 1192,
  [1193] = 1168,
  [1194] = 1161,
  [1195] = 1162,
  [1196] = 1196,
  [1197] = 1180,
  [1198] = 1196,
  [1199] = 1199,
  [1200] = 1169,
  [1201] = 1170,
  [1202] = 1202,
  [1203] = 1191,
  [1204] = 1192,
  [1205] = 1171,
  [1206] = 1175,
  [1207] = 1166,
  [1208] = 1199,
  [1209] = 1160,
  [1210] = 1179,
  [1211] = 1181,
  [1212] = 1189,
  [1213] = 1182,
  [1214] = 1183,
  [1215] = 1173,
  [1216] = 1202,
  [1217] = 1184,
  [1218] = 1185,
  [1219] = 1186,
  [1220] = 1187,
  [1221] = 1188,
  [1222] = 1222,
  [1223] = 1222,
  [1224] = 1183,
  [1225] = 1165,
  [1226] = 1188,
  [1227] = 1187,
  [1228] = 1171,
  [1229] = 1189,
  [1230] = 1180,
  [1231] = 1188,
  [1232] = 1175,
  [1233] = 1166,
  [1234] = 1160,
  [1235] = 1166,
  [1236] = 1179,
  [1237] = 1237,
  [1238] = 1169,
  [1239] = 1173,
  [1240] = 1161,
  [1241] = 1163,
  [1242] = 1164,
  [1243] = 1165,
  [1244] = 1167,
  [1245] = 1189,
  [1246] = 1237,
  [1247] = 1172,
  [1248] = 1186,
  [1249] = 1169,
  [1250] = 1180,
  [1251] = 1175,
  [1252] = 1181,
  [1253] = 1184,
  [1254] = 1182,
  [1255] = 1187,
  [1256] = 1173,
  [1257] = 1185,
  [1258] = 1161,
  [1259] = 1160,
  [1260] = 1162,
  [1261] = 1179,
  [1262] = 1170,
  [1263] = 1191,
  [1264] = 1192,
  [1265] = 1191,
  [1266] = 1181,
  [1267] = 1192,
  [1268] = 1162,
  [1269] = 1172,
  [1270] = 1163,
  [1271] = 1171,
  [1272] = 1184,
  [1273] = 1185,
  [1274] = 1199,
  [1275] = 1199,
  [1276] = 1182,
  [1277] = 1202,
  [1278] = 1167,
  [1279] = 1186,
  [1280] = 1202,
  [1281] = 1170,
  [1282] = 1164,
  [1283] = 1183,
  [1284] = 1284,
  [1285] = 1285,
  [1286] = 1284,
  [1287] = 1285,
  [1288] = 1288,
  [1289] = 1288,
  [1290] = 1290,
  [1291] = 1290,
  [1292] = 1292,
  [1293] = 1293,
  [1294] = 1294,
  [1295] = 1295,
  [1296] = 1293,
  [1297] = 1297,
  [1298] = 1298,
  [1299] = 1295,
  [1300] = 1300,
  [1301] = 1301,
  [1302] = 1292,
  [1303] = 1298,
  [1304] = 1300,
  [1305] = 1301,
  [1306] = 1306,
  [1307] = 1297,
  [1308] = 1294,
  [1309] = 1306,
  [1310] = 1310,
  [1311] = 1310,
  [1312] = 1310,
  [1313] = 1310,
  [1314] = 1310,
  [1315] = 1310,
  [1316] = 1310,
  [1317] = 1310,
  [1318] = 1310,
  [1319] = 1310,
  [1320] = 1310,
  [1321] = 1310,
  [1322] = 1310,
  [1323] = 1310,
  [1324] = 1310,
  [1325] = 1310,
  [1326] = 1310,
  [1327] = 1166,
  [1328] = 1161,
  [1329] = 1162,
  [1330] = 1170,
  [1331] = 1171,
  [1332] = 1175,
  [1333] = 1160,
  [1334] = 1179,
  [1335] = 1181,
  [1336] = 1182,
  [1337] = 1183,
  [1338] = 1184,
  [1339] = 1185,
  [1340] = 1186,
  [1341] = 1187,
  [1342] = 1188,
  [1343] = 1189,
  [1344] = 1172,
  [1345] = 1180,
  [1346] = 1191,
  [1347] = 1192,
  [1348] = 1199,
  [1349] = 1202,
  [1350] = 1169,
  [1351] = 1173,
  [1352] = 1163,
  [1353] = 1164,
  [1354] = 1165,
  [1355] = 1288,
  [1356] = 1161,
  [1357] = 1162,
  [1358] = 1170,
  [1359] = 1171,
  [1360] = 1175,
  [1361] = 1160,
  [1362] = 1179,
  [1363] = 1181,
  [1364] = 1182,
  [1365] = 1183,
  [1366] = 1184,
  [1367] = 1185,
  [1368] = 1186,
  [1369] = 1187,
  [1370] = 1188,
  [1371] = 1189,
  [1372] = 1172,
  [1373] = 1180,
  [1374] = 1191,
  [1375] = 1192,
  [1376] = 1199,
  [1377] = 1202,
  [1378] = 1166,
  [1379] = 1169,
  [1380] = 1173,
  [1381] = 1163,
  [1382] = 1164,
  [1383] = 1165,
  [1384] = 1167,
  [1385] = 1285,
  [1386] = 1284,
  [1387] = 1167,
  [1388] = 1300,
  [1389] = 1175,
  [1390] = 1293,
  [1391] = 1160,
  [1392] = 1179,
  [1393] = 1181,
  [1394] = 1182,
  [1395] = 1183,
  [1396] = 1184,
  [1397] = 1185,
  [1398] = 1186,
  [1399] = 1187,
  [1400] = 1188,
  [1401] = 1189,
  [1402] = 1172,
  [1403] = 1180,
  [1404] = 1161,
  [1405] = 1295,
  [1406] = 1191,
  [1407] = 1192,
  [1408] = 1199,
  [1409] = 1202,
  [1410] = 1166,
  [1411] = 1292,
  [1412] = 1297,
  [1413] = 1169,
  [1414] = 1173,
  [1415] = 1288,
  [1416] = 1301,
  [1417] = 1163,
  [1418] = 1164,
  [1419] = 1165,
  [1420] = 1167,
  [1421] = 1290,
  [1422] = 1162,
  [1423] = 1170,
  [1424] = 1171,
  [1425] = 1285,
  [1426] = 1284,
  [1427] = 1298,
  [1428] = 1284,
  [1429] = 1295,
  [1430] = 1292,
  [1431] = 1297,
  [1432] = 1300,
  [1433] = 1301,
  [1434] = 1285,
  [1435] = 1290,
  [1436] = 1161,
  [1437] = 1162,
  [1438] = 1288,
  [1439] = 1170,
  [1440] = 1171,
  [1441] = 1175,
  [1442] = 1160,
  [1443] = 1179,
  [1444] = 1181,
  [1445] = 1182,
  [1446] = 1183,
  [1447] = 1184,
  [1448] = 1185,
  [1449] = 1186,
  [1450] = 1187,
  [1451] = 1188,
  [1452] = 1189,
  [1453] = 1172,
  [1454] = 1180,
  [1455] = 1191,
  [1456] = 1192,
  [1457] = 1199,
  [1458] = 1202,
  [1459] = 1166,
  [1460] = 1169,
  [1461] = 1173,
  [1462] = 1163,
  [1463] = 1164,
  [1464] = 1165,
  [1465] = 1167,
  [1466] = 1293,
  [1467] = 1298,
  [1468] = 1301,
  [1469] = 1290,
  [1470] = 1293,
  [1471] = 1298,
  [1472] = 1295,
  [1473] = 1292,
  [1474] = 1297,
  [1475] = 1300,
  [1476] = 1476,
  [1477] = 1477,
  [1478] = 1477,
  [1479] = 1476,
  [1480] = 1477,
  [1481] = 1476,
  [1482] = 1476,
  [1483] = 1476,
  [1484] = 1476,
  [1485] = 1477,
  [1486] = 1477,
  [1487] = 1477,
  [1488] = 1488,
  [1489] = 1489,
  [1490] = 1165,
  [1491] = 1182,
  [1492] = 1166,
  [1493] = 1169,
  [1494] = 1173,
  [1495] = 1163,
  [1496] = 1164,
  [1497] = 1161,
  [1498] = 1183,
  [1499] = 1184,
  [1500] = 1167,
  [1501] = 1185,
  [1502] = 1186,
  [1503] = 1187,
  [1504] = 1188,
  [1505] = 1189,
  [1506] = 1172,
  [1507] = 1180,
  [1508] = 1191,
  [1509] = 1192,
  [1510] = 1162,
  [1511] = 1170,
  [1512] = 1171,
  [1513] = 1199,
  [1514] = 1175,
  [1515] = 1160,
  [1516] = 1179,
  [1517] = 1181,
  [1518] = 1202,
  [1519] = 1519,
  [1520] = 1519,
  [1521] = 1519,
  [1522] = 1519,
  [1523] = 1519,
  [1524] = 1519,
  [1525] = 1519,
  [1526] = 1519,
  [1527] = 1519,
  [1528] = 1519,
  [1529] = 1519,
  [1530] = 1519,
  [1531] = 1519,
  [1532] = 1519,
  [1533] = 1519,
  [1534] = 1519,
  [1535] = 1519,
  [1536] = 1164,
  [1537] = 1182,
  [1538] = 1183,
  [1539] = 1184,
  [1540] = 1185,
  [1541] = 1186,
  [1542] = 1187,
  [1543] = 1188,
  [1544] = 1189,
  [1545] = 1172,
  [1546] = 1162,
  [1547] = 1547,
  [1548] = 1180,
  [1549] = 1191,
  [1550] = 1192,
  [1551] = 1199,
  [1552] = 1202,
  [1553] = 1553,
  [1554] = 1170,
  [1555] = 1166,
  [1556] = 1169,
  [1557] = 1171,
  [1558] = 1161,
  [1559] = 1175,
  [1560] = 1173,
  [1561] = 1163,
  [1562] = 1160,
  [1563] = 1165,
  [1564] = 1167,
  [1565] = 1179,
  [1566] = 1181,
  [1567] = 1567,
  [1568] = 1568,
  [1569] = 1163,
  [1570] = 1160,
  [1571] = 1199,
  [1572] = 1202,
  [1573] = 1166,
  [1574] = 1169,
  [1575] = 1173,
  [1576] = 1164,
  [1577] = 1165,
  [1578] = 1167,
  [1579] = 1181,
  [1580] = 1182,
  [1581] = 1183,
  [1582] = 1184,
  [1583] = 1185,
  [1584] = 1186,
  [1585] = 1187,
  [1586] = 1188,
  [1587] = 1189,
  [1588] = 1172,
  [1589] = 1180,
  [1590] = 1191,
  [1591] = 1192,
  [1592] = 1161,
  [1593] = 1179,
  [1594] = 1162,
  [1595] = 1170,
  [1596] = 1171,
  [1597] = 1175,
  [1598] = 1165,
  [1599] = 1599,
  [1600] = 1600,
  [1601] = 1601,
  [1602] = 1602,
  [1603] = 1161,
  [1604] = 1162,
  [1605] = 1170,
  [1606] = 1171,
  [1607] = 1175,
  [1608] = 1160,
  [1609] = 1179,
  [1610] = 1181,
  [1611] = 1182,
  [1612] = 1183,
  [1613] = 1184,
  [1614] = 1599,
  [1615] = 1186,
  [1616] = 1187,
  [1617] = 1188,
  [1618] = 1189,
  [1619] = 1172,
  [1620] = 1180,
  [1621] = 1191,
  [1622] = 1192,
  [1623] = 1199,
  [1624] = 1202,
  [1625] = 1166,
  [1626] = 1169,
  [1627] = 1173,
  [1628] = 1163,
  [1629] = 1164,
  [1630] = 1167,
  [1631] = 1600,
  [1632] = 1601,
  [1633] = 1602,
  [1634] = 1634,
  [1635] = 1185,
  [1636] = 1636,
  [1637] = 1636,
  [1638] = 1187,
  [1639] = 1163,
  [1640] = 1181,
  [1641] = 1182,
  [1642] = 1188,
  [1643] = 1189,
  [1644] = 1172,
  [1645] = 1180,
  [1646] = 1191,
  [1647] = 1173,
  [1648] = 1192,
  [1649] = 1636,
  [1650] = 1168,
  [1651] = 1171,
  [1652] = 1199,
  [1653] = 1202,
  [1654] = 1166,
  [1655] = 1160,
  [1656] = 1196,
  [1657] = 1169,
  [1658] = 1173,
  [1659] = 1163,
  [1660] = 1160,
  [1661] = 1164,
  [1662] = 1165,
  [1663] = 1183,
  [1664] = 1167,
  [1665] = 1183,
  [1666] = 1184,
  [1667] = 1170,
  [1668] = 1185,
  [1669] = 1184,
  [1670] = 1186,
  [1671] = 1170,
  [1672] = 1672,
  [1673] = 1673,
  [1674] = 1185,
  [1675] = 1186,
  [1676] = 1636,
  [1677] = 1161,
  [1678] = 1162,
  [1679] = 1636,
  [1680] = 1187,
  [1681] = 1164,
  [1682] = 1165,
  [1683] = 1636,
  [1684] = 1188,
  [1685] = 1170,
  [1686] = 1171,
  [1687] = 1171,
  [1688] = 1175,
  [1689] = 1175,
  [1690] = 1160,
  [1691] = 1636,
  [1692] = 1179,
  [1693] = 1181,
  [1694] = 1182,
  [1695] = 1183,
  [1696] = 1184,
  [1697] = 1185,
  [1698] = 1186,
  [1699] = 1187,
  [1700] = 1188,
  [1701] = 1189,
  [1702] = 1172,
  [1703] = 1636,
  [1704] = 1180,
  [1705] = 1191,
  [1706] = 1192,
  [1707] = 1199,
  [1708] = 1202,
  [1709] = 1166,
  [1710] = 1169,
  [1711] = 1173,
  [1712] = 1636,
  [1713] = 1163,
  [1714] = 1164,
  [1715] = 1165,
  [1716] = 1167,
  [1717] = 1189,
  [1718] = 1172,
  [1719] = 1180,
  [1720] = 1636,
  [1721] = 1191,
  [1722] = 1167,
  [1723] = 1161,
  [1724] = 1162,
  [1725] = 1175,
  [1726] = 1192,
  [1727] = 1636,
  [1728] = 1199,
  [1729] = 1636,
  [1730] = 1202,
  [1731] = 1636,
  [1732] = 1166,
  [1733] = 1636,
  [1734] = 1179,
  [1735] = 1636,
  [1736] = 1636,
  [1737] = 1636,
  [1738] = 1181,
  [1739] = 1182,
  [1740] = 1740,
  [1741] = 1161,
  [1742] = 1162,
  [1743] = 1169,
  [1744] = 1744,
  [1745] = 1179,
  [1746] = 1746,
  [1747] = 1746,
  [1748] = 1748,
  [1749] = 1749,
  [1750] = 1746,
  [1751] = 1751,
  [1752] = 1752,
  [1753] = 1222,
  [1754] = 1746,
  [1755] = 1746,
  [1756] = 1202,
  [1757] = 1757,
  [1758] = 1758,
  [1759] = 1757,
  [1760] = 1758,
  [1761] = 1757,
  [1762] = 1758,
  [1763] = 1757,
  [1764] = 1758,
  [1765] = 1757,
  [1766] = 1766,
  [1767] = 1758,
  [1768] = 1757,
  [1769] = 1758,
  [1770] = 1757,
  [1771] = 1758,
  [1772] = 1757,
  [1773] = 1758,
  [1774] = 1757,
  [1775] = 1775,
  [1776] = 1758,
  [1777] = 1757,
  [1778] = 1758,
  [1779] = 1757,
  [1780] = 1758,
  [1781] = 1757,
  [1782] = 1758,
  [1783] = 1757,
  [1784] = 1784,
  [1785] = 1758,
  [1786] = 1757,
  [1787] = 1758,
  [1788] = 1757,
  [1789] = 1758,
  [1790] = 1757,
  [1791] = 1758,
  [1792] = 1758,
  [1793] = 1775,
  [1794] = 1161,
  [1795] = 1162,
  [1796] = 1170,
  [1797] = 1171,
  [1798] = 1798,
  [1799] = 1175,
  [1800] = 1160,
  [1801] = 1179,
  [1802] = 1181,
  [1803] = 1182,
  [1804] = 1183,
  [1805] = 1184,
  [1806] = 1185,
  [1807] = 1186,
  [1808] = 1187,
  [1809] = 1188,
  [1810] = 1189,
  [1811] = 1172,
  [1812] = 1180,
  [1813] = 1237,
  [1814] = 1191,
  [1815] = 1192,
  [1816] = 1199,
  [1817] = 1166,
  [1818] = 1169,
  [1819] = 1766,
  [1820] = 1173,
  [1821] = 1163,
  [1822] = 1164,
  [1823] = 1165,
  [1824] = 1167,
  [1825] = 1798,
  [1826] = 1826,
  [1827] = 1827,
  [1828] = 1826,
  [1829] = 1827,
  [1830] = 1826,
  [1831] = 1827,
  [1832] = 1832,
  [1833] = 1826,
  [1834] = 1827,
  [1835] = 1832,
  [1836] = 1832,
  [1837] = 1826,
  [1838] = 1827,
  [1839] = 1832,
  [1840] = 1826,
  [1841] = 1826,
  [1842] = 1827,
  [1843] = 1832,
  [1844] = 1827,
  [1845] = 1827,
  [1846] = 1832,
  [1847] = 1847,
  [1848] = 1847,
  [1849] = 1847,
  [1850] = 1850,
  [1851] = 1851,
  [1852] = 1852,
  [1853] = 1832,
  [1854] = 1847,
  [1855] = 1855,
  [1856] = 1856,
  [1857] = 1826,
  [1858] = 1827,
  [1859] = 1832,
  [1860] = 1826,
  [1861] = 1827,
  [1862] = 1826,
  [1863] = 1827,
  [1864] = 1832,
  [1865] = 1832,
  [1866] = 1827,
  [1867] = 1826,
  [1868] = 1827,
  [1869] = 1832,
  [1870] = 1832,
  [1871] = 1826,
  [1872] = 1827,
  [1873] = 1832,
  [1874] = 1826,
  [1875] = 1826,
  [1876] = 1876,
  [1877] = 1827,
  [1878] = 1832,
  [1879] = 1827,
  [1880] = 1832,
  [1881] = 1826,
  [1882] = 1827,
  [1883] = 1826,
  [1884] = 1832,
  [1885] = 1832,
  [1886] = 1886,
  [1887] = 1887,
  [1888] = 1888,
  [1889] = 1284,
  [1890] = 1288,
  [1891] = 1285,
  [1892] = 1284,
  [1893] = 1798,
  [1894] = 1168,
  [1895] = 1288,
  [1896] = 1766,
  [1897] = 1897,
  [1898] = 1285,
  [1899] = 1899,
  [1900] = 1196,
  [1901] = 1901,
  [1902] = 1902,
  [1903] = 1903,
  [1904] = 1775,
  [1905] = 1905,
  [1906] = 1906,
  [1907] = 1907,
  [1908] = 1908,
  [1909] = 1909,
  [1910] = 1910,
  [1911] = 1911,
  [1912] = 1907,
  [1913] = 1913,
  [1914] = 1914,
  [1915] = 1915,
  [1916] = 1916,
  [1917] = 1906,
  [1918] = 1916,
  [1919] = 1906,
  [1920] = 1909,
  [1921] = 1905,
  [1922] = 1910,
  [1923] = 1911,
  [1924] = 1907,
  [1925] = 1913,
  [1926] = 1914,
  [1927] = 1915,
  [1928] = 1916,
  [1929] = 1905,
  [1930] = 1906,
  [1931] = 1931,
  [1932] = 1909,
  [1933] = 1909,
  [1934] = 1910,
  [1935] = 1911,
  [1936] = 1907,
  [1937] = 1913,
  [1938] = 1914,
  [1939] = 1915,
  [1940] = 1916,
  [1941] = 1905,
  [1942] = 1906,
  [1943] = 1911,
  [1944] = 1910,
  [1945] = 1910,
  [1946] = 1909,
  [1947] = 1911,
  [1948] = 1907,
  [1949] = 1910,
  [1950] = 1911,
  [1951] = 1907,
  [1952] = 1913,
  [1953] = 1914,
  [1954] = 1915,
  [1955] = 1916,
  [1956] = 1905,
  [1957] = 1906,
  [1958] = 1913,
  [1959] = 1914,
  [1960] = 1915,
  [1961] = 1909,
  [1962] = 1916,
  [1963] = 1910,
  [1964] = 1910,
  [1965] = 1911,
  [1966] = 1907,
  [1967] = 1913,
  [1968] = 1914,
  [1969] = 1915,
  [1970] = 1916,
  [1971] = 1905,
  [1972] = 1906,
  [1973] = 1905,
  [1974] = 1905,
  [1975] = 1909,
  [1976] = 1906,
  [1977] = 1911,
  [1978] = 1910,
  [1979] = 1911,
  [1980] = 1907,
  [1981] = 1913,
  [1982] = 1914,
  [1983] = 1915,
  [1984] = 1916,
  [1985] = 1906,
  [1986] = 1905,
  [1987] = 1906,
  [1988] = 1907,
  [1989] = 1909,
  [1990] = 1909,
  [1991] = 1913,
  [1992] = 1914,
  [1993] = 1910,
  [1994] = 1911,
  [1995] = 1907,
  [1996] = 1913,
  [1997] = 1914,
  [1998] = 1915,
  [1999] = 1916,
  [2000] = 1905,
  [2001] = 1906,
  [2002] = 1910,
  [2003] = 1911,
  [2004] = 1907,
  [2005] = 1909,
  [2006] = 1913,
  [2007] = 1914,
  [2008] = 1910,
  [2009] = 1911,
  [2010] = 1907,
  [2011] = 1913,
  [2012] = 1914,
  [2013] = 1915,
  [2014] = 1916,
  [2015] = 1913,
  [2016] = 1905,
  [2017] = 1906,
  [2018] = 1915,
  [2019] = 1909,
  [2020] = 1916,
  [2021] = 1905,
  [2022] = 1910,
  [2023] = 1911,
  [2024] = 1913,
  [2025] = 1916,
  [2026] = 1905,
  [2027] = 1906,
  [2028] = 1914,
  [2029] = 1915,
  [2030] = 1915,
  [2031] = 2031,
  [2032] = 1909,
  [2033] = 1906,
  [2034] = 1909,
  [2035] = 2035,
  [2036] = 1909,
  [2037] = 1909,
  [2038] = 1910,
  [2039] = 2039,
  [2040] = 1911,
  [2041] = 1907,
  [2042] = 1913,
  [2043] = 2043,
  [2044] = 2044,
  [2045] = 1914,
  [2046] = 1915,
  [2047] = 1916,
  [2048] = 1905,
  [2049] = 1906,
  [2050] = 1910,
  [2051] = 1911,
  [2052] = 1909,
  [2053] = 1907,
  [2054] = 1913,
  [2055] = 1910,
  [2056] = 1911,
  [2057] = 1907,
  [2058] = 1913,
  [2059] = 1914,
  [2060] = 1915,
  [2061] = 1916,
  [2062] = 1905,
  [2063] = 1906,
  [2064] = 1914,
  [2065] = 2065,
  [2066] = 1915,
  [2067] = 1909,
  [2068] = 1916,
  [2069] = 1906,
  [2070] = 1910,
  [2071] = 1911,
  [2072] = 1907,
  [2073] = 1913,
  [2074] = 1931,
  [2075] = 2035,
  [2076] = 1914,
  [2077] = 1931,
  [2078] = 2035,
  [2079] = 1915,
  [2080] = 1916,
  [2081] = 1931,
  [2082] = 2035,
  [2083] = 1931,
  [2084] = 2035,
  [2085] = 1931,
  [2086] = 2035,
  [2087] = 1931,
  [2088] = 2035,
  [2089] = 1931,
  [2090] = 2035,
  [2091] = 1931,
  [2092] = 2035,
  [2093] = 1931,
  [2094] = 2035,
  [2095] = 1931,
  [2096] = 2035,
  [2097] = 1931,
  [2098] = 2035,
  [2099] = 1931,
  [2100] = 2035,
  [2101] = 1931,
  [2102] = 2035,
  [2103] = 1931,
  [2104] = 2035,
  [2105] = 1931,
  [2106] = 2035,
  [2107] = 2035,
  [2108] = 1916,
  [2109] = 2109,
  [2110] = 1905,
  [2111] = 2111,
  [2112] = 2112,
  [2113] = 2113,
  [2114] = 1905,
  [2115] = 2115,
  [2116] = 2115,
  [2117] = 2115,
  [2118] = 2118,
  [2119] = 2118,
  [2120] = 1601,
  [2121] = 1602,
  [2122] = 1600,
  [2123] = 1599,
  [2124] = 1599,
  [2125] = 1602,
  [2126] = 1600,
  [2127] = 1601,
  [2128] = 1600,
  [2129] = 1599,
  [2130] = 2130,
  [2131] = 1602,
  [2132] = 1601,
  [2133] = 1599,
  [2134] = 1599,
  [2135] = 2135,
  [2136] = 2136,
  [2137] = 2137,
  [2138] = 2138,
  [2139] = 2139,
  [2140] = 2140,
  [2141] = 2141,
  [2142] = 2142,
  [2143] = 2143,
  [2144] = 2144,
  [2145] = 2145,
  [2146] = 2146,
  [2147] = 2147,
  [2148] = 2148,
  [2149] = 2149,
  [2150] = 2150,
  [2151] = 2151,
  [2152] = 2152,
  [2153] = 2153,
  [2154] = 2154,
  [2155] = 2155,
  [2156] = 2156,
  [2157] = 2157,
  [2158] = 2158,
  [2159] = 2159,
  [2160] = 2160,
  [2161] = 2161,
  [2162] = 2162,
  [2163] = 2163,
  [2164] = 2164,
  [2165] = 2165,
  [2166] = 2166,
  [2167] = 2167,
  [2168] = 2168,
  [2169] = 2169,
  [2170] = 2170,
  [2171] = 2171,
  [2172] = 2172,
  [2173] = 2173,
  [2174] = 2174,
  [2175] = 2175,
  [2176] = 2176,
  [2177] = 2177,
  [2178] = 2178,
  [2179] = 2179,
  [2180] = 2180,
  [2181] = 2181,
  [2182] = 2182,
  [2183] = 2183,
  [2184] = 2184,
  [2185] = 2185,
  [2186] = 2186,
  [2187] = 2187,
  [2188] = 2188,
  [2189] = 2189,
  [2190] = 2190,
  [2191] = 2191,
  [2192] = 2192,
  [2193] = 2193,
  [2194] = 2194,
  [2195] = 2195,
  [2196] = 2196,
  [2197] = 2197,
  [2198] = 2198,
  [2199] = 2199,
  [2200] = 2200,
  [2201] = 2201,
  [2202] = 2202,
  [2203] = 2203,
  [2204] = 2204,
  [2205] = 2205,
  [2206] = 2206,
  [2207] = 2207,
  [2208] = 2208,
  [2209] = 2209,
  [2210] = 2210,
  [2211] = 2211,
  [2212] = 2211,
  [2213] = 2213,
  [2214] = 2213,
  [2215] = 2215,
  [2216] = 2213,
  [2217] = 2215,
  [2218] = 2213,
  [2219] = 2219,
  [2220] = 2220,
  [2221] = 2221,
  [2222] = 2220,
  [2223] = 2221,
  [2224] = 2224,
  [2225] = 2219,
  [2226] = 2224,
  [2227] = 2227,
  [2228] = 2228,
  [2229] = 2229,
  [2230] = 2230,
  [2231] = 2231,
  [2232] = 2232,
  [2233] = 2232,
  [2234] = 2234,
  [2235] = 2229,
  [2236] = 2231,
  [2237] = 2237,
  [2238] = 2238,
  [2239] = 2227,
  [2240] = 2228,
  [2241] = 2237,
  [2242] = 2230,
  [2243] = 2238,
  [2244] = 2234,
  [2245] = 2245,
  [2246] = 2246,
  [2247] = 2247,
  [2248] = 2248,
  [2249] = 2249,
  [2250] = 2219,
  [2251] = 2251,
  [2252] = 2252,
  [2253] = 2253,
  [2254] = 2254,
  [2255] = 2255,
  [2256] = 2256,
  [2257] = 2257,
  [2258] = 2258,
  [2259] = 2259,
  [2260] = 2224,
  [2261] = 2221,
  [2262] = 2130,
  [2263] = 2224,
  [2264] = 2264,
  [2265] = 2265,
  [2266] = 2266,
  [2267] = 2267,
  [2268] = 2220,
  [2269] = 2269,
  [2270] = 2270,
  [2271] = 2271,
  [2272] = 2272,
  [2273] = 2273,
  [2274] = 2219,
  [2275] = 2275,
  [2276] = 2276,
  [2277] = 2277,
  [2278] = 2278,
  [2279] = 2279,
  [2280] = 2280,
  [2281] = 2281,
  [2282] = 2282,
  [2283] = 2283,
  [2284] = 2284,
  [2285] = 2285,
  [2286] = 2273,
  [2287] = 2287,
  [2288] = 2288,
  [2289] = 2258,
  [2290] = 2290,
  [2291] = 2291,
  [2292] = 2255,
  [2293] = 2256,
  [2294] = 2257,
  [2295] = 2245,
  [2296] = 2221,
  [2297] = 2297,
  [2298] = 2298,
  [2299] = 2299,
  [2300] = 2300,
  [2301] = 2291,
  [2302] = 2302,
  [2303] = 2303,
  [2304] = 2246,
  [2305] = 2248,
  [2306] = 2306,
  [2307] = 2251,
  [2308] = 2308,
  [2309] = 2309,
  [2310] = 2287,
  [2311] = 2254,
  [2312] = 2312,
  [2313] = 2313,
  [2314] = 2314,
  [2315] = 2266,
  [2316] = 2267,
  [2317] = 2317,
  [2318] = 2272,
  [2319] = 2282,
  [2320] = 2283,
  [2321] = 2290,
  [2322] = 2306,
  [2323] = 2308,
  [2324] = 2309,
  [2325] = 2312,
  [2326] = 2259,
  [2327] = 2247,
  [2328] = 2328,
  [2329] = 2313,
  [2330] = 2314,
  [2331] = 2317,
  [2332] = 2328,
  [2333] = 2333,
  [2334] = 2334,
  [2335] = 2335,
  [2336] = 2333,
  [2337] = 2334,
  [2338] = 2335,
  [2339] = 2297,
  [2340] = 2249,
  [2341] = 2252,
  [2342] = 2253,
  [2343] = 2264,
  [2344] = 2265,
  [2345] = 2303,
  [2346] = 2285,
  [2347] = 2288,
  [2348] = 2269,
  [2349] = 2270,
  [2350] = 2271,
  [2351] = 2275,
  [2352] = 2276,
  [2353] = 2277,
  [2354] = 2278,
  [2355] = 2279,
  [2356] = 2280,
  [2357] = 2281,
  [2358] = 2284,
  [2359] = 2298,
  [2360] = 2299,
  [2361] = 2300,
  [2362] = 2362,
  [2363] = 2302,
  [2364] = 2220,
  [2365] = 2365,
  [2366] = 2130,
  [2367] = 2365,
  [2368] = 2362,
  [2369] = 2234,
  [2370] = 2229,
  [2371] = 2230,
  [2372] = 2231,
  [2373] = 2238,
  [2374] = 2237,
  [2375] = 2232,
  [2376] = 2234,
  [2377] = 2228,
  [2378] = 2227,
  [2379] = 2237,
  [2380] = 2230,
  [2381] = 2238,
  [2382] = 2229,
  [2383] = 2228,
  [2384] = 2227,
  [2385] = 2232,
  [2386] = 2231,
  [2387] = 2333,
  [2388] = 2309,
  [2389] = 2246,
  [2390] = 2267,
  [2391] = 2259,
  [2392] = 2273,
  [2393] = 2247,
  [2394] = 2313,
  [2395] = 2314,
  [2396] = 2317,
  [2397] = 2283,
  [2398] = 2328,
  [2399] = 2287,
  [2400] = 2312,
  [2401] = 2334,
  [2402] = 2335,
  [2403] = 2288,
  [2404] = 2258,
  [2405] = 2291,
  [2406] = 2291,
  [2407] = 2297,
  [2408] = 2284,
  [2409] = 2290,
  [2410] = 2264,
  [2411] = 2255,
  [2412] = 2256,
  [2413] = 2257,
  [2414] = 2249,
  [2415] = 2245,
  [2416] = 2313,
  [2417] = 2252,
  [2418] = 2314,
  [2419] = 2253,
  [2420] = 2269,
  [2421] = 2270,
  [2422] = 2271,
  [2423] = 2264,
  [2424] = 2265,
  [2425] = 2297,
  [2426] = 2247,
  [2427] = 2317,
  [2428] = 2303,
  [2429] = 2269,
  [2430] = 2270,
  [2431] = 2271,
  [2432] = 2272,
  [2433] = 2275,
  [2434] = 2276,
  [2435] = 2277,
  [2436] = 2278,
  [2437] = 2279,
  [2438] = 2280,
  [2439] = 2281,
  [2440] = 2246,
  [2441] = 2248,
  [2442] = 2248,
  [2443] = 2284,
  [2444] = 2298,
  [2445] = 2299,
  [2446] = 2300,
  [2447] = 2362,
  [2448] = 2302,
  [2449] = 2251,
  [2450] = 2328,
  [2451] = 2254,
  [2452] = 2275,
  [2453] = 2365,
  [2454] = 2130,
  [2455] = 2303,
  [2456] = 2276,
  [2457] = 2254,
  [2458] = 2273,
  [2459] = 2287,
  [2460] = 2288,
  [2461] = 2265,
  [2462] = 2277,
  [2463] = 2258,
  [2464] = 2278,
  [2465] = 2279,
  [2466] = 2266,
  [2467] = 2267,
  [2468] = 2298,
  [2469] = 2299,
  [2470] = 2285,
  [2471] = 2300,
  [2472] = 2362,
  [2473] = 2302,
  [2474] = 2255,
  [2475] = 2272,
  [2476] = 2333,
  [2477] = 2251,
  [2478] = 2252,
  [2479] = 2249,
  [2480] = 2256,
  [2481] = 2257,
  [2482] = 2282,
  [2483] = 2245,
  [2484] = 2283,
  [2485] = 2290,
  [2486] = 2280,
  [2487] = 2306,
  [2488] = 2308,
  [2489] = 2309,
  [2490] = 2312,
  [2491] = 2259,
  [2492] = 2281,
  [2493] = 2253,
  [2494] = 2282,
  [2495] = 2266,
  [2496] = 2365,
  [2497] = 2334,
  [2498] = 2335,
  [2499] = 2130,
  [2500] = 2306,
  [2501] = 2308,
  [2502] = 2285,
  [2503] = 2213,
  [2504] = 2213,
  [2505] = 2505,
  [2506] = 2213,
  [2507] = 2213,
  [2508] = 2224,
  [2509] = 2219,
  [2510] = 2221,
  [2511] = 2221,
  [2512] = 2220,
  [2513] = 2219,
  [2514] = 2224,
  [2515] = 2220,
  [2516] = 2221,
  [2517] = 2232,
  [2518] = 2238,
  [2519] = 2229,
  [2520] = 2230,
  [2521] = 2227,
  [2522] = 2234,
  [2523] = 2219,
  [2524] = 2228,
  [2525] = 2227,
  [2526] = 2224,
  [2527] = 2231,
  [2528] = 2220,
  [2529] = 2231,
  [2530] = 2230,
  [2531] = 2228,
  [2532] = 2238,
  [2533] = 2237,
  [2534] = 2232,
  [2535] = 2234,
  [2536] = 2229,
  [2537] = 2237,
  [2538] = 2334,
  [2539] = 2228,
  [2540] = 2232,
  [2541] = 2234,
  [2542] = 2303,
  [2543] = 2238,
  [2544] = 2224,
  [2545] = 2264,
  [2546] = 2246,
  [2547] = 2248,
  [2548] = 2265,
  [2549] = 2249,
  [2550] = 2251,
  [2551] = 2252,
  [2552] = 2229,
  [2553] = 2220,
  [2554] = 2249,
  [2555] = 2269,
  [2556] = 2270,
  [2557] = 2271,
  [2558] = 2287,
  [2559] = 2253,
  [2560] = 2219,
  [2561] = 2258,
  [2562] = 2254,
  [2563] = 2275,
  [2564] = 2221,
  [2565] = 2276,
  [2566] = 2277,
  [2567] = 2278,
  [2568] = 2279,
  [2569] = 2280,
  [2570] = 2281,
  [2571] = 2264,
  [2572] = 2265,
  [2573] = 2266,
  [2574] = 2267,
  [2575] = 2284,
  [2576] = 2269,
  [2577] = 2270,
  [2578] = 2271,
  [2579] = 2272,
  [2580] = 2130,
  [2581] = 2255,
  [2582] = 2285,
  [2583] = 2273,
  [2584] = 2287,
  [2585] = 2288,
  [2586] = 2258,
  [2587] = 2298,
  [2588] = 2291,
  [2589] = 2299,
  [2590] = 2255,
  [2591] = 2256,
  [2592] = 2257,
  [2593] = 2245,
  [2594] = 2300,
  [2595] = 2362,
  [2596] = 2275,
  [2597] = 2276,
  [2598] = 2277,
  [2599] = 2278,
  [2600] = 2279,
  [2601] = 2280,
  [2602] = 2281,
  [2603] = 2282,
  [2604] = 2297,
  [2605] = 2283,
  [2606] = 2284,
  [2607] = 2290,
  [2608] = 2302,
  [2609] = 2303,
  [2610] = 2298,
  [2611] = 2299,
  [2612] = 2231,
  [2613] = 2246,
  [2614] = 2248,
  [2615] = 2300,
  [2616] = 2362,
  [2617] = 2251,
  [2618] = 2302,
  [2619] = 2252,
  [2620] = 2365,
  [2621] = 2254,
  [2622] = 2230,
  [2623] = 2306,
  [2624] = 2308,
  [2625] = 2309,
  [2626] = 2130,
  [2627] = 2256,
  [2628] = 2266,
  [2629] = 2267,
  [2630] = 2312,
  [2631] = 2365,
  [2632] = 2257,
  [2633] = 2245,
  [2634] = 2259,
  [2635] = 2272,
  [2636] = 2291,
  [2637] = 2282,
  [2638] = 2283,
  [2639] = 2290,
  [2640] = 2253,
  [2641] = 2313,
  [2642] = 2247,
  [2643] = 2314,
  [2644] = 2306,
  [2645] = 2308,
  [2646] = 2309,
  [2647] = 2312,
  [2648] = 2317,
  [2649] = 2259,
  [2650] = 2328,
  [2651] = 2227,
  [2652] = 2247,
  [2653] = 2313,
  [2654] = 2314,
  [2655] = 2317,
  [2656] = 2328,
  [2657] = 2333,
  [2658] = 2335,
  [2659] = 2333,
  [2660] = 2334,
  [2661] = 2335,
  [2662] = 2285,
  [2663] = 2273,
  [2664] = 2297,
  [2665] = 2237,
  [2666] = 2288,
  [2667] = 2234,
  [2668] = 2256,
  [2669] = 2306,
  [2670] = 2280,
  [2671] = 2308,
  [2672] = 2309,
  [2673] = 2312,
  [2674] = 2281,
  [2675] = 2275,
  [2676] = 2365,
  [2677] = 2228,
  [2678] = 2246,
  [2679] = 2266,
  [2680] = 2227,
  [2681] = 2248,
  [2682] = 2276,
  [2683] = 2277,
  [2684] = 2264,
  [2685] = 2267,
  [2686] = 2231,
  [2687] = 2259,
  [2688] = 2247,
  [2689] = 2251,
  [2690] = 2257,
  [2691] = 2230,
  [2692] = 2313,
  [2693] = 2314,
  [2694] = 2317,
  [2695] = 2328,
  [2696] = 2238,
  [2697] = 2333,
  [2698] = 2334,
  [2699] = 2335,
  [2700] = 2272,
  [2701] = 2232,
  [2702] = 2303,
  [2703] = 2279,
  [2704] = 2245,
  [2705] = 2284,
  [2706] = 2298,
  [2707] = 2265,
  [2708] = 2249,
  [2709] = 2282,
  [2710] = 2252,
  [2711] = 2283,
  [2712] = 2299,
  [2713] = 2300,
  [2714] = 2253,
  [2715] = 2290,
  [2716] = 2362,
  [2717] = 2237,
  [2718] = 2285,
  [2719] = 2273,
  [2720] = 2287,
  [2721] = 2288,
  [2722] = 2297,
  [2723] = 2302,
  [2724] = 2291,
  [2725] = 2254,
  [2726] = 2258,
  [2727] = 2269,
  [2728] = 2278,
  [2729] = 2255,
  [2730] = 2270,
  [2731] = 2271,
  [2732] = 2130,
  [2733] = 2229,
  [2734] = 2270,
  [2735] = 2253,
  [2736] = 2248,
  [2737] = 2303,
  [2738] = 2251,
  [2739] = 2264,
  [2740] = 2287,
  [2741] = 2288,
  [2742] = 2265,
  [2743] = 2266,
  [2744] = 2269,
  [2745] = 2271,
  [2746] = 2267,
  [2747] = 2258,
  [2748] = 2275,
  [2749] = 2276,
  [2750] = 2277,
  [2751] = 2255,
  [2752] = 2278,
  [2753] = 2279,
  [2754] = 2272,
  [2755] = 2280,
  [2756] = 2256,
  [2757] = 2282,
  [2758] = 2281,
  [2759] = 2283,
  [2760] = 2290,
  [2761] = 2259,
  [2762] = 2257,
  [2763] = 2284,
  [2764] = 2298,
  [2765] = 2299,
  [2766] = 2254,
  [2767] = 2300,
  [2768] = 2362,
  [2769] = 2302,
  [2770] = 2247,
  [2771] = 2313,
  [2772] = 2306,
  [2773] = 2308,
  [2774] = 2309,
  [2775] = 2312,
  [2776] = 2314,
  [2777] = 2285,
  [2778] = 2130,
  [2779] = 2365,
  [2780] = 2317,
  [2781] = 2328,
  [2782] = 2245,
  [2783] = 2291,
  [2784] = 2297,
  [2785] = 2333,
  [2786] = 2334,
  [2787] = 2335,
  [2788] = 2249,
  [2789] = 2246,
  [2790] = 2252,
  [2791] = 2273,
  [2792] = 2792,
  [2793] = 2793,
  [2794] = 2793,
  [2795] = 2793,
  [2796] = 2793,
  [2797] = 2793,
  [2798] = 2793,
  [2799] = 2793,
  [2800] = 2793,
  [2801] = 2793,
  [2802] = 2793,
  [2803] = 2793,
  [2804] = 2793,
  [2805] = 2793,
  [2806] = 2793,
  [2807] = 2793,
  [2808] = 2793,
  [2809] = 2793,
  [2810] = 2213,
  [2811] = 2213,
  [2812] = 2812,
  [2813] = 2213,
  [2814] = 2220,
  [2815] = 2221,
  [2816] = 2219,
  [2817] = 2224,
  [2818] = 2818,
  [2819] = 2213,
  [2820] = 2237,
  [2821] = 2229,
  [2822] = 2231,
  [2823] = 2227,
  [2824] = 2238,
  [2825] = 2234,
  [2826] = 2230,
  [2827] = 2232,
  [2828] = 2228,
  [2829] = 2251,
  [2830] = 2249,
  [2831] = 2254,
  [2832] = 2252,
  [2833] = 2253,
  [2834] = 2282,
  [2835] = 2264,
  [2836] = 2265,
  [2837] = 2269,
  [2838] = 2270,
  [2839] = 2271,
  [2840] = 2303,
  [2841] = 2275,
  [2842] = 2276,
  [2843] = 2277,
  [2844] = 2278,
  [2845] = 2279,
  [2846] = 2283,
  [2847] = 2280,
  [2848] = 2281,
  [2849] = 2284,
  [2850] = 2272,
  [2851] = 2298,
  [2852] = 2299,
  [2853] = 2300,
  [2854] = 2362,
  [2855] = 2302,
  [2856] = 2365,
  [2857] = 2130,
  [2858] = 2259,
  [2859] = 2290,
  [2860] = 2247,
  [2861] = 2224,
  [2862] = 2313,
  [2863] = 2220,
  [2864] = 2248,
  [2865] = 2317,
  [2866] = 2213,
  [2867] = 2328,
  [2868] = 2333,
  [2869] = 2219,
  [2870] = 2334,
  [2871] = 2221,
  [2872] = 2335,
  [2873] = 2266,
  [2874] = 2267,
  [2875] = 2246,
  [2876] = 2285,
  [2877] = 2273,
  [2878] = 2287,
  [2879] = 2288,
  [2880] = 2258,
  [2881] = 2306,
  [2882] = 2291,
  [2883] = 2213,
  [2884] = 2255,
  [2885] = 2256,
  [2886] = 2257,
  [2887] = 2245,
  [2888] = 2308,
  [2889] = 2309,
  [2890] = 2312,
  [2891] = 2213,
  [2892] = 2297,
  [2893] = 2314,
  [2894] = 2228,
  [2895] = 2224,
  [2896] = 2232,
  [2897] = 2221,
  [2898] = 2234,
  [2899] = 2229,
  [2900] = 2227,
  [2901] = 2901,
  [2902] = 2237,
  [2903] = 2219,
  [2904] = 2220,
  [2905] = 2231,
  [2906] = 2230,
  [2907] = 2238,
  [2908] = 2312,
  [2909] = 2271,
  [2910] = 2272,
  [2911] = 2258,
  [2912] = 2282,
  [2913] = 2283,
  [2914] = 2284,
  [2915] = 2290,
  [2916] = 2306,
  [2917] = 2308,
  [2918] = 2309,
  [2919] = 2230,
  [2920] = 2365,
  [2921] = 2213,
  [2922] = 2259,
  [2923] = 2220,
  [2924] = 2234,
  [2925] = 2247,
  [2926] = 2313,
  [2927] = 2314,
  [2928] = 2291,
  [2929] = 2335,
  [2930] = 2249,
  [2931] = 2252,
  [2932] = 2253,
  [2933] = 2306,
  [2934] = 2308,
  [2935] = 2309,
  [2936] = 2312,
  [2937] = 2228,
  [2938] = 2229,
  [2939] = 2264,
  [2940] = 2265,
  [2941] = 2255,
  [2942] = 2256,
  [2943] = 2269,
  [2944] = 2270,
  [2945] = 2257,
  [2946] = 2245,
  [2947] = 2275,
  [2948] = 2288,
  [2949] = 2277,
  [2950] = 2278,
  [2951] = 2279,
  [2952] = 2280,
  [2953] = 2281,
  [2954] = 2221,
  [2955] = 2298,
  [2956] = 2299,
  [2957] = 2300,
  [2958] = 2362,
  [2959] = 2302,
  [2960] = 2237,
  [2961] = 2238,
  [2962] = 2317,
  [2963] = 2328,
  [2964] = 2333,
  [2965] = 2334,
  [2966] = 2297,
  [2967] = 2303,
  [2968] = 2227,
  [2969] = 2246,
  [2970] = 2248,
  [2971] = 2251,
  [2972] = 2972,
  [2973] = 2254,
  [2974] = 2231,
  [2975] = 2219,
  [2976] = 2232,
  [2977] = 2130,
  [2978] = 2285,
  [2979] = 2273,
  [2980] = 2224,
  [2981] = 2287,
  [2982] = 2266,
  [2983] = 2267,
  [2984] = 2276,
  [2985] = 2314,
  [2986] = 2280,
  [2987] = 2281,
  [2988] = 2284,
  [2989] = 2266,
  [2990] = 2267,
  [2991] = 2298,
  [2992] = 2299,
  [2993] = 2224,
  [2994] = 2994,
  [2995] = 2300,
  [2996] = 2362,
  [2997] = 2302,
  [2998] = 2252,
  [2999] = 2246,
  [3000] = 2248,
  [3001] = 2231,
  [3002] = 2130,
  [3003] = 2994,
  [3004] = 2251,
  [3005] = 2238,
  [3006] = 2272,
  [3007] = 2994,
  [3008] = 2285,
  [3009] = 2273,
  [3010] = 2994,
  [3011] = 2220,
  [3012] = 2232,
  [3013] = 2219,
  [3014] = 2287,
  [3015] = 2288,
  [3016] = 2994,
  [3017] = 2258,
  [3018] = 2221,
  [3019] = 2253,
  [3020] = 2220,
  [3021] = 2994,
  [3022] = 2219,
  [3023] = 2221,
  [3024] = 2291,
  [3025] = 2224,
  [3026] = 2282,
  [3027] = 2994,
  [3028] = 2283,
  [3029] = 2234,
  [3030] = 2290,
  [3031] = 2303,
  [3032] = 2994,
  [3033] = 2994,
  [3034] = 2229,
  [3035] = 2994,
  [3036] = 2994,
  [3037] = 2264,
  [3038] = 2365,
  [3039] = 3039,
  [3040] = 2265,
  [3041] = 2297,
  [3042] = 2994,
  [3043] = 2994,
  [3044] = 2254,
  [3045] = 2994,
  [3046] = 2269,
  [3047] = 2230,
  [3048] = 2270,
  [3049] = 2271,
  [3050] = 2219,
  [3051] = 2255,
  [3052] = 2220,
  [3053] = 2256,
  [3054] = 2257,
  [3055] = 2245,
  [3056] = 2306,
  [3057] = 2237,
  [3058] = 2308,
  [3059] = 2309,
  [3060] = 2312,
  [3061] = 2259,
  [3062] = 2228,
  [3063] = 2249,
  [3064] = 2994,
  [3065] = 2247,
  [3066] = 2227,
  [3067] = 2275,
  [3068] = 2276,
  [3069] = 2221,
  [3070] = 2277,
  [3071] = 2224,
  [3072] = 2313,
  [3073] = 2278,
  [3074] = 2335,
  [3075] = 2317,
  [3076] = 2328,
  [3077] = 2279,
  [3078] = 2333,
  [3079] = 2334,
  [3080] = 2994,
  [3081] = 2232,
  [3082] = 2252,
  [3083] = 2280,
  [3084] = 2231,
  [3085] = 2237,
  [3086] = 2281,
  [3087] = 2229,
  [3088] = 2267,
  [3089] = 2303,
  [3090] = 2230,
  [3091] = 2227,
  [3092] = 2282,
  [3093] = 2283,
  [3094] = 2284,
  [3095] = 2290,
  [3096] = 2264,
  [3097] = 2234,
  [3098] = 2270,
  [3099] = 3099,
  [3100] = 2228,
  [3101] = 2229,
  [3102] = 2271,
  [3103] = 2298,
  [3104] = 2299,
  [3105] = 2228,
  [3106] = 2265,
  [3107] = 2285,
  [3108] = 2273,
  [3109] = 2287,
  [3110] = 2300,
  [3111] = 2362,
  [3112] = 2229,
  [3113] = 2333,
  [3114] = 2232,
  [3115] = 2253,
  [3116] = 2288,
  [3117] = 2272,
  [3118] = 2227,
  [3119] = 2258,
  [3120] = 2302,
  [3121] = 2231,
  [3122] = 2238,
  [3123] = 2335,
  [3124] = 2238,
  [3125] = 2266,
  [3126] = 2237,
  [3127] = 2234,
  [3128] = 2231,
  [3129] = 2254,
  [3130] = 2246,
  [3131] = 2230,
  [3132] = 2291,
  [3133] = 2238,
  [3134] = 2306,
  [3135] = 2308,
  [3136] = 2309,
  [3137] = 2247,
  [3138] = 2234,
  [3139] = 2248,
  [3140] = 2232,
  [3141] = 2269,
  [3142] = 2255,
  [3143] = 2256,
  [3144] = 2257,
  [3145] = 2245,
  [3146] = 2259,
  [3147] = 2249,
  [3148] = 2275,
  [3149] = 2312,
  [3150] = 2365,
  [3151] = 2228,
  [3152] = 2227,
  [3153] = 2251,
  [3154] = 2313,
  [3155] = 2276,
  [3156] = 2334,
  [3157] = 2328,
  [3158] = 2237,
  [3159] = 2314,
  [3160] = 2317,
  [3161] = 2277,
  [3162] = 2230,
  [3163] = 2278,
  [3164] = 2279,
  [3165] = 2297,
  [3166] = 2130,
  [3167] = 2303,
  [3168] = 2267,
  [3169] = 2273,
  [3170] = 2248,
  [3171] = 2333,
  [3172] = 2287,
  [3173] = 2306,
  [3174] = 2334,
  [3175] = 2335,
  [3176] = 2264,
  [3177] = 2285,
  [3178] = 2290,
  [3179] = 2259,
  [3180] = 2269,
  [3181] = 2270,
  [3182] = 2271,
  [3183] = 2283,
  [3184] = 2288,
  [3185] = 2258,
  [3186] = 2259,
  [3187] = 2275,
  [3188] = 2276,
  [3189] = 2265,
  [3190] = 2272,
  [3191] = 2269,
  [3192] = 2270,
  [3193] = 2271,
  [3194] = 2291,
  [3195] = 2275,
  [3196] = 2291,
  [3197] = 2276,
  [3198] = 2273,
  [3199] = 2255,
  [3200] = 2256,
  [3201] = 2277,
  [3202] = 2257,
  [3203] = 2277,
  [3204] = 2245,
  [3205] = 2259,
  [3206] = 2278,
  [3207] = 2279,
  [3208] = 2317,
  [3209] = 2280,
  [3210] = 2272,
  [3211] = 2278,
  [3212] = 2247,
  [3213] = 2281,
  [3214] = 2279,
  [3215] = 2308,
  [3216] = 2282,
  [3217] = 2275,
  [3218] = 2280,
  [3219] = 2254,
  [3220] = 2281,
  [3221] = 2276,
  [3222] = 2277,
  [3223] = 2278,
  [3224] = 2279,
  [3225] = 2284,
  [3226] = 2280,
  [3227] = 2281,
  [3228] = 2249,
  [3229] = 2313,
  [3230] = 2314,
  [3231] = 2283,
  [3232] = 2328,
  [3233] = 2297,
  [3234] = 2266,
  [3235] = 2290,
  [3236] = 2298,
  [3237] = 2264,
  [3238] = 2224,
  [3239] = 2290,
  [3240] = 2284,
  [3241] = 2299,
  [3242] = 2253,
  [3243] = 2300,
  [3244] = 2303,
  [3245] = 2362,
  [3246] = 2317,
  [3247] = 2302,
  [3248] = 2328,
  [3249] = 2252,
  [3250] = 2309,
  [3251] = 2335,
  [3252] = 2255,
  [3253] = 2328,
  [3254] = 2333,
  [3255] = 2298,
  [3256] = 2299,
  [3257] = 2334,
  [3258] = 2246,
  [3259] = 2248,
  [3260] = 2284,
  [3261] = 2335,
  [3262] = 2312,
  [3263] = 2130,
  [3264] = 2247,
  [3265] = 2300,
  [3266] = 2298,
  [3267] = 2299,
  [3268] = 2219,
  [3269] = 2251,
  [3270] = 2362,
  [3271] = 2297,
  [3272] = 2251,
  [3273] = 2300,
  [3274] = 2362,
  [3275] = 2266,
  [3276] = 2333,
  [3277] = 2302,
  [3278] = 2249,
  [3279] = 2256,
  [3280] = 2306,
  [3281] = 2302,
  [3282] = 2282,
  [3283] = 2282,
  [3284] = 2265,
  [3285] = 2306,
  [3286] = 2253,
  [3287] = 2308,
  [3288] = 2313,
  [3289] = 2257,
  [3290] = 2254,
  [3291] = 2246,
  [3292] = 2313,
  [3293] = 2314,
  [3294] = 2308,
  [3295] = 2264,
  [3296] = 2245,
  [3297] = 2265,
  [3298] = 2283,
  [3299] = 2309,
  [3300] = 2309,
  [3301] = 2312,
  [3302] = 2314,
  [3303] = 2312,
  [3304] = 2365,
  [3305] = 2365,
  [3306] = 2130,
  [3307] = 2252,
  [3308] = 2251,
  [3309] = 2365,
  [3310] = 2267,
  [3311] = 2288,
  [3312] = 2254,
  [3313] = 2287,
  [3314] = 2285,
  [3315] = 2249,
  [3316] = 2269,
  [3317] = 2273,
  [3318] = 2267,
  [3319] = 2287,
  [3320] = 2252,
  [3321] = 2270,
  [3322] = 2288,
  [3323] = 2258,
  [3324] = 2271,
  [3325] = 2247,
  [3326] = 2334,
  [3327] = 2291,
  [3328] = 2246,
  [3329] = 2130,
  [3330] = 2255,
  [3331] = 2256,
  [3332] = 2257,
  [3333] = 2245,
  [3334] = 2221,
  [3335] = 2253,
  [3336] = 2258,
  [3337] = 2297,
  [3338] = 2248,
  [3339] = 2272,
  [3340] = 2303,
  [3341] = 2266,
  [3342] = 2285,
  [3343] = 2317,
  [3344] = 2220,
  [3345] = 2229,
  [3346] = 2237,
  [3347] = 2238,
  [3348] = 2228,
  [3349] = 2227,
  [3350] = 2234,
  [3351] = 2232,
  [3352] = 2231,
  [3353] = 2230,
  [3354] = 2308,
  [3355] = 2302,
  [3356] = 2249,
  [3357] = 2266,
  [3358] = 2267,
  [3359] = 2269,
  [3360] = 2272,
  [3361] = 2300,
  [3362] = 2253,
  [3363] = 2285,
  [3364] = 2273,
  [3365] = 2287,
  [3366] = 2277,
  [3367] = 2288,
  [3368] = 2282,
  [3369] = 2283,
  [3370] = 2258,
  [3371] = 2290,
  [3372] = 2298,
  [3373] = 2299,
  [3374] = 2362,
  [3375] = 2291,
  [3376] = 2265,
  [3377] = 2254,
  [3378] = 2255,
  [3379] = 2306,
  [3380] = 2256,
  [3381] = 2257,
  [3382] = 2245,
  [3383] = 2284,
  [3384] = 2309,
  [3385] = 2281,
  [3386] = 2130,
  [3387] = 2365,
  [3388] = 2297,
  [3389] = 2278,
  [3390] = 2303,
  [3391] = 2280,
  [3392] = 2246,
  [3393] = 2259,
  [3394] = 2248,
  [3395] = 2270,
  [3396] = 2247,
  [3397] = 2252,
  [3398] = 2313,
  [3399] = 2314,
  [3400] = 2317,
  [3401] = 2328,
  [3402] = 2264,
  [3403] = 2333,
  [3404] = 2334,
  [3405] = 2335,
  [3406] = 2279,
  [3407] = 2251,
  [3408] = 2271,
  [3409] = 2275,
  [3410] = 2276,
  [3411] = 2312,
  [3412] = 3412,
  [3413] = 3412,
  [3414] = 3414,
  [3415] = 3415,
  [3416] = 3415,
  [3417] = 3417,
  [3418] = 3414,
  [3419] = 3417,
  [3420] = 3420,
  [3421] = 3421,
  [3422] = 3422,
  [3423] = 3421,
  [3424] = 3424,
  [3425] = 2365,
  [3426] = 3426,
  [3427] = 2164,
  [3428] = 2172,
  [3429] = 2140,
  [3430] = 2174,
  [3431] = 2142,
  [3432] = 2184,
  [3433] = 2149,
  [3434] = 2193,
  [3435] = 2173,
  [3436] = 2175,
  [3437] = 2194,
  [3438] = 2207,
  [3439] = 2151,
  [3440] = 2168,
  [3441] = 3441,
  [3442] = 2156,
  [3443] = 2196,
  [3444] = 2155,
  [3445] = 2163,
  [3446] = 2187,
  [3447] = 2176,
  [3448] = 2144,
  [3449] = 2148,
  [3450] = 2170,
  [3451] = 2179,
  [3452] = 2169,
  [3453] = 2171,
  [3454] = 2189,
  [3455] = 2195,
  [3456] = 2159,
  [3457] = 2180,
  [3458] = 2145,
  [3459] = 2167,
  [3460] = 2183,
  [3461] = 2190,
  [3462] = 2198,
  [3463] = 2199,
  [3464] = 2210,
  [3465] = 2191,
  [3466] = 2178,
  [3467] = 2188,
  [3468] = 2197,
  [3469] = 2206,
  [3470] = 2157,
  [3471] = 2152,
  [3472] = 3472,
  [3473] = 2186,
  [3474] = 2143,
  [3475] = 2139,
  [3476] = 2185,
  [3477] = 2204,
  [3478] = 2141,
  [3479] = 2200,
  [3480] = 2153,
  [3481] = 2165,
  [3482] = 2209,
  [3483] = 2146,
  [3484] = 2177,
  [3485] = 2181,
  [3486] = 2182,
  [3487] = 2166,
  [3488] = 2161,
  [3489] = 2192,
  [3490] = 2205,
  [3491] = 2147,
  [3492] = 2160,
  [3493] = 3493,
  [3494] = 3494,
  [3495] = 3495,
  [3496] = 3496,
  [3497] = 3495,
  [3498] = 3498,
  [3499] = 3498,
  [3500] = 3494,
  [3501] = 3501,
  [3502] = 3502,
  [3503] = 3503,
  [3504] = 3504,
  [3505] = 3505,
  [3506] = 3503,
  [3507] = 3505,
  [3508] = 3508,
  [3509] = 3509,
  [3510] = 3510,
  [3511] = 3511,
  [3512] = 3504,
  [3513] = 3513,
  [3514] = 3514,
  [3515] = 3511,
  [3516] = 3516,
  [3517] = 3517,
  [3518] = 3516,
  [3519] = 3519,
  [3520] = 3520,
  [3521] = 3521,
  [3522] = 3522,
  [3523] = 3523,
  [3524] = 3524,
  [3525] = 3525,
  [3526] = 3526,
  [3527] = 3527,
  [3528] = 3528,
  [3529] = 3529,
  [3530] = 3530,
  [3531] = 2365,
  [3532] = 3426,
  [3533] = 3533,
  [3534] = 3534,
  [3535] = 3535,
  [3536] = 3536,
  [3537] = 3535,
  [3538] = 3533,
  [3539] = 3539,
  [3540] = 3540,
  [3541] = 3541,
  [3542] = 3536,
  [3543] = 3541,
  [3544] = 3544,
  [3545] = 3545,
  [3546] = 3546,
  [3547] = 3547,
  [3548] = 3548,
  [3549] = 3549,
  [3550] = 3550,
  [3551] = 3551,
  [3552] = 3549,
  [3553] = 3553,
  [3554] = 3544,
  [3555] = 3550,
  [3556] = 3556,
  [3557] = 3557,
  [3558] = 3558,
  [3559] = 3556,
  [3560] = 3547,
  [3561] = 3546,
  [3562] = 3548,
  [3563] = 3563,
  [3564] = 3557,
  [3565] = 3565,
  [3566] = 3553,
  [3567] = 3551,
  [3568] = 3568,
  [3569] = 3569,
  [3570] = 3570,
  [3571] = 3571,
  [3572] = 3572,
  [3573] = 3573,
  [3574] = 3574,
  [3575] = 3575,
  [3576] = 3576,
  [3577] = 3569,
  [3578] = 3578,
  [3579] = 3579,
  [3580] = 3580,
  [3581] = 3581,
  [3582] = 3582,
  [3583] = 3583,
  [3584] = 3580,
  [3585] = 3585,
  [3586] = 3571,
  [3587] = 3587,
  [3588] = 3588,
  [3589] = 3589,
  [3590] = 3590,
  [3591] = 3591,
  [3592] = 3565,
  [3593] = 3593,
  [3594] = 3594,
  [3595] = 3582,
  [3596] = 3583,
  [3597] = 3597,
  [3598] = 3598,
  [3599] = 3599,
  [3600] = 3600,
  [3601] = 3601,
  [3602] = 3601,
  [3603] = 3601,
  [3604] = 3601,
  [3605] = 3601,
  [3606] = 3606,
  [3607] = 3601,
  [3608] = 3608,
  [3609] = 3601,
  [3610] = 3601,
  [3611] = 3601,
  [3612] = 3601,
  [3613] = 3601,
  [3614] = 3601,
  [3615] = 3601,
  [3616] = 3601,
  [3617] = 3601,
  [3618] = 3601,
  [3619] = 3619,
  [3620] = 3620,
  [3621] = 3621,
  [3622] = 3620,
  [3623] = 3620,
  [3624] = 3620,
  [3625] = 3620,
  [3626] = 3620,
  [3627] = 3620,
  [3628] = 3620,
  [3629] = 3620,
  [3630] = 3620,
  [3631] = 3620,
  [3632] = 3620,
  [3633] = 3620,
  [3634] = 3620,
  [3635] = 3621,
  [3636] = 3620,
  [3637] = 3620,
  [3638] = 3638,
  [3639] = 3639,
  [3640] = 3640,
  [3641] = 3641,
  [3642] = 3642,
  [3643] = 3643,
  [3644] = 3644,
  [3645] = 3645,
  [3646] = 3646,
  [3647] = 3647,
  [3648] = 3648,
  [3649] = 3649,
  [3650] = 3650,
  [3651] = 3651,
  [3652] = 3652,
  [3653] = 3653,
  [3654] = 3654,
  [3655] = 3655,
  [3656] = 3656,
  [3657] = 3657,
  [3658] = 3658,
  [3659] = 3659,
  [3660] = 3660,
  [3661] = 3661,
  [3662] = 3516,
  [3663] = 3511,
  [3664] = 3664,
  [3665] = 3536,
  [3666] = 3511,
  [3667] = 3667,
  [3668] = 3535,
  [3669] = 3516,
  [3670] = 3670,
  [3671] = 2204,
  [3672] = 2171,
  [3673] = 2139,
  [3674] = 2173,
  [3675] = 2174,
  [3676] = 2175,
  [3677] = 2176,
  [3678] = 2178,
  [3679] = 2179,
  [3680] = 2180,
  [3681] = 2182,
  [3682] = 2183,
  [3683] = 2186,
  [3684] = 2187,
  [3685] = 2188,
  [3686] = 2190,
  [3687] = 2191,
  [3688] = 2192,
  [3689] = 2193,
  [3690] = 2194,
  [3691] = 2195,
  [3692] = 2196,
  [3693] = 2197,
  [3694] = 2198,
  [3695] = 2199,
  [3696] = 3472,
  [3697] = 2205,
  [3698] = 2207,
  [3699] = 2209,
  [3700] = 2177,
  [3701] = 2200,
  [3702] = 2142,
  [3703] = 2143,
  [3704] = 2145,
  [3705] = 2147,
  [3706] = 2149,
  [3707] = 2153,
  [3708] = 2206,
  [3709] = 2140,
  [3710] = 2164,
  [3711] = 2170,
  [3712] = 2155,
  [3713] = 2148,
  [3714] = 2365,
  [3715] = 2146,
  [3716] = 3511,
  [3717] = 2156,
  [3718] = 3553,
  [3719] = 3441,
  [3720] = 2157,
  [3721] = 2168,
  [3722] = 2144,
  [3723] = 2161,
  [3724] = 2163,
  [3725] = 3544,
  [3726] = 2165,
  [3727] = 2166,
  [3728] = 3546,
  [3729] = 2210,
  [3730] = 3516,
  [3731] = 2181,
  [3732] = 2184,
  [3733] = 2141,
  [3734] = 2160,
  [3735] = 2152,
  [3736] = 3426,
  [3737] = 2185,
  [3738] = 3536,
  [3739] = 2189,
  [3740] = 2172,
  [3741] = 2159,
  [3742] = 3535,
  [3743] = 2167,
  [3744] = 2169,
  [3745] = 2151,
  [3746] = 2171,
  [3747] = 2168,
  [3748] = 2152,
  [3749] = 3551,
  [3750] = 2185,
  [3751] = 2189,
  [3752] = 2172,
  [3753] = 2159,
  [3754] = 2365,
  [3755] = 3755,
  [3756] = 2146,
  [3757] = 2167,
  [3758] = 3541,
  [3759] = 3553,
  [3760] = 2169,
  [3761] = 2170,
  [3762] = 2139,
  [3763] = 2173,
  [3764] = 2174,
  [3765] = 3544,
  [3766] = 2175,
  [3767] = 2176,
  [3768] = 2178,
  [3769] = 2179,
  [3770] = 2180,
  [3771] = 2182,
  [3772] = 2183,
  [3773] = 2144,
  [3774] = 2186,
  [3775] = 3546,
  [3776] = 2187,
  [3777] = 2188,
  [3778] = 2190,
  [3779] = 2191,
  [3780] = 2192,
  [3781] = 2193,
  [3782] = 2194,
  [3783] = 2195,
  [3784] = 2196,
  [3785] = 2197,
  [3786] = 2160,
  [3787] = 2198,
  [3788] = 2199,
  [3789] = 2163,
  [3790] = 2165,
  [3791] = 2204,
  [3792] = 2205,
  [3793] = 2207,
  [3794] = 2209,
  [3795] = 3472,
  [3796] = 2177,
  [3797] = 2200,
  [3798] = 2142,
  [3799] = 3441,
  [3800] = 3571,
  [3801] = 2156,
  [3802] = 3535,
  [3803] = 2143,
  [3804] = 2145,
  [3805] = 3508,
  [3806] = 2147,
  [3807] = 2149,
  [3808] = 2153,
  [3809] = 3426,
  [3810] = 3548,
  [3811] = 2206,
  [3812] = 2140,
  [3813] = 2164,
  [3814] = 2151,
  [3815] = 2155,
  [3816] = 2148,
  [3817] = 2166,
  [3818] = 2210,
  [3819] = 2181,
  [3820] = 2184,
  [3821] = 2141,
  [3822] = 2157,
  [3823] = 3536,
  [3824] = 2161,
  [3825] = 3521,
  [3826] = 3522,
  [3827] = 3510,
  [3828] = 3513,
  [3829] = 3509,
  [3830] = 3523,
  [3831] = 3530,
  [3832] = 3832,
  [3833] = 3519,
  [3834] = 3571,
  [3835] = 3517,
  [3836] = 3540,
  [3837] = 3501,
  [3838] = 3502,
  [3839] = 3546,
  [3840] = 3553,
  [3841] = 3544,
  [3842] = 3571,
  [3843] = 3501,
  [3844] = 3502,
  [3845] = 3509,
  [3846] = 3526,
  [3847] = 3525,
  [3848] = 3510,
  [3849] = 3849,
  [3850] = 3524,
  [3851] = 3513,
  [3852] = 3852,
  [3853] = 3853,
  [3854] = 3853,
  [3855] = 3852,
  [3856] = 3525,
  [3857] = 3852,
  [3858] = 3858,
  [3859] = 3859,
  [3860] = 3853,
  [3861] = 3858,
  [3862] = 3862,
  [3863] = 3853,
  [3864] = 3858,
  [3865] = 3852,
  [3866] = 3853,
  [3867] = 3867,
  [3868] = 3526,
  [3869] = 3524,
  [3870] = 3852,
  [3871] = 3859,
  [3872] = 3867,
  [3873] = 3859,
  [3874] = 3874,
  [3875] = 3875,
  [3876] = 3876,
  [3877] = 3876,
  [3878] = 3878,
  [3879] = 3878,
  [3880] = 3880,
  [3881] = 3881,
  [3882] = 3882,
  [3883] = 3883,
  [3884] = 3883,
  [3885] = 3885,
  [3886] = 3885,
  [3887] = 3887,
  [3888] = 3888,
  [3889] = 3889,
  [3890] = 3890,
  [3891] = 3891,
  [3892] = 3892,
  [3893] = 3893,
  [3894] = 3894,
  [3895] = 3895,
  [3896] = 3896,
  [3897] = 3897,
  [3898] = 3898,
  [3899] = 3893,
  [3900] = 3892,
  [3901] = 3896,
  [3902] = 3897,
  [3903] = 3898,
  [3904] = 3891,
  [3905] = 3905,
  [3906] = 3906,
  [3907] = 3907,
  [3908] = 3905,
  [3909] = 3906,
  [3910] = 3894,
  [3911] = 3895,
  [3912] = 3912,
  [3913] = 3913,
  [3914] = 3914,
  [3915] = 3915,
  [3916] = 3916,
  [3917] = 3917,
  [3918] = 3918,
  [3919] = 3919,
  [3920] = 3920,
  [3921] = 3919,
  [3922] = 3922,
  [3923] = 3914,
  [3924] = 3924,
  [3925] = 3925,
  [3926] = 3917,
  [3927] = 3927,
  [3928] = 3928,
  [3929] = 3924,
  [3930] = 3928,
  [3931] = 3931,
  [3932] = 3931,
  [3933] = 3920,
  [3934] = 3916,
  [3935] = 3935,
  [3936] = 3936,
  [3937] = 3498,
  [3938] = 3938,
  [3939] = 3939,
  [3940] = 3940,
  [3941] = 3941,
  [3942] = 3942,
  [3943] = 3943,
  [3944] = 3944,
  [3945] = 3945,
  [3946] = 3946,
  [3947] = 3947,
  [3948] = 3948,
  [3949] = 3949,
  [3950] = 3950,
  [3951] = 3951,
  [3952] = 3952,
  [3953] = 3953,
  [3954] = 3954,
  [3955] = 3955,
  [3956] = 3956,
  [3957] = 3957,
  [3958] = 3958,
  [3959] = 3959,
  [3960] = 3960,
  [3961] = 3961,
  [3962] = 3962,
  [3963] = 3963,
  [3964] = 3958,
  [3965] = 3965,
  [3966] = 3966,
  [3967] = 3958,
  [3968] = 3968,
  [3969] = 3961,
  [3970] = 3958,
  [3971] = 3958,
  [3972] = 3958,
  [3973] = 3958,
  [3974] = 3958,
  [3975] = 3956,
  [3976] = 3961,
  [3977] = 3977,
  [3978] = 3958,
  [3979] = 3961,
  [3980] = 3958,
  [3981] = 3961,
  [3982] = 3982,
  [3983] = 3961,
  [3984] = 3961,
  [3985] = 3985,
  [3986] = 3956,
  [3987] = 3958,
  [3988] = 3988,
  [3989] = 3956,
  [3990] = 3961,
  [3991] = 3956,
  [3992] = 3992,
  [3993] = 3993,
  [3994] = 3993,
  [3995] = 3961,
  [3996] = 3958,
  [3997] = 3958,
  [3998] = 3998,
  [3999] = 3958,
  [4000] = 3961,
  [4001] = 3961,
  [4002] = 3958,
  [4003] = 3961,
  [4004] = 3961,
  [4005] = 3961,
  [4006] = 3958,
  [4007] = 3961,
  [4008] = 3958,
  [4009] = 4009,
  [4010] = 3993,
  [4011] = 4011,
  [4012] = 4012,
  [4013] = 3961,
  [4014] = 4014,
  [4015] = 4015,
  [4016] = 4016,
  [4017] = 4017,
  [4018] = 4016,
  [4019] = 4019,
  [4020] = 4020,
  [4021] = 4020,
  [4022] = 4022,
  [4023] = 4023,
  [4024] = 4015,
  [4025] = 4016,
  [4026] = 4020,
  [4027] = 2158,
  [4028] = 4015,
  [4029] = 1601,
  [4030] = 4016,
  [4031] = 4016,
  [4032] = 1602,
  [4033] = 1600,
  [4034] = 4016,
  [4035] = 4017,
  [4036] = 4017,
  [4037] = 4037,
  [4038] = 4038,
  [4039] = 4020,
  [4040] = 4015,
  [4041] = 4016,
  [4042] = 4017,
  [4043] = 2150,
  [4044] = 4044,
  [4045] = 4016,
  [4046] = 4020,
  [4047] = 4016,
  [4048] = 4017,
  [4049] = 4015,
  [4050] = 4050,
  [4051] = 4051,
  [4052] = 4020,
  [4053] = 4017,
  [4054] = 4022,
  [4055] = 4016,
  [4056] = 4016,
  [4057] = 4015,
  [4058] = 4017,
  [4059] = 4059,
  [4060] = 4016,
  [4061] = 4015,
  [4062] = 4020,
  [4063] = 4016,
  [4064] = 4064,
  [4065] = 4020,
  [4066] = 4066,
  [4067] = 4067,
  [4068] = 4068,
  [4069] = 4015,
  [4070] = 4070,
  [4071] = 4071,
  [4072] = 4015,
  [4073] = 4071,
  [4074] = 4074,
  [4075] = 4075,
  [4076] = 4017,
  [4077] = 4015,
  [4078] = 4016,
  [4079] = 4075,
  [4080] = 4017,
  [4081] = 4020,
  [4082] = 4071,
  [4083] = 4075,
  [4084] = 4020,
  [4085] = 4071,
  [4086] = 4075,
  [4087] = 4087,
  [4088] = 4017,
  [4089] = 4071,
  [4090] = 4075,
  [4091] = 4071,
  [4092] = 4015,
  [4093] = 4075,
  [4094] = 4094,
  [4095] = 4071,
  [4096] = 4015,
  [4097] = 4075,
  [4098] = 4071,
  [4099] = 4075,
  [4100] = 4071,
  [4101] = 4075,
  [4102] = 4015,
  [4103] = 4020,
  [4104] = 4071,
  [4105] = 4075,
  [4106] = 4071,
  [4107] = 4075,
  [4108] = 4108,
  [4109] = 4071,
  [4110] = 4075,
  [4111] = 4111,
  [4112] = 4016,
  [4113] = 4071,
  [4114] = 4075,
  [4115] = 4071,
  [4116] = 4075,
  [4117] = 4071,
  [4118] = 4075,
  [4119] = 4071,
  [4120] = 4015,
  [4121] = 4075,
  [4122] = 4017,
  [4123] = 4071,
  [4124] = 4075,
  [4125] = 4017,
  [4126] = 4020,
  [4127] = 4017,
  [4128] = 4128,
  [4129] = 4020,
  [4130] = 4016,
  [4131] = 4020,
  [4132] = 4017,
  [4133] = 4133,
  [4134] = 4134,
  [4135] = 4020,
  [4136] = 4015,
  [4137] = 4015,
  [4138] = 4017,
  [4139] = 4051,
  [4140] = 4015,
  [4141] = 4020,
  [4142] = 4017,
  [4143] = 4143,
  [4144] = 4144,
  [4145] = 4145,
  [4146] = 4146,
  [4147] = 4147,
  [4148] = 4148,
  [4149] = 4149,
  [4150] = 4149,
  [4151] = 4151,
  [4152] = 4152,
  [4153] = 4153,
  [4154] = 4149,
  [4155] = 4149,
  [4156] = 4156,
  [4157] = 3516,
  [4158] = 4148,
  [4159] = 4159,
  [4160] = 4160,
  [4161] = 4144,
  [4162] = 3472,
  [4163] = 4159,
  [4164] = 4164,
  [4165] = 4165,
  [4166] = 3511,
  [4167] = 4167,
  [4168] = 4168,
  [4169] = 3516,
  [4170] = 4170,
  [4171] = 4171,
  [4172] = 4172,
  [4173] = 4173,
  [4174] = 4174,
  [4175] = 4175,
  [4176] = 4149,
  [4177] = 4149,
  [4178] = 4149,
  [4179] = 4179,
  [4180] = 4180,
  [4181] = 4149,
  [4182] = 3504,
  [4183] = 4183,
  [4184] = 4164,
  [4185] = 4171,
  [4186] = 4186,
  [4187] = 4187,
  [4188] = 4188,
  [4189] = 4189,
  [4190] = 4190,
  [4191] = 4191,
  [4192] = 4192,
  [4193] = 4188,
  [4194] = 4194,
  [4195] = 3505,
  [4196] = 4196,
  [4197] = 4197,
  [4198] = 4149,
  [4199] = 3503,
  [4200] = 4200,
  [4201] = 4151,
  [4202] = 4164,
  [4203] = 4153,
  [4204] = 4204,
  [4205] = 4149,
  [4206] = 4149,
  [4207] = 4207,
  [4208] = 4188,
  [4209] = 4209,
  [4210] = 4210,
  [4211] = 2313,
  [4212] = 4212,
  [4213] = 3493,
  [4214] = 4149,
  [4215] = 4215,
  [4216] = 4216,
  [4217] = 4217,
  [4218] = 4218,
  [4219] = 4149,
  [4220] = 4149,
  [4221] = 4221,
  [4222] = 4222,
  [4223] = 4149,
  [4224] = 4156,
  [4225] = 4225,
  [4226] = 4226,
  [4227] = 4227,
  [4228] = 4228,
  [4229] = 4229,
  [4230] = 4230,
  [4231] = 4170,
  [4232] = 4232,
  [4233] = 3511,
  [4234] = 4160,
  [4235] = 4235,
  [4236] = 4180,
  [4237] = 4192,
  [4238] = 4225,
  [4239] = 4149,
  [4240] = 4240,
  [4241] = 4240,
  [4242] = 3496,
  [4243] = 4243,
  [4244] = 4244,
  [4245] = 4245,
  [4246] = 4246,
  [4247] = 4247,
  [4248] = 4240,
  [4249] = 4249,
  [4250] = 4250,
  [4251] = 4245,
  [4252] = 4246,
  [4253] = 4243,
  [4254] = 4254,
  [4255] = 4247,
  [4256] = 4256,
  [4257] = 4257,
  [4258] = 4258,
  [4259] = 4259,
  [4260] = 4260,
  [4261] = 4261,
  [4262] = 4262,
  [4263] = 4263,
  [4264] = 4264,
  [4265] = 4265,
  [4266] = 4244,
  [4267] = 4262,
  [4268] = 4268,
  [4269] = 4269,
  [4270] = 3535,
  [4271] = 4271,
  [4272] = 4272,
  [4273] = 4262,
  [4274] = 4258,
  [4275] = 4245,
  [4276] = 4245,
  [4277] = 4262,
  [4278] = 4249,
  [4279] = 4250,
  [4280] = 4280,
  [4281] = 4263,
  [4282] = 4244,
  [4283] = 4283,
  [4284] = 3520,
  [4285] = 4240,
  [4286] = 4240,
  [4287] = 4287,
  [4288] = 4258,
  [4289] = 4289,
  [4290] = 4243,
  [4291] = 4240,
  [4292] = 4292,
  [4293] = 4258,
  [4294] = 4294,
  [4295] = 4243,
  [4296] = 4296,
  [4297] = 4246,
  [4298] = 4262,
  [4299] = 4299,
  [4300] = 4300,
  [4301] = 4262,
  [4302] = 4302,
  [4303] = 4283,
  [4304] = 4304,
  [4305] = 4263,
  [4306] = 4243,
  [4307] = 4244,
  [4308] = 4308,
  [4309] = 4309,
  [4310] = 4310,
  [4311] = 4287,
  [4312] = 4262,
  [4313] = 4263,
  [4314] = 4283,
  [4315] = 4240,
  [4316] = 4243,
  [4317] = 4247,
  [4318] = 4318,
  [4319] = 4319,
  [4320] = 4244,
  [4321] = 4246,
  [4322] = 4262,
  [4323] = 4240,
  [4324] = 4244,
  [4325] = 4243,
  [4326] = 4263,
  [4327] = 4327,
  [4328] = 4262,
  [4329] = 4258,
  [4330] = 4263,
  [4331] = 4244,
  [4332] = 4245,
  [4333] = 4333,
  [4334] = 4246,
  [4335] = 4240,
  [4336] = 4244,
  [4337] = 4319,
  [4338] = 4338,
  [4339] = 4339,
  [4340] = 4340,
  [4341] = 4240,
  [4342] = 4243,
  [4343] = 4258,
  [4344] = 4262,
  [4345] = 4345,
  [4346] = 4262,
  [4347] = 4258,
  [4348] = 4258,
  [4349] = 4249,
  [4350] = 4287,
  [4351] = 4351,
  [4352] = 4352,
  [4353] = 4263,
  [4354] = 4354,
  [4355] = 4258,
  [4356] = 4244,
  [4357] = 4357,
  [4358] = 4240,
  [4359] = 4243,
  [4360] = 4319,
  [4361] = 4262,
  [4362] = 4362,
  [4363] = 4363,
  [4364] = 4263,
  [4365] = 4262,
  [4366] = 4263,
  [4367] = 4244,
  [4368] = 4258,
  [4369] = 4263,
  [4370] = 4244,
  [4371] = 4245,
  [4372] = 4263,
  [4373] = 4244,
  [4374] = 3533,
  [4375] = 4375,
  [4376] = 4263,
  [4377] = 4244,
  [4378] = 4262,
  [4379] = 4379,
  [4380] = 3536,
  [4381] = 4243,
  [4382] = 4319,
  [4383] = 4250,
  [4384] = 4240,
  [4385] = 4243,
  [4386] = 4258,
  [4387] = 4258,
  [4388] = 4240,
  [4389] = 4258,
  [4390] = 4262,
  [4391] = 4258,
  [4392] = 4246,
  [4393] = 4240,
  [4394] = 4258,
  [4395] = 4243,
  [4396] = 4396,
  [4397] = 4263,
  [4398] = 4244,
  [4399] = 3514,
  [4400] = 4400,
  [4401] = 4243,
  [4402] = 4240,
  [4403] = 4403,
  [4404] = 4263,
  [4405] = 4244,
  [4406] = 4319,
  [4407] = 4407,
  [4408] = 4240,
  [4409] = 4243,
  [4410] = 3535,
  [4411] = 3536,
  [4412] = 4243,
  [4413] = 4413,
  [4414] = 4414,
  [4415] = 4415,
  [4416] = 4258,
  [4417] = 4417,
  [4418] = 4263,
  [4419] = 4263,
  [4420] = 4244,
  [4421] = 4262,
  [4422] = 4243,
  [4423] = 3511,
  [4424] = 4424,
  [4425] = 4425,
  [4426] = 4426,
  [4427] = 4427,
  [4428] = 4428,
  [4429] = 4429,
  [4430] = 4430,
  [4431] = 4431,
  [4432] = 4432,
  [4433] = 4433,
  [4434] = 4434,
  [4435] = 4435,
  [4436] = 4436,
  [4437] = 4437,
  [4438] = 4438,
  [4439] = 4439,
  [4440] = 4440,
  [4441] = 4426,
  [4442] = 4442,
  [4443] = 4427,
  [4444] = 4440,
  [4445] = 4440,
  [4446] = 4442,
  [4447] = 4447,
  [4448] = 4448,
  [4449] = 4449,
  [4450] = 4450,
  [4451] = 4442,
  [4452] = 4452,
  [4453] = 3511,
  [4454] = 4454,
  [4455] = 4455,
  [4456] = 4456,
  [4457] = 4447,
  [4458] = 4448,
  [4459] = 4449,
  [4460] = 4456,
  [4461] = 4428,
  [4462] = 4429,
  [4463] = 4430,
  [4464] = 4432,
  [4465] = 4452,
  [4466] = 4434,
  [4467] = 4436,
  [4468] = 4438,
  [4469] = 4439,
  [4470] = 4426,
  [4471] = 4427,
  [4472] = 4440,
  [4473] = 4442,
  [4474] = 4447,
  [4475] = 4448,
  [4476] = 4449,
  [4477] = 4450,
  [4478] = 4452,
  [4479] = 3511,
  [4480] = 4480,
  [4481] = 4456,
  [4482] = 4428,
  [4483] = 4429,
  [4484] = 4430,
  [4485] = 4432,
  [4486] = 4434,
  [4487] = 4436,
  [4488] = 4438,
  [4489] = 4439,
  [4490] = 4426,
  [4491] = 4427,
  [4492] = 4454,
  [4493] = 4440,
  [4494] = 4442,
  [4495] = 4447,
  [4496] = 4448,
  [4497] = 4449,
  [4498] = 4450,
  [4499] = 4452,
  [4500] = 3511,
  [4501] = 4501,
  [4502] = 4456,
  [4503] = 4428,
  [4504] = 4429,
  [4505] = 4430,
  [4506] = 4432,
  [4507] = 4425,
  [4508] = 4434,
  [4509] = 4436,
  [4510] = 4438,
  [4511] = 4439,
  [4512] = 4426,
  [4513] = 4427,
  [4514] = 4440,
  [4515] = 4442,
  [4516] = 4447,
  [4517] = 4448,
  [4518] = 4449,
  [4519] = 4450,
  [4520] = 4452,
  [4521] = 3511,
  [4522] = 3511,
  [4523] = 4456,
  [4524] = 3553,
  [4525] = 3550,
  [4526] = 4455,
  [4527] = 4428,
  [4528] = 4429,
  [4529] = 4430,
  [4530] = 4432,
  [4531] = 4434,
  [4532] = 4436,
  [4533] = 4438,
  [4534] = 4439,
  [4535] = 4426,
  [4536] = 4427,
  [4537] = 4537,
  [4538] = 4538,
  [4539] = 4539,
  [4540] = 4440,
  [4541] = 4442,
  [4542] = 4447,
  [4543] = 4448,
  [4544] = 4449,
  [4545] = 4450,
  [4546] = 2312,
  [4547] = 4452,
  [4548] = 4456,
  [4549] = 4447,
  [4550] = 4448,
  [4551] = 4449,
  [4552] = 4430,
  [4553] = 4432,
  [4554] = 4436,
  [4555] = 4450,
  [4556] = 4439,
  [4557] = 4426,
  [4558] = 4427,
  [4559] = 4559,
  [4560] = 4440,
  [4561] = 4448,
  [4562] = 4449,
  [4563] = 4450,
  [4564] = 4452,
  [4565] = 4452,
  [4566] = 4428,
  [4567] = 4567,
  [4568] = 4568,
  [4569] = 4539,
  [4570] = 4429,
  [4571] = 4571,
  [4572] = 4430,
  [4573] = 4573,
  [4574] = 4574,
  [4575] = 4575,
  [4576] = 4432,
  [4577] = 4577,
  [4578] = 4578,
  [4579] = 4579,
  [4580] = 4580,
  [4581] = 4581,
  [4582] = 4582,
  [4583] = 4434,
  [4584] = 4584,
  [4585] = 4436,
  [4586] = 4537,
  [4587] = 4559,
  [4588] = 4577,
  [4589] = 4578,
  [4590] = 4590,
  [4591] = 4591,
  [4592] = 4592,
  [4593] = 4593,
  [4594] = 4438,
  [4595] = 4439,
  [4596] = 4596,
  [4597] = 4426,
  [4598] = 4427,
  [4599] = 4440,
  [4600] = 4571,
  [4601] = 4442,
  [4602] = 4573,
  [4603] = 4574,
  [4604] = 4454,
  [4605] = 4455,
  [4606] = 4447,
  [4607] = 4448,
  [4608] = 4449,
  [4609] = 4450,
  [4610] = 4580,
  [4611] = 4581,
  [4612] = 4582,
  [4613] = 4584,
  [4614] = 4452,
  [4615] = 4615,
  [4616] = 4616,
  [4617] = 4617,
  [4618] = 3511,
  [4619] = 4537,
  [4620] = 4578,
  [4621] = 4592,
  [4622] = 4538,
  [4623] = 4539,
  [4624] = 4571,
  [4625] = 4573,
  [4626] = 4456,
  [4627] = 4580,
  [4628] = 4581,
  [4629] = 4582,
  [4630] = 4584,
  [4631] = 4631,
  [4632] = 4428,
  [4633] = 4456,
  [4634] = 4537,
  [4635] = 4578,
  [4636] = 4592,
  [4637] = 4637,
  [4638] = 4428,
  [4639] = 4429,
  [4640] = 4571,
  [4641] = 4573,
  [4642] = 4430,
  [4643] = 4643,
  [4644] = 4432,
  [4645] = 4581,
  [4646] = 4582,
  [4647] = 4584,
  [4648] = 4648,
  [4649] = 3557,
  [4650] = 4434,
  [4651] = 4436,
  [4652] = 4578,
  [4653] = 4592,
  [4654] = 4559,
  [4655] = 4438,
  [4656] = 4439,
  [4657] = 4426,
  [4658] = 4590,
  [4659] = 4574,
  [4660] = 4660,
  [4661] = 4427,
  [4662] = 4425,
  [4663] = 4663,
  [4664] = 4664,
  [4665] = 4592,
  [4666] = 4440,
  [4667] = 3511,
  [4668] = 4442,
  [4669] = 4591,
  [4670] = 4454,
  [4671] = 4447,
  [4672] = 4448,
  [4673] = 4449,
  [4674] = 4674,
  [4675] = 4450,
  [4676] = 4452,
  [4677] = 4428,
  [4678] = 4678,
  [4679] = 4679,
  [4680] = 4592,
  [4681] = 4438,
  [4682] = 4592,
  [4683] = 3511,
  [4684] = 4439,
  [4685] = 4685,
  [4686] = 4538,
  [4687] = 4426,
  [4688] = 4539,
  [4689] = 4456,
  [4690] = 3556,
  [4691] = 4456,
  [4692] = 4592,
  [4693] = 2306,
  [4694] = 4567,
  [4695] = 4428,
  [4696] = 4427,
  [4697] = 4429,
  [4698] = 4430,
  [4699] = 4225,
  [4700] = 2308,
  [4701] = 2309,
  [4702] = 4432,
  [4703] = 3544,
  [4704] = 4434,
  [4705] = 4592,
  [4706] = 4706,
  [4707] = 4436,
  [4708] = 4568,
  [4709] = 4559,
  [4710] = 4438,
  [4711] = 4439,
  [4712] = 4156,
  [4713] = 4580,
  [4714] = 4714,
  [4715] = 4426,
  [4716] = 4440,
  [4717] = 4428,
  [4718] = 4427,
  [4719] = 4442,
  [4720] = 4720,
  [4721] = 4567,
  [4722] = 4722,
  [4723] = 4592,
  [4724] = 4568,
  [4725] = 4429,
  [4726] = 4440,
  [4727] = 4442,
  [4728] = 4454,
  [4729] = 4447,
  [4730] = 4448,
  [4731] = 4449,
  [4732] = 4450,
  [4733] = 4430,
  [4734] = 4452,
  [4735] = 4429,
  [4736] = 4430,
  [4737] = 4592,
  [4738] = 3511,
  [4739] = 4739,
  [4740] = 4432,
  [4741] = 4741,
  [4742] = 4434,
  [4743] = 4743,
  [4744] = 4456,
  [4745] = 4454,
  [4746] = 4436,
  [4747] = 4434,
  [4748] = 4456,
  [4749] = 4559,
  [4750] = 4592,
  [4751] = 4577,
  [4752] = 4455,
  [4753] = 4590,
  [4754] = 4428,
  [4755] = 4429,
  [4756] = 4430,
  [4757] = 4432,
  [4758] = 4591,
  [4759] = 4432,
  [4760] = 4434,
  [4761] = 4436,
  [4762] = 4438,
  [4763] = 4763,
  [4764] = 4439,
  [4765] = 4592,
  [4766] = 4438,
  [4767] = 4439,
  [4768] = 4768,
  [4769] = 4426,
  [4770] = 4426,
  [4771] = 4771,
  [4772] = 4427,
  [4773] = 4575,
  [4774] = 4427,
  [4775] = 4775,
  [4776] = 4440,
  [4777] = 4442,
  [4778] = 4447,
  [4779] = 4592,
  [4780] = 4448,
  [4781] = 4781,
  [4782] = 4449,
  [4783] = 4450,
  [4784] = 4452,
  [4785] = 4440,
  [4786] = 3511,
  [4787] = 4442,
  [4788] = 4434,
  [4789] = 4454,
  [4790] = 4455,
  [4791] = 4447,
  [4792] = 4456,
  [4793] = 4448,
  [4794] = 4592,
  [4795] = 4449,
  [4796] = 4450,
  [4797] = 4797,
  [4798] = 4452,
  [4799] = 4436,
  [4800] = 3546,
  [4801] = 4428,
  [4802] = 4581,
  [4803] = 4429,
  [4804] = 4430,
  [4805] = 4432,
  [4806] = 4592,
  [4807] = 4434,
  [4808] = 4436,
  [4809] = 4438,
  [4810] = 4439,
  [4811] = 4426,
  [4812] = 3516,
  [4813] = 4436,
  [4814] = 4427,
  [4815] = 4815,
  [4816] = 4559,
  [4817] = 4817,
  [4818] = 4425,
  [4819] = 4440,
  [4820] = 4442,
  [4821] = 4447,
  [4822] = 4448,
  [4823] = 4449,
  [4824] = 4450,
  [4825] = 4452,
  [4826] = 3511,
  [4827] = 3511,
  [4828] = 4828,
  [4829] = 4425,
  [4830] = 4577,
  [4831] = 4538,
  [4832] = 4456,
  [4833] = 4539,
  [4834] = 4590,
  [4835] = 4456,
  [4836] = 4591,
  [4837] = 4428,
  [4838] = 3516,
  [4839] = 4429,
  [4840] = 4430,
  [4841] = 4432,
  [4842] = 4674,
  [4843] = 4843,
  [4844] = 3516,
  [4845] = 4434,
  [4846] = 4436,
  [4847] = 4847,
  [4848] = 4848,
  [4849] = 3516,
  [4850] = 4850,
  [4851] = 4573,
  [4852] = 4438,
  [4853] = 4439,
  [4854] = 3516,
  [4855] = 4855,
  [4856] = 4426,
  [4857] = 4438,
  [4858] = 4428,
  [4859] = 4447,
  [4860] = 3516,
  [4861] = 4427,
  [4862] = 4567,
  [4863] = 4863,
  [4864] = 3516,
  [4865] = 4582,
  [4866] = 4866,
  [4867] = 4448,
  [4868] = 3516,
  [4869] = 4440,
  [4870] = 4449,
  [4871] = 4442,
  [4872] = 4447,
  [4873] = 3516,
  [4874] = 4448,
  [4875] = 4875,
  [4876] = 4449,
  [4877] = 4450,
  [4878] = 4452,
  [4879] = 4567,
  [4880] = 4450,
  [4881] = 3516,
  [4882] = 3511,
  [4883] = 4568,
  [4884] = 4584,
  [4885] = 4568,
  [4886] = 4452,
  [4887] = 4439,
  [4888] = 4429,
  [4889] = 3516,
  [4890] = 4430,
  [4891] = 4781,
  [4892] = 4456,
  [4893] = 3516,
  [4894] = 4714,
  [4895] = 4432,
  [4896] = 4896,
  [4897] = 3516,
  [4898] = 4898,
  [4899] = 4428,
  [4900] = 4429,
  [4901] = 4430,
  [4902] = 4434,
  [4903] = 4432,
  [4904] = 4426,
  [4905] = 4436,
  [4906] = 4434,
  [4907] = 4907,
  [4908] = 4436,
  [4909] = 4909,
  [4910] = 4910,
  [4911] = 4438,
  [4912] = 4439,
  [4913] = 4432,
  [4914] = 4426,
  [4915] = 4571,
  [4916] = 4427,
  [4917] = 4538,
  [4918] = 4918,
  [4919] = 4559,
  [4920] = 4920,
  [4921] = 4440,
  [4922] = 4922,
  [4923] = 4442,
  [4924] = 4447,
  [4925] = 4448,
  [4926] = 4449,
  [4927] = 4450,
  [4928] = 4577,
  [4929] = 4452,
  [4930] = 4429,
  [4931] = 4430,
  [4932] = 4590,
  [4933] = 4933,
  [4934] = 4934,
  [4935] = 3511,
  [4936] = 4591,
  [4937] = 4937,
  [4938] = 4427,
  [4939] = 4438,
  [4940] = 4940,
  [4941] = 4439,
  [4942] = 4450,
  [4943] = 4943,
  [4944] = 4943,
  [4945] = 4945,
  [4946] = 4946,
  [4947] = 4943,
  [4948] = 3950,
  [4949] = 4949,
  [4950] = 4950,
  [4951] = 4951,
  [4952] = 4943,
  [4953] = 2221,
  [4954] = 4954,
  [4955] = 4955,
  [4956] = 3945,
  [4957] = 4950,
  [4958] = 4958,
  [4959] = 4943,
  [4960] = 4960,
  [4961] = 4961,
  [4962] = 4951,
  [4963] = 4951,
  [4964] = 4964,
  [4965] = 4943,
  [4966] = 3571,
  [4967] = 4967,
  [4968] = 3948,
  [4969] = 4951,
  [4970] = 4970,
  [4971] = 4971,
  [4972] = 4943,
  [4973] = 4973,
  [4974] = 4943,
  [4975] = 4975,
  [4976] = 4976,
  [4977] = 4943,
  [4978] = 4978,
  [4979] = 4951,
  [4980] = 4980,
  [4981] = 4951,
  [4982] = 4982,
  [4983] = 4943,
  [4984] = 4984,
  [4985] = 4951,
  [4986] = 3946,
  [4987] = 4987,
  [4988] = 4950,
  [4989] = 4943,
  [4990] = 4990,
  [4991] = 4991,
  [4992] = 4992,
  [4993] = 4993,
  [4994] = 4943,
  [4995] = 4951,
  [4996] = 4996,
  [4997] = 4997,
  [4998] = 4998,
  [4999] = 2231,
  [5000] = 5000,
  [5001] = 4951,
  [5002] = 5002,
  [5003] = 4951,
  [5004] = 5004,
  [5005] = 4951,
  [5006] = 2229,
  [5007] = 3947,
  [5008] = 4951,
  [5009] = 4943,
  [5010] = 5010,
  [5011] = 5011,
  [5012] = 4951,
  [5013] = 5013,
  [5014] = 5014,
  [5015] = 2237,
  [5016] = 5016,
  [5017] = 5017,
  [5018] = 4943,
  [5019] = 2234,
  [5020] = 3988,
  [5021] = 5021,
  [5022] = 5022,
  [5023] = 5023,
  [5024] = 5024,
  [5025] = 4951,
  [5026] = 2130,
  [5027] = 4943,
  [5028] = 4946,
  [5029] = 5029,
  [5030] = 5030,
  [5031] = 4951,
  [5032] = 5032,
  [5033] = 5033,
  [5034] = 4951,
  [5035] = 4943,
  [5036] = 5036,
  [5037] = 5037,
  [5038] = 5038,
  [5039] = 4951,
  [5040] = 4945,
  [5041] = 5041,
  [5042] = 2238,
  [5043] = 4945,
  [5044] = 4943,
  [5045] = 4945,
  [5046] = 4945,
  [5047] = 4945,
  [5048] = 4945,
  [5049] = 4945,
  [5050] = 4945,
  [5051] = 4945,
  [5052] = 4945,
  [5053] = 4945,
  [5054] = 4945,
  [5055] = 4945,
  [5056] = 4945,
  [5057] = 4945,
  [5058] = 4945,
  [5059] = 3558,
  [5060] = 5060,
  [5061] = 2191,
  [5062] = 5062,
  [5063] = 5063,
  [5064] = 5064,
  [5065] = 5065,
  [5066] = 5060,
  [5067] = 5067,
  [5068] = 2249,
  [5069] = 2192,
  [5070] = 5070,
  [5071] = 2193,
  [5072] = 5072,
  [5073] = 5073,
  [5074] = 5074,
  [5075] = 5075,
  [5076] = 5076,
  [5077] = 2194,
  [5078] = 5078,
  [5079] = 5070,
  [5080] = 5080,
  [5081] = 5081,
  [5082] = 2172,
  [5083] = 5083,
  [5084] = 5084,
  [5085] = 5085,
  [5086] = 5086,
  [5087] = 5087,
  [5088] = 2253,
  [5089] = 5089,
  [5090] = 5090,
  [5091] = 5091,
  [5092] = 5092,
  [5093] = 5060,
  [5094] = 5063,
  [5095] = 3957,
  [5096] = 2195,
  [5097] = 2196,
  [5098] = 5098,
  [5099] = 5099,
  [5100] = 5100,
  [5101] = 5089,
  [5102] = 5086,
  [5103] = 2159,
  [5104] = 5104,
  [5105] = 5105,
  [5106] = 5098,
  [5107] = 5107,
  [5108] = 2197,
  [5109] = 2198,
  [5110] = 2199,
  [5111] = 2167,
  [5112] = 2204,
  [5113] = 5086,
  [5114] = 5114,
  [5115] = 2205,
  [5116] = 5116,
  [5117] = 2298,
  [5118] = 5081,
  [5119] = 3593,
  [5120] = 5060,
  [5121] = 3594,
  [5122] = 5122,
  [5123] = 5123,
  [5124] = 2299,
  [5125] = 5081,
  [5126] = 5126,
  [5127] = 5063,
  [5128] = 5063,
  [5129] = 5084,
  [5130] = 5085,
  [5131] = 5131,
  [5132] = 5064,
  [5133] = 4011,
  [5134] = 2169,
  [5135] = 5067,
  [5136] = 2300,
  [5137] = 1601,
  [5138] = 5138,
  [5139] = 2362,
  [5140] = 5086,
  [5141] = 5141,
  [5142] = 2207,
  [5143] = 5143,
  [5144] = 5062,
  [5145] = 5145,
  [5146] = 5072,
  [5147] = 5060,
  [5148] = 5081,
  [5149] = 2264,
  [5150] = 5063,
  [5151] = 5151,
  [5152] = 5152,
  [5153] = 5153,
  [5154] = 5076,
  [5155] = 3572,
  [5156] = 5081,
  [5157] = 5084,
  [5158] = 5158,
  [5159] = 5159,
  [5160] = 5160,
  [5161] = 5085,
  [5162] = 2170,
  [5163] = 2302,
  [5164] = 2209,
  [5165] = 5165,
  [5166] = 5166,
  [5167] = 5086,
  [5168] = 5084,
  [5169] = 5169,
  [5170] = 5099,
  [5171] = 5099,
  [5172] = 5100,
  [5173] = 5081,
  [5174] = 5060,
  [5175] = 5175,
  [5176] = 5085,
  [5177] = 5084,
  [5178] = 5085,
  [5179] = 5086,
  [5180] = 5180,
  [5181] = 5181,
  [5182] = 2177,
  [5183] = 2161,
  [5184] = 5084,
  [5185] = 3998,
  [5186] = 5085,
  [5187] = 1600,
  [5188] = 5188,
  [5189] = 5189,
  [5190] = 5190,
  [5191] = 5060,
  [5192] = 3966,
  [5193] = 2200,
  [5194] = 5086,
  [5195] = 5060,
  [5196] = 5100,
  [5197] = 5197,
  [5198] = 5198,
  [5199] = 5199,
  [5200] = 5064,
  [5201] = 5060,
  [5202] = 2265,
  [5203] = 2142,
  [5204] = 2143,
  [5205] = 5205,
  [5206] = 5116,
  [5207] = 5207,
  [5208] = 5081,
  [5209] = 5116,
  [5210] = 5210,
  [5211] = 2171,
  [5212] = 5212,
  [5213] = 5063,
  [5214] = 5073,
  [5215] = 5215,
  [5216] = 5216,
  [5217] = 3959,
  [5218] = 5218,
  [5219] = 5083,
  [5220] = 5060,
  [5221] = 5221,
  [5222] = 5222,
  [5223] = 5223,
  [5224] = 5224,
  [5225] = 5151,
  [5226] = 5226,
  [5227] = 5227,
  [5228] = 5080,
  [5229] = 5229,
  [5230] = 2139,
  [5231] = 2145,
  [5232] = 5232,
  [5233] = 5078,
  [5234] = 5085,
  [5235] = 5235,
  [5236] = 2147,
  [5237] = 5063,
  [5238] = 4009,
  [5239] = 5239,
  [5240] = 5099,
  [5241] = 5100,
  [5242] = 5116,
  [5243] = 5243,
  [5244] = 5244,
  [5245] = 5074,
  [5246] = 5246,
  [5247] = 5247,
  [5248] = 5086,
  [5249] = 5249,
  [5250] = 5250,
  [5251] = 5251,
  [5252] = 5252,
  [5253] = 5175,
  [5254] = 5116,
  [5255] = 2149,
  [5256] = 1602,
  [5257] = 5250,
  [5258] = 2153,
  [5259] = 2206,
  [5260] = 5060,
  [5261] = 5081,
  [5262] = 5252,
  [5263] = 5116,
  [5264] = 5264,
  [5265] = 5265,
  [5266] = 5084,
  [5267] = 5267,
  [5268] = 5081,
  [5269] = 5269,
  [5270] = 5232,
  [5271] = 5084,
  [5272] = 5085,
  [5273] = 5085,
  [5274] = 5064,
  [5275] = 5275,
  [5276] = 5276,
  [5277] = 5090,
  [5278] = 5116,
  [5279] = 2140,
  [5280] = 2164,
  [5281] = 2158,
  [5282] = 3573,
  [5283] = 3575,
  [5284] = 2151,
  [5285] = 5285,
  [5286] = 5267,
  [5287] = 5243,
  [5288] = 5244,
  [5289] = 5289,
  [5290] = 5246,
  [5291] = 5063,
  [5292] = 3962,
  [5293] = 5293,
  [5294] = 2155,
  [5295] = 5275,
  [5296] = 5296,
  [5297] = 2148,
  [5298] = 2173,
  [5299] = 5116,
  [5300] = 5065,
  [5301] = 2271,
  [5302] = 5302,
  [5303] = 5243,
  [5304] = 5244,
  [5305] = 2146,
  [5306] = 5246,
  [5307] = 5307,
  [5308] = 2174,
  [5309] = 5063,
  [5310] = 5063,
  [5311] = 5296,
  [5312] = 5312,
  [5313] = 2163,
  [5314] = 5086,
  [5315] = 5315,
  [5316] = 5316,
  [5317] = 5243,
  [5318] = 5244,
  [5319] = 5063,
  [5320] = 5246,
  [5321] = 2175,
  [5322] = 5322,
  [5323] = 3597,
  [5324] = 5324,
  [5325] = 5060,
  [5326] = 2252,
  [5327] = 2232,
  [5328] = 5243,
  [5329] = 5244,
  [5330] = 2176,
  [5331] = 3581,
  [5332] = 5064,
  [5333] = 5249,
  [5334] = 5190,
  [5335] = 5081,
  [5336] = 5063,
  [5337] = 2165,
  [5338] = 2178,
  [5339] = 5243,
  [5340] = 5244,
  [5341] = 2269,
  [5342] = 5246,
  [5343] = 5343,
  [5344] = 5344,
  [5345] = 5345,
  [5346] = 5081,
  [5347] = 5081,
  [5348] = 5104,
  [5349] = 2270,
  [5350] = 5243,
  [5351] = 5244,
  [5352] = 2284,
  [5353] = 5246,
  [5354] = 5354,
  [5355] = 2179,
  [5356] = 5356,
  [5357] = 5357,
  [5358] = 2180,
  [5359] = 2166,
  [5360] = 5086,
  [5361] = 5243,
  [5362] = 5244,
  [5363] = 2210,
  [5364] = 5246,
  [5365] = 5365,
  [5366] = 5366,
  [5367] = 5116,
  [5368] = 5063,
  [5369] = 2182,
  [5370] = 2183,
  [5371] = 5084,
  [5372] = 5243,
  [5373] = 5244,
  [5374] = 5084,
  [5375] = 5246,
  [5376] = 5060,
  [5377] = 5377,
  [5378] = 5378,
  [5379] = 5085,
  [5380] = 5380,
  [5381] = 5381,
  [5382] = 5064,
  [5383] = 5243,
  [5384] = 5244,
  [5385] = 5244,
  [5386] = 5246,
  [5387] = 5084,
  [5388] = 2186,
  [5389] = 3963,
  [5390] = 5390,
  [5391] = 5085,
  [5392] = 2247,
  [5393] = 5085,
  [5394] = 5243,
  [5395] = 5244,
  [5396] = 5081,
  [5397] = 5246,
  [5398] = 5246,
  [5399] = 5399,
  [5400] = 5081,
  [5401] = 2181,
  [5402] = 5402,
  [5403] = 2184,
  [5404] = 5084,
  [5405] = 5243,
  [5406] = 5244,
  [5407] = 5087,
  [5408] = 5246,
  [5409] = 5085,
  [5410] = 2141,
  [5411] = 5411,
  [5412] = 2160,
  [5413] = 5086,
  [5414] = 5116,
  [5415] = 5084,
  [5416] = 5243,
  [5417] = 5244,
  [5418] = 5418,
  [5419] = 5246,
  [5420] = 5085,
  [5421] = 5275,
  [5422] = 5116,
  [5423] = 5075,
  [5424] = 5086,
  [5425] = 5060,
  [5426] = 2187,
  [5427] = 5243,
  [5428] = 5244,
  [5429] = 5429,
  [5430] = 5246,
  [5431] = 5431,
  [5432] = 2150,
  [5433] = 5239,
  [5434] = 2156,
  [5435] = 5435,
  [5436] = 5116,
  [5437] = 2259,
  [5438] = 5243,
  [5439] = 5244,
  [5440] = 5099,
  [5441] = 5246,
  [5442] = 5442,
  [5443] = 3589,
  [5444] = 5100,
  [5445] = 3590,
  [5446] = 5446,
  [5447] = 5063,
  [5448] = 5243,
  [5449] = 5246,
  [5450] = 2275,
  [5451] = 5275,
  [5452] = 5275,
  [5453] = 5116,
  [5454] = 5454,
  [5455] = 5086,
  [5456] = 5081,
  [5457] = 3992,
  [5458] = 3441,
  [5459] = 5063,
  [5460] = 3960,
  [5461] = 5461,
  [5462] = 5086,
  [5463] = 5084,
  [5464] = 5085,
  [5465] = 2152,
  [5466] = 5091,
  [5467] = 5116,
  [5468] = 2276,
  [5469] = 5461,
  [5470] = 5275,
  [5471] = 2314,
  [5472] = 5060,
  [5473] = 5473,
  [5474] = 5264,
  [5475] = 5475,
  [5476] = 2277,
  [5477] = 5473,
  [5478] = 5478,
  [5479] = 2278,
  [5480] = 2230,
  [5481] = 3965,
  [5482] = 2279,
  [5483] = 5153,
  [5484] = 2335,
  [5485] = 5485,
  [5486] = 5060,
  [5487] = 3977,
  [5488] = 2185,
  [5489] = 5489,
  [5490] = 5063,
  [5491] = 5084,
  [5492] = 5063,
  [5493] = 2188,
  [5494] = 5064,
  [5495] = 5495,
  [5496] = 5390,
  [5497] = 5497,
  [5498] = 5498,
  [5499] = 5243,
  [5500] = 5086,
  [5501] = 2280,
  [5502] = 2281,
  [5503] = 5229,
  [5504] = 5081,
  [5505] = 5105,
  [5506] = 5506,
  [5507] = 5084,
  [5508] = 5085,
  [5509] = 5509,
  [5510] = 5510,
  [5511] = 5060,
  [5512] = 2317,
  [5513] = 5478,
  [5514] = 2328,
  [5515] = 5399,
  [5516] = 2189,
  [5517] = 5116,
  [5518] = 5189,
  [5519] = 5399,
  [5520] = 2333,
  [5521] = 2334,
  [5522] = 5399,
  [5523] = 5523,
  [5524] = 5399,
  [5525] = 5525,
  [5526] = 5399,
  [5527] = 5116,
  [5528] = 5399,
  [5529] = 5529,
  [5530] = 5399,
  [5531] = 3585,
  [5532] = 5399,
  [5533] = 5210,
  [5534] = 5399,
  [5535] = 3587,
  [5536] = 5399,
  [5537] = 2157,
  [5538] = 5399,
  [5539] = 2168,
  [5540] = 5399,
  [5541] = 3579,
  [5542] = 5399,
  [5543] = 2190,
  [5544] = 5399,
  [5545] = 2144,
  [5546] = 5399,
  [5547] = 5086,
  [5548] = 5399,
  [5549] = 5246,
  [5550] = 5550,
  [5551] = 5551,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(233);
      if (lookahead == '\r') SKIP(225);
      if (lookahead == '!') ADVANCE(312);
      if (lookahead == '"') ADVANCE(328);
      if (lookahead == '#') ADVANCE(382);
      if (lookahead == '$') ADVANCE(511);
      if (lookahead == '%') ADVANCE(476);
      if (lookahead == '&') ADVANCE(484);
      if (lookahead == '\'') ADVANCE(534);
      if (lookahead == '(') ADVANCE(243);
      if (lookahead == ')') ADVANCE(245);
      if (lookahead == '*') ADVANCE(241);
      if (lookahead == '+') ADVANCE(468);
      if (lookahead == ',') ADVANCE(305);
      if (lookahead == '-') ADVANCE(352);
      if (lookahead == '.') ADVANCE(339);
      if (lookahead == '/') ADVANCE(497);
      if (lookahead == ':') ADVANCE(291);
      if (lookahead == ';') ADVANCE(546);
      if (lookahead == '<') ADVANCE(385);
      if (lookahead == '=') ADVANCE(341);
      if (lookahead == '>') ADVANCE(389);
      if (lookahead == '?') ADVANCE(68);
      if (lookahead == '@') ADVANCE(294);
      if (lookahead == '[') ADVANCE(310);
      if (lookahead == '\\') ADVANCE(454);
      if (lookahead == ']') ADVANCE(311);
      if (lookahead == '^') ADVANCE(528);
      if (lookahead == '_') ADVANCE(299);
      if (lookahead == '{') ADVANCE(336);
      if (lookahead == '|') ADVANCE(478);
      if (lookahead == '}') ADVANCE(337);
      if (lookahead == '~') ADVANCE(349);
      if (lookahead == 0xac) ADVANCE(350);
      if (lookahead == 0xd7) ADVANCE(523);
      if (lookahead == 0xf7) ADVANCE(504);
      if (lookahead == 0x2016) ADVANCE(481);
      if (lookahead == 0x2025) ADVANCE(464);
      if (lookahead == 0x2026) ADVANCE(466);
      if (lookahead == 0x203c) ADVANCE(509);
      if (lookahead == 0x2047) ADVANCE(514);
      if (lookahead == 0x207a) ADVANCE(531);
      if (lookahead == 0x2115) ADVANCE(333);
      if (lookahead == 0x211d) ADVANCE(335);
      if (lookahead == 0x2124) ADVANCE(334);
      if (lookahead == 0x2190) ADVANCE(261);
      if (lookahead == 0x2192) ADVANCE(275);
      if (lookahead == 0x219d) ADVANCE(374);
      if (lookahead == 0x21a6) ADVANCE(272);
      if (lookahead == 0x21d2) ADVANCE(363);
      if (lookahead == 0x21d4) ADVANCE(371);
      if (lookahead == 0x21dd) ADVANCE(373);
      if (lookahead == 0x21f8) ADVANCE(365);
      if (lookahead == 0x2200) ADVANCE(264);
      if (lookahead == 0x2203) ADVANCE(267);
      if (lookahead == 0x2208) ADVANCE(258);
      if (lookahead == 0x2209) ADVANCE(420);
      if (lookahead == 0x2218) ADVANCE(506);
      if (lookahead == 0x221d) ADVANCE(430);
      if (lookahead == 0x2227) ADVANCE(301);
      if (lookahead == 0x2228) ADVANCE(303);
      if (lookahead == 0x2229) ADVANCE(459);
      if (lookahead == 0x222a) ADVANCE(462);
      if (lookahead == 0x2237) ADVANCE(297);
      if (lookahead == 0x223c) ADVANCE(432);
      if (lookahead == 0x2240) ADVANCE(525);
      if (lookahead == 0x2243) ADVANCE(434);
      if (lookahead == 0x2245) ADVANCE(412);
      if (lookahead == 0x2248) ADVANCE(399);
      if (lookahead == 0x224d) ADVANCE(410);
      if (lookahead == 0x2250) ADVANCE(414);
      if (lookahead == 0x2254) ADVANCE(378);
      if (lookahead == 0x225c) ADVANCE(255);
      if (lookahead == 0x2260) ADVANCE(383);
      if (lookahead == 0x2261) ADVANCE(368);
      if (lookahead == 0x2264) ADVANCE(394);
      if (lookahead == 0x2265) ADVANCE(397);
      if (lookahead == 0x226a) ADVANCE(418);
      if (lookahead == 0x226b) ADVANCE(416);
      if (lookahead == 0x227a) ADVANCE(422);
      if (lookahead == 0x227b) ADVANCE(424);
      if (lookahead == 0x2282) ADVANCE(444);
      if (lookahead == 0x2283) ADVANCE(446);
      if (lookahead == 0x2286) ADVANCE(448);
      if (lookahead == 0x2287) ADVANCE(450);
      if (lookahead == 0x228e) ADVANCE(520);
      if (lookahead == 0x228f) ADVANCE(436);
      if (lookahead == 0x2290) ADVANCE(438);
      if (lookahead == 0x2291) ADVANCE(440);
      if (lookahead == 0x2292) ADVANCE(442);
      if (lookahead == 0x2293) ADVANCE(516);
      if (lookahead == 0x2294) ADVANCE(518);
      if (lookahead == 0x2295) ADVANCE(472);
      if (lookahead == 0x2296) ADVANCE(475);
      if (lookahead == 0x2297) ADVANCE(494);
      if (lookahead == 0x2298) ADVANCE(491);
      if (lookahead == 0x2299) ADVANCE(488);
      if (lookahead == 0x22a2) ADVANCE(402);
      if (lookahead == 0x22a3) ADVANCE(406);
      if (lookahead == 0x22a8) ADVANCE(404);
      if (lookahead == 0x22c4) ADVANCE(359);
      if (lookahead == 0x22c5) ADVANCE(527);
      if (lookahead == 0x22c6) ADVANCE(508);
      if (lookahead == 0x25a1) ADVANCE(289);
      if (lookahead == 0x25c7) ADVANCE(360);
      if (lookahead == 0x25cf) ADVANCE(502);
      if (lookahead == 0x25ef) ADVANCE(500);
      if (lookahead == 0x27e8) ADVANCE(278);
      if (lookahead == 0x27e9) ADVANCE(284);
      if (lookahead == 0x27f5) ADVANCE(260);
      if (lookahead == 0x27f6) ADVANCE(274);
      if (lookahead == 0x27f9) ADVANCE(362);
      if (lookahead == 0x27fa) ADVANCE(370);
      if (lookahead == 0x27fc) ADVANCE(271);
      if (lookahead == 0x2945) ADVANCE(366);
      if (lookahead == 0x2a74) ADVANCE(380);
      if (lookahead == 0x2aaf) ADVANCE(426);
      if (lookahead == 0x2ab0) ADVANCE(428);
      if (lookahead == 0x2ae4) ADVANCE(408);
      if (lookahead == 0x3008) ADVANCE(277);
      if (lookahead == 0x3009) ADVANCE(282);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(318);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(536);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(225);
      if (('2' <= lookahead && lookahead <= '7')) ADVANCE(322);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(32);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(32);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(30);
      if (lookahead == '\r') ADVANCE(329);
      if (lookahead == '"') ADVANCE(331);
      if (lookahead == '(') ADVANCE(329);
      if (lookahead == '\\') ADVANCE(330);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(329);
      if (lookahead != 0) ADVANCE(329);
      END_STATE();
    case 4:
      if (lookahead == '\r') SKIP(4);
      if (lookahead == '!') ADVANCE(312);
      if (lookahead == '"') ADVANCE(328);
      if (lookahead == '#') ADVANCE(382);
      if (lookahead == '$') ADVANCE(511);
      if (lookahead == '%') ADVANCE(476);
      if (lookahead == '&') ADVANCE(484);
      if (lookahead == '\'') ADVANCE(534);
      if (lookahead == '(') ADVANCE(307);
      if (lookahead == ')') ADVANCE(308);
      if (lookahead == '*') ADVANCE(495);
      if (lookahead == '+') ADVANCE(468);
      if (lookahead == ',') ADVANCE(305);
      if (lookahead == '-') ADVANCE(354);
      if (lookahead == '.') ADVANCE(54);
      if (lookahead == '/') ADVANCE(497);
      if (lookahead == ':') ADVANCE(57);
      if (lookahead == '<') ADVANCE(385);
      if (lookahead == '=') ADVANCE(344);
      if (lookahead == '>') ADVANCE(388);
      if (lookahead == '?') ADVANCE(68);
      if (lookahead == '@') ADVANCE(294);
      if (lookahead == '[') ADVANCE(310);
      if (lookahead == '\\') ADVANCE(454);
      if (lookahead == '^') ADVANCE(528);
      if (lookahead == '_') ADVANCE(299);
      if (lookahead == '{') ADVANCE(336);
      if (lookahead == '|') ADVANCE(479);
      if (lookahead == '}') ADVANCE(337);
      if (lookahead == '~') ADVANCE(349);
      if (lookahead == 0xac) ADVANCE(350);
      if (lookahead == 0xd7) ADVANCE(523);
      if (lookahead == 0xf7) ADVANCE(504);
      if (lookahead == 0x2016) ADVANCE(481);
      if (lookahead == 0x2025) ADVANCE(464);
      if (lookahead == 0x2026) ADVANCE(466);
      if (lookahead == 0x203c) ADVANCE(509);
      if (lookahead == 0x2047) ADVANCE(514);
      if (lookahead == 0x207a) ADVANCE(531);
      if (lookahead == 0x2115) ADVANCE(333);
      if (lookahead == 0x211d) ADVANCE(335);
      if (lookahead == 0x2124) ADVANCE(334);
      if (lookahead == 0x219d) ADVANCE(374);
      if (lookahead == 0x21d2) ADVANCE(363);
      if (lookahead == 0x21d4) ADVANCE(371);
      if (lookahead == 0x21dd) ADVANCE(373);
      if (lookahead == 0x21f8) ADVANCE(365);
      if (lookahead == 0x2200) ADVANCE(264);
      if (lookahead == 0x2203) ADVANCE(267);
      if (lookahead == 0x2208) ADVANCE(258);
      if (lookahead == 0x2209) ADVANCE(420);
      if (lookahead == 0x2218) ADVANCE(506);
      if (lookahead == 0x221d) ADVANCE(430);
      if (lookahead == 0x2227) ADVANCE(301);
      if (lookahead == 0x2228) ADVANCE(303);
      if (lookahead == 0x2229) ADVANCE(459);
      if (lookahead == 0x222a) ADVANCE(462);
      if (lookahead == 0x223c) ADVANCE(432);
      if (lookahead == 0x2240) ADVANCE(525);
      if (lookahead == 0x2243) ADVANCE(434);
      if (lookahead == 0x2245) ADVANCE(412);
      if (lookahead == 0x2248) ADVANCE(399);
      if (lookahead == 0x224d) ADVANCE(410);
      if (lookahead == 0x2250) ADVANCE(414);
      if (lookahead == 0x2254) ADVANCE(378);
      if (lookahead == 0x2260) ADVANCE(383);
      if (lookahead == 0x2261) ADVANCE(368);
      if (lookahead == 0x2264) ADVANCE(394);
      if (lookahead == 0x2265) ADVANCE(397);
      if (lookahead == 0x226a) ADVANCE(418);
      if (lookahead == 0x226b) ADVANCE(416);
      if (lookahead == 0x227a) ADVANCE(422);
      if (lookahead == 0x227b) ADVANCE(424);
      if (lookahead == 0x2282) ADVANCE(444);
      if (lookahead == 0x2283) ADVANCE(446);
      if (lookahead == 0x2286) ADVANCE(448);
      if (lookahead == 0x2287) ADVANCE(450);
      if (lookahead == 0x228e) ADVANCE(520);
      if (lookahead == 0x228f) ADVANCE(436);
      if (lookahead == 0x2290) ADVANCE(438);
      if (lookahead == 0x2291) ADVANCE(440);
      if (lookahead == 0x2292) ADVANCE(442);
      if (lookahead == 0x2293) ADVANCE(516);
      if (lookahead == 0x2294) ADVANCE(518);
      if (lookahead == 0x2295) ADVANCE(472);
      if (lookahead == 0x2296) ADVANCE(475);
      if (lookahead == 0x2297) ADVANCE(494);
      if (lookahead == 0x2298) ADVANCE(491);
      if (lookahead == 0x2299) ADVANCE(488);
      if (lookahead == 0x22a2) ADVANCE(402);
      if (lookahead == 0x22a3) ADVANCE(406);
      if (lookahead == 0x22a8) ADVANCE(404);
      if (lookahead == 0x22c4) ADVANCE(359);
      if (lookahead == 0x22c5) ADVANCE(527);
      if (lookahead == 0x22c6) ADVANCE(508);
      if (lookahead == 0x25a1) ADVANCE(289);
      if (lookahead == 0x25c7) ADVANCE(360);
      if (lookahead == 0x25cf) ADVANCE(502);
      if (lookahead == 0x25ef) ADVANCE(500);
      if (lookahead == 0x27e8) ADVANCE(278);
      if (lookahead == 0x27f9) ADVANCE(362);
      if (lookahead == 0x27fa) ADVANCE(370);
      if (lookahead == 0x2945) ADVANCE(366);
      if (lookahead == 0x2a74) ADVANCE(380);
      if (lookahead == 0x2aaf) ADVANCE(426);
      if (lookahead == 0x2ab0) ADVANCE(428);
      if (lookahead == 0x2ae4) ADVANCE(408);
      if (lookahead == 0x3008) ADVANCE(277);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(4);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(313);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 5:
      if (lookahead == '\r') SKIP(5);
      if (lookahead == '!') ADVANCE(312);
      if (lookahead == '"') ADVANCE(328);
      if (lookahead == '#') ADVANCE(382);
      if (lookahead == '$') ADVANCE(511);
      if (lookahead == '%') ADVANCE(476);
      if (lookahead == '&') ADVANCE(484);
      if (lookahead == '\'') ADVANCE(534);
      if (lookahead == '(') ADVANCE(307);
      if (lookahead == '*') ADVANCE(495);
      if (lookahead == '+') ADVANCE(468);
      if (lookahead == ',') ADVANCE(305);
      if (lookahead == '-') ADVANCE(353);
      if (lookahead == '.') ADVANCE(54);
      if (lookahead == '/') ADVANCE(497);
      if (lookahead == ':') ADVANCE(57);
      if (lookahead == '<') ADVANCE(385);
      if (lookahead == '=') ADVANCE(343);
      if (lookahead == '>') ADVANCE(388);
      if (lookahead == '?') ADVANCE(68);
      if (lookahead == '@') ADVANCE(294);
      if (lookahead == '[') ADVANCE(310);
      if (lookahead == '\\') ADVANCE(454);
      if (lookahead == '^') ADVANCE(528);
      if (lookahead == '_') ADVANCE(224);
      if (lookahead == '{') ADVANCE(336);
      if (lookahead == '|') ADVANCE(479);
      if (lookahead == '~') ADVANCE(349);
      if (lookahead == 0xac) ADVANCE(350);
      if (lookahead == 0xd7) ADVANCE(523);
      if (lookahead == 0xf7) ADVANCE(504);
      if (lookahead == 0x2016) ADVANCE(481);
      if (lookahead == 0x2025) ADVANCE(464);
      if (lookahead == 0x2026) ADVANCE(466);
      if (lookahead == 0x203c) ADVANCE(509);
      if (lookahead == 0x2047) ADVANCE(514);
      if (lookahead == 0x207a) ADVANCE(531);
      if (lookahead == 0x2115) ADVANCE(333);
      if (lookahead == 0x211d) ADVANCE(335);
      if (lookahead == 0x2124) ADVANCE(334);
      if (lookahead == 0x219d) ADVANCE(374);
      if (lookahead == 0x21d2) ADVANCE(363);
      if (lookahead == 0x21d4) ADVANCE(371);
      if (lookahead == 0x21dd) ADVANCE(373);
      if (lookahead == 0x21f8) ADVANCE(365);
      if (lookahead == 0x2200) ADVANCE(264);
      if (lookahead == 0x2203) ADVANCE(267);
      if (lookahead == 0x2208) ADVANCE(258);
      if (lookahead == 0x2209) ADVANCE(420);
      if (lookahead == 0x2218) ADVANCE(506);
      if (lookahead == 0x221d) ADVANCE(430);
      if (lookahead == 0x2227) ADVANCE(301);
      if (lookahead == 0x2228) ADVANCE(303);
      if (lookahead == 0x2229) ADVANCE(459);
      if (lookahead == 0x222a) ADVANCE(462);
      if (lookahead == 0x223c) ADVANCE(432);
      if (lookahead == 0x2240) ADVANCE(525);
      if (lookahead == 0x2243) ADVANCE(434);
      if (lookahead == 0x2245) ADVANCE(412);
      if (lookahead == 0x2248) ADVANCE(399);
      if (lookahead == 0x224d) ADVANCE(410);
      if (lookahead == 0x2250) ADVANCE(414);
      if (lookahead == 0x2254) ADVANCE(378);
      if (lookahead == 0x2260) ADVANCE(383);
      if (lookahead == 0x2261) ADVANCE(368);
      if (lookahead == 0x2264) ADVANCE(394);
      if (lookahead == 0x2265) ADVANCE(397);
      if (lookahead == 0x226a) ADVANCE(418);
      if (lookahead == 0x226b) ADVANCE(416);
      if (lookahead == 0x227a) ADVANCE(422);
      if (lookahead == 0x227b) ADVANCE(424);
      if (lookahead == 0x2282) ADVANCE(444);
      if (lookahead == 0x2283) ADVANCE(446);
      if (lookahead == 0x2286) ADVANCE(448);
      if (lookahead == 0x2287) ADVANCE(450);
      if (lookahead == 0x228e) ADVANCE(520);
      if (lookahead == 0x228f) ADVANCE(436);
      if (lookahead == 0x2290) ADVANCE(438);
      if (lookahead == 0x2291) ADVANCE(440);
      if (lookahead == 0x2292) ADVANCE(442);
      if (lookahead == 0x2293) ADVANCE(516);
      if (lookahead == 0x2294) ADVANCE(518);
      if (lookahead == 0x2295) ADVANCE(472);
      if (lookahead == 0x2296) ADVANCE(475);
      if (lookahead == 0x2297) ADVANCE(494);
      if (lookahead == 0x2298) ADVANCE(491);
      if (lookahead == 0x2299) ADVANCE(488);
      if (lookahead == 0x22a2) ADVANCE(402);
      if (lookahead == 0x22a3) ADVANCE(406);
      if (lookahead == 0x22a8) ADVANCE(404);
      if (lookahead == 0x22c4) ADVANCE(359);
      if (lookahead == 0x22c5) ADVANCE(527);
      if (lookahead == 0x22c6) ADVANCE(508);
      if (lookahead == 0x25a1) ADVANCE(289);
      if (lookahead == 0x25c7) ADVANCE(360);
      if (lookahead == 0x25cf) ADVANCE(502);
      if (lookahead == 0x25ef) ADVANCE(500);
      if (lookahead == 0x27e8) ADVANCE(278);
      if (lookahead == 0x27f9) ADVANCE(362);
      if (lookahead == 0x27fa) ADVANCE(370);
      if (lookahead == 0x2945) ADVANCE(366);
      if (lookahead == 0x2a74) ADVANCE(380);
      if (lookahead == 0x2aaf) ADVANCE(426);
      if (lookahead == 0x2ab0) ADVANCE(428);
      if (lookahead == 0x2ae4) ADVANCE(408);
      if (lookahead == 0x3008) ADVANCE(277);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(5);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(313);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 6:
      if (lookahead == '\r') SKIP(6);
      if (lookahead == '"') ADVANCE(328);
      if (lookahead == '#') ADVANCE(382);
      if (lookahead == '$') ADVANCE(511);
      if (lookahead == '%') ADVANCE(476);
      if (lookahead == '&') ADVANCE(484);
      if (lookahead == '\'') ADVANCE(534);
      if (lookahead == '(') ADVANCE(307);
      if (lookahead == '*') ADVANCE(495);
      if (lookahead == '+') ADVANCE(468);
      if (lookahead == '-') ADVANCE(354);
      if (lookahead == '.') ADVANCE(54);
      if (lookahead == '/') ADVANCE(497);
      if (lookahead == ':') ADVANCE(57);
      if (lookahead == '<') ADVANCE(385);
      if (lookahead == '=') ADVANCE(344);
      if (lookahead == '>') ADVANCE(390);
      if (lookahead == '?') ADVANCE(68);
      if (lookahead == '@') ADVANCE(294);
      if (lookahead == '[') ADVANCE(310);
      if (lookahead == '\\') ADVANCE(454);
      if (lookahead == '^') ADVANCE(528);
      if (lookahead == '_') ADVANCE(224);
      if (lookahead == '{') ADVANCE(336);
      if (lookahead == '|') ADVANCE(479);
      if (lookahead == '~') ADVANCE(349);
      if (lookahead == 0xac) ADVANCE(350);
      if (lookahead == 0xd7) ADVANCE(523);
      if (lookahead == 0xf7) ADVANCE(504);
      if (lookahead == 0x2016) ADVANCE(481);
      if (lookahead == 0x2025) ADVANCE(464);
      if (lookahead == 0x2026) ADVANCE(466);
      if (lookahead == 0x203c) ADVANCE(509);
      if (lookahead == 0x2047) ADVANCE(514);
      if (lookahead == 0x207a) ADVANCE(531);
      if (lookahead == 0x2115) ADVANCE(333);
      if (lookahead == 0x211d) ADVANCE(335);
      if (lookahead == 0x2124) ADVANCE(334);
      if (lookahead == 0x219d) ADVANCE(374);
      if (lookahead == 0x21d2) ADVANCE(363);
      if (lookahead == 0x21d4) ADVANCE(371);
      if (lookahead == 0x21dd) ADVANCE(373);
      if (lookahead == 0x21f8) ADVANCE(365);
      if (lookahead == 0x2200) ADVANCE(264);
      if (lookahead == 0x2203) ADVANCE(267);
      if (lookahead == 0x2208) ADVANCE(258);
      if (lookahead == 0x2209) ADVANCE(420);
      if (lookahead == 0x2218) ADVANCE(506);
      if (lookahead == 0x221d) ADVANCE(430);
      if (lookahead == 0x2227) ADVANCE(301);
      if (lookahead == 0x2228) ADVANCE(303);
      if (lookahead == 0x2229) ADVANCE(459);
      if (lookahead == 0x222a) ADVANCE(462);
      if (lookahead == 0x223c) ADVANCE(432);
      if (lookahead == 0x2240) ADVANCE(525);
      if (lookahead == 0x2243) ADVANCE(434);
      if (lookahead == 0x2245) ADVANCE(412);
      if (lookahead == 0x2248) ADVANCE(399);
      if (lookahead == 0x224d) ADVANCE(410);
      if (lookahead == 0x2250) ADVANCE(414);
      if (lookahead == 0x2254) ADVANCE(378);
      if (lookahead == 0x2260) ADVANCE(383);
      if (lookahead == 0x2261) ADVANCE(368);
      if (lookahead == 0x2264) ADVANCE(394);
      if (lookahead == 0x2265) ADVANCE(397);
      if (lookahead == 0x226a) ADVANCE(418);
      if (lookahead == 0x226b) ADVANCE(416);
      if (lookahead == 0x227a) ADVANCE(422);
      if (lookahead == 0x227b) ADVANCE(424);
      if (lookahead == 0x2282) ADVANCE(444);
      if (lookahead == 0x2283) ADVANCE(446);
      if (lookahead == 0x2286) ADVANCE(448);
      if (lookahead == 0x2287) ADVANCE(450);
      if (lookahead == 0x228e) ADVANCE(520);
      if (lookahead == 0x228f) ADVANCE(436);
      if (lookahead == 0x2290) ADVANCE(438);
      if (lookahead == 0x2291) ADVANCE(440);
      if (lookahead == 0x2292) ADVANCE(442);
      if (lookahead == 0x2293) ADVANCE(516);
      if (lookahead == 0x2294) ADVANCE(518);
      if (lookahead == 0x2295) ADVANCE(472);
      if (lookahead == 0x2296) ADVANCE(475);
      if (lookahead == 0x2297) ADVANCE(494);
      if (lookahead == 0x2298) ADVANCE(491);
      if (lookahead == 0x2299) ADVANCE(488);
      if (lookahead == 0x22a2) ADVANCE(402);
      if (lookahead == 0x22a3) ADVANCE(406);
      if (lookahead == 0x22a8) ADVANCE(404);
      if (lookahead == 0x22c4) ADVANCE(359);
      if (lookahead == 0x22c5) ADVANCE(527);
      if (lookahead == 0x22c6) ADVANCE(508);
      if (lookahead == 0x25a1) ADVANCE(289);
      if (lookahead == 0x25c7) ADVANCE(360);
      if (lookahead == 0x25cf) ADVANCE(502);
      if (lookahead == 0x25ef) ADVANCE(500);
      if (lookahead == 0x27e8) ADVANCE(278);
      if (lookahead == 0x27e9) ADVANCE(283);
      if (lookahead == 0x27f9) ADVANCE(362);
      if (lookahead == 0x27fa) ADVANCE(370);
      if (lookahead == 0x2945) ADVANCE(366);
      if (lookahead == 0x2a74) ADVANCE(380);
      if (lookahead == 0x2aaf) ADVANCE(426);
      if (lookahead == 0x2ab0) ADVANCE(428);
      if (lookahead == 0x2ae4) ADVANCE(408);
      if (lookahead == 0x3008) ADVANCE(277);
      if (lookahead == 0x3009) ADVANCE(281);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(6);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(313);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 7:
      if (lookahead == '\r') SKIP(7);
      if (lookahead == '#') ADVANCE(382);
      if (lookahead == '$') ADVANCE(511);
      if (lookahead == '%') ADVANCE(476);
      if (lookahead == '&') ADVANCE(484);
      if (lookahead == '\'') ADVANCE(534);
      if (lookahead == '(') ADVANCE(307);
      if (lookahead == '*') ADVANCE(495);
      if (lookahead == '+') ADVANCE(468);
      if (lookahead == '-') ADVANCE(354);
      if (lookahead == '.') ADVANCE(53);
      if (lookahead == '/') ADVANCE(497);
      if (lookahead == ':') ADVANCE(292);
      if (lookahead == '<') ADVANCE(385);
      if (lookahead == '=') ADVANCE(344);
      if (lookahead == '>') ADVANCE(390);
      if (lookahead == '?') ADVANCE(68);
      if (lookahead == '@') ADVANCE(294);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') ADVANCE(455);
      if (lookahead == '^') ADVANCE(528);
      if (lookahead == '_') ADVANCE(224);
      if (lookahead == '|') ADVANCE(479);
      if (lookahead == '~') ADVANCE(349);
      if (lookahead == 0xac) ADVANCE(350);
      if (lookahead == 0xd7) ADVANCE(523);
      if (lookahead == 0xf7) ADVANCE(504);
      if (lookahead == 0x2016) ADVANCE(481);
      if (lookahead == 0x2025) ADVANCE(464);
      if (lookahead == 0x2026) ADVANCE(466);
      if (lookahead == 0x203c) ADVANCE(509);
      if (lookahead == 0x2047) ADVANCE(514);
      if (lookahead == 0x207a) ADVANCE(531);
      if (lookahead == 0x2115) ADVANCE(333);
      if (lookahead == 0x211d) ADVANCE(335);
      if (lookahead == 0x2124) ADVANCE(334);
      if (lookahead == 0x219d) ADVANCE(374);
      if (lookahead == 0x21d2) ADVANCE(363);
      if (lookahead == 0x21d4) ADVANCE(371);
      if (lookahead == 0x21dd) ADVANCE(373);
      if (lookahead == 0x21f8) ADVANCE(365);
      if (lookahead == 0x2208) ADVANCE(258);
      if (lookahead == 0x2209) ADVANCE(420);
      if (lookahead == 0x2218) ADVANCE(506);
      if (lookahead == 0x221d) ADVANCE(430);
      if (lookahead == 0x2227) ADVANCE(301);
      if (lookahead == 0x2228) ADVANCE(303);
      if (lookahead == 0x2229) ADVANCE(459);
      if (lookahead == 0x222a) ADVANCE(462);
      if (lookahead == 0x223c) ADVANCE(432);
      if (lookahead == 0x2240) ADVANCE(525);
      if (lookahead == 0x2243) ADVANCE(434);
      if (lookahead == 0x2245) ADVANCE(412);
      if (lookahead == 0x2248) ADVANCE(399);
      if (lookahead == 0x224d) ADVANCE(410);
      if (lookahead == 0x2250) ADVANCE(414);
      if (lookahead == 0x2254) ADVANCE(378);
      if (lookahead == 0x2260) ADVANCE(383);
      if (lookahead == 0x2261) ADVANCE(368);
      if (lookahead == 0x2264) ADVANCE(394);
      if (lookahead == 0x2265) ADVANCE(397);
      if (lookahead == 0x226a) ADVANCE(418);
      if (lookahead == 0x226b) ADVANCE(416);
      if (lookahead == 0x227a) ADVANCE(422);
      if (lookahead == 0x227b) ADVANCE(424);
      if (lookahead == 0x2282) ADVANCE(444);
      if (lookahead == 0x2283) ADVANCE(446);
      if (lookahead == 0x2286) ADVANCE(448);
      if (lookahead == 0x2287) ADVANCE(450);
      if (lookahead == 0x228e) ADVANCE(520);
      if (lookahead == 0x228f) ADVANCE(436);
      if (lookahead == 0x2290) ADVANCE(438);
      if (lookahead == 0x2291) ADVANCE(440);
      if (lookahead == 0x2292) ADVANCE(442);
      if (lookahead == 0x2293) ADVANCE(516);
      if (lookahead == 0x2294) ADVANCE(518);
      if (lookahead == 0x2295) ADVANCE(472);
      if (lookahead == 0x2296) ADVANCE(475);
      if (lookahead == 0x2297) ADVANCE(494);
      if (lookahead == 0x2298) ADVANCE(491);
      if (lookahead == 0x2299) ADVANCE(488);
      if (lookahead == 0x22a2) ADVANCE(402);
      if (lookahead == 0x22a3) ADVANCE(406);
      if (lookahead == 0x22a8) ADVANCE(404);
      if (lookahead == 0x22c4) ADVANCE(359);
      if (lookahead == 0x22c5) ADVANCE(527);
      if (lookahead == 0x22c6) ADVANCE(508);
      if (lookahead == 0x25a1) ADVANCE(289);
      if (lookahead == 0x25c7) ADVANCE(360);
      if (lookahead == 0x25cf) ADVANCE(502);
      if (lookahead == 0x25ef) ADVANCE(500);
      if (lookahead == 0x27e8) ADVANCE(278);
      if (lookahead == 0x27e9) ADVANCE(283);
      if (lookahead == 0x27f9) ADVANCE(362);
      if (lookahead == 0x27fa) ADVANCE(370);
      if (lookahead == 0x2945) ADVANCE(366);
      if (lookahead == 0x2a74) ADVANCE(380);
      if (lookahead == 0x2aaf) ADVANCE(426);
      if (lookahead == 0x2ab0) ADVANCE(428);
      if (lookahead == 0x2ae4) ADVANCE(408);
      if (lookahead == 0x3008) ADVANCE(277);
      if (lookahead == 0x3009) ADVANCE(281);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(7);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(314);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 8:
      if (lookahead == '\r') SKIP(8);
      if (lookahead == '!') ADVANCE(312);
      if (lookahead == '#') ADVANCE(382);
      if (lookahead == '$') ADVANCE(511);
      if (lookahead == '%') ADVANCE(476);
      if (lookahead == '&') ADVANCE(484);
      if (lookahead == '\'') ADVANCE(534);
      if (lookahead == '(') ADVANCE(307);
      if (lookahead == '*') ADVANCE(495);
      if (lookahead == '+') ADVANCE(468);
      if (lookahead == ',') ADVANCE(305);
      if (lookahead == '-') ADVANCE(353);
      if (lookahead == '.') ADVANCE(339);
      if (lookahead == '/') ADVANCE(497);
      if (lookahead == ':') ADVANCE(55);
      if (lookahead == '<') ADVANCE(387);
      if (lookahead == '=') ADVANCE(343);
      if (lookahead == '>') ADVANCE(388);
      if (lookahead == '?') ADVANCE(68);
      if (lookahead == '@') ADVANCE(69);
      if (lookahead == '[') ADVANCE(310);
      if (lookahead == '\\') ADVANCE(455);
      if (lookahead == '^') ADVANCE(528);
      if (lookahead == '|') ADVANCE(479);
      if (lookahead == '~') ADVANCE(349);
      if (lookahead == 0xac) ADVANCE(350);
      if (lookahead == 0xd7) ADVANCE(523);
      if (lookahead == 0xf7) ADVANCE(504);
      if (lookahead == 0x2016) ADVANCE(481);
      if (lookahead == 0x2025) ADVANCE(464);
      if (lookahead == 0x2026) ADVANCE(466);
      if (lookahead == 0x203c) ADVANCE(509);
      if (lookahead == 0x2047) ADVANCE(514);
      if (lookahead == 0x207a) ADVANCE(531);
      if (lookahead == 0x2115) ADVANCE(333);
      if (lookahead == 0x211d) ADVANCE(335);
      if (lookahead == 0x2124) ADVANCE(334);
      if (lookahead == 0x219d) ADVANCE(374);
      if (lookahead == 0x21d2) ADVANCE(363);
      if (lookahead == 0x21d4) ADVANCE(371);
      if (lookahead == 0x21dd) ADVANCE(373);
      if (lookahead == 0x21f8) ADVANCE(365);
      if (lookahead == 0x2208) ADVANCE(258);
      if (lookahead == 0x2209) ADVANCE(420);
      if (lookahead == 0x2218) ADVANCE(506);
      if (lookahead == 0x221d) ADVANCE(430);
      if (lookahead == 0x2227) ADVANCE(301);
      if (lookahead == 0x2228) ADVANCE(303);
      if (lookahead == 0x2229) ADVANCE(459);
      if (lookahead == 0x222a) ADVANCE(462);
      if (lookahead == 0x2237) ADVANCE(297);
      if (lookahead == 0x223c) ADVANCE(432);
      if (lookahead == 0x2240) ADVANCE(525);
      if (lookahead == 0x2243) ADVANCE(434);
      if (lookahead == 0x2245) ADVANCE(412);
      if (lookahead == 0x2248) ADVANCE(399);
      if (lookahead == 0x224d) ADVANCE(410);
      if (lookahead == 0x2250) ADVANCE(414);
      if (lookahead == 0x2254) ADVANCE(378);
      if (lookahead == 0x2260) ADVANCE(383);
      if (lookahead == 0x2261) ADVANCE(368);
      if (lookahead == 0x2264) ADVANCE(394);
      if (lookahead == 0x2265) ADVANCE(397);
      if (lookahead == 0x226a) ADVANCE(418);
      if (lookahead == 0x226b) ADVANCE(416);
      if (lookahead == 0x227a) ADVANCE(422);
      if (lookahead == 0x227b) ADVANCE(424);
      if (lookahead == 0x2282) ADVANCE(444);
      if (lookahead == 0x2283) ADVANCE(446);
      if (lookahead == 0x2286) ADVANCE(448);
      if (lookahead == 0x2287) ADVANCE(450);
      if (lookahead == 0x228e) ADVANCE(520);
      if (lookahead == 0x228f) ADVANCE(436);
      if (lookahead == 0x2290) ADVANCE(438);
      if (lookahead == 0x2291) ADVANCE(440);
      if (lookahead == 0x2292) ADVANCE(442);
      if (lookahead == 0x2293) ADVANCE(516);
      if (lookahead == 0x2294) ADVANCE(518);
      if (lookahead == 0x2295) ADVANCE(472);
      if (lookahead == 0x2296) ADVANCE(475);
      if (lookahead == 0x2297) ADVANCE(494);
      if (lookahead == 0x2298) ADVANCE(491);
      if (lookahead == 0x2299) ADVANCE(488);
      if (lookahead == 0x22a2) ADVANCE(402);
      if (lookahead == 0x22a3) ADVANCE(406);
      if (lookahead == 0x22a8) ADVANCE(404);
      if (lookahead == 0x22c4) ADVANCE(359);
      if (lookahead == 0x22c5) ADVANCE(527);
      if (lookahead == 0x22c6) ADVANCE(508);
      if (lookahead == 0x25a1) ADVANCE(289);
      if (lookahead == 0x25c7) ADVANCE(360);
      if (lookahead == 0x25cf) ADVANCE(502);
      if (lookahead == 0x25ef) ADVANCE(500);
      if (lookahead == 0x27f9) ADVANCE(362);
      if (lookahead == 0x27fa) ADVANCE(370);
      if (lookahead == 0x2945) ADVANCE(366);
      if (lookahead == 0x2a74) ADVANCE(380);
      if (lookahead == 0x2aaf) ADVANCE(426);
      if (lookahead == 0x2ab0) ADVANCE(428);
      if (lookahead == 0x2ae4) ADVANCE(408);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(8);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(224);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 9:
      if (lookahead == '\r') SKIP(9);
      if (lookahead == '#') ADVANCE(382);
      if (lookahead == '$') ADVANCE(511);
      if (lookahead == '%') ADVANCE(476);
      if (lookahead == '&') ADVANCE(484);
      if (lookahead == '\'') ADVANCE(534);
      if (lookahead == '(') ADVANCE(307);
      if (lookahead == '*') ADVANCE(495);
      if (lookahead == '+') ADVANCE(468);
      if (lookahead == '-') ADVANCE(354);
      if (lookahead == '.') ADVANCE(53);
      if (lookahead == '/') ADVANCE(497);
      if (lookahead == ':') ADVANCE(57);
      if (lookahead == '<') ADVANCE(385);
      if (lookahead == '=') ADVANCE(344);
      if (lookahead == '>') ADVANCE(388);
      if (lookahead == '?') ADVANCE(68);
      if (lookahead == '@') ADVANCE(69);
      if (lookahead == '[') ADVANCE(310);
      if (lookahead == '\\') ADVANCE(455);
      if (lookahead == '^') ADVANCE(528);
      if (lookahead == '{') ADVANCE(336);
      if (lookahead == '|') ADVANCE(479);
      if (lookahead == '~') ADVANCE(349);
      if (lookahead == 0xac) ADVANCE(350);
      if (lookahead == 0xd7) ADVANCE(523);
      if (lookahead == 0xf7) ADVANCE(504);
      if (lookahead == 0x2016) ADVANCE(481);
      if (lookahead == 0x2025) ADVANCE(464);
      if (lookahead == 0x2026) ADVANCE(466);
      if (lookahead == 0x203c) ADVANCE(509);
      if (lookahead == 0x2047) ADVANCE(514);
      if (lookahead == 0x207a) ADVANCE(531);
      if (lookahead == 0x219d) ADVANCE(374);
      if (lookahead == 0x21d2) ADVANCE(363);
      if (lookahead == 0x21d4) ADVANCE(371);
      if (lookahead == 0x21dd) ADVANCE(373);
      if (lookahead == 0x21f8) ADVANCE(365);
      if (lookahead == 0x2208) ADVANCE(258);
      if (lookahead == 0x2209) ADVANCE(420);
      if (lookahead == 0x2218) ADVANCE(506);
      if (lookahead == 0x221d) ADVANCE(430);
      if (lookahead == 0x2227) ADVANCE(301);
      if (lookahead == 0x2228) ADVANCE(303);
      if (lookahead == 0x2229) ADVANCE(459);
      if (lookahead == 0x222a) ADVANCE(462);
      if (lookahead == 0x223c) ADVANCE(432);
      if (lookahead == 0x2240) ADVANCE(525);
      if (lookahead == 0x2243) ADVANCE(434);
      if (lookahead == 0x2245) ADVANCE(412);
      if (lookahead == 0x2248) ADVANCE(399);
      if (lookahead == 0x224d) ADVANCE(410);
      if (lookahead == 0x2250) ADVANCE(414);
      if (lookahead == 0x2254) ADVANCE(378);
      if (lookahead == 0x2260) ADVANCE(383);
      if (lookahead == 0x2261) ADVANCE(368);
      if (lookahead == 0x2264) ADVANCE(394);
      if (lookahead == 0x2265) ADVANCE(397);
      if (lookahead == 0x226a) ADVANCE(418);
      if (lookahead == 0x226b) ADVANCE(416);
      if (lookahead == 0x227a) ADVANCE(422);
      if (lookahead == 0x227b) ADVANCE(424);
      if (lookahead == 0x2282) ADVANCE(444);
      if (lookahead == 0x2283) ADVANCE(446);
      if (lookahead == 0x2286) ADVANCE(448);
      if (lookahead == 0x2287) ADVANCE(450);
      if (lookahead == 0x228e) ADVANCE(520);
      if (lookahead == 0x228f) ADVANCE(436);
      if (lookahead == 0x2290) ADVANCE(438);
      if (lookahead == 0x2291) ADVANCE(440);
      if (lookahead == 0x2292) ADVANCE(442);
      if (lookahead == 0x2293) ADVANCE(516);
      if (lookahead == 0x2294) ADVANCE(518);
      if (lookahead == 0x2295) ADVANCE(472);
      if (lookahead == 0x2296) ADVANCE(475);
      if (lookahead == 0x2297) ADVANCE(494);
      if (lookahead == 0x2298) ADVANCE(491);
      if (lookahead == 0x2299) ADVANCE(488);
      if (lookahead == 0x22a2) ADVANCE(402);
      if (lookahead == 0x22a3) ADVANCE(406);
      if (lookahead == 0x22a8) ADVANCE(404);
      if (lookahead == 0x22c4) ADVANCE(359);
      if (lookahead == 0x22c5) ADVANCE(527);
      if (lookahead == 0x22c6) ADVANCE(508);
      if (lookahead == 0x25a1) ADVANCE(289);
      if (lookahead == 0x25c7) ADVANCE(360);
      if (lookahead == 0x25cf) ADVANCE(502);
      if (lookahead == 0x25ef) ADVANCE(500);
      if (lookahead == 0x27e8) ADVANCE(278);
      if (lookahead == 0x27f9) ADVANCE(362);
      if (lookahead == 0x27fa) ADVANCE(370);
      if (lookahead == 0x2945) ADVANCE(366);
      if (lookahead == 0x2a74) ADVANCE(380);
      if (lookahead == 0x2aaf) ADVANCE(426);
      if (lookahead == 0x2ab0) ADVANCE(428);
      if (lookahead == 0x2ae4) ADVANCE(408);
      if (lookahead == 0x3008) ADVANCE(277);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(9);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(224);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 10:
      if (lookahead == '\r') SKIP(10);
      if (lookahead == '!') ADVANCE(312);
      if (lookahead == '#') ADVANCE(382);
      if (lookahead == '$') ADVANCE(511);
      if (lookahead == '%') ADVANCE(476);
      if (lookahead == '&') ADVANCE(484);
      if (lookahead == '\'') ADVANCE(534);
      if (lookahead == '(') ADVANCE(307);
      if (lookahead == '*') ADVANCE(495);
      if (lookahead == '+') ADVANCE(468);
      if (lookahead == ',') ADVANCE(305);
      if (lookahead == '-') ADVANCE(354);
      if (lookahead == '.') ADVANCE(339);
      if (lookahead == '/') ADVANCE(497);
      if (lookahead == ':') ADVANCE(55);
      if (lookahead == '<') ADVANCE(387);
      if (lookahead == '=') ADVANCE(344);
      if (lookahead == '>') ADVANCE(388);
      if (lookahead == '?') ADVANCE(68);
      if (lookahead == '@') ADVANCE(69);
      if (lookahead == '[') ADVANCE(310);
      if (lookahead == '\\') ADVANCE(455);
      if (lookahead == '^') ADVANCE(528);
      if (lookahead == '|') ADVANCE(479);
      if (lookahead == '}') ADVANCE(337);
      if (lookahead == '~') ADVANCE(349);
      if (lookahead == 0xac) ADVANCE(350);
      if (lookahead == 0xd7) ADVANCE(523);
      if (lookahead == 0xf7) ADVANCE(504);
      if (lookahead == 0x2016) ADVANCE(481);
      if (lookahead == 0x2025) ADVANCE(464);
      if (lookahead == 0x2026) ADVANCE(466);
      if (lookahead == 0x203c) ADVANCE(509);
      if (lookahead == 0x2047) ADVANCE(514);
      if (lookahead == 0x207a) ADVANCE(531);
      if (lookahead == 0x2115) ADVANCE(333);
      if (lookahead == 0x211d) ADVANCE(335);
      if (lookahead == 0x2124) ADVANCE(334);
      if (lookahead == 0x219d) ADVANCE(374);
      if (lookahead == 0x21d2) ADVANCE(363);
      if (lookahead == 0x21d4) ADVANCE(371);
      if (lookahead == 0x21dd) ADVANCE(373);
      if (lookahead == 0x21f8) ADVANCE(365);
      if (lookahead == 0x2208) ADVANCE(258);
      if (lookahead == 0x2209) ADVANCE(420);
      if (lookahead == 0x2218) ADVANCE(506);
      if (lookahead == 0x221d) ADVANCE(430);
      if (lookahead == 0x2227) ADVANCE(301);
      if (lookahead == 0x2228) ADVANCE(303);
      if (lookahead == 0x2229) ADVANCE(459);
      if (lookahead == 0x222a) ADVANCE(462);
      if (lookahead == 0x2237) ADVANCE(297);
      if (lookahead == 0x223c) ADVANCE(432);
      if (lookahead == 0x2240) ADVANCE(525);
      if (lookahead == 0x2243) ADVANCE(434);
      if (lookahead == 0x2245) ADVANCE(412);
      if (lookahead == 0x2248) ADVANCE(399);
      if (lookahead == 0x224d) ADVANCE(410);
      if (lookahead == 0x2250) ADVANCE(414);
      if (lookahead == 0x2254) ADVANCE(378);
      if (lookahead == 0x2260) ADVANCE(383);
      if (lookahead == 0x2261) ADVANCE(368);
      if (lookahead == 0x2264) ADVANCE(394);
      if (lookahead == 0x2265) ADVANCE(397);
      if (lookahead == 0x226a) ADVANCE(418);
      if (lookahead == 0x226b) ADVANCE(416);
      if (lookahead == 0x227a) ADVANCE(422);
      if (lookahead == 0x227b) ADVANCE(424);
      if (lookahead == 0x2282) ADVANCE(444);
      if (lookahead == 0x2283) ADVANCE(446);
      if (lookahead == 0x2286) ADVANCE(448);
      if (lookahead == 0x2287) ADVANCE(450);
      if (lookahead == 0x228e) ADVANCE(520);
      if (lookahead == 0x228f) ADVANCE(436);
      if (lookahead == 0x2290) ADVANCE(438);
      if (lookahead == 0x2291) ADVANCE(440);
      if (lookahead == 0x2292) ADVANCE(442);
      if (lookahead == 0x2293) ADVANCE(516);
      if (lookahead == 0x2294) ADVANCE(518);
      if (lookahead == 0x2295) ADVANCE(472);
      if (lookahead == 0x2296) ADVANCE(475);
      if (lookahead == 0x2297) ADVANCE(494);
      if (lookahead == 0x2298) ADVANCE(491);
      if (lookahead == 0x2299) ADVANCE(488);
      if (lookahead == 0x22a2) ADVANCE(402);
      if (lookahead == 0x22a3) ADVANCE(406);
      if (lookahead == 0x22a8) ADVANCE(404);
      if (lookahead == 0x22c4) ADVANCE(359);
      if (lookahead == 0x22c5) ADVANCE(527);
      if (lookahead == 0x22c6) ADVANCE(508);
      if (lookahead == 0x25a1) ADVANCE(289);
      if (lookahead == 0x25c7) ADVANCE(360);
      if (lookahead == 0x25cf) ADVANCE(502);
      if (lookahead == 0x25ef) ADVANCE(500);
      if (lookahead == 0x27f9) ADVANCE(362);
      if (lookahead == 0x27fa) ADVANCE(370);
      if (lookahead == 0x2945) ADVANCE(366);
      if (lookahead == 0x2a74) ADVANCE(380);
      if (lookahead == 0x2aaf) ADVANCE(426);
      if (lookahead == 0x2ab0) ADVANCE(428);
      if (lookahead == 0x2ae4) ADVANCE(408);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(10);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(224);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 11:
      if (lookahead == '\r') SKIP(11);
      if (lookahead == '!') ADVANCE(312);
      if (lookahead == '#') ADVANCE(382);
      if (lookahead == '$') ADVANCE(511);
      if (lookahead == '%') ADVANCE(476);
      if (lookahead == '&') ADVANCE(484);
      if (lookahead == '\'') ADVANCE(534);
      if (lookahead == '(') ADVANCE(307);
      if (lookahead == ')') ADVANCE(308);
      if (lookahead == '*') ADVANCE(495);
      if (lookahead == '+') ADVANCE(468);
      if (lookahead == ',') ADVANCE(305);
      if (lookahead == '-') ADVANCE(356);
      if (lookahead == '.') ADVANCE(339);
      if (lookahead == '/') ADVANCE(497);
      if (lookahead == ':') ADVANCE(292);
      if (lookahead == ';') ADVANCE(546);
      if (lookahead == '<') ADVANCE(386);
      if (lookahead == '=') ADVANCE(344);
      if (lookahead == '>') ADVANCE(388);
      if (lookahead == '?') ADVANCE(68);
      if (lookahead == '@') ADVANCE(69);
      if (lookahead == '[') ADVANCE(310);
      if (lookahead == '\\') ADVANCE(456);
      if (lookahead == ']') ADVANCE(311);
      if (lookahead == '^') ADVANCE(528);
      if (lookahead == '{') ADVANCE(336);
      if (lookahead == '|') ADVANCE(479);
      if (lookahead == '}') ADVANCE(337);
      if (lookahead == '~') ADVANCE(64);
      if (lookahead == 0xd7) ADVANCE(523);
      if (lookahead == 0xf7) ADVANCE(504);
      if (lookahead == 0x2016) ADVANCE(481);
      if (lookahead == 0x2025) ADVANCE(464);
      if (lookahead == 0x2026) ADVANCE(466);
      if (lookahead == 0x203c) ADVANCE(509);
      if (lookahead == 0x2047) ADVANCE(514);
      if (lookahead == 0x207a) ADVANCE(531);
      if (lookahead == 0x219d) ADVANCE(374);
      if (lookahead == 0x21d2) ADVANCE(363);
      if (lookahead == 0x21d4) ADVANCE(371);
      if (lookahead == 0x21dd) ADVANCE(373);
      if (lookahead == 0x21f8) ADVANCE(365);
      if (lookahead == 0x2208) ADVANCE(258);
      if (lookahead == 0x2209) ADVANCE(420);
      if (lookahead == 0x2218) ADVANCE(506);
      if (lookahead == 0x221d) ADVANCE(430);
      if (lookahead == 0x2227) ADVANCE(301);
      if (lookahead == 0x2228) ADVANCE(303);
      if (lookahead == 0x2229) ADVANCE(459);
      if (lookahead == 0x222a) ADVANCE(462);
      if (lookahead == 0x223c) ADVANCE(432);
      if (lookahead == 0x2240) ADVANCE(525);
      if (lookahead == 0x2243) ADVANCE(434);
      if (lookahead == 0x2245) ADVANCE(412);
      if (lookahead == 0x2248) ADVANCE(399);
      if (lookahead == 0x224d) ADVANCE(410);
      if (lookahead == 0x2250) ADVANCE(414);
      if (lookahead == 0x2254) ADVANCE(378);
      if (lookahead == 0x2260) ADVANCE(383);
      if (lookahead == 0x2261) ADVANCE(368);
      if (lookahead == 0x2264) ADVANCE(394);
      if (lookahead == 0x2265) ADVANCE(397);
      if (lookahead == 0x226a) ADVANCE(418);
      if (lookahead == 0x226b) ADVANCE(416);
      if (lookahead == 0x227a) ADVANCE(422);
      if (lookahead == 0x227b) ADVANCE(424);
      if (lookahead == 0x2282) ADVANCE(444);
      if (lookahead == 0x2283) ADVANCE(446);
      if (lookahead == 0x2286) ADVANCE(448);
      if (lookahead == 0x2287) ADVANCE(450);
      if (lookahead == 0x228e) ADVANCE(520);
      if (lookahead == 0x228f) ADVANCE(436);
      if (lookahead == 0x2290) ADVANCE(438);
      if (lookahead == 0x2291) ADVANCE(440);
      if (lookahead == 0x2292) ADVANCE(442);
      if (lookahead == 0x2293) ADVANCE(516);
      if (lookahead == 0x2294) ADVANCE(518);
      if (lookahead == 0x2295) ADVANCE(472);
      if (lookahead == 0x2296) ADVANCE(475);
      if (lookahead == 0x2297) ADVANCE(494);
      if (lookahead == 0x2298) ADVANCE(491);
      if (lookahead == 0x2299) ADVANCE(488);
      if (lookahead == 0x22a2) ADVANCE(402);
      if (lookahead == 0x22a3) ADVANCE(406);
      if (lookahead == 0x22a8) ADVANCE(404);
      if (lookahead == 0x22c5) ADVANCE(527);
      if (lookahead == 0x22c6) ADVANCE(508);
      if (lookahead == 0x25a1) ADVANCE(289);
      if (lookahead == 0x25cf) ADVANCE(502);
      if (lookahead == 0x25ef) ADVANCE(500);
      if (lookahead == 0x27f9) ADVANCE(362);
      if (lookahead == 0x27fa) ADVANCE(370);
      if (lookahead == 0x2945) ADVANCE(366);
      if (lookahead == 0x2a74) ADVANCE(380);
      if (lookahead == 0x2aaf) ADVANCE(426);
      if (lookahead == 0x2ab0) ADVANCE(428);
      if (lookahead == 0x2ae4) ADVANCE(408);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(11);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(224);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 12:
      if (lookahead == '\r') SKIP(12);
      if (lookahead == '!') ADVANCE(312);
      if (lookahead == '#') ADVANCE(382);
      if (lookahead == '$') ADVANCE(511);
      if (lookahead == '%') ADVANCE(476);
      if (lookahead == '&') ADVANCE(484);
      if (lookahead == '\'') ADVANCE(534);
      if (lookahead == '(') ADVANCE(307);
      if (lookahead == '*') ADVANCE(495);
      if (lookahead == '+') ADVANCE(468);
      if (lookahead == '-') ADVANCE(356);
      if (lookahead == '.') ADVANCE(339);
      if (lookahead == '/') ADVANCE(497);
      if (lookahead == ':') ADVANCE(55);
      if (lookahead == '<') ADVANCE(386);
      if (lookahead == '=') ADVANCE(342);
      if (lookahead == '>') ADVANCE(388);
      if (lookahead == '?') ADVANCE(68);
      if (lookahead == '@') ADVANCE(69);
      if (lookahead == '[') ADVANCE(309);
      if (lookahead == '\\') ADVANCE(456);
      if (lookahead == '^') ADVANCE(528);
      if (lookahead == '|') ADVANCE(479);
      if (lookahead == '~') ADVANCE(64);
      if (lookahead == 0xd7) ADVANCE(523);
      if (lookahead == 0xf7) ADVANCE(504);
      if (lookahead == 0x2016) ADVANCE(481);
      if (lookahead == 0x2025) ADVANCE(464);
      if (lookahead == 0x2026) ADVANCE(466);
      if (lookahead == 0x203c) ADVANCE(509);
      if (lookahead == 0x2047) ADVANCE(514);
      if (lookahead == 0x207a) ADVANCE(531);
      if (lookahead == 0x219d) ADVANCE(374);
      if (lookahead == 0x21d2) ADVANCE(363);
      if (lookahead == 0x21d4) ADVANCE(371);
      if (lookahead == 0x21dd) ADVANCE(373);
      if (lookahead == 0x21f8) ADVANCE(365);
      if (lookahead == 0x2208) ADVANCE(258);
      if (lookahead == 0x2209) ADVANCE(420);
      if (lookahead == 0x2218) ADVANCE(506);
      if (lookahead == 0x221d) ADVANCE(430);
      if (lookahead == 0x2227) ADVANCE(301);
      if (lookahead == 0x2228) ADVANCE(303);
      if (lookahead == 0x2229) ADVANCE(459);
      if (lookahead == 0x222a) ADVANCE(462);
      if (lookahead == 0x2237) ADVANCE(297);
      if (lookahead == 0x223c) ADVANCE(432);
      if (lookahead == 0x2240) ADVANCE(525);
      if (lookahead == 0x2243) ADVANCE(434);
      if (lookahead == 0x2245) ADVANCE(412);
      if (lookahead == 0x2248) ADVANCE(399);
      if (lookahead == 0x224d) ADVANCE(410);
      if (lookahead == 0x2250) ADVANCE(414);
      if (lookahead == 0x2254) ADVANCE(378);
      if (lookahead == 0x225c) ADVANCE(255);
      if (lookahead == 0x2260) ADVANCE(383);
      if (lookahead == 0x2261) ADVANCE(368);
      if (lookahead == 0x2264) ADVANCE(394);
      if (lookahead == 0x2265) ADVANCE(397);
      if (lookahead == 0x226a) ADVANCE(418);
      if (lookahead == 0x226b) ADVANCE(416);
      if (lookahead == 0x227a) ADVANCE(422);
      if (lookahead == 0x227b) ADVANCE(424);
      if (lookahead == 0x2282) ADVANCE(444);
      if (lookahead == 0x2283) ADVANCE(446);
      if (lookahead == 0x2286) ADVANCE(448);
      if (lookahead == 0x2287) ADVANCE(450);
      if (lookahead == 0x228e) ADVANCE(520);
      if (lookahead == 0x228f) ADVANCE(436);
      if (lookahead == 0x2290) ADVANCE(438);
      if (lookahead == 0x2291) ADVANCE(440);
      if (lookahead == 0x2292) ADVANCE(442);
      if (lookahead == 0x2293) ADVANCE(516);
      if (lookahead == 0x2294) ADVANCE(518);
      if (lookahead == 0x2295) ADVANCE(472);
      if (lookahead == 0x2296) ADVANCE(475);
      if (lookahead == 0x2297) ADVANCE(494);
      if (lookahead == 0x2298) ADVANCE(491);
      if (lookahead == 0x2299) ADVANCE(488);
      if (lookahead == 0x22a2) ADVANCE(402);
      if (lookahead == 0x22a3) ADVANCE(406);
      if (lookahead == 0x22a8) ADVANCE(404);
      if (lookahead == 0x22c5) ADVANCE(527);
      if (lookahead == 0x22c6) ADVANCE(508);
      if (lookahead == 0x25cf) ADVANCE(502);
      if (lookahead == 0x25ef) ADVANCE(500);
      if (lookahead == 0x27f9) ADVANCE(362);
      if (lookahead == 0x27fa) ADVANCE(370);
      if (lookahead == 0x2945) ADVANCE(366);
      if (lookahead == 0x2a74) ADVANCE(380);
      if (lookahead == 0x2aaf) ADVANCE(426);
      if (lookahead == 0x2ab0) ADVANCE(428);
      if (lookahead == 0x2ae4) ADVANCE(408);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(12);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(224);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 13:
      if (lookahead == '\r') SKIP(13);
      if (lookahead == '!') ADVANCE(312);
      if (lookahead == '#') ADVANCE(382);
      if (lookahead == '$') ADVANCE(511);
      if (lookahead == '%') ADVANCE(476);
      if (lookahead == '&') ADVANCE(484);
      if (lookahead == '\'') ADVANCE(534);
      if (lookahead == '(') ADVANCE(307);
      if (lookahead == '*') ADVANCE(495);
      if (lookahead == '+') ADVANCE(468);
      if (lookahead == '-') ADVANCE(355);
      if (lookahead == '.') ADVANCE(339);
      if (lookahead == '/') ADVANCE(497);
      if (lookahead == ':') ADVANCE(55);
      if (lookahead == '<') ADVANCE(386);
      if (lookahead == '=') ADVANCE(344);
      if (lookahead == '>') ADVANCE(388);
      if (lookahead == '?') ADVANCE(68);
      if (lookahead == '@') ADVANCE(69);
      if (lookahead == '[') ADVANCE(310);
      if (lookahead == '\\') ADVANCE(456);
      if (lookahead == ']') ADVANCE(72);
      if (lookahead == '^') ADVANCE(528);
      if (lookahead == '|') ADVANCE(479);
      if (lookahead == '~') ADVANCE(64);
      if (lookahead == 0xd7) ADVANCE(523);
      if (lookahead == 0xf7) ADVANCE(504);
      if (lookahead == 0x2016) ADVANCE(481);
      if (lookahead == 0x2025) ADVANCE(464);
      if (lookahead == 0x2026) ADVANCE(466);
      if (lookahead == 0x203c) ADVANCE(509);
      if (lookahead == 0x2047) ADVANCE(514);
      if (lookahead == 0x207a) ADVANCE(531);
      if (lookahead == 0x2192) ADVANCE(275);
      if (lookahead == 0x219d) ADVANCE(374);
      if (lookahead == 0x21d2) ADVANCE(363);
      if (lookahead == 0x21d4) ADVANCE(371);
      if (lookahead == 0x21dd) ADVANCE(373);
      if (lookahead == 0x21f8) ADVANCE(365);
      if (lookahead == 0x2208) ADVANCE(258);
      if (lookahead == 0x2209) ADVANCE(420);
      if (lookahead == 0x2218) ADVANCE(506);
      if (lookahead == 0x221d) ADVANCE(430);
      if (lookahead == 0x2227) ADVANCE(301);
      if (lookahead == 0x2228) ADVANCE(303);
      if (lookahead == 0x2229) ADVANCE(459);
      if (lookahead == 0x222a) ADVANCE(462);
      if (lookahead == 0x2237) ADVANCE(297);
      if (lookahead == 0x223c) ADVANCE(432);
      if (lookahead == 0x2240) ADVANCE(525);
      if (lookahead == 0x2243) ADVANCE(434);
      if (lookahead == 0x2245) ADVANCE(412);
      if (lookahead == 0x2248) ADVANCE(399);
      if (lookahead == 0x224d) ADVANCE(410);
      if (lookahead == 0x2250) ADVANCE(414);
      if (lookahead == 0x2254) ADVANCE(378);
      if (lookahead == 0x2260) ADVANCE(383);
      if (lookahead == 0x2261) ADVANCE(368);
      if (lookahead == 0x2264) ADVANCE(394);
      if (lookahead == 0x2265) ADVANCE(397);
      if (lookahead == 0x226a) ADVANCE(418);
      if (lookahead == 0x226b) ADVANCE(416);
      if (lookahead == 0x227a) ADVANCE(422);
      if (lookahead == 0x227b) ADVANCE(424);
      if (lookahead == 0x2282) ADVANCE(444);
      if (lookahead == 0x2283) ADVANCE(446);
      if (lookahead == 0x2286) ADVANCE(448);
      if (lookahead == 0x2287) ADVANCE(450);
      if (lookahead == 0x228e) ADVANCE(520);
      if (lookahead == 0x228f) ADVANCE(436);
      if (lookahead == 0x2290) ADVANCE(438);
      if (lookahead == 0x2291) ADVANCE(440);
      if (lookahead == 0x2292) ADVANCE(442);
      if (lookahead == 0x2293) ADVANCE(516);
      if (lookahead == 0x2294) ADVANCE(518);
      if (lookahead == 0x2295) ADVANCE(472);
      if (lookahead == 0x2296) ADVANCE(475);
      if (lookahead == 0x2297) ADVANCE(494);
      if (lookahead == 0x2298) ADVANCE(491);
      if (lookahead == 0x2299) ADVANCE(488);
      if (lookahead == 0x22a2) ADVANCE(402);
      if (lookahead == 0x22a3) ADVANCE(406);
      if (lookahead == 0x22a8) ADVANCE(404);
      if (lookahead == 0x22c5) ADVANCE(527);
      if (lookahead == 0x22c6) ADVANCE(508);
      if (lookahead == 0x25a1) ADVANCE(289);
      if (lookahead == 0x25cf) ADVANCE(502);
      if (lookahead == 0x25ef) ADVANCE(500);
      if (lookahead == 0x27f6) ADVANCE(274);
      if (lookahead == 0x27f9) ADVANCE(362);
      if (lookahead == 0x27fa) ADVANCE(370);
      if (lookahead == 0x2945) ADVANCE(366);
      if (lookahead == 0x2a74) ADVANCE(380);
      if (lookahead == 0x2aaf) ADVANCE(426);
      if (lookahead == 0x2ab0) ADVANCE(428);
      if (lookahead == 0x2ae4) ADVANCE(408);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(13);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(224);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 14:
      if (lookahead == '\r') SKIP(15);
      if (lookahead == '!') ADVANCE(312);
      if (lookahead == '#') ADVANCE(382);
      if (lookahead == '$') ADVANCE(511);
      if (lookahead == '%') ADVANCE(476);
      if (lookahead == '&') ADVANCE(484);
      if (lookahead == '\'') ADVANCE(534);
      if (lookahead == '(') ADVANCE(307);
      if (lookahead == '*') ADVANCE(495);
      if (lookahead == '+') ADVANCE(468);
      if (lookahead == ',') ADVANCE(305);
      if (lookahead == '-') ADVANCE(356);
      if (lookahead == '.') ADVANCE(339);
      if (lookahead == '/') ADVANCE(497);
      if (lookahead == ':') ADVANCE(55);
      if (lookahead == '<') ADVANCE(386);
      if (lookahead == '=') ADVANCE(344);
      if (lookahead == '>') ADVANCE(389);
      if (lookahead == '?') ADVANCE(68);
      if (lookahead == '@') ADVANCE(69);
      if (lookahead == '[') ADVANCE(310);
      if (lookahead == '\\') ADVANCE(456);
      if (lookahead == '^') ADVANCE(528);
      if (lookahead == '_') ADVANCE(298);
      if (lookahead == '|') ADVANCE(479);
      if (lookahead == '~') ADVANCE(64);
      if (lookahead == 0xd7) ADVANCE(523);
      if (lookahead == 0xf7) ADVANCE(504);
      if (lookahead == 0x2016) ADVANCE(481);
      if (lookahead == 0x2025) ADVANCE(464);
      if (lookahead == 0x2026) ADVANCE(466);
      if (lookahead == 0x203c) ADVANCE(509);
      if (lookahead == 0x2047) ADVANCE(514);
      if (lookahead == 0x207a) ADVANCE(531);
      if (lookahead == 0x219d) ADVANCE(374);
      if (lookahead == 0x21d2) ADVANCE(363);
      if (lookahead == 0x21d4) ADVANCE(371);
      if (lookahead == 0x21dd) ADVANCE(373);
      if (lookahead == 0x21f8) ADVANCE(365);
      if (lookahead == 0x2208) ADVANCE(258);
      if (lookahead == 0x2209) ADVANCE(420);
      if (lookahead == 0x2218) ADVANCE(506);
      if (lookahead == 0x221d) ADVANCE(430);
      if (lookahead == 0x2227) ADVANCE(301);
      if (lookahead == 0x2228) ADVANCE(303);
      if (lookahead == 0x2229) ADVANCE(459);
      if (lookahead == 0x222a) ADVANCE(462);
      if (lookahead == 0x2237) ADVANCE(297);
      if (lookahead == 0x223c) ADVANCE(432);
      if (lookahead == 0x2240) ADVANCE(525);
      if (lookahead == 0x2243) ADVANCE(434);
      if (lookahead == 0x2245) ADVANCE(412);
      if (lookahead == 0x2248) ADVANCE(399);
      if (lookahead == 0x224d) ADVANCE(410);
      if (lookahead == 0x2250) ADVANCE(414);
      if (lookahead == 0x2254) ADVANCE(378);
      if (lookahead == 0x2260) ADVANCE(383);
      if (lookahead == 0x2261) ADVANCE(368);
      if (lookahead == 0x2264) ADVANCE(394);
      if (lookahead == 0x2265) ADVANCE(397);
      if (lookahead == 0x226a) ADVANCE(418);
      if (lookahead == 0x226b) ADVANCE(416);
      if (lookahead == 0x227a) ADVANCE(422);
      if (lookahead == 0x227b) ADVANCE(424);
      if (lookahead == 0x2282) ADVANCE(444);
      if (lookahead == 0x2283) ADVANCE(446);
      if (lookahead == 0x2286) ADVANCE(448);
      if (lookahead == 0x2287) ADVANCE(450);
      if (lookahead == 0x228e) ADVANCE(520);
      if (lookahead == 0x228f) ADVANCE(436);
      if (lookahead == 0x2290) ADVANCE(438);
      if (lookahead == 0x2291) ADVANCE(440);
      if (lookahead == 0x2292) ADVANCE(442);
      if (lookahead == 0x2293) ADVANCE(516);
      if (lookahead == 0x2294) ADVANCE(518);
      if (lookahead == 0x2295) ADVANCE(472);
      if (lookahead == 0x2296) ADVANCE(475);
      if (lookahead == 0x2297) ADVANCE(494);
      if (lookahead == 0x2298) ADVANCE(491);
      if (lookahead == 0x2299) ADVANCE(488);
      if (lookahead == 0x22a2) ADVANCE(402);
      if (lookahead == 0x22a3) ADVANCE(406);
      if (lookahead == 0x22a8) ADVANCE(404);
      if (lookahead == 0x22c5) ADVANCE(527);
      if (lookahead == 0x22c6) ADVANCE(508);
      if (lookahead == 0x25a1) ADVANCE(289);
      if (lookahead == 0x25cf) ADVANCE(502);
      if (lookahead == 0x25ef) ADVANCE(500);
      if (lookahead == 0x27e9) ADVANCE(284);
      if (lookahead == 0x27f9) ADVANCE(362);
      if (lookahead == 0x27fa) ADVANCE(370);
      if (lookahead == 0x2945) ADVANCE(366);
      if (lookahead == 0x2a74) ADVANCE(380);
      if (lookahead == 0x2aaf) ADVANCE(426);
      if (lookahead == 0x2ab0) ADVANCE(428);
      if (lookahead == 0x2ae4) ADVANCE(408);
      if (lookahead == 0x3009) ADVANCE(282);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(319);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(15);
      END_STATE();
    case 15:
      if (lookahead == '\r') SKIP(15);
      if (lookahead == '!') ADVANCE(312);
      if (lookahead == '#') ADVANCE(382);
      if (lookahead == '$') ADVANCE(511);
      if (lookahead == '%') ADVANCE(476);
      if (lookahead == '&') ADVANCE(484);
      if (lookahead == '\'') ADVANCE(534);
      if (lookahead == '(') ADVANCE(307);
      if (lookahead == '*') ADVANCE(495);
      if (lookahead == '+') ADVANCE(468);
      if (lookahead == ',') ADVANCE(305);
      if (lookahead == '-') ADVANCE(356);
      if (lookahead == '.') ADVANCE(339);
      if (lookahead == '/') ADVANCE(497);
      if (lookahead == ':') ADVANCE(55);
      if (lookahead == '<') ADVANCE(386);
      if (lookahead == '=') ADVANCE(344);
      if (lookahead == '>') ADVANCE(389);
      if (lookahead == '?') ADVANCE(68);
      if (lookahead == '@') ADVANCE(69);
      if (lookahead == '[') ADVANCE(310);
      if (lookahead == '\\') ADVANCE(456);
      if (lookahead == '^') ADVANCE(528);
      if (lookahead == '_') ADVANCE(298);
      if (lookahead == '|') ADVANCE(479);
      if (lookahead == '~') ADVANCE(64);
      if (lookahead == 0xd7) ADVANCE(523);
      if (lookahead == 0xf7) ADVANCE(504);
      if (lookahead == 0x2016) ADVANCE(481);
      if (lookahead == 0x2025) ADVANCE(464);
      if (lookahead == 0x2026) ADVANCE(466);
      if (lookahead == 0x203c) ADVANCE(509);
      if (lookahead == 0x2047) ADVANCE(514);
      if (lookahead == 0x207a) ADVANCE(531);
      if (lookahead == 0x219d) ADVANCE(374);
      if (lookahead == 0x21d2) ADVANCE(363);
      if (lookahead == 0x21d4) ADVANCE(371);
      if (lookahead == 0x21dd) ADVANCE(373);
      if (lookahead == 0x21f8) ADVANCE(365);
      if (lookahead == 0x2208) ADVANCE(258);
      if (lookahead == 0x2209) ADVANCE(420);
      if (lookahead == 0x2218) ADVANCE(506);
      if (lookahead == 0x221d) ADVANCE(430);
      if (lookahead == 0x2227) ADVANCE(301);
      if (lookahead == 0x2228) ADVANCE(303);
      if (lookahead == 0x2229) ADVANCE(459);
      if (lookahead == 0x222a) ADVANCE(462);
      if (lookahead == 0x2237) ADVANCE(297);
      if (lookahead == 0x223c) ADVANCE(432);
      if (lookahead == 0x2240) ADVANCE(525);
      if (lookahead == 0x2243) ADVANCE(434);
      if (lookahead == 0x2245) ADVANCE(412);
      if (lookahead == 0x2248) ADVANCE(399);
      if (lookahead == 0x224d) ADVANCE(410);
      if (lookahead == 0x2250) ADVANCE(414);
      if (lookahead == 0x2254) ADVANCE(378);
      if (lookahead == 0x2260) ADVANCE(383);
      if (lookahead == 0x2261) ADVANCE(368);
      if (lookahead == 0x2264) ADVANCE(394);
      if (lookahead == 0x2265) ADVANCE(397);
      if (lookahead == 0x226a) ADVANCE(418);
      if (lookahead == 0x226b) ADVANCE(416);
      if (lookahead == 0x227a) ADVANCE(422);
      if (lookahead == 0x227b) ADVANCE(424);
      if (lookahead == 0x2282) ADVANCE(444);
      if (lookahead == 0x2283) ADVANCE(446);
      if (lookahead == 0x2286) ADVANCE(448);
      if (lookahead == 0x2287) ADVANCE(450);
      if (lookahead == 0x228e) ADVANCE(520);
      if (lookahead == 0x228f) ADVANCE(436);
      if (lookahead == 0x2290) ADVANCE(438);
      if (lookahead == 0x2291) ADVANCE(440);
      if (lookahead == 0x2292) ADVANCE(442);
      if (lookahead == 0x2293) ADVANCE(516);
      if (lookahead == 0x2294) ADVANCE(518);
      if (lookahead == 0x2295) ADVANCE(472);
      if (lookahead == 0x2296) ADVANCE(475);
      if (lookahead == 0x2297) ADVANCE(494);
      if (lookahead == 0x2298) ADVANCE(491);
      if (lookahead == 0x2299) ADVANCE(488);
      if (lookahead == 0x22a2) ADVANCE(402);
      if (lookahead == 0x22a3) ADVANCE(406);
      if (lookahead == 0x22a8) ADVANCE(404);
      if (lookahead == 0x22c5) ADVANCE(527);
      if (lookahead == 0x22c6) ADVANCE(508);
      if (lookahead == 0x25a1) ADVANCE(289);
      if (lookahead == 0x25cf) ADVANCE(502);
      if (lookahead == 0x25ef) ADVANCE(500);
      if (lookahead == 0x27e9) ADVANCE(284);
      if (lookahead == 0x27f9) ADVANCE(362);
      if (lookahead == 0x27fa) ADVANCE(370);
      if (lookahead == 0x2945) ADVANCE(366);
      if (lookahead == 0x2a74) ADVANCE(380);
      if (lookahead == 0x2aaf) ADVANCE(426);
      if (lookahead == 0x2ab0) ADVANCE(428);
      if (lookahead == 0x2ae4) ADVANCE(408);
      if (lookahead == 0x3009) ADVANCE(282);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(15);
      END_STATE();
    case 16:
      if (lookahead == '\r') SKIP(16);
      if (lookahead == '!') ADVANCE(312);
      if (lookahead == '#') ADVANCE(382);
      if (lookahead == '$') ADVANCE(511);
      if (lookahead == '%') ADVANCE(476);
      if (lookahead == '&') ADVANCE(484);
      if (lookahead == '\'') ADVANCE(534);
      if (lookahead == '(') ADVANCE(307);
      if (lookahead == '*') ADVANCE(495);
      if (lookahead == '+') ADVANCE(468);
      if (lookahead == ',') ADVANCE(305);
      if (lookahead == '-') ADVANCE(356);
      if (lookahead == '.') ADVANCE(339);
      if (lookahead == '/') ADVANCE(497);
      if (lookahead == ':') ADVANCE(55);
      if (lookahead == '<') ADVANCE(386);
      if (lookahead == '=') ADVANCE(344);
      if (lookahead == '>') ADVANCE(390);
      if (lookahead == '?') ADVANCE(68);
      if (lookahead == '@') ADVANCE(69);
      if (lookahead == '[') ADVANCE(310);
      if (lookahead == '\\') ADVANCE(456);
      if (lookahead == '^') ADVANCE(528);
      if (lookahead == '|') ADVANCE(479);
      if (lookahead == '~') ADVANCE(64);
      if (lookahead == 0xd7) ADVANCE(523);
      if (lookahead == 0xf7) ADVANCE(504);
      if (lookahead == 0x2016) ADVANCE(481);
      if (lookahead == 0x2025) ADVANCE(464);
      if (lookahead == 0x2026) ADVANCE(466);
      if (lookahead == 0x203c) ADVANCE(509);
      if (lookahead == 0x2047) ADVANCE(514);
      if (lookahead == 0x207a) ADVANCE(531);
      if (lookahead == 0x219d) ADVANCE(374);
      if (lookahead == 0x21d2) ADVANCE(363);
      if (lookahead == 0x21d4) ADVANCE(371);
      if (lookahead == 0x21dd) ADVANCE(373);
      if (lookahead == 0x21f8) ADVANCE(365);
      if (lookahead == 0x2208) ADVANCE(258);
      if (lookahead == 0x2209) ADVANCE(420);
      if (lookahead == 0x2218) ADVANCE(506);
      if (lookahead == 0x221d) ADVANCE(430);
      if (lookahead == 0x2227) ADVANCE(301);
      if (lookahead == 0x2228) ADVANCE(303);
      if (lookahead == 0x2229) ADVANCE(459);
      if (lookahead == 0x222a) ADVANCE(462);
      if (lookahead == 0x2237) ADVANCE(297);
      if (lookahead == 0x223c) ADVANCE(432);
      if (lookahead == 0x2240) ADVANCE(525);
      if (lookahead == 0x2243) ADVANCE(434);
      if (lookahead == 0x2245) ADVANCE(412);
      if (lookahead == 0x2248) ADVANCE(399);
      if (lookahead == 0x224d) ADVANCE(410);
      if (lookahead == 0x2250) ADVANCE(414);
      if (lookahead == 0x2254) ADVANCE(378);
      if (lookahead == 0x2260) ADVANCE(383);
      if (lookahead == 0x2261) ADVANCE(368);
      if (lookahead == 0x2264) ADVANCE(394);
      if (lookahead == 0x2265) ADVANCE(397);
      if (lookahead == 0x226a) ADVANCE(418);
      if (lookahead == 0x226b) ADVANCE(416);
      if (lookahead == 0x227a) ADVANCE(422);
      if (lookahead == 0x227b) ADVANCE(424);
      if (lookahead == 0x2282) ADVANCE(444);
      if (lookahead == 0x2283) ADVANCE(446);
      if (lookahead == 0x2286) ADVANCE(448);
      if (lookahead == 0x2287) ADVANCE(450);
      if (lookahead == 0x228e) ADVANCE(520);
      if (lookahead == 0x228f) ADVANCE(436);
      if (lookahead == 0x2290) ADVANCE(438);
      if (lookahead == 0x2291) ADVANCE(440);
      if (lookahead == 0x2292) ADVANCE(442);
      if (lookahead == 0x2293) ADVANCE(516);
      if (lookahead == 0x2294) ADVANCE(518);
      if (lookahead == 0x2295) ADVANCE(472);
      if (lookahead == 0x2296) ADVANCE(475);
      if (lookahead == 0x2297) ADVANCE(494);
      if (lookahead == 0x2298) ADVANCE(491);
      if (lookahead == 0x2299) ADVANCE(488);
      if (lookahead == 0x22a2) ADVANCE(402);
      if (lookahead == 0x22a3) ADVANCE(406);
      if (lookahead == 0x22a8) ADVANCE(404);
      if (lookahead == 0x22c5) ADVANCE(527);
      if (lookahead == 0x22c6) ADVANCE(508);
      if (lookahead == 0x25a1) ADVANCE(289);
      if (lookahead == 0x25cf) ADVANCE(502);
      if (lookahead == 0x25ef) ADVANCE(500);
      if (lookahead == 0x27e9) ADVANCE(283);
      if (lookahead == 0x27f9) ADVANCE(362);
      if (lookahead == 0x27fa) ADVANCE(370);
      if (lookahead == 0x2945) ADVANCE(366);
      if (lookahead == 0x2a74) ADVANCE(380);
      if (lookahead == 0x2aaf) ADVANCE(426);
      if (lookahead == 0x2ab0) ADVANCE(428);
      if (lookahead == 0x2ae4) ADVANCE(408);
      if (lookahead == 0x3009) ADVANCE(281);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(16);
      END_STATE();
    case 17:
      if (lookahead == '\r') SKIP(16);
      if (lookahead == '!') ADVANCE(312);
      if (lookahead == '#') ADVANCE(382);
      if (lookahead == '$') ADVANCE(511);
      if (lookahead == '%') ADVANCE(476);
      if (lookahead == '&') ADVANCE(484);
      if (lookahead == '\'') ADVANCE(534);
      if (lookahead == '(') ADVANCE(307);
      if (lookahead == '*') ADVANCE(495);
      if (lookahead == '+') ADVANCE(468);
      if (lookahead == ',') ADVANCE(305);
      if (lookahead == '-') ADVANCE(356);
      if (lookahead == '.') ADVANCE(339);
      if (lookahead == '/') ADVANCE(497);
      if (lookahead == ':') ADVANCE(55);
      if (lookahead == '<') ADVANCE(386);
      if (lookahead == '=') ADVANCE(344);
      if (lookahead == '>') ADVANCE(390);
      if (lookahead == '?') ADVANCE(68);
      if (lookahead == '@') ADVANCE(69);
      if (lookahead == '[') ADVANCE(310);
      if (lookahead == '\\') ADVANCE(456);
      if (lookahead == '^') ADVANCE(528);
      if (lookahead == '|') ADVANCE(479);
      if (lookahead == '~') ADVANCE(64);
      if (lookahead == 0xd7) ADVANCE(523);
      if (lookahead == 0xf7) ADVANCE(504);
      if (lookahead == 0x2016) ADVANCE(481);
      if (lookahead == 0x2025) ADVANCE(464);
      if (lookahead == 0x2026) ADVANCE(466);
      if (lookahead == 0x203c) ADVANCE(509);
      if (lookahead == 0x2047) ADVANCE(514);
      if (lookahead == 0x207a) ADVANCE(531);
      if (lookahead == 0x219d) ADVANCE(374);
      if (lookahead == 0x21d2) ADVANCE(363);
      if (lookahead == 0x21d4) ADVANCE(371);
      if (lookahead == 0x21dd) ADVANCE(373);
      if (lookahead == 0x21f8) ADVANCE(365);
      if (lookahead == 0x2208) ADVANCE(258);
      if (lookahead == 0x2209) ADVANCE(420);
      if (lookahead == 0x2218) ADVANCE(506);
      if (lookahead == 0x221d) ADVANCE(430);
      if (lookahead == 0x2227) ADVANCE(301);
      if (lookahead == 0x2228) ADVANCE(303);
      if (lookahead == 0x2229) ADVANCE(459);
      if (lookahead == 0x222a) ADVANCE(462);
      if (lookahead == 0x2237) ADVANCE(297);
      if (lookahead == 0x223c) ADVANCE(432);
      if (lookahead == 0x2240) ADVANCE(525);
      if (lookahead == 0x2243) ADVANCE(434);
      if (lookahead == 0x2245) ADVANCE(412);
      if (lookahead == 0x2248) ADVANCE(399);
      if (lookahead == 0x224d) ADVANCE(410);
      if (lookahead == 0x2250) ADVANCE(414);
      if (lookahead == 0x2254) ADVANCE(378);
      if (lookahead == 0x2260) ADVANCE(383);
      if (lookahead == 0x2261) ADVANCE(368);
      if (lookahead == 0x2264) ADVANCE(394);
      if (lookahead == 0x2265) ADVANCE(397);
      if (lookahead == 0x226a) ADVANCE(418);
      if (lookahead == 0x226b) ADVANCE(416);
      if (lookahead == 0x227a) ADVANCE(422);
      if (lookahead == 0x227b) ADVANCE(424);
      if (lookahead == 0x2282) ADVANCE(444);
      if (lookahead == 0x2283) ADVANCE(446);
      if (lookahead == 0x2286) ADVANCE(448);
      if (lookahead == 0x2287) ADVANCE(450);
      if (lookahead == 0x228e) ADVANCE(520);
      if (lookahead == 0x228f) ADVANCE(436);
      if (lookahead == 0x2290) ADVANCE(438);
      if (lookahead == 0x2291) ADVANCE(440);
      if (lookahead == 0x2292) ADVANCE(442);
      if (lookahead == 0x2293) ADVANCE(516);
      if (lookahead == 0x2294) ADVANCE(518);
      if (lookahead == 0x2295) ADVANCE(472);
      if (lookahead == 0x2296) ADVANCE(475);
      if (lookahead == 0x2297) ADVANCE(494);
      if (lookahead == 0x2298) ADVANCE(491);
      if (lookahead == 0x2299) ADVANCE(488);
      if (lookahead == 0x22a2) ADVANCE(402);
      if (lookahead == 0x22a3) ADVANCE(406);
      if (lookahead == 0x22a8) ADVANCE(404);
      if (lookahead == 0x22c5) ADVANCE(527);
      if (lookahead == 0x22c6) ADVANCE(508);
      if (lookahead == 0x25a1) ADVANCE(289);
      if (lookahead == 0x25cf) ADVANCE(502);
      if (lookahead == 0x25ef) ADVANCE(500);
      if (lookahead == 0x27e9) ADVANCE(283);
      if (lookahead == 0x27f9) ADVANCE(362);
      if (lookahead == 0x27fa) ADVANCE(370);
      if (lookahead == 0x2945) ADVANCE(366);
      if (lookahead == 0x2a74) ADVANCE(380);
      if (lookahead == 0x2aaf) ADVANCE(426);
      if (lookahead == 0x2ab0) ADVANCE(428);
      if (lookahead == 0x2ae4) ADVANCE(408);
      if (lookahead == 0x3009) ADVANCE(281);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(16);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(324);
      END_STATE();
    case 18:
      if (lookahead == '\r') SKIP(18);
      if (lookahead == '!') ADVANCE(312);
      if (lookahead == '#') ADVANCE(382);
      if (lookahead == '$') ADVANCE(511);
      if (lookahead == '%') ADVANCE(476);
      if (lookahead == '&') ADVANCE(484);
      if (lookahead == '\'') ADVANCE(534);
      if (lookahead == '(') ADVANCE(307);
      if (lookahead == '*') ADVANCE(495);
      if (lookahead == '+') ADVANCE(468);
      if (lookahead == ',') ADVANCE(305);
      if (lookahead == '-') ADVANCE(356);
      if (lookahead == '.') ADVANCE(339);
      if (lookahead == '/') ADVANCE(497);
      if (lookahead == ':') ADVANCE(55);
      if (lookahead == '<') ADVANCE(386);
      if (lookahead == '=') ADVANCE(344);
      if (lookahead == '>') ADVANCE(388);
      if (lookahead == '?') ADVANCE(68);
      if (lookahead == '@') ADVANCE(69);
      if (lookahead == '[') ADVANCE(310);
      if (lookahead == '\\') ADVANCE(456);
      if (lookahead == '^') ADVANCE(528);
      if (lookahead == '|') ADVANCE(478);
      if (lookahead == '~') ADVANCE(64);
      if (lookahead == 0xd7) ADVANCE(523);
      if (lookahead == 0xf7) ADVANCE(504);
      if (lookahead == 0x2016) ADVANCE(481);
      if (lookahead == 0x2025) ADVANCE(464);
      if (lookahead == 0x2026) ADVANCE(466);
      if (lookahead == 0x203c) ADVANCE(509);
      if (lookahead == 0x2047) ADVANCE(514);
      if (lookahead == 0x207a) ADVANCE(531);
      if (lookahead == 0x219d) ADVANCE(374);
      if (lookahead == 0x21a6) ADVANCE(272);
      if (lookahead == 0x21d2) ADVANCE(363);
      if (lookahead == 0x21d4) ADVANCE(371);
      if (lookahead == 0x21dd) ADVANCE(373);
      if (lookahead == 0x21f8) ADVANCE(365);
      if (lookahead == 0x2208) ADVANCE(258);
      if (lookahead == 0x2209) ADVANCE(420);
      if (lookahead == 0x2218) ADVANCE(506);
      if (lookahead == 0x221d) ADVANCE(430);
      if (lookahead == 0x2227) ADVANCE(301);
      if (lookahead == 0x2228) ADVANCE(303);
      if (lookahead == 0x2229) ADVANCE(459);
      if (lookahead == 0x222a) ADVANCE(462);
      if (lookahead == 0x2237) ADVANCE(297);
      if (lookahead == 0x223c) ADVANCE(432);
      if (lookahead == 0x2240) ADVANCE(525);
      if (lookahead == 0x2243) ADVANCE(434);
      if (lookahead == 0x2245) ADVANCE(412);
      if (lookahead == 0x2248) ADVANCE(399);
      if (lookahead == 0x224d) ADVANCE(410);
      if (lookahead == 0x2250) ADVANCE(414);
      if (lookahead == 0x2254) ADVANCE(378);
      if (lookahead == 0x2260) ADVANCE(383);
      if (lookahead == 0x2261) ADVANCE(368);
      if (lookahead == 0x2264) ADVANCE(394);
      if (lookahead == 0x2265) ADVANCE(397);
      if (lookahead == 0x226a) ADVANCE(418);
      if (lookahead == 0x226b) ADVANCE(416);
      if (lookahead == 0x227a) ADVANCE(422);
      if (lookahead == 0x227b) ADVANCE(424);
      if (lookahead == 0x2282) ADVANCE(444);
      if (lookahead == 0x2283) ADVANCE(446);
      if (lookahead == 0x2286) ADVANCE(448);
      if (lookahead == 0x2287) ADVANCE(450);
      if (lookahead == 0x228e) ADVANCE(520);
      if (lookahead == 0x228f) ADVANCE(436);
      if (lookahead == 0x2290) ADVANCE(438);
      if (lookahead == 0x2291) ADVANCE(440);
      if (lookahead == 0x2292) ADVANCE(442);
      if (lookahead == 0x2293) ADVANCE(516);
      if (lookahead == 0x2294) ADVANCE(518);
      if (lookahead == 0x2295) ADVANCE(472);
      if (lookahead == 0x2296) ADVANCE(475);
      if (lookahead == 0x2297) ADVANCE(494);
      if (lookahead == 0x2298) ADVANCE(491);
      if (lookahead == 0x2299) ADVANCE(488);
      if (lookahead == 0x22a2) ADVANCE(402);
      if (lookahead == 0x22a3) ADVANCE(406);
      if (lookahead == 0x22a8) ADVANCE(404);
      if (lookahead == 0x22c5) ADVANCE(527);
      if (lookahead == 0x22c6) ADVANCE(508);
      if (lookahead == 0x25a1) ADVANCE(289);
      if (lookahead == 0x25cf) ADVANCE(502);
      if (lookahead == 0x25ef) ADVANCE(500);
      if (lookahead == 0x27f9) ADVANCE(362);
      if (lookahead == 0x27fa) ADVANCE(370);
      if (lookahead == 0x27fc) ADVANCE(271);
      if (lookahead == 0x2945) ADVANCE(366);
      if (lookahead == 0x2a74) ADVANCE(380);
      if (lookahead == 0x2aaf) ADVANCE(426);
      if (lookahead == 0x2ab0) ADVANCE(428);
      if (lookahead == 0x2ae4) ADVANCE(408);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(18);
      END_STATE();
    case 19:
      if (lookahead == '\r') SKIP(18);
      if (lookahead == '!') ADVANCE(312);
      if (lookahead == '#') ADVANCE(382);
      if (lookahead == '$') ADVANCE(511);
      if (lookahead == '%') ADVANCE(476);
      if (lookahead == '&') ADVANCE(484);
      if (lookahead == '\'') ADVANCE(534);
      if (lookahead == '(') ADVANCE(307);
      if (lookahead == '*') ADVANCE(495);
      if (lookahead == '+') ADVANCE(468);
      if (lookahead == ',') ADVANCE(305);
      if (lookahead == '-') ADVANCE(356);
      if (lookahead == '.') ADVANCE(339);
      if (lookahead == '/') ADVANCE(497);
      if (lookahead == ':') ADVANCE(55);
      if (lookahead == '<') ADVANCE(386);
      if (lookahead == '=') ADVANCE(344);
      if (lookahead == '>') ADVANCE(388);
      if (lookahead == '?') ADVANCE(68);
      if (lookahead == '@') ADVANCE(69);
      if (lookahead == '[') ADVANCE(310);
      if (lookahead == '\\') ADVANCE(456);
      if (lookahead == '^') ADVANCE(528);
      if (lookahead == '|') ADVANCE(478);
      if (lookahead == '~') ADVANCE(64);
      if (lookahead == 0xd7) ADVANCE(523);
      if (lookahead == 0xf7) ADVANCE(504);
      if (lookahead == 0x2016) ADVANCE(481);
      if (lookahead == 0x2025) ADVANCE(464);
      if (lookahead == 0x2026) ADVANCE(466);
      if (lookahead == 0x203c) ADVANCE(509);
      if (lookahead == 0x2047) ADVANCE(514);
      if (lookahead == 0x207a) ADVANCE(531);
      if (lookahead == 0x219d) ADVANCE(374);
      if (lookahead == 0x21a6) ADVANCE(272);
      if (lookahead == 0x21d2) ADVANCE(363);
      if (lookahead == 0x21d4) ADVANCE(371);
      if (lookahead == 0x21dd) ADVANCE(373);
      if (lookahead == 0x21f8) ADVANCE(365);
      if (lookahead == 0x2208) ADVANCE(258);
      if (lookahead == 0x2209) ADVANCE(420);
      if (lookahead == 0x2218) ADVANCE(506);
      if (lookahead == 0x221d) ADVANCE(430);
      if (lookahead == 0x2227) ADVANCE(301);
      if (lookahead == 0x2228) ADVANCE(303);
      if (lookahead == 0x2229) ADVANCE(459);
      if (lookahead == 0x222a) ADVANCE(462);
      if (lookahead == 0x2237) ADVANCE(297);
      if (lookahead == 0x223c) ADVANCE(432);
      if (lookahead == 0x2240) ADVANCE(525);
      if (lookahead == 0x2243) ADVANCE(434);
      if (lookahead == 0x2245) ADVANCE(412);
      if (lookahead == 0x2248) ADVANCE(399);
      if (lookahead == 0x224d) ADVANCE(410);
      if (lookahead == 0x2250) ADVANCE(414);
      if (lookahead == 0x2254) ADVANCE(378);
      if (lookahead == 0x2260) ADVANCE(383);
      if (lookahead == 0x2261) ADVANCE(368);
      if (lookahead == 0x2264) ADVANCE(394);
      if (lookahead == 0x2265) ADVANCE(397);
      if (lookahead == 0x226a) ADVANCE(418);
      if (lookahead == 0x226b) ADVANCE(416);
      if (lookahead == 0x227a) ADVANCE(422);
      if (lookahead == 0x227b) ADVANCE(424);
      if (lookahead == 0x2282) ADVANCE(444);
      if (lookahead == 0x2283) ADVANCE(446);
      if (lookahead == 0x2286) ADVANCE(448);
      if (lookahead == 0x2287) ADVANCE(450);
      if (lookahead == 0x228e) ADVANCE(520);
      if (lookahead == 0x228f) ADVANCE(436);
      if (lookahead == 0x2290) ADVANCE(438);
      if (lookahead == 0x2291) ADVANCE(440);
      if (lookahead == 0x2292) ADVANCE(442);
      if (lookahead == 0x2293) ADVANCE(516);
      if (lookahead == 0x2294) ADVANCE(518);
      if (lookahead == 0x2295) ADVANCE(472);
      if (lookahead == 0x2296) ADVANCE(475);
      if (lookahead == 0x2297) ADVANCE(494);
      if (lookahead == 0x2298) ADVANCE(491);
      if (lookahead == 0x2299) ADVANCE(488);
      if (lookahead == 0x22a2) ADVANCE(402);
      if (lookahead == 0x22a3) ADVANCE(406);
      if (lookahead == 0x22a8) ADVANCE(404);
      if (lookahead == 0x22c5) ADVANCE(527);
      if (lookahead == 0x22c6) ADVANCE(508);
      if (lookahead == 0x25a1) ADVANCE(289);
      if (lookahead == 0x25cf) ADVANCE(502);
      if (lookahead == 0x25ef) ADVANCE(500);
      if (lookahead == 0x27f9) ADVANCE(362);
      if (lookahead == 0x27fa) ADVANCE(370);
      if (lookahead == 0x27fc) ADVANCE(271);
      if (lookahead == 0x2945) ADVANCE(366);
      if (lookahead == 0x2a74) ADVANCE(380);
      if (lookahead == 0x2aaf) ADVANCE(426);
      if (lookahead == 0x2ab0) ADVANCE(428);
      if (lookahead == 0x2ae4) ADVANCE(408);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(18);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(327);
      END_STATE();
    case 20:
      if (lookahead == '\r') SKIP(20);
      if (lookahead == '!') ADVANCE(312);
      if (lookahead == '#') ADVANCE(382);
      if (lookahead == '$') ADVANCE(511);
      if (lookahead == '%') ADVANCE(476);
      if (lookahead == '&') ADVANCE(484);
      if (lookahead == '\'') ADVANCE(534);
      if (lookahead == '(') ADVANCE(307);
      if (lookahead == '*') ADVANCE(495);
      if (lookahead == '+') ADVANCE(468);
      if (lookahead == '-') ADVANCE(353);
      if (lookahead == '.') ADVANCE(339);
      if (lookahead == '/') ADVANCE(497);
      if (lookahead == ':') ADVANCE(55);
      if (lookahead == '<') ADVANCE(387);
      if (lookahead == '=') ADVANCE(341);
      if (lookahead == '>') ADVANCE(388);
      if (lookahead == '?') ADVANCE(68);
      if (lookahead == '@') ADVANCE(69);
      if (lookahead == '[') ADVANCE(310);
      if (lookahead == '\\') ADVANCE(455);
      if (lookahead == '^') ADVANCE(528);
      if (lookahead == '|') ADVANCE(479);
      if (lookahead == '~') ADVANCE(349);
      if (lookahead == 0xac) ADVANCE(350);
      if (lookahead == 0xd7) ADVANCE(523);
      if (lookahead == 0xf7) ADVANCE(504);
      if (lookahead == 0x2016) ADVANCE(481);
      if (lookahead == 0x2025) ADVANCE(464);
      if (lookahead == 0x2026) ADVANCE(466);
      if (lookahead == 0x203c) ADVANCE(509);
      if (lookahead == 0x2047) ADVANCE(514);
      if (lookahead == 0x207a) ADVANCE(531);
      if (lookahead == 0x2115) ADVANCE(333);
      if (lookahead == 0x211d) ADVANCE(335);
      if (lookahead == 0x2124) ADVANCE(334);
      if (lookahead == 0x219d) ADVANCE(374);
      if (lookahead == 0x21d2) ADVANCE(363);
      if (lookahead == 0x21d4) ADVANCE(371);
      if (lookahead == 0x21dd) ADVANCE(373);
      if (lookahead == 0x21f8) ADVANCE(365);
      if (lookahead == 0x2208) ADVANCE(258);
      if (lookahead == 0x2209) ADVANCE(420);
      if (lookahead == 0x2218) ADVANCE(506);
      if (lookahead == 0x221d) ADVANCE(430);
      if (lookahead == 0x2227) ADVANCE(301);
      if (lookahead == 0x2228) ADVANCE(303);
      if (lookahead == 0x2229) ADVANCE(459);
      if (lookahead == 0x222a) ADVANCE(462);
      if (lookahead == 0x2237) ADVANCE(297);
      if (lookahead == 0x223c) ADVANCE(432);
      if (lookahead == 0x2240) ADVANCE(525);
      if (lookahead == 0x2243) ADVANCE(434);
      if (lookahead == 0x2245) ADVANCE(412);
      if (lookahead == 0x2248) ADVANCE(399);
      if (lookahead == 0x224d) ADVANCE(410);
      if (lookahead == 0x2250) ADVANCE(414);
      if (lookahead == 0x2254) ADVANCE(378);
      if (lookahead == 0x225c) ADVANCE(255);
      if (lookahead == 0x2260) ADVANCE(383);
      if (lookahead == 0x2261) ADVANCE(368);
      if (lookahead == 0x2264) ADVANCE(394);
      if (lookahead == 0x2265) ADVANCE(397);
      if (lookahead == 0x226a) ADVANCE(418);
      if (lookahead == 0x226b) ADVANCE(416);
      if (lookahead == 0x227a) ADVANCE(422);
      if (lookahead == 0x227b) ADVANCE(424);
      if (lookahead == 0x2282) ADVANCE(444);
      if (lookahead == 0x2283) ADVANCE(446);
      if (lookahead == 0x2286) ADVANCE(448);
      if (lookahead == 0x2287) ADVANCE(450);
      if (lookahead == 0x228e) ADVANCE(520);
      if (lookahead == 0x228f) ADVANCE(436);
      if (lookahead == 0x2290) ADVANCE(438);
      if (lookahead == 0x2291) ADVANCE(440);
      if (lookahead == 0x2292) ADVANCE(442);
      if (lookahead == 0x2293) ADVANCE(516);
      if (lookahead == 0x2294) ADVANCE(518);
      if (lookahead == 0x2295) ADVANCE(472);
      if (lookahead == 0x2296) ADVANCE(475);
      if (lookahead == 0x2297) ADVANCE(494);
      if (lookahead == 0x2298) ADVANCE(491);
      if (lookahead == 0x2299) ADVANCE(488);
      if (lookahead == 0x22a2) ADVANCE(402);
      if (lookahead == 0x22a3) ADVANCE(406);
      if (lookahead == 0x22a8) ADVANCE(404);
      if (lookahead == 0x22c4) ADVANCE(359);
      if (lookahead == 0x22c5) ADVANCE(527);
      if (lookahead == 0x22c6) ADVANCE(508);
      if (lookahead == 0x25a1) ADVANCE(289);
      if (lookahead == 0x25c7) ADVANCE(360);
      if (lookahead == 0x25cf) ADVANCE(502);
      if (lookahead == 0x25ef) ADVANCE(500);
      if (lookahead == 0x27f9) ADVANCE(362);
      if (lookahead == 0x27fa) ADVANCE(370);
      if (lookahead == 0x2945) ADVANCE(366);
      if (lookahead == 0x2a74) ADVANCE(380);
      if (lookahead == 0x2aaf) ADVANCE(426);
      if (lookahead == 0x2ab0) ADVANCE(428);
      if (lookahead == 0x2ae4) ADVANCE(408);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(20);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(224);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 21:
      if (lookahead == '\r') SKIP(21);
      if (lookahead == '!') ADVANCE(312);
      if (lookahead == '#') ADVANCE(382);
      if (lookahead == '$') ADVANCE(511);
      if (lookahead == '%') ADVANCE(476);
      if (lookahead == '&') ADVANCE(484);
      if (lookahead == '\'') ADVANCE(534);
      if (lookahead == '(') ADVANCE(307);
      if (lookahead == ')') ADVANCE(308);
      if (lookahead == '*') ADVANCE(495);
      if (lookahead == '+') ADVANCE(468);
      if (lookahead == ',') ADVANCE(305);
      if (lookahead == '-') ADVANCE(356);
      if (lookahead == '.') ADVANCE(339);
      if (lookahead == '/') ADVANCE(497);
      if (lookahead == ':') ADVANCE(291);
      if (lookahead == ';') ADVANCE(546);
      if (lookahead == '<') ADVANCE(386);
      if (lookahead == '=') ADVANCE(344);
      if (lookahead == '>') ADVANCE(388);
      if (lookahead == '?') ADVANCE(68);
      if (lookahead == '@') ADVANCE(69);
      if (lookahead == '[') ADVANCE(310);
      if (lookahead == '\\') ADVANCE(456);
      if (lookahead == ']') ADVANCE(311);
      if (lookahead == '^') ADVANCE(528);
      if (lookahead == '{') ADVANCE(336);
      if (lookahead == '|') ADVANCE(479);
      if (lookahead == '}') ADVANCE(337);
      if (lookahead == '~') ADVANCE(64);
      if (lookahead == 0xd7) ADVANCE(523);
      if (lookahead == 0xf7) ADVANCE(504);
      if (lookahead == 0x2016) ADVANCE(481);
      if (lookahead == 0x2025) ADVANCE(464);
      if (lookahead == 0x2026) ADVANCE(466);
      if (lookahead == 0x203c) ADVANCE(509);
      if (lookahead == 0x2047) ADVANCE(514);
      if (lookahead == 0x207a) ADVANCE(531);
      if (lookahead == 0x219d) ADVANCE(374);
      if (lookahead == 0x21d2) ADVANCE(363);
      if (lookahead == 0x21d4) ADVANCE(371);
      if (lookahead == 0x21dd) ADVANCE(373);
      if (lookahead == 0x21f8) ADVANCE(365);
      if (lookahead == 0x2208) ADVANCE(258);
      if (lookahead == 0x2209) ADVANCE(420);
      if (lookahead == 0x2218) ADVANCE(506);
      if (lookahead == 0x221d) ADVANCE(430);
      if (lookahead == 0x2227) ADVANCE(301);
      if (lookahead == 0x2228) ADVANCE(303);
      if (lookahead == 0x2229) ADVANCE(459);
      if (lookahead == 0x222a) ADVANCE(462);
      if (lookahead == 0x2237) ADVANCE(297);
      if (lookahead == 0x223c) ADVANCE(432);
      if (lookahead == 0x2240) ADVANCE(525);
      if (lookahead == 0x2243) ADVANCE(434);
      if (lookahead == 0x2245) ADVANCE(412);
      if (lookahead == 0x2248) ADVANCE(399);
      if (lookahead == 0x224d) ADVANCE(410);
      if (lookahead == 0x2250) ADVANCE(414);
      if (lookahead == 0x2254) ADVANCE(378);
      if (lookahead == 0x2260) ADVANCE(383);
      if (lookahead == 0x2261) ADVANCE(368);
      if (lookahead == 0x2264) ADVANCE(394);
      if (lookahead == 0x2265) ADVANCE(397);
      if (lookahead == 0x226a) ADVANCE(418);
      if (lookahead == 0x226b) ADVANCE(416);
      if (lookahead == 0x227a) ADVANCE(422);
      if (lookahead == 0x227b) ADVANCE(424);
      if (lookahead == 0x2282) ADVANCE(444);
      if (lookahead == 0x2283) ADVANCE(446);
      if (lookahead == 0x2286) ADVANCE(448);
      if (lookahead == 0x2287) ADVANCE(450);
      if (lookahead == 0x228e) ADVANCE(520);
      if (lookahead == 0x228f) ADVANCE(436);
      if (lookahead == 0x2290) ADVANCE(438);
      if (lookahead == 0x2291) ADVANCE(440);
      if (lookahead == 0x2292) ADVANCE(442);
      if (lookahead == 0x2293) ADVANCE(516);
      if (lookahead == 0x2294) ADVANCE(518);
      if (lookahead == 0x2295) ADVANCE(472);
      if (lookahead == 0x2296) ADVANCE(475);
      if (lookahead == 0x2297) ADVANCE(494);
      if (lookahead == 0x2298) ADVANCE(491);
      if (lookahead == 0x2299) ADVANCE(488);
      if (lookahead == 0x22a2) ADVANCE(402);
      if (lookahead == 0x22a3) ADVANCE(406);
      if (lookahead == 0x22a8) ADVANCE(404);
      if (lookahead == 0x22c5) ADVANCE(527);
      if (lookahead == 0x22c6) ADVANCE(508);
      if (lookahead == 0x25a1) ADVANCE(289);
      if (lookahead == 0x25cf) ADVANCE(502);
      if (lookahead == 0x25ef) ADVANCE(500);
      if (lookahead == 0x27f9) ADVANCE(362);
      if (lookahead == 0x27fa) ADVANCE(370);
      if (lookahead == 0x2945) ADVANCE(366);
      if (lookahead == 0x2a74) ADVANCE(380);
      if (lookahead == 0x2aaf) ADVANCE(426);
      if (lookahead == 0x2ab0) ADVANCE(428);
      if (lookahead == 0x2ae4) ADVANCE(408);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(21);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(224);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 22:
      if (lookahead == '\r') SKIP(22);
      if (lookahead == '!') ADVANCE(312);
      if (lookahead == '#') ADVANCE(382);
      if (lookahead == '$') ADVANCE(511);
      if (lookahead == '%') ADVANCE(476);
      if (lookahead == '&') ADVANCE(484);
      if (lookahead == '\'') ADVANCE(534);
      if (lookahead == '(') ADVANCE(307);
      if (lookahead == '*') ADVANCE(495);
      if (lookahead == '+') ADVANCE(468);
      if (lookahead == ',') ADVANCE(305);
      if (lookahead == '-') ADVANCE(355);
      if (lookahead == '.') ADVANCE(339);
      if (lookahead == '/') ADVANCE(497);
      if (lookahead == ':') ADVANCE(291);
      if (lookahead == '<') ADVANCE(386);
      if (lookahead == '=') ADVANCE(344);
      if (lookahead == '>') ADVANCE(388);
      if (lookahead == '?') ADVANCE(68);
      if (lookahead == '@') ADVANCE(69);
      if (lookahead == '[') ADVANCE(309);
      if (lookahead == '\\') ADVANCE(456);
      if (lookahead == ']') ADVANCE(72);
      if (lookahead == '^') ADVANCE(528);
      if (lookahead == '|') ADVANCE(478);
      if (lookahead == '~') ADVANCE(64);
      if (lookahead == 0xd7) ADVANCE(523);
      if (lookahead == 0xf7) ADVANCE(504);
      if (lookahead == 0x2016) ADVANCE(481);
      if (lookahead == 0x2025) ADVANCE(464);
      if (lookahead == 0x2026) ADVANCE(466);
      if (lookahead == 0x203c) ADVANCE(509);
      if (lookahead == 0x2047) ADVANCE(514);
      if (lookahead == 0x207a) ADVANCE(531);
      if (lookahead == 0x2192) ADVANCE(275);
      if (lookahead == 0x219d) ADVANCE(374);
      if (lookahead == 0x21a6) ADVANCE(272);
      if (lookahead == 0x21d2) ADVANCE(363);
      if (lookahead == 0x21d4) ADVANCE(371);
      if (lookahead == 0x21dd) ADVANCE(373);
      if (lookahead == 0x21f8) ADVANCE(365);
      if (lookahead == 0x2208) ADVANCE(258);
      if (lookahead == 0x2209) ADVANCE(420);
      if (lookahead == 0x2218) ADVANCE(506);
      if (lookahead == 0x221d) ADVANCE(430);
      if (lookahead == 0x2227) ADVANCE(301);
      if (lookahead == 0x2228) ADVANCE(303);
      if (lookahead == 0x2229) ADVANCE(459);
      if (lookahead == 0x222a) ADVANCE(462);
      if (lookahead == 0x2237) ADVANCE(297);
      if (lookahead == 0x223c) ADVANCE(432);
      if (lookahead == 0x2240) ADVANCE(525);
      if (lookahead == 0x2243) ADVANCE(434);
      if (lookahead == 0x2245) ADVANCE(412);
      if (lookahead == 0x2248) ADVANCE(399);
      if (lookahead == 0x224d) ADVANCE(410);
      if (lookahead == 0x2250) ADVANCE(414);
      if (lookahead == 0x2254) ADVANCE(378);
      if (lookahead == 0x2260) ADVANCE(383);
      if (lookahead == 0x2261) ADVANCE(368);
      if (lookahead == 0x2264) ADVANCE(394);
      if (lookahead == 0x2265) ADVANCE(397);
      if (lookahead == 0x226a) ADVANCE(418);
      if (lookahead == 0x226b) ADVANCE(416);
      if (lookahead == 0x227a) ADVANCE(422);
      if (lookahead == 0x227b) ADVANCE(424);
      if (lookahead == 0x2282) ADVANCE(444);
      if (lookahead == 0x2283) ADVANCE(446);
      if (lookahead == 0x2286) ADVANCE(448);
      if (lookahead == 0x2287) ADVANCE(450);
      if (lookahead == 0x228e) ADVANCE(520);
      if (lookahead == 0x228f) ADVANCE(436);
      if (lookahead == 0x2290) ADVANCE(438);
      if (lookahead == 0x2291) ADVANCE(440);
      if (lookahead == 0x2292) ADVANCE(442);
      if (lookahead == 0x2293) ADVANCE(516);
      if (lookahead == 0x2294) ADVANCE(518);
      if (lookahead == 0x2295) ADVANCE(472);
      if (lookahead == 0x2296) ADVANCE(475);
      if (lookahead == 0x2297) ADVANCE(494);
      if (lookahead == 0x2298) ADVANCE(491);
      if (lookahead == 0x2299) ADVANCE(488);
      if (lookahead == 0x22a2) ADVANCE(402);
      if (lookahead == 0x22a3) ADVANCE(406);
      if (lookahead == 0x22a8) ADVANCE(404);
      if (lookahead == 0x22c5) ADVANCE(527);
      if (lookahead == 0x22c6) ADVANCE(508);
      if (lookahead == 0x25cf) ADVANCE(502);
      if (lookahead == 0x25ef) ADVANCE(500);
      if (lookahead == 0x27f6) ADVANCE(274);
      if (lookahead == 0x27f9) ADVANCE(362);
      if (lookahead == 0x27fa) ADVANCE(370);
      if (lookahead == 0x27fc) ADVANCE(271);
      if (lookahead == 0x2945) ADVANCE(366);
      if (lookahead == 0x2a74) ADVANCE(380);
      if (lookahead == 0x2aaf) ADVANCE(426);
      if (lookahead == 0x2ab0) ADVANCE(428);
      if (lookahead == 0x2ae4) ADVANCE(408);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(22);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(224);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 23:
      if (lookahead == '\r') SKIP(24);
      if (lookahead == '!') ADVANCE(312);
      if (lookahead == '(') ADVANCE(306);
      if (lookahead == '*') ADVANCE(543);
      if (lookahead == ',') ADVANCE(305);
      if (lookahead == '-') ADVANCE(51);
      if (lookahead == ':') ADVANCE(56);
      if (lookahead == '<') ADVANCE(63);
      if (lookahead == '=') ADVANCE(62);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') ADVANCE(42);
      if (lookahead == '_') ADVANCE(224);
      if (lookahead == '~') ADVANCE(348);
      if (lookahead == 0xac) ADVANCE(350);
      if (lookahead == 0x2115) ADVANCE(333);
      if (lookahead == 0x211d) ADVANCE(335);
      if (lookahead == 0x2124) ADVANCE(334);
      if (lookahead == 0x2237) ADVANCE(297);
      if (lookahead == 0x22c4) ADVANCE(359);
      if (lookahead == 0x25a1) ADVANCE(289);
      if (lookahead == 0x25c7) ADVANCE(360);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(24);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(544);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 24:
      if (lookahead == '\r') SKIP(24);
      if (lookahead == '!') ADVANCE(312);
      if (lookahead == '(') ADVANCE(306);
      if (lookahead == ',') ADVANCE(305);
      if (lookahead == '-') ADVANCE(51);
      if (lookahead == ':') ADVANCE(56);
      if (lookahead == '<') ADVANCE(63);
      if (lookahead == '=') ADVANCE(62);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') ADVANCE(42);
      if (lookahead == '~') ADVANCE(348);
      if (lookahead == 0xac) ADVANCE(350);
      if (lookahead == 0x2115) ADVANCE(333);
      if (lookahead == 0x211d) ADVANCE(335);
      if (lookahead == 0x2124) ADVANCE(334);
      if (lookahead == 0x2237) ADVANCE(297);
      if (lookahead == 0x22c4) ADVANCE(359);
      if (lookahead == 0x25a1) ADVANCE(289);
      if (lookahead == 0x25c7) ADVANCE(360);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(24);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(224);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 25:
      if (lookahead == '\r') SKIP(25);
      if (lookahead == '(') ADVANCE(38);
      if (lookahead == ')') ADVANCE(308);
      if (lookahead == '+') ADVANCE(467);
      if (lookahead == ',') ADVANCE(305);
      if (lookahead == '-') ADVANCE(351);
      if (lookahead == '.') ADVANCE(338);
      if (lookahead == ';') ADVANCE(546);
      if (lookahead == '<') ADVANCE(384);
      if (lookahead == '=') ADVANCE(340);
      if (lookahead == '[') ADVANCE(309);
      if (lookahead == '\\') ADVANCE(40);
      if (lookahead == '{') ADVANCE(336);
      if (lookahead == 0x2208) ADVANCE(258);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(25);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(224);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 26:
      if (lookahead == '\r') ADVANCE(238);
      if (lookahead == '(') ADVANCE(244);
      if (lookahead == ')') ADVANCE(246);
      if (lookahead == '*') ADVANCE(242);
      if (lookahead == '-') ADVANCE(240);
      if (lookahead == ';') ADVANCE(239);
      if (lookahead == '\\') ADVANCE(239);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(238);
      if (lookahead != 0) ADVANCE(239);
      END_STATE();
    case 27:
      if (lookahead == '\r') SKIP(27);
      if (lookahead == '!') ADVANCE(312);
      if (lookahead == '(') ADVANCE(306);
      if (lookahead == ')') ADVANCE(308);
      if (lookahead == ',') ADVANCE(305);
      if (lookahead == '\\') ADVANCE(39);
      if (lookahead == '_') ADVANCE(298);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(27);
      END_STATE();
    case 28:
      if (lookahead == '\r') SKIP(27);
      if (lookahead == '!') ADVANCE(312);
      if (lookahead == '(') ADVANCE(306);
      if (lookahead == ')') ADVANCE(308);
      if (lookahead == ',') ADVANCE(305);
      if (lookahead == '\\') ADVANCE(39);
      if (lookahead == '_') ADVANCE(298);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(27);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(324);
      END_STATE();
    case 29:
      if (lookahead == '\r') SKIP(30);
      if (lookahead == '(') ADVANCE(38);
      if (lookahead == '\\') ADVANCE(39);
      if (lookahead == '*' ||
          lookahead == '+') ADVANCE(535);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(30);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(537);
      END_STATE();
    case 30:
      if (lookahead == '\r') SKIP(30);
      if (lookahead == '(') ADVANCE(38);
      if (lookahead == '\\') ADVANCE(39);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(30);
      END_STATE();
    case 31:
      if (lookahead == '\r') SKIP(30);
      if (lookahead == '(') ADVANCE(38);
      if (lookahead == '\\') ADVANCE(39);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(30);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == '|') ADVANCE(545);
      END_STATE();
    case 32:
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(32);
      END_STATE();
    case 33:
      if (lookahead == ')') ADVANCE(471);
      END_STATE();
    case 34:
      if (lookahead == ')') ADVANCE(474);
      END_STATE();
    case 35:
      if (lookahead == ')') ADVANCE(487);
      END_STATE();
    case 36:
      if (lookahead == ')') ADVANCE(490);
      END_STATE();
    case 37:
      if (lookahead == ')') ADVANCE(493);
      END_STATE();
    case 38:
      if (lookahead == '*') ADVANCE(235);
      END_STATE();
    case 39:
      if (lookahead == '*') ADVANCE(234);
      END_STATE();
    case 40:
      if (lookahead == '*') ADVANCE(234);
      if (lookahead == 'i') ADVANCE(142);
      END_STATE();
    case 41:
      if (lookahead == '*') ADVANCE(234);
      if (lookahead == 'i') ADVANCE(142);
      if (lookahead == 'l') ADVANCE(145);
      if (lookahead == 'n') ADVANCE(93);
      END_STATE();
    case 42:
      if (lookahead == '*') ADVANCE(234);
      if (lookahead == 'l') ADVANCE(145);
      if (lookahead == 'n') ADVANCE(93);
      END_STATE();
    case 43:
      if (lookahead == '*') ADVANCE(237);
      END_STATE();
    case 44:
      if (lookahead == '-') ADVANCE(66);
      END_STATE();
    case 45:
      if (lookahead == '-') ADVANCE(247);
      END_STATE();
    case 46:
      if (lookahead == '-') ADVANCE(50);
      if (lookahead == '.') ADVANCE(357);
      END_STATE();
    case 47:
      if (lookahead == '-') ADVANCE(259);
      if (lookahead == '<') ADVANCE(276);
      if (lookahead == '>') ADVANCE(358);
      END_STATE();
    case 48:
      if (lookahead == '-') ADVANCE(259);
      if (lookahead == '>') ADVANCE(358);
      END_STATE();
    case 49:
      if (lookahead == '-') ADVANCE(45);
      END_STATE();
    case 50:
      if (lookahead == '-') ADVANCE(45);
      if (lookahead == 'a') ADVANCE(128);
      if (lookahead == 'f') ADVANCE(81);
      END_STATE();
    case 51:
      if (lookahead == '-') ADVANCE(49);
      if (lookahead == '.') ADVANCE(357);
      END_STATE();
    case 52:
      if (lookahead == '-') ADVANCE(65);
      if (lookahead == '|') ADVANCE(480);
      END_STATE();
    case 53:
      if (lookahead == '.') ADVANCE(463);
      END_STATE();
    case 54:
      if (lookahead == '.') ADVANCE(463);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(315);
      END_STATE();
    case 55:
      if (lookahead == ':') ADVANCE(296);
      if (lookahead == '=') ADVANCE(377);
      if (lookahead == '>') ADVANCE(452);
      END_STATE();
    case 56:
      if (lookahead == ':') ADVANCE(295);
      END_STATE();
    case 57:
      if (lookahead == ':') ADVANCE(58);
      if (lookahead == '=') ADVANCE(377);
      if (lookahead == '>') ADVANCE(452);
      END_STATE();
    case 58:
      if (lookahead == '=') ADVANCE(379);
      END_STATE();
    case 59:
      if (lookahead == '=') ADVANCE(60);
      END_STATE();
    case 60:
      if (lookahead == '=') ADVANCE(250);
      END_STATE();
    case 61:
      if (lookahead == '=') ADVANCE(253);
      END_STATE();
    case 62:
      if (lookahead == '=') ADVANCE(59);
      END_STATE();
    case 63:
      if (lookahead == '>') ADVANCE(358);
      END_STATE();
    case 64:
      if (lookahead == '>') ADVANCE(372);
      END_STATE();
    case 65:
      if (lookahead == '>') ADVANCE(270);
      END_STATE();
    case 66:
      if (lookahead == '>') ADVANCE(364);
      END_STATE();
    case 67:
      if (lookahead == '>') ADVANCE(279);
      END_STATE();
    case 68:
      if (lookahead == '?') ADVANCE(513);
      END_STATE();
    case 69:
      if (lookahead == '@') ADVANCE(451);
      END_STATE();
    case 70:
      if (lookahead == 'X') ADVANCE(37);
      END_STATE();
    case 71:
      if (lookahead == ']') ADVANCE(288);
      END_STATE();
    case 72:
      if (lookahead == '_') ADVANCE(345);
      END_STATE();
    case 73:
      if (lookahead == 'a') ADVANCE(157);
      if (lookahead == 'd') ADVANCE(150);
      if (lookahead == 'i') ADVANCE(182);
      if (lookahead == 'o') ADVANCE(143);
      if (lookahead == 'u') ADVANCE(158);
      END_STATE();
    case 74:
      if (lookahead == 'a') ADVANCE(139);
      if (lookahead == 'e') ADVANCE(167);
      if (lookahead == 'l') ADVANCE(417);
      if (lookahead == 'n') ADVANCE(152);
      if (lookahead == 'o') ADVANCE(177);
      END_STATE();
    case 75:
      if (lookahead == 'a') ADVANCE(139);
      if (lookahead == 'e') ADVANCE(167);
      if (lookahead == 'l') ADVANCE(417);
      if (lookahead == 'o') ADVANCE(177);
      END_STATE();
    case 76:
      if (lookahead == 'a') ADVANCE(188);
      END_STATE();
    case 77:
      if (lookahead == 'a') ADVANCE(160);
      if (lookahead == 'u') ADVANCE(161);
      END_STATE();
    case 78:
      if (lookahead == 'a') ADVANCE(128);
      if (lookahead == 'f') ADVANCE(81);
      END_STATE();
    case 79:
      if (lookahead == 'a') ADVANCE(178);
      END_STATE();
    case 80:
      if (lookahead == 'a') ADVANCE(131);
      END_STATE();
    case 81:
      if (lookahead == 'a') ADVANCE(122);
      END_STATE();
    case 82:
      if (lookahead == 'b') ADVANCE(196);
      if (lookahead == 'c') ADVANCE(87);
      if (lookahead == 'p') ADVANCE(197);
      END_STATE();
    case 83:
      if (lookahead == 'b') ADVANCE(198);
      if (lookahead == 'p') ADVANCE(199);
      END_STATE();
    case 84:
      if (lookahead == 'c') ADVANCE(77);
      if (lookahead == 's') ADVANCE(214);
      END_STATE();
    case 85:
      if (lookahead == 'c') ADVANCE(505);
      END_STATE();
    case 86:
      if (lookahead == 'c') ADVANCE(421);
      END_STATE();
    case 87:
      if (lookahead == 'c') ADVANCE(423);
      END_STATE();
    case 88:
      if (lookahead == 'c') ADVANCE(499);
      END_STATE();
    case 89:
      if (lookahead == 'c') ADVANCE(121);
      END_STATE();
    case 90:
      if (lookahead == 'c') ADVANCE(209);
      END_STATE();
    case 91:
      if (lookahead == 'd') ADVANCE(375);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(166);
      if (lookahead == 'g') ADVANCE(415);
      END_STATE();
    case 93:
      if (lookahead == 'e') ADVANCE(107);
      END_STATE();
    case 94:
      if (lookahead == 'e') ADVANCE(107);
      if (lookahead == 'o') ADVANCE(213);
      END_STATE();
    case 95:
      if (lookahead == 'e') ADVANCE(168);
      END_STATE();
    case 96:
      if (lookahead == 'e') ADVANCE(86);
      if (lookahead == 'o') ADVANCE(163);
      END_STATE();
    case 97:
      if (lookahead == 'e') ADVANCE(189);
      END_STATE();
    case 98:
      if (lookahead == 'e') ADVANCE(90);
      END_STATE();
    case 99:
      if (lookahead == 'e') ADVANCE(186);
      END_STATE();
    case 100:
      if (lookahead == 'e') ADVANCE(204);
      END_STATE();
    case 101:
      if (lookahead == 'e') ADVANCE(205);
      END_STATE();
    case 102:
      if (lookahead == 'e') ADVANCE(193);
      END_STATE();
    case 103:
      if (lookahead == 'e') ADVANCE(206);
      END_STATE();
    case 104:
      if (lookahead == 'e') ADVANCE(207);
      END_STATE();
    case 105:
      if (lookahead == 'e') ADVANCE(208);
      END_STATE();
    case 106:
      if (lookahead == 'g') ADVANCE(89);
      END_STATE();
    case 107:
      if (lookahead == 'g') ADVANCE(347);
      END_STATE();
    case 108:
      if (lookahead == 'g') ADVANCE(411);
      END_STATE();
    case 109:
      if (lookahead == 'g') ADVANCE(155);
      END_STATE();
    case 110:
      if (lookahead == 'h') ADVANCE(489);
      END_STATE();
    case 111:
      if (lookahead == 'h') ADVANCE(134);
      END_STATE();
    case 112:
      if (lookahead == 'i') ADVANCE(106);
      if (lookahead == 'u') ADVANCE(129);
      END_STATE();
    case 113:
      if (lookahead == 'i') ADVANCE(219);
      if (lookahead == 'o') ADVANCE(200);
      END_STATE();
    case 114:
      if (lookahead == 'i') ADVANCE(133);
      if (lookahead == 'q') ADVANCE(84);
      if (lookahead == 't') ADVANCE(79);
      if (lookahead == 'u') ADVANCE(82);
      END_STATE();
    case 115:
      if (lookahead == 'i') ADVANCE(195);
      END_STATE();
    case 116:
      if (lookahead == 'i') ADVANCE(220);
      END_STATE();
    case 117:
      if (lookahead == 'i') ADVANCE(135);
      END_STATE();
    case 118:
      if (lookahead == 'i') ADVANCE(154);
      END_STATE();
    case 119:
      if (lookahead == 'i') ADVANCE(146);
      END_STATE();
    case 120:
      if (lookahead == 'i') ADVANCE(140);
      END_STATE();
    case 121:
      if (lookahead == 'i') ADVANCE(184);
      END_STATE();
    case 122:
      if (lookahead == 'i') ADVANCE(179);
      END_STATE();
    case 123:
      if (lookahead == 'i') ADVANCE(210);
      END_STATE();
    case 124:
      if (lookahead == 'i') ADVANCE(137);
      END_STATE();
    case 125:
      if (lookahead == 'l') ADVANCE(263);
      END_STATE();
    case 126:
      if (lookahead == 'l') ADVANCE(215);
      END_STATE();
    case 127:
      if (lookahead == 'l') ADVANCE(76);
      END_STATE();
    case 128:
      if (lookahead == 'l') ADVANCE(109);
      END_STATE();
    case 129:
      if (lookahead == 'l') ADVANCE(130);
      END_STATE();
    case 130:
      if (lookahead == 'l') ADVANCE(100);
      END_STATE();
    case 131:
      if (lookahead == 'l') ADVANCE(125);
      END_STATE();
    case 132:
      if (lookahead == 'l') ADVANCE(217);
      END_STATE();
    case 133:
      if (lookahead == 'm') ADVANCE(431);
      END_STATE();
    case 134:
      if (lookahead == 'm') ADVANCE(547);
      END_STATE();
    case 135:
      if (lookahead == 'm') ADVANCE(97);
      END_STATE();
    case 136:
      if (lookahead == 'm') ADVANCE(159);
      END_STATE();
    case 137:
      if (lookahead == 'm') ADVANCE(102);
      END_STATE();
    case 138:
      if (lookahead == 'n') ADVANCE(257);
      END_STATE();
    case 139:
      if (lookahead == 'n') ADVANCE(91);
      END_STATE();
    case 140:
      if (lookahead == 'n') ADVANCE(419);
      END_STATE();
    case 141:
      if (lookahead == 'n') ADVANCE(461);
      END_STATE();
    case 142:
      if (lookahead == 'n') ADVANCE(256);
      END_STATE();
    case 143:
      if (lookahead == 'n') ADVANCE(108);
      END_STATE();
    case 144:
      if (lookahead == 'n') ADVANCE(118);
      if (lookahead == 'p') ADVANCE(132);
      END_STATE();
    case 145:
      if (lookahead == 'n') ADVANCE(152);
      END_STATE();
    case 146:
      if (lookahead == 'n') ADVANCE(218);
      END_STATE();
    case 147:
      if (lookahead == 'o') ADVANCE(221);
      END_STATE();
    case 148:
      if (lookahead == 'o') ADVANCE(429);
      END_STATE();
    case 149:
      if (lookahead == 'o') ADVANCE(213);
      END_STATE();
    case 150:
      if (lookahead == 'o') ADVANCE(201);
      END_STATE();
    case 151:
      if (lookahead == 'o') ADVANCE(181);
      END_STATE();
    case 152:
      if (lookahead == 'o') ADVANCE(202);
      END_STATE();
    case 153:
      if (lookahead == 'o') ADVANCE(203);
      END_STATE();
    case 154:
      if (lookahead == 'o') ADVANCE(141);
      END_STATE();
    case 155:
      if (lookahead == 'o') ADVANCE(185);
      END_STATE();
    case 156:
      if (lookahead == 'p') ADVANCE(162);
      if (lookahead == 's') ADVANCE(222);
      END_STATE();
    case 157:
      if (lookahead == 'p') ADVANCE(457);
      END_STATE();
    case 158:
      if (lookahead == 'p') ADVANCE(460);
      END_STATE();
    case 159:
      if (lookahead == 'p') ADVANCE(409);
      END_STATE();
    case 160:
      if (lookahead == 'p') ADVANCE(515);
      END_STATE();
    case 161:
      if (lookahead == 'p') ADVANCE(517);
      END_STATE();
    case 162:
      if (lookahead == 'p') ADVANCE(183);
      END_STATE();
    case 163:
      if (lookahead == 'p') ADVANCE(211);
      END_STATE();
    case 164:
      if (lookahead == 'q') ADVANCE(216);
      END_STATE();
    case 165:
      if (lookahead == 'q') ADVANCE(216);
      if (lookahead == 'x') ADVANCE(115);
      END_STATE();
    case 166:
      if (lookahead == 'q') ADVANCE(396);
      END_STATE();
    case 167:
      if (lookahead == 'q') ADVANCE(393);
      END_STATE();
    case 168:
      if (lookahead == 'q') ADVANCE(413);
      END_STATE();
    case 169:
      if (lookahead == 'q') ADVANCE(433);
      END_STATE();
    case 170:
      if (lookahead == 'q') ADVANCE(425);
      END_STATE();
    case 171:
      if (lookahead == 'q') ADVANCE(427);
      END_STATE();
    case 172:
      if (lookahead == 'q') ADVANCE(447);
      END_STATE();
    case 173:
      if (lookahead == 'q') ADVANCE(449);
      END_STATE();
    case 174:
      if (lookahead == 'q') ADVANCE(439);
      END_STATE();
    case 175:
      if (lookahead == 'q') ADVANCE(441);
      END_STATE();
    case 176:
      if (lookahead == 'r') ADVANCE(524);
      END_STATE();
    case 177:
      if (lookahead == 'r') ADVANCE(376);
      END_STATE();
    case 178:
      if (lookahead == 'r') ADVANCE(507);
      END_STATE();
    case 179:
      if (lookahead == 'r') ADVANCE(548);
      END_STATE();
    case 180:
      if (lookahead == 'r') ADVANCE(96);
      END_STATE();
    case 181:
      if (lookahead == 'r') ADVANCE(80);
      END_STATE();
    case 182:
      if (lookahead == 'r') ADVANCE(85);
      END_STATE();
    case 183:
      if (lookahead == 'r') ADVANCE(147);
      END_STATE();
    case 184:
      if (lookahead == 'r') ADVANCE(88);
      END_STATE();
    case 185:
      if (lookahead == 'r') ADVANCE(123);
      END_STATE();
    case 186:
      if (lookahead == 'r') ADVANCE(194);
      END_STATE();
    case 187:
      if (lookahead == 's') ADVANCE(470);
      END_STATE();
    case 188:
      if (lookahead == 's') ADVANCE(110);
      END_STATE();
    case 189:
      if (lookahead == 's') ADVANCE(522);
      END_STATE();
    case 190:
      if (lookahead == 's') ADVANCE(519);
      END_STATE();
    case 191:
      if (lookahead == 's') ADVANCE(266);
      END_STATE();
    case 192:
      if (lookahead == 's') ADVANCE(473);
      END_STATE();
    case 193:
      if (lookahead == 's') ADVANCE(492);
      END_STATE();
    case 194:
      if (lookahead == 's') ADVANCE(98);
      END_STATE();
    case 195:
      if (lookahead == 's') ADVANCE(212);
      END_STATE();
    case 196:
      if (lookahead == 's') ADVANCE(101);
      END_STATE();
    case 197:
      if (lookahead == 's') ADVANCE(103);
      END_STATE();
    case 198:
      if (lookahead == 's') ADVANCE(104);
      END_STATE();
    case 199:
      if (lookahead == 's') ADVANCE(105);
      END_STATE();
    case 200:
      if (lookahead == 't') ADVANCE(95);
      END_STATE();
    case 201:
      if (lookahead == 't') ADVANCE(526);
      END_STATE();
    case 202:
      if (lookahead == 't') ADVANCE(346);
      END_STATE();
    case 203:
      if (lookahead == 't') ADVANCE(486);
      END_STATE();
    case 204:
      if (lookahead == 't') ADVANCE(501);
      END_STATE();
    case 205:
      if (lookahead == 't') ADVANCE(443);
      END_STATE();
    case 206:
      if (lookahead == 't') ADVANCE(445);
      END_STATE();
    case 207:
      if (lookahead == 't') ADVANCE(435);
      END_STATE();
    case 208:
      if (lookahead == 't') ADVANCE(437);
      END_STATE();
    case 209:
      if (lookahead == 't') ADVANCE(458);
      END_STATE();
    case 210:
      if (lookahead == 't') ADVANCE(111);
      END_STATE();
    case 211:
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 212:
      if (lookahead == 't') ADVANCE(191);
      END_STATE();
    case 213:
      if (lookahead == 't') ADVANCE(120);
      END_STATE();
    case 214:
      if (lookahead == 'u') ADVANCE(83);
      END_STATE();
    case 215:
      if (lookahead == 'u') ADVANCE(187);
      END_STATE();
    case 216:
      if (lookahead == 'u') ADVANCE(116);
      END_STATE();
    case 217:
      if (lookahead == 'u') ADVANCE(190);
      END_STATE();
    case 218:
      if (lookahead == 'u') ADVANCE(192);
      END_STATE();
    case 219:
      if (lookahead == 'v') ADVANCE(503);
      END_STATE();
    case 220:
      if (lookahead == 'v') ADVANCE(367);
      END_STATE();
    case 221:
      if (lookahead == 'x') ADVANCE(398);
      END_STATE();
    case 222:
      if (lookahead == 'y') ADVANCE(136);
      END_STATE();
    case 223:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(315);
      END_STATE();
    case 224:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(224);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 225:
      if (eof) ADVANCE(233);
      if (lookahead == '\r') SKIP(225);
      if (lookahead == '!') ADVANCE(312);
      if (lookahead == '"') ADVANCE(328);
      if (lookahead == '#') ADVANCE(382);
      if (lookahead == '$') ADVANCE(511);
      if (lookahead == '%') ADVANCE(476);
      if (lookahead == '&') ADVANCE(484);
      if (lookahead == '\'') ADVANCE(534);
      if (lookahead == '(') ADVANCE(243);
      if (lookahead == ')') ADVANCE(245);
      if (lookahead == '*') ADVANCE(241);
      if (lookahead == '+') ADVANCE(468);
      if (lookahead == ',') ADVANCE(305);
      if (lookahead == '-') ADVANCE(352);
      if (lookahead == '.') ADVANCE(339);
      if (lookahead == '/') ADVANCE(497);
      if (lookahead == ':') ADVANCE(291);
      if (lookahead == ';') ADVANCE(546);
      if (lookahead == '<') ADVANCE(385);
      if (lookahead == '=') ADVANCE(341);
      if (lookahead == '>') ADVANCE(389);
      if (lookahead == '?') ADVANCE(68);
      if (lookahead == '@') ADVANCE(294);
      if (lookahead == '[') ADVANCE(310);
      if (lookahead == '\\') ADVANCE(454);
      if (lookahead == ']') ADVANCE(311);
      if (lookahead == '^') ADVANCE(528);
      if (lookahead == '_') ADVANCE(299);
      if (lookahead == '{') ADVANCE(336);
      if (lookahead == '|') ADVANCE(478);
      if (lookahead == '}') ADVANCE(337);
      if (lookahead == '~') ADVANCE(349);
      if (lookahead == 0xac) ADVANCE(350);
      if (lookahead == 0xd7) ADVANCE(523);
      if (lookahead == 0xf7) ADVANCE(504);
      if (lookahead == 0x2016) ADVANCE(481);
      if (lookahead == 0x2025) ADVANCE(464);
      if (lookahead == 0x2026) ADVANCE(466);
      if (lookahead == 0x203c) ADVANCE(509);
      if (lookahead == 0x2047) ADVANCE(514);
      if (lookahead == 0x207a) ADVANCE(531);
      if (lookahead == 0x2115) ADVANCE(333);
      if (lookahead == 0x211d) ADVANCE(335);
      if (lookahead == 0x2124) ADVANCE(334);
      if (lookahead == 0x2190) ADVANCE(261);
      if (lookahead == 0x2192) ADVANCE(275);
      if (lookahead == 0x219d) ADVANCE(374);
      if (lookahead == 0x21a6) ADVANCE(272);
      if (lookahead == 0x21d2) ADVANCE(363);
      if (lookahead == 0x21d4) ADVANCE(371);
      if (lookahead == 0x21dd) ADVANCE(373);
      if (lookahead == 0x21f8) ADVANCE(365);
      if (lookahead == 0x2200) ADVANCE(264);
      if (lookahead == 0x2203) ADVANCE(267);
      if (lookahead == 0x2208) ADVANCE(258);
      if (lookahead == 0x2209) ADVANCE(420);
      if (lookahead == 0x2218) ADVANCE(506);
      if (lookahead == 0x221d) ADVANCE(430);
      if (lookahead == 0x2227) ADVANCE(301);
      if (lookahead == 0x2228) ADVANCE(303);
      if (lookahead == 0x2229) ADVANCE(459);
      if (lookahead == 0x222a) ADVANCE(462);
      if (lookahead == 0x2237) ADVANCE(297);
      if (lookahead == 0x223c) ADVANCE(432);
      if (lookahead == 0x2240) ADVANCE(525);
      if (lookahead == 0x2243) ADVANCE(434);
      if (lookahead == 0x2245) ADVANCE(412);
      if (lookahead == 0x2248) ADVANCE(399);
      if (lookahead == 0x224d) ADVANCE(410);
      if (lookahead == 0x2250) ADVANCE(414);
      if (lookahead == 0x2254) ADVANCE(378);
      if (lookahead == 0x225c) ADVANCE(255);
      if (lookahead == 0x2260) ADVANCE(383);
      if (lookahead == 0x2261) ADVANCE(368);
      if (lookahead == 0x2264) ADVANCE(394);
      if (lookahead == 0x2265) ADVANCE(397);
      if (lookahead == 0x226a) ADVANCE(418);
      if (lookahead == 0x226b) ADVANCE(416);
      if (lookahead == 0x227a) ADVANCE(422);
      if (lookahead == 0x227b) ADVANCE(424);
      if (lookahead == 0x2282) ADVANCE(444);
      if (lookahead == 0x2283) ADVANCE(446);
      if (lookahead == 0x2286) ADVANCE(448);
      if (lookahead == 0x2287) ADVANCE(450);
      if (lookahead == 0x228e) ADVANCE(520);
      if (lookahead == 0x228f) ADVANCE(436);
      if (lookahead == 0x2290) ADVANCE(438);
      if (lookahead == 0x2291) ADVANCE(440);
      if (lookahead == 0x2292) ADVANCE(442);
      if (lookahead == 0x2293) ADVANCE(516);
      if (lookahead == 0x2294) ADVANCE(518);
      if (lookahead == 0x2295) ADVANCE(472);
      if (lookahead == 0x2296) ADVANCE(475);
      if (lookahead == 0x2297) ADVANCE(494);
      if (lookahead == 0x2298) ADVANCE(491);
      if (lookahead == 0x2299) ADVANCE(488);
      if (lookahead == 0x22a2) ADVANCE(402);
      if (lookahead == 0x22a3) ADVANCE(406);
      if (lookahead == 0x22a8) ADVANCE(404);
      if (lookahead == 0x22c4) ADVANCE(359);
      if (lookahead == 0x22c5) ADVANCE(527);
      if (lookahead == 0x22c6) ADVANCE(508);
      if (lookahead == 0x25a1) ADVANCE(289);
      if (lookahead == 0x25c7) ADVANCE(360);
      if (lookahead == 0x25cf) ADVANCE(502);
      if (lookahead == 0x25ef) ADVANCE(500);
      if (lookahead == 0x27e8) ADVANCE(278);
      if (lookahead == 0x27e9) ADVANCE(284);
      if (lookahead == 0x27f5) ADVANCE(260);
      if (lookahead == 0x27f6) ADVANCE(274);
      if (lookahead == 0x27f9) ADVANCE(362);
      if (lookahead == 0x27fa) ADVANCE(370);
      if (lookahead == 0x27fc) ADVANCE(271);
      if (lookahead == 0x2945) ADVANCE(366);
      if (lookahead == 0x2a74) ADVANCE(380);
      if (lookahead == 0x2aaf) ADVANCE(426);
      if (lookahead == 0x2ab0) ADVANCE(428);
      if (lookahead == 0x2ae4) ADVANCE(408);
      if (lookahead == 0x3008) ADVANCE(277);
      if (lookahead == 0x3009) ADVANCE(282);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(225);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(314);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 226:
      if (eof) ADVANCE(233);
      if (lookahead == '\r') SKIP(227);
      if (lookahead == '!') ADVANCE(312);
      if (lookahead == '(') ADVANCE(306);
      if (lookahead == ')') ADVANCE(308);
      if (lookahead == '+') ADVANCE(467);
      if (lookahead == ',') ADVANCE(305);
      if (lookahead == '-') ADVANCE(46);
      if (lookahead == ':') ADVANCE(290);
      if (lookahead == ';') ADVANCE(546);
      if (lookahead == '<') ADVANCE(47);
      if (lookahead == '=') ADVANCE(62);
      if (lookahead == '>') ADVANCE(67);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') ADVANCE(41);
      if (lookahead == ']') ADVANCE(311);
      if (lookahead == '_') ADVANCE(299);
      if (lookahead == '{') ADVANCE(336);
      if (lookahead == '|') ADVANCE(52);
      if (lookahead == '}') ADVANCE(337);
      if (lookahead == '~') ADVANCE(348);
      if (lookahead == 0xac) ADVANCE(350);
      if (lookahead == 0x2016) ADVANCE(481);
      if (lookahead == 0x2115) ADVANCE(333);
      if (lookahead == 0x211d) ADVANCE(335);
      if (lookahead == 0x2124) ADVANCE(334);
      if (lookahead == 0x2190) ADVANCE(261);
      if (lookahead == 0x21a6) ADVANCE(272);
      if (lookahead == 0x2208) ADVANCE(258);
      if (lookahead == 0x22c4) ADVANCE(359);
      if (lookahead == 0x25a1) ADVANCE(289);
      if (lookahead == 0x25c7) ADVANCE(360);
      if (lookahead == 0x27e8) ADVANCE(278);
      if (lookahead == 0x27e9) ADVANCE(283);
      if (lookahead == 0x27f5) ADVANCE(260);
      if (lookahead == 0x27fc) ADVANCE(271);
      if (lookahead == 0x3008) ADVANCE(277);
      if (lookahead == 0x3009) ADVANCE(281);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(224);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(227);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(323);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 227:
      if (eof) ADVANCE(233);
      if (lookahead == '\r') SKIP(227);
      if (lookahead == '!') ADVANCE(312);
      if (lookahead == '(') ADVANCE(306);
      if (lookahead == ')') ADVANCE(308);
      if (lookahead == '+') ADVANCE(467);
      if (lookahead == ',') ADVANCE(305);
      if (lookahead == '-') ADVANCE(46);
      if (lookahead == ':') ADVANCE(290);
      if (lookahead == ';') ADVANCE(546);
      if (lookahead == '<') ADVANCE(47);
      if (lookahead == '=') ADVANCE(62);
      if (lookahead == '>') ADVANCE(67);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') ADVANCE(41);
      if (lookahead == ']') ADVANCE(311);
      if (lookahead == '_') ADVANCE(299);
      if (lookahead == '{') ADVANCE(336);
      if (lookahead == '|') ADVANCE(52);
      if (lookahead == '}') ADVANCE(337);
      if (lookahead == '~') ADVANCE(348);
      if (lookahead == 0xac) ADVANCE(350);
      if (lookahead == 0x2016) ADVANCE(481);
      if (lookahead == 0x2115) ADVANCE(333);
      if (lookahead == 0x211d) ADVANCE(335);
      if (lookahead == 0x2124) ADVANCE(334);
      if (lookahead == 0x2190) ADVANCE(261);
      if (lookahead == 0x21a6) ADVANCE(272);
      if (lookahead == 0x2208) ADVANCE(258);
      if (lookahead == 0x22c4) ADVANCE(359);
      if (lookahead == 0x25a1) ADVANCE(289);
      if (lookahead == 0x25c7) ADVANCE(360);
      if (lookahead == 0x27e8) ADVANCE(278);
      if (lookahead == 0x27e9) ADVANCE(283);
      if (lookahead == 0x27f5) ADVANCE(260);
      if (lookahead == 0x27fc) ADVANCE(271);
      if (lookahead == 0x3008) ADVANCE(277);
      if (lookahead == 0x3009) ADVANCE(281);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(227);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(224);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 228:
      if (eof) ADVANCE(233);
      if (lookahead == '\r') SKIP(228);
      if (lookahead == '!') ADVANCE(312);
      if (lookahead == '"') ADVANCE(328);
      if (lookahead == '#') ADVANCE(382);
      if (lookahead == '$') ADVANCE(511);
      if (lookahead == '%') ADVANCE(476);
      if (lookahead == '&') ADVANCE(484);
      if (lookahead == '\'') ADVANCE(534);
      if (lookahead == '(') ADVANCE(307);
      if (lookahead == '*') ADVANCE(495);
      if (lookahead == '+') ADVANCE(468);
      if (lookahead == ',') ADVANCE(305);
      if (lookahead == '-') ADVANCE(353);
      if (lookahead == '.') ADVANCE(54);
      if (lookahead == '/') ADVANCE(497);
      if (lookahead == ':') ADVANCE(57);
      if (lookahead == '<') ADVANCE(385);
      if (lookahead == '=') ADVANCE(344);
      if (lookahead == '>') ADVANCE(388);
      if (lookahead == '?') ADVANCE(68);
      if (lookahead == '@') ADVANCE(294);
      if (lookahead == '[') ADVANCE(310);
      if (lookahead == '\\') ADVANCE(454);
      if (lookahead == '^') ADVANCE(528);
      if (lookahead == '_') ADVANCE(224);
      if (lookahead == '{') ADVANCE(336);
      if (lookahead == '|') ADVANCE(479);
      if (lookahead == '~') ADVANCE(349);
      if (lookahead == 0xac) ADVANCE(350);
      if (lookahead == 0xd7) ADVANCE(523);
      if (lookahead == 0xf7) ADVANCE(504);
      if (lookahead == 0x2016) ADVANCE(481);
      if (lookahead == 0x2025) ADVANCE(464);
      if (lookahead == 0x2026) ADVANCE(466);
      if (lookahead == 0x203c) ADVANCE(509);
      if (lookahead == 0x2047) ADVANCE(514);
      if (lookahead == 0x207a) ADVANCE(531);
      if (lookahead == 0x2115) ADVANCE(333);
      if (lookahead == 0x211d) ADVANCE(335);
      if (lookahead == 0x2124) ADVANCE(334);
      if (lookahead == 0x219d) ADVANCE(374);
      if (lookahead == 0x21d2) ADVANCE(363);
      if (lookahead == 0x21d4) ADVANCE(371);
      if (lookahead == 0x21dd) ADVANCE(373);
      if (lookahead == 0x21f8) ADVANCE(365);
      if (lookahead == 0x2200) ADVANCE(264);
      if (lookahead == 0x2203) ADVANCE(267);
      if (lookahead == 0x2208) ADVANCE(258);
      if (lookahead == 0x2209) ADVANCE(420);
      if (lookahead == 0x2218) ADVANCE(506);
      if (lookahead == 0x221d) ADVANCE(430);
      if (lookahead == 0x2227) ADVANCE(301);
      if (lookahead == 0x2228) ADVANCE(303);
      if (lookahead == 0x2229) ADVANCE(459);
      if (lookahead == 0x222a) ADVANCE(462);
      if (lookahead == 0x223c) ADVANCE(432);
      if (lookahead == 0x2240) ADVANCE(525);
      if (lookahead == 0x2243) ADVANCE(434);
      if (lookahead == 0x2245) ADVANCE(412);
      if (lookahead == 0x2248) ADVANCE(399);
      if (lookahead == 0x224d) ADVANCE(410);
      if (lookahead == 0x2250) ADVANCE(414);
      if (lookahead == 0x2254) ADVANCE(378);
      if (lookahead == 0x2260) ADVANCE(383);
      if (lookahead == 0x2261) ADVANCE(368);
      if (lookahead == 0x2264) ADVANCE(394);
      if (lookahead == 0x2265) ADVANCE(397);
      if (lookahead == 0x226a) ADVANCE(418);
      if (lookahead == 0x226b) ADVANCE(416);
      if (lookahead == 0x227a) ADVANCE(422);
      if (lookahead == 0x227b) ADVANCE(424);
      if (lookahead == 0x2282) ADVANCE(444);
      if (lookahead == 0x2283) ADVANCE(446);
      if (lookahead == 0x2286) ADVANCE(448);
      if (lookahead == 0x2287) ADVANCE(450);
      if (lookahead == 0x228e) ADVANCE(520);
      if (lookahead == 0x228f) ADVANCE(436);
      if (lookahead == 0x2290) ADVANCE(438);
      if (lookahead == 0x2291) ADVANCE(440);
      if (lookahead == 0x2292) ADVANCE(442);
      if (lookahead == 0x2293) ADVANCE(516);
      if (lookahead == 0x2294) ADVANCE(518);
      if (lookahead == 0x2295) ADVANCE(472);
      if (lookahead == 0x2296) ADVANCE(475);
      if (lookahead == 0x2297) ADVANCE(494);
      if (lookahead == 0x2298) ADVANCE(491);
      if (lookahead == 0x2299) ADVANCE(488);
      if (lookahead == 0x22a2) ADVANCE(402);
      if (lookahead == 0x22a3) ADVANCE(406);
      if (lookahead == 0x22a8) ADVANCE(404);
      if (lookahead == 0x22c4) ADVANCE(359);
      if (lookahead == 0x22c5) ADVANCE(527);
      if (lookahead == 0x22c6) ADVANCE(508);
      if (lookahead == 0x25a1) ADVANCE(289);
      if (lookahead == 0x25c7) ADVANCE(360);
      if (lookahead == 0x25cf) ADVANCE(502);
      if (lookahead == 0x25ef) ADVANCE(500);
      if (lookahead == 0x27e8) ADVANCE(278);
      if (lookahead == 0x27f9) ADVANCE(362);
      if (lookahead == 0x27fa) ADVANCE(370);
      if (lookahead == 0x2945) ADVANCE(366);
      if (lookahead == 0x2a74) ADVANCE(380);
      if (lookahead == 0x2aaf) ADVANCE(426);
      if (lookahead == 0x2ab0) ADVANCE(428);
      if (lookahead == 0x2ae4) ADVANCE(408);
      if (lookahead == 0x3008) ADVANCE(277);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(228);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(313);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 229:
      if (eof) ADVANCE(233);
      if (lookahead == '\r') SKIP(229);
      if (lookahead == '!') ADVANCE(312);
      if (lookahead == '#') ADVANCE(382);
      if (lookahead == '$') ADVANCE(511);
      if (lookahead == '%') ADVANCE(476);
      if (lookahead == '&') ADVANCE(484);
      if (lookahead == '\'') ADVANCE(534);
      if (lookahead == '(') ADVANCE(307);
      if (lookahead == '*') ADVANCE(495);
      if (lookahead == '+') ADVANCE(468);
      if (lookahead == ',') ADVANCE(305);
      if (lookahead == '-') ADVANCE(353);
      if (lookahead == '.') ADVANCE(339);
      if (lookahead == '/') ADVANCE(497);
      if (lookahead == ':') ADVANCE(55);
      if (lookahead == '<') ADVANCE(387);
      if (lookahead == '=') ADVANCE(344);
      if (lookahead == '>') ADVANCE(388);
      if (lookahead == '?') ADVANCE(68);
      if (lookahead == '@') ADVANCE(69);
      if (lookahead == '[') ADVANCE(310);
      if (lookahead == '\\') ADVANCE(455);
      if (lookahead == '^') ADVANCE(528);
      if (lookahead == '|') ADVANCE(479);
      if (lookahead == '~') ADVANCE(349);
      if (lookahead == 0xac) ADVANCE(350);
      if (lookahead == 0xd7) ADVANCE(523);
      if (lookahead == 0xf7) ADVANCE(504);
      if (lookahead == 0x2016) ADVANCE(481);
      if (lookahead == 0x2025) ADVANCE(464);
      if (lookahead == 0x2026) ADVANCE(466);
      if (lookahead == 0x203c) ADVANCE(509);
      if (lookahead == 0x2047) ADVANCE(514);
      if (lookahead == 0x207a) ADVANCE(531);
      if (lookahead == 0x2115) ADVANCE(333);
      if (lookahead == 0x211d) ADVANCE(335);
      if (lookahead == 0x2124) ADVANCE(334);
      if (lookahead == 0x219d) ADVANCE(374);
      if (lookahead == 0x21d2) ADVANCE(363);
      if (lookahead == 0x21d4) ADVANCE(371);
      if (lookahead == 0x21dd) ADVANCE(373);
      if (lookahead == 0x21f8) ADVANCE(365);
      if (lookahead == 0x2208) ADVANCE(258);
      if (lookahead == 0x2209) ADVANCE(420);
      if (lookahead == 0x2218) ADVANCE(506);
      if (lookahead == 0x221d) ADVANCE(430);
      if (lookahead == 0x2227) ADVANCE(301);
      if (lookahead == 0x2228) ADVANCE(303);
      if (lookahead == 0x2229) ADVANCE(459);
      if (lookahead == 0x222a) ADVANCE(462);
      if (lookahead == 0x2237) ADVANCE(297);
      if (lookahead == 0x223c) ADVANCE(432);
      if (lookahead == 0x2240) ADVANCE(525);
      if (lookahead == 0x2243) ADVANCE(434);
      if (lookahead == 0x2245) ADVANCE(412);
      if (lookahead == 0x2248) ADVANCE(399);
      if (lookahead == 0x224d) ADVANCE(410);
      if (lookahead == 0x2250) ADVANCE(414);
      if (lookahead == 0x2254) ADVANCE(378);
      if (lookahead == 0x2260) ADVANCE(383);
      if (lookahead == 0x2261) ADVANCE(368);
      if (lookahead == 0x2264) ADVANCE(394);
      if (lookahead == 0x2265) ADVANCE(397);
      if (lookahead == 0x226a) ADVANCE(418);
      if (lookahead == 0x226b) ADVANCE(416);
      if (lookahead == 0x227a) ADVANCE(422);
      if (lookahead == 0x227b) ADVANCE(424);
      if (lookahead == 0x2282) ADVANCE(444);
      if (lookahead == 0x2283) ADVANCE(446);
      if (lookahead == 0x2286) ADVANCE(448);
      if (lookahead == 0x2287) ADVANCE(450);
      if (lookahead == 0x228e) ADVANCE(520);
      if (lookahead == 0x228f) ADVANCE(436);
      if (lookahead == 0x2290) ADVANCE(438);
      if (lookahead == 0x2291) ADVANCE(440);
      if (lookahead == 0x2292) ADVANCE(442);
      if (lookahead == 0x2293) ADVANCE(516);
      if (lookahead == 0x2294) ADVANCE(518);
      if (lookahead == 0x2295) ADVANCE(472);
      if (lookahead == 0x2296) ADVANCE(475);
      if (lookahead == 0x2297) ADVANCE(494);
      if (lookahead == 0x2298) ADVANCE(491);
      if (lookahead == 0x2299) ADVANCE(488);
      if (lookahead == 0x22a2) ADVANCE(402);
      if (lookahead == 0x22a3) ADVANCE(406);
      if (lookahead == 0x22a8) ADVANCE(404);
      if (lookahead == 0x22c4) ADVANCE(359);
      if (lookahead == 0x22c5) ADVANCE(527);
      if (lookahead == 0x22c6) ADVANCE(508);
      if (lookahead == 0x25a1) ADVANCE(289);
      if (lookahead == 0x25c7) ADVANCE(360);
      if (lookahead == 0x25cf) ADVANCE(502);
      if (lookahead == 0x25ef) ADVANCE(500);
      if (lookahead == 0x27f9) ADVANCE(362);
      if (lookahead == 0x27fa) ADVANCE(370);
      if (lookahead == 0x2945) ADVANCE(366);
      if (lookahead == 0x2a74) ADVANCE(380);
      if (lookahead == 0x2aaf) ADVANCE(426);
      if (lookahead == 0x2ab0) ADVANCE(428);
      if (lookahead == 0x2ae4) ADVANCE(408);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(229);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(224);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 230:
      if (eof) ADVANCE(233);
      if (lookahead == '\r') SKIP(230);
      if (lookahead == '!') ADVANCE(312);
      if (lookahead == '#') ADVANCE(382);
      if (lookahead == '$') ADVANCE(511);
      if (lookahead == '%') ADVANCE(476);
      if (lookahead == '&') ADVANCE(484);
      if (lookahead == '\'') ADVANCE(534);
      if (lookahead == '(') ADVANCE(307);
      if (lookahead == '*') ADVANCE(495);
      if (lookahead == '+') ADVANCE(468);
      if (lookahead == '-') ADVANCE(353);
      if (lookahead == '.') ADVANCE(339);
      if (lookahead == '/') ADVANCE(497);
      if (lookahead == ':') ADVANCE(55);
      if (lookahead == '<') ADVANCE(387);
      if (lookahead == '=') ADVANCE(342);
      if (lookahead == '>') ADVANCE(388);
      if (lookahead == '?') ADVANCE(68);
      if (lookahead == '@') ADVANCE(69);
      if (lookahead == '[') ADVANCE(310);
      if (lookahead == '\\') ADVANCE(455);
      if (lookahead == '^') ADVANCE(528);
      if (lookahead == '|') ADVANCE(479);
      if (lookahead == '~') ADVANCE(349);
      if (lookahead == 0xac) ADVANCE(350);
      if (lookahead == 0xd7) ADVANCE(523);
      if (lookahead == 0xf7) ADVANCE(504);
      if (lookahead == 0x2016) ADVANCE(481);
      if (lookahead == 0x2025) ADVANCE(464);
      if (lookahead == 0x2026) ADVANCE(466);
      if (lookahead == 0x203c) ADVANCE(509);
      if (lookahead == 0x2047) ADVANCE(514);
      if (lookahead == 0x207a) ADVANCE(531);
      if (lookahead == 0x2115) ADVANCE(333);
      if (lookahead == 0x211d) ADVANCE(335);
      if (lookahead == 0x2124) ADVANCE(334);
      if (lookahead == 0x219d) ADVANCE(374);
      if (lookahead == 0x21d2) ADVANCE(363);
      if (lookahead == 0x21d4) ADVANCE(371);
      if (lookahead == 0x21dd) ADVANCE(373);
      if (lookahead == 0x21f8) ADVANCE(365);
      if (lookahead == 0x2208) ADVANCE(258);
      if (lookahead == 0x2209) ADVANCE(420);
      if (lookahead == 0x2218) ADVANCE(506);
      if (lookahead == 0x221d) ADVANCE(430);
      if (lookahead == 0x2227) ADVANCE(301);
      if (lookahead == 0x2228) ADVANCE(303);
      if (lookahead == 0x2229) ADVANCE(459);
      if (lookahead == 0x222a) ADVANCE(462);
      if (lookahead == 0x2237) ADVANCE(297);
      if (lookahead == 0x223c) ADVANCE(432);
      if (lookahead == 0x2240) ADVANCE(525);
      if (lookahead == 0x2243) ADVANCE(434);
      if (lookahead == 0x2245) ADVANCE(412);
      if (lookahead == 0x2248) ADVANCE(399);
      if (lookahead == 0x224d) ADVANCE(410);
      if (lookahead == 0x2250) ADVANCE(414);
      if (lookahead == 0x2254) ADVANCE(378);
      if (lookahead == 0x225c) ADVANCE(255);
      if (lookahead == 0x2260) ADVANCE(383);
      if (lookahead == 0x2261) ADVANCE(368);
      if (lookahead == 0x2264) ADVANCE(394);
      if (lookahead == 0x2265) ADVANCE(397);
      if (lookahead == 0x226a) ADVANCE(418);
      if (lookahead == 0x226b) ADVANCE(416);
      if (lookahead == 0x227a) ADVANCE(422);
      if (lookahead == 0x227b) ADVANCE(424);
      if (lookahead == 0x2282) ADVANCE(444);
      if (lookahead == 0x2283) ADVANCE(446);
      if (lookahead == 0x2286) ADVANCE(448);
      if (lookahead == 0x2287) ADVANCE(450);
      if (lookahead == 0x228e) ADVANCE(520);
      if (lookahead == 0x228f) ADVANCE(436);
      if (lookahead == 0x2290) ADVANCE(438);
      if (lookahead == 0x2291) ADVANCE(440);
      if (lookahead == 0x2292) ADVANCE(442);
      if (lookahead == 0x2293) ADVANCE(516);
      if (lookahead == 0x2294) ADVANCE(518);
      if (lookahead == 0x2295) ADVANCE(472);
      if (lookahead == 0x2296) ADVANCE(475);
      if (lookahead == 0x2297) ADVANCE(494);
      if (lookahead == 0x2298) ADVANCE(491);
      if (lookahead == 0x2299) ADVANCE(488);
      if (lookahead == 0x22a2) ADVANCE(402);
      if (lookahead == 0x22a3) ADVANCE(406);
      if (lookahead == 0x22a8) ADVANCE(404);
      if (lookahead == 0x22c4) ADVANCE(359);
      if (lookahead == 0x22c5) ADVANCE(527);
      if (lookahead == 0x22c6) ADVANCE(508);
      if (lookahead == 0x25a1) ADVANCE(289);
      if (lookahead == 0x25c7) ADVANCE(360);
      if (lookahead == 0x25cf) ADVANCE(502);
      if (lookahead == 0x25ef) ADVANCE(500);
      if (lookahead == 0x27f9) ADVANCE(362);
      if (lookahead == 0x27fa) ADVANCE(370);
      if (lookahead == 0x2945) ADVANCE(366);
      if (lookahead == 0x2a74) ADVANCE(380);
      if (lookahead == 0x2aaf) ADVANCE(426);
      if (lookahead == 0x2ab0) ADVANCE(428);
      if (lookahead == 0x2ae4) ADVANCE(408);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(230);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(224);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 231:
      if (eof) ADVANCE(233);
      if (lookahead == '\r') SKIP(232);
      if (lookahead == '!') ADVANCE(312);
      if (lookahead == '(') ADVANCE(306);
      if (lookahead == ')') ADVANCE(308);
      if (lookahead == '*') ADVANCE(543);
      if (lookahead == ',') ADVANCE(305);
      if (lookahead == '-') ADVANCE(51);
      if (lookahead == '.') ADVANCE(338);
      if (lookahead == ':') ADVANCE(293);
      if (lookahead == '<') ADVANCE(48);
      if (lookahead == '=') ADVANCE(61);
      if (lookahead == '>') ADVANCE(538);
      if (lookahead == '[') ADVANCE(310);
      if (lookahead == '\\') ADVANCE(42);
      if (lookahead == '_') ADVANCE(224);
      if (lookahead == '}') ADVANCE(337);
      if (lookahead == '~') ADVANCE(348);
      if (lookahead == 0xac) ADVANCE(350);
      if (lookahead == 0x2115) ADVANCE(333);
      if (lookahead == 0x211d) ADVANCE(335);
      if (lookahead == 0x2124) ADVANCE(334);
      if (lookahead == 0x2190) ADVANCE(261);
      if (lookahead == 0x2254) ADVANCE(378);
      if (lookahead == 0x225c) ADVANCE(255);
      if (lookahead == 0x22c4) ADVANCE(359);
      if (lookahead == 0x25a1) ADVANCE(289);
      if (lookahead == 0x25c7) ADVANCE(360);
      if (lookahead == 0x27f5) ADVANCE(260);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(232);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(544);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 232:
      if (eof) ADVANCE(233);
      if (lookahead == '\r') SKIP(232);
      if (lookahead == '!') ADVANCE(312);
      if (lookahead == '(') ADVANCE(306);
      if (lookahead == ')') ADVANCE(308);
      if (lookahead == ',') ADVANCE(305);
      if (lookahead == '-') ADVANCE(51);
      if (lookahead == '.') ADVANCE(338);
      if (lookahead == ':') ADVANCE(293);
      if (lookahead == '<') ADVANCE(48);
      if (lookahead == '=') ADVANCE(61);
      if (lookahead == '[') ADVANCE(310);
      if (lookahead == '\\') ADVANCE(42);
      if (lookahead == '}') ADVANCE(337);
      if (lookahead == '~') ADVANCE(348);
      if (lookahead == 0xac) ADVANCE(350);
      if (lookahead == 0x2115) ADVANCE(333);
      if (lookahead == 0x211d) ADVANCE(335);
      if (lookahead == 0x2124) ADVANCE(334);
      if (lookahead == 0x2190) ADVANCE(261);
      if (lookahead == 0x2254) ADVANCE(378);
      if (lookahead == 0x225c) ADVANCE(255);
      if (lookahead == 0x22c4) ADVANCE(359);
      if (lookahead == 0x25a1) ADVANCE(289);
      if (lookahead == 0x25c7) ADVANCE(360);
      if (lookahead == 0x27f5) ADVANCE(260);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(232);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(224);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(234);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_LPAREN_STAR);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_STAR_RPAREN);
      if (lookahead == '\n') ADVANCE(32);
      if (lookahead == '\r') ADVANCE(1);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(2);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token1);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token1);
      if (lookahead == '\r') ADVANCE(238);
      if (lookahead == '(') ADVANCE(244);
      if (lookahead == ')') ADVANCE(239);
      if (lookahead == '*') ADVANCE(242);
      if (lookahead == '-') ADVANCE(240);
      if (lookahead == ';') ADVANCE(239);
      if (lookahead == '\\') ADVANCE(239);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(238);
      if (lookahead != 0) ADVANCE(239);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token1);
      if (lookahead == ')') ADVANCE(237);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token1);
      if (lookahead == ')') ADVANCE(237);
      if (lookahead == '-') ADVANCE(78);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token2);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token2);
      if (lookahead == ')') ADVANCE(236);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token3);
      if (lookahead == '*') ADVANCE(235);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token3);
      if (lookahead == '*') ADVANCE(235);
      if (lookahead != 0 &&
          lookahead != '(') ADVANCE(237);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token4);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(aux_sym_block_comment_text_token4);
      if (lookahead == ')') ADVANCE(237);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_DASH_DASH_DASH_DASH);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(aux_sym_single_line_token1);
      if (lookahead == '(') ADVANCE(38);
      if (lookahead == '-') ADVANCE(249);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(aux_sym_single_line_token1);
      if (lookahead == '-') ADVANCE(249);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ_EQ);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(aux_sym_double_line_token1);
      if (lookahead == '(') ADVANCE(38);
      if (lookahead == '=') ADVANCE(252);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(aux_sym_double_line_token1);
      if (lookahead == '=') ADVANCE(252);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(60);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_u225c);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_BSLASHin);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_BSLASHin);
      if (lookahead == 't') ADVANCE(99);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_u2208);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_u27f5);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_u2190);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_BSLASHA);
      if (lookahead == 'A') ADVANCE(268);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_BSLASHforall);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_u2200);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_BSLASHE);
      if (lookahead == 'E') ADVANCE(269);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_BSLASHexists);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_u2203);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_temporal_forall);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_temporal_exists);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_PIPE_DASH_GT);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_u27fc);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_u21a6);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_u27f6);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_u2192);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_u3008);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_u27e8);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '_') ADVANCE(285);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_u3009);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_u3009);
      if (lookahead == '_') ADVANCE(286);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_u27e9);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_u27e9);
      if (lookahead == '_') ADVANCE(287);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_GT_GT_);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_u3009_);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_u27e9_);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_LBRACK_RBRACK);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_u25a1);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(296);
      if (lookahead == '=') ADVANCE(377);
      if (lookahead == '>') ADVANCE(452);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(58);
      if (lookahead == '=') ADVANCE(377);
      if (lookahead == '>') ADVANCE(452);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(377);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '@') ADVANCE(451);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      if (lookahead == '=') ADVANCE(379);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_u2237);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_placeholder);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_placeholder);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(224);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_SLASH_BSLASH);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(anon_sym_u2227);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_BSLASH_SLASH);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(anon_sym_u2228);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead == '*') ADVANCE(235);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead == '*') ADVANCE(235);
      if (lookahead == '+') ADVANCE(33);
      if (lookahead == '-') ADVANCE(34);
      if (lookahead == '.') ADVANCE(35);
      if (lookahead == '/') ADVANCE(36);
      if (lookahead == '\\') ADVANCE(70);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == ']') ADVANCE(288);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(aux_sym_child_id_token1);
      if (lookahead == '.') ADVANCE(223);
      if (lookahead == '_') ADVANCE(224);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(313);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(aux_sym_child_id_token1);
      if (lookahead == '_') ADVANCE(224);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(314);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_real_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(315);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(anon_sym_BSLASHb);
      if (lookahead == 'i') ADVANCE(106);
      if (lookahead == 'u') ADVANCE(129);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(anon_sym_BSLASHB);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(aux_sym_binary_number_token1);
      if (lookahead == '_') ADVANCE(224);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(318);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(536);
      if (('2' <= lookahead && lookahead <= '7')) ADVANCE(322);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(aux_sym_binary_number_token1);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(319);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(anon_sym_BSLASHo);
      if (lookahead == 'd') ADVANCE(153);
      if (lookahead == 'm') ADVANCE(119);
      if (lookahead == 'p') ADVANCE(126);
      if (lookahead == 's') ADVANCE(127);
      if (lookahead == 't') ADVANCE(124);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_BSLASHO);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(aux_sym_octal_number_token1);
      if (lookahead == '_') ADVANCE(224);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(536);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(322);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(aux_sym_octal_number_token1);
      if (lookahead == '8' ||
          lookahead == '9' ||
          lookahead == '_') ADVANCE(224);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(323);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(aux_sym_octal_number_token1);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(324);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(anon_sym_BSLASHh);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(anon_sym_BSLASHH);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(aux_sym_hex_number_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(327);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(aux_sym_string_token1);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '*') ADVANCE(332);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(332);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(anon_sym_DQUOTE2);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym_escape_char);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(anon_sym_u2115);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(anon_sym_u2124);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(anon_sym_u211d);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(463);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '=') ADVANCE(254);
      if (lookahead == '>') ADVANCE(361);
      if (lookahead == '|') ADVANCE(407);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '=') ADVANCE(253);
      if (lookahead == '>') ADVANCE(361);
      if (lookahead == '|') ADVANCE(407);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '=') ADVANCE(59);
      if (lookahead == '>') ADVANCE(361);
      if (lookahead == '|') ADVANCE(407);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '<') ADVANCE(392);
      if (lookahead == '>') ADVANCE(361);
      if (lookahead == '|') ADVANCE(407);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(anon_sym_RBRACK_);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(anon_sym_BSLASHlnot);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(anon_sym_BSLASHneg);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '>') ADVANCE(372);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(anon_sym_u00ac);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(44);
      if (lookahead == '-') ADVANCE(483);
      if (lookahead == '.') ADVANCE(357);
      if (lookahead == '>') ADVANCE(273);
      if (lookahead == '|') ADVANCE(405);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(44);
      if (lookahead == '-') ADVANCE(483);
      if (lookahead == '.') ADVANCE(357);
      if (lookahead == '|') ADVANCE(405);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(44);
      if (lookahead == '-') ADVANCE(482);
      if (lookahead == '.') ADVANCE(357);
      if (lookahead == '|') ADVANCE(405);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(44);
      if (lookahead == '-') ADVANCE(482);
      if (lookahead == '>') ADVANCE(273);
      if (lookahead == '|') ADVANCE(405);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '+') ADVANCE(44);
      if (lookahead == '-') ADVANCE(482);
      if (lookahead == '|') ADVANCE(405);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym_negative_dot);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(anon_sym_LT_GT);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(anon_sym_u22c4);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(anon_sym_u25c7);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(anon_sym_u27f9);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(anon_sym_u21d2);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(anon_sym_DASH_PLUS_DASH_GT);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(anon_sym_u21f8);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(anon_sym_u2945);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(anon_sym_BSLASHequiv);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(anon_sym_u2261);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(anon_sym_LT_EQ_GT);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(anon_sym_u27fa);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(anon_sym_u21d4);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(anon_sym_TILDE_GT);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(anon_sym_u21dd);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(anon_sym_u219d);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(anon_sym_BSLASHland);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(anon_sym_BSLASHlor);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(anon_sym_u2254);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(anon_sym_COLON_COLON_EQ);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(anon_sym_u2a74);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '#') ADVANCE(510);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(anon_sym_u2260);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == ':') ADVANCE(453);
      if (lookahead == '<') ADVANCE(276);
      if (lookahead == '=') ADVANCE(391);
      if (lookahead == '>') ADVANCE(358);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == ':') ADVANCE(453);
      if (lookahead == '=') ADVANCE(391);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == ':') ADVANCE(453);
      if (lookahead == '=') ADVANCE(391);
      if (lookahead == '>') ADVANCE(358);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym_gt);
      if (lookahead == '=') ADVANCE(395);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(sym_gt);
      if (lookahead == '=') ADVANCE(395);
      if (lookahead == '>') ADVANCE(280);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(sym_gt);
      if (lookahead == '=') ADVANCE(395);
      if (lookahead == '>') ADVANCE(279);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      if (lookahead == '>') ADVANCE(369);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(anon_sym_EQ_LT);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(anon_sym_BSLASHleq);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(anon_sym_u2264);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(anon_sym_BSLASHgeq);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(anon_sym_u2265);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(anon_sym_BSLASHapprox);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(anon_sym_u2248);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(anon_sym_PIPE_DASH);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(anon_sym_PIPE_DASH);
      if (lookahead == '>') ADVANCE(270);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(anon_sym_u22a2);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(anon_sym_u22a8);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(anon_sym_DASH_PIPE);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(anon_sym_u22a3);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(anon_sym_EQ_PIPE);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(anon_sym_u2ae4);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(anon_sym_BSLASHasymp);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(anon_sym_u224d);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(anon_sym_BSLASHcong);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(anon_sym_u2245);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(anon_sym_BSLASHdoteq);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(anon_sym_u2250);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(anon_sym_BSLASHgg);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(anon_sym_u226b);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(anon_sym_BSLASHll);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(anon_sym_u226a);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(anon_sym_BSLASHnotin);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(anon_sym_u2209);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(anon_sym_BSLASHprec);
      if (lookahead == 'e') ADVANCE(170);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(anon_sym_u227a);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(anon_sym_BSLASHsucc);
      if (lookahead == 'e') ADVANCE(171);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(anon_sym_u227b);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(anon_sym_BSLASHpreceq);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(anon_sym_u2aaf);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(anon_sym_BSLASHsucceq);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(anon_sym_u2ab0);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(anon_sym_BSLASHpropto);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(anon_sym_u221d);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(anon_sym_BSLASHsim);
      if (lookahead == 'e') ADVANCE(169);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(anon_sym_u223c);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(anon_sym_BSLASHsimeq);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(anon_sym_u2243);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(anon_sym_BSLASHsqsubset);
      if (lookahead == 'e') ADVANCE(174);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(anon_sym_u228f);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(anon_sym_BSLASHsqsupset);
      if (lookahead == 'e') ADVANCE(175);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(anon_sym_u2290);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(anon_sym_BSLASHsqsubseteq);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(anon_sym_u2291);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(anon_sym_BSLASHsqsupseteq);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(anon_sym_u2292);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(anon_sym_BSLASHsubset);
      if (lookahead == 'e') ADVANCE(172);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(anon_sym_u2282);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(anon_sym_BSLASHsupset);
      if (lookahead == 'e') ADVANCE(173);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(anon_sym_u2283);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(anon_sym_BSLASHsubseteq);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(anon_sym_u2286);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(anon_sym_BSLASHsupseteq);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(anon_sym_u2287);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(sym_compose);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(sym_map_to);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(sym_map_from);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(sym_setminus);
      ADVANCE_MAP(
        '*', 234,
        '/', 302,
        'A', 262,
        'B', 317,
        'E', 265,
        'H', 326,
        'O', 321,
        'X', 521,
        'a', 156,
        'b', 316,
        'c', 73,
        'd', 113,
        'e', 165,
        'f', 151,
        'g', 92,
        'h', 325,
        'i', 138,
        'l', 74,
        'n', 94,
        'o', 320,
        'p', 180,
        's', 114,
        't', 117,
        'u', 144,
        'w', 176,
      );
      END_STATE();
    case 455:
      ACCEPT_TOKEN(sym_setminus);
      ADVANCE_MAP(
        '*', 234,
        '/', 302,
        'X', 521,
        'a', 156,
        'b', 112,
        'c', 73,
        'd', 113,
        'e', 164,
        'g', 92,
        'i', 138,
        'l', 74,
        'n', 94,
        'o', 320,
        'p', 180,
        's', 114,
        't', 117,
        'u', 144,
        'w', 176,
      );
      END_STATE();
    case 456:
      ACCEPT_TOKEN(sym_setminus);
      ADVANCE_MAP(
        '*', 234,
        '/', 302,
        'X', 521,
        'a', 156,
        'b', 112,
        'c', 73,
        'd', 113,
        'e', 164,
        'g', 92,
        'i', 138,
        'l', 75,
        'n', 149,
        'o', 320,
        'p', 180,
        's', 114,
        't', 117,
        'u', 144,
        'w', 176,
      );
      END_STATE();
    case 457:
      ACCEPT_TOKEN(anon_sym_BSLASHcap);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(anon_sym_BSLASHintersect);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(anon_sym_u2229);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(anon_sym_BSLASHcup);
      END_STATE();
    case 461:
      ACCEPT_TOKEN(anon_sym_BSLASHunion);
      END_STATE();
    case 462:
      ACCEPT_TOKEN(anon_sym_u222a);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      if (lookahead == '.') ADVANCE(465);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(anon_sym_u2025);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 466:
      ACCEPT_TOKEN(anon_sym_u2026);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 468:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(469);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(sym_plusplus);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(anon_sym_BSLASHoplus);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(anon_sym_LPAREN_PLUS_RPAREN);
      END_STATE();
    case 472:
      ACCEPT_TOKEN(anon_sym_u2295);
      END_STATE();
    case 473:
      ACCEPT_TOKEN(anon_sym_BSLASHominus);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(anon_sym_LPAREN_DASH_RPAREN);
      END_STATE();
    case 475:
      ACCEPT_TOKEN(anon_sym_u2296);
      END_STATE();
    case 476:
      ACCEPT_TOKEN(sym_mod);
      if (lookahead == '%') ADVANCE(477);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(sym_modmod);
      END_STATE();
    case 478:
      ACCEPT_TOKEN(sym_vert);
      if (lookahead == '-') ADVANCE(401);
      if (lookahead == '=') ADVANCE(403);
      if (lookahead == '|') ADVANCE(480);
      END_STATE();
    case 479:
      ACCEPT_TOKEN(sym_vert);
      if (lookahead == '-') ADVANCE(400);
      if (lookahead == '=') ADVANCE(403);
      if (lookahead == '|') ADVANCE(480);
      END_STATE();
    case 480:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 481:
      ACCEPT_TOKEN(anon_sym_u2016);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(sym_minusminus);
      END_STATE();
    case 483:
      ACCEPT_TOKEN(sym_minusminus);
      if (lookahead == '-') ADVANCE(45);
      END_STATE();
    case 484:
      ACCEPT_TOKEN(sym_amp);
      if (lookahead == '&') ADVANCE(485);
      END_STATE();
    case 485:
      ACCEPT_TOKEN(sym_ampamp);
      END_STATE();
    case 486:
      ACCEPT_TOKEN(anon_sym_BSLASHodot);
      END_STATE();
    case 487:
      ACCEPT_TOKEN(anon_sym_LPAREN_DOT_RPAREN);
      END_STATE();
    case 488:
      ACCEPT_TOKEN(anon_sym_u2299);
      END_STATE();
    case 489:
      ACCEPT_TOKEN(anon_sym_BSLASHoslash);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(anon_sym_LPAREN_SLASH_RPAREN);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(anon_sym_u2298);
      END_STATE();
    case 492:
      ACCEPT_TOKEN(anon_sym_BSLASHotimes);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(anon_sym_LPAREN_BSLASHX_RPAREN);
      END_STATE();
    case 494:
      ACCEPT_TOKEN(anon_sym_u2297);
      END_STATE();
    case 495:
      ACCEPT_TOKEN(sym_mul);
      if (lookahead == '*') ADVANCE(496);
      END_STATE();
    case 496:
      ACCEPT_TOKEN(sym_mulmul);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(sym_slash);
      if (lookahead == '/') ADVANCE(498);
      if (lookahead == '=') ADVANCE(381);
      if (lookahead == '\\') ADVANCE(300);
      END_STATE();
    case 498:
      ACCEPT_TOKEN(sym_slashslash);
      END_STATE();
    case 499:
      ACCEPT_TOKEN(anon_sym_BSLASHbigcirc);
      END_STATE();
    case 500:
      ACCEPT_TOKEN(anon_sym_u25ef);
      END_STATE();
    case 501:
      ACCEPT_TOKEN(anon_sym_BSLASHbullet);
      END_STATE();
    case 502:
      ACCEPT_TOKEN(anon_sym_u25cf);
      END_STATE();
    case 503:
      ACCEPT_TOKEN(anon_sym_BSLASHdiv);
      END_STATE();
    case 504:
      ACCEPT_TOKEN(anon_sym_u00f7);
      END_STATE();
    case 505:
      ACCEPT_TOKEN(anon_sym_BSLASHcirc);
      END_STATE();
    case 506:
      ACCEPT_TOKEN(anon_sym_u2218);
      END_STATE();
    case 507:
      ACCEPT_TOKEN(anon_sym_BSLASHstar);
      END_STATE();
    case 508:
      ACCEPT_TOKEN(anon_sym_u22c6);
      END_STATE();
    case 509:
      ACCEPT_TOKEN(anon_sym_u203c);
      END_STATE();
    case 510:
      ACCEPT_TOKEN(sym_hashhash);
      END_STATE();
    case 511:
      ACCEPT_TOKEN(sym_dol);
      if (lookahead == '$') ADVANCE(512);
      END_STATE();
    case 512:
      ACCEPT_TOKEN(sym_doldol);
      END_STATE();
    case 513:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 514:
      ACCEPT_TOKEN(anon_sym_u2047);
      END_STATE();
    case 515:
      ACCEPT_TOKEN(anon_sym_BSLASHsqcap);
      END_STATE();
    case 516:
      ACCEPT_TOKEN(anon_sym_u2293);
      END_STATE();
    case 517:
      ACCEPT_TOKEN(anon_sym_BSLASHsqcup);
      END_STATE();
    case 518:
      ACCEPT_TOKEN(anon_sym_u2294);
      END_STATE();
    case 519:
      ACCEPT_TOKEN(anon_sym_BSLASHuplus);
      END_STATE();
    case 520:
      ACCEPT_TOKEN(anon_sym_u228e);
      END_STATE();
    case 521:
      ACCEPT_TOKEN(anon_sym_BSLASHX);
      END_STATE();
    case 522:
      ACCEPT_TOKEN(anon_sym_BSLASHtimes);
      END_STATE();
    case 523:
      ACCEPT_TOKEN(anon_sym_u00d7);
      END_STATE();
    case 524:
      ACCEPT_TOKEN(anon_sym_BSLASHwr);
      END_STATE();
    case 525:
      ACCEPT_TOKEN(anon_sym_u2240);
      END_STATE();
    case 526:
      ACCEPT_TOKEN(anon_sym_BSLASHcdot);
      END_STATE();
    case 527:
      ACCEPT_TOKEN(anon_sym_u22c5);
      END_STATE();
    case 528:
      ACCEPT_TOKEN(sym_pow);
      if (lookahead == '#') ADVANCE(533);
      if (lookahead == '*') ADVANCE(532);
      if (lookahead == '+') ADVANCE(530);
      if (lookahead == '^') ADVANCE(529);
      END_STATE();
    case 529:
      ACCEPT_TOKEN(sym_powpow);
      END_STATE();
    case 530:
      ACCEPT_TOKEN(anon_sym_CARET_PLUS);
      END_STATE();
    case 531:
      ACCEPT_TOKEN(anon_sym_u207a);
      END_STATE();
    case 532:
      ACCEPT_TOKEN(sym_asterisk);
      END_STATE();
    case 533:
      ACCEPT_TOKEN(sym_sup_hash);
      END_STATE();
    case 534:
      ACCEPT_TOKEN(sym_prime);
      END_STATE();
    case 535:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token1);
      END_STATE();
    case 536:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token1);
      if (lookahead == '_') ADVANCE(224);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(536);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 537:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(537);
      END_STATE();
    case 538:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 539:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token2);
      if (lookahead == '(') ADVANCE(38);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == '|') ADVANCE(540);
      END_STATE();
    case 540:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == '|') ADVANCE(540);
      END_STATE();
    case 541:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token3);
      if (lookahead == '(') ADVANCE(38);
      if (lookahead == '.') ADVANCE(542);
      END_STATE();
    case 542:
      ACCEPT_TOKEN(aux_sym_proof_step_id_token3);
      if (lookahead == '.') ADVANCE(542);
      END_STATE();
    case 543:
      ACCEPT_TOKEN(aux_sym_proof_step_ref_token1);
      END_STATE();
    case 544:
      ACCEPT_TOKEN(aux_sym_proof_step_ref_token1);
      if (lookahead == '_') ADVANCE(224);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(544);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(304);
      END_STATE();
    case 545:
      ACCEPT_TOKEN(aux_sym_proof_step_ref_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == '|') ADVANCE(545);
      END_STATE();
    case 546:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 547:
      ACCEPT_TOKEN(anon_sym_DASH_DASHalgorithm);
      END_STATE();
    case 548:
      ACCEPT_TOKEN(anon_sym_DASH_DASHfair);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '\r') SKIP(0);
      if (lookahead == 'A') ADVANCE(1);
      if (lookahead == 'B') ADVANCE(2);
      if (lookahead == 'C') ADVANCE(3);
      if (lookahead == 'D') ADVANCE(4);
      if (lookahead == 'E') ADVANCE(5);
      if (lookahead == 'F') ADVANCE(6);
      if (lookahead == 'H') ADVANCE(7);
      if (lookahead == 'I') ADVANCE(8);
      if (lookahead == 'L') ADVANCE(9);
      if (lookahead == 'M') ADVANCE(10);
      if (lookahead == 'N') ADVANCE(11);
      if (lookahead == 'O') ADVANCE(12);
      if (lookahead == 'P') ADVANCE(13);
      if (lookahead == 'Q') ADVANCE(14);
      if (lookahead == 'R') ADVANCE(15);
      if (lookahead == 'S') ADVANCE(16);
      if (lookahead == 'T') ADVANCE(17);
      if (lookahead == 'U') ADVANCE(18);
      if (lookahead == 'V') ADVANCE(19);
      if (lookahead == 'W') ADVANCE(20);
      if (lookahead == 'a') ADVANCE(21);
      if (lookahead == 'b') ADVANCE(22);
      if (lookahead == 'c') ADVANCE(23);
      if (lookahead == 'd') ADVANCE(24);
      if (lookahead == 'e') ADVANCE(25);
      if (lookahead == 'f') ADVANCE(26);
      if (lookahead == 'g') ADVANCE(27);
      if (lookahead == 'i') ADVANCE(28);
      if (lookahead == 'm') ADVANCE(29);
      if (lookahead == 'o') ADVANCE(30);
      if (lookahead == 'p') ADVANCE(31);
      if (lookahead == 'r') ADVANCE(32);
      if (lookahead == 's') ADVANCE(33);
      if (lookahead == 't') ADVANCE(34);
      if (lookahead == 'v') ADVANCE(35);
      if (lookahead == 'w') ADVANCE(36);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'C') ADVANCE(37);
      if (lookahead == 'S') ADVANCE(38);
      if (lookahead == 'X') ADVANCE(39);
      END_STATE();
    case 2:
      if (lookahead == 'O') ADVANCE(40);
      if (lookahead == 'Y') ADVANCE(41);
      END_STATE();
    case 3:
      if (lookahead == 'A') ADVANCE(42);
      if (lookahead == 'H') ADVANCE(43);
      if (lookahead == 'O') ADVANCE(44);
      END_STATE();
    case 4:
      if (lookahead == 'E') ADVANCE(45);
      if (lookahead == 'O') ADVANCE(46);
      END_STATE();
    case 5:
      if (lookahead == 'L') ADVANCE(47);
      if (lookahead == 'N') ADVANCE(48);
      if (lookahead == 'X') ADVANCE(49);
      END_STATE();
    case 6:
      if (lookahead == 'A') ADVANCE(50);
      END_STATE();
    case 7:
      if (lookahead == 'A') ADVANCE(51);
      if (lookahead == 'I') ADVANCE(52);
      END_STATE();
    case 8:
      if (lookahead == 'F') ADVANCE(53);
      if (lookahead == 'N') ADVANCE(54);
      if (lookahead == 'n') ADVANCE(55);
      END_STATE();
    case 9:
      if (lookahead == 'A') ADVANCE(56);
      if (lookahead == 'E') ADVANCE(57);
      if (lookahead == 'O') ADVANCE(58);
      END_STATE();
    case 10:
      if (lookahead == 'O') ADVANCE(59);
      END_STATE();
    case 11:
      if (lookahead == 'E') ADVANCE(60);
      if (lookahead == 'a') ADVANCE(61);
      END_STATE();
    case 12:
      if (lookahead == 'B') ADVANCE(62);
      if (lookahead == 'M') ADVANCE(63);
      if (lookahead == 'N') ADVANCE(64);
      if (lookahead == 'T') ADVANCE(65);
      END_STATE();
    case 13:
      if (lookahead == 'I') ADVANCE(66);
      if (lookahead == 'R') ADVANCE(67);
      END_STATE();
    case 14:
      if (lookahead == 'E') ADVANCE(68);
      END_STATE();
    case 15:
      if (lookahead == 'E') ADVANCE(69);
      if (lookahead == 'e') ADVANCE(70);
      END_STATE();
    case 16:
      if (lookahead == 'F') ADVANCE(71);
      if (lookahead == 'T') ADVANCE(72);
      if (lookahead == 'U') ADVANCE(73);
      END_STATE();
    case 17:
      if (lookahead == 'A') ADVANCE(74);
      if (lookahead == 'E') ADVANCE(75);
      if (lookahead == 'H') ADVANCE(76);
      if (lookahead == 'R') ADVANCE(77);
      END_STATE();
    case 18:
      if (lookahead == 'N') ADVANCE(78);
      if (lookahead == 'S') ADVANCE(79);
      END_STATE();
    case 19:
      if (lookahead == 'A') ADVANCE(80);
      END_STATE();
    case 20:
      if (lookahead == 'F') ADVANCE(81);
      if (lookahead == 'I') ADVANCE(82);
      END_STATE();
    case 21:
      if (lookahead == 'l') ADVANCE(83);
      if (lookahead == 's') ADVANCE(84);
      if (lookahead == 'w') ADVANCE(85);
      END_STATE();
    case 22:
      if (lookahead == 'e') ADVANCE(86);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(87);
      END_STATE();
    case 24:
      if (lookahead == 'e') ADVANCE(88);
      if (lookahead == 'o') ADVANCE(89);
      END_STATE();
    case 25:
      if (lookahead == 'i') ADVANCE(90);
      if (lookahead == 'l') ADVANCE(91);
      if (lookahead == 'n') ADVANCE(92);
      END_STATE();
    case 26:
      if (lookahead == 'a') ADVANCE(93);
      END_STATE();
    case 27:
      if (lookahead == 'o') ADVANCE(94);
      END_STATE();
    case 28:
      if (lookahead == 'f') ADVANCE(95);
      END_STATE();
    case 29:
      if (lookahead == 'a') ADVANCE(96);
      END_STATE();
    case 30:
      if (lookahead == 'r') ADVANCE(97);
      END_STATE();
    case 31:
      if (lookahead == 'r') ADVANCE(98);
      END_STATE();
    case 32:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 33:
      if (lookahead == 'k') ADVANCE(100);
      END_STATE();
    case 34:
      if (lookahead == 'h') ADVANCE(101);
      END_STATE();
    case 35:
      if (lookahead == 'a') ADVANCE(102);
      END_STATE();
    case 36:
      if (lookahead == 'h') ADVANCE(103);
      if (lookahead == 'i') ADVANCE(104);
      END_STATE();
    case 37:
      if (lookahead == 'T') ADVANCE(105);
      END_STATE();
    case 38:
      if (lookahead == 'S') ADVANCE(106);
      END_STATE();
    case 39:
      if (lookahead == 'I') ADVANCE(107);
      END_STATE();
    case 40:
      if (lookahead == 'O') ADVANCE(108);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_BY);
      END_STATE();
    case 42:
      if (lookahead == 'S') ADVANCE(109);
      END_STATE();
    case 43:
      if (lookahead == 'O') ADVANCE(110);
      END_STATE();
    case 44:
      if (lookahead == 'N') ADVANCE(111);
      if (lookahead == 'R') ADVANCE(112);
      END_STATE();
    case 45:
      if (lookahead == 'F') ADVANCE(113);
      END_STATE();
    case 46:
      if (lookahead == 'M') ADVANCE(114);
      END_STATE();
    case 47:
      if (lookahead == 'S') ADVANCE(115);
      END_STATE();
    case 48:
      if (lookahead == 'A') ADVANCE(116);
      END_STATE();
    case 49:
      if (lookahead == 'C') ADVANCE(117);
      if (lookahead == 'T') ADVANCE(118);
      END_STATE();
    case 50:
      if (lookahead == 'L') ADVANCE(119);
      END_STATE();
    case 51:
      if (lookahead == 'V') ADVANCE(120);
      END_STATE();
    case 52:
      if (lookahead == 'D') ADVANCE(121);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_IF);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_IN);
      if (lookahead == 'S') ADVANCE(122);
      END_STATE();
    case 55:
      if (lookahead == 't') ADVANCE(123);
      END_STATE();
    case 56:
      if (lookahead == 'M') ADVANCE(124);
      END_STATE();
    case 57:
      if (lookahead == 'M') ADVANCE(125);
      if (lookahead == 'T') ADVANCE(126);
      END_STATE();
    case 58:
      if (lookahead == 'C') ADVANCE(127);
      END_STATE();
    case 59:
      if (lookahead == 'D') ADVANCE(128);
      END_STATE();
    case 60:
      if (lookahead == 'W') ADVANCE(129);
      END_STATE();
    case 61:
      if (lookahead == 't') ADVANCE(130);
      END_STATE();
    case 62:
      if (lookahead == 'V') ADVANCE(131);
      END_STATE();
    case 63:
      if (lookahead == 'I') ADVANCE(132);
      END_STATE();
    case 64:
      if (lookahead == 'L') ADVANCE(133);
      END_STATE();
    case 65:
      if (lookahead == 'H') ADVANCE(134);
      END_STATE();
    case 66:
      if (lookahead == 'C') ADVANCE(135);
      END_STATE();
    case 67:
      if (lookahead == 'O') ADVANCE(136);
      END_STATE();
    case 68:
      if (lookahead == 'D') ADVANCE(137);
      END_STATE();
    case 69:
      if (lookahead == 'C') ADVANCE(138);
      END_STATE();
    case 70:
      if (lookahead == 'a') ADVANCE(139);
      END_STATE();
    case 71:
      if (lookahead == '_') ADVANCE(140);
      END_STATE();
    case 72:
      if (lookahead == 'A') ADVANCE(141);
      if (lookahead == 'R') ADVANCE(142);
      END_STATE();
    case 73:
      if (lookahead == 'B') ADVANCE(143);
      if (lookahead == 'F') ADVANCE(144);
      END_STATE();
    case 74:
      if (lookahead == 'K') ADVANCE(145);
      END_STATE();
    case 75:
      if (lookahead == 'M') ADVANCE(146);
      END_STATE();
    case 76:
      if (lookahead == 'E') ADVANCE(147);
      END_STATE();
    case 77:
      if (lookahead == 'U') ADVANCE(148);
      END_STATE();
    case 78:
      if (lookahead == 'C') ADVANCE(149);
      if (lookahead == 'I') ADVANCE(150);
      END_STATE();
    case 79:
      if (lookahead == 'E') ADVANCE(151);
      END_STATE();
    case 80:
      if (lookahead == 'R') ADVANCE(152);
      END_STATE();
    case 81:
      if (lookahead == '_') ADVANCE(153);
      END_STATE();
    case 82:
      if (lookahead == 'T') ADVANCE(154);
      END_STATE();
    case 83:
      if (lookahead == 'g') ADVANCE(155);
      END_STATE();
    case 84:
      if (lookahead == 's') ADVANCE(156);
      END_STATE();
    case 85:
      if (lookahead == 'a') ADVANCE(157);
      END_STATE();
    case 86:
      if (lookahead == 'g') ADVANCE(158);
      END_STATE();
    case 87:
      if (lookahead == 'l') ADVANCE(159);
      END_STATE();
    case 88:
      if (lookahead == 'f') ADVANCE(160);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 90:
      if (lookahead == 't') ADVANCE(161);
      END_STATE();
    case 91:
      if (lookahead == 's') ADVANCE(162);
      END_STATE();
    case 92:
      if (lookahead == 'd') ADVANCE(163);
      END_STATE();
    case 93:
      if (lookahead == 'i') ADVANCE(164);
      END_STATE();
    case 94:
      if (lookahead == 't') ADVANCE(165);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 96:
      if (lookahead == 'c') ADVANCE(166);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 98:
      if (lookahead == 'i') ADVANCE(167);
      if (lookahead == 'o') ADVANCE(168);
      END_STATE();
    case 99:
      if (lookahead == 't') ADVANCE(169);
      END_STATE();
    case 100:
      if (lookahead == 'i') ADVANCE(170);
      END_STATE();
    case 101:
      if (lookahead == 'e') ADVANCE(171);
      END_STATE();
    case 102:
      if (lookahead == 'r') ADVANCE(172);
      END_STATE();
    case 103:
      if (lookahead == 'e') ADVANCE(173);
      if (lookahead == 'i') ADVANCE(174);
      END_STATE();
    case 104:
      if (lookahead == 't') ADVANCE(175);
      END_STATE();
    case 105:
      if (lookahead == 'I') ADVANCE(176);
      END_STATE();
    case 106:
      if (lookahead == 'U') ADVANCE(177);
      END_STATE();
    case 107:
      if (lookahead == 'O') ADVANCE(178);
      END_STATE();
    case 108:
      if (lookahead == 'L') ADVANCE(179);
      END_STATE();
    case 109:
      if (lookahead == 'E') ADVANCE(180);
      END_STATE();
    case 110:
      if (lookahead == 'O') ADVANCE(181);
      END_STATE();
    case 111:
      if (lookahead == 'S') ADVANCE(182);
      END_STATE();
    case 112:
      if (lookahead == 'O') ADVANCE(183);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_DEF);
      if (lookahead == 'I') ADVANCE(184);
      if (lookahead == 'S') ADVANCE(185);
      END_STATE();
    case 114:
      if (lookahead == 'A') ADVANCE(186);
      END_STATE();
    case 115:
      if (lookahead == 'E') ADVANCE(187);
      END_STATE();
    case 116:
      if (lookahead == 'B') ADVANCE(188);
      END_STATE();
    case 117:
      if (lookahead == 'E') ADVANCE(189);
      END_STATE();
    case 118:
      if (lookahead == 'E') ADVANCE(190);
      END_STATE();
    case 119:
      if (lookahead == 'S') ADVANCE(191);
      END_STATE();
    case 120:
      if (lookahead == 'E') ADVANCE(192);
      END_STATE();
    case 121:
      if (lookahead == 'E') ADVANCE(193);
      END_STATE();
    case 122:
      if (lookahead == 'T') ADVANCE(194);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_Int);
      END_STATE();
    case 124:
      if (lookahead == 'B') ADVANCE(195);
      END_STATE();
    case 125:
      if (lookahead == 'M') ADVANCE(196);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_LET);
      END_STATE();
    case 127:
      if (lookahead == 'A') ADVANCE(197);
      END_STATE();
    case 128:
      if (lookahead == 'U') ADVANCE(198);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_NEW);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_Nat);
      END_STATE();
    case 131:
      if (lookahead == 'I') ADVANCE(199);
      END_STATE();
    case 132:
      if (lookahead == 'T') ADVANCE(200);
      END_STATE();
    case 133:
      if (lookahead == 'Y') ADVANCE(201);
      END_STATE();
    case 134:
      if (lookahead == 'E') ADVANCE(202);
      END_STATE();
    case 135:
      if (lookahead == 'K') ADVANCE(203);
      END_STATE();
    case 136:
      if (lookahead == 'O') ADVANCE(204);
      if (lookahead == 'P') ADVANCE(205);
      if (lookahead == 'V') ADVANCE(206);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_QED);
      END_STATE();
    case 138:
      if (lookahead == 'U') ADVANCE(207);
      END_STATE();
    case 139:
      if (lookahead == 'l') ADVANCE(208);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_SF_);
      END_STATE();
    case 141:
      if (lookahead == 'T') ADVANCE(209);
      END_STATE();
    case 142:
      if (lookahead == 'I') ADVANCE(210);
      END_STATE();
    case 143:
      if (lookahead == 'S') ADVANCE(211);
      END_STATE();
    case 144:
      if (lookahead == 'F') ADVANCE(212);
      END_STATE();
    case 145:
      if (lookahead == 'E') ADVANCE(213);
      END_STATE();
    case 146:
      if (lookahead == 'P') ADVANCE(214);
      END_STATE();
    case 147:
      if (lookahead == 'N') ADVANCE(215);
      if (lookahead == 'O') ADVANCE(216);
      END_STATE();
    case 148:
      if (lookahead == 'E') ADVANCE(217);
      END_STATE();
    case 149:
      if (lookahead == 'H') ADVANCE(218);
      END_STATE();
    case 150:
      if (lookahead == 'O') ADVANCE(219);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_USE);
      END_STATE();
    case 152:
      if (lookahead == 'I') ADVANCE(220);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_WF_);
      END_STATE();
    case 154:
      if (lookahead == 'H') ADVANCE(221);
      if (lookahead == 'N') ADVANCE(222);
      END_STATE();
    case 155:
      if (lookahead == 'o') ADVANCE(223);
      END_STATE();
    case 156:
      if (lookahead == 'e') ADVANCE(224);
      END_STATE();
    case 157:
      if (lookahead == 'i') ADVANCE(225);
      END_STATE();
    case 158:
      if (lookahead == 'i') ADVANCE(226);
      END_STATE();
    case 159:
      if (lookahead == 'l') ADVANCE(227);
      END_STATE();
    case 160:
      if (lookahead == 'i') ADVANCE(228);
      END_STATE();
    case 161:
      if (lookahead == 'h') ADVANCE(229);
      END_STATE();
    case 162:
      if (lookahead == 'e') ADVANCE(230);
      if (lookahead == 'i') ADVANCE(231);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_end);
      END_STATE();
    case 164:
      if (lookahead == 'r') ADVANCE(232);
      END_STATE();
    case 165:
      if (lookahead == 'o') ADVANCE(233);
      END_STATE();
    case 166:
      if (lookahead == 'r') ADVANCE(234);
      END_STATE();
    case 167:
      if (lookahead == 'n') ADVANCE(235);
      END_STATE();
    case 168:
      if (lookahead == 'c') ADVANCE(236);
      END_STATE();
    case 169:
      if (lookahead == 'u') ADVANCE(237);
      END_STATE();
    case 170:
      if (lookahead == 'p') ADVANCE(238);
      END_STATE();
    case 171:
      if (lookahead == 'n') ADVANCE(239);
      END_STATE();
    case 172:
      if (lookahead == 'i') ADVANCE(240);
      END_STATE();
    case 173:
      if (lookahead == 'n') ADVANCE(241);
      END_STATE();
    case 174:
      if (lookahead == 'l') ADVANCE(242);
      END_STATE();
    case 175:
      if (lookahead == 'h') ADVANCE(243);
      END_STATE();
    case 176:
      if (lookahead == 'O') ADVANCE(244);
      END_STATE();
    case 177:
      if (lookahead == 'M') ADVANCE(245);
      END_STATE();
    case 178:
      if (lookahead == 'M') ADVANCE(246);
      END_STATE();
    case 179:
      if (lookahead == 'E') ADVANCE(247);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_CASE);
      END_STATE();
    case 181:
      if (lookahead == 'S') ADVANCE(248);
      END_STATE();
    case 182:
      if (lookahead == 'T') ADVANCE(249);
      END_STATE();
    case 183:
      if (lookahead == 'L') ADVANCE(250);
      END_STATE();
    case 184:
      if (lookahead == 'N') ADVANCE(251);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_DEFS);
      END_STATE();
    case 186:
      if (lookahead == 'I') ADVANCE(252);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_ELSE);
      END_STATE();
    case 188:
      if (lookahead == 'L') ADVANCE(253);
      END_STATE();
    case 189:
      if (lookahead == 'P') ADVANCE(254);
      END_STATE();
    case 190:
      if (lookahead == 'N') ADVANCE(255);
      END_STATE();
    case 191:
      if (lookahead == 'E') ADVANCE(256);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_HAVE);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_HIDE);
      END_STATE();
    case 194:
      if (lookahead == 'A') ADVANCE(257);
      END_STATE();
    case 195:
      if (lookahead == 'D') ADVANCE(258);
      END_STATE();
    case 196:
      if (lookahead == 'A') ADVANCE(259);
      END_STATE();
    case 197:
      if (lookahead == 'L') ADVANCE(260);
      END_STATE();
    case 198:
      if (lookahead == 'L') ADVANCE(261);
      END_STATE();
    case 199:
      if (lookahead == 'O') ADVANCE(262);
      END_STATE();
    case 200:
      if (lookahead == 'T') ADVANCE(263);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_ONLY);
      END_STATE();
    case 202:
      if (lookahead == 'R') ADVANCE(264);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_PICK);
      END_STATE();
    case 204:
      if (lookahead == 'F') ADVANCE(265);
      END_STATE();
    case 205:
      if (lookahead == 'O') ADVANCE(266);
      END_STATE();
    case 206:
      if (lookahead == 'E') ADVANCE(267);
      END_STATE();
    case 207:
      if (lookahead == 'R') ADVANCE(268);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_Real);
      END_STATE();
    case 209:
      if (lookahead == 'E') ADVANCE(269);
      END_STATE();
    case 210:
      if (lookahead == 'N') ADVANCE(270);
      END_STATE();
    case 211:
      if (lookahead == 'E') ADVANCE(271);
      END_STATE();
    case 212:
      if (lookahead == 'I') ADVANCE(272);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_TAKE);
      END_STATE();
    case 214:
      if (lookahead == 'O') ADVANCE(273);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_THEN);
      END_STATE();
    case 216:
      if (lookahead == 'R') ADVANCE(274);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_TRUE);
      END_STATE();
    case 218:
      if (lookahead == 'A') ADVANCE(275);
      END_STATE();
    case 219:
      if (lookahead == 'N') ADVANCE(276);
      END_STATE();
    case 220:
      if (lookahead == 'A') ADVANCE(277);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_WITH);
      END_STATE();
    case 222:
      if (lookahead == 'E') ADVANCE(278);
      END_STATE();
    case 223:
      if (lookahead == 'r') ADVANCE(279);
      END_STATE();
    case 224:
      if (lookahead == 'r') ADVANCE(280);
      END_STATE();
    case 225:
      if (lookahead == 't') ADVANCE(281);
      END_STATE();
    case 226:
      if (lookahead == 'n') ADVANCE(282);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_call);
      END_STATE();
    case 228:
      if (lookahead == 'n') ADVANCE(283);
      END_STATE();
    case 229:
      if (lookahead == 'e') ADVANCE(284);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 231:
      if (lookahead == 'f') ADVANCE(285);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_fair);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_goto);
      END_STATE();
    case 234:
      if (lookahead == 'o') ADVANCE(286);
      END_STATE();
    case 235:
      if (lookahead == 't') ADVANCE(287);
      END_STATE();
    case 236:
      if (lookahead == 'e') ADVANCE(288);
      END_STATE();
    case 237:
      if (lookahead == 'r') ADVANCE(289);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_pcal_skip);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 240:
      if (lookahead == 'a') ADVANCE(290);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_when);
      END_STATE();
    case 242:
      if (lookahead == 'e') ADVANCE(291);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 244:
      if (lookahead == 'N') ADVANCE(292);
      END_STATE();
    case 245:
      if (lookahead == 'E') ADVANCE(293);
      if (lookahead == 'P') ADVANCE(294);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_AXIOM);
      END_STATE();
    case 247:
      if (lookahead == 'A') ADVANCE(295);
      END_STATE();
    case 248:
      if (lookahead == 'E') ADVANCE(296);
      END_STATE();
    case 249:
      if (lookahead == 'A') ADVANCE(297);
      END_STATE();
    case 250:
      if (lookahead == 'L') ADVANCE(298);
      END_STATE();
    case 251:
      if (lookahead == 'E') ADVANCE(299);
      END_STATE();
    case 252:
      if (lookahead == 'N') ADVANCE(300);
      END_STATE();
    case 253:
      if (lookahead == 'E') ADVANCE(301);
      END_STATE();
    case 254:
      if (lookahead == 'T') ADVANCE(302);
      END_STATE();
    case 255:
      if (lookahead == 'D') ADVANCE(303);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_FALSE);
      END_STATE();
    case 257:
      if (lookahead == 'N') ADVANCE(304);
      END_STATE();
    case 258:
      if (lookahead == 'A') ADVANCE(305);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_LEMMA);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_LOCAL);
      END_STATE();
    case 261:
      if (lookahead == 'E') ADVANCE(306);
      END_STATE();
    case 262:
      if (lookahead == 'U') ADVANCE(307);
      END_STATE();
    case 263:
      if (lookahead == 'E') ADVANCE(308);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_OTHER);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_PROOF);
      END_STATE();
    case 266:
      if (lookahead == 'S') ADVANCE(309);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_PROVE);
      END_STATE();
    case 268:
      if (lookahead == 'S') ADVANCE(310);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_STATE);
      END_STATE();
    case 270:
      if (lookahead == 'G') ADVANCE(311);
      END_STATE();
    case 271:
      if (lookahead == 'T') ADVANCE(312);
      END_STATE();
    case 272:
      if (lookahead == 'C') ADVANCE(313);
      END_STATE();
    case 273:
      if (lookahead == 'R') ADVANCE(314);
      END_STATE();
    case 274:
      if (lookahead == 'E') ADVANCE(315);
      END_STATE();
    case 275:
      if (lookahead == 'N') ADVANCE(316);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_union);
      END_STATE();
    case 277:
      if (lookahead == 'B') ADVANCE(317);
      END_STATE();
    case 278:
      if (lookahead == 'S') ADVANCE(318);
      END_STATE();
    case 279:
      if (lookahead == 'i') ADVANCE(319);
      END_STATE();
    case 280:
      if (lookahead == 't') ADVANCE(320);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_begin);
      END_STATE();
    case 283:
      if (lookahead == 'e') ADVANCE(321);
      END_STATE();
    case 284:
      if (lookahead == 'r') ADVANCE(322);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_elsif);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_macro);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_print);
      END_STATE();
    case 288:
      if (lookahead == 'd') ADVANCE(323);
      if (lookahead == 's') ADVANCE(324);
      END_STATE();
    case 289:
      if (lookahead == 'n') ADVANCE(325);
      END_STATE();
    case 290:
      if (lookahead == 'b') ADVANCE(326);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_ACTION);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_ASSUME);
      END_STATE();
    case 294:
      if (lookahead == 'T') ADVANCE(327);
      END_STATE();
    case 295:
      if (lookahead == 'N') ADVANCE(328);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_CHOOSE);
      END_STATE();
    case 297:
      if (lookahead == 'N') ADVANCE(329);
      END_STATE();
    case 298:
      if (lookahead == 'A') ADVANCE(330);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_DEFINE);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_domain);
      END_STATE();
    case 301:
      if (lookahead == 'D') ADVANCE(331);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_EXCEPT);
      END_STATE();
    case 303:
      if (lookahead == 'S') ADVANCE(332);
      END_STATE();
    case 304:
      if (lookahead == 'C') ADVANCE(333);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_LAMBDA);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_MODULE);
      END_STATE();
    case 307:
      if (lookahead == 'S') ADVANCE(334);
      END_STATE();
    case 308:
      if (lookahead == 'D') ADVANCE(335);
      END_STATE();
    case 309:
      if (lookahead == 'I') ADVANCE(336);
      END_STATE();
    case 310:
      if (lookahead == 'I') ADVANCE(337);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym_string_set);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym_powerset);
      END_STATE();
    case 313:
      if (lookahead == 'E') ADVANCE(338);
      END_STATE();
    case 314:
      if (lookahead == 'A') ADVANCE(339);
      END_STATE();
    case 315:
      if (lookahead == 'M') ADVANCE(340);
      END_STATE();
    case 316:
      if (lookahead == 'G') ADVANCE(341);
      END_STATE();
    case 317:
      if (lookahead == 'L') ADVANCE(342);
      END_STATE();
    case 318:
      if (lookahead == 'S') ADVANCE(343);
      END_STATE();
    case 319:
      if (lookahead == 't') ADVANCE(344);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_define);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(anon_sym_either);
      END_STATE();
    case 323:
      if (lookahead == 'u') ADVANCE(345);
      END_STATE();
    case 324:
      if (lookahead == 's') ADVANCE(346);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym_pcal_return);
      END_STATE();
    case 326:
      if (lookahead == 'l') ADVANCE(347);
      END_STATE();
    case 327:
      if (lookahead == 'I') ADVANCE(348);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym_boolean_set);
      END_STATE();
    case 329:
      if (lookahead == 'T') ADVANCE(349);
      END_STATE();
    case 330:
      if (lookahead == 'R') ADVANCE(350);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym_enabled);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(anon_sym_EXTENDS);
      END_STATE();
    case 333:
      if (lookahead == 'E') ADVANCE(351);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(anon_sym_OBVIOUS);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(anon_sym_OMITTED);
      END_STATE();
    case 336:
      if (lookahead == 'T') ADVANCE(352);
      END_STATE();
    case 337:
      if (lookahead == 'V') ADVANCE(353);
      END_STATE();
    case 338:
      if (lookahead == 'S') ADVANCE(354);
      END_STATE();
    case 339:
      if (lookahead == 'L') ADVANCE(355);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(anon_sym_THEOREM);
      END_STATE();
    case 341:
      if (lookahead == 'E') ADVANCE(356);
      END_STATE();
    case 342:
      if (lookahead == 'E') ADVANCE(357);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(anon_sym_WITNESS);
      END_STATE();
    case 344:
      if (lookahead == 'h') ADVANCE(358);
      END_STATE();
    case 345:
      if (lookahead == 'r') ADVANCE(359);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(anon_sym_process);
      END_STATE();
    case 347:
      if (lookahead == 'e') ADVANCE(360);
      END_STATE();
    case 348:
      if (lookahead == 'O') ADVANCE(361);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(anon_sym_CONSTANT);
      if (lookahead == 'S') ADVANCE(362);
      END_STATE();
    case 350:
      if (lookahead == 'Y') ADVANCE(363);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(anon_sym_INSTANCE);
      END_STATE();
    case 352:
      if (lookahead == 'I') ADVANCE(364);
      END_STATE();
    case 353:
      if (lookahead == 'E') ADVANCE(365);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(anon_sym_SUFFICES);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(anon_sym_TEMPORAL);
      END_STATE();
    case 356:
      if (lookahead == 'D') ADVANCE(366);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(anon_sym_VARIABLE);
      if (lookahead == 'S') ADVANCE(367);
      END_STATE();
    case 358:
      if (lookahead == 'm') ADVANCE(368);
      END_STATE();
    case 359:
      if (lookahead == 'e') ADVANCE(369);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(anon_sym_variable);
      if (lookahead == 's') ADVANCE(370);
      END_STATE();
    case 361:
      if (lookahead == 'N') ADVANCE(371);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(anon_sym_CONSTANTS);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(anon_sym_COROLLARY);
      END_STATE();
    case 364:
      if (lookahead == 'O') ADVANCE(372);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(anon_sym_RECURSIVE);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym_unchanged);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(anon_sym_VARIABLES);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(anon_sym_algorithm);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(anon_sym_procedure);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(anon_sym_variables);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(anon_sym_ASSUMPTION);
      END_STATE();
    case 372:
      if (lookahead == 'N') ADVANCE(373);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(anon_sym_PROPOSITION);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 226, .external_lex_state = 2},
  [2] = {.lex_state = 4, .external_lex_state = 3},
  [3] = {.lex_state = 4, .external_lex_state = 3},
  [4] = {.lex_state = 4, .external_lex_state = 3},
  [5] = {.lex_state = 4, .external_lex_state = 4},
  [6] = {.lex_state = 5, .external_lex_state = 4},
  [7] = {.lex_state = 5, .external_lex_state = 4},
  [8] = {.lex_state = 228, .external_lex_state = 4},
  [9] = {.lex_state = 5, .external_lex_state = 4},
  [10] = {.lex_state = 228, .external_lex_state = 4},
  [11] = {.lex_state = 228, .external_lex_state = 4},
  [12] = {.lex_state = 4, .external_lex_state = 4},
  [13] = {.lex_state = 4, .external_lex_state = 4},
  [14] = {.lex_state = 4, .external_lex_state = 4},
  [15] = {.lex_state = 4, .external_lex_state = 4},
  [16] = {.lex_state = 4, .external_lex_state = 4},
  [17] = {.lex_state = 4, .external_lex_state = 4},
  [18] = {.lex_state = 4, .external_lex_state = 4},
  [19] = {.lex_state = 4, .external_lex_state = 4},
  [20] = {.lex_state = 4, .external_lex_state = 4},
  [21] = {.lex_state = 4, .external_lex_state = 4},
  [22] = {.lex_state = 4, .external_lex_state = 4},
  [23] = {.lex_state = 4, .external_lex_state = 4},
  [24] = {.lex_state = 4, .external_lex_state = 4},
  [25] = {.lex_state = 4, .external_lex_state = 4},
  [26] = {.lex_state = 4, .external_lex_state = 4},
  [27] = {.lex_state = 4, .external_lex_state = 4},
  [28] = {.lex_state = 4, .external_lex_state = 4},
  [29] = {.lex_state = 4, .external_lex_state = 4},
  [30] = {.lex_state = 4, .external_lex_state = 4},
  [31] = {.lex_state = 4, .external_lex_state = 4},
  [32] = {.lex_state = 4, .external_lex_state = 4},
  [33] = {.lex_state = 4, .external_lex_state = 4},
  [34] = {.lex_state = 4, .external_lex_state = 4},
  [35] = {.lex_state = 4, .external_lex_state = 4},
  [36] = {.lex_state = 4, .external_lex_state = 4},
  [37] = {.lex_state = 4, .external_lex_state = 4},
  [38] = {.lex_state = 4, .external_lex_state = 4},
  [39] = {.lex_state = 4, .external_lex_state = 4},
  [40] = {.lex_state = 4, .external_lex_state = 4},
  [41] = {.lex_state = 4, .external_lex_state = 4},
  [42] = {.lex_state = 4, .external_lex_state = 4},
  [43] = {.lex_state = 4, .external_lex_state = 4},
  [44] = {.lex_state = 4, .external_lex_state = 4},
  [45] = {.lex_state = 6, .external_lex_state = 4},
  [46] = {.lex_state = 4, .external_lex_state = 4},
  [47] = {.lex_state = 4, .external_lex_state = 4},
  [48] = {.lex_state = 4, .external_lex_state = 4},
  [49] = {.lex_state = 4, .external_lex_state = 4},
  [50] = {.lex_state = 4, .external_lex_state = 4},
  [51] = {.lex_state = 4, .external_lex_state = 4},
  [52] = {.lex_state = 4, .external_lex_state = 4},
  [53] = {.lex_state = 4, .external_lex_state = 4},
  [54] = {.lex_state = 6, .external_lex_state = 4},
  [55] = {.lex_state = 4, .external_lex_state = 4},
  [56] = {.lex_state = 4, .external_lex_state = 4},
  [57] = {.lex_state = 4, .external_lex_state = 4},
  [58] = {.lex_state = 4, .external_lex_state = 4},
  [59] = {.lex_state = 4, .external_lex_state = 4},
  [60] = {.lex_state = 4, .external_lex_state = 4},
  [61] = {.lex_state = 6, .external_lex_state = 4},
  [62] = {.lex_state = 6, .external_lex_state = 4},
  [63] = {.lex_state = 4, .external_lex_state = 4},
  [64] = {.lex_state = 4, .external_lex_state = 4},
  [65] = {.lex_state = 4, .external_lex_state = 4},
  [66] = {.lex_state = 6, .external_lex_state = 4},
  [67] = {.lex_state = 4, .external_lex_state = 4},
  [68] = {.lex_state = 6, .external_lex_state = 4},
  [69] = {.lex_state = 6, .external_lex_state = 4},
  [70] = {.lex_state = 6, .external_lex_state = 4},
  [71] = {.lex_state = 6, .external_lex_state = 4},
  [72] = {.lex_state = 6, .external_lex_state = 4},
  [73] = {.lex_state = 6, .external_lex_state = 4},
  [74] = {.lex_state = 6, .external_lex_state = 4},
  [75] = {.lex_state = 6, .external_lex_state = 4},
  [76] = {.lex_state = 6, .external_lex_state = 4},
  [77] = {.lex_state = 6, .external_lex_state = 4},
  [78] = {.lex_state = 6, .external_lex_state = 4},
  [79] = {.lex_state = 6, .external_lex_state = 4},
  [80] = {.lex_state = 6, .external_lex_state = 4},
  [81] = {.lex_state = 6, .external_lex_state = 4},
  [82] = {.lex_state = 4, .external_lex_state = 4},
  [83] = {.lex_state = 4, .external_lex_state = 4},
  [84] = {.lex_state = 4, .external_lex_state = 4},
  [85] = {.lex_state = 4, .external_lex_state = 4},
  [86] = {.lex_state = 4, .external_lex_state = 4},
  [87] = {.lex_state = 4, .external_lex_state = 4},
  [88] = {.lex_state = 4, .external_lex_state = 4},
  [89] = {.lex_state = 4, .external_lex_state = 4},
  [90] = {.lex_state = 4, .external_lex_state = 4},
  [91] = {.lex_state = 4, .external_lex_state = 4},
  [92] = {.lex_state = 4, .external_lex_state = 4},
  [93] = {.lex_state = 4, .external_lex_state = 4},
  [94] = {.lex_state = 4, .external_lex_state = 4},
  [95] = {.lex_state = 4, .external_lex_state = 4},
  [96] = {.lex_state = 4, .external_lex_state = 4},
  [97] = {.lex_state = 4, .external_lex_state = 4},
  [98] = {.lex_state = 4, .external_lex_state = 4},
  [99] = {.lex_state = 4, .external_lex_state = 4},
  [100] = {.lex_state = 4, .external_lex_state = 4},
  [101] = {.lex_state = 4, .external_lex_state = 4},
  [102] = {.lex_state = 4, .external_lex_state = 4},
  [103] = {.lex_state = 4, .external_lex_state = 4},
  [104] = {.lex_state = 4, .external_lex_state = 4},
  [105] = {.lex_state = 4, .external_lex_state = 4},
  [106] = {.lex_state = 4, .external_lex_state = 4},
  [107] = {.lex_state = 4, .external_lex_state = 4},
  [108] = {.lex_state = 4, .external_lex_state = 4},
  [109] = {.lex_state = 4, .external_lex_state = 4},
  [110] = {.lex_state = 4, .external_lex_state = 4},
  [111] = {.lex_state = 4, .external_lex_state = 4},
  [112] = {.lex_state = 4, .external_lex_state = 4},
  [113] = {.lex_state = 4, .external_lex_state = 4},
  [114] = {.lex_state = 4, .external_lex_state = 4},
  [115] = {.lex_state = 4, .external_lex_state = 4},
  [116] = {.lex_state = 4, .external_lex_state = 4},
  [117] = {.lex_state = 4, .external_lex_state = 4},
  [118] = {.lex_state = 4, .external_lex_state = 4},
  [119] = {.lex_state = 4, .external_lex_state = 4},
  [120] = {.lex_state = 4, .external_lex_state = 4},
  [121] = {.lex_state = 4, .external_lex_state = 4},
  [122] = {.lex_state = 4, .external_lex_state = 4},
  [123] = {.lex_state = 4, .external_lex_state = 4},
  [124] = {.lex_state = 4, .external_lex_state = 4},
  [125] = {.lex_state = 4, .external_lex_state = 4},
  [126] = {.lex_state = 4, .external_lex_state = 4},
  [127] = {.lex_state = 4, .external_lex_state = 4},
  [128] = {.lex_state = 4, .external_lex_state = 4},
  [129] = {.lex_state = 4, .external_lex_state = 4},
  [130] = {.lex_state = 4, .external_lex_state = 4},
  [131] = {.lex_state = 4, .external_lex_state = 4},
  [132] = {.lex_state = 4, .external_lex_state = 5},
  [133] = {.lex_state = 4, .external_lex_state = 5},
  [134] = {.lex_state = 4, .external_lex_state = 4},
  [135] = {.lex_state = 4, .external_lex_state = 4},
  [136] = {.lex_state = 4, .external_lex_state = 4},
  [137] = {.lex_state = 4, .external_lex_state = 4},
  [138] = {.lex_state = 4, .external_lex_state = 4},
  [139] = {.lex_state = 4, .external_lex_state = 4},
  [140] = {.lex_state = 4, .external_lex_state = 4},
  [141] = {.lex_state = 4, .external_lex_state = 4},
  [142] = {.lex_state = 4, .external_lex_state = 4},
  [143] = {.lex_state = 4, .external_lex_state = 4},
  [144] = {.lex_state = 4, .external_lex_state = 4},
  [145] = {.lex_state = 4, .external_lex_state = 4},
  [146] = {.lex_state = 4, .external_lex_state = 4},
  [147] = {.lex_state = 4, .external_lex_state = 4},
  [148] = {.lex_state = 4, .external_lex_state = 4},
  [149] = {.lex_state = 4, .external_lex_state = 4},
  [150] = {.lex_state = 4, .external_lex_state = 4},
  [151] = {.lex_state = 4, .external_lex_state = 4},
  [152] = {.lex_state = 4, .external_lex_state = 4},
  [153] = {.lex_state = 4, .external_lex_state = 4},
  [154] = {.lex_state = 4, .external_lex_state = 4},
  [155] = {.lex_state = 4, .external_lex_state = 5},
  [156] = {.lex_state = 4, .external_lex_state = 4},
  [157] = {.lex_state = 4, .external_lex_state = 4},
  [158] = {.lex_state = 4, .external_lex_state = 4},
  [159] = {.lex_state = 4, .external_lex_state = 4},
  [160] = {.lex_state = 4, .external_lex_state = 4},
  [161] = {.lex_state = 4, .external_lex_state = 4},
  [162] = {.lex_state = 4, .external_lex_state = 4},
  [163] = {.lex_state = 4, .external_lex_state = 4},
  [164] = {.lex_state = 4, .external_lex_state = 4},
  [165] = {.lex_state = 4, .external_lex_state = 4},
  [166] = {.lex_state = 4, .external_lex_state = 4},
  [167] = {.lex_state = 4, .external_lex_state = 4},
  [168] = {.lex_state = 4, .external_lex_state = 4},
  [169] = {.lex_state = 4, .external_lex_state = 4},
  [170] = {.lex_state = 4, .external_lex_state = 4},
  [171] = {.lex_state = 4, .external_lex_state = 4},
  [172] = {.lex_state = 4, .external_lex_state = 4},
  [173] = {.lex_state = 4, .external_lex_state = 4},
  [174] = {.lex_state = 4, .external_lex_state = 4},
  [175] = {.lex_state = 4, .external_lex_state = 4},
  [176] = {.lex_state = 4, .external_lex_state = 4},
  [177] = {.lex_state = 4, .external_lex_state = 4},
  [178] = {.lex_state = 4, .external_lex_state = 4},
  [179] = {.lex_state = 4, .external_lex_state = 4},
  [180] = {.lex_state = 4, .external_lex_state = 4},
  [181] = {.lex_state = 4, .external_lex_state = 5},
  [182] = {.lex_state = 4, .external_lex_state = 5},
  [183] = {.lex_state = 4, .external_lex_state = 5},
  [184] = {.lex_state = 4, .external_lex_state = 4},
  [185] = {.lex_state = 4, .external_lex_state = 4},
  [186] = {.lex_state = 4, .external_lex_state = 4},
  [187] = {.lex_state = 4, .external_lex_state = 4},
  [188] = {.lex_state = 4, .external_lex_state = 4},
  [189] = {.lex_state = 4, .external_lex_state = 4},
  [190] = {.lex_state = 4, .external_lex_state = 4},
  [191] = {.lex_state = 4, .external_lex_state = 4},
  [192] = {.lex_state = 4, .external_lex_state = 4},
  [193] = {.lex_state = 4, .external_lex_state = 4},
  [194] = {.lex_state = 4, .external_lex_state = 4},
  [195] = {.lex_state = 4, .external_lex_state = 4},
  [196] = {.lex_state = 4, .external_lex_state = 4},
  [197] = {.lex_state = 4, .external_lex_state = 4},
  [198] = {.lex_state = 4, .external_lex_state = 4},
  [199] = {.lex_state = 4, .external_lex_state = 4},
  [200] = {.lex_state = 4, .external_lex_state = 4},
  [201] = {.lex_state = 4, .external_lex_state = 4},
  [202] = {.lex_state = 4, .external_lex_state = 4},
  [203] = {.lex_state = 4, .external_lex_state = 4},
  [204] = {.lex_state = 4, .external_lex_state = 4},
  [205] = {.lex_state = 4, .external_lex_state = 4},
  [206] = {.lex_state = 4, .external_lex_state = 4},
  [207] = {.lex_state = 4, .external_lex_state = 4},
  [208] = {.lex_state = 4, .external_lex_state = 4},
  [209] = {.lex_state = 4, .external_lex_state = 4},
  [210] = {.lex_state = 4, .external_lex_state = 4},
  [211] = {.lex_state = 4, .external_lex_state = 4},
  [212] = {.lex_state = 4, .external_lex_state = 4},
  [213] = {.lex_state = 4, .external_lex_state = 4},
  [214] = {.lex_state = 4, .external_lex_state = 4},
  [215] = {.lex_state = 4, .external_lex_state = 4},
  [216] = {.lex_state = 4, .external_lex_state = 4},
  [217] = {.lex_state = 4, .external_lex_state = 4},
  [218] = {.lex_state = 4, .external_lex_state = 4},
  [219] = {.lex_state = 4, .external_lex_state = 4},
  [220] = {.lex_state = 4, .external_lex_state = 4},
  [221] = {.lex_state = 4, .external_lex_state = 4},
  [222] = {.lex_state = 4, .external_lex_state = 4},
  [223] = {.lex_state = 4, .external_lex_state = 4},
  [224] = {.lex_state = 4, .external_lex_state = 4},
  [225] = {.lex_state = 4, .external_lex_state = 4},
  [226] = {.lex_state = 4, .external_lex_state = 4},
  [227] = {.lex_state = 4, .external_lex_state = 4},
  [228] = {.lex_state = 4, .external_lex_state = 4},
  [229] = {.lex_state = 4, .external_lex_state = 4},
  [230] = {.lex_state = 4, .external_lex_state = 4},
  [231] = {.lex_state = 4, .external_lex_state = 4},
  [232] = {.lex_state = 4, .external_lex_state = 4},
  [233] = {.lex_state = 4, .external_lex_state = 4},
  [234] = {.lex_state = 4, .external_lex_state = 4},
  [235] = {.lex_state = 4, .external_lex_state = 4},
  [236] = {.lex_state = 4, .external_lex_state = 4},
  [237] = {.lex_state = 4, .external_lex_state = 4},
  [238] = {.lex_state = 4, .external_lex_state = 4},
  [239] = {.lex_state = 4, .external_lex_state = 4},
  [240] = {.lex_state = 4, .external_lex_state = 4},
  [241] = {.lex_state = 4, .external_lex_state = 4},
  [242] = {.lex_state = 4, .external_lex_state = 4},
  [243] = {.lex_state = 4, .external_lex_state = 4},
  [244] = {.lex_state = 4, .external_lex_state = 4},
  [245] = {.lex_state = 4, .external_lex_state = 4},
  [246] = {.lex_state = 4, .external_lex_state = 4},
  [247] = {.lex_state = 4, .external_lex_state = 4},
  [248] = {.lex_state = 4, .external_lex_state = 4},
  [249] = {.lex_state = 4, .external_lex_state = 4},
  [250] = {.lex_state = 4, .external_lex_state = 4},
  [251] = {.lex_state = 4, .external_lex_state = 4},
  [252] = {.lex_state = 4, .external_lex_state = 4},
  [253] = {.lex_state = 4, .external_lex_state = 4},
  [254] = {.lex_state = 4, .external_lex_state = 4},
  [255] = {.lex_state = 4, .external_lex_state = 4},
  [256] = {.lex_state = 4, .external_lex_state = 4},
  [257] = {.lex_state = 4, .external_lex_state = 4},
  [258] = {.lex_state = 4, .external_lex_state = 4},
  [259] = {.lex_state = 4, .external_lex_state = 4},
  [260] = {.lex_state = 4, .external_lex_state = 4},
  [261] = {.lex_state = 4, .external_lex_state = 4},
  [262] = {.lex_state = 4, .external_lex_state = 4},
  [263] = {.lex_state = 4, .external_lex_state = 4},
  [264] = {.lex_state = 4, .external_lex_state = 4},
  [265] = {.lex_state = 4, .external_lex_state = 4},
  [266] = {.lex_state = 4, .external_lex_state = 4},
  [267] = {.lex_state = 4, .external_lex_state = 4},
  [268] = {.lex_state = 4, .external_lex_state = 4},
  [269] = {.lex_state = 4, .external_lex_state = 4},
  [270] = {.lex_state = 4, .external_lex_state = 4},
  [271] = {.lex_state = 4, .external_lex_state = 4},
  [272] = {.lex_state = 4, .external_lex_state = 4},
  [273] = {.lex_state = 4, .external_lex_state = 4},
  [274] = {.lex_state = 4, .external_lex_state = 4},
  [275] = {.lex_state = 4, .external_lex_state = 4},
  [276] = {.lex_state = 4, .external_lex_state = 4},
  [277] = {.lex_state = 4, .external_lex_state = 4},
  [278] = {.lex_state = 4, .external_lex_state = 4},
  [279] = {.lex_state = 4, .external_lex_state = 4},
  [280] = {.lex_state = 4, .external_lex_state = 4},
  [281] = {.lex_state = 4, .external_lex_state = 4},
  [282] = {.lex_state = 4, .external_lex_state = 4},
  [283] = {.lex_state = 4, .external_lex_state = 4},
  [284] = {.lex_state = 4, .external_lex_state = 4},
  [285] = {.lex_state = 4, .external_lex_state = 4},
  [286] = {.lex_state = 4, .external_lex_state = 4},
  [287] = {.lex_state = 4, .external_lex_state = 4},
  [288] = {.lex_state = 4, .external_lex_state = 4},
  [289] = {.lex_state = 4, .external_lex_state = 4},
  [290] = {.lex_state = 4, .external_lex_state = 4},
  [291] = {.lex_state = 4, .external_lex_state = 4},
  [292] = {.lex_state = 4, .external_lex_state = 4},
  [293] = {.lex_state = 4, .external_lex_state = 4},
  [294] = {.lex_state = 4, .external_lex_state = 4},
  [295] = {.lex_state = 4, .external_lex_state = 4},
  [296] = {.lex_state = 4, .external_lex_state = 4},
  [297] = {.lex_state = 4, .external_lex_state = 4},
  [298] = {.lex_state = 4, .external_lex_state = 4},
  [299] = {.lex_state = 4, .external_lex_state = 4},
  [300] = {.lex_state = 4, .external_lex_state = 4},
  [301] = {.lex_state = 4, .external_lex_state = 4},
  [302] = {.lex_state = 4, .external_lex_state = 4},
  [303] = {.lex_state = 4, .external_lex_state = 4},
  [304] = {.lex_state = 4, .external_lex_state = 4},
  [305] = {.lex_state = 4, .external_lex_state = 4},
  [306] = {.lex_state = 4, .external_lex_state = 4},
  [307] = {.lex_state = 4, .external_lex_state = 4},
  [308] = {.lex_state = 4, .external_lex_state = 4},
  [309] = {.lex_state = 4, .external_lex_state = 4},
  [310] = {.lex_state = 4, .external_lex_state = 4},
  [311] = {.lex_state = 4, .external_lex_state = 4},
  [312] = {.lex_state = 4, .external_lex_state = 4},
  [313] = {.lex_state = 4, .external_lex_state = 4},
  [314] = {.lex_state = 4, .external_lex_state = 4},
  [315] = {.lex_state = 4, .external_lex_state = 4},
  [316] = {.lex_state = 4, .external_lex_state = 4},
  [317] = {.lex_state = 4, .external_lex_state = 4},
  [318] = {.lex_state = 4, .external_lex_state = 4},
  [319] = {.lex_state = 4, .external_lex_state = 4},
  [320] = {.lex_state = 4, .external_lex_state = 4},
  [321] = {.lex_state = 4, .external_lex_state = 4},
  [322] = {.lex_state = 4, .external_lex_state = 4},
  [323] = {.lex_state = 4, .external_lex_state = 4},
  [324] = {.lex_state = 4, .external_lex_state = 4},
  [325] = {.lex_state = 4, .external_lex_state = 4},
  [326] = {.lex_state = 4, .external_lex_state = 4},
  [327] = {.lex_state = 4, .external_lex_state = 4},
  [328] = {.lex_state = 4, .external_lex_state = 4},
  [329] = {.lex_state = 4, .external_lex_state = 4},
  [330] = {.lex_state = 4, .external_lex_state = 4},
  [331] = {.lex_state = 4, .external_lex_state = 4},
  [332] = {.lex_state = 4, .external_lex_state = 4},
  [333] = {.lex_state = 4, .external_lex_state = 4},
  [334] = {.lex_state = 4, .external_lex_state = 4},
  [335] = {.lex_state = 4, .external_lex_state = 4},
  [336] = {.lex_state = 4, .external_lex_state = 4},
  [337] = {.lex_state = 4, .external_lex_state = 4},
  [338] = {.lex_state = 4, .external_lex_state = 4},
  [339] = {.lex_state = 4, .external_lex_state = 4},
  [340] = {.lex_state = 4, .external_lex_state = 4},
  [341] = {.lex_state = 4, .external_lex_state = 4},
  [342] = {.lex_state = 4, .external_lex_state = 4},
  [343] = {.lex_state = 4, .external_lex_state = 4},
  [344] = {.lex_state = 4, .external_lex_state = 4},
  [345] = {.lex_state = 4, .external_lex_state = 4},
  [346] = {.lex_state = 4, .external_lex_state = 4},
  [347] = {.lex_state = 4, .external_lex_state = 4},
  [348] = {.lex_state = 4, .external_lex_state = 4},
  [349] = {.lex_state = 4, .external_lex_state = 4},
  [350] = {.lex_state = 4, .external_lex_state = 4},
  [351] = {.lex_state = 4, .external_lex_state = 4},
  [352] = {.lex_state = 4, .external_lex_state = 4},
  [353] = {.lex_state = 4, .external_lex_state = 4},
  [354] = {.lex_state = 4, .external_lex_state = 4},
  [355] = {.lex_state = 4, .external_lex_state = 4},
  [356] = {.lex_state = 4, .external_lex_state = 4},
  [357] = {.lex_state = 4, .external_lex_state = 4},
  [358] = {.lex_state = 4, .external_lex_state = 4},
  [359] = {.lex_state = 4, .external_lex_state = 4},
  [360] = {.lex_state = 4, .external_lex_state = 4},
  [361] = {.lex_state = 4, .external_lex_state = 4},
  [362] = {.lex_state = 4, .external_lex_state = 4},
  [363] = {.lex_state = 4, .external_lex_state = 4},
  [364] = {.lex_state = 4, .external_lex_state = 4},
  [365] = {.lex_state = 4, .external_lex_state = 4},
  [366] = {.lex_state = 4, .external_lex_state = 4},
  [367] = {.lex_state = 4, .external_lex_state = 4},
  [368] = {.lex_state = 4, .external_lex_state = 4},
  [369] = {.lex_state = 4, .external_lex_state = 4},
  [370] = {.lex_state = 4, .external_lex_state = 4},
  [371] = {.lex_state = 4, .external_lex_state = 4},
  [372] = {.lex_state = 4, .external_lex_state = 4},
  [373] = {.lex_state = 4, .external_lex_state = 4},
  [374] = {.lex_state = 4, .external_lex_state = 4},
  [375] = {.lex_state = 4, .external_lex_state = 4},
  [376] = {.lex_state = 4, .external_lex_state = 4},
  [377] = {.lex_state = 4, .external_lex_state = 4},
  [378] = {.lex_state = 4, .external_lex_state = 4},
  [379] = {.lex_state = 4, .external_lex_state = 4},
  [380] = {.lex_state = 4, .external_lex_state = 4},
  [381] = {.lex_state = 4, .external_lex_state = 4},
  [382] = {.lex_state = 4, .external_lex_state = 4},
  [383] = {.lex_state = 4, .external_lex_state = 4},
  [384] = {.lex_state = 4, .external_lex_state = 4},
  [385] = {.lex_state = 4, .external_lex_state = 4},
  [386] = {.lex_state = 4, .external_lex_state = 4},
  [387] = {.lex_state = 4, .external_lex_state = 4},
  [388] = {.lex_state = 4, .external_lex_state = 4},
  [389] = {.lex_state = 4, .external_lex_state = 4},
  [390] = {.lex_state = 4, .external_lex_state = 4},
  [391] = {.lex_state = 4, .external_lex_state = 4},
  [392] = {.lex_state = 4, .external_lex_state = 4},
  [393] = {.lex_state = 4, .external_lex_state = 4},
  [394] = {.lex_state = 4, .external_lex_state = 4},
  [395] = {.lex_state = 4, .external_lex_state = 4},
  [396] = {.lex_state = 4, .external_lex_state = 4},
  [397] = {.lex_state = 4, .external_lex_state = 4},
  [398] = {.lex_state = 4, .external_lex_state = 4},
  [399] = {.lex_state = 4, .external_lex_state = 4},
  [400] = {.lex_state = 4, .external_lex_state = 4},
  [401] = {.lex_state = 4, .external_lex_state = 4},
  [402] = {.lex_state = 4, .external_lex_state = 4},
  [403] = {.lex_state = 4, .external_lex_state = 4},
  [404] = {.lex_state = 4, .external_lex_state = 4},
  [405] = {.lex_state = 4, .external_lex_state = 4},
  [406] = {.lex_state = 4, .external_lex_state = 4},
  [407] = {.lex_state = 4, .external_lex_state = 4},
  [408] = {.lex_state = 4, .external_lex_state = 4},
  [409] = {.lex_state = 4, .external_lex_state = 4},
  [410] = {.lex_state = 4, .external_lex_state = 4},
  [411] = {.lex_state = 4, .external_lex_state = 4},
  [412] = {.lex_state = 4, .external_lex_state = 4},
  [413] = {.lex_state = 4, .external_lex_state = 4},
  [414] = {.lex_state = 4, .external_lex_state = 4},
  [415] = {.lex_state = 4, .external_lex_state = 4},
  [416] = {.lex_state = 4, .external_lex_state = 4},
  [417] = {.lex_state = 4, .external_lex_state = 4},
  [418] = {.lex_state = 4, .external_lex_state = 4},
  [419] = {.lex_state = 4, .external_lex_state = 4},
  [420] = {.lex_state = 4, .external_lex_state = 4},
  [421] = {.lex_state = 4, .external_lex_state = 4},
  [422] = {.lex_state = 4, .external_lex_state = 4},
  [423] = {.lex_state = 4, .external_lex_state = 4},
  [424] = {.lex_state = 4, .external_lex_state = 4},
  [425] = {.lex_state = 4, .external_lex_state = 4},
  [426] = {.lex_state = 4, .external_lex_state = 4},
  [427] = {.lex_state = 4, .external_lex_state = 4},
  [428] = {.lex_state = 4, .external_lex_state = 4},
  [429] = {.lex_state = 4, .external_lex_state = 4},
  [430] = {.lex_state = 4, .external_lex_state = 4},
  [431] = {.lex_state = 4, .external_lex_state = 4},
  [432] = {.lex_state = 4, .external_lex_state = 4},
  [433] = {.lex_state = 4, .external_lex_state = 4},
  [434] = {.lex_state = 4, .external_lex_state = 4},
  [435] = {.lex_state = 4, .external_lex_state = 4},
  [436] = {.lex_state = 4, .external_lex_state = 4},
  [437] = {.lex_state = 4, .external_lex_state = 4},
  [438] = {.lex_state = 4, .external_lex_state = 4},
  [439] = {.lex_state = 4, .external_lex_state = 4},
  [440] = {.lex_state = 4, .external_lex_state = 4},
  [441] = {.lex_state = 4, .external_lex_state = 4},
  [442] = {.lex_state = 4, .external_lex_state = 4},
  [443] = {.lex_state = 4, .external_lex_state = 4},
  [444] = {.lex_state = 4, .external_lex_state = 4},
  [445] = {.lex_state = 4, .external_lex_state = 4},
  [446] = {.lex_state = 4, .external_lex_state = 4},
  [447] = {.lex_state = 4, .external_lex_state = 4},
  [448] = {.lex_state = 4, .external_lex_state = 4},
  [449] = {.lex_state = 4, .external_lex_state = 4},
  [450] = {.lex_state = 4, .external_lex_state = 4},
  [451] = {.lex_state = 4, .external_lex_state = 4},
  [452] = {.lex_state = 4, .external_lex_state = 4},
  [453] = {.lex_state = 4, .external_lex_state = 4},
  [454] = {.lex_state = 4, .external_lex_state = 4},
  [455] = {.lex_state = 4, .external_lex_state = 4},
  [456] = {.lex_state = 4, .external_lex_state = 4},
  [457] = {.lex_state = 4, .external_lex_state = 4},
  [458] = {.lex_state = 4, .external_lex_state = 4},
  [459] = {.lex_state = 4, .external_lex_state = 4},
  [460] = {.lex_state = 4, .external_lex_state = 4},
  [461] = {.lex_state = 4, .external_lex_state = 4},
  [462] = {.lex_state = 4, .external_lex_state = 4},
  [463] = {.lex_state = 4, .external_lex_state = 4},
  [464] = {.lex_state = 4, .external_lex_state = 4},
  [465] = {.lex_state = 4, .external_lex_state = 4},
  [466] = {.lex_state = 4, .external_lex_state = 4},
  [467] = {.lex_state = 4, .external_lex_state = 4},
  [468] = {.lex_state = 4, .external_lex_state = 4},
  [469] = {.lex_state = 4, .external_lex_state = 4},
  [470] = {.lex_state = 4, .external_lex_state = 4},
  [471] = {.lex_state = 4, .external_lex_state = 4},
  [472] = {.lex_state = 4, .external_lex_state = 4},
  [473] = {.lex_state = 4, .external_lex_state = 4},
  [474] = {.lex_state = 4, .external_lex_state = 4},
  [475] = {.lex_state = 4, .external_lex_state = 4},
  [476] = {.lex_state = 4, .external_lex_state = 4},
  [477] = {.lex_state = 4, .external_lex_state = 4},
  [478] = {.lex_state = 4, .external_lex_state = 4},
  [479] = {.lex_state = 4, .external_lex_state = 4},
  [480] = {.lex_state = 4, .external_lex_state = 4},
  [481] = {.lex_state = 4, .external_lex_state = 4},
  [482] = {.lex_state = 4, .external_lex_state = 4},
  [483] = {.lex_state = 4, .external_lex_state = 4},
  [484] = {.lex_state = 4, .external_lex_state = 4},
  [485] = {.lex_state = 4, .external_lex_state = 4},
  [486] = {.lex_state = 4, .external_lex_state = 4},
  [487] = {.lex_state = 4, .external_lex_state = 4},
  [488] = {.lex_state = 4, .external_lex_state = 4},
  [489] = {.lex_state = 4, .external_lex_state = 4},
  [490] = {.lex_state = 4, .external_lex_state = 4},
  [491] = {.lex_state = 4, .external_lex_state = 4},
  [492] = {.lex_state = 4, .external_lex_state = 4},
  [493] = {.lex_state = 4, .external_lex_state = 4},
  [494] = {.lex_state = 4, .external_lex_state = 4},
  [495] = {.lex_state = 4, .external_lex_state = 4},
  [496] = {.lex_state = 4, .external_lex_state = 4},
  [497] = {.lex_state = 4, .external_lex_state = 4},
  [498] = {.lex_state = 4, .external_lex_state = 4},
  [499] = {.lex_state = 4, .external_lex_state = 4},
  [500] = {.lex_state = 4, .external_lex_state = 4},
  [501] = {.lex_state = 4, .external_lex_state = 4},
  [502] = {.lex_state = 4, .external_lex_state = 4},
  [503] = {.lex_state = 4, .external_lex_state = 4},
  [504] = {.lex_state = 4, .external_lex_state = 4},
  [505] = {.lex_state = 4, .external_lex_state = 4},
  [506] = {.lex_state = 4, .external_lex_state = 4},
  [507] = {.lex_state = 4, .external_lex_state = 4},
  [508] = {.lex_state = 4, .external_lex_state = 4},
  [509] = {.lex_state = 4, .external_lex_state = 4},
  [510] = {.lex_state = 4, .external_lex_state = 4},
  [511] = {.lex_state = 4, .external_lex_state = 4},
  [512] = {.lex_state = 4, .external_lex_state = 4},
  [513] = {.lex_state = 4, .external_lex_state = 4},
  [514] = {.lex_state = 4, .external_lex_state = 4},
  [515] = {.lex_state = 4, .external_lex_state = 4},
  [516] = {.lex_state = 4, .external_lex_state = 4},
  [517] = {.lex_state = 4, .external_lex_state = 4},
  [518] = {.lex_state = 4, .external_lex_state = 4},
  [519] = {.lex_state = 4, .external_lex_state = 4},
  [520] = {.lex_state = 4, .external_lex_state = 4},
  [521] = {.lex_state = 4, .external_lex_state = 4},
  [522] = {.lex_state = 4, .external_lex_state = 4},
  [523] = {.lex_state = 4, .external_lex_state = 4},
  [524] = {.lex_state = 4, .external_lex_state = 4},
  [525] = {.lex_state = 4, .external_lex_state = 4},
  [526] = {.lex_state = 4, .external_lex_state = 4},
  [527] = {.lex_state = 4, .external_lex_state = 4},
  [528] = {.lex_state = 4, .external_lex_state = 4},
  [529] = {.lex_state = 4, .external_lex_state = 4},
  [530] = {.lex_state = 4, .external_lex_state = 4},
  [531] = {.lex_state = 4, .external_lex_state = 4},
  [532] = {.lex_state = 4, .external_lex_state = 4},
  [533] = {.lex_state = 4, .external_lex_state = 4},
  [534] = {.lex_state = 4, .external_lex_state = 4},
  [535] = {.lex_state = 4, .external_lex_state = 4},
  [536] = {.lex_state = 4, .external_lex_state = 4},
  [537] = {.lex_state = 4, .external_lex_state = 4},
  [538] = {.lex_state = 4, .external_lex_state = 4},
  [539] = {.lex_state = 4, .external_lex_state = 4},
  [540] = {.lex_state = 4, .external_lex_state = 4},
  [541] = {.lex_state = 4, .external_lex_state = 4},
  [542] = {.lex_state = 4, .external_lex_state = 4},
  [543] = {.lex_state = 4, .external_lex_state = 4},
  [544] = {.lex_state = 4, .external_lex_state = 4},
  [545] = {.lex_state = 4, .external_lex_state = 4},
  [546] = {.lex_state = 4, .external_lex_state = 4},
  [547] = {.lex_state = 4, .external_lex_state = 4},
  [548] = {.lex_state = 4, .external_lex_state = 4},
  [549] = {.lex_state = 4, .external_lex_state = 4},
  [550] = {.lex_state = 4, .external_lex_state = 4},
  [551] = {.lex_state = 4, .external_lex_state = 4},
  [552] = {.lex_state = 4, .external_lex_state = 4},
  [553] = {.lex_state = 4, .external_lex_state = 4},
  [554] = {.lex_state = 4, .external_lex_state = 4},
  [555] = {.lex_state = 4, .external_lex_state = 4},
  [556] = {.lex_state = 4, .external_lex_state = 4},
  [557] = {.lex_state = 4, .external_lex_state = 4},
  [558] = {.lex_state = 4, .external_lex_state = 4},
  [559] = {.lex_state = 4, .external_lex_state = 4},
  [560] = {.lex_state = 4, .external_lex_state = 4},
  [561] = {.lex_state = 4, .external_lex_state = 4},
  [562] = {.lex_state = 4, .external_lex_state = 4},
  [563] = {.lex_state = 4, .external_lex_state = 4},
  [564] = {.lex_state = 4, .external_lex_state = 4},
  [565] = {.lex_state = 4, .external_lex_state = 4},
  [566] = {.lex_state = 4, .external_lex_state = 4},
  [567] = {.lex_state = 4, .external_lex_state = 4},
  [568] = {.lex_state = 4, .external_lex_state = 4},
  [569] = {.lex_state = 4, .external_lex_state = 4},
  [570] = {.lex_state = 4, .external_lex_state = 4},
  [571] = {.lex_state = 4, .external_lex_state = 4},
  [572] = {.lex_state = 4, .external_lex_state = 4},
  [573] = {.lex_state = 4, .external_lex_state = 4},
  [574] = {.lex_state = 4, .external_lex_state = 4},
  [575] = {.lex_state = 4, .external_lex_state = 4},
  [576] = {.lex_state = 4, .external_lex_state = 4},
  [577] = {.lex_state = 4, .external_lex_state = 4},
  [578] = {.lex_state = 4, .external_lex_state = 4},
  [579] = {.lex_state = 4, .external_lex_state = 4},
  [580] = {.lex_state = 4, .external_lex_state = 4},
  [581] = {.lex_state = 4, .external_lex_state = 4},
  [582] = {.lex_state = 4, .external_lex_state = 4},
  [583] = {.lex_state = 4, .external_lex_state = 4},
  [584] = {.lex_state = 4, .external_lex_state = 4},
  [585] = {.lex_state = 4, .external_lex_state = 4},
  [586] = {.lex_state = 4, .external_lex_state = 4},
  [587] = {.lex_state = 4, .external_lex_state = 4},
  [588] = {.lex_state = 4, .external_lex_state = 4},
  [589] = {.lex_state = 4, .external_lex_state = 4},
  [590] = {.lex_state = 4, .external_lex_state = 4},
  [591] = {.lex_state = 4, .external_lex_state = 4},
  [592] = {.lex_state = 4, .external_lex_state = 4},
  [593] = {.lex_state = 4, .external_lex_state = 4},
  [594] = {.lex_state = 4, .external_lex_state = 4},
  [595] = {.lex_state = 4, .external_lex_state = 4},
  [596] = {.lex_state = 4, .external_lex_state = 4},
  [597] = {.lex_state = 4, .external_lex_state = 4},
  [598] = {.lex_state = 4, .external_lex_state = 4},
  [599] = {.lex_state = 4, .external_lex_state = 4},
  [600] = {.lex_state = 4, .external_lex_state = 4},
  [601] = {.lex_state = 4, .external_lex_state = 4},
  [602] = {.lex_state = 4, .external_lex_state = 4},
  [603] = {.lex_state = 4, .external_lex_state = 4},
  [604] = {.lex_state = 4, .external_lex_state = 4},
  [605] = {.lex_state = 4, .external_lex_state = 4},
  [606] = {.lex_state = 4, .external_lex_state = 4},
  [607] = {.lex_state = 4, .external_lex_state = 4},
  [608] = {.lex_state = 4, .external_lex_state = 4},
  [609] = {.lex_state = 4, .external_lex_state = 4},
  [610] = {.lex_state = 4, .external_lex_state = 4},
  [611] = {.lex_state = 4, .external_lex_state = 4},
  [612] = {.lex_state = 4, .external_lex_state = 4},
  [613] = {.lex_state = 4, .external_lex_state = 4},
  [614] = {.lex_state = 4, .external_lex_state = 4},
  [615] = {.lex_state = 4, .external_lex_state = 4},
  [616] = {.lex_state = 4, .external_lex_state = 4},
  [617] = {.lex_state = 4, .external_lex_state = 4},
  [618] = {.lex_state = 4, .external_lex_state = 4},
  [619] = {.lex_state = 4, .external_lex_state = 4},
  [620] = {.lex_state = 4, .external_lex_state = 4},
  [621] = {.lex_state = 4, .external_lex_state = 4},
  [622] = {.lex_state = 4, .external_lex_state = 4},
  [623] = {.lex_state = 4, .external_lex_state = 4},
  [624] = {.lex_state = 4, .external_lex_state = 4},
  [625] = {.lex_state = 4, .external_lex_state = 4},
  [626] = {.lex_state = 4, .external_lex_state = 4},
  [627] = {.lex_state = 4, .external_lex_state = 4},
  [628] = {.lex_state = 4, .external_lex_state = 4},
  [629] = {.lex_state = 4, .external_lex_state = 4},
  [630] = {.lex_state = 4, .external_lex_state = 4},
  [631] = {.lex_state = 4, .external_lex_state = 4},
  [632] = {.lex_state = 4, .external_lex_state = 4},
  [633] = {.lex_state = 4, .external_lex_state = 4},
  [634] = {.lex_state = 4, .external_lex_state = 4},
  [635] = {.lex_state = 4, .external_lex_state = 4},
  [636] = {.lex_state = 4, .external_lex_state = 4},
  [637] = {.lex_state = 4, .external_lex_state = 4},
  [638] = {.lex_state = 4, .external_lex_state = 4},
  [639] = {.lex_state = 4, .external_lex_state = 4},
  [640] = {.lex_state = 4, .external_lex_state = 4},
  [641] = {.lex_state = 4, .external_lex_state = 4},
  [642] = {.lex_state = 4, .external_lex_state = 4},
  [643] = {.lex_state = 4, .external_lex_state = 4},
  [644] = {.lex_state = 4, .external_lex_state = 4},
  [645] = {.lex_state = 4, .external_lex_state = 4},
  [646] = {.lex_state = 4, .external_lex_state = 4},
  [647] = {.lex_state = 4, .external_lex_state = 4},
  [648] = {.lex_state = 4, .external_lex_state = 4},
  [649] = {.lex_state = 4, .external_lex_state = 4},
  [650] = {.lex_state = 4, .external_lex_state = 4},
  [651] = {.lex_state = 4, .external_lex_state = 4},
  [652] = {.lex_state = 4, .external_lex_state = 4},
  [653] = {.lex_state = 4, .external_lex_state = 4},
  [654] = {.lex_state = 4, .external_lex_state = 4},
  [655] = {.lex_state = 4, .external_lex_state = 4},
  [656] = {.lex_state = 4, .external_lex_state = 4},
  [657] = {.lex_state = 4, .external_lex_state = 4},
  [658] = {.lex_state = 4, .external_lex_state = 4},
  [659] = {.lex_state = 4, .external_lex_state = 4},
  [660] = {.lex_state = 4, .external_lex_state = 4},
  [661] = {.lex_state = 4, .external_lex_state = 4},
  [662] = {.lex_state = 4, .external_lex_state = 4},
  [663] = {.lex_state = 4, .external_lex_state = 4},
  [664] = {.lex_state = 4, .external_lex_state = 4},
  [665] = {.lex_state = 4, .external_lex_state = 4},
  [666] = {.lex_state = 4, .external_lex_state = 4},
  [667] = {.lex_state = 4, .external_lex_state = 4},
  [668] = {.lex_state = 4, .external_lex_state = 4},
  [669] = {.lex_state = 4, .external_lex_state = 4},
  [670] = {.lex_state = 4, .external_lex_state = 4},
  [671] = {.lex_state = 4, .external_lex_state = 4},
  [672] = {.lex_state = 4, .external_lex_state = 4},
  [673] = {.lex_state = 4, .external_lex_state = 4},
  [674] = {.lex_state = 4, .external_lex_state = 4},
  [675] = {.lex_state = 4, .external_lex_state = 4},
  [676] = {.lex_state = 4, .external_lex_state = 4},
  [677] = {.lex_state = 4, .external_lex_state = 4},
  [678] = {.lex_state = 4, .external_lex_state = 4},
  [679] = {.lex_state = 4, .external_lex_state = 4},
  [680] = {.lex_state = 4, .external_lex_state = 4},
  [681] = {.lex_state = 4, .external_lex_state = 4},
  [682] = {.lex_state = 4, .external_lex_state = 4},
  [683] = {.lex_state = 4, .external_lex_state = 4},
  [684] = {.lex_state = 4, .external_lex_state = 4},
  [685] = {.lex_state = 4, .external_lex_state = 4},
  [686] = {.lex_state = 4, .external_lex_state = 4},
  [687] = {.lex_state = 4, .external_lex_state = 4},
  [688] = {.lex_state = 4, .external_lex_state = 4},
  [689] = {.lex_state = 4, .external_lex_state = 4},
  [690] = {.lex_state = 4, .external_lex_state = 4},
  [691] = {.lex_state = 4, .external_lex_state = 4},
  [692] = {.lex_state = 4, .external_lex_state = 4},
  [693] = {.lex_state = 4, .external_lex_state = 4},
  [694] = {.lex_state = 4, .external_lex_state = 4},
  [695] = {.lex_state = 4, .external_lex_state = 4},
  [696] = {.lex_state = 4, .external_lex_state = 4},
  [697] = {.lex_state = 4, .external_lex_state = 4},
  [698] = {.lex_state = 4, .external_lex_state = 4},
  [699] = {.lex_state = 4, .external_lex_state = 4},
  [700] = {.lex_state = 4, .external_lex_state = 4},
  [701] = {.lex_state = 4, .external_lex_state = 4},
  [702] = {.lex_state = 4, .external_lex_state = 4},
  [703] = {.lex_state = 4, .external_lex_state = 4},
  [704] = {.lex_state = 4, .external_lex_state = 4},
  [705] = {.lex_state = 4, .external_lex_state = 4},
  [706] = {.lex_state = 4, .external_lex_state = 4},
  [707] = {.lex_state = 4, .external_lex_state = 4},
  [708] = {.lex_state = 4, .external_lex_state = 4},
  [709] = {.lex_state = 4, .external_lex_state = 4},
  [710] = {.lex_state = 4, .external_lex_state = 4},
  [711] = {.lex_state = 4, .external_lex_state = 4},
  [712] = {.lex_state = 4, .external_lex_state = 4},
  [713] = {.lex_state = 4, .external_lex_state = 4},
  [714] = {.lex_state = 4, .external_lex_state = 4},
  [715] = {.lex_state = 4, .external_lex_state = 4},
  [716] = {.lex_state = 4, .external_lex_state = 4},
  [717] = {.lex_state = 4, .external_lex_state = 4},
  [718] = {.lex_state = 4, .external_lex_state = 4},
  [719] = {.lex_state = 4, .external_lex_state = 4},
  [720] = {.lex_state = 4, .external_lex_state = 4},
  [721] = {.lex_state = 4, .external_lex_state = 4},
  [722] = {.lex_state = 4, .external_lex_state = 4},
  [723] = {.lex_state = 4, .external_lex_state = 4},
  [724] = {.lex_state = 4, .external_lex_state = 4},
  [725] = {.lex_state = 4, .external_lex_state = 4},
  [726] = {.lex_state = 4, .external_lex_state = 4},
  [727] = {.lex_state = 4, .external_lex_state = 4},
  [728] = {.lex_state = 4, .external_lex_state = 4},
  [729] = {.lex_state = 4, .external_lex_state = 4},
  [730] = {.lex_state = 4, .external_lex_state = 4},
  [731] = {.lex_state = 4, .external_lex_state = 4},
  [732] = {.lex_state = 4, .external_lex_state = 4},
  [733] = {.lex_state = 4, .external_lex_state = 4},
  [734] = {.lex_state = 4, .external_lex_state = 4},
  [735] = {.lex_state = 4, .external_lex_state = 4},
  [736] = {.lex_state = 4, .external_lex_state = 4},
  [737] = {.lex_state = 4, .external_lex_state = 4},
  [738] = {.lex_state = 4, .external_lex_state = 4},
  [739] = {.lex_state = 4, .external_lex_state = 4},
  [740] = {.lex_state = 4, .external_lex_state = 4},
  [741] = {.lex_state = 4, .external_lex_state = 4},
  [742] = {.lex_state = 4, .external_lex_state = 4},
  [743] = {.lex_state = 4, .external_lex_state = 4},
  [744] = {.lex_state = 4, .external_lex_state = 4},
  [745] = {.lex_state = 4, .external_lex_state = 4},
  [746] = {.lex_state = 4, .external_lex_state = 4},
  [747] = {.lex_state = 4, .external_lex_state = 4},
  [748] = {.lex_state = 4, .external_lex_state = 4},
  [749] = {.lex_state = 4, .external_lex_state = 4},
  [750] = {.lex_state = 4, .external_lex_state = 4},
  [751] = {.lex_state = 4, .external_lex_state = 4},
  [752] = {.lex_state = 4, .external_lex_state = 4},
  [753] = {.lex_state = 4, .external_lex_state = 4},
  [754] = {.lex_state = 4, .external_lex_state = 4},
  [755] = {.lex_state = 4, .external_lex_state = 4},
  [756] = {.lex_state = 4, .external_lex_state = 4},
  [757] = {.lex_state = 4, .external_lex_state = 4},
  [758] = {.lex_state = 4, .external_lex_state = 4},
  [759] = {.lex_state = 4, .external_lex_state = 4},
  [760] = {.lex_state = 4, .external_lex_state = 4},
  [761] = {.lex_state = 4, .external_lex_state = 4},
  [762] = {.lex_state = 4, .external_lex_state = 4},
  [763] = {.lex_state = 4, .external_lex_state = 4},
  [764] = {.lex_state = 4, .external_lex_state = 4},
  [765] = {.lex_state = 4, .external_lex_state = 4},
  [766] = {.lex_state = 4, .external_lex_state = 4},
  [767] = {.lex_state = 4, .external_lex_state = 4},
  [768] = {.lex_state = 4, .external_lex_state = 4},
  [769] = {.lex_state = 4, .external_lex_state = 4},
  [770] = {.lex_state = 4, .external_lex_state = 4},
  [771] = {.lex_state = 4, .external_lex_state = 4},
  [772] = {.lex_state = 4, .external_lex_state = 4},
  [773] = {.lex_state = 4, .external_lex_state = 4},
  [774] = {.lex_state = 4, .external_lex_state = 4},
  [775] = {.lex_state = 4, .external_lex_state = 4},
  [776] = {.lex_state = 4, .external_lex_state = 4},
  [777] = {.lex_state = 4, .external_lex_state = 4},
  [778] = {.lex_state = 4, .external_lex_state = 4},
  [779] = {.lex_state = 4, .external_lex_state = 4},
  [780] = {.lex_state = 4, .external_lex_state = 4},
  [781] = {.lex_state = 4, .external_lex_state = 4},
  [782] = {.lex_state = 4, .external_lex_state = 4},
  [783] = {.lex_state = 4, .external_lex_state = 4},
  [784] = {.lex_state = 4, .external_lex_state = 4},
  [785] = {.lex_state = 4, .external_lex_state = 4},
  [786] = {.lex_state = 4, .external_lex_state = 4},
  [787] = {.lex_state = 4, .external_lex_state = 4},
  [788] = {.lex_state = 4, .external_lex_state = 4},
  [789] = {.lex_state = 4, .external_lex_state = 4},
  [790] = {.lex_state = 4, .external_lex_state = 4},
  [791] = {.lex_state = 4, .external_lex_state = 4},
  [792] = {.lex_state = 4, .external_lex_state = 4},
  [793] = {.lex_state = 4, .external_lex_state = 4},
  [794] = {.lex_state = 4, .external_lex_state = 4},
  [795] = {.lex_state = 4, .external_lex_state = 4},
  [796] = {.lex_state = 4, .external_lex_state = 4},
  [797] = {.lex_state = 4, .external_lex_state = 4},
  [798] = {.lex_state = 4, .external_lex_state = 4},
  [799] = {.lex_state = 4, .external_lex_state = 4},
  [800] = {.lex_state = 4, .external_lex_state = 4},
  [801] = {.lex_state = 4, .external_lex_state = 4},
  [802] = {.lex_state = 4, .external_lex_state = 4},
  [803] = {.lex_state = 4, .external_lex_state = 4},
  [804] = {.lex_state = 4, .external_lex_state = 4},
  [805] = {.lex_state = 4, .external_lex_state = 4},
  [806] = {.lex_state = 4, .external_lex_state = 4},
  [807] = {.lex_state = 4, .external_lex_state = 4},
  [808] = {.lex_state = 4, .external_lex_state = 4},
  [809] = {.lex_state = 4, .external_lex_state = 4},
  [810] = {.lex_state = 4, .external_lex_state = 4},
  [811] = {.lex_state = 4, .external_lex_state = 4},
  [812] = {.lex_state = 4, .external_lex_state = 4},
  [813] = {.lex_state = 4, .external_lex_state = 4},
  [814] = {.lex_state = 4, .external_lex_state = 4},
  [815] = {.lex_state = 4, .external_lex_state = 4},
  [816] = {.lex_state = 4, .external_lex_state = 4},
  [817] = {.lex_state = 4, .external_lex_state = 4},
  [818] = {.lex_state = 4, .external_lex_state = 4},
  [819] = {.lex_state = 4, .external_lex_state = 4},
  [820] = {.lex_state = 4, .external_lex_state = 4},
  [821] = {.lex_state = 4, .external_lex_state = 4},
  [822] = {.lex_state = 4, .external_lex_state = 4},
  [823] = {.lex_state = 4, .external_lex_state = 4},
  [824] = {.lex_state = 4, .external_lex_state = 4},
  [825] = {.lex_state = 4, .external_lex_state = 4},
  [826] = {.lex_state = 4, .external_lex_state = 4},
  [827] = {.lex_state = 4, .external_lex_state = 4},
  [828] = {.lex_state = 4, .external_lex_state = 4},
  [829] = {.lex_state = 4, .external_lex_state = 4},
  [830] = {.lex_state = 4, .external_lex_state = 4},
  [831] = {.lex_state = 4, .external_lex_state = 4},
  [832] = {.lex_state = 4, .external_lex_state = 4},
  [833] = {.lex_state = 4, .external_lex_state = 4},
  [834] = {.lex_state = 4, .external_lex_state = 4},
  [835] = {.lex_state = 4, .external_lex_state = 4},
  [836] = {.lex_state = 4, .external_lex_state = 4},
  [837] = {.lex_state = 4, .external_lex_state = 4},
  [838] = {.lex_state = 4, .external_lex_state = 4},
  [839] = {.lex_state = 4, .external_lex_state = 4},
  [840] = {.lex_state = 4, .external_lex_state = 4},
  [841] = {.lex_state = 4, .external_lex_state = 4},
  [842] = {.lex_state = 4, .external_lex_state = 4},
  [843] = {.lex_state = 4, .external_lex_state = 4},
  [844] = {.lex_state = 4, .external_lex_state = 4},
  [845] = {.lex_state = 4, .external_lex_state = 4},
  [846] = {.lex_state = 4, .external_lex_state = 4},
  [847] = {.lex_state = 4, .external_lex_state = 4},
  [848] = {.lex_state = 4, .external_lex_state = 4},
  [849] = {.lex_state = 4, .external_lex_state = 4},
  [850] = {.lex_state = 4, .external_lex_state = 4},
  [851] = {.lex_state = 4, .external_lex_state = 4},
  [852] = {.lex_state = 4, .external_lex_state = 4},
  [853] = {.lex_state = 4, .external_lex_state = 4},
  [854] = {.lex_state = 4, .external_lex_state = 4},
  [855] = {.lex_state = 4, .external_lex_state = 4},
  [856] = {.lex_state = 4, .external_lex_state = 4},
  [857] = {.lex_state = 4, .external_lex_state = 4},
  [858] = {.lex_state = 4, .external_lex_state = 4},
  [859] = {.lex_state = 4, .external_lex_state = 4},
  [860] = {.lex_state = 4, .external_lex_state = 4},
  [861] = {.lex_state = 4, .external_lex_state = 4},
  [862] = {.lex_state = 4, .external_lex_state = 4},
  [863] = {.lex_state = 4, .external_lex_state = 4},
  [864] = {.lex_state = 4, .external_lex_state = 4},
  [865] = {.lex_state = 4, .external_lex_state = 4},
  [866] = {.lex_state = 4, .external_lex_state = 4},
  [867] = {.lex_state = 4, .external_lex_state = 4},
  [868] = {.lex_state = 4, .external_lex_state = 4},
  [869] = {.lex_state = 4, .external_lex_state = 4},
  [870] = {.lex_state = 4, .external_lex_state = 4},
  [871] = {.lex_state = 4, .external_lex_state = 4},
  [872] = {.lex_state = 4, .external_lex_state = 4},
  [873] = {.lex_state = 4, .external_lex_state = 4},
  [874] = {.lex_state = 4, .external_lex_state = 4},
  [875] = {.lex_state = 4, .external_lex_state = 4},
  [876] = {.lex_state = 4, .external_lex_state = 4},
  [877] = {.lex_state = 4, .external_lex_state = 4},
  [878] = {.lex_state = 4, .external_lex_state = 4},
  [879] = {.lex_state = 4, .external_lex_state = 4},
  [880] = {.lex_state = 4, .external_lex_state = 4},
  [881] = {.lex_state = 4, .external_lex_state = 4},
  [882] = {.lex_state = 4, .external_lex_state = 4},
  [883] = {.lex_state = 4, .external_lex_state = 4},
  [884] = {.lex_state = 4, .external_lex_state = 4},
  [885] = {.lex_state = 4, .external_lex_state = 4},
  [886] = {.lex_state = 4, .external_lex_state = 4},
  [887] = {.lex_state = 4, .external_lex_state = 4},
  [888] = {.lex_state = 4, .external_lex_state = 4},
  [889] = {.lex_state = 4, .external_lex_state = 4},
  [890] = {.lex_state = 4, .external_lex_state = 4},
  [891] = {.lex_state = 4, .external_lex_state = 4},
  [892] = {.lex_state = 4, .external_lex_state = 4},
  [893] = {.lex_state = 4, .external_lex_state = 4},
  [894] = {.lex_state = 4, .external_lex_state = 4},
  [895] = {.lex_state = 4, .external_lex_state = 4},
  [896] = {.lex_state = 4, .external_lex_state = 4},
  [897] = {.lex_state = 4, .external_lex_state = 4},
  [898] = {.lex_state = 4, .external_lex_state = 4},
  [899] = {.lex_state = 4, .external_lex_state = 4},
  [900] = {.lex_state = 4, .external_lex_state = 4},
  [901] = {.lex_state = 4, .external_lex_state = 4},
  [902] = {.lex_state = 4, .external_lex_state = 4},
  [903] = {.lex_state = 4, .external_lex_state = 4},
  [904] = {.lex_state = 4, .external_lex_state = 4},
  [905] = {.lex_state = 4, .external_lex_state = 4},
  [906] = {.lex_state = 4, .external_lex_state = 4},
  [907] = {.lex_state = 4, .external_lex_state = 4},
  [908] = {.lex_state = 4, .external_lex_state = 4},
  [909] = {.lex_state = 4, .external_lex_state = 4},
  [910] = {.lex_state = 4, .external_lex_state = 4},
  [911] = {.lex_state = 4, .external_lex_state = 4},
  [912] = {.lex_state = 4, .external_lex_state = 4},
  [913] = {.lex_state = 4, .external_lex_state = 4},
  [914] = {.lex_state = 4, .external_lex_state = 4},
  [915] = {.lex_state = 4, .external_lex_state = 4},
  [916] = {.lex_state = 4, .external_lex_state = 4},
  [917] = {.lex_state = 4, .external_lex_state = 4},
  [918] = {.lex_state = 4, .external_lex_state = 4},
  [919] = {.lex_state = 4, .external_lex_state = 4},
  [920] = {.lex_state = 4, .external_lex_state = 4},
  [921] = {.lex_state = 4, .external_lex_state = 4},
  [922] = {.lex_state = 4, .external_lex_state = 4},
  [923] = {.lex_state = 4, .external_lex_state = 4},
  [924] = {.lex_state = 4, .external_lex_state = 4},
  [925] = {.lex_state = 4, .external_lex_state = 4},
  [926] = {.lex_state = 4, .external_lex_state = 4},
  [927] = {.lex_state = 4, .external_lex_state = 4},
  [928] = {.lex_state = 4, .external_lex_state = 4},
  [929] = {.lex_state = 4, .external_lex_state = 4},
  [930] = {.lex_state = 4, .external_lex_state = 4},
  [931] = {.lex_state = 4, .external_lex_state = 4},
  [932] = {.lex_state = 4, .external_lex_state = 4},
  [933] = {.lex_state = 4, .external_lex_state = 4},
  [934] = {.lex_state = 4, .external_lex_state = 4},
  [935] = {.lex_state = 4, .external_lex_state = 4},
  [936] = {.lex_state = 4, .external_lex_state = 4},
  [937] = {.lex_state = 4, .external_lex_state = 4},
  [938] = {.lex_state = 4, .external_lex_state = 4},
  [939] = {.lex_state = 4, .external_lex_state = 4},
  [940] = {.lex_state = 4, .external_lex_state = 4},
  [941] = {.lex_state = 4, .external_lex_state = 4},
  [942] = {.lex_state = 4, .external_lex_state = 4},
  [943] = {.lex_state = 4, .external_lex_state = 4},
  [944] = {.lex_state = 4, .external_lex_state = 4},
  [945] = {.lex_state = 4, .external_lex_state = 4},
  [946] = {.lex_state = 4, .external_lex_state = 4},
  [947] = {.lex_state = 4, .external_lex_state = 4},
  [948] = {.lex_state = 4, .external_lex_state = 4},
  [949] = {.lex_state = 4, .external_lex_state = 4},
  [950] = {.lex_state = 4, .external_lex_state = 4},
  [951] = {.lex_state = 4, .external_lex_state = 4},
  [952] = {.lex_state = 4, .external_lex_state = 4},
  [953] = {.lex_state = 4, .external_lex_state = 4},
  [954] = {.lex_state = 4, .external_lex_state = 4},
  [955] = {.lex_state = 4, .external_lex_state = 4},
  [956] = {.lex_state = 4, .external_lex_state = 4},
  [957] = {.lex_state = 4, .external_lex_state = 4},
  [958] = {.lex_state = 4, .external_lex_state = 4},
  [959] = {.lex_state = 4, .external_lex_state = 4},
  [960] = {.lex_state = 4, .external_lex_state = 4},
  [961] = {.lex_state = 4, .external_lex_state = 4},
  [962] = {.lex_state = 4, .external_lex_state = 4},
  [963] = {.lex_state = 4, .external_lex_state = 4},
  [964] = {.lex_state = 4, .external_lex_state = 4},
  [965] = {.lex_state = 4, .external_lex_state = 4},
  [966] = {.lex_state = 4, .external_lex_state = 4},
  [967] = {.lex_state = 4, .external_lex_state = 4},
  [968] = {.lex_state = 4, .external_lex_state = 4},
  [969] = {.lex_state = 4, .external_lex_state = 4},
  [970] = {.lex_state = 4, .external_lex_state = 4},
  [971] = {.lex_state = 4, .external_lex_state = 4},
  [972] = {.lex_state = 4, .external_lex_state = 4},
  [973] = {.lex_state = 4, .external_lex_state = 4},
  [974] = {.lex_state = 4, .external_lex_state = 4},
  [975] = {.lex_state = 4, .external_lex_state = 4},
  [976] = {.lex_state = 4, .external_lex_state = 4},
  [977] = {.lex_state = 4, .external_lex_state = 4},
  [978] = {.lex_state = 4, .external_lex_state = 4},
  [979] = {.lex_state = 4, .external_lex_state = 4},
  [980] = {.lex_state = 4, .external_lex_state = 4},
  [981] = {.lex_state = 4, .external_lex_state = 4},
  [982] = {.lex_state = 4, .external_lex_state = 4},
  [983] = {.lex_state = 4, .external_lex_state = 4},
  [984] = {.lex_state = 4, .external_lex_state = 4},
  [985] = {.lex_state = 4, .external_lex_state = 4},
  [986] = {.lex_state = 4, .external_lex_state = 4},
  [987] = {.lex_state = 4, .external_lex_state = 4},
  [988] = {.lex_state = 4, .external_lex_state = 4},
  [989] = {.lex_state = 4, .external_lex_state = 4},
  [990] = {.lex_state = 4, .external_lex_state = 4},
  [991] = {.lex_state = 4, .external_lex_state = 4},
  [992] = {.lex_state = 4, .external_lex_state = 4},
  [993] = {.lex_state = 4, .external_lex_state = 4},
  [994] = {.lex_state = 4, .external_lex_state = 4},
  [995] = {.lex_state = 4, .external_lex_state = 4},
  [996] = {.lex_state = 4, .external_lex_state = 4},
  [997] = {.lex_state = 4, .external_lex_state = 4},
  [998] = {.lex_state = 4, .external_lex_state = 4},
  [999] = {.lex_state = 4, .external_lex_state = 4},
  [1000] = {.lex_state = 4, .external_lex_state = 4},
  [1001] = {.lex_state = 4, .external_lex_state = 4},
  [1002] = {.lex_state = 4, .external_lex_state = 4},
  [1003] = {.lex_state = 4, .external_lex_state = 4},
  [1004] = {.lex_state = 4, .external_lex_state = 4},
  [1005] = {.lex_state = 4, .external_lex_state = 4},
  [1006] = {.lex_state = 4, .external_lex_state = 4},
  [1007] = {.lex_state = 4, .external_lex_state = 4},
  [1008] = {.lex_state = 4, .external_lex_state = 4},
  [1009] = {.lex_state = 4, .external_lex_state = 4},
  [1010] = {.lex_state = 4, .external_lex_state = 4},
  [1011] = {.lex_state = 4, .external_lex_state = 4},
  [1012] = {.lex_state = 4, .external_lex_state = 4},
  [1013] = {.lex_state = 4, .external_lex_state = 4},
  [1014] = {.lex_state = 4, .external_lex_state = 4},
  [1015] = {.lex_state = 4, .external_lex_state = 4},
  [1016] = {.lex_state = 4, .external_lex_state = 4},
  [1017] = {.lex_state = 4, .external_lex_state = 4},
  [1018] = {.lex_state = 4, .external_lex_state = 4},
  [1019] = {.lex_state = 4, .external_lex_state = 4},
  [1020] = {.lex_state = 4, .external_lex_state = 4},
  [1021] = {.lex_state = 4, .external_lex_state = 4},
  [1022] = {.lex_state = 4, .external_lex_state = 4},
  [1023] = {.lex_state = 4, .external_lex_state = 4},
  [1024] = {.lex_state = 4, .external_lex_state = 4},
  [1025] = {.lex_state = 4, .external_lex_state = 4},
  [1026] = {.lex_state = 4, .external_lex_state = 4},
  [1027] = {.lex_state = 4, .external_lex_state = 4},
  [1028] = {.lex_state = 4, .external_lex_state = 4},
  [1029] = {.lex_state = 4, .external_lex_state = 4},
  [1030] = {.lex_state = 4, .external_lex_state = 4},
  [1031] = {.lex_state = 4, .external_lex_state = 4},
  [1032] = {.lex_state = 4, .external_lex_state = 4},
  [1033] = {.lex_state = 4, .external_lex_state = 4},
  [1034] = {.lex_state = 4, .external_lex_state = 4},
  [1035] = {.lex_state = 4, .external_lex_state = 4},
  [1036] = {.lex_state = 4, .external_lex_state = 4},
  [1037] = {.lex_state = 4, .external_lex_state = 4},
  [1038] = {.lex_state = 4, .external_lex_state = 4},
  [1039] = {.lex_state = 4, .external_lex_state = 4},
  [1040] = {.lex_state = 4, .external_lex_state = 4},
  [1041] = {.lex_state = 4, .external_lex_state = 4},
  [1042] = {.lex_state = 4, .external_lex_state = 4},
  [1043] = {.lex_state = 4, .external_lex_state = 4},
  [1044] = {.lex_state = 4, .external_lex_state = 4},
  [1045] = {.lex_state = 4, .external_lex_state = 4},
  [1046] = {.lex_state = 4, .external_lex_state = 4},
  [1047] = {.lex_state = 4, .external_lex_state = 4},
  [1048] = {.lex_state = 4, .external_lex_state = 4},
  [1049] = {.lex_state = 4, .external_lex_state = 4},
  [1050] = {.lex_state = 4, .external_lex_state = 4},
  [1051] = {.lex_state = 4, .external_lex_state = 4},
  [1052] = {.lex_state = 4, .external_lex_state = 4},
  [1053] = {.lex_state = 4, .external_lex_state = 4},
  [1054] = {.lex_state = 4, .external_lex_state = 4},
  [1055] = {.lex_state = 4, .external_lex_state = 4},
  [1056] = {.lex_state = 4, .external_lex_state = 4},
  [1057] = {.lex_state = 4, .external_lex_state = 4},
  [1058] = {.lex_state = 4, .external_lex_state = 4},
  [1059] = {.lex_state = 4, .external_lex_state = 4},
  [1060] = {.lex_state = 4, .external_lex_state = 4},
  [1061] = {.lex_state = 4, .external_lex_state = 4},
  [1062] = {.lex_state = 4, .external_lex_state = 4},
  [1063] = {.lex_state = 4, .external_lex_state = 4},
  [1064] = {.lex_state = 4, .external_lex_state = 4},
  [1065] = {.lex_state = 4, .external_lex_state = 4},
  [1066] = {.lex_state = 4, .external_lex_state = 4},
  [1067] = {.lex_state = 4, .external_lex_state = 4},
  [1068] = {.lex_state = 4, .external_lex_state = 4},
  [1069] = {.lex_state = 4, .external_lex_state = 4},
  [1070] = {.lex_state = 4, .external_lex_state = 4},
  [1071] = {.lex_state = 4, .external_lex_state = 4},
  [1072] = {.lex_state = 4, .external_lex_state = 4},
  [1073] = {.lex_state = 4, .external_lex_state = 4},
  [1074] = {.lex_state = 4, .external_lex_state = 4},
  [1075] = {.lex_state = 4, .external_lex_state = 4},
  [1076] = {.lex_state = 4, .external_lex_state = 4},
  [1077] = {.lex_state = 4, .external_lex_state = 4},
  [1078] = {.lex_state = 4, .external_lex_state = 4},
  [1079] = {.lex_state = 4, .external_lex_state = 4},
  [1080] = {.lex_state = 4, .external_lex_state = 4},
  [1081] = {.lex_state = 4, .external_lex_state = 4},
  [1082] = {.lex_state = 4, .external_lex_state = 4},
  [1083] = {.lex_state = 4, .external_lex_state = 4},
  [1084] = {.lex_state = 4, .external_lex_state = 4},
  [1085] = {.lex_state = 7, .external_lex_state = 6},
  [1086] = {.lex_state = 7, .external_lex_state = 6},
  [1087] = {.lex_state = 7, .external_lex_state = 6},
  [1088] = {.lex_state = 7, .external_lex_state = 6},
  [1089] = {.lex_state = 7, .external_lex_state = 6},
  [1090] = {.lex_state = 7, .external_lex_state = 6},
  [1091] = {.lex_state = 7, .external_lex_state = 6},
  [1092] = {.lex_state = 7, .external_lex_state = 6},
  [1093] = {.lex_state = 7, .external_lex_state = 6},
  [1094] = {.lex_state = 7, .external_lex_state = 6},
  [1095] = {.lex_state = 7, .external_lex_state = 6},
  [1096] = {.lex_state = 7, .external_lex_state = 6},
  [1097] = {.lex_state = 7, .external_lex_state = 6},
  [1098] = {.lex_state = 7, .external_lex_state = 6},
  [1099] = {.lex_state = 7, .external_lex_state = 6},
  [1100] = {.lex_state = 7, .external_lex_state = 6},
  [1101] = {.lex_state = 8, .external_lex_state = 7},
  [1102] = {.lex_state = 229, .external_lex_state = 7},
  [1103] = {.lex_state = 229, .external_lex_state = 7},
  [1104] = {.lex_state = 8, .external_lex_state = 7},
  [1105] = {.lex_state = 7, .external_lex_state = 6},
  [1106] = {.lex_state = 7, .external_lex_state = 6},
  [1107] = {.lex_state = 7, .external_lex_state = 6},
  [1108] = {.lex_state = 7, .external_lex_state = 6},
  [1109] = {.lex_state = 7, .external_lex_state = 6},
  [1110] = {.lex_state = 9, .external_lex_state = 6},
  [1111] = {.lex_state = 9, .external_lex_state = 6},
  [1112] = {.lex_state = 9, .external_lex_state = 6},
  [1113] = {.lex_state = 9, .external_lex_state = 6},
  [1114] = {.lex_state = 9, .external_lex_state = 6},
  [1115] = {.lex_state = 9, .external_lex_state = 6},
  [1116] = {.lex_state = 9, .external_lex_state = 6},
  [1117] = {.lex_state = 9, .external_lex_state = 6},
  [1118] = {.lex_state = 9, .external_lex_state = 6},
  [1119] = {.lex_state = 9, .external_lex_state = 6},
  [1120] = {.lex_state = 9, .external_lex_state = 6},
  [1121] = {.lex_state = 9, .external_lex_state = 6},
  [1122] = {.lex_state = 9, .external_lex_state = 6},
  [1123] = {.lex_state = 9, .external_lex_state = 6},
  [1124] = {.lex_state = 9, .external_lex_state = 6},
  [1125] = {.lex_state = 9, .external_lex_state = 6},
  [1126] = {.lex_state = 9, .external_lex_state = 6},
  [1127] = {.lex_state = 9, .external_lex_state = 6},
  [1128] = {.lex_state = 9, .external_lex_state = 6},
  [1129] = {.lex_state = 9, .external_lex_state = 6},
  [1130] = {.lex_state = 9, .external_lex_state = 6},
  [1131] = {.lex_state = 9, .external_lex_state = 6},
  [1132] = {.lex_state = 9, .external_lex_state = 6},
  [1133] = {.lex_state = 9, .external_lex_state = 6},
  [1134] = {.lex_state = 9, .external_lex_state = 6},
  [1135] = {.lex_state = 9, .external_lex_state = 6},
  [1136] = {.lex_state = 9, .external_lex_state = 6},
  [1137] = {.lex_state = 9, .external_lex_state = 6},
  [1138] = {.lex_state = 9, .external_lex_state = 6},
  [1139] = {.lex_state = 9, .external_lex_state = 6},
  [1140] = {.lex_state = 9, .external_lex_state = 6},
  [1141] = {.lex_state = 9, .external_lex_state = 6},
  [1142] = {.lex_state = 9, .external_lex_state = 6},
  [1143] = {.lex_state = 9, .external_lex_state = 6},
  [1144] = {.lex_state = 9, .external_lex_state = 6},
  [1145] = {.lex_state = 9, .external_lex_state = 6},
  [1146] = {.lex_state = 9, .external_lex_state = 6},
  [1147] = {.lex_state = 9, .external_lex_state = 6},
  [1148] = {.lex_state = 9, .external_lex_state = 6},
  [1149] = {.lex_state = 9, .external_lex_state = 6},
  [1150] = {.lex_state = 9, .external_lex_state = 6},
  [1151] = {.lex_state = 9, .external_lex_state = 6},
  [1152] = {.lex_state = 9, .external_lex_state = 6},
  [1153] = {.lex_state = 9, .external_lex_state = 6},
  [1154] = {.lex_state = 9, .external_lex_state = 6},
  [1155] = {.lex_state = 9, .external_lex_state = 6},
  [1156] = {.lex_state = 9, .external_lex_state = 6},
  [1157] = {.lex_state = 9, .external_lex_state = 6},
  [1158] = {.lex_state = 9, .external_lex_state = 6},
  [1159] = {.lex_state = 9, .external_lex_state = 6},
  [1160] = {.lex_state = 229, .external_lex_state = 7},
  [1161] = {.lex_state = 229, .external_lex_state = 7},
  [1162] = {.lex_state = 229, .external_lex_state = 7},
  [1163] = {.lex_state = 229, .external_lex_state = 7},
  [1164] = {.lex_state = 229, .external_lex_state = 7},
  [1165] = {.lex_state = 229, .external_lex_state = 7},
  [1166] = {.lex_state = 229, .external_lex_state = 7},
  [1167] = {.lex_state = 229, .external_lex_state = 7},
  [1168] = {.lex_state = 229, .external_lex_state = 7},
  [1169] = {.lex_state = 8, .external_lex_state = 7},
  [1170] = {.lex_state = 229, .external_lex_state = 7},
  [1171] = {.lex_state = 229, .external_lex_state = 7},
  [1172] = {.lex_state = 8, .external_lex_state = 7},
  [1173] = {.lex_state = 8, .external_lex_state = 7},
  [1174] = {.lex_state = 8, .external_lex_state = 7},
  [1175] = {.lex_state = 229, .external_lex_state = 7},
  [1176] = {.lex_state = 8, .external_lex_state = 7},
  [1177] = {.lex_state = 8, .external_lex_state = 7},
  [1178] = {.lex_state = 8, .external_lex_state = 7},
  [1179] = {.lex_state = 229, .external_lex_state = 7},
  [1180] = {.lex_state = 8, .external_lex_state = 7},
  [1181] = {.lex_state = 229, .external_lex_state = 7},
  [1182] = {.lex_state = 229, .external_lex_state = 7},
  [1183] = {.lex_state = 229, .external_lex_state = 7},
  [1184] = {.lex_state = 229, .external_lex_state = 7},
  [1185] = {.lex_state = 229, .external_lex_state = 7},
  [1186] = {.lex_state = 229, .external_lex_state = 7},
  [1187] = {.lex_state = 229, .external_lex_state = 7},
  [1188] = {.lex_state = 229, .external_lex_state = 7},
  [1189] = {.lex_state = 229, .external_lex_state = 7},
  [1190] = {.lex_state = 229, .external_lex_state = 7},
  [1191] = {.lex_state = 8, .external_lex_state = 7},
  [1192] = {.lex_state = 8, .external_lex_state = 7},
  [1193] = {.lex_state = 8, .external_lex_state = 7},
  [1194] = {.lex_state = 8, .external_lex_state = 7},
  [1195] = {.lex_state = 8, .external_lex_state = 7},
  [1196] = {.lex_state = 8, .external_lex_state = 7},
  [1197] = {.lex_state = 229, .external_lex_state = 7},
  [1198] = {.lex_state = 229, .external_lex_state = 7},
  [1199] = {.lex_state = 8, .external_lex_state = 7},
  [1200] = {.lex_state = 229, .external_lex_state = 7},
  [1201] = {.lex_state = 8, .external_lex_state = 7},
  [1202] = {.lex_state = 8, .external_lex_state = 7},
  [1203] = {.lex_state = 229, .external_lex_state = 7},
  [1204] = {.lex_state = 229, .external_lex_state = 7},
  [1205] = {.lex_state = 8, .external_lex_state = 7},
  [1206] = {.lex_state = 8, .external_lex_state = 7},
  [1207] = {.lex_state = 8, .external_lex_state = 7},
  [1208] = {.lex_state = 229, .external_lex_state = 7},
  [1209] = {.lex_state = 8, .external_lex_state = 7},
  [1210] = {.lex_state = 8, .external_lex_state = 7},
  [1211] = {.lex_state = 8, .external_lex_state = 7},
  [1212] = {.lex_state = 8, .external_lex_state = 7},
  [1213] = {.lex_state = 8, .external_lex_state = 7},
  [1214] = {.lex_state = 8, .external_lex_state = 7},
  [1215] = {.lex_state = 229, .external_lex_state = 7},
  [1216] = {.lex_state = 229, .external_lex_state = 7},
  [1217] = {.lex_state = 8, .external_lex_state = 7},
  [1218] = {.lex_state = 8, .external_lex_state = 7},
  [1219] = {.lex_state = 8, .external_lex_state = 7},
  [1220] = {.lex_state = 8, .external_lex_state = 7},
  [1221] = {.lex_state = 8, .external_lex_state = 7},
  [1222] = {.lex_state = 8, .external_lex_state = 6},
  [1223] = {.lex_state = 229, .external_lex_state = 6},
  [1224] = {.lex_state = 8, .external_lex_state = 6},
  [1225] = {.lex_state = 229, .external_lex_state = 6},
  [1226] = {.lex_state = 8, .external_lex_state = 6},
  [1227] = {.lex_state = 229, .external_lex_state = 6},
  [1228] = {.lex_state = 8, .external_lex_state = 6},
  [1229] = {.lex_state = 8, .external_lex_state = 6},
  [1230] = {.lex_state = 229, .external_lex_state = 6},
  [1231] = {.lex_state = 229, .external_lex_state = 6},
  [1232] = {.lex_state = 8, .external_lex_state = 6},
  [1233] = {.lex_state = 8, .external_lex_state = 6},
  [1234] = {.lex_state = 229, .external_lex_state = 6},
  [1235] = {.lex_state = 229, .external_lex_state = 6},
  [1236] = {.lex_state = 229, .external_lex_state = 6},
  [1237] = {.lex_state = 8, .external_lex_state = 6},
  [1238] = {.lex_state = 8, .external_lex_state = 6},
  [1239] = {.lex_state = 8, .external_lex_state = 6},
  [1240] = {.lex_state = 229, .external_lex_state = 6},
  [1241] = {.lex_state = 8, .external_lex_state = 6},
  [1242] = {.lex_state = 8, .external_lex_state = 6},
  [1243] = {.lex_state = 8, .external_lex_state = 6},
  [1244] = {.lex_state = 8, .external_lex_state = 6},
  [1245] = {.lex_state = 229, .external_lex_state = 6},
  [1246] = {.lex_state = 229, .external_lex_state = 6},
  [1247] = {.lex_state = 8, .external_lex_state = 6},
  [1248] = {.lex_state = 8, .external_lex_state = 6},
  [1249] = {.lex_state = 229, .external_lex_state = 6},
  [1250] = {.lex_state = 8, .external_lex_state = 6},
  [1251] = {.lex_state = 229, .external_lex_state = 6},
  [1252] = {.lex_state = 229, .external_lex_state = 6},
  [1253] = {.lex_state = 8, .external_lex_state = 6},
  [1254] = {.lex_state = 229, .external_lex_state = 6},
  [1255] = {.lex_state = 8, .external_lex_state = 6},
  [1256] = {.lex_state = 229, .external_lex_state = 6},
  [1257] = {.lex_state = 8, .external_lex_state = 6},
  [1258] = {.lex_state = 8, .external_lex_state = 6},
  [1259] = {.lex_state = 8, .external_lex_state = 6},
  [1260] = {.lex_state = 8, .external_lex_state = 6},
  [1261] = {.lex_state = 8, .external_lex_state = 6},
  [1262] = {.lex_state = 229, .external_lex_state = 6},
  [1263] = {.lex_state = 229, .external_lex_state = 6},
  [1264] = {.lex_state = 229, .external_lex_state = 6},
  [1265] = {.lex_state = 8, .external_lex_state = 6},
  [1266] = {.lex_state = 8, .external_lex_state = 6},
  [1267] = {.lex_state = 8, .external_lex_state = 6},
  [1268] = {.lex_state = 229, .external_lex_state = 6},
  [1269] = {.lex_state = 229, .external_lex_state = 6},
  [1270] = {.lex_state = 229, .external_lex_state = 6},
  [1271] = {.lex_state = 229, .external_lex_state = 6},
  [1272] = {.lex_state = 229, .external_lex_state = 6},
  [1273] = {.lex_state = 229, .external_lex_state = 6},
  [1274] = {.lex_state = 8, .external_lex_state = 6},
  [1275] = {.lex_state = 229, .external_lex_state = 6},
  [1276] = {.lex_state = 8, .external_lex_state = 6},
  [1277] = {.lex_state = 8, .external_lex_state = 6},
  [1278] = {.lex_state = 229, .external_lex_state = 6},
  [1279] = {.lex_state = 229, .external_lex_state = 6},
  [1280] = {.lex_state = 229, .external_lex_state = 6},
  [1281] = {.lex_state = 8, .external_lex_state = 6},
  [1282] = {.lex_state = 229, .external_lex_state = 6},
  [1283] = {.lex_state = 229, .external_lex_state = 6},
  [1284] = {.lex_state = 8, .external_lex_state = 6},
  [1285] = {.lex_state = 8, .external_lex_state = 6},
  [1286] = {.lex_state = 229, .external_lex_state = 6},
  [1287] = {.lex_state = 229, .external_lex_state = 6},
  [1288] = {.lex_state = 8, .external_lex_state = 6},
  [1289] = {.lex_state = 229, .external_lex_state = 6},
  [1290] = {.lex_state = 229, .external_lex_state = 6},
  [1291] = {.lex_state = 8, .external_lex_state = 6},
  [1292] = {.lex_state = 229, .external_lex_state = 6},
  [1293] = {.lex_state = 8, .external_lex_state = 6},
  [1294] = {.lex_state = 229, .external_lex_state = 6},
  [1295] = {.lex_state = 229, .external_lex_state = 6},
  [1296] = {.lex_state = 229, .external_lex_state = 6},
  [1297] = {.lex_state = 229, .external_lex_state = 6},
  [1298] = {.lex_state = 8, .external_lex_state = 6},
  [1299] = {.lex_state = 8, .external_lex_state = 6},
  [1300] = {.lex_state = 8, .external_lex_state = 6},
  [1301] = {.lex_state = 8, .external_lex_state = 6},
  [1302] = {.lex_state = 8, .external_lex_state = 6},
  [1303] = {.lex_state = 229, .external_lex_state = 6},
  [1304] = {.lex_state = 229, .external_lex_state = 6},
  [1305] = {.lex_state = 229, .external_lex_state = 6},
  [1306] = {.lex_state = 229, .external_lex_state = 6},
  [1307] = {.lex_state = 8, .external_lex_state = 6},
  [1308] = {.lex_state = 8, .external_lex_state = 6},
  [1309] = {.lex_state = 8, .external_lex_state = 6},
  [1310] = {.lex_state = 10, .external_lex_state = 6},
  [1311] = {.lex_state = 10, .external_lex_state = 6},
  [1312] = {.lex_state = 10, .external_lex_state = 6},
  [1313] = {.lex_state = 10, .external_lex_state = 6},
  [1314] = {.lex_state = 10, .external_lex_state = 6},
  [1315] = {.lex_state = 10, .external_lex_state = 6},
  [1316] = {.lex_state = 10, .external_lex_state = 6},
  [1317] = {.lex_state = 10, .external_lex_state = 6},
  [1318] = {.lex_state = 10, .external_lex_state = 6},
  [1319] = {.lex_state = 10, .external_lex_state = 6},
  [1320] = {.lex_state = 10, .external_lex_state = 6},
  [1321] = {.lex_state = 10, .external_lex_state = 6},
  [1322] = {.lex_state = 10, .external_lex_state = 6},
  [1323] = {.lex_state = 10, .external_lex_state = 6},
  [1324] = {.lex_state = 10, .external_lex_state = 6},
  [1325] = {.lex_state = 10, .external_lex_state = 6},
  [1326] = {.lex_state = 10, .external_lex_state = 6},
  [1327] = {.lex_state = 10, .external_lex_state = 6},
  [1328] = {.lex_state = 10, .external_lex_state = 6},
  [1329] = {.lex_state = 10, .external_lex_state = 6},
  [1330] = {.lex_state = 10, .external_lex_state = 6},
  [1331] = {.lex_state = 10, .external_lex_state = 6},
  [1332] = {.lex_state = 10, .external_lex_state = 6},
  [1333] = {.lex_state = 10, .external_lex_state = 6},
  [1334] = {.lex_state = 10, .external_lex_state = 6},
  [1335] = {.lex_state = 10, .external_lex_state = 6},
  [1336] = {.lex_state = 10, .external_lex_state = 6},
  [1337] = {.lex_state = 10, .external_lex_state = 6},
  [1338] = {.lex_state = 10, .external_lex_state = 6},
  [1339] = {.lex_state = 10, .external_lex_state = 6},
  [1340] = {.lex_state = 10, .external_lex_state = 6},
  [1341] = {.lex_state = 10, .external_lex_state = 6},
  [1342] = {.lex_state = 10, .external_lex_state = 6},
  [1343] = {.lex_state = 10, .external_lex_state = 6},
  [1344] = {.lex_state = 10, .external_lex_state = 6},
  [1345] = {.lex_state = 10, .external_lex_state = 6},
  [1346] = {.lex_state = 10, .external_lex_state = 6},
  [1347] = {.lex_state = 10, .external_lex_state = 6},
  [1348] = {.lex_state = 10, .external_lex_state = 6},
  [1349] = {.lex_state = 10, .external_lex_state = 6},
  [1350] = {.lex_state = 10, .external_lex_state = 6},
  [1351] = {.lex_state = 10, .external_lex_state = 6},
  [1352] = {.lex_state = 10, .external_lex_state = 6},
  [1353] = {.lex_state = 10, .external_lex_state = 6},
  [1354] = {.lex_state = 10, .external_lex_state = 6},
  [1355] = {.lex_state = 10, .external_lex_state = 6},
  [1356] = {.lex_state = 11, .external_lex_state = 6},
  [1357] = {.lex_state = 11, .external_lex_state = 6},
  [1358] = {.lex_state = 11, .external_lex_state = 6},
  [1359] = {.lex_state = 11, .external_lex_state = 6},
  [1360] = {.lex_state = 11, .external_lex_state = 6},
  [1361] = {.lex_state = 11, .external_lex_state = 6},
  [1362] = {.lex_state = 11, .external_lex_state = 6},
  [1363] = {.lex_state = 11, .external_lex_state = 6},
  [1364] = {.lex_state = 11, .external_lex_state = 6},
  [1365] = {.lex_state = 11, .external_lex_state = 6},
  [1366] = {.lex_state = 11, .external_lex_state = 6},
  [1367] = {.lex_state = 11, .external_lex_state = 6},
  [1368] = {.lex_state = 11, .external_lex_state = 6},
  [1369] = {.lex_state = 11, .external_lex_state = 6},
  [1370] = {.lex_state = 11, .external_lex_state = 6},
  [1371] = {.lex_state = 11, .external_lex_state = 6},
  [1372] = {.lex_state = 11, .external_lex_state = 6},
  [1373] = {.lex_state = 11, .external_lex_state = 6},
  [1374] = {.lex_state = 11, .external_lex_state = 6},
  [1375] = {.lex_state = 11, .external_lex_state = 6},
  [1376] = {.lex_state = 11, .external_lex_state = 6},
  [1377] = {.lex_state = 11, .external_lex_state = 6},
  [1378] = {.lex_state = 11, .external_lex_state = 6},
  [1379] = {.lex_state = 11, .external_lex_state = 6},
  [1380] = {.lex_state = 11, .external_lex_state = 6},
  [1381] = {.lex_state = 11, .external_lex_state = 6},
  [1382] = {.lex_state = 11, .external_lex_state = 6},
  [1383] = {.lex_state = 11, .external_lex_state = 6},
  [1384] = {.lex_state = 11, .external_lex_state = 6},
  [1385] = {.lex_state = 10, .external_lex_state = 6},
  [1386] = {.lex_state = 10, .external_lex_state = 6},
  [1387] = {.lex_state = 10, .external_lex_state = 6},
  [1388] = {.lex_state = 10, .external_lex_state = 6},
  [1389] = {.lex_state = 10, .external_lex_state = 6},
  [1390] = {.lex_state = 10, .external_lex_state = 6},
  [1391] = {.lex_state = 10, .external_lex_state = 6},
  [1392] = {.lex_state = 10, .external_lex_state = 6},
  [1393] = {.lex_state = 10, .external_lex_state = 6},
  [1394] = {.lex_state = 10, .external_lex_state = 6},
  [1395] = {.lex_state = 10, .external_lex_state = 6},
  [1396] = {.lex_state = 10, .external_lex_state = 6},
  [1397] = {.lex_state = 10, .external_lex_state = 6},
  [1398] = {.lex_state = 10, .external_lex_state = 6},
  [1399] = {.lex_state = 10, .external_lex_state = 6},
  [1400] = {.lex_state = 10, .external_lex_state = 6},
  [1401] = {.lex_state = 10, .external_lex_state = 6},
  [1402] = {.lex_state = 10, .external_lex_state = 6},
  [1403] = {.lex_state = 10, .external_lex_state = 6},
  [1404] = {.lex_state = 10, .external_lex_state = 6},
  [1405] = {.lex_state = 10, .external_lex_state = 6},
  [1406] = {.lex_state = 10, .external_lex_state = 6},
  [1407] = {.lex_state = 10, .external_lex_state = 6},
  [1408] = {.lex_state = 10, .external_lex_state = 6},
  [1409] = {.lex_state = 10, .external_lex_state = 6},
  [1410] = {.lex_state = 10, .external_lex_state = 6},
  [1411] = {.lex_state = 10, .external_lex_state = 6},
  [1412] = {.lex_state = 10, .external_lex_state = 6},
  [1413] = {.lex_state = 10, .external_lex_state = 6},
  [1414] = {.lex_state = 10, .external_lex_state = 6},
  [1415] = {.lex_state = 10, .external_lex_state = 6},
  [1416] = {.lex_state = 10, .external_lex_state = 6},
  [1417] = {.lex_state = 10, .external_lex_state = 6},
  [1418] = {.lex_state = 10, .external_lex_state = 6},
  [1419] = {.lex_state = 10, .external_lex_state = 6},
  [1420] = {.lex_state = 10, .external_lex_state = 6},
  [1421] = {.lex_state = 10, .external_lex_state = 6},
  [1422] = {.lex_state = 10, .external_lex_state = 6},
  [1423] = {.lex_state = 10, .external_lex_state = 6},
  [1424] = {.lex_state = 10, .external_lex_state = 6},
  [1425] = {.lex_state = 10, .external_lex_state = 6},
  [1426] = {.lex_state = 10, .external_lex_state = 6},
  [1427] = {.lex_state = 10, .external_lex_state = 6},
  [1428] = {.lex_state = 10, .external_lex_state = 8},
  [1429] = {.lex_state = 10, .external_lex_state = 6},
  [1430] = {.lex_state = 10, .external_lex_state = 6},
  [1431] = {.lex_state = 10, .external_lex_state = 6},
  [1432] = {.lex_state = 10, .external_lex_state = 6},
  [1433] = {.lex_state = 10, .external_lex_state = 6},
  [1434] = {.lex_state = 10, .external_lex_state = 8},
  [1435] = {.lex_state = 10, .external_lex_state = 6},
  [1436] = {.lex_state = 10, .external_lex_state = 8},
  [1437] = {.lex_state = 10, .external_lex_state = 8},
  [1438] = {.lex_state = 10, .external_lex_state = 8},
  [1439] = {.lex_state = 10, .external_lex_state = 8},
  [1440] = {.lex_state = 10, .external_lex_state = 8},
  [1441] = {.lex_state = 10, .external_lex_state = 8},
  [1442] = {.lex_state = 10, .external_lex_state = 8},
  [1443] = {.lex_state = 10, .external_lex_state = 8},
  [1444] = {.lex_state = 10, .external_lex_state = 8},
  [1445] = {.lex_state = 10, .external_lex_state = 8},
  [1446] = {.lex_state = 10, .external_lex_state = 8},
  [1447] = {.lex_state = 10, .external_lex_state = 8},
  [1448] = {.lex_state = 10, .external_lex_state = 8},
  [1449] = {.lex_state = 10, .external_lex_state = 8},
  [1450] = {.lex_state = 10, .external_lex_state = 8},
  [1451] = {.lex_state = 10, .external_lex_state = 8},
  [1452] = {.lex_state = 10, .external_lex_state = 8},
  [1453] = {.lex_state = 10, .external_lex_state = 8},
  [1454] = {.lex_state = 10, .external_lex_state = 8},
  [1455] = {.lex_state = 10, .external_lex_state = 8},
  [1456] = {.lex_state = 10, .external_lex_state = 8},
  [1457] = {.lex_state = 10, .external_lex_state = 8},
  [1458] = {.lex_state = 10, .external_lex_state = 8},
  [1459] = {.lex_state = 10, .external_lex_state = 8},
  [1460] = {.lex_state = 10, .external_lex_state = 8},
  [1461] = {.lex_state = 10, .external_lex_state = 8},
  [1462] = {.lex_state = 10, .external_lex_state = 8},
  [1463] = {.lex_state = 10, .external_lex_state = 8},
  [1464] = {.lex_state = 10, .external_lex_state = 8},
  [1465] = {.lex_state = 10, .external_lex_state = 8},
  [1466] = {.lex_state = 10, .external_lex_state = 6},
  [1467] = {.lex_state = 10, .external_lex_state = 6},
  [1468] = {.lex_state = 10, .external_lex_state = 8},
  [1469] = {.lex_state = 10, .external_lex_state = 8},
  [1470] = {.lex_state = 10, .external_lex_state = 8},
  [1471] = {.lex_state = 10, .external_lex_state = 8},
  [1472] = {.lex_state = 10, .external_lex_state = 8},
  [1473] = {.lex_state = 10, .external_lex_state = 8},
  [1474] = {.lex_state = 10, .external_lex_state = 8},
  [1475] = {.lex_state = 10, .external_lex_state = 8},
  [1476] = {.lex_state = 10, .external_lex_state = 6},
  [1477] = {.lex_state = 10, .external_lex_state = 6},
  [1478] = {.lex_state = 10, .external_lex_state = 6},
  [1479] = {.lex_state = 10, .external_lex_state = 6},
  [1480] = {.lex_state = 10, .external_lex_state = 6},
  [1481] = {.lex_state = 10, .external_lex_state = 6},
  [1482] = {.lex_state = 10, .external_lex_state = 6},
  [1483] = {.lex_state = 10, .external_lex_state = 6},
  [1484] = {.lex_state = 10, .external_lex_state = 6},
  [1485] = {.lex_state = 10, .external_lex_state = 6},
  [1486] = {.lex_state = 10, .external_lex_state = 6},
  [1487] = {.lex_state = 10, .external_lex_state = 6},
  [1488] = {.lex_state = 12, .external_lex_state = 9},
  [1489] = {.lex_state = 13, .external_lex_state = 9},
  [1490] = {.lex_state = 13, .external_lex_state = 9},
  [1491] = {.lex_state = 13, .external_lex_state = 9},
  [1492] = {.lex_state = 13, .external_lex_state = 9},
  [1493] = {.lex_state = 13, .external_lex_state = 9},
  [1494] = {.lex_state = 13, .external_lex_state = 9},
  [1495] = {.lex_state = 13, .external_lex_state = 9},
  [1496] = {.lex_state = 13, .external_lex_state = 9},
  [1497] = {.lex_state = 13, .external_lex_state = 9},
  [1498] = {.lex_state = 13, .external_lex_state = 9},
  [1499] = {.lex_state = 13, .external_lex_state = 9},
  [1500] = {.lex_state = 13, .external_lex_state = 9},
  [1501] = {.lex_state = 13, .external_lex_state = 9},
  [1502] = {.lex_state = 13, .external_lex_state = 9},
  [1503] = {.lex_state = 13, .external_lex_state = 9},
  [1504] = {.lex_state = 13, .external_lex_state = 9},
  [1505] = {.lex_state = 13, .external_lex_state = 9},
  [1506] = {.lex_state = 13, .external_lex_state = 9},
  [1507] = {.lex_state = 13, .external_lex_state = 9},
  [1508] = {.lex_state = 13, .external_lex_state = 9},
  [1509] = {.lex_state = 13, .external_lex_state = 9},
  [1510] = {.lex_state = 13, .external_lex_state = 9},
  [1511] = {.lex_state = 13, .external_lex_state = 9},
  [1512] = {.lex_state = 13, .external_lex_state = 9},
  [1513] = {.lex_state = 13, .external_lex_state = 9},
  [1514] = {.lex_state = 13, .external_lex_state = 9},
  [1515] = {.lex_state = 13, .external_lex_state = 9},
  [1516] = {.lex_state = 13, .external_lex_state = 9},
  [1517] = {.lex_state = 13, .external_lex_state = 9},
  [1518] = {.lex_state = 13, .external_lex_state = 9},
  [1519] = {.lex_state = 14, .external_lex_state = 6},
  [1520] = {.lex_state = 14, .external_lex_state = 6},
  [1521] = {.lex_state = 14, .external_lex_state = 6},
  [1522] = {.lex_state = 14, .external_lex_state = 6},
  [1523] = {.lex_state = 14, .external_lex_state = 6},
  [1524] = {.lex_state = 14, .external_lex_state = 6},
  [1525] = {.lex_state = 14, .external_lex_state = 6},
  [1526] = {.lex_state = 14, .external_lex_state = 6},
  [1527] = {.lex_state = 14, .external_lex_state = 6},
  [1528] = {.lex_state = 14, .external_lex_state = 6},
  [1529] = {.lex_state = 14, .external_lex_state = 6},
  [1530] = {.lex_state = 14, .external_lex_state = 6},
  [1531] = {.lex_state = 14, .external_lex_state = 6},
  [1532] = {.lex_state = 14, .external_lex_state = 6},
  [1533] = {.lex_state = 14, .external_lex_state = 6},
  [1534] = {.lex_state = 14, .external_lex_state = 6},
  [1535] = {.lex_state = 14, .external_lex_state = 6},
  [1536] = {.lex_state = 14, .external_lex_state = 6},
  [1537] = {.lex_state = 14, .external_lex_state = 6},
  [1538] = {.lex_state = 14, .external_lex_state = 6},
  [1539] = {.lex_state = 14, .external_lex_state = 6},
  [1540] = {.lex_state = 14, .external_lex_state = 6},
  [1541] = {.lex_state = 14, .external_lex_state = 6},
  [1542] = {.lex_state = 14, .external_lex_state = 6},
  [1543] = {.lex_state = 14, .external_lex_state = 6},
  [1544] = {.lex_state = 14, .external_lex_state = 6},
  [1545] = {.lex_state = 14, .external_lex_state = 6},
  [1546] = {.lex_state = 14, .external_lex_state = 6},
  [1547] = {.lex_state = 11, .external_lex_state = 9},
  [1548] = {.lex_state = 14, .external_lex_state = 6},
  [1549] = {.lex_state = 14, .external_lex_state = 6},
  [1550] = {.lex_state = 14, .external_lex_state = 6},
  [1551] = {.lex_state = 14, .external_lex_state = 6},
  [1552] = {.lex_state = 14, .external_lex_state = 6},
  [1553] = {.lex_state = 11, .external_lex_state = 6},
  [1554] = {.lex_state = 14, .external_lex_state = 6},
  [1555] = {.lex_state = 14, .external_lex_state = 6},
  [1556] = {.lex_state = 14, .external_lex_state = 6},
  [1557] = {.lex_state = 14, .external_lex_state = 6},
  [1558] = {.lex_state = 14, .external_lex_state = 6},
  [1559] = {.lex_state = 14, .external_lex_state = 6},
  [1560] = {.lex_state = 14, .external_lex_state = 6},
  [1561] = {.lex_state = 14, .external_lex_state = 6},
  [1562] = {.lex_state = 14, .external_lex_state = 6},
  [1563] = {.lex_state = 14, .external_lex_state = 6},
  [1564] = {.lex_state = 14, .external_lex_state = 6},
  [1565] = {.lex_state = 14, .external_lex_state = 6},
  [1566] = {.lex_state = 14, .external_lex_state = 6},
  [1567] = {.lex_state = 11, .external_lex_state = 9},
  [1568] = {.lex_state = 11, .external_lex_state = 9},
  [1569] = {.lex_state = 11, .external_lex_state = 9},
  [1570] = {.lex_state = 11, .external_lex_state = 9},
  [1571] = {.lex_state = 11, .external_lex_state = 9},
  [1572] = {.lex_state = 11, .external_lex_state = 9},
  [1573] = {.lex_state = 11, .external_lex_state = 9},
  [1574] = {.lex_state = 11, .external_lex_state = 9},
  [1575] = {.lex_state = 11, .external_lex_state = 9},
  [1576] = {.lex_state = 11, .external_lex_state = 9},
  [1577] = {.lex_state = 11, .external_lex_state = 9},
  [1578] = {.lex_state = 11, .external_lex_state = 9},
  [1579] = {.lex_state = 11, .external_lex_state = 9},
  [1580] = {.lex_state = 11, .external_lex_state = 9},
  [1581] = {.lex_state = 11, .external_lex_state = 9},
  [1582] = {.lex_state = 11, .external_lex_state = 9},
  [1583] = {.lex_state = 11, .external_lex_state = 9},
  [1584] = {.lex_state = 11, .external_lex_state = 9},
  [1585] = {.lex_state = 11, .external_lex_state = 9},
  [1586] = {.lex_state = 11, .external_lex_state = 9},
  [1587] = {.lex_state = 11, .external_lex_state = 9},
  [1588] = {.lex_state = 11, .external_lex_state = 9},
  [1589] = {.lex_state = 11, .external_lex_state = 9},
  [1590] = {.lex_state = 11, .external_lex_state = 9},
  [1591] = {.lex_state = 11, .external_lex_state = 9},
  [1592] = {.lex_state = 11, .external_lex_state = 9},
  [1593] = {.lex_state = 11, .external_lex_state = 9},
  [1594] = {.lex_state = 11, .external_lex_state = 9},
  [1595] = {.lex_state = 11, .external_lex_state = 9},
  [1596] = {.lex_state = 11, .external_lex_state = 9},
  [1597] = {.lex_state = 11, .external_lex_state = 9},
  [1598] = {.lex_state = 13, .external_lex_state = 6},
  [1599] = {.lex_state = 5, .external_lex_state = 4},
  [1600] = {.lex_state = 228, .external_lex_state = 4},
  [1601] = {.lex_state = 228, .external_lex_state = 4},
  [1602] = {.lex_state = 228, .external_lex_state = 4},
  [1603] = {.lex_state = 13, .external_lex_state = 6},
  [1604] = {.lex_state = 13, .external_lex_state = 6},
  [1605] = {.lex_state = 13, .external_lex_state = 6},
  [1606] = {.lex_state = 13, .external_lex_state = 6},
  [1607] = {.lex_state = 13, .external_lex_state = 6},
  [1608] = {.lex_state = 13, .external_lex_state = 6},
  [1609] = {.lex_state = 13, .external_lex_state = 6},
  [1610] = {.lex_state = 13, .external_lex_state = 6},
  [1611] = {.lex_state = 13, .external_lex_state = 6},
  [1612] = {.lex_state = 13, .external_lex_state = 6},
  [1613] = {.lex_state = 13, .external_lex_state = 6},
  [1614] = {.lex_state = 228, .external_lex_state = 4},
  [1615] = {.lex_state = 13, .external_lex_state = 6},
  [1616] = {.lex_state = 13, .external_lex_state = 6},
  [1617] = {.lex_state = 13, .external_lex_state = 6},
  [1618] = {.lex_state = 13, .external_lex_state = 6},
  [1619] = {.lex_state = 13, .external_lex_state = 6},
  [1620] = {.lex_state = 13, .external_lex_state = 6},
  [1621] = {.lex_state = 13, .external_lex_state = 6},
  [1622] = {.lex_state = 13, .external_lex_state = 6},
  [1623] = {.lex_state = 13, .external_lex_state = 6},
  [1624] = {.lex_state = 13, .external_lex_state = 6},
  [1625] = {.lex_state = 13, .external_lex_state = 6},
  [1626] = {.lex_state = 13, .external_lex_state = 6},
  [1627] = {.lex_state = 13, .external_lex_state = 6},
  [1628] = {.lex_state = 13, .external_lex_state = 6},
  [1629] = {.lex_state = 13, .external_lex_state = 6},
  [1630] = {.lex_state = 13, .external_lex_state = 6},
  [1631] = {.lex_state = 5, .external_lex_state = 4},
  [1632] = {.lex_state = 5, .external_lex_state = 4},
  [1633] = {.lex_state = 5, .external_lex_state = 4},
  [1634] = {.lex_state = 11, .external_lex_state = 6},
  [1635] = {.lex_state = 13, .external_lex_state = 6},
  [1636] = {.lex_state = 13, .external_lex_state = 6},
  [1637] = {.lex_state = 13, .external_lex_state = 6},
  [1638] = {.lex_state = 17, .external_lex_state = 6},
  [1639] = {.lex_state = 19, .external_lex_state = 6},
  [1640] = {.lex_state = 19, .external_lex_state = 6},
  [1641] = {.lex_state = 19, .external_lex_state = 6},
  [1642] = {.lex_state = 17, .external_lex_state = 6},
  [1643] = {.lex_state = 17, .external_lex_state = 6},
  [1644] = {.lex_state = 17, .external_lex_state = 6},
  [1645] = {.lex_state = 17, .external_lex_state = 6},
  [1646] = {.lex_state = 17, .external_lex_state = 6},
  [1647] = {.lex_state = 19, .external_lex_state = 6},
  [1648] = {.lex_state = 17, .external_lex_state = 6},
  [1649] = {.lex_state = 13, .external_lex_state = 6},
  [1650] = {.lex_state = 11, .external_lex_state = 9},
  [1651] = {.lex_state = 19, .external_lex_state = 6},
  [1652] = {.lex_state = 17, .external_lex_state = 6},
  [1653] = {.lex_state = 17, .external_lex_state = 6},
  [1654] = {.lex_state = 17, .external_lex_state = 6},
  [1655] = {.lex_state = 17, .external_lex_state = 6},
  [1656] = {.lex_state = 11, .external_lex_state = 9},
  [1657] = {.lex_state = 17, .external_lex_state = 6},
  [1658] = {.lex_state = 17, .external_lex_state = 6},
  [1659] = {.lex_state = 17, .external_lex_state = 6},
  [1660] = {.lex_state = 19, .external_lex_state = 6},
  [1661] = {.lex_state = 17, .external_lex_state = 6},
  [1662] = {.lex_state = 17, .external_lex_state = 6},
  [1663] = {.lex_state = 19, .external_lex_state = 6},
  [1664] = {.lex_state = 17, .external_lex_state = 6},
  [1665] = {.lex_state = 17, .external_lex_state = 6},
  [1666] = {.lex_state = 17, .external_lex_state = 6},
  [1667] = {.lex_state = 17, .external_lex_state = 6},
  [1668] = {.lex_state = 17, .external_lex_state = 6},
  [1669] = {.lex_state = 19, .external_lex_state = 6},
  [1670] = {.lex_state = 17, .external_lex_state = 6},
  [1671] = {.lex_state = 19, .external_lex_state = 6},
  [1672] = {.lex_state = 11, .external_lex_state = 6},
  [1673] = {.lex_state = 11, .external_lex_state = 6},
  [1674] = {.lex_state = 19, .external_lex_state = 6},
  [1675] = {.lex_state = 19, .external_lex_state = 6},
  [1676] = {.lex_state = 13, .external_lex_state = 6},
  [1677] = {.lex_state = 11, .external_lex_state = 8},
  [1678] = {.lex_state = 11, .external_lex_state = 8},
  [1679] = {.lex_state = 13, .external_lex_state = 6},
  [1680] = {.lex_state = 19, .external_lex_state = 6},
  [1681] = {.lex_state = 19, .external_lex_state = 6},
  [1682] = {.lex_state = 19, .external_lex_state = 6},
  [1683] = {.lex_state = 13, .external_lex_state = 6},
  [1684] = {.lex_state = 19, .external_lex_state = 6},
  [1685] = {.lex_state = 11, .external_lex_state = 8},
  [1686] = {.lex_state = 11, .external_lex_state = 8},
  [1687] = {.lex_state = 17, .external_lex_state = 6},
  [1688] = {.lex_state = 11, .external_lex_state = 8},
  [1689] = {.lex_state = 19, .external_lex_state = 6},
  [1690] = {.lex_state = 11, .external_lex_state = 8},
  [1691] = {.lex_state = 13, .external_lex_state = 6},
  [1692] = {.lex_state = 11, .external_lex_state = 8},
  [1693] = {.lex_state = 11, .external_lex_state = 8},
  [1694] = {.lex_state = 11, .external_lex_state = 8},
  [1695] = {.lex_state = 11, .external_lex_state = 8},
  [1696] = {.lex_state = 11, .external_lex_state = 8},
  [1697] = {.lex_state = 11, .external_lex_state = 8},
  [1698] = {.lex_state = 11, .external_lex_state = 8},
  [1699] = {.lex_state = 11, .external_lex_state = 8},
  [1700] = {.lex_state = 11, .external_lex_state = 8},
  [1701] = {.lex_state = 11, .external_lex_state = 8},
  [1702] = {.lex_state = 11, .external_lex_state = 8},
  [1703] = {.lex_state = 13, .external_lex_state = 6},
  [1704] = {.lex_state = 11, .external_lex_state = 8},
  [1705] = {.lex_state = 11, .external_lex_state = 8},
  [1706] = {.lex_state = 11, .external_lex_state = 8},
  [1707] = {.lex_state = 11, .external_lex_state = 8},
  [1708] = {.lex_state = 11, .external_lex_state = 8},
  [1709] = {.lex_state = 11, .external_lex_state = 8},
  [1710] = {.lex_state = 11, .external_lex_state = 8},
  [1711] = {.lex_state = 11, .external_lex_state = 8},
  [1712] = {.lex_state = 13, .external_lex_state = 6},
  [1713] = {.lex_state = 11, .external_lex_state = 8},
  [1714] = {.lex_state = 11, .external_lex_state = 8},
  [1715] = {.lex_state = 11, .external_lex_state = 8},
  [1716] = {.lex_state = 11, .external_lex_state = 8},
  [1717] = {.lex_state = 19, .external_lex_state = 6},
  [1718] = {.lex_state = 19, .external_lex_state = 6},
  [1719] = {.lex_state = 19, .external_lex_state = 6},
  [1720] = {.lex_state = 13, .external_lex_state = 6},
  [1721] = {.lex_state = 19, .external_lex_state = 6},
  [1722] = {.lex_state = 19, .external_lex_state = 6},
  [1723] = {.lex_state = 17, .external_lex_state = 6},
  [1724] = {.lex_state = 17, .external_lex_state = 6},
  [1725] = {.lex_state = 17, .external_lex_state = 6},
  [1726] = {.lex_state = 19, .external_lex_state = 6},
  [1727] = {.lex_state = 13, .external_lex_state = 6},
  [1728] = {.lex_state = 19, .external_lex_state = 6},
  [1729] = {.lex_state = 13, .external_lex_state = 6},
  [1730] = {.lex_state = 19, .external_lex_state = 6},
  [1731] = {.lex_state = 13, .external_lex_state = 6},
  [1732] = {.lex_state = 19, .external_lex_state = 6},
  [1733] = {.lex_state = 13, .external_lex_state = 6},
  [1734] = {.lex_state = 17, .external_lex_state = 6},
  [1735] = {.lex_state = 13, .external_lex_state = 6},
  [1736] = {.lex_state = 13, .external_lex_state = 6},
  [1737] = {.lex_state = 13, .external_lex_state = 6},
  [1738] = {.lex_state = 17, .external_lex_state = 6},
  [1739] = {.lex_state = 17, .external_lex_state = 6},
  [1740] = {.lex_state = 11, .external_lex_state = 6},
  [1741] = {.lex_state = 19, .external_lex_state = 6},
  [1742] = {.lex_state = 19, .external_lex_state = 6},
  [1743] = {.lex_state = 19, .external_lex_state = 6},
  [1744] = {.lex_state = 11, .external_lex_state = 6},
  [1745] = {.lex_state = 19, .external_lex_state = 6},
  [1746] = {.lex_state = 12, .external_lex_state = 6},
  [1747] = {.lex_state = 12, .external_lex_state = 6},
  [1748] = {.lex_state = 11, .external_lex_state = 6},
  [1749] = {.lex_state = 11, .external_lex_state = 6},
  [1750] = {.lex_state = 12, .external_lex_state = 6},
  [1751] = {.lex_state = 11, .external_lex_state = 6},
  [1752] = {.lex_state = 11, .external_lex_state = 6},
  [1753] = {.lex_state = 11, .external_lex_state = 8},
  [1754] = {.lex_state = 12, .external_lex_state = 6},
  [1755] = {.lex_state = 12, .external_lex_state = 6},
  [1756] = {.lex_state = 11, .external_lex_state = 10},
  [1757] = {.lex_state = 13, .external_lex_state = 6},
  [1758] = {.lex_state = 11, .external_lex_state = 6},
  [1759] = {.lex_state = 13, .external_lex_state = 6},
  [1760] = {.lex_state = 11, .external_lex_state = 6},
  [1761] = {.lex_state = 13, .external_lex_state = 6},
  [1762] = {.lex_state = 11, .external_lex_state = 6},
  [1763] = {.lex_state = 13, .external_lex_state = 6},
  [1764] = {.lex_state = 11, .external_lex_state = 6},
  [1765] = {.lex_state = 13, .external_lex_state = 6},
  [1766] = {.lex_state = 11, .external_lex_state = 6},
  [1767] = {.lex_state = 11, .external_lex_state = 6},
  [1768] = {.lex_state = 13, .external_lex_state = 6},
  [1769] = {.lex_state = 11, .external_lex_state = 6},
  [1770] = {.lex_state = 13, .external_lex_state = 6},
  [1771] = {.lex_state = 11, .external_lex_state = 6},
  [1772] = {.lex_state = 13, .external_lex_state = 6},
  [1773] = {.lex_state = 11, .external_lex_state = 6},
  [1774] = {.lex_state = 13, .external_lex_state = 6},
  [1775] = {.lex_state = 11, .external_lex_state = 6},
  [1776] = {.lex_state = 11, .external_lex_state = 6},
  [1777] = {.lex_state = 13, .external_lex_state = 6},
  [1778] = {.lex_state = 11, .external_lex_state = 6},
  [1779] = {.lex_state = 13, .external_lex_state = 6},
  [1780] = {.lex_state = 11, .external_lex_state = 6},
  [1781] = {.lex_state = 13, .external_lex_state = 6},
  [1782] = {.lex_state = 11, .external_lex_state = 6},
  [1783] = {.lex_state = 13, .external_lex_state = 6},
  [1784] = {.lex_state = 11, .external_lex_state = 6},
  [1785] = {.lex_state = 11, .external_lex_state = 6},
  [1786] = {.lex_state = 13, .external_lex_state = 6},
  [1787] = {.lex_state = 11, .external_lex_state = 6},
  [1788] = {.lex_state = 13, .external_lex_state = 6},
  [1789] = {.lex_state = 11, .external_lex_state = 6},
  [1790] = {.lex_state = 13, .external_lex_state = 6},
  [1791] = {.lex_state = 11, .external_lex_state = 6},
  [1792] = {.lex_state = 11, .external_lex_state = 6},
  [1793] = {.lex_state = 17, .external_lex_state = 6},
  [1794] = {.lex_state = 11, .external_lex_state = 10},
  [1795] = {.lex_state = 11, .external_lex_state = 10},
  [1796] = {.lex_state = 11, .external_lex_state = 10},
  [1797] = {.lex_state = 11, .external_lex_state = 10},
  [1798] = {.lex_state = 11, .external_lex_state = 6},
  [1799] = {.lex_state = 11, .external_lex_state = 10},
  [1800] = {.lex_state = 11, .external_lex_state = 10},
  [1801] = {.lex_state = 11, .external_lex_state = 10},
  [1802] = {.lex_state = 11, .external_lex_state = 10},
  [1803] = {.lex_state = 11, .external_lex_state = 10},
  [1804] = {.lex_state = 11, .external_lex_state = 10},
  [1805] = {.lex_state = 11, .external_lex_state = 10},
  [1806] = {.lex_state = 11, .external_lex_state = 10},
  [1807] = {.lex_state = 11, .external_lex_state = 10},
  [1808] = {.lex_state = 11, .external_lex_state = 10},
  [1809] = {.lex_state = 11, .external_lex_state = 10},
  [1810] = {.lex_state = 11, .external_lex_state = 10},
  [1811] = {.lex_state = 11, .external_lex_state = 10},
  [1812] = {.lex_state = 11, .external_lex_state = 10},
  [1813] = {.lex_state = 11, .external_lex_state = 8},
  [1814] = {.lex_state = 11, .external_lex_state = 10},
  [1815] = {.lex_state = 11, .external_lex_state = 10},
  [1816] = {.lex_state = 11, .external_lex_state = 10},
  [1817] = {.lex_state = 11, .external_lex_state = 10},
  [1818] = {.lex_state = 11, .external_lex_state = 10},
  [1819] = {.lex_state = 19, .external_lex_state = 6},
  [1820] = {.lex_state = 11, .external_lex_state = 10},
  [1821] = {.lex_state = 11, .external_lex_state = 10},
  [1822] = {.lex_state = 11, .external_lex_state = 10},
  [1823] = {.lex_state = 11, .external_lex_state = 10},
  [1824] = {.lex_state = 11, .external_lex_state = 10},
  [1825] = {.lex_state = 19, .external_lex_state = 6},
  [1826] = {.lex_state = 11, .external_lex_state = 6},
  [1827] = {.lex_state = 11, .external_lex_state = 6},
  [1828] = {.lex_state = 11, .external_lex_state = 6},
  [1829] = {.lex_state = 11, .external_lex_state = 6},
  [1830] = {.lex_state = 11, .external_lex_state = 6},
  [1831] = {.lex_state = 11, .external_lex_state = 6},
  [1832] = {.lex_state = 11, .external_lex_state = 6},
  [1833] = {.lex_state = 11, .external_lex_state = 6},
  [1834] = {.lex_state = 11, .external_lex_state = 6},
  [1835] = {.lex_state = 11, .external_lex_state = 6},
  [1836] = {.lex_state = 11, .external_lex_state = 6},
  [1837] = {.lex_state = 11, .external_lex_state = 6},
  [1838] = {.lex_state = 11, .external_lex_state = 6},
  [1839] = {.lex_state = 11, .external_lex_state = 6},
  [1840] = {.lex_state = 11, .external_lex_state = 6},
  [1841] = {.lex_state = 11, .external_lex_state = 6},
  [1842] = {.lex_state = 11, .external_lex_state = 6},
  [1843] = {.lex_state = 11, .external_lex_state = 6},
  [1844] = {.lex_state = 11, .external_lex_state = 6},
  [1845] = {.lex_state = 11, .external_lex_state = 6},
  [1846] = {.lex_state = 11, .external_lex_state = 6},
  [1847] = {.lex_state = 11, .external_lex_state = 6},
  [1848] = {.lex_state = 11, .external_lex_state = 6},
  [1849] = {.lex_state = 11, .external_lex_state = 6},
  [1850] = {.lex_state = 11, .external_lex_state = 6},
  [1851] = {.lex_state = 11, .external_lex_state = 6},
  [1852] = {.lex_state = 11, .external_lex_state = 6},
  [1853] = {.lex_state = 11, .external_lex_state = 6},
  [1854] = {.lex_state = 11, .external_lex_state = 6},
  [1855] = {.lex_state = 11, .external_lex_state = 8},
  [1856] = {.lex_state = 11, .external_lex_state = 6},
  [1857] = {.lex_state = 11, .external_lex_state = 6},
  [1858] = {.lex_state = 11, .external_lex_state = 6},
  [1859] = {.lex_state = 11, .external_lex_state = 6},
  [1860] = {.lex_state = 11, .external_lex_state = 6},
  [1861] = {.lex_state = 11, .external_lex_state = 6},
  [1862] = {.lex_state = 11, .external_lex_state = 6},
  [1863] = {.lex_state = 11, .external_lex_state = 6},
  [1864] = {.lex_state = 11, .external_lex_state = 6},
  [1865] = {.lex_state = 11, .external_lex_state = 6},
  [1866] = {.lex_state = 11, .external_lex_state = 6},
  [1867] = {.lex_state = 11, .external_lex_state = 6},
  [1868] = {.lex_state = 11, .external_lex_state = 6},
  [1869] = {.lex_state = 11, .external_lex_state = 6},
  [1870] = {.lex_state = 11, .external_lex_state = 6},
  [1871] = {.lex_state = 11, .external_lex_state = 6},
  [1872] = {.lex_state = 11, .external_lex_state = 6},
  [1873] = {.lex_state = 11, .external_lex_state = 6},
  [1874] = {.lex_state = 11, .external_lex_state = 6},
  [1875] = {.lex_state = 11, .external_lex_state = 6},
  [1876] = {.lex_state = 11, .external_lex_state = 6},
  [1877] = {.lex_state = 11, .external_lex_state = 6},
  [1878] = {.lex_state = 11, .external_lex_state = 6},
  [1879] = {.lex_state = 11, .external_lex_state = 6},
  [1880] = {.lex_state = 11, .external_lex_state = 6},
  [1881] = {.lex_state = 11, .external_lex_state = 6},
  [1882] = {.lex_state = 11, .external_lex_state = 6},
  [1883] = {.lex_state = 11, .external_lex_state = 6},
  [1884] = {.lex_state = 11, .external_lex_state = 6},
  [1885] = {.lex_state = 11, .external_lex_state = 6},
  [1886] = {.lex_state = 11, .external_lex_state = 6},
  [1887] = {.lex_state = 11, .external_lex_state = 6},
  [1888] = {.lex_state = 11, .external_lex_state = 6},
  [1889] = {.lex_state = 11, .external_lex_state = 6},
  [1890] = {.lex_state = 11, .external_lex_state = 6},
  [1891] = {.lex_state = 11, .external_lex_state = 8},
  [1892] = {.lex_state = 11, .external_lex_state = 8},
  [1893] = {.lex_state = 11, .external_lex_state = 8},
  [1894] = {.lex_state = 11, .external_lex_state = 6},
  [1895] = {.lex_state = 11, .external_lex_state = 8},
  [1896] = {.lex_state = 11, .external_lex_state = 8},
  [1897] = {.lex_state = 11, .external_lex_state = 6},
  [1898] = {.lex_state = 11, .external_lex_state = 6},
  [1899] = {.lex_state = 11, .external_lex_state = 10},
  [1900] = {.lex_state = 11, .external_lex_state = 6},
  [1901] = {.lex_state = 11, .external_lex_state = 10},
  [1902] = {.lex_state = 11, .external_lex_state = 6},
  [1903] = {.lex_state = 11, .external_lex_state = 6},
  [1904] = {.lex_state = 11, .external_lex_state = 8},
  [1905] = {.lex_state = 11, .external_lex_state = 6},
  [1906] = {.lex_state = 11, .external_lex_state = 6},
  [1907] = {.lex_state = 11, .external_lex_state = 6},
  [1908] = {.lex_state = 11, .external_lex_state = 6},
  [1909] = {.lex_state = 11, .external_lex_state = 6},
  [1910] = {.lex_state = 11, .external_lex_state = 6},
  [1911] = {.lex_state = 11, .external_lex_state = 6},
  [1912] = {.lex_state = 11, .external_lex_state = 6},
  [1913] = {.lex_state = 11, .external_lex_state = 6},
  [1914] = {.lex_state = 11, .external_lex_state = 6},
  [1915] = {.lex_state = 11, .external_lex_state = 6},
  [1916] = {.lex_state = 11, .external_lex_state = 6},
  [1917] = {.lex_state = 11, .external_lex_state = 6},
  [1918] = {.lex_state = 11, .external_lex_state = 6},
  [1919] = {.lex_state = 11, .external_lex_state = 6},
  [1920] = {.lex_state = 11, .external_lex_state = 6},
  [1921] = {.lex_state = 11, .external_lex_state = 6},
  [1922] = {.lex_state = 11, .external_lex_state = 6},
  [1923] = {.lex_state = 11, .external_lex_state = 6},
  [1924] = {.lex_state = 11, .external_lex_state = 6},
  [1925] = {.lex_state = 11, .external_lex_state = 6},
  [1926] = {.lex_state = 11, .external_lex_state = 6},
  [1927] = {.lex_state = 11, .external_lex_state = 6},
  [1928] = {.lex_state = 11, .external_lex_state = 6},
  [1929] = {.lex_state = 11, .external_lex_state = 6},
  [1930] = {.lex_state = 11, .external_lex_state = 6},
  [1931] = {.lex_state = 11, .external_lex_state = 6},
  [1932] = {.lex_state = 11, .external_lex_state = 6},
  [1933] = {.lex_state = 11, .external_lex_state = 6},
  [1934] = {.lex_state = 11, .external_lex_state = 6},
  [1935] = {.lex_state = 11, .external_lex_state = 6},
  [1936] = {.lex_state = 11, .external_lex_state = 6},
  [1937] = {.lex_state = 11, .external_lex_state = 6},
  [1938] = {.lex_state = 11, .external_lex_state = 6},
  [1939] = {.lex_state = 11, .external_lex_state = 6},
  [1940] = {.lex_state = 11, .external_lex_state = 6},
  [1941] = {.lex_state = 11, .external_lex_state = 6},
  [1942] = {.lex_state = 11, .external_lex_state = 6},
  [1943] = {.lex_state = 11, .external_lex_state = 6},
  [1944] = {.lex_state = 11, .external_lex_state = 6},
  [1945] = {.lex_state = 11, .external_lex_state = 6},
  [1946] = {.lex_state = 11, .external_lex_state = 6},
  [1947] = {.lex_state = 11, .external_lex_state = 6},
  [1948] = {.lex_state = 11, .external_lex_state = 6},
  [1949] = {.lex_state = 11, .external_lex_state = 6},
  [1950] = {.lex_state = 11, .external_lex_state = 6},
  [1951] = {.lex_state = 11, .external_lex_state = 6},
  [1952] = {.lex_state = 11, .external_lex_state = 6},
  [1953] = {.lex_state = 11, .external_lex_state = 6},
  [1954] = {.lex_state = 11, .external_lex_state = 6},
  [1955] = {.lex_state = 11, .external_lex_state = 6},
  [1956] = {.lex_state = 11, .external_lex_state = 6},
  [1957] = {.lex_state = 11, .external_lex_state = 6},
  [1958] = {.lex_state = 11, .external_lex_state = 6},
  [1959] = {.lex_state = 11, .external_lex_state = 6},
  [1960] = {.lex_state = 11, .external_lex_state = 6},
  [1961] = {.lex_state = 11, .external_lex_state = 6},
  [1962] = {.lex_state = 11, .external_lex_state = 6},
  [1963] = {.lex_state = 11, .external_lex_state = 6},
  [1964] = {.lex_state = 11, .external_lex_state = 6},
  [1965] = {.lex_state = 11, .external_lex_state = 6},
  [1966] = {.lex_state = 11, .external_lex_state = 6},
  [1967] = {.lex_state = 11, .external_lex_state = 6},
  [1968] = {.lex_state = 11, .external_lex_state = 6},
  [1969] = {.lex_state = 11, .external_lex_state = 6},
  [1970] = {.lex_state = 11, .external_lex_state = 6},
  [1971] = {.lex_state = 11, .external_lex_state = 6},
  [1972] = {.lex_state = 11, .external_lex_state = 6},
  [1973] = {.lex_state = 11, .external_lex_state = 6},
  [1974] = {.lex_state = 11, .external_lex_state = 6},
  [1975] = {.lex_state = 11, .external_lex_state = 6},
  [1976] = {.lex_state = 11, .external_lex_state = 6},
  [1977] = {.lex_state = 11, .external_lex_state = 6},
  [1978] = {.lex_state = 11, .external_lex_state = 6},
  [1979] = {.lex_state = 11, .external_lex_state = 6},
  [1980] = {.lex_state = 11, .external_lex_state = 6},
  [1981] = {.lex_state = 11, .external_lex_state = 6},
  [1982] = {.lex_state = 11, .external_lex_state = 6},
  [1983] = {.lex_state = 11, .external_lex_state = 6},
  [1984] = {.lex_state = 11, .external_lex_state = 6},
  [1985] = {.lex_state = 11, .external_lex_state = 6},
  [1986] = {.lex_state = 11, .external_lex_state = 6},
  [1987] = {.lex_state = 11, .external_lex_state = 6},
  [1988] = {.lex_state = 11, .external_lex_state = 6},
  [1989] = {.lex_state = 11, .external_lex_state = 6},
  [1990] = {.lex_state = 11, .external_lex_state = 6},
  [1991] = {.lex_state = 11, .external_lex_state = 6},
  [1992] = {.lex_state = 11, .external_lex_state = 6},
  [1993] = {.lex_state = 11, .external_lex_state = 6},
  [1994] = {.lex_state = 11, .external_lex_state = 6},
  [1995] = {.lex_state = 11, .external_lex_state = 6},
  [1996] = {.lex_state = 11, .external_lex_state = 6},
  [1997] = {.lex_state = 11, .external_lex_state = 6},
  [1998] = {.lex_state = 11, .external_lex_state = 6},
  [1999] = {.lex_state = 11, .external_lex_state = 6},
  [2000] = {.lex_state = 11, .external_lex_state = 6},
  [2001] = {.lex_state = 11, .external_lex_state = 6},
  [2002] = {.lex_state = 11, .external_lex_state = 6},
  [2003] = {.lex_state = 11, .external_lex_state = 6},
  [2004] = {.lex_state = 11, .external_lex_state = 6},
  [2005] = {.lex_state = 11, .external_lex_state = 6},
  [2006] = {.lex_state = 11, .external_lex_state = 6},
  [2007] = {.lex_state = 11, .external_lex_state = 6},
  [2008] = {.lex_state = 11, .external_lex_state = 6},
  [2009] = {.lex_state = 11, .external_lex_state = 6},
  [2010] = {.lex_state = 11, .external_lex_state = 6},
  [2011] = {.lex_state = 11, .external_lex_state = 6},
  [2012] = {.lex_state = 11, .external_lex_state = 6},
  [2013] = {.lex_state = 11, .external_lex_state = 6},
  [2014] = {.lex_state = 11, .external_lex_state = 6},
  [2015] = {.lex_state = 11, .external_lex_state = 6},
  [2016] = {.lex_state = 11, .external_lex_state = 6},
  [2017] = {.lex_state = 11, .external_lex_state = 6},
  [2018] = {.lex_state = 11, .external_lex_state = 6},
  [2019] = {.lex_state = 11, .external_lex_state = 6},
  [2020] = {.lex_state = 11, .external_lex_state = 6},
  [2021] = {.lex_state = 11, .external_lex_state = 6},
  [2022] = {.lex_state = 11, .external_lex_state = 6},
  [2023] = {.lex_state = 11, .external_lex_state = 6},
  [2024] = {.lex_state = 11, .external_lex_state = 6},
  [2025] = {.lex_state = 11, .external_lex_state = 6},
  [2026] = {.lex_state = 11, .external_lex_state = 6},
  [2027] = {.lex_state = 11, .external_lex_state = 6},
  [2028] = {.lex_state = 11, .external_lex_state = 6},
  [2029] = {.lex_state = 11, .external_lex_state = 6},
  [2030] = {.lex_state = 11, .external_lex_state = 6},
  [2031] = {.lex_state = 11, .external_lex_state = 6},
  [2032] = {.lex_state = 11, .external_lex_state = 6},
  [2033] = {.lex_state = 11, .external_lex_state = 6},
  [2034] = {.lex_state = 11, .external_lex_state = 6},
  [2035] = {.lex_state = 11, .external_lex_state = 6},
  [2036] = {.lex_state = 11, .external_lex_state = 6},
  [2037] = {.lex_state = 11, .external_lex_state = 6},
  [2038] = {.lex_state = 11, .external_lex_state = 6},
  [2039] = {.lex_state = 11, .external_lex_state = 8},
  [2040] = {.lex_state = 11, .external_lex_state = 6},
  [2041] = {.lex_state = 11, .external_lex_state = 6},
  [2042] = {.lex_state = 11, .external_lex_state = 6},
  [2043] = {.lex_state = 11, .external_lex_state = 6},
  [2044] = {.lex_state = 11, .external_lex_state = 6},
  [2045] = {.lex_state = 11, .external_lex_state = 6},
  [2046] = {.lex_state = 11, .external_lex_state = 6},
  [2047] = {.lex_state = 11, .external_lex_state = 6},
  [2048] = {.lex_state = 11, .external_lex_state = 6},
  [2049] = {.lex_state = 11, .external_lex_state = 6},
  [2050] = {.lex_state = 11, .external_lex_state = 6},
  [2051] = {.lex_state = 11, .external_lex_state = 6},
  [2052] = {.lex_state = 11, .external_lex_state = 6},
  [2053] = {.lex_state = 11, .external_lex_state = 6},
  [2054] = {.lex_state = 11, .external_lex_state = 6},
  [2055] = {.lex_state = 11, .external_lex_state = 6},
  [2056] = {.lex_state = 11, .external_lex_state = 6},
  [2057] = {.lex_state = 11, .external_lex_state = 6},
  [2058] = {.lex_state = 11, .external_lex_state = 6},
  [2059] = {.lex_state = 11, .external_lex_state = 6},
  [2060] = {.lex_state = 11, .external_lex_state = 6},
  [2061] = {.lex_state = 11, .external_lex_state = 6},
  [2062] = {.lex_state = 11, .external_lex_state = 6},
  [2063] = {.lex_state = 11, .external_lex_state = 6},
  [2064] = {.lex_state = 11, .external_lex_state = 6},
  [2065] = {.lex_state = 11, .external_lex_state = 6},
  [2066] = {.lex_state = 11, .external_lex_state = 6},
  [2067] = {.lex_state = 11, .external_lex_state = 6},
  [2068] = {.lex_state = 11, .external_lex_state = 6},
  [2069] = {.lex_state = 11, .external_lex_state = 6},
  [2070] = {.lex_state = 11, .external_lex_state = 6},
  [2071] = {.lex_state = 11, .external_lex_state = 6},
  [2072] = {.lex_state = 11, .external_lex_state = 6},
  [2073] = {.lex_state = 11, .external_lex_state = 6},
  [2074] = {.lex_state = 11, .external_lex_state = 6},
  [2075] = {.lex_state = 11, .external_lex_state = 6},
  [2076] = {.lex_state = 11, .external_lex_state = 6},
  [2077] = {.lex_state = 11, .external_lex_state = 6},
  [2078] = {.lex_state = 11, .external_lex_state = 6},
  [2079] = {.lex_state = 11, .external_lex_state = 6},
  [2080] = {.lex_state = 11, .external_lex_state = 6},
  [2081] = {.lex_state = 11, .external_lex_state = 6},
  [2082] = {.lex_state = 11, .external_lex_state = 6},
  [2083] = {.lex_state = 11, .external_lex_state = 6},
  [2084] = {.lex_state = 11, .external_lex_state = 6},
  [2085] = {.lex_state = 11, .external_lex_state = 6},
  [2086] = {.lex_state = 11, .external_lex_state = 6},
  [2087] = {.lex_state = 11, .external_lex_state = 6},
  [2088] = {.lex_state = 11, .external_lex_state = 6},
  [2089] = {.lex_state = 11, .external_lex_state = 6},
  [2090] = {.lex_state = 11, .external_lex_state = 6},
  [2091] = {.lex_state = 11, .external_lex_state = 6},
  [2092] = {.lex_state = 11, .external_lex_state = 6},
  [2093] = {.lex_state = 11, .external_lex_state = 6},
  [2094] = {.lex_state = 11, .external_lex_state = 6},
  [2095] = {.lex_state = 11, .external_lex_state = 6},
  [2096] = {.lex_state = 11, .external_lex_state = 6},
  [2097] = {.lex_state = 11, .external_lex_state = 6},
  [2098] = {.lex_state = 11, .external_lex_state = 6},
  [2099] = {.lex_state = 11, .external_lex_state = 6},
  [2100] = {.lex_state = 11, .external_lex_state = 6},
  [2101] = {.lex_state = 11, .external_lex_state = 6},
  [2102] = {.lex_state = 11, .external_lex_state = 6},
  [2103] = {.lex_state = 11, .external_lex_state = 6},
  [2104] = {.lex_state = 11, .external_lex_state = 6},
  [2105] = {.lex_state = 11, .external_lex_state = 6},
  [2106] = {.lex_state = 11, .external_lex_state = 6},
  [2107] = {.lex_state = 11, .external_lex_state = 6},
  [2108] = {.lex_state = 11, .external_lex_state = 6},
  [2109] = {.lex_state = 11, .external_lex_state = 6},
  [2110] = {.lex_state = 11, .external_lex_state = 6},
  [2111] = {.lex_state = 11, .external_lex_state = 6},
  [2112] = {.lex_state = 11, .external_lex_state = 6},
  [2113] = {.lex_state = 11, .external_lex_state = 6},
  [2114] = {.lex_state = 11, .external_lex_state = 6},
  [2115] = {.lex_state = 11, .external_lex_state = 6},
  [2116] = {.lex_state = 11, .external_lex_state = 6},
  [2117] = {.lex_state = 11, .external_lex_state = 6},
  [2118] = {.lex_state = 4, .external_lex_state = 3},
  [2119] = {.lex_state = 4, .external_lex_state = 4},
  [2120] = {.lex_state = 4, .external_lex_state = 4},
  [2121] = {.lex_state = 4, .external_lex_state = 4},
  [2122] = {.lex_state = 4, .external_lex_state = 4},
  [2123] = {.lex_state = 4, .external_lex_state = 4},
  [2124] = {.lex_state = 4, .external_lex_state = 4},
  [2125] = {.lex_state = 4, .external_lex_state = 4},
  [2126] = {.lex_state = 4, .external_lex_state = 4},
  [2127] = {.lex_state = 4, .external_lex_state = 4},
  [2128] = {.lex_state = 4, .external_lex_state = 5},
  [2129] = {.lex_state = 4, .external_lex_state = 4},
  [2130] = {.lex_state = 6, .external_lex_state = 4},
  [2131] = {.lex_state = 4, .external_lex_state = 5},
  [2132] = {.lex_state = 4, .external_lex_state = 5},
  [2133] = {.lex_state = 4, .external_lex_state = 5},
  [2134] = {.lex_state = 4, .external_lex_state = 5},
  [2135] = {.lex_state = 4, .external_lex_state = 4},
  [2136] = {.lex_state = 4, .external_lex_state = 4},
  [2137] = {.lex_state = 4, .external_lex_state = 4},
  [2138] = {.lex_state = 4, .external_lex_state = 4},
  [2139] = {.lex_state = 4, .external_lex_state = 4},
  [2140] = {.lex_state = 4, .external_lex_state = 4},
  [2141] = {.lex_state = 4, .external_lex_state = 4},
  [2142] = {.lex_state = 4, .external_lex_state = 4},
  [2143] = {.lex_state = 4, .external_lex_state = 4},
  [2144] = {.lex_state = 4, .external_lex_state = 4},
  [2145] = {.lex_state = 4, .external_lex_state = 4},
  [2146] = {.lex_state = 4, .external_lex_state = 4},
  [2147] = {.lex_state = 4, .external_lex_state = 4},
  [2148] = {.lex_state = 4, .external_lex_state = 4},
  [2149] = {.lex_state = 4, .external_lex_state = 4},
  [2150] = {.lex_state = 4, .external_lex_state = 4},
  [2151] = {.lex_state = 4, .external_lex_state = 4},
  [2152] = {.lex_state = 4, .external_lex_state = 4},
  [2153] = {.lex_state = 4, .external_lex_state = 4},
  [2154] = {.lex_state = 4, .external_lex_state = 4},
  [2155] = {.lex_state = 4, .external_lex_state = 4},
  [2156] = {.lex_state = 4, .external_lex_state = 4},
  [2157] = {.lex_state = 4, .external_lex_state = 4},
  [2158] = {.lex_state = 4, .external_lex_state = 4},
  [2159] = {.lex_state = 4, .external_lex_state = 4},
  [2160] = {.lex_state = 4, .external_lex_state = 4},
  [2161] = {.lex_state = 4, .external_lex_state = 4},
  [2162] = {.lex_state = 4, .external_lex_state = 4},
  [2163] = {.lex_state = 4, .external_lex_state = 4},
  [2164] = {.lex_state = 4, .external_lex_state = 4},
  [2165] = {.lex_state = 4, .external_lex_state = 4},
  [2166] = {.lex_state = 4, .external_lex_state = 4},
  [2167] = {.lex_state = 4, .external_lex_state = 4},
  [2168] = {.lex_state = 4, .external_lex_state = 4},
  [2169] = {.lex_state = 4, .external_lex_state = 4},
  [2170] = {.lex_state = 4, .external_lex_state = 4},
  [2171] = {.lex_state = 4, .external_lex_state = 4},
  [2172] = {.lex_state = 4, .external_lex_state = 4},
  [2173] = {.lex_state = 4, .external_lex_state = 4},
  [2174] = {.lex_state = 4, .external_lex_state = 4},
  [2175] = {.lex_state = 4, .external_lex_state = 4},
  [2176] = {.lex_state = 4, .external_lex_state = 4},
  [2177] = {.lex_state = 4, .external_lex_state = 4},
  [2178] = {.lex_state = 4, .external_lex_state = 4},
  [2179] = {.lex_state = 4, .external_lex_state = 4},
  [2180] = {.lex_state = 4, .external_lex_state = 4},
  [2181] = {.lex_state = 4, .external_lex_state = 4},
  [2182] = {.lex_state = 4, .external_lex_state = 4},
  [2183] = {.lex_state = 4, .external_lex_state = 4},
  [2184] = {.lex_state = 4, .external_lex_state = 4},
  [2185] = {.lex_state = 4, .external_lex_state = 4},
  [2186] = {.lex_state = 4, .external_lex_state = 4},
  [2187] = {.lex_state = 4, .external_lex_state = 4},
  [2188] = {.lex_state = 4, .external_lex_state = 4},
  [2189] = {.lex_state = 4, .external_lex_state = 4},
  [2190] = {.lex_state = 4, .external_lex_state = 4},
  [2191] = {.lex_state = 4, .external_lex_state = 4},
  [2192] = {.lex_state = 4, .external_lex_state = 4},
  [2193] = {.lex_state = 4, .external_lex_state = 4},
  [2194] = {.lex_state = 4, .external_lex_state = 4},
  [2195] = {.lex_state = 4, .external_lex_state = 4},
  [2196] = {.lex_state = 4, .external_lex_state = 4},
  [2197] = {.lex_state = 4, .external_lex_state = 4},
  [2198] = {.lex_state = 4, .external_lex_state = 4},
  [2199] = {.lex_state = 4, .external_lex_state = 4},
  [2200] = {.lex_state = 4, .external_lex_state = 4},
  [2201] = {.lex_state = 4, .external_lex_state = 4},
  [2202] = {.lex_state = 4, .external_lex_state = 4},
  [2203] = {.lex_state = 4, .external_lex_state = 4},
  [2204] = {.lex_state = 4, .external_lex_state = 4},
  [2205] = {.lex_state = 4, .external_lex_state = 4},
  [2206] = {.lex_state = 4, .external_lex_state = 4},
  [2207] = {.lex_state = 4, .external_lex_state = 4},
  [2208] = {.lex_state = 4, .external_lex_state = 4},
  [2209] = {.lex_state = 4, .external_lex_state = 4},
  [2210] = {.lex_state = 4, .external_lex_state = 4},
  [2211] = {.lex_state = 20, .external_lex_state = 7},
  [2212] = {.lex_state = 230, .external_lex_state = 7},
  [2213] = {.lex_state = 8, .external_lex_state = 7},
  [2214] = {.lex_state = 229, .external_lex_state = 7},
  [2215] = {.lex_state = 20, .external_lex_state = 6},
  [2216] = {.lex_state = 229, .external_lex_state = 6},
  [2217] = {.lex_state = 230, .external_lex_state = 6},
  [2218] = {.lex_state = 8, .external_lex_state = 6},
  [2219] = {.lex_state = 229, .external_lex_state = 7},
  [2220] = {.lex_state = 8, .external_lex_state = 7},
  [2221] = {.lex_state = 229, .external_lex_state = 7},
  [2222] = {.lex_state = 229, .external_lex_state = 7},
  [2223] = {.lex_state = 8, .external_lex_state = 7},
  [2224] = {.lex_state = 229, .external_lex_state = 7},
  [2225] = {.lex_state = 8, .external_lex_state = 7},
  [2226] = {.lex_state = 8, .external_lex_state = 7},
  [2227] = {.lex_state = 8, .external_lex_state = 7},
  [2228] = {.lex_state = 8, .external_lex_state = 7},
  [2229] = {.lex_state = 229, .external_lex_state = 7},
  [2230] = {.lex_state = 229, .external_lex_state = 7},
  [2231] = {.lex_state = 229, .external_lex_state = 7},
  [2232] = {.lex_state = 229, .external_lex_state = 7},
  [2233] = {.lex_state = 8, .external_lex_state = 7},
  [2234] = {.lex_state = 229, .external_lex_state = 7},
  [2235] = {.lex_state = 8, .external_lex_state = 7},
  [2236] = {.lex_state = 8, .external_lex_state = 7},
  [2237] = {.lex_state = 229, .external_lex_state = 7},
  [2238] = {.lex_state = 8, .external_lex_state = 7},
  [2239] = {.lex_state = 229, .external_lex_state = 7},
  [2240] = {.lex_state = 229, .external_lex_state = 7},
  [2241] = {.lex_state = 8, .external_lex_state = 7},
  [2242] = {.lex_state = 8, .external_lex_state = 7},
  [2243] = {.lex_state = 229, .external_lex_state = 7},
  [2244] = {.lex_state = 8, .external_lex_state = 7},
  [2245] = {.lex_state = 229, .external_lex_state = 7},
  [2246] = {.lex_state = 229, .external_lex_state = 7},
  [2247] = {.lex_state = 229, .external_lex_state = 7},
  [2248] = {.lex_state = 229, .external_lex_state = 7},
  [2249] = {.lex_state = 229, .external_lex_state = 7},
  [2250] = {.lex_state = 229, .external_lex_state = 6},
  [2251] = {.lex_state = 229, .external_lex_state = 7},
  [2252] = {.lex_state = 229, .external_lex_state = 7},
  [2253] = {.lex_state = 229, .external_lex_state = 7},
  [2254] = {.lex_state = 229, .external_lex_state = 7},
  [2255] = {.lex_state = 229, .external_lex_state = 7},
  [2256] = {.lex_state = 229, .external_lex_state = 7},
  [2257] = {.lex_state = 229, .external_lex_state = 7},
  [2258] = {.lex_state = 229, .external_lex_state = 7},
  [2259] = {.lex_state = 229, .external_lex_state = 7},
  [2260] = {.lex_state = 229, .external_lex_state = 6},
  [2261] = {.lex_state = 229, .external_lex_state = 6},
  [2262] = {.lex_state = 229, .external_lex_state = 7},
  [2263] = {.lex_state = 8, .external_lex_state = 6},
  [2264] = {.lex_state = 229, .external_lex_state = 7},
  [2265] = {.lex_state = 229, .external_lex_state = 7},
  [2266] = {.lex_state = 229, .external_lex_state = 7},
  [2267] = {.lex_state = 229, .external_lex_state = 7},
  [2268] = {.lex_state = 8, .external_lex_state = 6},
  [2269] = {.lex_state = 229, .external_lex_state = 7},
  [2270] = {.lex_state = 229, .external_lex_state = 7},
  [2271] = {.lex_state = 229, .external_lex_state = 7},
  [2272] = {.lex_state = 229, .external_lex_state = 7},
  [2273] = {.lex_state = 229, .external_lex_state = 7},
  [2274] = {.lex_state = 8, .external_lex_state = 6},
  [2275] = {.lex_state = 229, .external_lex_state = 7},
  [2276] = {.lex_state = 229, .external_lex_state = 7},
  [2277] = {.lex_state = 229, .external_lex_state = 7},
  [2278] = {.lex_state = 229, .external_lex_state = 7},
  [2279] = {.lex_state = 229, .external_lex_state = 7},
  [2280] = {.lex_state = 229, .external_lex_state = 7},
  [2281] = {.lex_state = 229, .external_lex_state = 7},
  [2282] = {.lex_state = 229, .external_lex_state = 7},
  [2283] = {.lex_state = 229, .external_lex_state = 7},
  [2284] = {.lex_state = 229, .external_lex_state = 7},
  [2285] = {.lex_state = 8, .external_lex_state = 7},
  [2286] = {.lex_state = 8, .external_lex_state = 7},
  [2287] = {.lex_state = 8, .external_lex_state = 7},
  [2288] = {.lex_state = 8, .external_lex_state = 7},
  [2289] = {.lex_state = 8, .external_lex_state = 7},
  [2290] = {.lex_state = 229, .external_lex_state = 7},
  [2291] = {.lex_state = 8, .external_lex_state = 7},
  [2292] = {.lex_state = 8, .external_lex_state = 7},
  [2293] = {.lex_state = 8, .external_lex_state = 7},
  [2294] = {.lex_state = 8, .external_lex_state = 7},
  [2295] = {.lex_state = 8, .external_lex_state = 7},
  [2296] = {.lex_state = 8, .external_lex_state = 6},
  [2297] = {.lex_state = 8, .external_lex_state = 7},
  [2298] = {.lex_state = 229, .external_lex_state = 7},
  [2299] = {.lex_state = 229, .external_lex_state = 7},
  [2300] = {.lex_state = 229, .external_lex_state = 7},
  [2301] = {.lex_state = 229, .external_lex_state = 7},
  [2302] = {.lex_state = 229, .external_lex_state = 7},
  [2303] = {.lex_state = 8, .external_lex_state = 7},
  [2304] = {.lex_state = 8, .external_lex_state = 7},
  [2305] = {.lex_state = 8, .external_lex_state = 7},
  [2306] = {.lex_state = 229, .external_lex_state = 7},
  [2307] = {.lex_state = 8, .external_lex_state = 7},
  [2308] = {.lex_state = 229, .external_lex_state = 7},
  [2309] = {.lex_state = 229, .external_lex_state = 7},
  [2310] = {.lex_state = 229, .external_lex_state = 7},
  [2311] = {.lex_state = 8, .external_lex_state = 7},
  [2312] = {.lex_state = 229, .external_lex_state = 7},
  [2313] = {.lex_state = 229, .external_lex_state = 7},
  [2314] = {.lex_state = 229, .external_lex_state = 7},
  [2315] = {.lex_state = 8, .external_lex_state = 7},
  [2316] = {.lex_state = 8, .external_lex_state = 7},
  [2317] = {.lex_state = 229, .external_lex_state = 7},
  [2318] = {.lex_state = 8, .external_lex_state = 7},
  [2319] = {.lex_state = 8, .external_lex_state = 7},
  [2320] = {.lex_state = 8, .external_lex_state = 7},
  [2321] = {.lex_state = 8, .external_lex_state = 7},
  [2322] = {.lex_state = 8, .external_lex_state = 7},
  [2323] = {.lex_state = 8, .external_lex_state = 7},
  [2324] = {.lex_state = 8, .external_lex_state = 7},
  [2325] = {.lex_state = 8, .external_lex_state = 7},
  [2326] = {.lex_state = 8, .external_lex_state = 7},
  [2327] = {.lex_state = 8, .external_lex_state = 7},
  [2328] = {.lex_state = 229, .external_lex_state = 7},
  [2329] = {.lex_state = 8, .external_lex_state = 7},
  [2330] = {.lex_state = 8, .external_lex_state = 7},
  [2331] = {.lex_state = 8, .external_lex_state = 7},
  [2332] = {.lex_state = 8, .external_lex_state = 7},
  [2333] = {.lex_state = 8, .external_lex_state = 7},
  [2334] = {.lex_state = 8, .external_lex_state = 7},
  [2335] = {.lex_state = 8, .external_lex_state = 7},
  [2336] = {.lex_state = 229, .external_lex_state = 7},
  [2337] = {.lex_state = 229, .external_lex_state = 7},
  [2338] = {.lex_state = 229, .external_lex_state = 7},
  [2339] = {.lex_state = 229, .external_lex_state = 7},
  [2340] = {.lex_state = 8, .external_lex_state = 7},
  [2341] = {.lex_state = 8, .external_lex_state = 7},
  [2342] = {.lex_state = 8, .external_lex_state = 7},
  [2343] = {.lex_state = 8, .external_lex_state = 7},
  [2344] = {.lex_state = 8, .external_lex_state = 7},
  [2345] = {.lex_state = 229, .external_lex_state = 7},
  [2346] = {.lex_state = 229, .external_lex_state = 7},
  [2347] = {.lex_state = 229, .external_lex_state = 7},
  [2348] = {.lex_state = 8, .external_lex_state = 7},
  [2349] = {.lex_state = 8, .external_lex_state = 7},
  [2350] = {.lex_state = 8, .external_lex_state = 7},
  [2351] = {.lex_state = 8, .external_lex_state = 7},
  [2352] = {.lex_state = 8, .external_lex_state = 7},
  [2353] = {.lex_state = 8, .external_lex_state = 7},
  [2354] = {.lex_state = 8, .external_lex_state = 7},
  [2355] = {.lex_state = 8, .external_lex_state = 7},
  [2356] = {.lex_state = 8, .external_lex_state = 7},
  [2357] = {.lex_state = 8, .external_lex_state = 7},
  [2358] = {.lex_state = 8, .external_lex_state = 7},
  [2359] = {.lex_state = 8, .external_lex_state = 7},
  [2360] = {.lex_state = 8, .external_lex_state = 7},
  [2361] = {.lex_state = 8, .external_lex_state = 7},
  [2362] = {.lex_state = 8, .external_lex_state = 7},
  [2363] = {.lex_state = 8, .external_lex_state = 7},
  [2364] = {.lex_state = 229, .external_lex_state = 6},
  [2365] = {.lex_state = 8, .external_lex_state = 7},
  [2366] = {.lex_state = 8, .external_lex_state = 7},
  [2367] = {.lex_state = 229, .external_lex_state = 7},
  [2368] = {.lex_state = 229, .external_lex_state = 7},
  [2369] = {.lex_state = 8, .external_lex_state = 6},
  [2370] = {.lex_state = 8, .external_lex_state = 6},
  [2371] = {.lex_state = 8, .external_lex_state = 6},
  [2372] = {.lex_state = 229, .external_lex_state = 6},
  [2373] = {.lex_state = 229, .external_lex_state = 6},
  [2374] = {.lex_state = 8, .external_lex_state = 6},
  [2375] = {.lex_state = 229, .external_lex_state = 6},
  [2376] = {.lex_state = 229, .external_lex_state = 6},
  [2377] = {.lex_state = 8, .external_lex_state = 6},
  [2378] = {.lex_state = 8, .external_lex_state = 6},
  [2379] = {.lex_state = 229, .external_lex_state = 6},
  [2380] = {.lex_state = 229, .external_lex_state = 6},
  [2381] = {.lex_state = 8, .external_lex_state = 6},
  [2382] = {.lex_state = 229, .external_lex_state = 6},
  [2383] = {.lex_state = 229, .external_lex_state = 6},
  [2384] = {.lex_state = 229, .external_lex_state = 6},
  [2385] = {.lex_state = 8, .external_lex_state = 6},
  [2386] = {.lex_state = 8, .external_lex_state = 6},
  [2387] = {.lex_state = 8, .external_lex_state = 6},
  [2388] = {.lex_state = 229, .external_lex_state = 6},
  [2389] = {.lex_state = 229, .external_lex_state = 6},
  [2390] = {.lex_state = 229, .external_lex_state = 6},
  [2391] = {.lex_state = 8, .external_lex_state = 6},
  [2392] = {.lex_state = 8, .external_lex_state = 6},
  [2393] = {.lex_state = 8, .external_lex_state = 6},
  [2394] = {.lex_state = 8, .external_lex_state = 6},
  [2395] = {.lex_state = 8, .external_lex_state = 6},
  [2396] = {.lex_state = 8, .external_lex_state = 6},
  [2397] = {.lex_state = 229, .external_lex_state = 6},
  [2398] = {.lex_state = 8, .external_lex_state = 6},
  [2399] = {.lex_state = 8, .external_lex_state = 6},
  [2400] = {.lex_state = 229, .external_lex_state = 6},
  [2401] = {.lex_state = 8, .external_lex_state = 6},
  [2402] = {.lex_state = 8, .external_lex_state = 6},
  [2403] = {.lex_state = 8, .external_lex_state = 6},
  [2404] = {.lex_state = 8, .external_lex_state = 6},
  [2405] = {.lex_state = 8, .external_lex_state = 6},
  [2406] = {.lex_state = 229, .external_lex_state = 6},
  [2407] = {.lex_state = 229, .external_lex_state = 6},
  [2408] = {.lex_state = 229, .external_lex_state = 6},
  [2409] = {.lex_state = 229, .external_lex_state = 6},
  [2410] = {.lex_state = 229, .external_lex_state = 6},
  [2411] = {.lex_state = 8, .external_lex_state = 6},
  [2412] = {.lex_state = 8, .external_lex_state = 6},
  [2413] = {.lex_state = 8, .external_lex_state = 6},
  [2414] = {.lex_state = 8, .external_lex_state = 6},
  [2415] = {.lex_state = 8, .external_lex_state = 6},
  [2416] = {.lex_state = 229, .external_lex_state = 6},
  [2417] = {.lex_state = 8, .external_lex_state = 6},
  [2418] = {.lex_state = 229, .external_lex_state = 6},
  [2419] = {.lex_state = 8, .external_lex_state = 6},
  [2420] = {.lex_state = 229, .external_lex_state = 6},
  [2421] = {.lex_state = 229, .external_lex_state = 6},
  [2422] = {.lex_state = 229, .external_lex_state = 6},
  [2423] = {.lex_state = 8, .external_lex_state = 6},
  [2424] = {.lex_state = 8, .external_lex_state = 6},
  [2425] = {.lex_state = 8, .external_lex_state = 6},
  [2426] = {.lex_state = 229, .external_lex_state = 6},
  [2427] = {.lex_state = 229, .external_lex_state = 6},
  [2428] = {.lex_state = 8, .external_lex_state = 6},
  [2429] = {.lex_state = 8, .external_lex_state = 6},
  [2430] = {.lex_state = 8, .external_lex_state = 6},
  [2431] = {.lex_state = 8, .external_lex_state = 6},
  [2432] = {.lex_state = 229, .external_lex_state = 6},
  [2433] = {.lex_state = 8, .external_lex_state = 6},
  [2434] = {.lex_state = 8, .external_lex_state = 6},
  [2435] = {.lex_state = 8, .external_lex_state = 6},
  [2436] = {.lex_state = 8, .external_lex_state = 6},
  [2437] = {.lex_state = 8, .external_lex_state = 6},
  [2438] = {.lex_state = 8, .external_lex_state = 6},
  [2439] = {.lex_state = 8, .external_lex_state = 6},
  [2440] = {.lex_state = 8, .external_lex_state = 6},
  [2441] = {.lex_state = 229, .external_lex_state = 6},
  [2442] = {.lex_state = 8, .external_lex_state = 6},
  [2443] = {.lex_state = 8, .external_lex_state = 6},
  [2444] = {.lex_state = 8, .external_lex_state = 6},
  [2445] = {.lex_state = 8, .external_lex_state = 6},
  [2446] = {.lex_state = 8, .external_lex_state = 6},
  [2447] = {.lex_state = 8, .external_lex_state = 6},
  [2448] = {.lex_state = 8, .external_lex_state = 6},
  [2449] = {.lex_state = 8, .external_lex_state = 6},
  [2450] = {.lex_state = 229, .external_lex_state = 6},
  [2451] = {.lex_state = 229, .external_lex_state = 6},
  [2452] = {.lex_state = 229, .external_lex_state = 6},
  [2453] = {.lex_state = 8, .external_lex_state = 6},
  [2454] = {.lex_state = 8, .external_lex_state = 6},
  [2455] = {.lex_state = 229, .external_lex_state = 6},
  [2456] = {.lex_state = 229, .external_lex_state = 6},
  [2457] = {.lex_state = 8, .external_lex_state = 6},
  [2458] = {.lex_state = 229, .external_lex_state = 6},
  [2459] = {.lex_state = 229, .external_lex_state = 6},
  [2460] = {.lex_state = 229, .external_lex_state = 6},
  [2461] = {.lex_state = 229, .external_lex_state = 6},
  [2462] = {.lex_state = 229, .external_lex_state = 6},
  [2463] = {.lex_state = 229, .external_lex_state = 6},
  [2464] = {.lex_state = 229, .external_lex_state = 6},
  [2465] = {.lex_state = 229, .external_lex_state = 6},
  [2466] = {.lex_state = 8, .external_lex_state = 6},
  [2467] = {.lex_state = 8, .external_lex_state = 6},
  [2468] = {.lex_state = 229, .external_lex_state = 6},
  [2469] = {.lex_state = 229, .external_lex_state = 6},
  [2470] = {.lex_state = 229, .external_lex_state = 6},
  [2471] = {.lex_state = 229, .external_lex_state = 6},
  [2472] = {.lex_state = 229, .external_lex_state = 6},
  [2473] = {.lex_state = 229, .external_lex_state = 6},
  [2474] = {.lex_state = 229, .external_lex_state = 6},
  [2475] = {.lex_state = 8, .external_lex_state = 6},
  [2476] = {.lex_state = 229, .external_lex_state = 6},
  [2477] = {.lex_state = 229, .external_lex_state = 6},
  [2478] = {.lex_state = 229, .external_lex_state = 6},
  [2479] = {.lex_state = 229, .external_lex_state = 6},
  [2480] = {.lex_state = 229, .external_lex_state = 6},
  [2481] = {.lex_state = 229, .external_lex_state = 6},
  [2482] = {.lex_state = 8, .external_lex_state = 6},
  [2483] = {.lex_state = 229, .external_lex_state = 6},
  [2484] = {.lex_state = 8, .external_lex_state = 6},
  [2485] = {.lex_state = 8, .external_lex_state = 6},
  [2486] = {.lex_state = 229, .external_lex_state = 6},
  [2487] = {.lex_state = 8, .external_lex_state = 6},
  [2488] = {.lex_state = 8, .external_lex_state = 6},
  [2489] = {.lex_state = 8, .external_lex_state = 6},
  [2490] = {.lex_state = 8, .external_lex_state = 6},
  [2491] = {.lex_state = 229, .external_lex_state = 6},
  [2492] = {.lex_state = 229, .external_lex_state = 6},
  [2493] = {.lex_state = 229, .external_lex_state = 6},
  [2494] = {.lex_state = 229, .external_lex_state = 6},
  [2495] = {.lex_state = 229, .external_lex_state = 6},
  [2496] = {.lex_state = 229, .external_lex_state = 6},
  [2497] = {.lex_state = 229, .external_lex_state = 6},
  [2498] = {.lex_state = 229, .external_lex_state = 6},
  [2499] = {.lex_state = 229, .external_lex_state = 6},
  [2500] = {.lex_state = 229, .external_lex_state = 6},
  [2501] = {.lex_state = 229, .external_lex_state = 6},
  [2502] = {.lex_state = 8, .external_lex_state = 6},
  [2503] = {.lex_state = 10, .external_lex_state = 6},
  [2504] = {.lex_state = 21, .external_lex_state = 6},
  [2505] = {.lex_state = 7, .external_lex_state = 6},
  [2506] = {.lex_state = 10, .external_lex_state = 6},
  [2507] = {.lex_state = 10, .external_lex_state = 8},
  [2508] = {.lex_state = 11, .external_lex_state = 6},
  [2509] = {.lex_state = 11, .external_lex_state = 6},
  [2510] = {.lex_state = 10, .external_lex_state = 6},
  [2511] = {.lex_state = 11, .external_lex_state = 6},
  [2512] = {.lex_state = 10, .external_lex_state = 6},
  [2513] = {.lex_state = 10, .external_lex_state = 6},
  [2514] = {.lex_state = 10, .external_lex_state = 6},
  [2515] = {.lex_state = 11, .external_lex_state = 6},
  [2516] = {.lex_state = 10, .external_lex_state = 6},
  [2517] = {.lex_state = 10, .external_lex_state = 6},
  [2518] = {.lex_state = 11, .external_lex_state = 6},
  [2519] = {.lex_state = 11, .external_lex_state = 6},
  [2520] = {.lex_state = 11, .external_lex_state = 6},
  [2521] = {.lex_state = 11, .external_lex_state = 6},
  [2522] = {.lex_state = 11, .external_lex_state = 6},
  [2523] = {.lex_state = 10, .external_lex_state = 6},
  [2524] = {.lex_state = 10, .external_lex_state = 6},
  [2525] = {.lex_state = 10, .external_lex_state = 6},
  [2526] = {.lex_state = 10, .external_lex_state = 6},
  [2527] = {.lex_state = 11, .external_lex_state = 6},
  [2528] = {.lex_state = 10, .external_lex_state = 6},
  [2529] = {.lex_state = 10, .external_lex_state = 6},
  [2530] = {.lex_state = 10, .external_lex_state = 6},
  [2531] = {.lex_state = 11, .external_lex_state = 6},
  [2532] = {.lex_state = 10, .external_lex_state = 6},
  [2533] = {.lex_state = 10, .external_lex_state = 6},
  [2534] = {.lex_state = 11, .external_lex_state = 6},
  [2535] = {.lex_state = 10, .external_lex_state = 6},
  [2536] = {.lex_state = 10, .external_lex_state = 6},
  [2537] = {.lex_state = 11, .external_lex_state = 6},
  [2538] = {.lex_state = 10, .external_lex_state = 6},
  [2539] = {.lex_state = 10, .external_lex_state = 6},
  [2540] = {.lex_state = 10, .external_lex_state = 6},
  [2541] = {.lex_state = 10, .external_lex_state = 6},
  [2542] = {.lex_state = 11, .external_lex_state = 6},
  [2543] = {.lex_state = 10, .external_lex_state = 6},
  [2544] = {.lex_state = 10, .external_lex_state = 8},
  [2545] = {.lex_state = 10, .external_lex_state = 6},
  [2546] = {.lex_state = 11, .external_lex_state = 6},
  [2547] = {.lex_state = 11, .external_lex_state = 6},
  [2548] = {.lex_state = 10, .external_lex_state = 6},
  [2549] = {.lex_state = 11, .external_lex_state = 6},
  [2550] = {.lex_state = 11, .external_lex_state = 6},
  [2551] = {.lex_state = 11, .external_lex_state = 6},
  [2552] = {.lex_state = 10, .external_lex_state = 6},
  [2553] = {.lex_state = 10, .external_lex_state = 8},
  [2554] = {.lex_state = 10, .external_lex_state = 6},
  [2555] = {.lex_state = 10, .external_lex_state = 6},
  [2556] = {.lex_state = 10, .external_lex_state = 6},
  [2557] = {.lex_state = 10, .external_lex_state = 6},
  [2558] = {.lex_state = 11, .external_lex_state = 6},
  [2559] = {.lex_state = 11, .external_lex_state = 6},
  [2560] = {.lex_state = 10, .external_lex_state = 8},
  [2561] = {.lex_state = 11, .external_lex_state = 6},
  [2562] = {.lex_state = 11, .external_lex_state = 6},
  [2563] = {.lex_state = 10, .external_lex_state = 6},
  [2564] = {.lex_state = 10, .external_lex_state = 8},
  [2565] = {.lex_state = 10, .external_lex_state = 6},
  [2566] = {.lex_state = 10, .external_lex_state = 6},
  [2567] = {.lex_state = 10, .external_lex_state = 6},
  [2568] = {.lex_state = 10, .external_lex_state = 6},
  [2569] = {.lex_state = 10, .external_lex_state = 6},
  [2570] = {.lex_state = 10, .external_lex_state = 6},
  [2571] = {.lex_state = 11, .external_lex_state = 6},
  [2572] = {.lex_state = 11, .external_lex_state = 6},
  [2573] = {.lex_state = 11, .external_lex_state = 6},
  [2574] = {.lex_state = 11, .external_lex_state = 6},
  [2575] = {.lex_state = 10, .external_lex_state = 6},
  [2576] = {.lex_state = 11, .external_lex_state = 6},
  [2577] = {.lex_state = 11, .external_lex_state = 6},
  [2578] = {.lex_state = 11, .external_lex_state = 6},
  [2579] = {.lex_state = 11, .external_lex_state = 6},
  [2580] = {.lex_state = 11, .external_lex_state = 6},
  [2581] = {.lex_state = 11, .external_lex_state = 6},
  [2582] = {.lex_state = 10, .external_lex_state = 6},
  [2583] = {.lex_state = 10, .external_lex_state = 6},
  [2584] = {.lex_state = 10, .external_lex_state = 6},
  [2585] = {.lex_state = 10, .external_lex_state = 6},
  [2586] = {.lex_state = 10, .external_lex_state = 6},
  [2587] = {.lex_state = 10, .external_lex_state = 6},
  [2588] = {.lex_state = 10, .external_lex_state = 6},
  [2589] = {.lex_state = 10, .external_lex_state = 6},
  [2590] = {.lex_state = 10, .external_lex_state = 6},
  [2591] = {.lex_state = 10, .external_lex_state = 6},
  [2592] = {.lex_state = 10, .external_lex_state = 6},
  [2593] = {.lex_state = 10, .external_lex_state = 6},
  [2594] = {.lex_state = 10, .external_lex_state = 6},
  [2595] = {.lex_state = 10, .external_lex_state = 6},
  [2596] = {.lex_state = 11, .external_lex_state = 6},
  [2597] = {.lex_state = 11, .external_lex_state = 6},
  [2598] = {.lex_state = 11, .external_lex_state = 6},
  [2599] = {.lex_state = 11, .external_lex_state = 6},
  [2600] = {.lex_state = 11, .external_lex_state = 6},
  [2601] = {.lex_state = 11, .external_lex_state = 6},
  [2602] = {.lex_state = 11, .external_lex_state = 6},
  [2603] = {.lex_state = 11, .external_lex_state = 6},
  [2604] = {.lex_state = 10, .external_lex_state = 6},
  [2605] = {.lex_state = 11, .external_lex_state = 6},
  [2606] = {.lex_state = 11, .external_lex_state = 6},
  [2607] = {.lex_state = 11, .external_lex_state = 6},
  [2608] = {.lex_state = 10, .external_lex_state = 6},
  [2609] = {.lex_state = 10, .external_lex_state = 6},
  [2610] = {.lex_state = 11, .external_lex_state = 6},
  [2611] = {.lex_state = 11, .external_lex_state = 6},
  [2612] = {.lex_state = 10, .external_lex_state = 6},
  [2613] = {.lex_state = 10, .external_lex_state = 6},
  [2614] = {.lex_state = 10, .external_lex_state = 6},
  [2615] = {.lex_state = 11, .external_lex_state = 6},
  [2616] = {.lex_state = 11, .external_lex_state = 6},
  [2617] = {.lex_state = 10, .external_lex_state = 6},
  [2618] = {.lex_state = 11, .external_lex_state = 6},
  [2619] = {.lex_state = 10, .external_lex_state = 6},
  [2620] = {.lex_state = 10, .external_lex_state = 6},
  [2621] = {.lex_state = 10, .external_lex_state = 6},
  [2622] = {.lex_state = 10, .external_lex_state = 6},
  [2623] = {.lex_state = 11, .external_lex_state = 6},
  [2624] = {.lex_state = 11, .external_lex_state = 6},
  [2625] = {.lex_state = 11, .external_lex_state = 6},
  [2626] = {.lex_state = 10, .external_lex_state = 6},
  [2627] = {.lex_state = 11, .external_lex_state = 6},
  [2628] = {.lex_state = 10, .external_lex_state = 6},
  [2629] = {.lex_state = 10, .external_lex_state = 6},
  [2630] = {.lex_state = 11, .external_lex_state = 6},
  [2631] = {.lex_state = 11, .external_lex_state = 6},
  [2632] = {.lex_state = 11, .external_lex_state = 6},
  [2633] = {.lex_state = 11, .external_lex_state = 6},
  [2634] = {.lex_state = 11, .external_lex_state = 6},
  [2635] = {.lex_state = 10, .external_lex_state = 6},
  [2636] = {.lex_state = 11, .external_lex_state = 6},
  [2637] = {.lex_state = 10, .external_lex_state = 6},
  [2638] = {.lex_state = 10, .external_lex_state = 6},
  [2639] = {.lex_state = 10, .external_lex_state = 6},
  [2640] = {.lex_state = 10, .external_lex_state = 6},
  [2641] = {.lex_state = 11, .external_lex_state = 6},
  [2642] = {.lex_state = 11, .external_lex_state = 6},
  [2643] = {.lex_state = 11, .external_lex_state = 6},
  [2644] = {.lex_state = 10, .external_lex_state = 6},
  [2645] = {.lex_state = 10, .external_lex_state = 6},
  [2646] = {.lex_state = 10, .external_lex_state = 6},
  [2647] = {.lex_state = 10, .external_lex_state = 6},
  [2648] = {.lex_state = 11, .external_lex_state = 6},
  [2649] = {.lex_state = 10, .external_lex_state = 6},
  [2650] = {.lex_state = 11, .external_lex_state = 6},
  [2651] = {.lex_state = 10, .external_lex_state = 6},
  [2652] = {.lex_state = 10, .external_lex_state = 6},
  [2653] = {.lex_state = 10, .external_lex_state = 6},
  [2654] = {.lex_state = 10, .external_lex_state = 6},
  [2655] = {.lex_state = 10, .external_lex_state = 6},
  [2656] = {.lex_state = 10, .external_lex_state = 6},
  [2657] = {.lex_state = 10, .external_lex_state = 6},
  [2658] = {.lex_state = 10, .external_lex_state = 6},
  [2659] = {.lex_state = 11, .external_lex_state = 6},
  [2660] = {.lex_state = 11, .external_lex_state = 6},
  [2661] = {.lex_state = 11, .external_lex_state = 6},
  [2662] = {.lex_state = 11, .external_lex_state = 6},
  [2663] = {.lex_state = 11, .external_lex_state = 6},
  [2664] = {.lex_state = 11, .external_lex_state = 6},
  [2665] = {.lex_state = 10, .external_lex_state = 6},
  [2666] = {.lex_state = 11, .external_lex_state = 6},
  [2667] = {.lex_state = 10, .external_lex_state = 8},
  [2668] = {.lex_state = 10, .external_lex_state = 6},
  [2669] = {.lex_state = 10, .external_lex_state = 6},
  [2670] = {.lex_state = 10, .external_lex_state = 6},
  [2671] = {.lex_state = 10, .external_lex_state = 6},
  [2672] = {.lex_state = 10, .external_lex_state = 6},
  [2673] = {.lex_state = 10, .external_lex_state = 6},
  [2674] = {.lex_state = 10, .external_lex_state = 6},
  [2675] = {.lex_state = 10, .external_lex_state = 6},
  [2676] = {.lex_state = 10, .external_lex_state = 6},
  [2677] = {.lex_state = 10, .external_lex_state = 8},
  [2678] = {.lex_state = 10, .external_lex_state = 6},
  [2679] = {.lex_state = 10, .external_lex_state = 6},
  [2680] = {.lex_state = 10, .external_lex_state = 8},
  [2681] = {.lex_state = 10, .external_lex_state = 6},
  [2682] = {.lex_state = 10, .external_lex_state = 6},
  [2683] = {.lex_state = 10, .external_lex_state = 6},
  [2684] = {.lex_state = 10, .external_lex_state = 6},
  [2685] = {.lex_state = 10, .external_lex_state = 6},
  [2686] = {.lex_state = 10, .external_lex_state = 8},
  [2687] = {.lex_state = 10, .external_lex_state = 6},
  [2688] = {.lex_state = 10, .external_lex_state = 6},
  [2689] = {.lex_state = 10, .external_lex_state = 6},
  [2690] = {.lex_state = 10, .external_lex_state = 6},
  [2691] = {.lex_state = 10, .external_lex_state = 8},
  [2692] = {.lex_state = 10, .external_lex_state = 6},
  [2693] = {.lex_state = 10, .external_lex_state = 6},
  [2694] = {.lex_state = 10, .external_lex_state = 6},
  [2695] = {.lex_state = 10, .external_lex_state = 6},
  [2696] = {.lex_state = 10, .external_lex_state = 8},
  [2697] = {.lex_state = 10, .external_lex_state = 6},
  [2698] = {.lex_state = 10, .external_lex_state = 6},
  [2699] = {.lex_state = 10, .external_lex_state = 6},
  [2700] = {.lex_state = 10, .external_lex_state = 6},
  [2701] = {.lex_state = 10, .external_lex_state = 8},
  [2702] = {.lex_state = 10, .external_lex_state = 6},
  [2703] = {.lex_state = 10, .external_lex_state = 6},
  [2704] = {.lex_state = 10, .external_lex_state = 6},
  [2705] = {.lex_state = 10, .external_lex_state = 6},
  [2706] = {.lex_state = 10, .external_lex_state = 6},
  [2707] = {.lex_state = 10, .external_lex_state = 6},
  [2708] = {.lex_state = 10, .external_lex_state = 6},
  [2709] = {.lex_state = 10, .external_lex_state = 6},
  [2710] = {.lex_state = 10, .external_lex_state = 6},
  [2711] = {.lex_state = 10, .external_lex_state = 6},
  [2712] = {.lex_state = 10, .external_lex_state = 6},
  [2713] = {.lex_state = 10, .external_lex_state = 6},
  [2714] = {.lex_state = 10, .external_lex_state = 6},
  [2715] = {.lex_state = 10, .external_lex_state = 6},
  [2716] = {.lex_state = 10, .external_lex_state = 6},
  [2717] = {.lex_state = 10, .external_lex_state = 8},
  [2718] = {.lex_state = 10, .external_lex_state = 6},
  [2719] = {.lex_state = 10, .external_lex_state = 6},
  [2720] = {.lex_state = 10, .external_lex_state = 6},
  [2721] = {.lex_state = 10, .external_lex_state = 6},
  [2722] = {.lex_state = 10, .external_lex_state = 6},
  [2723] = {.lex_state = 10, .external_lex_state = 6},
  [2724] = {.lex_state = 10, .external_lex_state = 6},
  [2725] = {.lex_state = 10, .external_lex_state = 6},
  [2726] = {.lex_state = 10, .external_lex_state = 6},
  [2727] = {.lex_state = 10, .external_lex_state = 6},
  [2728] = {.lex_state = 10, .external_lex_state = 6},
  [2729] = {.lex_state = 10, .external_lex_state = 6},
  [2730] = {.lex_state = 10, .external_lex_state = 6},
  [2731] = {.lex_state = 10, .external_lex_state = 6},
  [2732] = {.lex_state = 10, .external_lex_state = 6},
  [2733] = {.lex_state = 10, .external_lex_state = 8},
  [2734] = {.lex_state = 10, .external_lex_state = 8},
  [2735] = {.lex_state = 10, .external_lex_state = 8},
  [2736] = {.lex_state = 10, .external_lex_state = 8},
  [2737] = {.lex_state = 10, .external_lex_state = 8},
  [2738] = {.lex_state = 10, .external_lex_state = 8},
  [2739] = {.lex_state = 10, .external_lex_state = 8},
  [2740] = {.lex_state = 10, .external_lex_state = 8},
  [2741] = {.lex_state = 10, .external_lex_state = 8},
  [2742] = {.lex_state = 10, .external_lex_state = 8},
  [2743] = {.lex_state = 10, .external_lex_state = 8},
  [2744] = {.lex_state = 10, .external_lex_state = 8},
  [2745] = {.lex_state = 10, .external_lex_state = 8},
  [2746] = {.lex_state = 10, .external_lex_state = 8},
  [2747] = {.lex_state = 10, .external_lex_state = 8},
  [2748] = {.lex_state = 10, .external_lex_state = 8},
  [2749] = {.lex_state = 10, .external_lex_state = 8},
  [2750] = {.lex_state = 10, .external_lex_state = 8},
  [2751] = {.lex_state = 10, .external_lex_state = 8},
  [2752] = {.lex_state = 10, .external_lex_state = 8},
  [2753] = {.lex_state = 10, .external_lex_state = 8},
  [2754] = {.lex_state = 10, .external_lex_state = 8},
  [2755] = {.lex_state = 10, .external_lex_state = 8},
  [2756] = {.lex_state = 10, .external_lex_state = 8},
  [2757] = {.lex_state = 10, .external_lex_state = 8},
  [2758] = {.lex_state = 10, .external_lex_state = 8},
  [2759] = {.lex_state = 10, .external_lex_state = 8},
  [2760] = {.lex_state = 10, .external_lex_state = 8},
  [2761] = {.lex_state = 10, .external_lex_state = 8},
  [2762] = {.lex_state = 10, .external_lex_state = 8},
  [2763] = {.lex_state = 10, .external_lex_state = 8},
  [2764] = {.lex_state = 10, .external_lex_state = 8},
  [2765] = {.lex_state = 10, .external_lex_state = 8},
  [2766] = {.lex_state = 10, .external_lex_state = 8},
  [2767] = {.lex_state = 10, .external_lex_state = 8},
  [2768] = {.lex_state = 10, .external_lex_state = 8},
  [2769] = {.lex_state = 10, .external_lex_state = 8},
  [2770] = {.lex_state = 10, .external_lex_state = 8},
  [2771] = {.lex_state = 10, .external_lex_state = 8},
  [2772] = {.lex_state = 10, .external_lex_state = 8},
  [2773] = {.lex_state = 10, .external_lex_state = 8},
  [2774] = {.lex_state = 10, .external_lex_state = 8},
  [2775] = {.lex_state = 10, .external_lex_state = 8},
  [2776] = {.lex_state = 10, .external_lex_state = 8},
  [2777] = {.lex_state = 10, .external_lex_state = 8},
  [2778] = {.lex_state = 10, .external_lex_state = 8},
  [2779] = {.lex_state = 10, .external_lex_state = 8},
  [2780] = {.lex_state = 10, .external_lex_state = 8},
  [2781] = {.lex_state = 10, .external_lex_state = 8},
  [2782] = {.lex_state = 10, .external_lex_state = 8},
  [2783] = {.lex_state = 10, .external_lex_state = 8},
  [2784] = {.lex_state = 10, .external_lex_state = 8},
  [2785] = {.lex_state = 10, .external_lex_state = 8},
  [2786] = {.lex_state = 10, .external_lex_state = 8},
  [2787] = {.lex_state = 10, .external_lex_state = 8},
  [2788] = {.lex_state = 10, .external_lex_state = 8},
  [2789] = {.lex_state = 10, .external_lex_state = 8},
  [2790] = {.lex_state = 10, .external_lex_state = 8},
  [2791] = {.lex_state = 10, .external_lex_state = 8},
  [2792] = {.lex_state = 9, .external_lex_state = 6},
  [2793] = {.lex_state = 22, .external_lex_state = 6},
  [2794] = {.lex_state = 22, .external_lex_state = 6},
  [2795] = {.lex_state = 22, .external_lex_state = 6},
  [2796] = {.lex_state = 22, .external_lex_state = 6},
  [2797] = {.lex_state = 22, .external_lex_state = 6},
  [2798] = {.lex_state = 22, .external_lex_state = 6},
  [2799] = {.lex_state = 22, .external_lex_state = 6},
  [2800] = {.lex_state = 22, .external_lex_state = 6},
  [2801] = {.lex_state = 22, .external_lex_state = 6},
  [2802] = {.lex_state = 22, .external_lex_state = 6},
  [2803] = {.lex_state = 22, .external_lex_state = 6},
  [2804] = {.lex_state = 22, .external_lex_state = 6},
  [2805] = {.lex_state = 22, .external_lex_state = 6},
  [2806] = {.lex_state = 22, .external_lex_state = 6},
  [2807] = {.lex_state = 22, .external_lex_state = 6},
  [2808] = {.lex_state = 22, .external_lex_state = 6},
  [2809] = {.lex_state = 22, .external_lex_state = 6},
  [2810] = {.lex_state = 13, .external_lex_state = 9},
  [2811] = {.lex_state = 14, .external_lex_state = 6},
  [2812] = {.lex_state = 14, .external_lex_state = 6},
  [2813] = {.lex_state = 21, .external_lex_state = 9},
  [2814] = {.lex_state = 13, .external_lex_state = 9},
  [2815] = {.lex_state = 13, .external_lex_state = 9},
  [2816] = {.lex_state = 13, .external_lex_state = 9},
  [2817] = {.lex_state = 13, .external_lex_state = 9},
  [2818] = {.lex_state = 21, .external_lex_state = 6},
  [2819] = {.lex_state = 13, .external_lex_state = 6},
  [2820] = {.lex_state = 13, .external_lex_state = 9},
  [2821] = {.lex_state = 13, .external_lex_state = 9},
  [2822] = {.lex_state = 13, .external_lex_state = 9},
  [2823] = {.lex_state = 13, .external_lex_state = 9},
  [2824] = {.lex_state = 13, .external_lex_state = 9},
  [2825] = {.lex_state = 13, .external_lex_state = 9},
  [2826] = {.lex_state = 13, .external_lex_state = 9},
  [2827] = {.lex_state = 13, .external_lex_state = 9},
  [2828] = {.lex_state = 13, .external_lex_state = 9},
  [2829] = {.lex_state = 13, .external_lex_state = 9},
  [2830] = {.lex_state = 13, .external_lex_state = 9},
  [2831] = {.lex_state = 13, .external_lex_state = 9},
  [2832] = {.lex_state = 13, .external_lex_state = 9},
  [2833] = {.lex_state = 13, .external_lex_state = 9},
  [2834] = {.lex_state = 13, .external_lex_state = 9},
  [2835] = {.lex_state = 13, .external_lex_state = 9},
  [2836] = {.lex_state = 13, .external_lex_state = 9},
  [2837] = {.lex_state = 13, .external_lex_state = 9},
  [2838] = {.lex_state = 13, .external_lex_state = 9},
  [2839] = {.lex_state = 13, .external_lex_state = 9},
  [2840] = {.lex_state = 13, .external_lex_state = 9},
  [2841] = {.lex_state = 13, .external_lex_state = 9},
  [2842] = {.lex_state = 13, .external_lex_state = 9},
  [2843] = {.lex_state = 13, .external_lex_state = 9},
  [2844] = {.lex_state = 13, .external_lex_state = 9},
  [2845] = {.lex_state = 13, .external_lex_state = 9},
  [2846] = {.lex_state = 13, .external_lex_state = 9},
  [2847] = {.lex_state = 13, .external_lex_state = 9},
  [2848] = {.lex_state = 13, .external_lex_state = 9},
  [2849] = {.lex_state = 13, .external_lex_state = 9},
  [2850] = {.lex_state = 13, .external_lex_state = 9},
  [2851] = {.lex_state = 13, .external_lex_state = 9},
  [2852] = {.lex_state = 13, .external_lex_state = 9},
  [2853] = {.lex_state = 13, .external_lex_state = 9},
  [2854] = {.lex_state = 13, .external_lex_state = 9},
  [2855] = {.lex_state = 13, .external_lex_state = 9},
  [2856] = {.lex_state = 13, .external_lex_state = 9},
  [2857] = {.lex_state = 13, .external_lex_state = 9},
  [2858] = {.lex_state = 13, .external_lex_state = 9},
  [2859] = {.lex_state = 13, .external_lex_state = 9},
  [2860] = {.lex_state = 13, .external_lex_state = 9},
  [2861] = {.lex_state = 14, .external_lex_state = 6},
  [2862] = {.lex_state = 13, .external_lex_state = 9},
  [2863] = {.lex_state = 14, .external_lex_state = 6},
  [2864] = {.lex_state = 13, .external_lex_state = 9},
  [2865] = {.lex_state = 13, .external_lex_state = 9},
  [2866] = {.lex_state = 17, .external_lex_state = 6},
  [2867] = {.lex_state = 13, .external_lex_state = 9},
  [2868] = {.lex_state = 13, .external_lex_state = 9},
  [2869] = {.lex_state = 14, .external_lex_state = 6},
  [2870] = {.lex_state = 13, .external_lex_state = 9},
  [2871] = {.lex_state = 14, .external_lex_state = 6},
  [2872] = {.lex_state = 13, .external_lex_state = 9},
  [2873] = {.lex_state = 13, .external_lex_state = 9},
  [2874] = {.lex_state = 13, .external_lex_state = 9},
  [2875] = {.lex_state = 13, .external_lex_state = 9},
  [2876] = {.lex_state = 13, .external_lex_state = 9},
  [2877] = {.lex_state = 13, .external_lex_state = 9},
  [2878] = {.lex_state = 13, .external_lex_state = 9},
  [2879] = {.lex_state = 13, .external_lex_state = 9},
  [2880] = {.lex_state = 13, .external_lex_state = 9},
  [2881] = {.lex_state = 13, .external_lex_state = 9},
  [2882] = {.lex_state = 13, .external_lex_state = 9},
  [2883] = {.lex_state = 21, .external_lex_state = 8},
  [2884] = {.lex_state = 13, .external_lex_state = 9},
  [2885] = {.lex_state = 13, .external_lex_state = 9},
  [2886] = {.lex_state = 13, .external_lex_state = 9},
  [2887] = {.lex_state = 13, .external_lex_state = 9},
  [2888] = {.lex_state = 13, .external_lex_state = 9},
  [2889] = {.lex_state = 13, .external_lex_state = 9},
  [2890] = {.lex_state = 13, .external_lex_state = 9},
  [2891] = {.lex_state = 19, .external_lex_state = 6},
  [2892] = {.lex_state = 13, .external_lex_state = 9},
  [2893] = {.lex_state = 13, .external_lex_state = 9},
  [2894] = {.lex_state = 14, .external_lex_state = 6},
  [2895] = {.lex_state = 11, .external_lex_state = 9},
  [2896] = {.lex_state = 14, .external_lex_state = 6},
  [2897] = {.lex_state = 11, .external_lex_state = 9},
  [2898] = {.lex_state = 14, .external_lex_state = 6},
  [2899] = {.lex_state = 14, .external_lex_state = 6},
  [2900] = {.lex_state = 14, .external_lex_state = 6},
  [2901] = {.lex_state = 12, .external_lex_state = 9},
  [2902] = {.lex_state = 14, .external_lex_state = 6},
  [2903] = {.lex_state = 11, .external_lex_state = 9},
  [2904] = {.lex_state = 11, .external_lex_state = 9},
  [2905] = {.lex_state = 14, .external_lex_state = 6},
  [2906] = {.lex_state = 14, .external_lex_state = 6},
  [2907] = {.lex_state = 14, .external_lex_state = 6},
  [2908] = {.lex_state = 14, .external_lex_state = 6},
  [2909] = {.lex_state = 14, .external_lex_state = 6},
  [2910] = {.lex_state = 14, .external_lex_state = 6},
  [2911] = {.lex_state = 14, .external_lex_state = 6},
  [2912] = {.lex_state = 14, .external_lex_state = 6},
  [2913] = {.lex_state = 14, .external_lex_state = 6},
  [2914] = {.lex_state = 14, .external_lex_state = 6},
  [2915] = {.lex_state = 14, .external_lex_state = 6},
  [2916] = {.lex_state = 14, .external_lex_state = 6},
  [2917] = {.lex_state = 14, .external_lex_state = 6},
  [2918] = {.lex_state = 14, .external_lex_state = 6},
  [2919] = {.lex_state = 11, .external_lex_state = 9},
  [2920] = {.lex_state = 14, .external_lex_state = 6},
  [2921] = {.lex_state = 21, .external_lex_state = 10},
  [2922] = {.lex_state = 14, .external_lex_state = 6},
  [2923] = {.lex_state = 13, .external_lex_state = 6},
  [2924] = {.lex_state = 11, .external_lex_state = 9},
  [2925] = {.lex_state = 14, .external_lex_state = 6},
  [2926] = {.lex_state = 14, .external_lex_state = 6},
  [2927] = {.lex_state = 14, .external_lex_state = 6},
  [2928] = {.lex_state = 14, .external_lex_state = 6},
  [2929] = {.lex_state = 14, .external_lex_state = 6},
  [2930] = {.lex_state = 14, .external_lex_state = 6},
  [2931] = {.lex_state = 14, .external_lex_state = 6},
  [2932] = {.lex_state = 14, .external_lex_state = 6},
  [2933] = {.lex_state = 12, .external_lex_state = 9},
  [2934] = {.lex_state = 12, .external_lex_state = 9},
  [2935] = {.lex_state = 12, .external_lex_state = 9},
  [2936] = {.lex_state = 12, .external_lex_state = 9},
  [2937] = {.lex_state = 11, .external_lex_state = 9},
  [2938] = {.lex_state = 11, .external_lex_state = 9},
  [2939] = {.lex_state = 14, .external_lex_state = 6},
  [2940] = {.lex_state = 14, .external_lex_state = 6},
  [2941] = {.lex_state = 14, .external_lex_state = 6},
  [2942] = {.lex_state = 14, .external_lex_state = 6},
  [2943] = {.lex_state = 14, .external_lex_state = 6},
  [2944] = {.lex_state = 14, .external_lex_state = 6},
  [2945] = {.lex_state = 14, .external_lex_state = 6},
  [2946] = {.lex_state = 14, .external_lex_state = 6},
  [2947] = {.lex_state = 14, .external_lex_state = 6},
  [2948] = {.lex_state = 14, .external_lex_state = 6},
  [2949] = {.lex_state = 14, .external_lex_state = 6},
  [2950] = {.lex_state = 14, .external_lex_state = 6},
  [2951] = {.lex_state = 14, .external_lex_state = 6},
  [2952] = {.lex_state = 14, .external_lex_state = 6},
  [2953] = {.lex_state = 14, .external_lex_state = 6},
  [2954] = {.lex_state = 13, .external_lex_state = 6},
  [2955] = {.lex_state = 14, .external_lex_state = 6},
  [2956] = {.lex_state = 14, .external_lex_state = 6},
  [2957] = {.lex_state = 14, .external_lex_state = 6},
  [2958] = {.lex_state = 14, .external_lex_state = 6},
  [2959] = {.lex_state = 14, .external_lex_state = 6},
  [2960] = {.lex_state = 11, .external_lex_state = 9},
  [2961] = {.lex_state = 11, .external_lex_state = 9},
  [2962] = {.lex_state = 14, .external_lex_state = 6},
  [2963] = {.lex_state = 14, .external_lex_state = 6},
  [2964] = {.lex_state = 14, .external_lex_state = 6},
  [2965] = {.lex_state = 14, .external_lex_state = 6},
  [2966] = {.lex_state = 14, .external_lex_state = 6},
  [2967] = {.lex_state = 14, .external_lex_state = 6},
  [2968] = {.lex_state = 11, .external_lex_state = 9},
  [2969] = {.lex_state = 14, .external_lex_state = 6},
  [2970] = {.lex_state = 14, .external_lex_state = 6},
  [2971] = {.lex_state = 14, .external_lex_state = 6},
  [2972] = {.lex_state = 21, .external_lex_state = 6},
  [2973] = {.lex_state = 14, .external_lex_state = 6},
  [2974] = {.lex_state = 11, .external_lex_state = 9},
  [2975] = {.lex_state = 13, .external_lex_state = 6},
  [2976] = {.lex_state = 11, .external_lex_state = 9},
  [2977] = {.lex_state = 14, .external_lex_state = 6},
  [2978] = {.lex_state = 14, .external_lex_state = 6},
  [2979] = {.lex_state = 14, .external_lex_state = 6},
  [2980] = {.lex_state = 13, .external_lex_state = 6},
  [2981] = {.lex_state = 14, .external_lex_state = 6},
  [2982] = {.lex_state = 14, .external_lex_state = 6},
  [2983] = {.lex_state = 14, .external_lex_state = 6},
  [2984] = {.lex_state = 14, .external_lex_state = 6},
  [2985] = {.lex_state = 11, .external_lex_state = 9},
  [2986] = {.lex_state = 11, .external_lex_state = 9},
  [2987] = {.lex_state = 11, .external_lex_state = 9},
  [2988] = {.lex_state = 11, .external_lex_state = 9},
  [2989] = {.lex_state = 11, .external_lex_state = 9},
  [2990] = {.lex_state = 11, .external_lex_state = 9},
  [2991] = {.lex_state = 11, .external_lex_state = 9},
  [2992] = {.lex_state = 11, .external_lex_state = 9},
  [2993] = {.lex_state = 11, .external_lex_state = 8},
  [2994] = {.lex_state = 21, .external_lex_state = 6},
  [2995] = {.lex_state = 11, .external_lex_state = 9},
  [2996] = {.lex_state = 11, .external_lex_state = 9},
  [2997] = {.lex_state = 11, .external_lex_state = 9},
  [2998] = {.lex_state = 11, .external_lex_state = 9},
  [2999] = {.lex_state = 11, .external_lex_state = 9},
  [3000] = {.lex_state = 11, .external_lex_state = 9},
  [3001] = {.lex_state = 13, .external_lex_state = 6},
  [3002] = {.lex_state = 11, .external_lex_state = 9},
  [3003] = {.lex_state = 21, .external_lex_state = 6},
  [3004] = {.lex_state = 11, .external_lex_state = 9},
  [3005] = {.lex_state = 13, .external_lex_state = 6},
  [3006] = {.lex_state = 11, .external_lex_state = 9},
  [3007] = {.lex_state = 21, .external_lex_state = 6},
  [3008] = {.lex_state = 11, .external_lex_state = 9},
  [3009] = {.lex_state = 11, .external_lex_state = 9},
  [3010] = {.lex_state = 21, .external_lex_state = 6},
  [3011] = {.lex_state = 19, .external_lex_state = 6},
  [3012] = {.lex_state = 13, .external_lex_state = 6},
  [3013] = {.lex_state = 17, .external_lex_state = 6},
  [3014] = {.lex_state = 11, .external_lex_state = 9},
  [3015] = {.lex_state = 11, .external_lex_state = 9},
  [3016] = {.lex_state = 21, .external_lex_state = 6},
  [3017] = {.lex_state = 11, .external_lex_state = 9},
  [3018] = {.lex_state = 11, .external_lex_state = 8},
  [3019] = {.lex_state = 11, .external_lex_state = 9},
  [3020] = {.lex_state = 11, .external_lex_state = 8},
  [3021] = {.lex_state = 21, .external_lex_state = 6},
  [3022] = {.lex_state = 11, .external_lex_state = 8},
  [3023] = {.lex_state = 17, .external_lex_state = 6},
  [3024] = {.lex_state = 11, .external_lex_state = 9},
  [3025] = {.lex_state = 17, .external_lex_state = 6},
  [3026] = {.lex_state = 11, .external_lex_state = 9},
  [3027] = {.lex_state = 21, .external_lex_state = 6},
  [3028] = {.lex_state = 11, .external_lex_state = 9},
  [3029] = {.lex_state = 13, .external_lex_state = 6},
  [3030] = {.lex_state = 11, .external_lex_state = 9},
  [3031] = {.lex_state = 11, .external_lex_state = 9},
  [3032] = {.lex_state = 21, .external_lex_state = 6},
  [3033] = {.lex_state = 21, .external_lex_state = 6},
  [3034] = {.lex_state = 13, .external_lex_state = 6},
  [3035] = {.lex_state = 21, .external_lex_state = 6},
  [3036] = {.lex_state = 21, .external_lex_state = 6},
  [3037] = {.lex_state = 11, .external_lex_state = 9},
  [3038] = {.lex_state = 11, .external_lex_state = 9},
  [3039] = {.lex_state = 21, .external_lex_state = 6},
  [3040] = {.lex_state = 11, .external_lex_state = 9},
  [3041] = {.lex_state = 11, .external_lex_state = 9},
  [3042] = {.lex_state = 21, .external_lex_state = 6},
  [3043] = {.lex_state = 21, .external_lex_state = 6},
  [3044] = {.lex_state = 11, .external_lex_state = 9},
  [3045] = {.lex_state = 21, .external_lex_state = 6},
  [3046] = {.lex_state = 11, .external_lex_state = 9},
  [3047] = {.lex_state = 13, .external_lex_state = 6},
  [3048] = {.lex_state = 11, .external_lex_state = 9},
  [3049] = {.lex_state = 11, .external_lex_state = 9},
  [3050] = {.lex_state = 19, .external_lex_state = 6},
  [3051] = {.lex_state = 11, .external_lex_state = 9},
  [3052] = {.lex_state = 17, .external_lex_state = 6},
  [3053] = {.lex_state = 11, .external_lex_state = 9},
  [3054] = {.lex_state = 11, .external_lex_state = 9},
  [3055] = {.lex_state = 11, .external_lex_state = 9},
  [3056] = {.lex_state = 11, .external_lex_state = 9},
  [3057] = {.lex_state = 13, .external_lex_state = 6},
  [3058] = {.lex_state = 11, .external_lex_state = 9},
  [3059] = {.lex_state = 11, .external_lex_state = 9},
  [3060] = {.lex_state = 11, .external_lex_state = 9},
  [3061] = {.lex_state = 11, .external_lex_state = 9},
  [3062] = {.lex_state = 13, .external_lex_state = 6},
  [3063] = {.lex_state = 11, .external_lex_state = 9},
  [3064] = {.lex_state = 21, .external_lex_state = 6},
  [3065] = {.lex_state = 11, .external_lex_state = 9},
  [3066] = {.lex_state = 13, .external_lex_state = 6},
  [3067] = {.lex_state = 11, .external_lex_state = 9},
  [3068] = {.lex_state = 11, .external_lex_state = 9},
  [3069] = {.lex_state = 19, .external_lex_state = 6},
  [3070] = {.lex_state = 11, .external_lex_state = 9},
  [3071] = {.lex_state = 19, .external_lex_state = 6},
  [3072] = {.lex_state = 11, .external_lex_state = 9},
  [3073] = {.lex_state = 11, .external_lex_state = 9},
  [3074] = {.lex_state = 11, .external_lex_state = 9},
  [3075] = {.lex_state = 11, .external_lex_state = 9},
  [3076] = {.lex_state = 11, .external_lex_state = 9},
  [3077] = {.lex_state = 11, .external_lex_state = 9},
  [3078] = {.lex_state = 11, .external_lex_state = 9},
  [3079] = {.lex_state = 11, .external_lex_state = 9},
  [3080] = {.lex_state = 21, .external_lex_state = 6},
  [3081] = {.lex_state = 19, .external_lex_state = 6},
  [3082] = {.lex_state = 13, .external_lex_state = 6},
  [3083] = {.lex_state = 13, .external_lex_state = 6},
  [3084] = {.lex_state = 11, .external_lex_state = 8},
  [3085] = {.lex_state = 11, .external_lex_state = 8},
  [3086] = {.lex_state = 13, .external_lex_state = 6},
  [3087] = {.lex_state = 19, .external_lex_state = 6},
  [3088] = {.lex_state = 13, .external_lex_state = 6},
  [3089] = {.lex_state = 13, .external_lex_state = 6},
  [3090] = {.lex_state = 19, .external_lex_state = 6},
  [3091] = {.lex_state = 11, .external_lex_state = 8},
  [3092] = {.lex_state = 13, .external_lex_state = 6},
  [3093] = {.lex_state = 13, .external_lex_state = 6},
  [3094] = {.lex_state = 13, .external_lex_state = 6},
  [3095] = {.lex_state = 13, .external_lex_state = 6},
  [3096] = {.lex_state = 13, .external_lex_state = 6},
  [3097] = {.lex_state = 11, .external_lex_state = 8},
  [3098] = {.lex_state = 13, .external_lex_state = 6},
  [3099] = {.lex_state = 21, .external_lex_state = 6},
  [3100] = {.lex_state = 17, .external_lex_state = 6},
  [3101] = {.lex_state = 17, .external_lex_state = 6},
  [3102] = {.lex_state = 13, .external_lex_state = 6},
  [3103] = {.lex_state = 13, .external_lex_state = 6},
  [3104] = {.lex_state = 13, .external_lex_state = 6},
  [3105] = {.lex_state = 11, .external_lex_state = 8},
  [3106] = {.lex_state = 13, .external_lex_state = 6},
  [3107] = {.lex_state = 13, .external_lex_state = 6},
  [3108] = {.lex_state = 13, .external_lex_state = 6},
  [3109] = {.lex_state = 13, .external_lex_state = 6},
  [3110] = {.lex_state = 13, .external_lex_state = 6},
  [3111] = {.lex_state = 13, .external_lex_state = 6},
  [3112] = {.lex_state = 11, .external_lex_state = 8},
  [3113] = {.lex_state = 13, .external_lex_state = 6},
  [3114] = {.lex_state = 17, .external_lex_state = 6},
  [3115] = {.lex_state = 13, .external_lex_state = 6},
  [3116] = {.lex_state = 13, .external_lex_state = 6},
  [3117] = {.lex_state = 13, .external_lex_state = 6},
  [3118] = {.lex_state = 17, .external_lex_state = 6},
  [3119] = {.lex_state = 13, .external_lex_state = 6},
  [3120] = {.lex_state = 13, .external_lex_state = 6},
  [3121] = {.lex_state = 19, .external_lex_state = 6},
  [3122] = {.lex_state = 19, .external_lex_state = 6},
  [3123] = {.lex_state = 13, .external_lex_state = 6},
  [3124] = {.lex_state = 11, .external_lex_state = 8},
  [3125] = {.lex_state = 13, .external_lex_state = 6},
  [3126] = {.lex_state = 19, .external_lex_state = 6},
  [3127] = {.lex_state = 17, .external_lex_state = 6},
  [3128] = {.lex_state = 17, .external_lex_state = 6},
  [3129] = {.lex_state = 13, .external_lex_state = 6},
  [3130] = {.lex_state = 13, .external_lex_state = 6},
  [3131] = {.lex_state = 17, .external_lex_state = 6},
  [3132] = {.lex_state = 13, .external_lex_state = 6},
  [3133] = {.lex_state = 17, .external_lex_state = 6},
  [3134] = {.lex_state = 13, .external_lex_state = 6},
  [3135] = {.lex_state = 13, .external_lex_state = 6},
  [3136] = {.lex_state = 13, .external_lex_state = 6},
  [3137] = {.lex_state = 13, .external_lex_state = 6},
  [3138] = {.lex_state = 19, .external_lex_state = 6},
  [3139] = {.lex_state = 13, .external_lex_state = 6},
  [3140] = {.lex_state = 11, .external_lex_state = 8},
  [3141] = {.lex_state = 13, .external_lex_state = 6},
  [3142] = {.lex_state = 13, .external_lex_state = 6},
  [3143] = {.lex_state = 13, .external_lex_state = 6},
  [3144] = {.lex_state = 13, .external_lex_state = 6},
  [3145] = {.lex_state = 13, .external_lex_state = 6},
  [3146] = {.lex_state = 13, .external_lex_state = 6},
  [3147] = {.lex_state = 13, .external_lex_state = 6},
  [3148] = {.lex_state = 13, .external_lex_state = 6},
  [3149] = {.lex_state = 13, .external_lex_state = 6},
  [3150] = {.lex_state = 13, .external_lex_state = 6},
  [3151] = {.lex_state = 19, .external_lex_state = 6},
  [3152] = {.lex_state = 19, .external_lex_state = 6},
  [3153] = {.lex_state = 13, .external_lex_state = 6},
  [3154] = {.lex_state = 13, .external_lex_state = 6},
  [3155] = {.lex_state = 13, .external_lex_state = 6},
  [3156] = {.lex_state = 13, .external_lex_state = 6},
  [3157] = {.lex_state = 13, .external_lex_state = 6},
  [3158] = {.lex_state = 17, .external_lex_state = 6},
  [3159] = {.lex_state = 13, .external_lex_state = 6},
  [3160] = {.lex_state = 13, .external_lex_state = 6},
  [3161] = {.lex_state = 13, .external_lex_state = 6},
  [3162] = {.lex_state = 11, .external_lex_state = 8},
  [3163] = {.lex_state = 13, .external_lex_state = 6},
  [3164] = {.lex_state = 13, .external_lex_state = 6},
  [3165] = {.lex_state = 13, .external_lex_state = 6},
  [3166] = {.lex_state = 13, .external_lex_state = 6},
  [3167] = {.lex_state = 11, .external_lex_state = 8},
  [3168] = {.lex_state = 11, .external_lex_state = 8},
  [3169] = {.lex_state = 17, .external_lex_state = 6},
  [3170] = {.lex_state = 19, .external_lex_state = 6},
  [3171] = {.lex_state = 17, .external_lex_state = 6},
  [3172] = {.lex_state = 17, .external_lex_state = 6},
  [3173] = {.lex_state = 17, .external_lex_state = 6},
  [3174] = {.lex_state = 17, .external_lex_state = 6},
  [3175] = {.lex_state = 17, .external_lex_state = 6},
  [3176] = {.lex_state = 11, .external_lex_state = 8},
  [3177] = {.lex_state = 11, .external_lex_state = 8},
  [3178] = {.lex_state = 17, .external_lex_state = 6},
  [3179] = {.lex_state = 19, .external_lex_state = 6},
  [3180] = {.lex_state = 17, .external_lex_state = 6},
  [3181] = {.lex_state = 17, .external_lex_state = 6},
  [3182] = {.lex_state = 17, .external_lex_state = 6},
  [3183] = {.lex_state = 19, .external_lex_state = 6},
  [3184] = {.lex_state = 17, .external_lex_state = 6},
  [3185] = {.lex_state = 17, .external_lex_state = 6},
  [3186] = {.lex_state = 17, .external_lex_state = 6},
  [3187] = {.lex_state = 11, .external_lex_state = 8},
  [3188] = {.lex_state = 11, .external_lex_state = 8},
  [3189] = {.lex_state = 11, .external_lex_state = 8},
  [3190] = {.lex_state = 11, .external_lex_state = 8},
  [3191] = {.lex_state = 19, .external_lex_state = 6},
  [3192] = {.lex_state = 19, .external_lex_state = 6},
  [3193] = {.lex_state = 19, .external_lex_state = 6},
  [3194] = {.lex_state = 11, .external_lex_state = 8},
  [3195] = {.lex_state = 17, .external_lex_state = 6},
  [3196] = {.lex_state = 17, .external_lex_state = 6},
  [3197] = {.lex_state = 17, .external_lex_state = 6},
  [3198] = {.lex_state = 11, .external_lex_state = 8},
  [3199] = {.lex_state = 17, .external_lex_state = 6},
  [3200] = {.lex_state = 17, .external_lex_state = 6},
  [3201] = {.lex_state = 11, .external_lex_state = 8},
  [3202] = {.lex_state = 17, .external_lex_state = 6},
  [3203] = {.lex_state = 17, .external_lex_state = 6},
  [3204] = {.lex_state = 17, .external_lex_state = 6},
  [3205] = {.lex_state = 11, .external_lex_state = 8},
  [3206] = {.lex_state = 11, .external_lex_state = 8},
  [3207] = {.lex_state = 11, .external_lex_state = 8},
  [3208] = {.lex_state = 19, .external_lex_state = 6},
  [3209] = {.lex_state = 11, .external_lex_state = 8},
  [3210] = {.lex_state = 19, .external_lex_state = 6},
  [3211] = {.lex_state = 17, .external_lex_state = 6},
  [3212] = {.lex_state = 11, .external_lex_state = 8},
  [3213] = {.lex_state = 11, .external_lex_state = 8},
  [3214] = {.lex_state = 17, .external_lex_state = 6},
  [3215] = {.lex_state = 17, .external_lex_state = 6},
  [3216] = {.lex_state = 11, .external_lex_state = 8},
  [3217] = {.lex_state = 19, .external_lex_state = 6},
  [3218] = {.lex_state = 17, .external_lex_state = 6},
  [3219] = {.lex_state = 19, .external_lex_state = 6},
  [3220] = {.lex_state = 17, .external_lex_state = 6},
  [3221] = {.lex_state = 19, .external_lex_state = 6},
  [3222] = {.lex_state = 19, .external_lex_state = 6},
  [3223] = {.lex_state = 19, .external_lex_state = 6},
  [3224] = {.lex_state = 19, .external_lex_state = 6},
  [3225] = {.lex_state = 17, .external_lex_state = 6},
  [3226] = {.lex_state = 19, .external_lex_state = 6},
  [3227] = {.lex_state = 19, .external_lex_state = 6},
  [3228] = {.lex_state = 19, .external_lex_state = 6},
  [3229] = {.lex_state = 11, .external_lex_state = 8},
  [3230] = {.lex_state = 11, .external_lex_state = 8},
  [3231] = {.lex_state = 11, .external_lex_state = 8},
  [3232] = {.lex_state = 19, .external_lex_state = 6},
  [3233] = {.lex_state = 17, .external_lex_state = 6},
  [3234] = {.lex_state = 17, .external_lex_state = 6},
  [3235] = {.lex_state = 19, .external_lex_state = 6},
  [3236] = {.lex_state = 17, .external_lex_state = 6},
  [3237] = {.lex_state = 19, .external_lex_state = 6},
  [3238] = {.lex_state = 11, .external_lex_state = 10},
  [3239] = {.lex_state = 11, .external_lex_state = 8},
  [3240] = {.lex_state = 19, .external_lex_state = 6},
  [3241] = {.lex_state = 17, .external_lex_state = 6},
  [3242] = {.lex_state = 17, .external_lex_state = 6},
  [3243] = {.lex_state = 17, .external_lex_state = 6},
  [3244] = {.lex_state = 17, .external_lex_state = 6},
  [3245] = {.lex_state = 17, .external_lex_state = 6},
  [3246] = {.lex_state = 11, .external_lex_state = 8},
  [3247] = {.lex_state = 17, .external_lex_state = 6},
  [3248] = {.lex_state = 11, .external_lex_state = 8},
  [3249] = {.lex_state = 19, .external_lex_state = 6},
  [3250] = {.lex_state = 17, .external_lex_state = 6},
  [3251] = {.lex_state = 19, .external_lex_state = 6},
  [3252] = {.lex_state = 11, .external_lex_state = 8},
  [3253] = {.lex_state = 17, .external_lex_state = 6},
  [3254] = {.lex_state = 11, .external_lex_state = 8},
  [3255] = {.lex_state = 19, .external_lex_state = 6},
  [3256] = {.lex_state = 19, .external_lex_state = 6},
  [3257] = {.lex_state = 11, .external_lex_state = 8},
  [3258] = {.lex_state = 17, .external_lex_state = 6},
  [3259] = {.lex_state = 17, .external_lex_state = 6},
  [3260] = {.lex_state = 11, .external_lex_state = 8},
  [3261] = {.lex_state = 11, .external_lex_state = 8},
  [3262] = {.lex_state = 17, .external_lex_state = 6},
  [3263] = {.lex_state = 17, .external_lex_state = 6},
  [3264] = {.lex_state = 17, .external_lex_state = 6},
  [3265] = {.lex_state = 19, .external_lex_state = 6},
  [3266] = {.lex_state = 11, .external_lex_state = 8},
  [3267] = {.lex_state = 11, .external_lex_state = 8},
  [3268] = {.lex_state = 11, .external_lex_state = 10},
  [3269] = {.lex_state = 17, .external_lex_state = 6},
  [3270] = {.lex_state = 19, .external_lex_state = 6},
  [3271] = {.lex_state = 11, .external_lex_state = 8},
  [3272] = {.lex_state = 19, .external_lex_state = 6},
  [3273] = {.lex_state = 11, .external_lex_state = 8},
  [3274] = {.lex_state = 11, .external_lex_state = 8},
  [3275] = {.lex_state = 19, .external_lex_state = 6},
  [3276] = {.lex_state = 19, .external_lex_state = 6},
  [3277] = {.lex_state = 11, .external_lex_state = 8},
  [3278] = {.lex_state = 17, .external_lex_state = 6},
  [3279] = {.lex_state = 11, .external_lex_state = 8},
  [3280] = {.lex_state = 19, .external_lex_state = 6},
  [3281] = {.lex_state = 19, .external_lex_state = 6},
  [3282] = {.lex_state = 19, .external_lex_state = 6},
  [3283] = {.lex_state = 17, .external_lex_state = 6},
  [3284] = {.lex_state = 19, .external_lex_state = 6},
  [3285] = {.lex_state = 11, .external_lex_state = 8},
  [3286] = {.lex_state = 19, .external_lex_state = 6},
  [3287] = {.lex_state = 19, .external_lex_state = 6},
  [3288] = {.lex_state = 19, .external_lex_state = 6},
  [3289] = {.lex_state = 11, .external_lex_state = 8},
  [3290] = {.lex_state = 17, .external_lex_state = 6},
  [3291] = {.lex_state = 19, .external_lex_state = 6},
  [3292] = {.lex_state = 17, .external_lex_state = 6},
  [3293] = {.lex_state = 17, .external_lex_state = 6},
  [3294] = {.lex_state = 11, .external_lex_state = 8},
  [3295] = {.lex_state = 17, .external_lex_state = 6},
  [3296] = {.lex_state = 11, .external_lex_state = 8},
  [3297] = {.lex_state = 17, .external_lex_state = 6},
  [3298] = {.lex_state = 17, .external_lex_state = 6},
  [3299] = {.lex_state = 11, .external_lex_state = 8},
  [3300] = {.lex_state = 19, .external_lex_state = 6},
  [3301] = {.lex_state = 19, .external_lex_state = 6},
  [3302] = {.lex_state = 19, .external_lex_state = 6},
  [3303] = {.lex_state = 11, .external_lex_state = 8},
  [3304] = {.lex_state = 11, .external_lex_state = 8},
  [3305] = {.lex_state = 19, .external_lex_state = 6},
  [3306] = {.lex_state = 11, .external_lex_state = 8},
  [3307] = {.lex_state = 17, .external_lex_state = 6},
  [3308] = {.lex_state = 11, .external_lex_state = 8},
  [3309] = {.lex_state = 17, .external_lex_state = 6},
  [3310] = {.lex_state = 17, .external_lex_state = 6},
  [3311] = {.lex_state = 11, .external_lex_state = 8},
  [3312] = {.lex_state = 11, .external_lex_state = 8},
  [3313] = {.lex_state = 11, .external_lex_state = 8},
  [3314] = {.lex_state = 19, .external_lex_state = 6},
  [3315] = {.lex_state = 11, .external_lex_state = 8},
  [3316] = {.lex_state = 11, .external_lex_state = 8},
  [3317] = {.lex_state = 19, .external_lex_state = 6},
  [3318] = {.lex_state = 19, .external_lex_state = 6},
  [3319] = {.lex_state = 19, .external_lex_state = 6},
  [3320] = {.lex_state = 11, .external_lex_state = 8},
  [3321] = {.lex_state = 11, .external_lex_state = 8},
  [3322] = {.lex_state = 19, .external_lex_state = 6},
  [3323] = {.lex_state = 19, .external_lex_state = 6},
  [3324] = {.lex_state = 11, .external_lex_state = 8},
  [3325] = {.lex_state = 19, .external_lex_state = 6},
  [3326] = {.lex_state = 19, .external_lex_state = 6},
  [3327] = {.lex_state = 19, .external_lex_state = 6},
  [3328] = {.lex_state = 11, .external_lex_state = 8},
  [3329] = {.lex_state = 19, .external_lex_state = 6},
  [3330] = {.lex_state = 19, .external_lex_state = 6},
  [3331] = {.lex_state = 19, .external_lex_state = 6},
  [3332] = {.lex_state = 19, .external_lex_state = 6},
  [3333] = {.lex_state = 19, .external_lex_state = 6},
  [3334] = {.lex_state = 11, .external_lex_state = 10},
  [3335] = {.lex_state = 11, .external_lex_state = 8},
  [3336] = {.lex_state = 11, .external_lex_state = 8},
  [3337] = {.lex_state = 19, .external_lex_state = 6},
  [3338] = {.lex_state = 11, .external_lex_state = 8},
  [3339] = {.lex_state = 17, .external_lex_state = 6},
  [3340] = {.lex_state = 19, .external_lex_state = 6},
  [3341] = {.lex_state = 11, .external_lex_state = 8},
  [3342] = {.lex_state = 17, .external_lex_state = 6},
  [3343] = {.lex_state = 17, .external_lex_state = 6},
  [3344] = {.lex_state = 11, .external_lex_state = 10},
  [3345] = {.lex_state = 11, .external_lex_state = 10},
  [3346] = {.lex_state = 11, .external_lex_state = 10},
  [3347] = {.lex_state = 11, .external_lex_state = 10},
  [3348] = {.lex_state = 11, .external_lex_state = 10},
  [3349] = {.lex_state = 11, .external_lex_state = 10},
  [3350] = {.lex_state = 11, .external_lex_state = 10},
  [3351] = {.lex_state = 11, .external_lex_state = 10},
  [3352] = {.lex_state = 11, .external_lex_state = 10},
  [3353] = {.lex_state = 11, .external_lex_state = 10},
  [3354] = {.lex_state = 11, .external_lex_state = 10},
  [3355] = {.lex_state = 11, .external_lex_state = 10},
  [3356] = {.lex_state = 11, .external_lex_state = 10},
  [3357] = {.lex_state = 11, .external_lex_state = 10},
  [3358] = {.lex_state = 11, .external_lex_state = 10},
  [3359] = {.lex_state = 11, .external_lex_state = 10},
  [3360] = {.lex_state = 11, .external_lex_state = 10},
  [3361] = {.lex_state = 11, .external_lex_state = 10},
  [3362] = {.lex_state = 11, .external_lex_state = 10},
  [3363] = {.lex_state = 11, .external_lex_state = 10},
  [3364] = {.lex_state = 11, .external_lex_state = 10},
  [3365] = {.lex_state = 11, .external_lex_state = 10},
  [3366] = {.lex_state = 11, .external_lex_state = 10},
  [3367] = {.lex_state = 11, .external_lex_state = 10},
  [3368] = {.lex_state = 11, .external_lex_state = 10},
  [3369] = {.lex_state = 11, .external_lex_state = 10},
  [3370] = {.lex_state = 11, .external_lex_state = 10},
  [3371] = {.lex_state = 11, .external_lex_state = 10},
  [3372] = {.lex_state = 11, .external_lex_state = 10},
  [3373] = {.lex_state = 11, .external_lex_state = 10},
  [3374] = {.lex_state = 11, .external_lex_state = 10},
  [3375] = {.lex_state = 11, .external_lex_state = 10},
  [3376] = {.lex_state = 11, .external_lex_state = 10},
  [3377] = {.lex_state = 11, .external_lex_state = 10},
  [3378] = {.lex_state = 11, .external_lex_state = 10},
  [3379] = {.lex_state = 11, .external_lex_state = 10},
  [3380] = {.lex_state = 11, .external_lex_state = 10},
  [3381] = {.lex_state = 11, .external_lex_state = 10},
  [3382] = {.lex_state = 11, .external_lex_state = 10},
  [3383] = {.lex_state = 11, .external_lex_state = 10},
  [3384] = {.lex_state = 11, .external_lex_state = 10},
  [3385] = {.lex_state = 11, .external_lex_state = 10},
  [3386] = {.lex_state = 11, .external_lex_state = 10},
  [3387] = {.lex_state = 11, .external_lex_state = 10},
  [3388] = {.lex_state = 11, .external_lex_state = 10},
  [3389] = {.lex_state = 11, .external_lex_state = 10},
  [3390] = {.lex_state = 11, .external_lex_state = 10},
  [3391] = {.lex_state = 11, .external_lex_state = 10},
  [3392] = {.lex_state = 11, .external_lex_state = 10},
  [3393] = {.lex_state = 11, .external_lex_state = 10},
  [3394] = {.lex_state = 11, .external_lex_state = 10},
  [3395] = {.lex_state = 11, .external_lex_state = 10},
  [3396] = {.lex_state = 11, .external_lex_state = 10},
  [3397] = {.lex_state = 11, .external_lex_state = 10},
  [3398] = {.lex_state = 11, .external_lex_state = 10},
  [3399] = {.lex_state = 11, .external_lex_state = 10},
  [3400] = {.lex_state = 11, .external_lex_state = 10},
  [3401] = {.lex_state = 11, .external_lex_state = 10},
  [3402] = {.lex_state = 11, .external_lex_state = 10},
  [3403] = {.lex_state = 11, .external_lex_state = 10},
  [3404] = {.lex_state = 11, .external_lex_state = 10},
  [3405] = {.lex_state = 11, .external_lex_state = 10},
  [3406] = {.lex_state = 11, .external_lex_state = 10},
  [3407] = {.lex_state = 11, .external_lex_state = 10},
  [3408] = {.lex_state = 11, .external_lex_state = 10},
  [3409] = {.lex_state = 11, .external_lex_state = 10},
  [3410] = {.lex_state = 11, .external_lex_state = 10},
  [3411] = {.lex_state = 11, .external_lex_state = 10},
  [3412] = {.lex_state = 226},
  [3413] = {.lex_state = 226},
  [3414] = {.lex_state = 226},
  [3415] = {.lex_state = 226},
  [3416] = {.lex_state = 226},
  [3417] = {.lex_state = 226},
  [3418] = {.lex_state = 226},
  [3419] = {.lex_state = 226},
  [3420] = {.lex_state = 226},
  [3421] = {.lex_state = 226},
  [3422] = {.lex_state = 226},
  [3423] = {.lex_state = 226},
  [3424] = {.lex_state = 226},
  [3425] = {.lex_state = 231},
  [3426] = {.lex_state = 231},
  [3427] = {.lex_state = 226},
  [3428] = {.lex_state = 226},
  [3429] = {.lex_state = 226},
  [3430] = {.lex_state = 226},
  [3431] = {.lex_state = 226},
  [3432] = {.lex_state = 226},
  [3433] = {.lex_state = 226},
  [3434] = {.lex_state = 226},
  [3435] = {.lex_state = 226},
  [3436] = {.lex_state = 226},
  [3437] = {.lex_state = 226},
  [3438] = {.lex_state = 226},
  [3439] = {.lex_state = 226},
  [3440] = {.lex_state = 226},
  [3441] = {.lex_state = 226},
  [3442] = {.lex_state = 226},
  [3443] = {.lex_state = 226},
  [3444] = {.lex_state = 226},
  [3445] = {.lex_state = 226},
  [3446] = {.lex_state = 226},
  [3447] = {.lex_state = 226},
  [3448] = {.lex_state = 226},
  [3449] = {.lex_state = 226},
  [3450] = {.lex_state = 226},
  [3451] = {.lex_state = 226},
  [3452] = {.lex_state = 226},
  [3453] = {.lex_state = 226},
  [3454] = {.lex_state = 226},
  [3455] = {.lex_state = 226},
  [3456] = {.lex_state = 226},
  [3457] = {.lex_state = 226},
  [3458] = {.lex_state = 226},
  [3459] = {.lex_state = 226},
  [3460] = {.lex_state = 226},
  [3461] = {.lex_state = 226},
  [3462] = {.lex_state = 226},
  [3463] = {.lex_state = 226},
  [3464] = {.lex_state = 226},
  [3465] = {.lex_state = 226},
  [3466] = {.lex_state = 226},
  [3467] = {.lex_state = 226},
  [3468] = {.lex_state = 226},
  [3469] = {.lex_state = 226},
  [3470] = {.lex_state = 226},
  [3471] = {.lex_state = 226},
  [3472] = {.lex_state = 226},
  [3473] = {.lex_state = 226},
  [3474] = {.lex_state = 226},
  [3475] = {.lex_state = 226},
  [3476] = {.lex_state = 226},
  [3477] = {.lex_state = 226},
  [3478] = {.lex_state = 226},
  [3479] = {.lex_state = 226},
  [3480] = {.lex_state = 226},
  [3481] = {.lex_state = 226},
  [3482] = {.lex_state = 226},
  [3483] = {.lex_state = 226},
  [3484] = {.lex_state = 226},
  [3485] = {.lex_state = 226},
  [3486] = {.lex_state = 226},
  [3487] = {.lex_state = 226},
  [3488] = {.lex_state = 226},
  [3489] = {.lex_state = 226},
  [3490] = {.lex_state = 226},
  [3491] = {.lex_state = 226},
  [3492] = {.lex_state = 226},
  [3493] = {.lex_state = 226},
  [3494] = {.lex_state = 226, .external_lex_state = 11},
  [3495] = {.lex_state = 226, .external_lex_state = 11},
  [3496] = {.lex_state = 226},
  [3497] = {.lex_state = 226, .external_lex_state = 11},
  [3498] = {.lex_state = 226, .external_lex_state = 11},
  [3499] = {.lex_state = 226, .external_lex_state = 11},
  [3500] = {.lex_state = 226, .external_lex_state = 11},
  [3501] = {.lex_state = 226},
  [3502] = {.lex_state = 226},
  [3503] = {.lex_state = 226},
  [3504] = {.lex_state = 226},
  [3505] = {.lex_state = 226},
  [3506] = {.lex_state = 226},
  [3507] = {.lex_state = 226},
  [3508] = {.lex_state = 226},
  [3509] = {.lex_state = 226},
  [3510] = {.lex_state = 226},
  [3511] = {.lex_state = 226},
  [3512] = {.lex_state = 226},
  [3513] = {.lex_state = 226},
  [3514] = {.lex_state = 226},
  [3515] = {.lex_state = 226},
  [3516] = {.lex_state = 231},
  [3517] = {.lex_state = 226},
  [3518] = {.lex_state = 23},
  [3519] = {.lex_state = 226},
  [3520] = {.lex_state = 226},
  [3521] = {.lex_state = 226},
  [3522] = {.lex_state = 226},
  [3523] = {.lex_state = 226},
  [3524] = {.lex_state = 226},
  [3525] = {.lex_state = 226},
  [3526] = {.lex_state = 226},
  [3527] = {.lex_state = 226},
  [3528] = {.lex_state = 226},
  [3529] = {.lex_state = 226},
  [3530] = {.lex_state = 226},
  [3531] = {.lex_state = 226},
  [3532] = {.lex_state = 226},
  [3533] = {.lex_state = 226},
  [3534] = {.lex_state = 226},
  [3535] = {.lex_state = 226},
  [3536] = {.lex_state = 226},
  [3537] = {.lex_state = 226},
  [3538] = {.lex_state = 226},
  [3539] = {.lex_state = 226},
  [3540] = {.lex_state = 226},
  [3541] = {.lex_state = 226},
  [3542] = {.lex_state = 226},
  [3543] = {.lex_state = 226},
  [3544] = {.lex_state = 226},
  [3545] = {.lex_state = 226},
  [3546] = {.lex_state = 226},
  [3547] = {.lex_state = 226},
  [3548] = {.lex_state = 226},
  [3549] = {.lex_state = 226},
  [3550] = {.lex_state = 226},
  [3551] = {.lex_state = 226},
  [3552] = {.lex_state = 226},
  [3553] = {.lex_state = 226},
  [3554] = {.lex_state = 226},
  [3555] = {.lex_state = 226},
  [3556] = {.lex_state = 226},
  [3557] = {.lex_state = 226},
  [3558] = {.lex_state = 226},
  [3559] = {.lex_state = 226},
  [3560] = {.lex_state = 226},
  [3561] = {.lex_state = 226},
  [3562] = {.lex_state = 226},
  [3563] = {.lex_state = 226},
  [3564] = {.lex_state = 226},
  [3565] = {.lex_state = 226},
  [3566] = {.lex_state = 226},
  [3567] = {.lex_state = 226},
  [3568] = {.lex_state = 226},
  [3569] = {.lex_state = 226, .external_lex_state = 12},
  [3570] = {.lex_state = 226},
  [3571] = {.lex_state = 226},
  [3572] = {.lex_state = 226},
  [3573] = {.lex_state = 226},
  [3574] = {.lex_state = 226},
  [3575] = {.lex_state = 226},
  [3576] = {.lex_state = 226},
  [3577] = {.lex_state = 226},
  [3578] = {.lex_state = 226},
  [3579] = {.lex_state = 226},
  [3580] = {.lex_state = 226, .external_lex_state = 12},
  [3581] = {.lex_state = 226},
  [3582] = {.lex_state = 226},
  [3583] = {.lex_state = 226},
  [3584] = {.lex_state = 226},
  [3585] = {.lex_state = 226},
  [3586] = {.lex_state = 226},
  [3587] = {.lex_state = 226},
  [3588] = {.lex_state = 226},
  [3589] = {.lex_state = 226},
  [3590] = {.lex_state = 226},
  [3591] = {.lex_state = 226, .external_lex_state = 12},
  [3592] = {.lex_state = 226},
  [3593] = {.lex_state = 226},
  [3594] = {.lex_state = 226},
  [3595] = {.lex_state = 226, .external_lex_state = 12},
  [3596] = {.lex_state = 226, .external_lex_state = 12},
  [3597] = {.lex_state = 226},
  [3598] = {.lex_state = 226},
  [3599] = {.lex_state = 226},
  [3600] = {.lex_state = 226},
  [3601] = {.lex_state = 226},
  [3602] = {.lex_state = 226},
  [3603] = {.lex_state = 226},
  [3604] = {.lex_state = 226},
  [3605] = {.lex_state = 226},
  [3606] = {.lex_state = 226},
  [3607] = {.lex_state = 226},
  [3608] = {.lex_state = 226},
  [3609] = {.lex_state = 226},
  [3610] = {.lex_state = 226},
  [3611] = {.lex_state = 226},
  [3612] = {.lex_state = 226},
  [3613] = {.lex_state = 226},
  [3614] = {.lex_state = 226},
  [3615] = {.lex_state = 226},
  [3616] = {.lex_state = 226},
  [3617] = {.lex_state = 226},
  [3618] = {.lex_state = 226},
  [3619] = {.lex_state = 226},
  [3620] = {.lex_state = 226},
  [3621] = {.lex_state = 226},
  [3622] = {.lex_state = 226},
  [3623] = {.lex_state = 226},
  [3624] = {.lex_state = 226},
  [3625] = {.lex_state = 226},
  [3626] = {.lex_state = 226},
  [3627] = {.lex_state = 226},
  [3628] = {.lex_state = 226},
  [3629] = {.lex_state = 226},
  [3630] = {.lex_state = 226},
  [3631] = {.lex_state = 226},
  [3632] = {.lex_state = 226},
  [3633] = {.lex_state = 226},
  [3634] = {.lex_state = 226},
  [3635] = {.lex_state = 226},
  [3636] = {.lex_state = 226},
  [3637] = {.lex_state = 226},
  [3638] = {.lex_state = 226, .external_lex_state = 13},
  [3639] = {.lex_state = 226, .external_lex_state = 13},
  [3640] = {.lex_state = 226, .external_lex_state = 13},
  [3641] = {.lex_state = 226},
  [3642] = {.lex_state = 226},
  [3643] = {.lex_state = 226},
  [3644] = {.lex_state = 226},
  [3645] = {.lex_state = 226},
  [3646] = {.lex_state = 226},
  [3647] = {.lex_state = 226},
  [3648] = {.lex_state = 226},
  [3649] = {.lex_state = 226},
  [3650] = {.lex_state = 226},
  [3651] = {.lex_state = 226},
  [3652] = {.lex_state = 226},
  [3653] = {.lex_state = 226},
  [3654] = {.lex_state = 226},
  [3655] = {.lex_state = 226},
  [3656] = {.lex_state = 226},
  [3657] = {.lex_state = 226},
  [3658] = {.lex_state = 226},
  [3659] = {.lex_state = 226},
  [3660] = {.lex_state = 226},
  [3661] = {.lex_state = 226},
  [3662] = {.lex_state = 231},
  [3663] = {.lex_state = 226},
  [3664] = {.lex_state = 226},
  [3665] = {.lex_state = 226},
  [3666] = {.lex_state = 226},
  [3667] = {.lex_state = 226},
  [3668] = {.lex_state = 226},
  [3669] = {.lex_state = 231},
  [3670] = {.lex_state = 226},
  [3671] = {.lex_state = 226},
  [3672] = {.lex_state = 226},
  [3673] = {.lex_state = 226},
  [3674] = {.lex_state = 226},
  [3675] = {.lex_state = 226},
  [3676] = {.lex_state = 226},
  [3677] = {.lex_state = 226},
  [3678] = {.lex_state = 226},
  [3679] = {.lex_state = 226},
  [3680] = {.lex_state = 226},
  [3681] = {.lex_state = 226},
  [3682] = {.lex_state = 226},
  [3683] = {.lex_state = 226},
  [3684] = {.lex_state = 226},
  [3685] = {.lex_state = 226},
  [3686] = {.lex_state = 226},
  [3687] = {.lex_state = 226},
  [3688] = {.lex_state = 226},
  [3689] = {.lex_state = 226},
  [3690] = {.lex_state = 226},
  [3691] = {.lex_state = 226},
  [3692] = {.lex_state = 226},
  [3693] = {.lex_state = 226},
  [3694] = {.lex_state = 226},
  [3695] = {.lex_state = 226},
  [3696] = {.lex_state = 226},
  [3697] = {.lex_state = 226},
  [3698] = {.lex_state = 226},
  [3699] = {.lex_state = 226},
  [3700] = {.lex_state = 226},
  [3701] = {.lex_state = 226},
  [3702] = {.lex_state = 226},
  [3703] = {.lex_state = 226},
  [3704] = {.lex_state = 226},
  [3705] = {.lex_state = 226},
  [3706] = {.lex_state = 226},
  [3707] = {.lex_state = 226},
  [3708] = {.lex_state = 226},
  [3709] = {.lex_state = 226},
  [3710] = {.lex_state = 226},
  [3711] = {.lex_state = 226},
  [3712] = {.lex_state = 226},
  [3713] = {.lex_state = 226},
  [3714] = {.lex_state = 226},
  [3715] = {.lex_state = 226},
  [3716] = {.lex_state = 226, .external_lex_state = 13},
  [3717] = {.lex_state = 226},
  [3718] = {.lex_state = 226},
  [3719] = {.lex_state = 226},
  [3720] = {.lex_state = 226},
  [3721] = {.lex_state = 226},
  [3722] = {.lex_state = 226},
  [3723] = {.lex_state = 226},
  [3724] = {.lex_state = 226},
  [3725] = {.lex_state = 226},
  [3726] = {.lex_state = 226},
  [3727] = {.lex_state = 226},
  [3728] = {.lex_state = 226},
  [3729] = {.lex_state = 226},
  [3730] = {.lex_state = 231, .external_lex_state = 13},
  [3731] = {.lex_state = 226},
  [3732] = {.lex_state = 226},
  [3733] = {.lex_state = 226},
  [3734] = {.lex_state = 226},
  [3735] = {.lex_state = 226},
  [3736] = {.lex_state = 226},
  [3737] = {.lex_state = 226},
  [3738] = {.lex_state = 226},
  [3739] = {.lex_state = 226},
  [3740] = {.lex_state = 226},
  [3741] = {.lex_state = 226},
  [3742] = {.lex_state = 226},
  [3743] = {.lex_state = 226},
  [3744] = {.lex_state = 226},
  [3745] = {.lex_state = 226},
  [3746] = {.lex_state = 226, .external_lex_state = 13},
  [3747] = {.lex_state = 226, .external_lex_state = 13},
  [3748] = {.lex_state = 226, .external_lex_state = 13},
  [3749] = {.lex_state = 226},
  [3750] = {.lex_state = 226, .external_lex_state = 13},
  [3751] = {.lex_state = 226, .external_lex_state = 13},
  [3752] = {.lex_state = 226, .external_lex_state = 13},
  [3753] = {.lex_state = 226, .external_lex_state = 13},
  [3754] = {.lex_state = 226, .external_lex_state = 13},
  [3755] = {.lex_state = 226},
  [3756] = {.lex_state = 226, .external_lex_state = 13},
  [3757] = {.lex_state = 226, .external_lex_state = 13},
  [3758] = {.lex_state = 226},
  [3759] = {.lex_state = 226},
  [3760] = {.lex_state = 226, .external_lex_state = 13},
  [3761] = {.lex_state = 226, .external_lex_state = 13},
  [3762] = {.lex_state = 226, .external_lex_state = 13},
  [3763] = {.lex_state = 226, .external_lex_state = 13},
  [3764] = {.lex_state = 226, .external_lex_state = 13},
  [3765] = {.lex_state = 226},
  [3766] = {.lex_state = 226, .external_lex_state = 13},
  [3767] = {.lex_state = 226, .external_lex_state = 13},
  [3768] = {.lex_state = 226, .external_lex_state = 13},
  [3769] = {.lex_state = 226, .external_lex_state = 13},
  [3770] = {.lex_state = 226, .external_lex_state = 13},
  [3771] = {.lex_state = 226, .external_lex_state = 13},
  [3772] = {.lex_state = 226, .external_lex_state = 13},
  [3773] = {.lex_state = 226, .external_lex_state = 13},
  [3774] = {.lex_state = 226, .external_lex_state = 13},
  [3775] = {.lex_state = 226},
  [3776] = {.lex_state = 226, .external_lex_state = 13},
  [3777] = {.lex_state = 226, .external_lex_state = 13},
  [3778] = {.lex_state = 226, .external_lex_state = 13},
  [3779] = {.lex_state = 226, .external_lex_state = 13},
  [3780] = {.lex_state = 226, .external_lex_state = 13},
  [3781] = {.lex_state = 226, .external_lex_state = 13},
  [3782] = {.lex_state = 226, .external_lex_state = 13},
  [3783] = {.lex_state = 226, .external_lex_state = 13},
  [3784] = {.lex_state = 226, .external_lex_state = 13},
  [3785] = {.lex_state = 226, .external_lex_state = 13},
  [3786] = {.lex_state = 226, .external_lex_state = 13},
  [3787] = {.lex_state = 226, .external_lex_state = 13},
  [3788] = {.lex_state = 226, .external_lex_state = 13},
  [3789] = {.lex_state = 226, .external_lex_state = 13},
  [3790] = {.lex_state = 226, .external_lex_state = 13},
  [3791] = {.lex_state = 226, .external_lex_state = 13},
  [3792] = {.lex_state = 226, .external_lex_state = 13},
  [3793] = {.lex_state = 226, .external_lex_state = 13},
  [3794] = {.lex_state = 226, .external_lex_state = 13},
  [3795] = {.lex_state = 226, .external_lex_state = 13},
  [3796] = {.lex_state = 226, .external_lex_state = 13},
  [3797] = {.lex_state = 226, .external_lex_state = 13},
  [3798] = {.lex_state = 226, .external_lex_state = 13},
  [3799] = {.lex_state = 226, .external_lex_state = 13},
  [3800] = {.lex_state = 226},
  [3801] = {.lex_state = 226, .external_lex_state = 13},
  [3802] = {.lex_state = 226, .external_lex_state = 13},
  [3803] = {.lex_state = 226, .external_lex_state = 13},
  [3804] = {.lex_state = 226, .external_lex_state = 13},
  [3805] = {.lex_state = 226},
  [3806] = {.lex_state = 226, .external_lex_state = 13},
  [3807] = {.lex_state = 226, .external_lex_state = 13},
  [3808] = {.lex_state = 226, .external_lex_state = 13},
  [3809] = {.lex_state = 226, .external_lex_state = 13},
  [3810] = {.lex_state = 226},
  [3811] = {.lex_state = 226, .external_lex_state = 13},
  [3812] = {.lex_state = 226, .external_lex_state = 13},
  [3813] = {.lex_state = 226, .external_lex_state = 13},
  [3814] = {.lex_state = 226, .external_lex_state = 13},
  [3815] = {.lex_state = 226, .external_lex_state = 13},
  [3816] = {.lex_state = 226, .external_lex_state = 13},
  [3817] = {.lex_state = 226, .external_lex_state = 13},
  [3818] = {.lex_state = 226, .external_lex_state = 13},
  [3819] = {.lex_state = 226, .external_lex_state = 13},
  [3820] = {.lex_state = 226, .external_lex_state = 13},
  [3821] = {.lex_state = 226, .external_lex_state = 13},
  [3822] = {.lex_state = 226, .external_lex_state = 13},
  [3823] = {.lex_state = 226, .external_lex_state = 13},
  [3824] = {.lex_state = 226, .external_lex_state = 13},
  [3825] = {.lex_state = 226},
  [3826] = {.lex_state = 226},
  [3827] = {.lex_state = 226},
  [3828] = {.lex_state = 226},
  [3829] = {.lex_state = 226},
  [3830] = {.lex_state = 226},
  [3831] = {.lex_state = 226},
  [3832] = {.lex_state = 226},
  [3833] = {.lex_state = 226},
  [3834] = {.lex_state = 226},
  [3835] = {.lex_state = 226},
  [3836] = {.lex_state = 226},
  [3837] = {.lex_state = 226},
  [3838] = {.lex_state = 226},
  [3839] = {.lex_state = 226, .external_lex_state = 13},
  [3840] = {.lex_state = 226, .external_lex_state = 13},
  [3841] = {.lex_state = 226, .external_lex_state = 13},
  [3842] = {.lex_state = 226, .external_lex_state = 13},
  [3843] = {.lex_state = 226, .external_lex_state = 13},
  [3844] = {.lex_state = 226, .external_lex_state = 13},
  [3845] = {.lex_state = 226, .external_lex_state = 13},
  [3846] = {.lex_state = 226},
  [3847] = {.lex_state = 226},
  [3848] = {.lex_state = 226, .external_lex_state = 13},
  [3849] = {.lex_state = 226},
  [3850] = {.lex_state = 226},
  [3851] = {.lex_state = 226, .external_lex_state = 13},
  [3852] = {.lex_state = 226},
  [3853] = {.lex_state = 226},
  [3854] = {.lex_state = 226},
  [3855] = {.lex_state = 226},
  [3856] = {.lex_state = 226, .external_lex_state = 13},
  [3857] = {.lex_state = 226},
  [3858] = {.lex_state = 226},
  [3859] = {.lex_state = 226},
  [3860] = {.lex_state = 226},
  [3861] = {.lex_state = 226},
  [3862] = {.lex_state = 226, .external_lex_state = 13},
  [3863] = {.lex_state = 226},
  [3864] = {.lex_state = 226},
  [3865] = {.lex_state = 226},
  [3866] = {.lex_state = 226},
  [3867] = {.lex_state = 226},
  [3868] = {.lex_state = 226, .external_lex_state = 13},
  [3869] = {.lex_state = 226, .external_lex_state = 13},
  [3870] = {.lex_state = 226},
  [3871] = {.lex_state = 226},
  [3872] = {.lex_state = 226},
  [3873] = {.lex_state = 226},
  [3874] = {.lex_state = 226},
  [3875] = {.lex_state = 226},
  [3876] = {.lex_state = 226},
  [3877] = {.lex_state = 226},
  [3878] = {.lex_state = 226},
  [3879] = {.lex_state = 226},
  [3880] = {.lex_state = 226},
  [3881] = {.lex_state = 226},
  [3882] = {.lex_state = 226},
  [3883] = {.lex_state = 226},
  [3884] = {.lex_state = 226},
  [3885] = {.lex_state = 226},
  [3886] = {.lex_state = 226},
  [3887] = {.lex_state = 25},
  [3888] = {.lex_state = 26},
  [3889] = {.lex_state = 26},
  [3890] = {.lex_state = 26},
  [3891] = {.lex_state = 226},
  [3892] = {.lex_state = 226},
  [3893] = {.lex_state = 226},
  [3894] = {.lex_state = 226},
  [3895] = {.lex_state = 226},
  [3896] = {.lex_state = 226},
  [3897] = {.lex_state = 226},
  [3898] = {.lex_state = 226},
  [3899] = {.lex_state = 226},
  [3900] = {.lex_state = 226},
  [3901] = {.lex_state = 226},
  [3902] = {.lex_state = 226},
  [3903] = {.lex_state = 226},
  [3904] = {.lex_state = 226},
  [3905] = {.lex_state = 226},
  [3906] = {.lex_state = 226},
  [3907] = {.lex_state = 226},
  [3908] = {.lex_state = 226},
  [3909] = {.lex_state = 226},
  [3910] = {.lex_state = 226},
  [3911] = {.lex_state = 226},
  [3912] = {.lex_state = 226},
  [3913] = {.lex_state = 25},
  [3914] = {.lex_state = 226},
  [3915] = {.lex_state = 226},
  [3916] = {.lex_state = 226},
  [3917] = {.lex_state = 226},
  [3918] = {.lex_state = 226},
  [3919] = {.lex_state = 226},
  [3920] = {.lex_state = 226},
  [3921] = {.lex_state = 226},
  [3922] = {.lex_state = 226},
  [3923] = {.lex_state = 226},
  [3924] = {.lex_state = 226},
  [3925] = {.lex_state = 226},
  [3926] = {.lex_state = 226},
  [3927] = {.lex_state = 226},
  [3928] = {.lex_state = 226},
  [3929] = {.lex_state = 226},
  [3930] = {.lex_state = 226},
  [3931] = {.lex_state = 226},
  [3932] = {.lex_state = 226},
  [3933] = {.lex_state = 226},
  [3934] = {.lex_state = 226},
  [3935] = {.lex_state = 226},
  [3936] = {.lex_state = 226},
  [3937] = {.lex_state = 226, .external_lex_state = 14},
  [3938] = {.lex_state = 226},
  [3939] = {.lex_state = 226},
  [3940] = {.lex_state = 226},
  [3941] = {.lex_state = 226},
  [3942] = {.lex_state = 226, .external_lex_state = 14},
  [3943] = {.lex_state = 226},
  [3944] = {.lex_state = 226, .external_lex_state = 14},
  [3945] = {.lex_state = 26},
  [3946] = {.lex_state = 26},
  [3947] = {.lex_state = 26},
  [3948] = {.lex_state = 26},
  [3949] = {.lex_state = 226},
  [3950] = {.lex_state = 26},
  [3951] = {.lex_state = 26},
  [3952] = {.lex_state = 226},
  [3953] = {.lex_state = 26},
  [3954] = {.lex_state = 226},
  [3955] = {.lex_state = 226},
  [3956] = {.lex_state = 226},
  [3957] = {.lex_state = 26},
  [3958] = {.lex_state = 226},
  [3959] = {.lex_state = 26},
  [3960] = {.lex_state = 26},
  [3961] = {.lex_state = 226},
  [3962] = {.lex_state = 26},
  [3963] = {.lex_state = 26},
  [3964] = {.lex_state = 226},
  [3965] = {.lex_state = 26},
  [3966] = {.lex_state = 26},
  [3967] = {.lex_state = 226},
  [3968] = {.lex_state = 226},
  [3969] = {.lex_state = 226},
  [3970] = {.lex_state = 226},
  [3971] = {.lex_state = 226},
  [3972] = {.lex_state = 226},
  [3973] = {.lex_state = 226},
  [3974] = {.lex_state = 226},
  [3975] = {.lex_state = 226},
  [3976] = {.lex_state = 226},
  [3977] = {.lex_state = 26},
  [3978] = {.lex_state = 226},
  [3979] = {.lex_state = 226},
  [3980] = {.lex_state = 226},
  [3981] = {.lex_state = 226},
  [3982] = {.lex_state = 226},
  [3983] = {.lex_state = 226},
  [3984] = {.lex_state = 226},
  [3985] = {.lex_state = 26},
  [3986] = {.lex_state = 226},
  [3987] = {.lex_state = 226},
  [3988] = {.lex_state = 226},
  [3989] = {.lex_state = 226},
  [3990] = {.lex_state = 226},
  [3991] = {.lex_state = 226},
  [3992] = {.lex_state = 26},
  [3993] = {.lex_state = 226},
  [3994] = {.lex_state = 226},
  [3995] = {.lex_state = 226},
  [3996] = {.lex_state = 226},
  [3997] = {.lex_state = 226},
  [3998] = {.lex_state = 26},
  [3999] = {.lex_state = 226},
  [4000] = {.lex_state = 226},
  [4001] = {.lex_state = 226},
  [4002] = {.lex_state = 226},
  [4003] = {.lex_state = 226},
  [4004] = {.lex_state = 226},
  [4005] = {.lex_state = 226},
  [4006] = {.lex_state = 226},
  [4007] = {.lex_state = 226},
  [4008] = {.lex_state = 226},
  [4009] = {.lex_state = 26},
  [4010] = {.lex_state = 226},
  [4011] = {.lex_state = 26},
  [4012] = {.lex_state = 231},
  [4013] = {.lex_state = 226},
  [4014] = {.lex_state = 26},
  [4015] = {.lex_state = 226},
  [4016] = {.lex_state = 226},
  [4017] = {.lex_state = 226},
  [4018] = {.lex_state = 226},
  [4019] = {.lex_state = 226},
  [4020] = {.lex_state = 226},
  [4021] = {.lex_state = 226},
  [4022] = {.lex_state = 226, .external_lex_state = 13},
  [4023] = {.lex_state = 0},
  [4024] = {.lex_state = 226},
  [4025] = {.lex_state = 226},
  [4026] = {.lex_state = 226},
  [4027] = {.lex_state = 226},
  [4028] = {.lex_state = 226},
  [4029] = {.lex_state = 226},
  [4030] = {.lex_state = 226},
  [4031] = {.lex_state = 226},
  [4032] = {.lex_state = 226},
  [4033] = {.lex_state = 226},
  [4034] = {.lex_state = 226},
  [4035] = {.lex_state = 226},
  [4036] = {.lex_state = 226},
  [4037] = {.lex_state = 226},
  [4038] = {.lex_state = 226},
  [4039] = {.lex_state = 226},
  [4040] = {.lex_state = 226},
  [4041] = {.lex_state = 226},
  [4042] = {.lex_state = 226},
  [4043] = {.lex_state = 226},
  [4044] = {.lex_state = 226},
  [4045] = {.lex_state = 226},
  [4046] = {.lex_state = 226},
  [4047] = {.lex_state = 226},
  [4048] = {.lex_state = 226},
  [4049] = {.lex_state = 226},
  [4050] = {.lex_state = 226},
  [4051] = {.lex_state = 226},
  [4052] = {.lex_state = 226},
  [4053] = {.lex_state = 226},
  [4054] = {.lex_state = 226},
  [4055] = {.lex_state = 226},
  [4056] = {.lex_state = 226},
  [4057] = {.lex_state = 226},
  [4058] = {.lex_state = 226},
  [4059] = {.lex_state = 226},
  [4060] = {.lex_state = 226},
  [4061] = {.lex_state = 226},
  [4062] = {.lex_state = 226},
  [4063] = {.lex_state = 226},
  [4064] = {.lex_state = 226},
  [4065] = {.lex_state = 226},
  [4066] = {.lex_state = 226},
  [4067] = {.lex_state = 226},
  [4068] = {.lex_state = 231},
  [4069] = {.lex_state = 226},
  [4070] = {.lex_state = 226},
  [4071] = {.lex_state = 0},
  [4072] = {.lex_state = 226},
  [4073] = {.lex_state = 0},
  [4074] = {.lex_state = 226},
  [4075] = {.lex_state = 0},
  [4076] = {.lex_state = 226},
  [4077] = {.lex_state = 226},
  [4078] = {.lex_state = 226},
  [4079] = {.lex_state = 0},
  [4080] = {.lex_state = 226},
  [4081] = {.lex_state = 226},
  [4082] = {.lex_state = 0},
  [4083] = {.lex_state = 0},
  [4084] = {.lex_state = 226},
  [4085] = {.lex_state = 0},
  [4086] = {.lex_state = 0},
  [4087] = {.lex_state = 226},
  [4088] = {.lex_state = 226},
  [4089] = {.lex_state = 0},
  [4090] = {.lex_state = 0},
  [4091] = {.lex_state = 0},
  [4092] = {.lex_state = 226},
  [4093] = {.lex_state = 0},
  [4094] = {.lex_state = 25},
  [4095] = {.lex_state = 0},
  [4096] = {.lex_state = 226},
  [4097] = {.lex_state = 0},
  [4098] = {.lex_state = 0},
  [4099] = {.lex_state = 0},
  [4100] = {.lex_state = 0},
  [4101] = {.lex_state = 0},
  [4102] = {.lex_state = 226},
  [4103] = {.lex_state = 226},
  [4104] = {.lex_state = 0},
  [4105] = {.lex_state = 0},
  [4106] = {.lex_state = 0},
  [4107] = {.lex_state = 0},
  [4108] = {.lex_state = 25},
  [4109] = {.lex_state = 0},
  [4110] = {.lex_state = 0},
  [4111] = {.lex_state = 226},
  [4112] = {.lex_state = 226},
  [4113] = {.lex_state = 0},
  [4114] = {.lex_state = 0},
  [4115] = {.lex_state = 0},
  [4116] = {.lex_state = 0},
  [4117] = {.lex_state = 0},
  [4118] = {.lex_state = 0},
  [4119] = {.lex_state = 0},
  [4120] = {.lex_state = 226},
  [4121] = {.lex_state = 0},
  [4122] = {.lex_state = 226},
  [4123] = {.lex_state = 0},
  [4124] = {.lex_state = 0},
  [4125] = {.lex_state = 226},
  [4126] = {.lex_state = 226},
  [4127] = {.lex_state = 226},
  [4128] = {.lex_state = 226},
  [4129] = {.lex_state = 226},
  [4130] = {.lex_state = 226},
  [4131] = {.lex_state = 226},
  [4132] = {.lex_state = 226},
  [4133] = {.lex_state = 226},
  [4134] = {.lex_state = 0},
  [4135] = {.lex_state = 226},
  [4136] = {.lex_state = 226},
  [4137] = {.lex_state = 226},
  [4138] = {.lex_state = 226},
  [4139] = {.lex_state = 226, .external_lex_state = 13},
  [4140] = {.lex_state = 226},
  [4141] = {.lex_state = 226},
  [4142] = {.lex_state = 226},
  [4143] = {.lex_state = 226},
  [4144] = {.lex_state = 226},
  [4145] = {.lex_state = 226},
  [4146] = {.lex_state = 226},
  [4147] = {.lex_state = 226},
  [4148] = {.lex_state = 226},
  [4149] = {.lex_state = 0, .external_lex_state = 15},
  [4150] = {.lex_state = 0, .external_lex_state = 15},
  [4151] = {.lex_state = 226},
  [4152] = {.lex_state = 226},
  [4153] = {.lex_state = 226},
  [4154] = {.lex_state = 0, .external_lex_state = 15},
  [4155] = {.lex_state = 0, .external_lex_state = 15},
  [4156] = {.lex_state = 226},
  [4157] = {.lex_state = 231},
  [4158] = {.lex_state = 226},
  [4159] = {.lex_state = 226},
  [4160] = {.lex_state = 226},
  [4161] = {.lex_state = 226},
  [4162] = {.lex_state = 28},
  [4163] = {.lex_state = 226},
  [4164] = {.lex_state = 226},
  [4165] = {.lex_state = 226},
  [4166] = {.lex_state = 28, .external_lex_state = 13},
  [4167] = {.lex_state = 226},
  [4168] = {.lex_state = 226},
  [4169] = {.lex_state = 231, .external_lex_state = 13},
  [4170] = {.lex_state = 226},
  [4171] = {.lex_state = 226},
  [4172] = {.lex_state = 226},
  [4173] = {.lex_state = 226},
  [4174] = {.lex_state = 226},
  [4175] = {.lex_state = 0},
  [4176] = {.lex_state = 0, .external_lex_state = 15},
  [4177] = {.lex_state = 0, .external_lex_state = 15},
  [4178] = {.lex_state = 0, .external_lex_state = 15},
  [4179] = {.lex_state = 0},
  [4180] = {.lex_state = 226},
  [4181] = {.lex_state = 0, .external_lex_state = 15},
  [4182] = {.lex_state = 226, .external_lex_state = 13},
  [4183] = {.lex_state = 226},
  [4184] = {.lex_state = 226},
  [4185] = {.lex_state = 226},
  [4186] = {.lex_state = 226},
  [4187] = {.lex_state = 226},
  [4188] = {.lex_state = 226},
  [4189] = {.lex_state = 226},
  [4190] = {.lex_state = 226},
  [4191] = {.lex_state = 226},
  [4192] = {.lex_state = 226},
  [4193] = {.lex_state = 226},
  [4194] = {.lex_state = 226},
  [4195] = {.lex_state = 226, .external_lex_state = 13},
  [4196] = {.lex_state = 226},
  [4197] = {.lex_state = 226},
  [4198] = {.lex_state = 0, .external_lex_state = 15},
  [4199] = {.lex_state = 226, .external_lex_state = 13},
  [4200] = {.lex_state = 226},
  [4201] = {.lex_state = 226},
  [4202] = {.lex_state = 226},
  [4203] = {.lex_state = 226},
  [4204] = {.lex_state = 226},
  [4205] = {.lex_state = 0, .external_lex_state = 15},
  [4206] = {.lex_state = 0, .external_lex_state = 15},
  [4207] = {.lex_state = 226},
  [4208] = {.lex_state = 226},
  [4209] = {.lex_state = 226},
  [4210] = {.lex_state = 226},
  [4211] = {.lex_state = 226},
  [4212] = {.lex_state = 0},
  [4213] = {.lex_state = 226, .external_lex_state = 13},
  [4214] = {.lex_state = 0, .external_lex_state = 15},
  [4215] = {.lex_state = 226},
  [4216] = {.lex_state = 226},
  [4217] = {.lex_state = 226},
  [4218] = {.lex_state = 226},
  [4219] = {.lex_state = 0, .external_lex_state = 15},
  [4220] = {.lex_state = 0, .external_lex_state = 15},
  [4221] = {.lex_state = 226},
  [4222] = {.lex_state = 226},
  [4223] = {.lex_state = 0, .external_lex_state = 15},
  [4224] = {.lex_state = 226},
  [4225] = {.lex_state = 226},
  [4226] = {.lex_state = 226},
  [4227] = {.lex_state = 0},
  [4228] = {.lex_state = 226},
  [4229] = {.lex_state = 0},
  [4230] = {.lex_state = 28},
  [4231] = {.lex_state = 226},
  [4232] = {.lex_state = 226},
  [4233] = {.lex_state = 28},
  [4234] = {.lex_state = 226},
  [4235] = {.lex_state = 0},
  [4236] = {.lex_state = 226},
  [4237] = {.lex_state = 226},
  [4238] = {.lex_state = 0},
  [4239] = {.lex_state = 0, .external_lex_state = 15},
  [4240] = {.lex_state = 3},
  [4241] = {.lex_state = 3},
  [4242] = {.lex_state = 226, .external_lex_state = 13},
  [4243] = {.lex_state = 226},
  [4244] = {.lex_state = 0, .external_lex_state = 16},
  [4245] = {.lex_state = 226},
  [4246] = {.lex_state = 226},
  [4247] = {.lex_state = 226, .external_lex_state = 17},
  [4248] = {.lex_state = 3},
  [4249] = {.lex_state = 0, .external_lex_state = 13},
  [4250] = {.lex_state = 0, .external_lex_state = 13},
  [4251] = {.lex_state = 226},
  [4252] = {.lex_state = 226},
  [4253] = {.lex_state = 226},
  [4254] = {.lex_state = 226},
  [4255] = {.lex_state = 226, .external_lex_state = 17},
  [4256] = {.lex_state = 0},
  [4257] = {.lex_state = 226},
  [4258] = {.lex_state = 3},
  [4259] = {.lex_state = 226},
  [4260] = {.lex_state = 25},
  [4261] = {.lex_state = 226},
  [4262] = {.lex_state = 0},
  [4263] = {.lex_state = 0, .external_lex_state = 16},
  [4264] = {.lex_state = 25},
  [4265] = {.lex_state = 25},
  [4266] = {.lex_state = 0, .external_lex_state = 16},
  [4267] = {.lex_state = 0},
  [4268] = {.lex_state = 226},
  [4269] = {.lex_state = 25},
  [4270] = {.lex_state = 226},
  [4271] = {.lex_state = 226},
  [4272] = {.lex_state = 226},
  [4273] = {.lex_state = 0},
  [4274] = {.lex_state = 3},
  [4275] = {.lex_state = 226},
  [4276] = {.lex_state = 226},
  [4277] = {.lex_state = 0},
  [4278] = {.lex_state = 0, .external_lex_state = 13},
  [4279] = {.lex_state = 0, .external_lex_state = 13},
  [4280] = {.lex_state = 226},
  [4281] = {.lex_state = 0, .external_lex_state = 16},
  [4282] = {.lex_state = 0, .external_lex_state = 16},
  [4283] = {.lex_state = 0, .external_lex_state = 13},
  [4284] = {.lex_state = 226, .external_lex_state = 13},
  [4285] = {.lex_state = 3},
  [4286] = {.lex_state = 3},
  [4287] = {.lex_state = 0, .external_lex_state = 13},
  [4288] = {.lex_state = 3},
  [4289] = {.lex_state = 226},
  [4290] = {.lex_state = 226},
  [4291] = {.lex_state = 3},
  [4292] = {.lex_state = 226},
  [4293] = {.lex_state = 3},
  [4294] = {.lex_state = 226},
  [4295] = {.lex_state = 226},
  [4296] = {.lex_state = 226},
  [4297] = {.lex_state = 226},
  [4298] = {.lex_state = 0},
  [4299] = {.lex_state = 0},
  [4300] = {.lex_state = 226},
  [4301] = {.lex_state = 0},
  [4302] = {.lex_state = 25},
  [4303] = {.lex_state = 0, .external_lex_state = 13},
  [4304] = {.lex_state = 0},
  [4305] = {.lex_state = 0, .external_lex_state = 16},
  [4306] = {.lex_state = 226},
  [4307] = {.lex_state = 0, .external_lex_state = 16},
  [4308] = {.lex_state = 25},
  [4309] = {.lex_state = 226},
  [4310] = {.lex_state = 226},
  [4311] = {.lex_state = 0, .external_lex_state = 13},
  [4312] = {.lex_state = 0},
  [4313] = {.lex_state = 0, .external_lex_state = 16},
  [4314] = {.lex_state = 0, .external_lex_state = 13},
  [4315] = {.lex_state = 3},
  [4316] = {.lex_state = 226},
  [4317] = {.lex_state = 226, .external_lex_state = 17},
  [4318] = {.lex_state = 3},
  [4319] = {.lex_state = 231},
  [4320] = {.lex_state = 0, .external_lex_state = 16},
  [4321] = {.lex_state = 226},
  [4322] = {.lex_state = 0},
  [4323] = {.lex_state = 3},
  [4324] = {.lex_state = 0, .external_lex_state = 16},
  [4325] = {.lex_state = 226},
  [4326] = {.lex_state = 0, .external_lex_state = 16},
  [4327] = {.lex_state = 226},
  [4328] = {.lex_state = 0},
  [4329] = {.lex_state = 3},
  [4330] = {.lex_state = 0, .external_lex_state = 16},
  [4331] = {.lex_state = 0, .external_lex_state = 16},
  [4332] = {.lex_state = 226},
  [4333] = {.lex_state = 226},
  [4334] = {.lex_state = 226},
  [4335] = {.lex_state = 3},
  [4336] = {.lex_state = 0, .external_lex_state = 16},
  [4337] = {.lex_state = 231},
  [4338] = {.lex_state = 226},
  [4339] = {.lex_state = 226},
  [4340] = {.lex_state = 226},
  [4341] = {.lex_state = 3},
  [4342] = {.lex_state = 226},
  [4343] = {.lex_state = 3},
  [4344] = {.lex_state = 0},
  [4345] = {.lex_state = 25},
  [4346] = {.lex_state = 0},
  [4347] = {.lex_state = 3},
  [4348] = {.lex_state = 3},
  [4349] = {.lex_state = 0, .external_lex_state = 13},
  [4350] = {.lex_state = 0, .external_lex_state = 13},
  [4351] = {.lex_state = 25},
  [4352] = {.lex_state = 226},
  [4353] = {.lex_state = 0, .external_lex_state = 16},
  [4354] = {.lex_state = 25},
  [4355] = {.lex_state = 3},
  [4356] = {.lex_state = 0, .external_lex_state = 16},
  [4357] = {.lex_state = 0},
  [4358] = {.lex_state = 3},
  [4359] = {.lex_state = 226},
  [4360] = {.lex_state = 231},
  [4361] = {.lex_state = 0},
  [4362] = {.lex_state = 226},
  [4363] = {.lex_state = 226},
  [4364] = {.lex_state = 0, .external_lex_state = 16},
  [4365] = {.lex_state = 0},
  [4366] = {.lex_state = 0, .external_lex_state = 16},
  [4367] = {.lex_state = 0, .external_lex_state = 16},
  [4368] = {.lex_state = 3},
  [4369] = {.lex_state = 0, .external_lex_state = 16},
  [4370] = {.lex_state = 0, .external_lex_state = 16},
  [4371] = {.lex_state = 226},
  [4372] = {.lex_state = 0, .external_lex_state = 16},
  [4373] = {.lex_state = 0, .external_lex_state = 16},
  [4374] = {.lex_state = 226, .external_lex_state = 13},
  [4375] = {.lex_state = 226},
  [4376] = {.lex_state = 0, .external_lex_state = 16},
  [4377] = {.lex_state = 0, .external_lex_state = 16},
  [4378] = {.lex_state = 0},
  [4379] = {.lex_state = 226},
  [4380] = {.lex_state = 226},
  [4381] = {.lex_state = 226},
  [4382] = {.lex_state = 231},
  [4383] = {.lex_state = 0, .external_lex_state = 13},
  [4384] = {.lex_state = 3},
  [4385] = {.lex_state = 226},
  [4386] = {.lex_state = 3},
  [4387] = {.lex_state = 3},
  [4388] = {.lex_state = 3},
  [4389] = {.lex_state = 3},
  [4390] = {.lex_state = 0},
  [4391] = {.lex_state = 3},
  [4392] = {.lex_state = 226},
  [4393] = {.lex_state = 3},
  [4394] = {.lex_state = 3},
  [4395] = {.lex_state = 226},
  [4396] = {.lex_state = 0},
  [4397] = {.lex_state = 0, .external_lex_state = 16},
  [4398] = {.lex_state = 0, .external_lex_state = 16},
  [4399] = {.lex_state = 226, .external_lex_state = 13},
  [4400] = {.lex_state = 0, .external_lex_state = 16},
  [4401] = {.lex_state = 226},
  [4402] = {.lex_state = 3},
  [4403] = {.lex_state = 226},
  [4404] = {.lex_state = 0, .external_lex_state = 16},
  [4405] = {.lex_state = 0, .external_lex_state = 16},
  [4406] = {.lex_state = 231},
  [4407] = {.lex_state = 0, .external_lex_state = 16},
  [4408] = {.lex_state = 3},
  [4409] = {.lex_state = 226},
  [4410] = {.lex_state = 226, .external_lex_state = 13},
  [4411] = {.lex_state = 226, .external_lex_state = 13},
  [4412] = {.lex_state = 226},
  [4413] = {.lex_state = 226},
  [4414] = {.lex_state = 226},
  [4415] = {.lex_state = 226},
  [4416] = {.lex_state = 3},
  [4417] = {.lex_state = 226},
  [4418] = {.lex_state = 0, .external_lex_state = 16},
  [4419] = {.lex_state = 0, .external_lex_state = 16},
  [4420] = {.lex_state = 0, .external_lex_state = 16},
  [4421] = {.lex_state = 0},
  [4422] = {.lex_state = 226},
  [4423] = {.lex_state = 28},
  [4424] = {.lex_state = 226},
  [4425] = {.lex_state = 12},
  [4426] = {.lex_state = 0},
  [4427] = {.lex_state = 0},
  [4428] = {.lex_state = 226},
  [4429] = {.lex_state = 226},
  [4430] = {.lex_state = 226},
  [4431] = {.lex_state = 226},
  [4432] = {.lex_state = 0},
  [4433] = {.lex_state = 226},
  [4434] = {.lex_state = 226},
  [4435] = {.lex_state = 226},
  [4436] = {.lex_state = 226},
  [4437] = {.lex_state = 226},
  [4438] = {.lex_state = 23},
  [4439] = {.lex_state = 226},
  [4440] = {.lex_state = 226},
  [4441] = {.lex_state = 0},
  [4442] = {.lex_state = 0},
  [4443] = {.lex_state = 0},
  [4444] = {.lex_state = 226},
  [4445] = {.lex_state = 226},
  [4446] = {.lex_state = 0},
  [4447] = {.lex_state = 23},
  [4448] = {.lex_state = 0},
  [4449] = {.lex_state = 0},
  [4450] = {.lex_state = 0},
  [4451] = {.lex_state = 0},
  [4452] = {.lex_state = 0},
  [4453] = {.lex_state = 28},
  [4454] = {.lex_state = 226},
  [4455] = {.lex_state = 12},
  [4456] = {.lex_state = 226},
  [4457] = {.lex_state = 23},
  [4458] = {.lex_state = 0},
  [4459] = {.lex_state = 0},
  [4460] = {.lex_state = 226},
  [4461] = {.lex_state = 226},
  [4462] = {.lex_state = 226},
  [4463] = {.lex_state = 226},
  [4464] = {.lex_state = 0},
  [4465] = {.lex_state = 0},
  [4466] = {.lex_state = 226},
  [4467] = {.lex_state = 226},
  [4468] = {.lex_state = 23},
  [4469] = {.lex_state = 226},
  [4470] = {.lex_state = 0},
  [4471] = {.lex_state = 0},
  [4472] = {.lex_state = 226},
  [4473] = {.lex_state = 0},
  [4474] = {.lex_state = 23},
  [4475] = {.lex_state = 0},
  [4476] = {.lex_state = 0},
  [4477] = {.lex_state = 0},
  [4478] = {.lex_state = 0},
  [4479] = {.lex_state = 28},
  [4480] = {.lex_state = 226},
  [4481] = {.lex_state = 226},
  [4482] = {.lex_state = 226},
  [4483] = {.lex_state = 226},
  [4484] = {.lex_state = 226},
  [4485] = {.lex_state = 0},
  [4486] = {.lex_state = 226},
  [4487] = {.lex_state = 226},
  [4488] = {.lex_state = 23},
  [4489] = {.lex_state = 226},
  [4490] = {.lex_state = 0},
  [4491] = {.lex_state = 0},
  [4492] = {.lex_state = 226},
  [4493] = {.lex_state = 226},
  [4494] = {.lex_state = 0},
  [4495] = {.lex_state = 23},
  [4496] = {.lex_state = 0},
  [4497] = {.lex_state = 0},
  [4498] = {.lex_state = 0},
  [4499] = {.lex_state = 0},
  [4500] = {.lex_state = 28},
  [4501] = {.lex_state = 226},
  [4502] = {.lex_state = 226},
  [4503] = {.lex_state = 226},
  [4504] = {.lex_state = 226},
  [4505] = {.lex_state = 226},
  [4506] = {.lex_state = 0},
  [4507] = {.lex_state = 12},
  [4508] = {.lex_state = 226},
  [4509] = {.lex_state = 226},
  [4510] = {.lex_state = 23},
  [4511] = {.lex_state = 226},
  [4512] = {.lex_state = 0},
  [4513] = {.lex_state = 0},
  [4514] = {.lex_state = 226},
  [4515] = {.lex_state = 0},
  [4516] = {.lex_state = 23},
  [4517] = {.lex_state = 0},
  [4518] = {.lex_state = 0},
  [4519] = {.lex_state = 0},
  [4520] = {.lex_state = 0},
  [4521] = {.lex_state = 28},
  [4522] = {.lex_state = 28},
  [4523] = {.lex_state = 226},
  [4524] = {.lex_state = 0, .external_lex_state = 13},
  [4525] = {.lex_state = 0, .external_lex_state = 13},
  [4526] = {.lex_state = 12},
  [4527] = {.lex_state = 226},
  [4528] = {.lex_state = 226},
  [4529] = {.lex_state = 226},
  [4530] = {.lex_state = 0},
  [4531] = {.lex_state = 226},
  [4532] = {.lex_state = 226},
  [4533] = {.lex_state = 23},
  [4534] = {.lex_state = 226},
  [4535] = {.lex_state = 0},
  [4536] = {.lex_state = 0},
  [4537] = {.lex_state = 226},
  [4538] = {.lex_state = 12},
  [4539] = {.lex_state = 12},
  [4540] = {.lex_state = 226},
  [4541] = {.lex_state = 0},
  [4542] = {.lex_state = 23},
  [4543] = {.lex_state = 0},
  [4544] = {.lex_state = 0},
  [4545] = {.lex_state = 0},
  [4546] = {.lex_state = 231},
  [4547] = {.lex_state = 0},
  [4548] = {.lex_state = 226},
  [4549] = {.lex_state = 23},
  [4550] = {.lex_state = 0},
  [4551] = {.lex_state = 0},
  [4552] = {.lex_state = 226},
  [4553] = {.lex_state = 0},
  [4554] = {.lex_state = 226},
  [4555] = {.lex_state = 0},
  [4556] = {.lex_state = 226},
  [4557] = {.lex_state = 0},
  [4558] = {.lex_state = 0},
  [4559] = {.lex_state = 226},
  [4560] = {.lex_state = 226},
  [4561] = {.lex_state = 0},
  [4562] = {.lex_state = 0},
  [4563] = {.lex_state = 0},
  [4564] = {.lex_state = 0},
  [4565] = {.lex_state = 0},
  [4566] = {.lex_state = 226},
  [4567] = {.lex_state = 12},
  [4568] = {.lex_state = 12},
  [4569] = {.lex_state = 12},
  [4570] = {.lex_state = 226},
  [4571] = {.lex_state = 226},
  [4572] = {.lex_state = 226},
  [4573] = {.lex_state = 0},
  [4574] = {.lex_state = 226},
  [4575] = {.lex_state = 0, .external_lex_state = 13},
  [4576] = {.lex_state = 0},
  [4577] = {.lex_state = 12},
  [4578] = {.lex_state = 226},
  [4579] = {.lex_state = 226},
  [4580] = {.lex_state = 226},
  [4581] = {.lex_state = 226},
  [4582] = {.lex_state = 226},
  [4583] = {.lex_state = 226},
  [4584] = {.lex_state = 0},
  [4585] = {.lex_state = 226},
  [4586] = {.lex_state = 226},
  [4587] = {.lex_state = 226},
  [4588] = {.lex_state = 12},
  [4589] = {.lex_state = 226},
  [4590] = {.lex_state = 12},
  [4591] = {.lex_state = 12},
  [4592] = {.lex_state = 226},
  [4593] = {.lex_state = 226},
  [4594] = {.lex_state = 23},
  [4595] = {.lex_state = 226},
  [4596] = {.lex_state = 0},
  [4597] = {.lex_state = 0},
  [4598] = {.lex_state = 0},
  [4599] = {.lex_state = 226},
  [4600] = {.lex_state = 226},
  [4601] = {.lex_state = 0},
  [4602] = {.lex_state = 0},
  [4603] = {.lex_state = 226},
  [4604] = {.lex_state = 226},
  [4605] = {.lex_state = 12},
  [4606] = {.lex_state = 23},
  [4607] = {.lex_state = 0},
  [4608] = {.lex_state = 0},
  [4609] = {.lex_state = 0},
  [4610] = {.lex_state = 226},
  [4611] = {.lex_state = 226},
  [4612] = {.lex_state = 226},
  [4613] = {.lex_state = 0},
  [4614] = {.lex_state = 0},
  [4615] = {.lex_state = 226},
  [4616] = {.lex_state = 25},
  [4617] = {.lex_state = 3},
  [4618] = {.lex_state = 28},
  [4619] = {.lex_state = 226},
  [4620] = {.lex_state = 226},
  [4621] = {.lex_state = 226},
  [4622] = {.lex_state = 12},
  [4623] = {.lex_state = 12},
  [4624] = {.lex_state = 226},
  [4625] = {.lex_state = 0},
  [4626] = {.lex_state = 226},
  [4627] = {.lex_state = 226},
  [4628] = {.lex_state = 226},
  [4629] = {.lex_state = 226},
  [4630] = {.lex_state = 0},
  [4631] = {.lex_state = 226},
  [4632] = {.lex_state = 226},
  [4633] = {.lex_state = 226},
  [4634] = {.lex_state = 226},
  [4635] = {.lex_state = 226},
  [4636] = {.lex_state = 226},
  [4637] = {.lex_state = 0},
  [4638] = {.lex_state = 226},
  [4639] = {.lex_state = 226},
  [4640] = {.lex_state = 226},
  [4641] = {.lex_state = 0},
  [4642] = {.lex_state = 226},
  [4643] = {.lex_state = 226},
  [4644] = {.lex_state = 0},
  [4645] = {.lex_state = 226},
  [4646] = {.lex_state = 226},
  [4647] = {.lex_state = 0},
  [4648] = {.lex_state = 0},
  [4649] = {.lex_state = 0, .external_lex_state = 13},
  [4650] = {.lex_state = 226},
  [4651] = {.lex_state = 226},
  [4652] = {.lex_state = 226},
  [4653] = {.lex_state = 226},
  [4654] = {.lex_state = 226},
  [4655] = {.lex_state = 23},
  [4656] = {.lex_state = 226},
  [4657] = {.lex_state = 0},
  [4658] = {.lex_state = 12},
  [4659] = {.lex_state = 226},
  [4660] = {.lex_state = 226},
  [4661] = {.lex_state = 0},
  [4662] = {.lex_state = 12},
  [4663] = {.lex_state = 226},
  [4664] = {.lex_state = 0},
  [4665] = {.lex_state = 226},
  [4666] = {.lex_state = 226},
  [4667] = {.lex_state = 28},
  [4668] = {.lex_state = 0},
  [4669] = {.lex_state = 12},
  [4670] = {.lex_state = 226},
  [4671] = {.lex_state = 23},
  [4672] = {.lex_state = 0},
  [4673] = {.lex_state = 0},
  [4674] = {.lex_state = 226},
  [4675] = {.lex_state = 0},
  [4676] = {.lex_state = 0},
  [4677] = {.lex_state = 226},
  [4678] = {.lex_state = 226},
  [4679] = {.lex_state = 0, .external_lex_state = 12},
  [4680] = {.lex_state = 226},
  [4681] = {.lex_state = 23},
  [4682] = {.lex_state = 226},
  [4683] = {.lex_state = 28},
  [4684] = {.lex_state = 226},
  [4685] = {.lex_state = 25},
  [4686] = {.lex_state = 12},
  [4687] = {.lex_state = 0},
  [4688] = {.lex_state = 12},
  [4689] = {.lex_state = 226},
  [4690] = {.lex_state = 0, .external_lex_state = 13},
  [4691] = {.lex_state = 226},
  [4692] = {.lex_state = 226},
  [4693] = {.lex_state = 231},
  [4694] = {.lex_state = 12},
  [4695] = {.lex_state = 226},
  [4696] = {.lex_state = 0},
  [4697] = {.lex_state = 226},
  [4698] = {.lex_state = 226},
  [4699] = {.lex_state = 0, .external_lex_state = 13},
  [4700] = {.lex_state = 231},
  [4701] = {.lex_state = 231},
  [4702] = {.lex_state = 0},
  [4703] = {.lex_state = 0, .external_lex_state = 13},
  [4704] = {.lex_state = 226},
  [4705] = {.lex_state = 226},
  [4706] = {.lex_state = 226},
  [4707] = {.lex_state = 226},
  [4708] = {.lex_state = 12},
  [4709] = {.lex_state = 226},
  [4710] = {.lex_state = 23},
  [4711] = {.lex_state = 226},
  [4712] = {.lex_state = 0, .external_lex_state = 13},
  [4713] = {.lex_state = 226},
  [4714] = {.lex_state = 226},
  [4715] = {.lex_state = 0},
  [4716] = {.lex_state = 226},
  [4717] = {.lex_state = 226},
  [4718] = {.lex_state = 0},
  [4719] = {.lex_state = 0},
  [4720] = {.lex_state = 0},
  [4721] = {.lex_state = 12},
  [4722] = {.lex_state = 226},
  [4723] = {.lex_state = 226},
  [4724] = {.lex_state = 12},
  [4725] = {.lex_state = 226},
  [4726] = {.lex_state = 226},
  [4727] = {.lex_state = 0},
  [4728] = {.lex_state = 226},
  [4729] = {.lex_state = 23},
  [4730] = {.lex_state = 0},
  [4731] = {.lex_state = 0},
  [4732] = {.lex_state = 0},
  [4733] = {.lex_state = 226},
  [4734] = {.lex_state = 0},
  [4735] = {.lex_state = 226},
  [4736] = {.lex_state = 226},
  [4737] = {.lex_state = 226},
  [4738] = {.lex_state = 28},
  [4739] = {.lex_state = 226},
  [4740] = {.lex_state = 0},
  [4741] = {.lex_state = 0, .external_lex_state = 13},
  [4742] = {.lex_state = 226},
  [4743] = {.lex_state = 226},
  [4744] = {.lex_state = 226},
  [4745] = {.lex_state = 226},
  [4746] = {.lex_state = 226},
  [4747] = {.lex_state = 226},
  [4748] = {.lex_state = 226},
  [4749] = {.lex_state = 226},
  [4750] = {.lex_state = 226},
  [4751] = {.lex_state = 12},
  [4752] = {.lex_state = 12},
  [4753] = {.lex_state = 12},
  [4754] = {.lex_state = 226},
  [4755] = {.lex_state = 226},
  [4756] = {.lex_state = 226},
  [4757] = {.lex_state = 0},
  [4758] = {.lex_state = 12},
  [4759] = {.lex_state = 0},
  [4760] = {.lex_state = 226},
  [4761] = {.lex_state = 226},
  [4762] = {.lex_state = 23},
  [4763] = {.lex_state = 0},
  [4764] = {.lex_state = 226},
  [4765] = {.lex_state = 226},
  [4766] = {.lex_state = 23},
  [4767] = {.lex_state = 226},
  [4768] = {.lex_state = 226},
  [4769] = {.lex_state = 0},
  [4770] = {.lex_state = 0},
  [4771] = {.lex_state = 0},
  [4772] = {.lex_state = 0},
  [4773] = {.lex_state = 226},
  [4774] = {.lex_state = 0},
  [4775] = {.lex_state = 226},
  [4776] = {.lex_state = 226},
  [4777] = {.lex_state = 0},
  [4778] = {.lex_state = 23},
  [4779] = {.lex_state = 226},
  [4780] = {.lex_state = 0},
  [4781] = {.lex_state = 226},
  [4782] = {.lex_state = 0},
  [4783] = {.lex_state = 0},
  [4784] = {.lex_state = 0},
  [4785] = {.lex_state = 226},
  [4786] = {.lex_state = 28},
  [4787] = {.lex_state = 0},
  [4788] = {.lex_state = 226},
  [4789] = {.lex_state = 226},
  [4790] = {.lex_state = 12},
  [4791] = {.lex_state = 23},
  [4792] = {.lex_state = 226},
  [4793] = {.lex_state = 0},
  [4794] = {.lex_state = 226},
  [4795] = {.lex_state = 0},
  [4796] = {.lex_state = 0},
  [4797] = {.lex_state = 226},
  [4798] = {.lex_state = 0},
  [4799] = {.lex_state = 226},
  [4800] = {.lex_state = 0, .external_lex_state = 13},
  [4801] = {.lex_state = 226},
  [4802] = {.lex_state = 226},
  [4803] = {.lex_state = 226},
  [4804] = {.lex_state = 226},
  [4805] = {.lex_state = 0},
  [4806] = {.lex_state = 226},
  [4807] = {.lex_state = 226},
  [4808] = {.lex_state = 226},
  [4809] = {.lex_state = 23},
  [4810] = {.lex_state = 226},
  [4811] = {.lex_state = 0},
  [4812] = {.lex_state = 231},
  [4813] = {.lex_state = 226},
  [4814] = {.lex_state = 0},
  [4815] = {.lex_state = 25},
  [4816] = {.lex_state = 226},
  [4817] = {.lex_state = 0},
  [4818] = {.lex_state = 12},
  [4819] = {.lex_state = 226},
  [4820] = {.lex_state = 0},
  [4821] = {.lex_state = 23},
  [4822] = {.lex_state = 0},
  [4823] = {.lex_state = 0},
  [4824] = {.lex_state = 0},
  [4825] = {.lex_state = 0},
  [4826] = {.lex_state = 28},
  [4827] = {.lex_state = 28},
  [4828] = {.lex_state = 0},
  [4829] = {.lex_state = 12},
  [4830] = {.lex_state = 12},
  [4831] = {.lex_state = 12},
  [4832] = {.lex_state = 226},
  [4833] = {.lex_state = 12},
  [4834] = {.lex_state = 12},
  [4835] = {.lex_state = 226},
  [4836] = {.lex_state = 12},
  [4837] = {.lex_state = 226},
  [4838] = {.lex_state = 231},
  [4839] = {.lex_state = 226},
  [4840] = {.lex_state = 226},
  [4841] = {.lex_state = 0},
  [4842] = {.lex_state = 226},
  [4843] = {.lex_state = 226},
  [4844] = {.lex_state = 231},
  [4845] = {.lex_state = 226},
  [4846] = {.lex_state = 226},
  [4847] = {.lex_state = 0, .external_lex_state = 13},
  [4848] = {.lex_state = 226},
  [4849] = {.lex_state = 231},
  [4850] = {.lex_state = 226},
  [4851] = {.lex_state = 0},
  [4852] = {.lex_state = 23},
  [4853] = {.lex_state = 226},
  [4854] = {.lex_state = 231},
  [4855] = {.lex_state = 226},
  [4856] = {.lex_state = 0},
  [4857] = {.lex_state = 23},
  [4858] = {.lex_state = 226},
  [4859] = {.lex_state = 23},
  [4860] = {.lex_state = 231},
  [4861] = {.lex_state = 0},
  [4862] = {.lex_state = 12},
  [4863] = {.lex_state = 226},
  [4864] = {.lex_state = 231},
  [4865] = {.lex_state = 226},
  [4866] = {.lex_state = 226},
  [4867] = {.lex_state = 0},
  [4868] = {.lex_state = 231},
  [4869] = {.lex_state = 226},
  [4870] = {.lex_state = 0},
  [4871] = {.lex_state = 0},
  [4872] = {.lex_state = 23},
  [4873] = {.lex_state = 231},
  [4874] = {.lex_state = 0},
  [4875] = {.lex_state = 25},
  [4876] = {.lex_state = 0},
  [4877] = {.lex_state = 0},
  [4878] = {.lex_state = 0},
  [4879] = {.lex_state = 12},
  [4880] = {.lex_state = 0},
  [4881] = {.lex_state = 231},
  [4882] = {.lex_state = 28},
  [4883] = {.lex_state = 12},
  [4884] = {.lex_state = 0},
  [4885] = {.lex_state = 12},
  [4886] = {.lex_state = 0},
  [4887] = {.lex_state = 226},
  [4888] = {.lex_state = 226},
  [4889] = {.lex_state = 231},
  [4890] = {.lex_state = 226},
  [4891] = {.lex_state = 0, .external_lex_state = 13},
  [4892] = {.lex_state = 226},
  [4893] = {.lex_state = 231},
  [4894] = {.lex_state = 226},
  [4895] = {.lex_state = 0},
  [4896] = {.lex_state = 226},
  [4897] = {.lex_state = 231},
  [4898] = {.lex_state = 226},
  [4899] = {.lex_state = 226},
  [4900] = {.lex_state = 226},
  [4901] = {.lex_state = 226},
  [4902] = {.lex_state = 226},
  [4903] = {.lex_state = 0},
  [4904] = {.lex_state = 0},
  [4905] = {.lex_state = 226},
  [4906] = {.lex_state = 226},
  [4907] = {.lex_state = 226},
  [4908] = {.lex_state = 226},
  [4909] = {.lex_state = 226},
  [4910] = {.lex_state = 226},
  [4911] = {.lex_state = 23},
  [4912] = {.lex_state = 226},
  [4913] = {.lex_state = 0},
  [4914] = {.lex_state = 0},
  [4915] = {.lex_state = 226},
  [4916] = {.lex_state = 0},
  [4917] = {.lex_state = 12},
  [4918] = {.lex_state = 0},
  [4919] = {.lex_state = 226},
  [4920] = {.lex_state = 0},
  [4921] = {.lex_state = 226},
  [4922] = {.lex_state = 226},
  [4923] = {.lex_state = 0},
  [4924] = {.lex_state = 23},
  [4925] = {.lex_state = 0},
  [4926] = {.lex_state = 0},
  [4927] = {.lex_state = 0},
  [4928] = {.lex_state = 12},
  [4929] = {.lex_state = 0},
  [4930] = {.lex_state = 226},
  [4931] = {.lex_state = 226},
  [4932] = {.lex_state = 12},
  [4933] = {.lex_state = 226},
  [4934] = {.lex_state = 0},
  [4935] = {.lex_state = 28},
  [4936] = {.lex_state = 12},
  [4937] = {.lex_state = 226},
  [4938] = {.lex_state = 0},
  [4939] = {.lex_state = 23},
  [4940] = {.lex_state = 226},
  [4941] = {.lex_state = 226},
  [4942] = {.lex_state = 0},
  [4943] = {.lex_state = 226},
  [4944] = {.lex_state = 226},
  [4945] = {.lex_state = 226},
  [4946] = {.lex_state = 0},
  [4947] = {.lex_state = 226},
  [4948] = {.lex_state = 0},
  [4949] = {.lex_state = 226},
  [4950] = {.lex_state = 25},
  [4951] = {.lex_state = 0},
  [4952] = {.lex_state = 226},
  [4953] = {.lex_state = 226},
  [4954] = {.lex_state = 226},
  [4955] = {.lex_state = 0},
  [4956] = {.lex_state = 0},
  [4957] = {.lex_state = 25},
  [4958] = {.lex_state = 226},
  [4959] = {.lex_state = 226},
  [4960] = {.lex_state = 226},
  [4961] = {.lex_state = 226},
  [4962] = {.lex_state = 0},
  [4963] = {.lex_state = 0},
  [4964] = {.lex_state = 0},
  [4965] = {.lex_state = 226},
  [4966] = {.lex_state = 226, .external_lex_state = 13},
  [4967] = {.lex_state = 0, .external_lex_state = 16},
  [4968] = {.lex_state = 0},
  [4969] = {.lex_state = 0},
  [4970] = {.lex_state = 0},
  [4971] = {.lex_state = 226},
  [4972] = {.lex_state = 226},
  [4973] = {.lex_state = 226},
  [4974] = {.lex_state = 226},
  [4975] = {.lex_state = 226},
  [4976] = {.lex_state = 226},
  [4977] = {.lex_state = 226},
  [4978] = {.lex_state = 226},
  [4979] = {.lex_state = 0},
  [4980] = {.lex_state = 0},
  [4981] = {.lex_state = 0},
  [4982] = {.lex_state = 226},
  [4983] = {.lex_state = 226},
  [4984] = {.lex_state = 226},
  [4985] = {.lex_state = 0},
  [4986] = {.lex_state = 0},
  [4987] = {.lex_state = 0},
  [4988] = {.lex_state = 25},
  [4989] = {.lex_state = 226},
  [4990] = {.lex_state = 226},
  [4991] = {.lex_state = 226},
  [4992] = {.lex_state = 0},
  [4993] = {.lex_state = 226},
  [4994] = {.lex_state = 226},
  [4995] = {.lex_state = 0},
  [4996] = {.lex_state = 226},
  [4997] = {.lex_state = 226},
  [4998] = {.lex_state = 226},
  [4999] = {.lex_state = 226},
  [5000] = {.lex_state = 0},
  [5001] = {.lex_state = 0},
  [5002] = {.lex_state = 226},
  [5003] = {.lex_state = 0},
  [5004] = {.lex_state = 226},
  [5005] = {.lex_state = 0},
  [5006] = {.lex_state = 226},
  [5007] = {.lex_state = 0},
  [5008] = {.lex_state = 0},
  [5009] = {.lex_state = 226},
  [5010] = {.lex_state = 226},
  [5011] = {.lex_state = 0},
  [5012] = {.lex_state = 0},
  [5013] = {.lex_state = 226},
  [5014] = {.lex_state = 226},
  [5015] = {.lex_state = 226},
  [5016] = {.lex_state = 0},
  [5017] = {.lex_state = 226},
  [5018] = {.lex_state = 226},
  [5019] = {.lex_state = 226},
  [5020] = {.lex_state = 0, .external_lex_state = 13},
  [5021] = {.lex_state = 226},
  [5022] = {.lex_state = 226},
  [5023] = {.lex_state = 25},
  [5024] = {.lex_state = 226},
  [5025] = {.lex_state = 0},
  [5026] = {.lex_state = 226},
  [5027] = {.lex_state = 226},
  [5028] = {.lex_state = 0},
  [5029] = {.lex_state = 0, .external_lex_state = 16},
  [5030] = {.lex_state = 226},
  [5031] = {.lex_state = 0},
  [5032] = {.lex_state = 226},
  [5033] = {.lex_state = 226},
  [5034] = {.lex_state = 0},
  [5035] = {.lex_state = 226},
  [5036] = {.lex_state = 226},
  [5037] = {.lex_state = 0},
  [5038] = {.lex_state = 226},
  [5039] = {.lex_state = 0},
  [5040] = {.lex_state = 226},
  [5041] = {.lex_state = 226},
  [5042] = {.lex_state = 226},
  [5043] = {.lex_state = 226},
  [5044] = {.lex_state = 226},
  [5045] = {.lex_state = 226},
  [5046] = {.lex_state = 226},
  [5047] = {.lex_state = 226},
  [5048] = {.lex_state = 226},
  [5049] = {.lex_state = 226},
  [5050] = {.lex_state = 226},
  [5051] = {.lex_state = 226},
  [5052] = {.lex_state = 226},
  [5053] = {.lex_state = 226},
  [5054] = {.lex_state = 226},
  [5055] = {.lex_state = 226},
  [5056] = {.lex_state = 226},
  [5057] = {.lex_state = 226},
  [5058] = {.lex_state = 226},
  [5059] = {.lex_state = 0, .external_lex_state = 13},
  [5060] = {.lex_state = 231},
  [5061] = {.lex_state = 14},
  [5062] = {.lex_state = 0},
  [5063] = {.lex_state = 31},
  [5064] = {.lex_state = 226},
  [5065] = {.lex_state = 226},
  [5066] = {.lex_state = 231},
  [5067] = {.lex_state = 14},
  [5068] = {.lex_state = 226},
  [5069] = {.lex_state = 14},
  [5070] = {.lex_state = 539},
  [5071] = {.lex_state = 14},
  [5072] = {.lex_state = 0},
  [5073] = {.lex_state = 0, .external_lex_state = 18},
  [5074] = {.lex_state = 226},
  [5075] = {.lex_state = 0},
  [5076] = {.lex_state = 226},
  [5077] = {.lex_state = 14},
  [5078] = {.lex_state = 226},
  [5079] = {.lex_state = 539},
  [5080] = {.lex_state = 0},
  [5081] = {.lex_state = 14},
  [5082] = {.lex_state = 14},
  [5083] = {.lex_state = 226},
  [5084] = {.lex_state = 17},
  [5085] = {.lex_state = 19},
  [5086] = {.lex_state = 226},
  [5087] = {.lex_state = 0},
  [5088] = {.lex_state = 226},
  [5089] = {.lex_state = 226},
  [5090] = {.lex_state = 541},
  [5091] = {.lex_state = 29},
  [5092] = {.lex_state = 0, .external_lex_state = 19},
  [5093] = {.lex_state = 231},
  [5094] = {.lex_state = 31},
  [5095] = {.lex_state = 0},
  [5096] = {.lex_state = 14},
  [5097] = {.lex_state = 14},
  [5098] = {.lex_state = 0, .external_lex_state = 18},
  [5099] = {.lex_state = 226},
  [5100] = {.lex_state = 226},
  [5101] = {.lex_state = 226},
  [5102] = {.lex_state = 226},
  [5103] = {.lex_state = 14},
  [5104] = {.lex_state = 0, .external_lex_state = 18},
  [5105] = {.lex_state = 251},
  [5106] = {.lex_state = 0, .external_lex_state = 18},
  [5107] = {.lex_state = 226},
  [5108] = {.lex_state = 14},
  [5109] = {.lex_state = 14},
  [5110] = {.lex_state = 14},
  [5111] = {.lex_state = 14},
  [5112] = {.lex_state = 14},
  [5113] = {.lex_state = 226},
  [5114] = {.lex_state = 226},
  [5115] = {.lex_state = 14},
  [5116] = {.lex_state = 226},
  [5117] = {.lex_state = 226},
  [5118] = {.lex_state = 14},
  [5119] = {.lex_state = 0, .external_lex_state = 13},
  [5120] = {.lex_state = 231},
  [5121] = {.lex_state = 0, .external_lex_state = 13},
  [5122] = {.lex_state = 226},
  [5123] = {.lex_state = 226},
  [5124] = {.lex_state = 226},
  [5125] = {.lex_state = 14},
  [5126] = {.lex_state = 226},
  [5127] = {.lex_state = 31},
  [5128] = {.lex_state = 31},
  [5129] = {.lex_state = 17},
  [5130] = {.lex_state = 19},
  [5131] = {.lex_state = 226},
  [5132] = {.lex_state = 226},
  [5133] = {.lex_state = 0},
  [5134] = {.lex_state = 14},
  [5135] = {.lex_state = 14},
  [5136] = {.lex_state = 226},
  [5137] = {.lex_state = 14},
  [5138] = {.lex_state = 226},
  [5139] = {.lex_state = 226},
  [5140] = {.lex_state = 226},
  [5141] = {.lex_state = 226},
  [5142] = {.lex_state = 14},
  [5143] = {.lex_state = 226},
  [5144] = {.lex_state = 0},
  [5145] = {.lex_state = 226},
  [5146] = {.lex_state = 0},
  [5147] = {.lex_state = 231},
  [5148] = {.lex_state = 14},
  [5149] = {.lex_state = 226},
  [5150] = {.lex_state = 31},
  [5151] = {.lex_state = 0, .external_lex_state = 18},
  [5152] = {.lex_state = 226},
  [5153] = {.lex_state = 0, .external_lex_state = 18},
  [5154] = {.lex_state = 226},
  [5155] = {.lex_state = 0, .external_lex_state = 13},
  [5156] = {.lex_state = 14},
  [5157] = {.lex_state = 17},
  [5158] = {.lex_state = 226},
  [5159] = {.lex_state = 226},
  [5160] = {.lex_state = 226},
  [5161] = {.lex_state = 19},
  [5162] = {.lex_state = 14},
  [5163] = {.lex_state = 226},
  [5164] = {.lex_state = 14},
  [5165] = {.lex_state = 226},
  [5166] = {.lex_state = 226},
  [5167] = {.lex_state = 226},
  [5168] = {.lex_state = 17},
  [5169] = {.lex_state = 0},
  [5170] = {.lex_state = 226},
  [5171] = {.lex_state = 226},
  [5172] = {.lex_state = 226},
  [5173] = {.lex_state = 14},
  [5174] = {.lex_state = 231},
  [5175] = {.lex_state = 0, .external_lex_state = 18},
  [5176] = {.lex_state = 19},
  [5177] = {.lex_state = 17},
  [5178] = {.lex_state = 19},
  [5179] = {.lex_state = 226},
  [5180] = {.lex_state = 226},
  [5181] = {.lex_state = 0, .external_lex_state = 13},
  [5182] = {.lex_state = 14},
  [5183] = {.lex_state = 14},
  [5184] = {.lex_state = 17},
  [5185] = {.lex_state = 0},
  [5186] = {.lex_state = 19},
  [5187] = {.lex_state = 14},
  [5188] = {.lex_state = 226},
  [5189] = {.lex_state = 226},
  [5190] = {.lex_state = 14},
  [5191] = {.lex_state = 231},
  [5192] = {.lex_state = 0},
  [5193] = {.lex_state = 14},
  [5194] = {.lex_state = 226},
  [5195] = {.lex_state = 231},
  [5196] = {.lex_state = 226},
  [5197] = {.lex_state = 226},
  [5198] = {.lex_state = 226},
  [5199] = {.lex_state = 226},
  [5200] = {.lex_state = 226},
  [5201] = {.lex_state = 231},
  [5202] = {.lex_state = 226},
  [5203] = {.lex_state = 14},
  [5204] = {.lex_state = 14},
  [5205] = {.lex_state = 0},
  [5206] = {.lex_state = 226},
  [5207] = {.lex_state = 226},
  [5208] = {.lex_state = 14},
  [5209] = {.lex_state = 226},
  [5210] = {.lex_state = 0, .external_lex_state = 18},
  [5211] = {.lex_state = 14},
  [5212] = {.lex_state = 226},
  [5213] = {.lex_state = 31},
  [5214] = {.lex_state = 0, .external_lex_state = 18},
  [5215] = {.lex_state = 226},
  [5216] = {.lex_state = 226},
  [5217] = {.lex_state = 0},
  [5218] = {.lex_state = 226},
  [5219] = {.lex_state = 226},
  [5220] = {.lex_state = 231},
  [5221] = {.lex_state = 226},
  [5222] = {.lex_state = 226},
  [5223] = {.lex_state = 226},
  [5224] = {.lex_state = 226},
  [5225] = {.lex_state = 0, .external_lex_state = 18},
  [5226] = {.lex_state = 226},
  [5227] = {.lex_state = 226},
  [5228] = {.lex_state = 0},
  [5229] = {.lex_state = 0, .external_lex_state = 18},
  [5230] = {.lex_state = 14},
  [5231] = {.lex_state = 14},
  [5232] = {.lex_state = 226},
  [5233] = {.lex_state = 226},
  [5234] = {.lex_state = 19},
  [5235] = {.lex_state = 0, .external_lex_state = 13},
  [5236] = {.lex_state = 14},
  [5237] = {.lex_state = 31},
  [5238] = {.lex_state = 0},
  [5239] = {.lex_state = 226},
  [5240] = {.lex_state = 226},
  [5241] = {.lex_state = 226},
  [5242] = {.lex_state = 226},
  [5243] = {.lex_state = 226},
  [5244] = {.lex_state = 226},
  [5245] = {.lex_state = 226},
  [5246] = {.lex_state = 226},
  [5247] = {.lex_state = 0},
  [5248] = {.lex_state = 226},
  [5249] = {.lex_state = 226},
  [5250] = {.lex_state = 226},
  [5251] = {.lex_state = 226},
  [5252] = {.lex_state = 226},
  [5253] = {.lex_state = 0, .external_lex_state = 18},
  [5254] = {.lex_state = 226},
  [5255] = {.lex_state = 14},
  [5256] = {.lex_state = 14},
  [5257] = {.lex_state = 226},
  [5258] = {.lex_state = 14},
  [5259] = {.lex_state = 14},
  [5260] = {.lex_state = 231},
  [5261] = {.lex_state = 14},
  [5262] = {.lex_state = 226},
  [5263] = {.lex_state = 226},
  [5264] = {.lex_state = 231},
  [5265] = {.lex_state = 226},
  [5266] = {.lex_state = 17},
  [5267] = {.lex_state = 226},
  [5268] = {.lex_state = 14},
  [5269] = {.lex_state = 226},
  [5270] = {.lex_state = 226},
  [5271] = {.lex_state = 17},
  [5272] = {.lex_state = 19},
  [5273] = {.lex_state = 19},
  [5274] = {.lex_state = 226},
  [5275] = {.lex_state = 226},
  [5276] = {.lex_state = 0},
  [5277] = {.lex_state = 541},
  [5278] = {.lex_state = 226},
  [5279] = {.lex_state = 14},
  [5280] = {.lex_state = 14},
  [5281] = {.lex_state = 14},
  [5282] = {.lex_state = 0, .external_lex_state = 13},
  [5283] = {.lex_state = 0, .external_lex_state = 13},
  [5284] = {.lex_state = 14},
  [5285] = {.lex_state = 226},
  [5286] = {.lex_state = 226},
  [5287] = {.lex_state = 226},
  [5288] = {.lex_state = 226},
  [5289] = {.lex_state = 226},
  [5290] = {.lex_state = 226},
  [5291] = {.lex_state = 31},
  [5292] = {.lex_state = 0},
  [5293] = {.lex_state = 0, .external_lex_state = 13},
  [5294] = {.lex_state = 14},
  [5295] = {.lex_state = 226},
  [5296] = {.lex_state = 0, .external_lex_state = 18},
  [5297] = {.lex_state = 14},
  [5298] = {.lex_state = 14},
  [5299] = {.lex_state = 226},
  [5300] = {.lex_state = 226},
  [5301] = {.lex_state = 0},
  [5302] = {.lex_state = 226},
  [5303] = {.lex_state = 226},
  [5304] = {.lex_state = 226},
  [5305] = {.lex_state = 14},
  [5306] = {.lex_state = 226},
  [5307] = {.lex_state = 226},
  [5308] = {.lex_state = 14},
  [5309] = {.lex_state = 31},
  [5310] = {.lex_state = 31},
  [5311] = {.lex_state = 0, .external_lex_state = 18},
  [5312] = {.lex_state = 226},
  [5313] = {.lex_state = 14},
  [5314] = {.lex_state = 226},
  [5315] = {.lex_state = 226},
  [5316] = {.lex_state = 226},
  [5317] = {.lex_state = 226},
  [5318] = {.lex_state = 226},
  [5319] = {.lex_state = 31},
  [5320] = {.lex_state = 226},
  [5321] = {.lex_state = 14},
  [5322] = {.lex_state = 226},
  [5323] = {.lex_state = 0, .external_lex_state = 13},
  [5324] = {.lex_state = 226},
  [5325] = {.lex_state = 231},
  [5326] = {.lex_state = 226},
  [5327] = {.lex_state = 0},
  [5328] = {.lex_state = 226},
  [5329] = {.lex_state = 226},
  [5330] = {.lex_state = 14},
  [5331] = {.lex_state = 0, .external_lex_state = 13},
  [5332] = {.lex_state = 226},
  [5333] = {.lex_state = 226},
  [5334] = {.lex_state = 14},
  [5335] = {.lex_state = 14},
  [5336] = {.lex_state = 31},
  [5337] = {.lex_state = 14},
  [5338] = {.lex_state = 14},
  [5339] = {.lex_state = 226},
  [5340] = {.lex_state = 226},
  [5341] = {.lex_state = 226},
  [5342] = {.lex_state = 226},
  [5343] = {.lex_state = 226},
  [5344] = {.lex_state = 226},
  [5345] = {.lex_state = 226},
  [5346] = {.lex_state = 14},
  [5347] = {.lex_state = 14},
  [5348] = {.lex_state = 0, .external_lex_state = 18},
  [5349] = {.lex_state = 226},
  [5350] = {.lex_state = 226},
  [5351] = {.lex_state = 226},
  [5352] = {.lex_state = 0},
  [5353] = {.lex_state = 226},
  [5354] = {.lex_state = 226},
  [5355] = {.lex_state = 14},
  [5356] = {.lex_state = 226},
  [5357] = {.lex_state = 0, .external_lex_state = 13},
  [5358] = {.lex_state = 14},
  [5359] = {.lex_state = 14},
  [5360] = {.lex_state = 226},
  [5361] = {.lex_state = 226},
  [5362] = {.lex_state = 226},
  [5363] = {.lex_state = 14},
  [5364] = {.lex_state = 226},
  [5365] = {.lex_state = 226},
  [5366] = {.lex_state = 226},
  [5367] = {.lex_state = 226},
  [5368] = {.lex_state = 31},
  [5369] = {.lex_state = 14},
  [5370] = {.lex_state = 14},
  [5371] = {.lex_state = 17},
  [5372] = {.lex_state = 226},
  [5373] = {.lex_state = 226},
  [5374] = {.lex_state = 17},
  [5375] = {.lex_state = 226},
  [5376] = {.lex_state = 231},
  [5377] = {.lex_state = 14},
  [5378] = {.lex_state = 226},
  [5379] = {.lex_state = 19},
  [5380] = {.lex_state = 226},
  [5381] = {.lex_state = 25},
  [5382] = {.lex_state = 226},
  [5383] = {.lex_state = 226},
  [5384] = {.lex_state = 226},
  [5385] = {.lex_state = 226},
  [5386] = {.lex_state = 226},
  [5387] = {.lex_state = 17},
  [5388] = {.lex_state = 14},
  [5389] = {.lex_state = 0},
  [5390] = {.lex_state = 0, .external_lex_state = 18},
  [5391] = {.lex_state = 19},
  [5392] = {.lex_state = 226},
  [5393] = {.lex_state = 19},
  [5394] = {.lex_state = 226},
  [5395] = {.lex_state = 226},
  [5396] = {.lex_state = 14},
  [5397] = {.lex_state = 226},
  [5398] = {.lex_state = 226},
  [5399] = {.lex_state = 226},
  [5400] = {.lex_state = 14},
  [5401] = {.lex_state = 14},
  [5402] = {.lex_state = 226},
  [5403] = {.lex_state = 14},
  [5404] = {.lex_state = 17},
  [5405] = {.lex_state = 226},
  [5406] = {.lex_state = 226},
  [5407] = {.lex_state = 0},
  [5408] = {.lex_state = 226},
  [5409] = {.lex_state = 19},
  [5410] = {.lex_state = 14},
  [5411] = {.lex_state = 0},
  [5412] = {.lex_state = 14},
  [5413] = {.lex_state = 226},
  [5414] = {.lex_state = 226},
  [5415] = {.lex_state = 17},
  [5416] = {.lex_state = 226},
  [5417] = {.lex_state = 226},
  [5418] = {.lex_state = 226},
  [5419] = {.lex_state = 226},
  [5420] = {.lex_state = 19},
  [5421] = {.lex_state = 226},
  [5422] = {.lex_state = 226},
  [5423] = {.lex_state = 0},
  [5424] = {.lex_state = 226},
  [5425] = {.lex_state = 231},
  [5426] = {.lex_state = 14},
  [5427] = {.lex_state = 226},
  [5428] = {.lex_state = 226},
  [5429] = {.lex_state = 0, .external_lex_state = 19},
  [5430] = {.lex_state = 226},
  [5431] = {.lex_state = 226},
  [5432] = {.lex_state = 14},
  [5433] = {.lex_state = 226},
  [5434] = {.lex_state = 14},
  [5435] = {.lex_state = 226},
  [5436] = {.lex_state = 226},
  [5437] = {.lex_state = 226},
  [5438] = {.lex_state = 226},
  [5439] = {.lex_state = 226},
  [5440] = {.lex_state = 226},
  [5441] = {.lex_state = 226},
  [5442] = {.lex_state = 0, .external_lex_state = 13},
  [5443] = {.lex_state = 0, .external_lex_state = 13},
  [5444] = {.lex_state = 226},
  [5445] = {.lex_state = 0, .external_lex_state = 13},
  [5446] = {.lex_state = 226},
  [5447] = {.lex_state = 31},
  [5448] = {.lex_state = 226},
  [5449] = {.lex_state = 226},
  [5450] = {.lex_state = 226},
  [5451] = {.lex_state = 226},
  [5452] = {.lex_state = 226},
  [5453] = {.lex_state = 226},
  [5454] = {.lex_state = 226},
  [5455] = {.lex_state = 226},
  [5456] = {.lex_state = 14},
  [5457] = {.lex_state = 0},
  [5458] = {.lex_state = 14},
  [5459] = {.lex_state = 31},
  [5460] = {.lex_state = 0},
  [5461] = {.lex_state = 0},
  [5462] = {.lex_state = 226},
  [5463] = {.lex_state = 17},
  [5464] = {.lex_state = 19},
  [5465] = {.lex_state = 14},
  [5466] = {.lex_state = 29},
  [5467] = {.lex_state = 226},
  [5468] = {.lex_state = 226},
  [5469] = {.lex_state = 0},
  [5470] = {.lex_state = 226},
  [5471] = {.lex_state = 226},
  [5472] = {.lex_state = 231},
  [5473] = {.lex_state = 14},
  [5474] = {.lex_state = 231},
  [5475] = {.lex_state = 226},
  [5476] = {.lex_state = 226},
  [5477] = {.lex_state = 14},
  [5478] = {.lex_state = 226},
  [5479] = {.lex_state = 226},
  [5480] = {.lex_state = 226},
  [5481] = {.lex_state = 0},
  [5482] = {.lex_state = 226},
  [5483] = {.lex_state = 0, .external_lex_state = 18},
  [5484] = {.lex_state = 226},
  [5485] = {.lex_state = 0, .external_lex_state = 13},
  [5486] = {.lex_state = 231},
  [5487] = {.lex_state = 0},
  [5488] = {.lex_state = 14},
  [5489] = {.lex_state = 0, .external_lex_state = 13},
  [5490] = {.lex_state = 31},
  [5491] = {.lex_state = 17},
  [5492] = {.lex_state = 31},
  [5493] = {.lex_state = 14},
  [5494] = {.lex_state = 226},
  [5495] = {.lex_state = 226},
  [5496] = {.lex_state = 0, .external_lex_state = 18},
  [5497] = {.lex_state = 226},
  [5498] = {.lex_state = 226},
  [5499] = {.lex_state = 226},
  [5500] = {.lex_state = 226},
  [5501] = {.lex_state = 226},
  [5502] = {.lex_state = 226},
  [5503] = {.lex_state = 0, .external_lex_state = 18},
  [5504] = {.lex_state = 14},
  [5505] = {.lex_state = 251},
  [5506] = {.lex_state = 226},
  [5507] = {.lex_state = 17},
  [5508] = {.lex_state = 19},
  [5509] = {.lex_state = 0},
  [5510] = {.lex_state = 226},
  [5511] = {.lex_state = 231},
  [5512] = {.lex_state = 0},
  [5513] = {.lex_state = 226},
  [5514] = {.lex_state = 0},
  [5515] = {.lex_state = 226},
  [5516] = {.lex_state = 14},
  [5517] = {.lex_state = 226},
  [5518] = {.lex_state = 226},
  [5519] = {.lex_state = 226},
  [5520] = {.lex_state = 0},
  [5521] = {.lex_state = 0},
  [5522] = {.lex_state = 226},
  [5523] = {.lex_state = 248},
  [5524] = {.lex_state = 226},
  [5525] = {.lex_state = 226},
  [5526] = {.lex_state = 226},
  [5527] = {.lex_state = 226},
  [5528] = {.lex_state = 226},
  [5529] = {.lex_state = 226},
  [5530] = {.lex_state = 226},
  [5531] = {.lex_state = 0, .external_lex_state = 13},
  [5532] = {.lex_state = 226},
  [5533] = {.lex_state = 0, .external_lex_state = 18},
  [5534] = {.lex_state = 226},
  [5535] = {.lex_state = 0, .external_lex_state = 13},
  [5536] = {.lex_state = 226},
  [5537] = {.lex_state = 14},
  [5538] = {.lex_state = 226},
  [5539] = {.lex_state = 14},
  [5540] = {.lex_state = 226},
  [5541] = {.lex_state = 0, .external_lex_state = 13},
  [5542] = {.lex_state = 226},
  [5543] = {.lex_state = 14},
  [5544] = {.lex_state = 226},
  [5545] = {.lex_state = 14},
  [5546] = {.lex_state = 226},
  [5547] = {.lex_state = 226},
  [5548] = {.lex_state = 226},
  [5549] = {.lex_state = 226},
  [5550] = {(TSStateId)(-1)},
  [5551] = {(TSStateId)(-1)},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_block_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [aux_sym_block_comment_text_token2] = ACTIONS(1),
    [aux_sym_block_comment_text_token3] = ACTIONS(1),
    [aux_sym_block_comment_text_token4] = ACTIONS(1),
    [anon_sym_MODULE] = ACTIONS(1),
    [anon_sym_DASH_DASH_DASH_DASH] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_u225c] = ACTIONS(1),
    [anon_sym_BSLASHin] = ACTIONS(1),
    [anon_sym_u2208] = ACTIONS(1),
    [anon_sym_u27f5] = ACTIONS(1),
    [anon_sym_u2190] = ACTIONS(1),
    [anon_sym_BSLASHA] = ACTIONS(1),
    [anon_sym_BSLASHforall] = ACTIONS(1),
    [anon_sym_u2200] = ACTIONS(1),
    [anon_sym_BSLASHE] = ACTIONS(1),
    [anon_sym_BSLASHexists] = ACTIONS(1),
    [anon_sym_u2203] = ACTIONS(1),
    [sym_temporal_forall] = ACTIONS(1),
    [sym_temporal_exists] = ACTIONS(1),
    [anon_sym_PIPE_DASH_GT] = ACTIONS(1),
    [anon_sym_u27fc] = ACTIONS(1),
    [anon_sym_u21a6] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_u27f6] = ACTIONS(1),
    [anon_sym_u2192] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_u3008] = ACTIONS(1),
    [anon_sym_u27e8] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_u3009] = ACTIONS(1),
    [anon_sym_u27e9] = ACTIONS(1),
    [anon_sym_GT_GT_] = ACTIONS(1),
    [anon_sym_u3009_] = ACTIONS(1),
    [anon_sym_u27e9_] = ACTIONS(1),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(1),
    [anon_sym_u25a1] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_u2237] = ACTIONS(1),
    [sym_placeholder] = ACTIONS(1),
    [anon_sym_SLASH_BSLASH] = ACTIONS(1),
    [anon_sym_u2227] = ACTIONS(1),
    [anon_sym_BSLASH_SLASH] = ACTIONS(1),
    [anon_sym_u2228] = ACTIONS(1),
    [anon_sym_EXTENDS] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_LOCAL] = ACTIONS(1),
    [anon_sym_VARIABLE] = ACTIONS(1),
    [anon_sym_VARIABLES] = ACTIONS(1),
    [anon_sym_CONSTANT] = ACTIONS(1),
    [anon_sym_CONSTANTS] = ACTIONS(1),
    [anon_sym_RECURSIVE] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_INSTANCE] = ACTIONS(1),
    [anon_sym_WITH] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [aux_sym_child_id_token1] = ACTIONS(1),
    [anon_sym_LAMBDA] = ACTIONS(1),
    [anon_sym_BSLASHb] = ACTIONS(1),
    [anon_sym_BSLASHB] = ACTIONS(1),
    [aux_sym_binary_number_token1] = ACTIONS(1),
    [anon_sym_BSLASHo] = ACTIONS(1),
    [anon_sym_BSLASHO] = ACTIONS(1),
    [aux_sym_octal_number_token1] = ACTIONS(1),
    [anon_sym_BSLASHh] = ACTIONS(1),
    [anon_sym_BSLASHH] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_TRUE] = ACTIONS(1),
    [anon_sym_FALSE] = ACTIONS(1),
    [sym_string_set] = ACTIONS(1),
    [sym_boolean_set] = ACTIONS(1),
    [anon_sym_Nat] = ACTIONS(1),
    [anon_sym_u2115] = ACTIONS(1),
    [anon_sym_Int] = ACTIONS(1),
    [anon_sym_u2124] = ACTIONS(1),
    [anon_sym_Real] = ACTIONS(1),
    [anon_sym_u211d] = ACTIONS(1),
    [anon_sym_CHOOSE] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_EXCEPT] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_WF_] = ACTIONS(1),
    [anon_sym_SF_] = ACTIONS(1),
    [anon_sym_IF] = ACTIONS(1),
    [anon_sym_THEN] = ACTIONS(1),
    [anon_sym_ELSE] = ACTIONS(1),
    [anon_sym_CASE] = ACTIONS(1),
    [anon_sym_OTHER] = ACTIONS(1),
    [anon_sym_LET] = ACTIONS(1),
    [anon_sym_IN] = ACTIONS(1),
    [anon_sym_BSLASHlnot] = ACTIONS(1),
    [anon_sym_BSLASHneg] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_u00ac] = ACTIONS(1),
    [sym_union] = ACTIONS(1),
    [sym_powerset] = ACTIONS(1),
    [sym_domain] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [sym_negative_dot] = ACTIONS(1),
    [sym_enabled] = ACTIONS(1),
    [sym_unchanged] = ACTIONS(1),
    [anon_sym_LT_GT] = ACTIONS(1),
    [anon_sym_u22c4] = ACTIONS(1),
    [anon_sym_u25c7] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_u27f9] = ACTIONS(1),
    [anon_sym_u21d2] = ACTIONS(1),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(1),
    [anon_sym_u21f8] = ACTIONS(1),
    [anon_sym_u2945] = ACTIONS(1),
    [anon_sym_BSLASHequiv] = ACTIONS(1),
    [anon_sym_u2261] = ACTIONS(1),
    [anon_sym_LT_EQ_GT] = ACTIONS(1),
    [anon_sym_u27fa] = ACTIONS(1),
    [anon_sym_u21d4] = ACTIONS(1),
    [anon_sym_TILDE_GT] = ACTIONS(1),
    [anon_sym_u21dd] = ACTIONS(1),
    [anon_sym_u219d] = ACTIONS(1),
    [anon_sym_BSLASHland] = ACTIONS(1),
    [anon_sym_BSLASHlor] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_u2254] = ACTIONS(1),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(1),
    [anon_sym_u2a74] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_u2260] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [sym_gt] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_LT] = ACTIONS(1),
    [anon_sym_BSLASHleq] = ACTIONS(1),
    [anon_sym_u2264] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_BSLASHgeq] = ACTIONS(1),
    [anon_sym_u2265] = ACTIONS(1),
    [anon_sym_BSLASHapprox] = ACTIONS(1),
    [anon_sym_u2248] = ACTIONS(1),
    [anon_sym_PIPE_DASH] = ACTIONS(1),
    [anon_sym_u22a2] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_u22a8] = ACTIONS(1),
    [anon_sym_DASH_PIPE] = ACTIONS(1),
    [anon_sym_u22a3] = ACTIONS(1),
    [anon_sym_EQ_PIPE] = ACTIONS(1),
    [anon_sym_u2ae4] = ACTIONS(1),
    [anon_sym_BSLASHasymp] = ACTIONS(1),
    [anon_sym_u224d] = ACTIONS(1),
    [anon_sym_BSLASHcong] = ACTIONS(1),
    [anon_sym_u2245] = ACTIONS(1),
    [anon_sym_BSLASHdoteq] = ACTIONS(1),
    [anon_sym_u2250] = ACTIONS(1),
    [anon_sym_BSLASHgg] = ACTIONS(1),
    [anon_sym_u226b] = ACTIONS(1),
    [anon_sym_BSLASHll] = ACTIONS(1),
    [anon_sym_u226a] = ACTIONS(1),
    [anon_sym_BSLASHnotin] = ACTIONS(1),
    [anon_sym_u2209] = ACTIONS(1),
    [anon_sym_BSLASHprec] = ACTIONS(1),
    [anon_sym_u227a] = ACTIONS(1),
    [anon_sym_BSLASHsucc] = ACTIONS(1),
    [anon_sym_u227b] = ACTIONS(1),
    [anon_sym_BSLASHpreceq] = ACTIONS(1),
    [anon_sym_u2aaf] = ACTIONS(1),
    [anon_sym_BSLASHsucceq] = ACTIONS(1),
    [anon_sym_u2ab0] = ACTIONS(1),
    [anon_sym_BSLASHpropto] = ACTIONS(1),
    [anon_sym_u221d] = ACTIONS(1),
    [anon_sym_BSLASHsim] = ACTIONS(1),
    [anon_sym_u223c] = ACTIONS(1),
    [anon_sym_BSLASHsimeq] = ACTIONS(1),
    [anon_sym_u2243] = ACTIONS(1),
    [anon_sym_BSLASHsqsubset] = ACTIONS(1),
    [anon_sym_u228f] = ACTIONS(1),
    [anon_sym_BSLASHsqsupset] = ACTIONS(1),
    [anon_sym_u2290] = ACTIONS(1),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(1),
    [anon_sym_u2291] = ACTIONS(1),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(1),
    [anon_sym_u2292] = ACTIONS(1),
    [anon_sym_BSLASHsubset] = ACTIONS(1),
    [anon_sym_u2282] = ACTIONS(1),
    [anon_sym_BSLASHsupset] = ACTIONS(1),
    [anon_sym_u2283] = ACTIONS(1),
    [anon_sym_BSLASHsubseteq] = ACTIONS(1),
    [anon_sym_u2286] = ACTIONS(1),
    [anon_sym_BSLASHsupseteq] = ACTIONS(1),
    [anon_sym_u2287] = ACTIONS(1),
    [sym_compose] = ACTIONS(1),
    [sym_map_to] = ACTIONS(1),
    [sym_map_from] = ACTIONS(1),
    [sym_setminus] = ACTIONS(1),
    [anon_sym_BSLASHcap] = ACTIONS(1),
    [anon_sym_BSLASHintersect] = ACTIONS(1),
    [anon_sym_u2229] = ACTIONS(1),
    [anon_sym_BSLASHcup] = ACTIONS(1),
    [anon_sym_BSLASHunion] = ACTIONS(1),
    [anon_sym_u222a] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_u2025] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_u2026] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [sym_plusplus] = ACTIONS(1),
    [anon_sym_BSLASHoplus] = ACTIONS(1),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(1),
    [anon_sym_u2295] = ACTIONS(1),
    [anon_sym_BSLASHominus] = ACTIONS(1),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(1),
    [anon_sym_u2296] = ACTIONS(1),
    [sym_mod] = ACTIONS(1),
    [sym_modmod] = ACTIONS(1),
    [sym_vert] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_u2016] = ACTIONS(1),
    [sym_minusminus] = ACTIONS(1),
    [sym_amp] = ACTIONS(1),
    [sym_ampamp] = ACTIONS(1),
    [anon_sym_BSLASHodot] = ACTIONS(1),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(1),
    [anon_sym_u2299] = ACTIONS(1),
    [anon_sym_BSLASHoslash] = ACTIONS(1),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(1),
    [anon_sym_u2298] = ACTIONS(1),
    [anon_sym_BSLASHotimes] = ACTIONS(1),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(1),
    [anon_sym_u2297] = ACTIONS(1),
    [sym_mul] = ACTIONS(1),
    [sym_mulmul] = ACTIONS(1),
    [sym_slash] = ACTIONS(1),
    [sym_slashslash] = ACTIONS(1),
    [anon_sym_BSLASHbigcirc] = ACTIONS(1),
    [anon_sym_u25ef] = ACTIONS(1),
    [anon_sym_BSLASHbullet] = ACTIONS(1),
    [anon_sym_u25cf] = ACTIONS(1),
    [anon_sym_BSLASHdiv] = ACTIONS(1),
    [anon_sym_u00f7] = ACTIONS(1),
    [anon_sym_BSLASHcirc] = ACTIONS(1),
    [anon_sym_u2218] = ACTIONS(1),
    [anon_sym_BSLASHstar] = ACTIONS(1),
    [anon_sym_u22c6] = ACTIONS(1),
    [anon_sym_u203c] = ACTIONS(1),
    [sym_hashhash] = ACTIONS(1),
    [sym_dol] = ACTIONS(1),
    [sym_doldol] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_u2047] = ACTIONS(1),
    [anon_sym_BSLASHsqcap] = ACTIONS(1),
    [anon_sym_u2293] = ACTIONS(1),
    [anon_sym_BSLASHsqcup] = ACTIONS(1),
    [anon_sym_u2294] = ACTIONS(1),
    [anon_sym_BSLASHuplus] = ACTIONS(1),
    [anon_sym_u228e] = ACTIONS(1),
    [anon_sym_BSLASHX] = ACTIONS(1),
    [anon_sym_BSLASHtimes] = ACTIONS(1),
    [anon_sym_u00d7] = ACTIONS(1),
    [anon_sym_BSLASHwr] = ACTIONS(1),
    [anon_sym_u2240] = ACTIONS(1),
    [anon_sym_BSLASHcdot] = ACTIONS(1),
    [anon_sym_u22c5] = ACTIONS(1),
    [sym_pow] = ACTIONS(1),
    [sym_powpow] = ACTIONS(1),
    [anon_sym_CARET_PLUS] = ACTIONS(1),
    [anon_sym_u207a] = ACTIONS(1),
    [sym_asterisk] = ACTIONS(1),
    [sym_sup_hash] = ACTIONS(1),
    [sym_prime] = ACTIONS(1),
    [anon_sym_ASSUME] = ACTIONS(1),
    [anon_sym_ASSUMPTION] = ACTIONS(1),
    [anon_sym_AXIOM] = ACTIONS(1),
    [anon_sym_THEOREM] = ACTIONS(1),
    [anon_sym_PROPOSITION] = ACTIONS(1),
    [anon_sym_LEMMA] = ACTIONS(1),
    [anon_sym_COROLLARY] = ACTIONS(1),
    [anon_sym_PROVE] = ACTIONS(1),
    [anon_sym_NEW] = ACTIONS(1),
    [anon_sym_STATE] = ACTIONS(1),
    [anon_sym_ACTION] = ACTIONS(1),
    [anon_sym_TEMPORAL] = ACTIONS(1),
    [anon_sym_PROOF] = ACTIONS(1),
    [anon_sym_BY] = ACTIONS(1),
    [anon_sym_ONLY] = ACTIONS(1),
    [anon_sym_OBVIOUS] = ACTIONS(1),
    [anon_sym_OMITTED] = ACTIONS(1),
    [anon_sym_DEFINE] = ACTIONS(1),
    [anon_sym_HAVE] = ACTIONS(1),
    [anon_sym_WITNESS] = ACTIONS(1),
    [anon_sym_TAKE] = ACTIONS(1),
    [anon_sym_SUFFICES] = ACTIONS(1),
    [anon_sym_PICK] = ACTIONS(1),
    [anon_sym_QED] = ACTIONS(1),
    [anon_sym_USE] = ACTIONS(1),
    [anon_sym_HIDE] = ACTIONS(1),
    [anon_sym_DEF] = ACTIONS(1),
    [anon_sym_DEFS] = ACTIONS(1),
    [aux_sym_proof_step_id_token1] = ACTIONS(1),
    [aux_sym_proof_step_ref_token1] = ACTIONS(1),
    [anon_sym_end] = ACTIONS(1),
    [anon_sym_algorithm] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_define] = ACTIONS(1),
    [anon_sym_macro] = ACTIONS(1),
    [anon_sym_procedure] = ACTIONS(1),
    [anon_sym_fair] = ACTIONS(1),
    [anon_sym_process] = ACTIONS(1),
    [anon_sym_variable] = ACTIONS(1),
    [anon_sym_variables] = ACTIONS(1),
    [anon_sym_begin] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_elsif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_either] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_when] = ACTIONS(1),
    [anon_sym_print] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [sym_pcal_skip] = ACTIONS(1),
    [sym_pcal_return] = ACTIONS(1),
    [anon_sym_goto] = ACTIONS(1),
    [anon_sym_call] = ACTIONS(1),
    [sym_leading_extramodular_text] = ACTIONS(1),
    [sym_trailing_extramodular_text] = ACTIONS(1),
    [sym__indent] = ACTIONS(1),
    [sym__bullet] = ACTIONS(1),
    [sym__dedent] = ACTIONS(1),
    [sym__begin_proof] = ACTIONS(1),
    [sym__begin_proof_step] = ACTIONS(1),
    [sym__notify_pcal_algorithm_start] = ACTIONS(1),
    [sym__notify_pcal_algorithm_end] = ACTIONS(1),
    [sym__double_excl] = ACTIONS(1),
    [sym__error_sentinel] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(5411),
    [sym_block_comment] = STATE(1),
    [sym_module] = STATE(3591),
    [sym_single_line] = STATE(3592),
    [sym_extends] = STATE(3424),
    [sym__unit] = STATE(3588),
    [sym_local_definition] = STATE(3578),
    [sym__definition] = STATE(3578),
    [sym_variable_declaration] = STATE(3578),
    [sym_constant_declaration] = STATE(3578),
    [sym_recursive_declaration] = STATE(3578),
    [sym_operator_definition] = STATE(3528),
    [sym_function_definition] = STATE(3528),
    [sym_instance] = STATE(3528),
    [sym_module_definition] = STATE(3528),
    [sym__number_set] = STATE(4382),
    [sym_nat_number_set] = STATE(4546),
    [sym_int_number_set] = STATE(4546),
    [sym_real_number_set] = STATE(4546),
    [sym_lnot] = STATE(3472),
    [sym_always] = STATE(3472),
    [sym_eventually] = STATE(3472),
    [sym_prefix_op_symbol] = STATE(5171),
    [sym_assumption] = STATE(3578),
    [sym_theorem] = STATE(3578),
    [sym_use_or_hide] = STATE(3578),
    [sym_pcal_algorithm] = STATE(5205),
    [sym__pcal_p_algorithm] = STATE(5487),
    [sym__pcal_c_algorithm] = STATE(5457),
    [sym_pcal_algorithm_start] = STATE(5478),
    [sym_fair] = STATE(5092),
    [aux_sym_source_file_repeat1] = STATE(4179),
    [aux_sym_source_file_repeat2] = STATE(3422),
    [sym_identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_DASH_DASH_DASH_DASH] = ACTIONS(9),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(11),
    [anon_sym_u25a1] = ACTIONS(11),
    [anon_sym_EXTENDS] = ACTIONS(13),
    [anon_sym_LOCAL] = ACTIONS(15),
    [anon_sym_VARIABLE] = ACTIONS(17),
    [anon_sym_VARIABLES] = ACTIONS(17),
    [anon_sym_CONSTANT] = ACTIONS(19),
    [anon_sym_CONSTANTS] = ACTIONS(19),
    [anon_sym_RECURSIVE] = ACTIONS(21),
    [anon_sym_INSTANCE] = ACTIONS(23),
    [anon_sym_Nat] = ACTIONS(25),
    [anon_sym_u2115] = ACTIONS(27),
    [anon_sym_Int] = ACTIONS(29),
    [anon_sym_u2124] = ACTIONS(31),
    [anon_sym_Real] = ACTIONS(33),
    [anon_sym_u211d] = ACTIONS(35),
    [anon_sym_BSLASHlnot] = ACTIONS(37),
    [anon_sym_BSLASHneg] = ACTIONS(37),
    [anon_sym_TILDE] = ACTIONS(37),
    [anon_sym_u00ac] = ACTIONS(37),
    [sym_union] = ACTIONS(39),
    [sym_powerset] = ACTIONS(39),
    [sym_domain] = ACTIONS(39),
    [sym_negative_dot] = ACTIONS(41),
    [sym_enabled] = ACTIONS(39),
    [sym_unchanged] = ACTIONS(39),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_u22c4] = ACTIONS(43),
    [anon_sym_u25c7] = ACTIONS(43),
    [anon_sym_ASSUME] = ACTIONS(45),
    [anon_sym_ASSUMPTION] = ACTIONS(45),
    [anon_sym_AXIOM] = ACTIONS(45),
    [anon_sym_THEOREM] = ACTIONS(47),
    [anon_sym_PROPOSITION] = ACTIONS(47),
    [anon_sym_LEMMA] = ACTIONS(47),
    [anon_sym_COROLLARY] = ACTIONS(47),
    [anon_sym_USE] = ACTIONS(49),
    [anon_sym_HIDE] = ACTIONS(49),
    [anon_sym_DASH_DASHalgorithm] = ACTIONS(51),
    [anon_sym_DASH_DASHfair] = ACTIONS(53),
    [sym_leading_extramodular_text] = ACTIONS(55),
  },
  [2] = {
    [sym_block_comment] = STATE(2),
    [sym_forall] = STATE(4007),
    [sym_exists] = STATE(4007),
    [sym_langle_bracket] = STATE(75),
    [sym_operator_definition] = STATE(3862),
    [sym_function_definition] = STATE(3862),
    [sym_instance] = STATE(5485),
    [sym_subexpr_prefix] = STATE(1091),
    [sym_subexpr_component] = STATE(5469),
    [sym_bound_op] = STATE(2937),
    [sym_bound_nonfix_op] = STATE(2937),
    [sym_module_definition] = STATE(3862),
    [sym__expr] = STATE(1547),
    [sym_prefixed_op] = STATE(3024),
    [sym__number] = STATE(3024),
    [sym_nat_number] = STATE(3014),
    [sym_binary_number] = STATE(3014),
    [sym_octal_number] = STATE(3014),
    [sym_hex_number] = STATE(3014),
    [sym_string] = STATE(3024),
    [sym_boolean] = STATE(3024),
    [sym__number_set] = STATE(2901),
    [sym__primitive_value_set] = STATE(3024),
    [sym_nat_number_set] = STATE(2936),
    [sym_int_number_set] = STATE(2936),
    [sym_real_number_set] = STATE(2936),
    [sym_label] = STATE(3024),
    [sym_subexpression] = STATE(3024),
    [sym_parentheses] = STATE(3024),
    [sym_bounded_quantification] = STATE(3024),
    [sym_unbounded_quantification] = STATE(3024),
    [sym_choose] = STATE(3024),
    [sym_finite_set_literal] = STATE(3024),
    [sym_set_filter] = STATE(3024),
    [sym_set_map] = STATE(3024),
    [sym_function_evaluation] = STATE(3024),
    [sym_function_literal] = STATE(3024),
    [sym_set_of_functions] = STATE(3024),
    [sym_record_literal] = STATE(3024),
    [sym_set_of_records] = STATE(3024),
    [sym_record_value] = STATE(3024),
    [sym_except] = STATE(3024),
    [sym_prev_func_val] = STATE(3024),
    [sym_tuple_literal] = STATE(3024),
    [sym_step_expr_or_stutter] = STATE(3024),
    [sym_step_expr_no_stutter] = STATE(3024),
    [sym_fairness] = STATE(3024),
    [sym_if_then_else] = STATE(3024),
    [sym_case] = STATE(3024),
    [sym_let_in] = STATE(3024),
    [sym_conj_list] = STATE(3024),
    [sym_disj_list] = STATE(3024),
    [sym_lnot] = STATE(261),
    [sym_negative] = STATE(489),
    [sym_always] = STATE(260),
    [sym_eventually] = STATE(260),
    [sym_prefix_op_symbol] = STATE(4922),
    [sym_bound_prefix_op] = STATE(3024),
    [sym_implies] = STATE(3441),
    [sym_plus_arrow] = STATE(3441),
    [sym_equiv] = STATE(3441),
    [sym_iff] = STATE(3441),
    [sym_leads_to] = STATE(3441),
    [sym_land] = STATE(3441),
    [sym_lor] = STATE(3441),
    [sym_assign] = STATE(3441),
    [sym_bnf_rule] = STATE(3441),
    [sym_eq] = STATE(3441),
    [sym_neq] = STATE(3441),
    [sym_lt] = STATE(3441),
    [sym_leq] = STATE(3441),
    [sym_geq] = STATE(3441),
    [sym_approx] = STATE(3441),
    [sym_rs_ttile] = STATE(3441),
    [sym_rd_ttile] = STATE(3441),
    [sym_ls_ttile] = STATE(3441),
    [sym_ld_ttile] = STATE(3441),
    [sym_asymp] = STATE(3441),
    [sym_cong] = STATE(3441),
    [sym_doteq] = STATE(3441),
    [sym_gg] = STATE(3441),
    [sym_ll] = STATE(3441),
    [sym_in] = STATE(3441),
    [sym_notin] = STATE(3441),
    [sym_prec] = STATE(3441),
    [sym_succ] = STATE(3441),
    [sym_preceq] = STATE(3441),
    [sym_succeq] = STATE(3441),
    [sym_propto] = STATE(3441),
    [sym_sim] = STATE(3441),
    [sym_simeq] = STATE(3441),
    [sym_sqsubset] = STATE(3441),
    [sym_sqsupset] = STATE(3441),
    [sym_sqsubseteq] = STATE(3441),
    [sym_sqsupseteq] = STATE(3441),
    [sym_subset] = STATE(3441),
    [sym_supset] = STATE(3441),
    [sym_subseteq] = STATE(3441),
    [sym_supseteq] = STATE(3441),
    [sym_cap] = STATE(3441),
    [sym_cup] = STATE(3441),
    [sym_dots_2] = STATE(3441),
    [sym_dots_3] = STATE(3441),
    [sym_plus] = STATE(3441),
    [sym_oplus] = STATE(3441),
    [sym_ominus] = STATE(3441),
    [sym_vertvert] = STATE(3441),
    [sym_minus] = STATE(3441),
    [sym_odot] = STATE(3441),
    [sym_oslash] = STATE(3441),
    [sym_otimes] = STATE(3441),
    [sym_bigcirc] = STATE(3441),
    [sym_bullet] = STATE(3441),
    [sym_div] = STATE(3441),
    [sym_circ] = STATE(3441),
    [sym_star] = STATE(3441),
    [sym_excl] = STATE(3441),
    [sym_qq] = STATE(3441),
    [sym_sqcap] = STATE(3441),
    [sym_sqcup] = STATE(3441),
    [sym_uplus] = STATE(3441),
    [sym_times] = STATE(3441),
    [sym_wr] = STATE(3441),
    [sym_cdot] = STATE(3441),
    [sym_infix_op_symbol] = STATE(5052),
    [sym_bound_infix_op] = STATE(3024),
    [sym_sup_plus] = STATE(3426),
    [sym_postfix_op_symbol] = STATE(4959),
    [sym_bound_postfix_op] = STATE(3024),
    [sym_assume_prove] = STATE(3944),
    [sym_definition_proof_step] = STATE(5485),
    [sym_have_proof_step] = STATE(5485),
    [sym_witness_proof_step] = STATE(5485),
    [sym_take_proof_step] = STATE(5485),
    [sym_suffices_proof_step] = STATE(5485),
    [sym_case_proof_step] = STATE(5485),
    [sym_pick_proof_step] = STATE(5485),
    [sym_use_or_hide] = STATE(5485),
    [sym_proof_step_ref] = STATE(2968),
    [aux_sym_definition_proof_step_repeat1] = STATE(3638),
    [sym_identifier] = ACTIONS(57),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(59),
    [anon_sym_u2208] = ACTIONS(61),
    [anon_sym_BSLASHA] = ACTIONS(63),
    [anon_sym_BSLASHforall] = ACTIONS(65),
    [anon_sym_u2200] = ACTIONS(65),
    [anon_sym_BSLASHE] = ACTIONS(67),
    [anon_sym_BSLASHexists] = ACTIONS(69),
    [anon_sym_u2203] = ACTIONS(69),
    [sym_temporal_forall] = ACTIONS(71),
    [sym_temporal_exists] = ACTIONS(71),
    [anon_sym_LT_LT] = ACTIONS(73),
    [anon_sym_u3008] = ACTIONS(73),
    [anon_sym_u27e8] = ACTIONS(73),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(75),
    [anon_sym_u25a1] = ACTIONS(75),
    [anon_sym_AT] = ACTIONS(77),
    [anon_sym_SLASH_BSLASH] = ACTIONS(79),
    [anon_sym_u2227] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(81),
    [anon_sym_u2228] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_LBRACK] = ACTIONS(85),
    [anon_sym_INSTANCE] = ACTIONS(87),
    [aux_sym_child_id_token1] = ACTIONS(89),
    [sym_real_number] = ACTIONS(91),
    [anon_sym_BSLASHb] = ACTIONS(93),
    [anon_sym_BSLASHB] = ACTIONS(95),
    [anon_sym_BSLASHo] = ACTIONS(97),
    [anon_sym_BSLASHO] = ACTIONS(99),
    [anon_sym_BSLASHh] = ACTIONS(101),
    [anon_sym_BSLASHH] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_TRUE] = ACTIONS(105),
    [anon_sym_FALSE] = ACTIONS(105),
    [sym_string_set] = ACTIONS(107),
    [sym_boolean_set] = ACTIONS(107),
    [anon_sym_Nat] = ACTIONS(109),
    [anon_sym_u2115] = ACTIONS(111),
    [anon_sym_Int] = ACTIONS(113),
    [anon_sym_u2124] = ACTIONS(115),
    [anon_sym_Real] = ACTIONS(117),
    [anon_sym_u211d] = ACTIONS(119),
    [anon_sym_CHOOSE] = ACTIONS(121),
    [anon_sym_LBRACE] = ACTIONS(123),
    [anon_sym_EQ] = ACTIONS(125),
    [anon_sym_WF_] = ACTIONS(127),
    [anon_sym_SF_] = ACTIONS(127),
    [anon_sym_IF] = ACTIONS(129),
    [anon_sym_CASE] = ACTIONS(131),
    [anon_sym_LET] = ACTIONS(133),
    [anon_sym_BSLASHlnot] = ACTIONS(135),
    [anon_sym_BSLASHneg] = ACTIONS(135),
    [anon_sym_TILDE] = ACTIONS(137),
    [anon_sym_u00ac] = ACTIONS(135),
    [sym_union] = ACTIONS(139),
    [sym_powerset] = ACTIONS(139),
    [sym_domain] = ACTIONS(139),
    [anon_sym_DASH] = ACTIONS(141),
    [sym_negative_dot] = ACTIONS(41),
    [sym_enabled] = ACTIONS(143),
    [sym_unchanged] = ACTIONS(143),
    [anon_sym_LT_GT] = ACTIONS(145),
    [anon_sym_u22c4] = ACTIONS(145),
    [anon_sym_u25c7] = ACTIONS(145),
    [anon_sym_EQ_GT] = ACTIONS(147),
    [anon_sym_u27f9] = ACTIONS(147),
    [anon_sym_u21d2] = ACTIONS(147),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(149),
    [anon_sym_u21f8] = ACTIONS(149),
    [anon_sym_u2945] = ACTIONS(149),
    [anon_sym_BSLASHequiv] = ACTIONS(151),
    [anon_sym_u2261] = ACTIONS(151),
    [anon_sym_LT_EQ_GT] = ACTIONS(153),
    [anon_sym_u27fa] = ACTIONS(153),
    [anon_sym_u21d4] = ACTIONS(153),
    [anon_sym_TILDE_GT] = ACTIONS(155),
    [anon_sym_u21dd] = ACTIONS(155),
    [anon_sym_u219d] = ACTIONS(155),
    [anon_sym_BSLASHland] = ACTIONS(79),
    [anon_sym_BSLASHlor] = ACTIONS(81),
    [anon_sym_COLON_EQ] = ACTIONS(157),
    [anon_sym_u2254] = ACTIONS(157),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(159),
    [anon_sym_u2a74] = ACTIONS(159),
    [anon_sym_SLASH_EQ] = ACTIONS(161),
    [anon_sym_POUND] = ACTIONS(163),
    [anon_sym_u2260] = ACTIONS(161),
    [anon_sym_LT] = ACTIONS(165),
    [sym_gt] = ACTIONS(167),
    [anon_sym_LT_EQ] = ACTIONS(169),
    [anon_sym_EQ_LT] = ACTIONS(171),
    [anon_sym_BSLASHleq] = ACTIONS(171),
    [anon_sym_u2264] = ACTIONS(171),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_BSLASHgeq] = ACTIONS(173),
    [anon_sym_u2265] = ACTIONS(173),
    [anon_sym_BSLASHapprox] = ACTIONS(175),
    [anon_sym_u2248] = ACTIONS(175),
    [anon_sym_PIPE_DASH] = ACTIONS(177),
    [anon_sym_u22a2] = ACTIONS(177),
    [anon_sym_PIPE_EQ] = ACTIONS(179),
    [anon_sym_u22a8] = ACTIONS(179),
    [anon_sym_DASH_PIPE] = ACTIONS(181),
    [anon_sym_u22a3] = ACTIONS(181),
    [anon_sym_EQ_PIPE] = ACTIONS(183),
    [anon_sym_u2ae4] = ACTIONS(183),
    [anon_sym_BSLASHasymp] = ACTIONS(185),
    [anon_sym_u224d] = ACTIONS(185),
    [anon_sym_BSLASHcong] = ACTIONS(187),
    [anon_sym_u2245] = ACTIONS(187),
    [anon_sym_BSLASHdoteq] = ACTIONS(189),
    [anon_sym_u2250] = ACTIONS(189),
    [anon_sym_BSLASHgg] = ACTIONS(191),
    [anon_sym_u226b] = ACTIONS(191),
    [anon_sym_BSLASHll] = ACTIONS(193),
    [anon_sym_u226a] = ACTIONS(193),
    [anon_sym_BSLASHnotin] = ACTIONS(195),
    [anon_sym_u2209] = ACTIONS(195),
    [anon_sym_BSLASHprec] = ACTIONS(197),
    [anon_sym_u227a] = ACTIONS(199),
    [anon_sym_BSLASHsucc] = ACTIONS(201),
    [anon_sym_u227b] = ACTIONS(203),
    [anon_sym_BSLASHpreceq] = ACTIONS(205),
    [anon_sym_u2aaf] = ACTIONS(205),
    [anon_sym_BSLASHsucceq] = ACTIONS(207),
    [anon_sym_u2ab0] = ACTIONS(207),
    [anon_sym_BSLASHpropto] = ACTIONS(209),
    [anon_sym_u221d] = ACTIONS(209),
    [anon_sym_BSLASHsim] = ACTIONS(211),
    [anon_sym_u223c] = ACTIONS(213),
    [anon_sym_BSLASHsimeq] = ACTIONS(215),
    [anon_sym_u2243] = ACTIONS(215),
    [anon_sym_BSLASHsqsubset] = ACTIONS(217),
    [anon_sym_u228f] = ACTIONS(219),
    [anon_sym_BSLASHsqsupset] = ACTIONS(221),
    [anon_sym_u2290] = ACTIONS(223),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(225),
    [anon_sym_u2291] = ACTIONS(225),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(227),
    [anon_sym_u2292] = ACTIONS(227),
    [anon_sym_BSLASHsubset] = ACTIONS(229),
    [anon_sym_u2282] = ACTIONS(231),
    [anon_sym_BSLASHsupset] = ACTIONS(233),
    [anon_sym_u2283] = ACTIONS(235),
    [anon_sym_BSLASHsubseteq] = ACTIONS(237),
    [anon_sym_u2286] = ACTIONS(237),
    [anon_sym_BSLASHsupseteq] = ACTIONS(239),
    [anon_sym_u2287] = ACTIONS(239),
    [sym_compose] = ACTIONS(241),
    [sym_map_to] = ACTIONS(241),
    [sym_map_from] = ACTIONS(241),
    [sym_setminus] = ACTIONS(167),
    [anon_sym_BSLASHcap] = ACTIONS(243),
    [anon_sym_BSLASHintersect] = ACTIONS(243),
    [anon_sym_u2229] = ACTIONS(243),
    [anon_sym_BSLASHcup] = ACTIONS(245),
    [anon_sym_BSLASHunion] = ACTIONS(245),
    [anon_sym_u222a] = ACTIONS(245),
    [anon_sym_DOT_DOT] = ACTIONS(247),
    [anon_sym_u2025] = ACTIONS(249),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(251),
    [anon_sym_u2026] = ACTIONS(251),
    [anon_sym_PLUS] = ACTIONS(253),
    [sym_plusplus] = ACTIONS(241),
    [anon_sym_BSLASHoplus] = ACTIONS(255),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(255),
    [anon_sym_u2295] = ACTIONS(255),
    [anon_sym_BSLASHominus] = ACTIONS(257),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(257),
    [anon_sym_u2296] = ACTIONS(257),
    [sym_mod] = ACTIONS(167),
    [sym_modmod] = ACTIONS(241),
    [sym_vert] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_u2016] = ACTIONS(259),
    [sym_minusminus] = ACTIONS(241),
    [sym_amp] = ACTIONS(167),
    [sym_ampamp] = ACTIONS(241),
    [anon_sym_BSLASHodot] = ACTIONS(261),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(261),
    [anon_sym_u2299] = ACTIONS(261),
    [anon_sym_BSLASHoslash] = ACTIONS(263),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(263),
    [anon_sym_u2298] = ACTIONS(263),
    [anon_sym_BSLASHotimes] = ACTIONS(265),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(265),
    [anon_sym_u2297] = ACTIONS(265),
    [sym_mul] = ACTIONS(167),
    [sym_mulmul] = ACTIONS(241),
    [sym_slash] = ACTIONS(167),
    [sym_slashslash] = ACTIONS(241),
    [anon_sym_BSLASHbigcirc] = ACTIONS(267),
    [anon_sym_u25ef] = ACTIONS(267),
    [anon_sym_BSLASHbullet] = ACTIONS(269),
    [anon_sym_u25cf] = ACTIONS(269),
    [anon_sym_BSLASHdiv] = ACTIONS(271),
    [anon_sym_u00f7] = ACTIONS(271),
    [anon_sym_BSLASHcirc] = ACTIONS(273),
    [anon_sym_u2218] = ACTIONS(273),
    [anon_sym_BSLASHstar] = ACTIONS(275),
    [anon_sym_u22c6] = ACTIONS(275),
    [anon_sym_u203c] = ACTIONS(277),
    [sym_hashhash] = ACTIONS(241),
    [sym_dol] = ACTIONS(167),
    [sym_doldol] = ACTIONS(241),
    [anon_sym_QMARK_QMARK] = ACTIONS(279),
    [anon_sym_u2047] = ACTIONS(279),
    [anon_sym_BSLASHsqcap] = ACTIONS(281),
    [anon_sym_u2293] = ACTIONS(281),
    [anon_sym_BSLASHsqcup] = ACTIONS(283),
    [anon_sym_u2294] = ACTIONS(283),
    [anon_sym_BSLASHuplus] = ACTIONS(285),
    [anon_sym_u228e] = ACTIONS(285),
    [anon_sym_BSLASHX] = ACTIONS(287),
    [anon_sym_BSLASHtimes] = ACTIONS(287),
    [anon_sym_u00d7] = ACTIONS(287),
    [anon_sym_BSLASHwr] = ACTIONS(289),
    [anon_sym_u2240] = ACTIONS(289),
    [anon_sym_BSLASHcdot] = ACTIONS(291),
    [anon_sym_u22c5] = ACTIONS(291),
    [sym_pow] = ACTIONS(167),
    [sym_powpow] = ACTIONS(241),
    [anon_sym_CARET_PLUS] = ACTIONS(293),
    [anon_sym_u207a] = ACTIONS(293),
    [sym_asterisk] = ACTIONS(295),
    [sym_sup_hash] = ACTIONS(295),
    [sym_prime] = ACTIONS(295),
    [anon_sym_ASSUME] = ACTIONS(297),
    [anon_sym_DEFINE] = ACTIONS(299),
    [anon_sym_HAVE] = ACTIONS(301),
    [anon_sym_WITNESS] = ACTIONS(303),
    [anon_sym_TAKE] = ACTIONS(305),
    [anon_sym_SUFFICES] = ACTIONS(307),
    [anon_sym_PICK] = ACTIONS(309),
    [anon_sym_QED] = ACTIONS(311),
    [anon_sym_USE] = ACTIONS(313),
    [anon_sym_HIDE] = ACTIONS(313),
    [sym__indent] = ACTIONS(315),
    [sym__double_excl] = ACTIONS(277),
  },
  [3] = {
    [sym_block_comment] = STATE(3),
    [sym_forall] = STATE(4007),
    [sym_exists] = STATE(4007),
    [sym_langle_bracket] = STATE(75),
    [sym_operator_definition] = STATE(3862),
    [sym_function_definition] = STATE(3862),
    [sym_instance] = STATE(5485),
    [sym_subexpr_prefix] = STATE(1091),
    [sym_subexpr_component] = STATE(5469),
    [sym_bound_op] = STATE(2937),
    [sym_bound_nonfix_op] = STATE(2937),
    [sym_module_definition] = STATE(3862),
    [sym__expr] = STATE(1547),
    [sym_prefixed_op] = STATE(3024),
    [sym__number] = STATE(3024),
    [sym_nat_number] = STATE(3014),
    [sym_binary_number] = STATE(3014),
    [sym_octal_number] = STATE(3014),
    [sym_hex_number] = STATE(3014),
    [sym_string] = STATE(3024),
    [sym_boolean] = STATE(3024),
    [sym__number_set] = STATE(2901),
    [sym__primitive_value_set] = STATE(3024),
    [sym_nat_number_set] = STATE(2936),
    [sym_int_number_set] = STATE(2936),
    [sym_real_number_set] = STATE(2936),
    [sym_label] = STATE(3024),
    [sym_subexpression] = STATE(3024),
    [sym_parentheses] = STATE(3024),
    [sym_bounded_quantification] = STATE(3024),
    [sym_unbounded_quantification] = STATE(3024),
    [sym_choose] = STATE(3024),
    [sym_finite_set_literal] = STATE(3024),
    [sym_set_filter] = STATE(3024),
    [sym_set_map] = STATE(3024),
    [sym_function_evaluation] = STATE(3024),
    [sym_function_literal] = STATE(3024),
    [sym_set_of_functions] = STATE(3024),
    [sym_record_literal] = STATE(3024),
    [sym_set_of_records] = STATE(3024),
    [sym_record_value] = STATE(3024),
    [sym_except] = STATE(3024),
    [sym_prev_func_val] = STATE(3024),
    [sym_tuple_literal] = STATE(3024),
    [sym_step_expr_or_stutter] = STATE(3024),
    [sym_step_expr_no_stutter] = STATE(3024),
    [sym_fairness] = STATE(3024),
    [sym_if_then_else] = STATE(3024),
    [sym_case] = STATE(3024),
    [sym_let_in] = STATE(3024),
    [sym_conj_list] = STATE(3024),
    [sym_disj_list] = STATE(3024),
    [sym_lnot] = STATE(261),
    [sym_negative] = STATE(489),
    [sym_always] = STATE(260),
    [sym_eventually] = STATE(260),
    [sym_prefix_op_symbol] = STATE(4922),
    [sym_bound_prefix_op] = STATE(3024),
    [sym_implies] = STATE(3441),
    [sym_plus_arrow] = STATE(3441),
    [sym_equiv] = STATE(3441),
    [sym_iff] = STATE(3441),
    [sym_leads_to] = STATE(3441),
    [sym_land] = STATE(3441),
    [sym_lor] = STATE(3441),
    [sym_assign] = STATE(3441),
    [sym_bnf_rule] = STATE(3441),
    [sym_eq] = STATE(3441),
    [sym_neq] = STATE(3441),
    [sym_lt] = STATE(3441),
    [sym_leq] = STATE(3441),
    [sym_geq] = STATE(3441),
    [sym_approx] = STATE(3441),
    [sym_rs_ttile] = STATE(3441),
    [sym_rd_ttile] = STATE(3441),
    [sym_ls_ttile] = STATE(3441),
    [sym_ld_ttile] = STATE(3441),
    [sym_asymp] = STATE(3441),
    [sym_cong] = STATE(3441),
    [sym_doteq] = STATE(3441),
    [sym_gg] = STATE(3441),
    [sym_ll] = STATE(3441),
    [sym_in] = STATE(3441),
    [sym_notin] = STATE(3441),
    [sym_prec] = STATE(3441),
    [sym_succ] = STATE(3441),
    [sym_preceq] = STATE(3441),
    [sym_succeq] = STATE(3441),
    [sym_propto] = STATE(3441),
    [sym_sim] = STATE(3441),
    [sym_simeq] = STATE(3441),
    [sym_sqsubset] = STATE(3441),
    [sym_sqsupset] = STATE(3441),
    [sym_sqsubseteq] = STATE(3441),
    [sym_sqsupseteq] = STATE(3441),
    [sym_subset] = STATE(3441),
    [sym_supset] = STATE(3441),
    [sym_subseteq] = STATE(3441),
    [sym_supseteq] = STATE(3441),
    [sym_cap] = STATE(3441),
    [sym_cup] = STATE(3441),
    [sym_dots_2] = STATE(3441),
    [sym_dots_3] = STATE(3441),
    [sym_plus] = STATE(3441),
    [sym_oplus] = STATE(3441),
    [sym_ominus] = STATE(3441),
    [sym_vertvert] = STATE(3441),
    [sym_minus] = STATE(3441),
    [sym_odot] = STATE(3441),
    [sym_oslash] = STATE(3441),
    [sym_otimes] = STATE(3441),
    [sym_bigcirc] = STATE(3441),
    [sym_bullet] = STATE(3441),
    [sym_div] = STATE(3441),
    [sym_circ] = STATE(3441),
    [sym_star] = STATE(3441),
    [sym_excl] = STATE(3441),
    [sym_qq] = STATE(3441),
    [sym_sqcap] = STATE(3441),
    [sym_sqcup] = STATE(3441),
    [sym_uplus] = STATE(3441),
    [sym_times] = STATE(3441),
    [sym_wr] = STATE(3441),
    [sym_cdot] = STATE(3441),
    [sym_infix_op_symbol] = STATE(5052),
    [sym_bound_infix_op] = STATE(3024),
    [sym_sup_plus] = STATE(3426),
    [sym_postfix_op_symbol] = STATE(4959),
    [sym_bound_postfix_op] = STATE(3024),
    [sym_assume_prove] = STATE(3944),
    [sym_definition_proof_step] = STATE(5485),
    [sym_have_proof_step] = STATE(5485),
    [sym_witness_proof_step] = STATE(5485),
    [sym_take_proof_step] = STATE(5485),
    [sym_suffices_proof_step] = STATE(5485),
    [sym_case_proof_step] = STATE(5485),
    [sym_pick_proof_step] = STATE(5485),
    [sym_use_or_hide] = STATE(5485),
    [sym_proof_step_ref] = STATE(2968),
    [aux_sym_definition_proof_step_repeat1] = STATE(3638),
    [sym_identifier] = ACTIONS(57),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(59),
    [anon_sym_u2208] = ACTIONS(61),
    [anon_sym_BSLASHA] = ACTIONS(63),
    [anon_sym_BSLASHforall] = ACTIONS(65),
    [anon_sym_u2200] = ACTIONS(65),
    [anon_sym_BSLASHE] = ACTIONS(67),
    [anon_sym_BSLASHexists] = ACTIONS(69),
    [anon_sym_u2203] = ACTIONS(69),
    [sym_temporal_forall] = ACTIONS(71),
    [sym_temporal_exists] = ACTIONS(71),
    [anon_sym_LT_LT] = ACTIONS(73),
    [anon_sym_u3008] = ACTIONS(73),
    [anon_sym_u27e8] = ACTIONS(73),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(75),
    [anon_sym_u25a1] = ACTIONS(75),
    [anon_sym_AT] = ACTIONS(77),
    [anon_sym_SLASH_BSLASH] = ACTIONS(79),
    [anon_sym_u2227] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(81),
    [anon_sym_u2228] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_LBRACK] = ACTIONS(85),
    [anon_sym_INSTANCE] = ACTIONS(87),
    [aux_sym_child_id_token1] = ACTIONS(89),
    [sym_real_number] = ACTIONS(91),
    [anon_sym_BSLASHb] = ACTIONS(93),
    [anon_sym_BSLASHB] = ACTIONS(95),
    [anon_sym_BSLASHo] = ACTIONS(97),
    [anon_sym_BSLASHO] = ACTIONS(99),
    [anon_sym_BSLASHh] = ACTIONS(101),
    [anon_sym_BSLASHH] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_TRUE] = ACTIONS(105),
    [anon_sym_FALSE] = ACTIONS(105),
    [sym_string_set] = ACTIONS(107),
    [sym_boolean_set] = ACTIONS(107),
    [anon_sym_Nat] = ACTIONS(109),
    [anon_sym_u2115] = ACTIONS(111),
    [anon_sym_Int] = ACTIONS(113),
    [anon_sym_u2124] = ACTIONS(115),
    [anon_sym_Real] = ACTIONS(117),
    [anon_sym_u211d] = ACTIONS(119),
    [anon_sym_CHOOSE] = ACTIONS(121),
    [anon_sym_LBRACE] = ACTIONS(123),
    [anon_sym_EQ] = ACTIONS(125),
    [anon_sym_WF_] = ACTIONS(127),
    [anon_sym_SF_] = ACTIONS(127),
    [anon_sym_IF] = ACTIONS(129),
    [anon_sym_CASE] = ACTIONS(131),
    [anon_sym_LET] = ACTIONS(133),
    [anon_sym_BSLASHlnot] = ACTIONS(135),
    [anon_sym_BSLASHneg] = ACTIONS(135),
    [anon_sym_TILDE] = ACTIONS(137),
    [anon_sym_u00ac] = ACTIONS(135),
    [sym_union] = ACTIONS(139),
    [sym_powerset] = ACTIONS(139),
    [sym_domain] = ACTIONS(139),
    [anon_sym_DASH] = ACTIONS(141),
    [sym_negative_dot] = ACTIONS(41),
    [sym_enabled] = ACTIONS(143),
    [sym_unchanged] = ACTIONS(143),
    [anon_sym_LT_GT] = ACTIONS(145),
    [anon_sym_u22c4] = ACTIONS(145),
    [anon_sym_u25c7] = ACTIONS(145),
    [anon_sym_EQ_GT] = ACTIONS(147),
    [anon_sym_u27f9] = ACTIONS(147),
    [anon_sym_u21d2] = ACTIONS(147),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(149),
    [anon_sym_u21f8] = ACTIONS(149),
    [anon_sym_u2945] = ACTIONS(149),
    [anon_sym_BSLASHequiv] = ACTIONS(151),
    [anon_sym_u2261] = ACTIONS(151),
    [anon_sym_LT_EQ_GT] = ACTIONS(153),
    [anon_sym_u27fa] = ACTIONS(153),
    [anon_sym_u21d4] = ACTIONS(153),
    [anon_sym_TILDE_GT] = ACTIONS(155),
    [anon_sym_u21dd] = ACTIONS(155),
    [anon_sym_u219d] = ACTIONS(155),
    [anon_sym_BSLASHland] = ACTIONS(79),
    [anon_sym_BSLASHlor] = ACTIONS(81),
    [anon_sym_COLON_EQ] = ACTIONS(157),
    [anon_sym_u2254] = ACTIONS(157),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(159),
    [anon_sym_u2a74] = ACTIONS(159),
    [anon_sym_SLASH_EQ] = ACTIONS(161),
    [anon_sym_POUND] = ACTIONS(163),
    [anon_sym_u2260] = ACTIONS(161),
    [anon_sym_LT] = ACTIONS(165),
    [sym_gt] = ACTIONS(167),
    [anon_sym_LT_EQ] = ACTIONS(169),
    [anon_sym_EQ_LT] = ACTIONS(171),
    [anon_sym_BSLASHleq] = ACTIONS(171),
    [anon_sym_u2264] = ACTIONS(171),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_BSLASHgeq] = ACTIONS(173),
    [anon_sym_u2265] = ACTIONS(173),
    [anon_sym_BSLASHapprox] = ACTIONS(175),
    [anon_sym_u2248] = ACTIONS(175),
    [anon_sym_PIPE_DASH] = ACTIONS(177),
    [anon_sym_u22a2] = ACTIONS(177),
    [anon_sym_PIPE_EQ] = ACTIONS(179),
    [anon_sym_u22a8] = ACTIONS(179),
    [anon_sym_DASH_PIPE] = ACTIONS(181),
    [anon_sym_u22a3] = ACTIONS(181),
    [anon_sym_EQ_PIPE] = ACTIONS(183),
    [anon_sym_u2ae4] = ACTIONS(183),
    [anon_sym_BSLASHasymp] = ACTIONS(185),
    [anon_sym_u224d] = ACTIONS(185),
    [anon_sym_BSLASHcong] = ACTIONS(187),
    [anon_sym_u2245] = ACTIONS(187),
    [anon_sym_BSLASHdoteq] = ACTIONS(189),
    [anon_sym_u2250] = ACTIONS(189),
    [anon_sym_BSLASHgg] = ACTIONS(191),
    [anon_sym_u226b] = ACTIONS(191),
    [anon_sym_BSLASHll] = ACTIONS(193),
    [anon_sym_u226a] = ACTIONS(193),
    [anon_sym_BSLASHnotin] = ACTIONS(195),
    [anon_sym_u2209] = ACTIONS(195),
    [anon_sym_BSLASHprec] = ACTIONS(197),
    [anon_sym_u227a] = ACTIONS(199),
    [anon_sym_BSLASHsucc] = ACTIONS(201),
    [anon_sym_u227b] = ACTIONS(203),
    [anon_sym_BSLASHpreceq] = ACTIONS(205),
    [anon_sym_u2aaf] = ACTIONS(205),
    [anon_sym_BSLASHsucceq] = ACTIONS(207),
    [anon_sym_u2ab0] = ACTIONS(207),
    [anon_sym_BSLASHpropto] = ACTIONS(209),
    [anon_sym_u221d] = ACTIONS(209),
    [anon_sym_BSLASHsim] = ACTIONS(211),
    [anon_sym_u223c] = ACTIONS(213),
    [anon_sym_BSLASHsimeq] = ACTIONS(215),
    [anon_sym_u2243] = ACTIONS(215),
    [anon_sym_BSLASHsqsubset] = ACTIONS(217),
    [anon_sym_u228f] = ACTIONS(219),
    [anon_sym_BSLASHsqsupset] = ACTIONS(221),
    [anon_sym_u2290] = ACTIONS(223),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(225),
    [anon_sym_u2291] = ACTIONS(225),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(227),
    [anon_sym_u2292] = ACTIONS(227),
    [anon_sym_BSLASHsubset] = ACTIONS(229),
    [anon_sym_u2282] = ACTIONS(231),
    [anon_sym_BSLASHsupset] = ACTIONS(233),
    [anon_sym_u2283] = ACTIONS(235),
    [anon_sym_BSLASHsubseteq] = ACTIONS(237),
    [anon_sym_u2286] = ACTIONS(237),
    [anon_sym_BSLASHsupseteq] = ACTIONS(239),
    [anon_sym_u2287] = ACTIONS(239),
    [sym_compose] = ACTIONS(241),
    [sym_map_to] = ACTIONS(241),
    [sym_map_from] = ACTIONS(241),
    [sym_setminus] = ACTIONS(167),
    [anon_sym_BSLASHcap] = ACTIONS(243),
    [anon_sym_BSLASHintersect] = ACTIONS(243),
    [anon_sym_u2229] = ACTIONS(243),
    [anon_sym_BSLASHcup] = ACTIONS(245),
    [anon_sym_BSLASHunion] = ACTIONS(245),
    [anon_sym_u222a] = ACTIONS(245),
    [anon_sym_DOT_DOT] = ACTIONS(247),
    [anon_sym_u2025] = ACTIONS(249),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(251),
    [anon_sym_u2026] = ACTIONS(251),
    [anon_sym_PLUS] = ACTIONS(253),
    [sym_plusplus] = ACTIONS(241),
    [anon_sym_BSLASHoplus] = ACTIONS(255),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(255),
    [anon_sym_u2295] = ACTIONS(255),
    [anon_sym_BSLASHominus] = ACTIONS(257),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(257),
    [anon_sym_u2296] = ACTIONS(257),
    [sym_mod] = ACTIONS(167),
    [sym_modmod] = ACTIONS(241),
    [sym_vert] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_u2016] = ACTIONS(259),
    [sym_minusminus] = ACTIONS(241),
    [sym_amp] = ACTIONS(167),
    [sym_ampamp] = ACTIONS(241),
    [anon_sym_BSLASHodot] = ACTIONS(261),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(261),
    [anon_sym_u2299] = ACTIONS(261),
    [anon_sym_BSLASHoslash] = ACTIONS(263),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(263),
    [anon_sym_u2298] = ACTIONS(263),
    [anon_sym_BSLASHotimes] = ACTIONS(265),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(265),
    [anon_sym_u2297] = ACTIONS(265),
    [sym_mul] = ACTIONS(167),
    [sym_mulmul] = ACTIONS(241),
    [sym_slash] = ACTIONS(167),
    [sym_slashslash] = ACTIONS(241),
    [anon_sym_BSLASHbigcirc] = ACTIONS(267),
    [anon_sym_u25ef] = ACTIONS(267),
    [anon_sym_BSLASHbullet] = ACTIONS(269),
    [anon_sym_u25cf] = ACTIONS(269),
    [anon_sym_BSLASHdiv] = ACTIONS(271),
    [anon_sym_u00f7] = ACTIONS(271),
    [anon_sym_BSLASHcirc] = ACTIONS(273),
    [anon_sym_u2218] = ACTIONS(273),
    [anon_sym_BSLASHstar] = ACTIONS(275),
    [anon_sym_u22c6] = ACTIONS(275),
    [anon_sym_u203c] = ACTIONS(277),
    [sym_hashhash] = ACTIONS(241),
    [sym_dol] = ACTIONS(167),
    [sym_doldol] = ACTIONS(241),
    [anon_sym_QMARK_QMARK] = ACTIONS(279),
    [anon_sym_u2047] = ACTIONS(279),
    [anon_sym_BSLASHsqcap] = ACTIONS(281),
    [anon_sym_u2293] = ACTIONS(281),
    [anon_sym_BSLASHsqcup] = ACTIONS(283),
    [anon_sym_u2294] = ACTIONS(283),
    [anon_sym_BSLASHuplus] = ACTIONS(285),
    [anon_sym_u228e] = ACTIONS(285),
    [anon_sym_BSLASHX] = ACTIONS(287),
    [anon_sym_BSLASHtimes] = ACTIONS(287),
    [anon_sym_u00d7] = ACTIONS(287),
    [anon_sym_BSLASHwr] = ACTIONS(289),
    [anon_sym_u2240] = ACTIONS(289),
    [anon_sym_BSLASHcdot] = ACTIONS(291),
    [anon_sym_u22c5] = ACTIONS(291),
    [sym_pow] = ACTIONS(167),
    [sym_powpow] = ACTIONS(241),
    [anon_sym_CARET_PLUS] = ACTIONS(293),
    [anon_sym_u207a] = ACTIONS(293),
    [sym_asterisk] = ACTIONS(295),
    [sym_sup_hash] = ACTIONS(295),
    [sym_prime] = ACTIONS(295),
    [anon_sym_ASSUME] = ACTIONS(297),
    [anon_sym_DEFINE] = ACTIONS(299),
    [anon_sym_HAVE] = ACTIONS(301),
    [anon_sym_WITNESS] = ACTIONS(303),
    [anon_sym_TAKE] = ACTIONS(305),
    [anon_sym_SUFFICES] = ACTIONS(307),
    [anon_sym_PICK] = ACTIONS(309),
    [anon_sym_QED] = ACTIONS(317),
    [anon_sym_USE] = ACTIONS(313),
    [anon_sym_HIDE] = ACTIONS(313),
    [sym__indent] = ACTIONS(315),
    [sym__double_excl] = ACTIONS(277),
  },
  [4] = {
    [sym_block_comment] = STATE(4),
    [sym_forall] = STATE(4007),
    [sym_exists] = STATE(4007),
    [sym_langle_bracket] = STATE(75),
    [sym_operator_definition] = STATE(3862),
    [sym_function_definition] = STATE(3862),
    [sym_instance] = STATE(5485),
    [sym_subexpr_prefix] = STATE(1091),
    [sym_subexpr_component] = STATE(5469),
    [sym_bound_op] = STATE(2937),
    [sym_bound_nonfix_op] = STATE(2937),
    [sym_module_definition] = STATE(3862),
    [sym__expr] = STATE(1547),
    [sym_prefixed_op] = STATE(3024),
    [sym__number] = STATE(3024),
    [sym_nat_number] = STATE(3014),
    [sym_binary_number] = STATE(3014),
    [sym_octal_number] = STATE(3014),
    [sym_hex_number] = STATE(3014),
    [sym_string] = STATE(3024),
    [sym_boolean] = STATE(3024),
    [sym__number_set] = STATE(2901),
    [sym__primitive_value_set] = STATE(3024),
    [sym_nat_number_set] = STATE(2936),
    [sym_int_number_set] = STATE(2936),
    [sym_real_number_set] = STATE(2936),
    [sym_label] = STATE(3024),
    [sym_subexpression] = STATE(3024),
    [sym_parentheses] = STATE(3024),
    [sym_bounded_quantification] = STATE(3024),
    [sym_unbounded_quantification] = STATE(3024),
    [sym_choose] = STATE(3024),
    [sym_finite_set_literal] = STATE(3024),
    [sym_set_filter] = STATE(3024),
    [sym_set_map] = STATE(3024),
    [sym_function_evaluation] = STATE(3024),
    [sym_function_literal] = STATE(3024),
    [sym_set_of_functions] = STATE(3024),
    [sym_record_literal] = STATE(3024),
    [sym_set_of_records] = STATE(3024),
    [sym_record_value] = STATE(3024),
    [sym_except] = STATE(3024),
    [sym_prev_func_val] = STATE(3024),
    [sym_tuple_literal] = STATE(3024),
    [sym_step_expr_or_stutter] = STATE(3024),
    [sym_step_expr_no_stutter] = STATE(3024),
    [sym_fairness] = STATE(3024),
    [sym_if_then_else] = STATE(3024),
    [sym_case] = STATE(3024),
    [sym_let_in] = STATE(3024),
    [sym_conj_list] = STATE(3024),
    [sym_disj_list] = STATE(3024),
    [sym_lnot] = STATE(261),
    [sym_negative] = STATE(489),
    [sym_always] = STATE(260),
    [sym_eventually] = STATE(260),
    [sym_prefix_op_symbol] = STATE(4922),
    [sym_bound_prefix_op] = STATE(3024),
    [sym_implies] = STATE(3441),
    [sym_plus_arrow] = STATE(3441),
    [sym_equiv] = STATE(3441),
    [sym_iff] = STATE(3441),
    [sym_leads_to] = STATE(3441),
    [sym_land] = STATE(3441),
    [sym_lor] = STATE(3441),
    [sym_assign] = STATE(3441),
    [sym_bnf_rule] = STATE(3441),
    [sym_eq] = STATE(3441),
    [sym_neq] = STATE(3441),
    [sym_lt] = STATE(3441),
    [sym_leq] = STATE(3441),
    [sym_geq] = STATE(3441),
    [sym_approx] = STATE(3441),
    [sym_rs_ttile] = STATE(3441),
    [sym_rd_ttile] = STATE(3441),
    [sym_ls_ttile] = STATE(3441),
    [sym_ld_ttile] = STATE(3441),
    [sym_asymp] = STATE(3441),
    [sym_cong] = STATE(3441),
    [sym_doteq] = STATE(3441),
    [sym_gg] = STATE(3441),
    [sym_ll] = STATE(3441),
    [sym_in] = STATE(3441),
    [sym_notin] = STATE(3441),
    [sym_prec] = STATE(3441),
    [sym_succ] = STATE(3441),
    [sym_preceq] = STATE(3441),
    [sym_succeq] = STATE(3441),
    [sym_propto] = STATE(3441),
    [sym_sim] = STATE(3441),
    [sym_simeq] = STATE(3441),
    [sym_sqsubset] = STATE(3441),
    [sym_sqsupset] = STATE(3441),
    [sym_sqsubseteq] = STATE(3441),
    [sym_sqsupseteq] = STATE(3441),
    [sym_subset] = STATE(3441),
    [sym_supset] = STATE(3441),
    [sym_subseteq] = STATE(3441),
    [sym_supseteq] = STATE(3441),
    [sym_cap] = STATE(3441),
    [sym_cup] = STATE(3441),
    [sym_dots_2] = STATE(3441),
    [sym_dots_3] = STATE(3441),
    [sym_plus] = STATE(3441),
    [sym_oplus] = STATE(3441),
    [sym_ominus] = STATE(3441),
    [sym_vertvert] = STATE(3441),
    [sym_minus] = STATE(3441),
    [sym_odot] = STATE(3441),
    [sym_oslash] = STATE(3441),
    [sym_otimes] = STATE(3441),
    [sym_bigcirc] = STATE(3441),
    [sym_bullet] = STATE(3441),
    [sym_div] = STATE(3441),
    [sym_circ] = STATE(3441),
    [sym_star] = STATE(3441),
    [sym_excl] = STATE(3441),
    [sym_qq] = STATE(3441),
    [sym_sqcap] = STATE(3441),
    [sym_sqcup] = STATE(3441),
    [sym_uplus] = STATE(3441),
    [sym_times] = STATE(3441),
    [sym_wr] = STATE(3441),
    [sym_cdot] = STATE(3441),
    [sym_infix_op_symbol] = STATE(5052),
    [sym_bound_infix_op] = STATE(3024),
    [sym_sup_plus] = STATE(3426),
    [sym_postfix_op_symbol] = STATE(4959),
    [sym_bound_postfix_op] = STATE(3024),
    [sym_assume_prove] = STATE(3944),
    [sym_definition_proof_step] = STATE(5485),
    [sym_have_proof_step] = STATE(5485),
    [sym_witness_proof_step] = STATE(5485),
    [sym_take_proof_step] = STATE(5485),
    [sym_suffices_proof_step] = STATE(5485),
    [sym_case_proof_step] = STATE(5485),
    [sym_pick_proof_step] = STATE(5485),
    [sym_use_or_hide] = STATE(5485),
    [sym_proof_step_ref] = STATE(2968),
    [aux_sym_definition_proof_step_repeat1] = STATE(3638),
    [sym_identifier] = ACTIONS(57),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(59),
    [anon_sym_u2208] = ACTIONS(61),
    [anon_sym_BSLASHA] = ACTIONS(63),
    [anon_sym_BSLASHforall] = ACTIONS(65),
    [anon_sym_u2200] = ACTIONS(65),
    [anon_sym_BSLASHE] = ACTIONS(67),
    [anon_sym_BSLASHexists] = ACTIONS(69),
    [anon_sym_u2203] = ACTIONS(69),
    [sym_temporal_forall] = ACTIONS(71),
    [sym_temporal_exists] = ACTIONS(71),
    [anon_sym_LT_LT] = ACTIONS(73),
    [anon_sym_u3008] = ACTIONS(73),
    [anon_sym_u27e8] = ACTIONS(73),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(75),
    [anon_sym_u25a1] = ACTIONS(75),
    [anon_sym_AT] = ACTIONS(77),
    [anon_sym_SLASH_BSLASH] = ACTIONS(79),
    [anon_sym_u2227] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(81),
    [anon_sym_u2228] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_LBRACK] = ACTIONS(85),
    [anon_sym_INSTANCE] = ACTIONS(87),
    [aux_sym_child_id_token1] = ACTIONS(89),
    [sym_real_number] = ACTIONS(91),
    [anon_sym_BSLASHb] = ACTIONS(93),
    [anon_sym_BSLASHB] = ACTIONS(95),
    [anon_sym_BSLASHo] = ACTIONS(97),
    [anon_sym_BSLASHO] = ACTIONS(99),
    [anon_sym_BSLASHh] = ACTIONS(101),
    [anon_sym_BSLASHH] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_TRUE] = ACTIONS(105),
    [anon_sym_FALSE] = ACTIONS(105),
    [sym_string_set] = ACTIONS(107),
    [sym_boolean_set] = ACTIONS(107),
    [anon_sym_Nat] = ACTIONS(109),
    [anon_sym_u2115] = ACTIONS(111),
    [anon_sym_Int] = ACTIONS(113),
    [anon_sym_u2124] = ACTIONS(115),
    [anon_sym_Real] = ACTIONS(117),
    [anon_sym_u211d] = ACTIONS(119),
    [anon_sym_CHOOSE] = ACTIONS(121),
    [anon_sym_LBRACE] = ACTIONS(123),
    [anon_sym_EQ] = ACTIONS(125),
    [anon_sym_WF_] = ACTIONS(127),
    [anon_sym_SF_] = ACTIONS(127),
    [anon_sym_IF] = ACTIONS(129),
    [anon_sym_CASE] = ACTIONS(131),
    [anon_sym_LET] = ACTIONS(133),
    [anon_sym_BSLASHlnot] = ACTIONS(135),
    [anon_sym_BSLASHneg] = ACTIONS(135),
    [anon_sym_TILDE] = ACTIONS(137),
    [anon_sym_u00ac] = ACTIONS(135),
    [sym_union] = ACTIONS(139),
    [sym_powerset] = ACTIONS(139),
    [sym_domain] = ACTIONS(139),
    [anon_sym_DASH] = ACTIONS(141),
    [sym_negative_dot] = ACTIONS(41),
    [sym_enabled] = ACTIONS(143),
    [sym_unchanged] = ACTIONS(143),
    [anon_sym_LT_GT] = ACTIONS(145),
    [anon_sym_u22c4] = ACTIONS(145),
    [anon_sym_u25c7] = ACTIONS(145),
    [anon_sym_EQ_GT] = ACTIONS(147),
    [anon_sym_u27f9] = ACTIONS(147),
    [anon_sym_u21d2] = ACTIONS(147),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(149),
    [anon_sym_u21f8] = ACTIONS(149),
    [anon_sym_u2945] = ACTIONS(149),
    [anon_sym_BSLASHequiv] = ACTIONS(151),
    [anon_sym_u2261] = ACTIONS(151),
    [anon_sym_LT_EQ_GT] = ACTIONS(153),
    [anon_sym_u27fa] = ACTIONS(153),
    [anon_sym_u21d4] = ACTIONS(153),
    [anon_sym_TILDE_GT] = ACTIONS(155),
    [anon_sym_u21dd] = ACTIONS(155),
    [anon_sym_u219d] = ACTIONS(155),
    [anon_sym_BSLASHland] = ACTIONS(79),
    [anon_sym_BSLASHlor] = ACTIONS(81),
    [anon_sym_COLON_EQ] = ACTIONS(157),
    [anon_sym_u2254] = ACTIONS(157),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(159),
    [anon_sym_u2a74] = ACTIONS(159),
    [anon_sym_SLASH_EQ] = ACTIONS(161),
    [anon_sym_POUND] = ACTIONS(163),
    [anon_sym_u2260] = ACTIONS(161),
    [anon_sym_LT] = ACTIONS(165),
    [sym_gt] = ACTIONS(167),
    [anon_sym_LT_EQ] = ACTIONS(169),
    [anon_sym_EQ_LT] = ACTIONS(171),
    [anon_sym_BSLASHleq] = ACTIONS(171),
    [anon_sym_u2264] = ACTIONS(171),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_BSLASHgeq] = ACTIONS(173),
    [anon_sym_u2265] = ACTIONS(173),
    [anon_sym_BSLASHapprox] = ACTIONS(175),
    [anon_sym_u2248] = ACTIONS(175),
    [anon_sym_PIPE_DASH] = ACTIONS(177),
    [anon_sym_u22a2] = ACTIONS(177),
    [anon_sym_PIPE_EQ] = ACTIONS(179),
    [anon_sym_u22a8] = ACTIONS(179),
    [anon_sym_DASH_PIPE] = ACTIONS(181),
    [anon_sym_u22a3] = ACTIONS(181),
    [anon_sym_EQ_PIPE] = ACTIONS(183),
    [anon_sym_u2ae4] = ACTIONS(183),
    [anon_sym_BSLASHasymp] = ACTIONS(185),
    [anon_sym_u224d] = ACTIONS(185),
    [anon_sym_BSLASHcong] = ACTIONS(187),
    [anon_sym_u2245] = ACTIONS(187),
    [anon_sym_BSLASHdoteq] = ACTIONS(189),
    [anon_sym_u2250] = ACTIONS(189),
    [anon_sym_BSLASHgg] = ACTIONS(191),
    [anon_sym_u226b] = ACTIONS(191),
    [anon_sym_BSLASHll] = ACTIONS(193),
    [anon_sym_u226a] = ACTIONS(193),
    [anon_sym_BSLASHnotin] = ACTIONS(195),
    [anon_sym_u2209] = ACTIONS(195),
    [anon_sym_BSLASHprec] = ACTIONS(197),
    [anon_sym_u227a] = ACTIONS(199),
    [anon_sym_BSLASHsucc] = ACTIONS(201),
    [anon_sym_u227b] = ACTIONS(203),
    [anon_sym_BSLASHpreceq] = ACTIONS(205),
    [anon_sym_u2aaf] = ACTIONS(205),
    [anon_sym_BSLASHsucceq] = ACTIONS(207),
    [anon_sym_u2ab0] = ACTIONS(207),
    [anon_sym_BSLASHpropto] = ACTIONS(209),
    [anon_sym_u221d] = ACTIONS(209),
    [anon_sym_BSLASHsim] = ACTIONS(211),
    [anon_sym_u223c] = ACTIONS(213),
    [anon_sym_BSLASHsimeq] = ACTIONS(215),
    [anon_sym_u2243] = ACTIONS(215),
    [anon_sym_BSLASHsqsubset] = ACTIONS(217),
    [anon_sym_u228f] = ACTIONS(219),
    [anon_sym_BSLASHsqsupset] = ACTIONS(221),
    [anon_sym_u2290] = ACTIONS(223),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(225),
    [anon_sym_u2291] = ACTIONS(225),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(227),
    [anon_sym_u2292] = ACTIONS(227),
    [anon_sym_BSLASHsubset] = ACTIONS(229),
    [anon_sym_u2282] = ACTIONS(231),
    [anon_sym_BSLASHsupset] = ACTIONS(233),
    [anon_sym_u2283] = ACTIONS(235),
    [anon_sym_BSLASHsubseteq] = ACTIONS(237),
    [anon_sym_u2286] = ACTIONS(237),
    [anon_sym_BSLASHsupseteq] = ACTIONS(239),
    [anon_sym_u2287] = ACTIONS(239),
    [sym_compose] = ACTIONS(241),
    [sym_map_to] = ACTIONS(241),
    [sym_map_from] = ACTIONS(241),
    [sym_setminus] = ACTIONS(167),
    [anon_sym_BSLASHcap] = ACTIONS(243),
    [anon_sym_BSLASHintersect] = ACTIONS(243),
    [anon_sym_u2229] = ACTIONS(243),
    [anon_sym_BSLASHcup] = ACTIONS(245),
    [anon_sym_BSLASHunion] = ACTIONS(245),
    [anon_sym_u222a] = ACTIONS(245),
    [anon_sym_DOT_DOT] = ACTIONS(247),
    [anon_sym_u2025] = ACTIONS(249),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(251),
    [anon_sym_u2026] = ACTIONS(251),
    [anon_sym_PLUS] = ACTIONS(253),
    [sym_plusplus] = ACTIONS(241),
    [anon_sym_BSLASHoplus] = ACTIONS(255),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(255),
    [anon_sym_u2295] = ACTIONS(255),
    [anon_sym_BSLASHominus] = ACTIONS(257),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(257),
    [anon_sym_u2296] = ACTIONS(257),
    [sym_mod] = ACTIONS(167),
    [sym_modmod] = ACTIONS(241),
    [sym_vert] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_u2016] = ACTIONS(259),
    [sym_minusminus] = ACTIONS(241),
    [sym_amp] = ACTIONS(167),
    [sym_ampamp] = ACTIONS(241),
    [anon_sym_BSLASHodot] = ACTIONS(261),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(261),
    [anon_sym_u2299] = ACTIONS(261),
    [anon_sym_BSLASHoslash] = ACTIONS(263),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(263),
    [anon_sym_u2298] = ACTIONS(263),
    [anon_sym_BSLASHotimes] = ACTIONS(265),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(265),
    [anon_sym_u2297] = ACTIONS(265),
    [sym_mul] = ACTIONS(167),
    [sym_mulmul] = ACTIONS(241),
    [sym_slash] = ACTIONS(167),
    [sym_slashslash] = ACTIONS(241),
    [anon_sym_BSLASHbigcirc] = ACTIONS(267),
    [anon_sym_u25ef] = ACTIONS(267),
    [anon_sym_BSLASHbullet] = ACTIONS(269),
    [anon_sym_u25cf] = ACTIONS(269),
    [anon_sym_BSLASHdiv] = ACTIONS(271),
    [anon_sym_u00f7] = ACTIONS(271),
    [anon_sym_BSLASHcirc] = ACTIONS(273),
    [anon_sym_u2218] = ACTIONS(273),
    [anon_sym_BSLASHstar] = ACTIONS(275),
    [anon_sym_u22c6] = ACTIONS(275),
    [anon_sym_u203c] = ACTIONS(277),
    [sym_hashhash] = ACTIONS(241),
    [sym_dol] = ACTIONS(167),
    [sym_doldol] = ACTIONS(241),
    [anon_sym_QMARK_QMARK] = ACTIONS(279),
    [anon_sym_u2047] = ACTIONS(279),
    [anon_sym_BSLASHsqcap] = ACTIONS(281),
    [anon_sym_u2293] = ACTIONS(281),
    [anon_sym_BSLASHsqcup] = ACTIONS(283),
    [anon_sym_u2294] = ACTIONS(283),
    [anon_sym_BSLASHuplus] = ACTIONS(285),
    [anon_sym_u228e] = ACTIONS(285),
    [anon_sym_BSLASHX] = ACTIONS(287),
    [anon_sym_BSLASHtimes] = ACTIONS(287),
    [anon_sym_u00d7] = ACTIONS(287),
    [anon_sym_BSLASHwr] = ACTIONS(289),
    [anon_sym_u2240] = ACTIONS(289),
    [anon_sym_BSLASHcdot] = ACTIONS(291),
    [anon_sym_u22c5] = ACTIONS(291),
    [sym_pow] = ACTIONS(167),
    [sym_powpow] = ACTIONS(241),
    [anon_sym_CARET_PLUS] = ACTIONS(293),
    [anon_sym_u207a] = ACTIONS(293),
    [sym_asterisk] = ACTIONS(295),
    [sym_sup_hash] = ACTIONS(295),
    [sym_prime] = ACTIONS(295),
    [anon_sym_ASSUME] = ACTIONS(297),
    [anon_sym_DEFINE] = ACTIONS(299),
    [anon_sym_HAVE] = ACTIONS(301),
    [anon_sym_WITNESS] = ACTIONS(303),
    [anon_sym_TAKE] = ACTIONS(305),
    [anon_sym_SUFFICES] = ACTIONS(307),
    [anon_sym_PICK] = ACTIONS(309),
    [anon_sym_QED] = ACTIONS(319),
    [anon_sym_USE] = ACTIONS(313),
    [anon_sym_HIDE] = ACTIONS(313),
    [sym__indent] = ACTIONS(315),
    [sym__double_excl] = ACTIONS(277),
  },
  [5] = {
    [sym_block_comment] = STATE(5),
    [sym_forall] = STATE(4007),
    [sym_exists] = STATE(4007),
    [sym_langle_bracket] = STATE(75),
    [sym_operator_definition] = STATE(3862),
    [sym_function_definition] = STATE(3862),
    [sym_instance] = STATE(5485),
    [sym_subexpr_prefix] = STATE(1091),
    [sym_subexpr_component] = STATE(5469),
    [sym_bound_op] = STATE(2937),
    [sym_bound_nonfix_op] = STATE(2937),
    [sym_module_definition] = STATE(3862),
    [sym__expr] = STATE(1547),
    [sym_prefixed_op] = STATE(3024),
    [sym__number] = STATE(3024),
    [sym_nat_number] = STATE(3014),
    [sym_binary_number] = STATE(3014),
    [sym_octal_number] = STATE(3014),
    [sym_hex_number] = STATE(3014),
    [sym_string] = STATE(3024),
    [sym_boolean] = STATE(3024),
    [sym__number_set] = STATE(2901),
    [sym__primitive_value_set] = STATE(3024),
    [sym_nat_number_set] = STATE(2936),
    [sym_int_number_set] = STATE(2936),
    [sym_real_number_set] = STATE(2936),
    [sym_label] = STATE(3024),
    [sym_subexpression] = STATE(3024),
    [sym_parentheses] = STATE(3024),
    [sym_bounded_quantification] = STATE(3024),
    [sym_unbounded_quantification] = STATE(3024),
    [sym_choose] = STATE(3024),
    [sym_finite_set_literal] = STATE(3024),
    [sym_set_filter] = STATE(3024),
    [sym_set_map] = STATE(3024),
    [sym_function_evaluation] = STATE(3024),
    [sym_function_literal] = STATE(3024),
    [sym_set_of_functions] = STATE(3024),
    [sym_record_literal] = STATE(3024),
    [sym_set_of_records] = STATE(3024),
    [sym_record_value] = STATE(3024),
    [sym_except] = STATE(3024),
    [sym_prev_func_val] = STATE(3024),
    [sym_tuple_literal] = STATE(3024),
    [sym_step_expr_or_stutter] = STATE(3024),
    [sym_step_expr_no_stutter] = STATE(3024),
    [sym_fairness] = STATE(3024),
    [sym_if_then_else] = STATE(3024),
    [sym_case] = STATE(3024),
    [sym_let_in] = STATE(3024),
    [sym_conj_list] = STATE(3024),
    [sym_disj_list] = STATE(3024),
    [sym_lnot] = STATE(261),
    [sym_negative] = STATE(489),
    [sym_always] = STATE(260),
    [sym_eventually] = STATE(260),
    [sym_prefix_op_symbol] = STATE(4922),
    [sym_bound_prefix_op] = STATE(3024),
    [sym_implies] = STATE(3441),
    [sym_plus_arrow] = STATE(3441),
    [sym_equiv] = STATE(3441),
    [sym_iff] = STATE(3441),
    [sym_leads_to] = STATE(3441),
    [sym_land] = STATE(3441),
    [sym_lor] = STATE(3441),
    [sym_assign] = STATE(3441),
    [sym_bnf_rule] = STATE(3441),
    [sym_eq] = STATE(3441),
    [sym_neq] = STATE(3441),
    [sym_lt] = STATE(3441),
    [sym_leq] = STATE(3441),
    [sym_geq] = STATE(3441),
    [sym_approx] = STATE(3441),
    [sym_rs_ttile] = STATE(3441),
    [sym_rd_ttile] = STATE(3441),
    [sym_ls_ttile] = STATE(3441),
    [sym_ld_ttile] = STATE(3441),
    [sym_asymp] = STATE(3441),
    [sym_cong] = STATE(3441),
    [sym_doteq] = STATE(3441),
    [sym_gg] = STATE(3441),
    [sym_ll] = STATE(3441),
    [sym_in] = STATE(3441),
    [sym_notin] = STATE(3441),
    [sym_prec] = STATE(3441),
    [sym_succ] = STATE(3441),
    [sym_preceq] = STATE(3441),
    [sym_succeq] = STATE(3441),
    [sym_propto] = STATE(3441),
    [sym_sim] = STATE(3441),
    [sym_simeq] = STATE(3441),
    [sym_sqsubset] = STATE(3441),
    [sym_sqsupset] = STATE(3441),
    [sym_sqsubseteq] = STATE(3441),
    [sym_sqsupseteq] = STATE(3441),
    [sym_subset] = STATE(3441),
    [sym_supset] = STATE(3441),
    [sym_subseteq] = STATE(3441),
    [sym_supseteq] = STATE(3441),
    [sym_cap] = STATE(3441),
    [sym_cup] = STATE(3441),
    [sym_dots_2] = STATE(3441),
    [sym_dots_3] = STATE(3441),
    [sym_plus] = STATE(3441),
    [sym_oplus] = STATE(3441),
    [sym_ominus] = STATE(3441),
    [sym_vertvert] = STATE(3441),
    [sym_minus] = STATE(3441),
    [sym_odot] = STATE(3441),
    [sym_oslash] = STATE(3441),
    [sym_otimes] = STATE(3441),
    [sym_bigcirc] = STATE(3441),
    [sym_bullet] = STATE(3441),
    [sym_div] = STATE(3441),
    [sym_circ] = STATE(3441),
    [sym_star] = STATE(3441),
    [sym_excl] = STATE(3441),
    [sym_qq] = STATE(3441),
    [sym_sqcap] = STATE(3441),
    [sym_sqcup] = STATE(3441),
    [sym_uplus] = STATE(3441),
    [sym_times] = STATE(3441),
    [sym_wr] = STATE(3441),
    [sym_cdot] = STATE(3441),
    [sym_infix_op_symbol] = STATE(5052),
    [sym_bound_infix_op] = STATE(3024),
    [sym_sup_plus] = STATE(3426),
    [sym_postfix_op_symbol] = STATE(4959),
    [sym_bound_postfix_op] = STATE(3024),
    [sym_assume_prove] = STATE(3944),
    [sym_definition_proof_step] = STATE(5485),
    [sym_have_proof_step] = STATE(5485),
    [sym_witness_proof_step] = STATE(5485),
    [sym_take_proof_step] = STATE(5485),
    [sym_suffices_proof_step] = STATE(5485),
    [sym_case_proof_step] = STATE(5485),
    [sym_pick_proof_step] = STATE(5485),
    [sym_use_or_hide] = STATE(5485),
    [sym_proof_step_ref] = STATE(2968),
    [aux_sym_definition_proof_step_repeat1] = STATE(3638),
    [sym_identifier] = ACTIONS(57),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(59),
    [anon_sym_u2208] = ACTIONS(61),
    [anon_sym_BSLASHA] = ACTIONS(63),
    [anon_sym_BSLASHforall] = ACTIONS(65),
    [anon_sym_u2200] = ACTIONS(65),
    [anon_sym_BSLASHE] = ACTIONS(67),
    [anon_sym_BSLASHexists] = ACTIONS(69),
    [anon_sym_u2203] = ACTIONS(69),
    [sym_temporal_forall] = ACTIONS(71),
    [sym_temporal_exists] = ACTIONS(71),
    [anon_sym_LT_LT] = ACTIONS(73),
    [anon_sym_u3008] = ACTIONS(73),
    [anon_sym_u27e8] = ACTIONS(73),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(75),
    [anon_sym_u25a1] = ACTIONS(75),
    [anon_sym_AT] = ACTIONS(77),
    [anon_sym_SLASH_BSLASH] = ACTIONS(79),
    [anon_sym_u2227] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(81),
    [anon_sym_u2228] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_LBRACK] = ACTIONS(85),
    [anon_sym_INSTANCE] = ACTIONS(87),
    [aux_sym_child_id_token1] = ACTIONS(89),
    [sym_real_number] = ACTIONS(91),
    [anon_sym_BSLASHb] = ACTIONS(93),
    [anon_sym_BSLASHB] = ACTIONS(95),
    [anon_sym_BSLASHo] = ACTIONS(97),
    [anon_sym_BSLASHO] = ACTIONS(99),
    [anon_sym_BSLASHh] = ACTIONS(101),
    [anon_sym_BSLASHH] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(103),
    [anon_sym_TRUE] = ACTIONS(105),
    [anon_sym_FALSE] = ACTIONS(105),
    [sym_string_set] = ACTIONS(107),
    [sym_boolean_set] = ACTIONS(107),
    [anon_sym_Nat] = ACTIONS(109),
    [anon_sym_u2115] = ACTIONS(111),
    [anon_sym_Int] = ACTIONS(113),
    [anon_sym_u2124] = ACTIONS(115),
    [anon_sym_Real] = ACTIONS(117),
    [anon_sym_u211d] = ACTIONS(119),
    [anon_sym_CHOOSE] = ACTIONS(121),
    [anon_sym_LBRACE] = ACTIONS(123),
    [anon_sym_EQ] = ACTIONS(125),
    [anon_sym_WF_] = ACTIONS(127),
    [anon_sym_SF_] = ACTIONS(127),
    [anon_sym_IF] = ACTIONS(129),
    [anon_sym_CASE] = ACTIONS(131),
    [anon_sym_LET] = ACTIONS(133),
    [anon_sym_BSLASHlnot] = ACTIONS(135),
    [anon_sym_BSLASHneg] = ACTIONS(135),
    [anon_sym_TILDE] = ACTIONS(137),
    [anon_sym_u00ac] = ACTIONS(135),
    [sym_union] = ACTIONS(139),
    [sym_powerset] = ACTIONS(139),
    [sym_domain] = ACTIONS(139),
    [anon_sym_DASH] = ACTIONS(141),
    [sym_negative_dot] = ACTIONS(41),
    [sym_enabled] = ACTIONS(143),
    [sym_unchanged] = ACTIONS(143),
    [anon_sym_LT_GT] = ACTIONS(145),
    [anon_sym_u22c4] = ACTIONS(145),
    [anon_sym_u25c7] = ACTIONS(145),
    [anon_sym_EQ_GT] = ACTIONS(147),
    [anon_sym_u27f9] = ACTIONS(147),
    [anon_sym_u21d2] = ACTIONS(147),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(149),
    [anon_sym_u21f8] = ACTIONS(149),
    [anon_sym_u2945] = ACTIONS(149),
    [anon_sym_BSLASHequiv] = ACTIONS(151),
    [anon_sym_u2261] = ACTIONS(151),
    [anon_sym_LT_EQ_GT] = ACTIONS(153),
    [anon_sym_u27fa] = ACTIONS(153),
    [anon_sym_u21d4] = ACTIONS(153),
    [anon_sym_TILDE_GT] = ACTIONS(155),
    [anon_sym_u21dd] = ACTIONS(155),
    [anon_sym_u219d] = ACTIONS(155),
    [anon_sym_BSLASHland] = ACTIONS(79),
    [anon_sym_BSLASHlor] = ACTIONS(81),
    [anon_sym_COLON_EQ] = ACTIONS(157),
    [anon_sym_u2254] = ACTIONS(157),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(159),
    [anon_sym_u2a74] = ACTIONS(159),
    [anon_sym_SLASH_EQ] = ACTIONS(161),
    [anon_sym_POUND] = ACTIONS(163),
    [anon_sym_u2260] = ACTIONS(161),
    [anon_sym_LT] = ACTIONS(165),
    [sym_gt] = ACTIONS(167),
    [anon_sym_LT_EQ] = ACTIONS(169),
    [anon_sym_EQ_LT] = ACTIONS(171),
    [anon_sym_BSLASHleq] = ACTIONS(171),
    [anon_sym_u2264] = ACTIONS(171),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_BSLASHgeq] = ACTIONS(173),
    [anon_sym_u2265] = ACTIONS(173),
    [anon_sym_BSLASHapprox] = ACTIONS(175),
    [anon_sym_u2248] = ACTIONS(175),
    [anon_sym_PIPE_DASH] = ACTIONS(177),
    [anon_sym_u22a2] = ACTIONS(177),
    [anon_sym_PIPE_EQ] = ACTIONS(179),
    [anon_sym_u22a8] = ACTIONS(179),
    [anon_sym_DASH_PIPE] = ACTIONS(181),
    [anon_sym_u22a3] = ACTIONS(181),
    [anon_sym_EQ_PIPE] = ACTIONS(183),
    [anon_sym_u2ae4] = ACTIONS(183),
    [anon_sym_BSLASHasymp] = ACTIONS(185),
    [anon_sym_u224d] = ACTIONS(185),
    [anon_sym_BSLASHcong] = ACTIONS(187),
    [anon_sym_u2245] = ACTIONS(187),
    [anon_sym_BSLASHdoteq] = ACTIONS(189),
    [anon_sym_u2250] = ACTIONS(189),
    [anon_sym_BSLASHgg] = ACTIONS(191),
    [anon_sym_u226b] = ACTIONS(191),
    [anon_sym_BSLASHll] = ACTIONS(193),
    [anon_sym_u226a] = ACTIONS(193),
    [anon_sym_BSLASHnotin] = ACTIONS(195),
    [anon_sym_u2209] = ACTIONS(195),
    [anon_sym_BSLASHprec] = ACTIONS(197),
    [anon_sym_u227a] = ACTIONS(199),
    [anon_sym_BSLASHsucc] = ACTIONS(201),
    [anon_sym_u227b] = ACTIONS(203),
    [anon_sym_BSLASHpreceq] = ACTIONS(205),
    [anon_sym_u2aaf] = ACTIONS(205),
    [anon_sym_BSLASHsucceq] = ACTIONS(207),
    [anon_sym_u2ab0] = ACTIONS(207),
    [anon_sym_BSLASHpropto] = ACTIONS(209),
    [anon_sym_u221d] = ACTIONS(209),
    [anon_sym_BSLASHsim] = ACTIONS(211),
    [anon_sym_u223c] = ACTIONS(213),
    [anon_sym_BSLASHsimeq] = ACTIONS(215),
    [anon_sym_u2243] = ACTIONS(215),
    [anon_sym_BSLASHsqsubset] = ACTIONS(217),
    [anon_sym_u228f] = ACTIONS(219),
    [anon_sym_BSLASHsqsupset] = ACTIONS(221),
    [anon_sym_u2290] = ACTIONS(223),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(225),
    [anon_sym_u2291] = ACTIONS(225),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(227),
    [anon_sym_u2292] = ACTIONS(227),
    [anon_sym_BSLASHsubset] = ACTIONS(229),
    [anon_sym_u2282] = ACTIONS(231),
    [anon_sym_BSLASHsupset] = ACTIONS(233),
    [anon_sym_u2283] = ACTIONS(235),
    [anon_sym_BSLASHsubseteq] = ACTIONS(237),
    [anon_sym_u2286] = ACTIONS(237),
    [anon_sym_BSLASHsupseteq] = ACTIONS(239),
    [anon_sym_u2287] = ACTIONS(239),
    [sym_compose] = ACTIONS(241),
    [sym_map_to] = ACTIONS(241),
    [sym_map_from] = ACTIONS(241),
    [sym_setminus] = ACTIONS(167),
    [anon_sym_BSLASHcap] = ACTIONS(243),
    [anon_sym_BSLASHintersect] = ACTIONS(243),
    [anon_sym_u2229] = ACTIONS(243),
    [anon_sym_BSLASHcup] = ACTIONS(245),
    [anon_sym_BSLASHunion] = ACTIONS(245),
    [anon_sym_u222a] = ACTIONS(245),
    [anon_sym_DOT_DOT] = ACTIONS(247),
    [anon_sym_u2025] = ACTIONS(249),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(251),
    [anon_sym_u2026] = ACTIONS(251),
    [anon_sym_PLUS] = ACTIONS(253),
    [sym_plusplus] = ACTIONS(241),
    [anon_sym_BSLASHoplus] = ACTIONS(255),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(255),
    [anon_sym_u2295] = ACTIONS(255),
    [anon_sym_BSLASHominus] = ACTIONS(257),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(257),
    [anon_sym_u2296] = ACTIONS(257),
    [sym_mod] = ACTIONS(167),
    [sym_modmod] = ACTIONS(241),
    [sym_vert] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_u2016] = ACTIONS(259),
    [sym_minusminus] = ACTIONS(241),
    [sym_amp] = ACTIONS(167),
    [sym_ampamp] = ACTIONS(241),
    [anon_sym_BSLASHodot] = ACTIONS(261),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(261),
    [anon_sym_u2299] = ACTIONS(261),
    [anon_sym_BSLASHoslash] = ACTIONS(263),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(263),
    [anon_sym_u2298] = ACTIONS(263),
    [anon_sym_BSLASHotimes] = ACTIONS(265),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(265),
    [anon_sym_u2297] = ACTIONS(265),
    [sym_mul] = ACTIONS(167),
    [sym_mulmul] = ACTIONS(241),
    [sym_slash] = ACTIONS(167),
    [sym_slashslash] = ACTIONS(241),
    [anon_sym_BSLASHbigcirc] = ACTIONS(267),
    [anon_sym_u25ef] = ACTIONS(267),
    [anon_sym_BSLASHbullet] = ACTIONS(269),
    [anon_sym_u25cf] = ACTIONS(269),
    [anon_sym_BSLASHdiv] = ACTIONS(271),
    [anon_sym_u00f7] = ACTIONS(271),
    [anon_sym_BSLASHcirc] = ACTIONS(273),
    [anon_sym_u2218] = ACTIONS(273),
    [anon_sym_BSLASHstar] = ACTIONS(275),
    [anon_sym_u22c6] = ACTIONS(275),
    [anon_sym_u203c] = ACTIONS(277),
    [sym_hashhash] = ACTIONS(241),
    [sym_dol] = ACTIONS(167),
    [sym_doldol] = ACTIONS(241),
    [anon_sym_QMARK_QMARK] = ACTIONS(279),
    [anon_sym_u2047] = ACTIONS(279),
    [anon_sym_BSLASHsqcap] = ACTIONS(281),
    [anon_sym_u2293] = ACTIONS(281),
    [anon_sym_BSLASHsqcup] = ACTIONS(283),
    [anon_sym_u2294] = ACTIONS(283),
    [anon_sym_BSLASHuplus] = ACTIONS(285),
    [anon_sym_u228e] = ACTIONS(285),
    [anon_sym_BSLASHX] = ACTIONS(287),
    [anon_sym_BSLASHtimes] = ACTIONS(287),
    [anon_sym_u00d7] = ACTIONS(287),
    [anon_sym_BSLASHwr] = ACTIONS(289),
    [anon_sym_u2240] = ACTIONS(289),
    [anon_sym_BSLASHcdot] = ACTIONS(291),
    [anon_sym_u22c5] = ACTIONS(291),
    [sym_pow] = ACTIONS(167),
    [sym_powpow] = ACTIONS(241),
    [anon_sym_CARET_PLUS] = ACTIONS(293),
    [anon_sym_u207a] = ACTIONS(293),
    [sym_asterisk] = ACTIONS(295),
    [sym_sup_hash] = ACTIONS(295),
    [sym_prime] = ACTIONS(295),
    [anon_sym_ASSUME] = ACTIONS(297),
    [anon_sym_DEFINE] = ACTIONS(299),
    [anon_sym_HAVE] = ACTIONS(301),
    [anon_sym_WITNESS] = ACTIONS(303),
    [anon_sym_TAKE] = ACTIONS(305),
    [anon_sym_SUFFICES] = ACTIONS(307),
    [anon_sym_PICK] = ACTIONS(309),
    [anon_sym_USE] = ACTIONS(313),
    [anon_sym_HIDE] = ACTIONS(313),
    [sym__indent] = ACTIONS(315),
    [sym__double_excl] = ACTIONS(277),
  },
  [6] = {
    [sym_block_comment] = STATE(6),
    [sym_forall] = STATE(3984),
    [sym_exists] = STATE(3984),
    [sym_langle_bracket] = STATE(76),
    [sym_subexpr_prefix] = STATE(1092),
    [sym_subexpr_component] = STATE(5469),
    [sym_bound_op] = STATE(2377),
    [sym_bound_nonfix_op] = STATE(2377),
    [sym__expr] = STATE(1258),
    [sym_prefixed_op] = STATE(2405),
    [sym__number] = STATE(2405),
    [sym_nat_number] = STATE(2399),
    [sym_binary_number] = STATE(2399),
    [sym_octal_number] = STATE(2399),
    [sym_hex_number] = STATE(2399),
    [sym_string] = STATE(2405),
    [sym_boolean] = STATE(2405),
    [sym__number_set] = STATE(2404),
    [sym__primitive_value_set] = STATE(2405),
    [sym_nat_number_set] = STATE(2490),
    [sym_int_number_set] = STATE(2490),
    [sym_real_number_set] = STATE(2490),
    [sym_label] = STATE(2405),
    [sym_subexpression] = STATE(2405),
    [sym_parentheses] = STATE(2405),
    [sym_bounded_quantification] = STATE(2405),
    [sym_unbounded_quantification] = STATE(2405),
    [sym_choose] = STATE(2405),
    [sym_finite_set_literal] = STATE(2405),
    [sym_set_filter] = STATE(2405),
    [sym_set_map] = STATE(2405),
    [sym_function_evaluation] = STATE(2405),
    [sym_function_literal] = STATE(2405),
    [sym_set_of_functions] = STATE(2405),
    [sym_record_literal] = STATE(2405),
    [sym_set_of_records] = STATE(2405),
    [sym_record_value] = STATE(2405),
    [sym_except] = STATE(2405),
    [sym_prev_func_val] = STATE(2405),
    [sym_tuple_literal] = STATE(2405),
    [sym_step_expr_or_stutter] = STATE(2405),
    [sym_step_expr_no_stutter] = STATE(2405),
    [sym_fairness] = STATE(2405),
    [sym_if_then_else] = STATE(2405),
    [sym_case] = STATE(2405),
    [sym_let_in] = STATE(2405),
    [sym_conj_list] = STATE(2405),
    [sym_disj_list] = STATE(2405),
    [sym_lnot] = STATE(264),
    [sym_negative] = STATE(517),
    [sym_always] = STATE(263),
    [sym_eventually] = STATE(263),
    [sym_prefix_op_symbol] = STATE(4965),
    [sym_bound_prefix_op] = STATE(2405),
    [sym_implies] = STATE(3441),
    [sym_plus_arrow] = STATE(3441),
    [sym_equiv] = STATE(3441),
    [sym_iff] = STATE(3441),
    [sym_leads_to] = STATE(3441),
    [sym_land] = STATE(3441),
    [sym_lor] = STATE(3441),
    [sym_assign] = STATE(3441),
    [sym_bnf_rule] = STATE(3441),
    [sym_eq] = STATE(3441),
    [sym_neq] = STATE(3441),
    [sym_lt] = STATE(3441),
    [sym_leq] = STATE(3441),
    [sym_geq] = STATE(3441),
    [sym_approx] = STATE(3441),
    [sym_rs_ttile] = STATE(3441),
    [sym_rd_ttile] = STATE(3441),
    [sym_ls_ttile] = STATE(3441),
    [sym_ld_ttile] = STATE(3441),
    [sym_asymp] = STATE(3441),
    [sym_cong] = STATE(3441),
    [sym_doteq] = STATE(3441),
    [sym_gg] = STATE(3441),
    [sym_ll] = STATE(3441),
    [sym_in] = STATE(3441),
    [sym_notin] = STATE(3441),
    [sym_prec] = STATE(3441),
    [sym_succ] = STATE(3441),
    [sym_preceq] = STATE(3441),
    [sym_succeq] = STATE(3441),
    [sym_propto] = STATE(3441),
    [sym_sim] = STATE(3441),
    [sym_simeq] = STATE(3441),
    [sym_sqsubset] = STATE(3441),
    [sym_sqsupset] = STATE(3441),
    [sym_sqsubseteq] = STATE(3441),
    [sym_sqsupseteq] = STATE(3441),
    [sym_subset] = STATE(3441),
    [sym_supset] = STATE(3441),
    [sym_subseteq] = STATE(3441),
    [sym_supseteq] = STATE(3441),
    [sym_cap] = STATE(3441),
    [sym_cup] = STATE(3441),
    [sym_dots_2] = STATE(3441),
    [sym_dots_3] = STATE(3441),
    [sym_plus] = STATE(3441),
    [sym_oplus] = STATE(3441),
    [sym_ominus] = STATE(3441),
    [sym_vertvert] = STATE(3441),
    [sym_minus] = STATE(3441),
    [sym_odot] = STATE(3441),
    [sym_oslash] = STATE(3441),
    [sym_otimes] = STATE(3441),
    [sym_bigcirc] = STATE(3441),
    [sym_bullet] = STATE(3441),
    [sym_div] = STATE(3441),
    [sym_circ] = STATE(3441),
    [sym_star] = STATE(3441),
    [sym_excl] = STATE(3441),
    [sym_qq] = STATE(3441),
    [sym_sqcap] = STATE(3441),
    [sym_sqcup] = STATE(3441),
    [sym_uplus] = STATE(3441),
    [sym_times] = STATE(3441),
    [sym_wr] = STATE(3441),
    [sym_cdot] = STATE(3441),
    [sym_infix_op_symbol] = STATE(5053),
    [sym_bound_infix_op] = STATE(2405),
    [sym_sup_plus] = STATE(3426),
    [sym_postfix_op_symbol] = STATE(4965),
    [sym_bound_postfix_op] = STATE(2405),
    [sym_proof_step_ref] = STATE(2378),
    [sym_identifier] = ACTIONS(321),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_DASH_DASH_DASH_DASH] = ACTIONS(324),
    [anon_sym_EQ_EQ_EQ_EQ] = ACTIONS(324),
    [anon_sym_BSLASHin] = ACTIONS(59),
    [anon_sym_u2208] = ACTIONS(61),
    [anon_sym_BSLASHA] = ACTIONS(63),
    [anon_sym_BSLASHforall] = ACTIONS(65),
    [anon_sym_u2200] = ACTIONS(65),
    [anon_sym_BSLASHE] = ACTIONS(67),
    [anon_sym_BSLASHexists] = ACTIONS(69),
    [anon_sym_u2203] = ACTIONS(69),
    [sym_temporal_forall] = ACTIONS(326),
    [sym_temporal_exists] = ACTIONS(326),
    [anon_sym_LT_LT] = ACTIONS(73),
    [anon_sym_u3008] = ACTIONS(73),
    [anon_sym_u27e8] = ACTIONS(73),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(328),
    [anon_sym_u25a1] = ACTIONS(328),
    [anon_sym_AT] = ACTIONS(331),
    [anon_sym_SLASH_BSLASH] = ACTIONS(79),
    [anon_sym_u2227] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(81),
    [anon_sym_u2228] = ACTIONS(81),
    [anon_sym_COMMA] = ACTIONS(324),
    [anon_sym_LOCAL] = ACTIONS(333),
    [anon_sym_VARIABLE] = ACTIONS(333),
    [anon_sym_VARIABLES] = ACTIONS(333),
    [anon_sym_CONSTANT] = ACTIONS(333),
    [anon_sym_CONSTANTS] = ACTIONS(333),
    [anon_sym_RECURSIVE] = ACTIONS(333),
    [anon_sym_LPAREN] = ACTIONS(335),
    [anon_sym_LBRACK] = ACTIONS(338),
    [anon_sym_INSTANCE] = ACTIONS(333),
    [anon_sym_BANG] = ACTIONS(324),
    [aux_sym_child_id_token1] = ACTIONS(340),
    [sym_real_number] = ACTIONS(342),
    [anon_sym_BSLASHb] = ACTIONS(344),
    [anon_sym_BSLASHB] = ACTIONS(346),
    [anon_sym_BSLASHo] = ACTIONS(348),
    [anon_sym_BSLASHO] = ACTIONS(350),
    [anon_sym_BSLASHh] = ACTIONS(352),
    [anon_sym_BSLASHH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_TRUE] = ACTIONS(356),
    [anon_sym_FALSE] = ACTIONS(356),
    [sym_string_set] = ACTIONS(358),
    [sym_boolean_set] = ACTIONS(358),
    [anon_sym_Nat] = ACTIONS(360),
    [anon_sym_u2115] = ACTIONS(363),
    [anon_sym_Int] = ACTIONS(366),
    [anon_sym_u2124] = ACTIONS(369),
    [anon_sym_Real] = ACTIONS(372),
    [anon_sym_u211d] = ACTIONS(375),
    [anon_sym_CHOOSE] = ACTIONS(378),
    [anon_sym_LBRACE] = ACTIONS(380),
    [anon_sym_EQ] = ACTIONS(125),
    [anon_sym_WF_] = ACTIONS(382),
    [anon_sym_SF_] = ACTIONS(382),
    [anon_sym_IF] = ACTIONS(384),
    [anon_sym_CASE] = ACTIONS(386),
    [anon_sym_LET] = ACTIONS(388),
    [anon_sym_BSLASHlnot] = ACTIONS(390),
    [anon_sym_BSLASHneg] = ACTIONS(390),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_u00ac] = ACTIONS(390),
    [sym_union] = ACTIONS(396),
    [sym_powerset] = ACTIONS(396),
    [sym_domain] = ACTIONS(396),
    [anon_sym_DASH] = ACTIONS(141),
    [sym_negative_dot] = ACTIONS(399),
    [sym_enabled] = ACTIONS(402),
    [sym_unchanged] = ACTIONS(402),
    [anon_sym_LT_GT] = ACTIONS(405),
    [anon_sym_u22c4] = ACTIONS(405),
    [anon_sym_u25c7] = ACTIONS(405),
    [anon_sym_EQ_GT] = ACTIONS(147),
    [anon_sym_u27f9] = ACTIONS(147),
    [anon_sym_u21d2] = ACTIONS(147),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(149),
    [anon_sym_u21f8] = ACTIONS(149),
    [anon_sym_u2945] = ACTIONS(149),
    [anon_sym_BSLASHequiv] = ACTIONS(151),
    [anon_sym_u2261] = ACTIONS(151),
    [anon_sym_LT_EQ_GT] = ACTIONS(153),
    [anon_sym_u27fa] = ACTIONS(153),
    [anon_sym_u21d4] = ACTIONS(153),
    [anon_sym_TILDE_GT] = ACTIONS(155),
    [anon_sym_u21dd] = ACTIONS(155),
    [anon_sym_u219d] = ACTIONS(155),
    [anon_sym_BSLASHland] = ACTIONS(79),
    [anon_sym_BSLASHlor] = ACTIONS(81),
    [anon_sym_COLON_EQ] = ACTIONS(157),
    [anon_sym_u2254] = ACTIONS(157),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(159),
    [anon_sym_u2a74] = ACTIONS(159),
    [anon_sym_SLASH_EQ] = ACTIONS(161),
    [anon_sym_POUND] = ACTIONS(163),
    [anon_sym_u2260] = ACTIONS(161),
    [anon_sym_LT] = ACTIONS(408),
    [sym_gt] = ACTIONS(167),
    [anon_sym_LT_EQ] = ACTIONS(169),
    [anon_sym_EQ_LT] = ACTIONS(171),
    [anon_sym_BSLASHleq] = ACTIONS(171),
    [anon_sym_u2264] = ACTIONS(171),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_BSLASHgeq] = ACTIONS(173),
    [anon_sym_u2265] = ACTIONS(173),
    [anon_sym_BSLASHapprox] = ACTIONS(175),
    [anon_sym_u2248] = ACTIONS(175),
    [anon_sym_PIPE_DASH] = ACTIONS(177),
    [anon_sym_u22a2] = ACTIONS(177),
    [anon_sym_PIPE_EQ] = ACTIONS(179),
    [anon_sym_u22a8] = ACTIONS(179),
    [anon_sym_DASH_PIPE] = ACTIONS(181),
    [anon_sym_u22a3] = ACTIONS(181),
    [anon_sym_EQ_PIPE] = ACTIONS(183),
    [anon_sym_u2ae4] = ACTIONS(183),
    [anon_sym_BSLASHasymp] = ACTIONS(185),
    [anon_sym_u224d] = ACTIONS(185),
    [anon_sym_BSLASHcong] = ACTIONS(187),
    [anon_sym_u2245] = ACTIONS(187),
    [anon_sym_BSLASHdoteq] = ACTIONS(189),
    [anon_sym_u2250] = ACTIONS(189),
    [anon_sym_BSLASHgg] = ACTIONS(191),
    [anon_sym_u226b] = ACTIONS(191),
    [anon_sym_BSLASHll] = ACTIONS(193),
    [anon_sym_u226a] = ACTIONS(193),
    [anon_sym_BSLASHnotin] = ACTIONS(195),
    [anon_sym_u2209] = ACTIONS(195),
    [anon_sym_BSLASHprec] = ACTIONS(197),
    [anon_sym_u227a] = ACTIONS(199),
    [anon_sym_BSLASHsucc] = ACTIONS(201),
    [anon_sym_u227b] = ACTIONS(203),
    [anon_sym_BSLASHpreceq] = ACTIONS(205),
    [anon_sym_u2aaf] = ACTIONS(205),
    [anon_sym_BSLASHsucceq] = ACTIONS(207),
    [anon_sym_u2ab0] = ACTIONS(207),
    [anon_sym_BSLASHpropto] = ACTIONS(209),
    [anon_sym_u221d] = ACTIONS(209),
    [anon_sym_BSLASHsim] = ACTIONS(211),
    [anon_sym_u223c] = ACTIONS(213),
    [anon_sym_BSLASHsimeq] = ACTIONS(215),
    [anon_sym_u2243] = ACTIONS(215),
    [anon_sym_BSLASHsqsubset] = ACTIONS(217),
    [anon_sym_u228f] = ACTIONS(219),
    [anon_sym_BSLASHsqsupset] = ACTIONS(221),
    [anon_sym_u2290] = ACTIONS(223),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(225),
    [anon_sym_u2291] = ACTIONS(225),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(227),
    [anon_sym_u2292] = ACTIONS(227),
    [anon_sym_BSLASHsubset] = ACTIONS(229),
    [anon_sym_u2282] = ACTIONS(231),
    [anon_sym_BSLASHsupset] = ACTIONS(233),
    [anon_sym_u2283] = ACTIONS(235),
    [anon_sym_BSLASHsubseteq] = ACTIONS(237),
    [anon_sym_u2286] = ACTIONS(237),
    [anon_sym_BSLASHsupseteq] = ACTIONS(239),
    [anon_sym_u2287] = ACTIONS(239),
    [sym_compose] = ACTIONS(241),
    [sym_map_to] = ACTIONS(241),
    [sym_map_from] = ACTIONS(241),
    [sym_setminus] = ACTIONS(167),
    [anon_sym_BSLASHcap] = ACTIONS(243),
    [anon_sym_BSLASHintersect] = ACTIONS(243),
    [anon_sym_u2229] = ACTIONS(243),
    [anon_sym_BSLASHcup] = ACTIONS(245),
    [anon_sym_BSLASHunion] = ACTIONS(245),
    [anon_sym_u222a] = ACTIONS(245),
    [anon_sym_DOT_DOT] = ACTIONS(247),
    [anon_sym_u2025] = ACTIONS(249),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(251),
    [anon_sym_u2026] = ACTIONS(251),
    [anon_sym_PLUS] = ACTIONS(253),
    [sym_plusplus] = ACTIONS(241),
    [anon_sym_BSLASHoplus] = ACTIONS(255),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(255),
    [anon_sym_u2295] = ACTIONS(255),
    [anon_sym_BSLASHominus] = ACTIONS(257),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(257),
    [anon_sym_u2296] = ACTIONS(257),
    [sym_mod] = ACTIONS(167),
    [sym_modmod] = ACTIONS(241),
    [sym_vert] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_u2016] = ACTIONS(259),
    [sym_minusminus] = ACTIONS(167),
    [sym_amp] = ACTIONS(167),
    [sym_ampamp] = ACTIONS(241),
    [anon_sym_BSLASHodot] = ACTIONS(261),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(261),
    [anon_sym_u2299] = ACTIONS(261),
    [anon_sym_BSLASHoslash] = ACTIONS(263),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(263),
    [anon_sym_u2298] = ACTIONS(263),
    [anon_sym_BSLASHotimes] = ACTIONS(265),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(265),
    [anon_sym_u2297] = ACTIONS(265),
    [sym_mul] = ACTIONS(167),
    [sym_mulmul] = ACTIONS(241),
    [sym_slash] = ACTIONS(167),
    [sym_slashslash] = ACTIONS(241),
    [anon_sym_BSLASHbigcirc] = ACTIONS(267),
    [anon_sym_u25ef] = ACTIONS(267),
    [anon_sym_BSLASHbullet] = ACTIONS(269),
    [anon_sym_u25cf] = ACTIONS(269),
    [anon_sym_BSLASHdiv] = ACTIONS(271),
    [anon_sym_u00f7] = ACTIONS(271),
    [anon_sym_BSLASHcirc] = ACTIONS(273),
    [anon_sym_u2218] = ACTIONS(273),
    [anon_sym_BSLASHstar] = ACTIONS(275),
    [anon_sym_u22c6] = ACTIONS(275),
    [anon_sym_u203c] = ACTIONS(277),
    [sym_hashhash] = ACTIONS(241),
    [sym_dol] = ACTIONS(167),
    [sym_doldol] = ACTIONS(241),
    [anon_sym_QMARK_QMARK] = ACTIONS(279),
    [anon_sym_u2047] = ACTIONS(279),
    [anon_sym_BSLASHsqcap] = ACTIONS(281),
    [anon_sym_u2293] = ACTIONS(281),
    [anon_sym_BSLASHsqcup] = ACTIONS(283),
    [anon_sym_u2294] = ACTIONS(283),
    [anon_sym_BSLASHuplus] = ACTIONS(285),
    [anon_sym_u228e] = ACTIONS(285),
    [anon_sym_BSLASHX] = ACTIONS(287),
    [anon_sym_BSLASHtimes] = ACTIONS(287),
    [anon_sym_u00d7] = ACTIONS(287),
    [anon_sym_BSLASHwr] = ACTIONS(289),
    [anon_sym_u2240] = ACTIONS(289),
    [anon_sym_BSLASHcdot] = ACTIONS(291),
    [anon_sym_u22c5] = ACTIONS(291),
    [sym_pow] = ACTIONS(167),
    [sym_powpow] = ACTIONS(241),
    [anon_sym_CARET_PLUS] = ACTIONS(293),
    [anon_sym_u207a] = ACTIONS(293),
    [sym_asterisk] = ACTIONS(295),
    [sym_sup_hash] = ACTIONS(295),
    [sym_prime] = ACTIONS(295),
    [anon_sym_ASSUME] = ACTIONS(333),
    [anon_sym_ASSUMPTION] = ACTIONS(333),
    [anon_sym_AXIOM] = ACTIONS(333),
    [anon_sym_THEOREM] = ACTIONS(333),
    [anon_sym_PROPOSITION] = ACTIONS(333),
    [anon_sym_LEMMA] = ACTIONS(333),
    [anon_sym_COROLLARY] = ACTIONS(333),
    [anon_sym_USE] = ACTIONS(333),
    [anon_sym_HIDE] = ACTIONS(333),
    [sym__indent] = ACTIONS(410),
    [sym__double_excl] = ACTIONS(277),
  },
  [7] = {
    [sym_block_comment] = STATE(7),
    [sym_forall] = STATE(3984),
    [sym_exists] = STATE(3984),
    [sym_langle_bracket] = STATE(76),
    [sym_subexpr_prefix] = STATE(1092),
    [sym_subexpr_component] = STATE(5469),
    [sym_bound_op] = STATE(2377),
    [sym_bound_nonfix_op] = STATE(2377),
    [sym__expr] = STATE(1260),
    [sym_prefixed_op] = STATE(2405),
    [sym__number] = STATE(2405),
    [sym_nat_number] = STATE(2399),
    [sym_binary_number] = STATE(2399),
    [sym_octal_number] = STATE(2399),
    [sym_hex_number] = STATE(2399),
    [sym_string] = STATE(2405),
    [sym_boolean] = STATE(2405),
    [sym__number_set] = STATE(2404),
    [sym__primitive_value_set] = STATE(2405),
    [sym_nat_number_set] = STATE(2490),
    [sym_int_number_set] = STATE(2490),
    [sym_real_number_set] = STATE(2490),
    [sym_label] = STATE(2405),
    [sym_subexpression] = STATE(2405),
    [sym_parentheses] = STATE(2405),
    [sym_bounded_quantification] = STATE(2405),
    [sym_unbounded_quantification] = STATE(2405),
    [sym_choose] = STATE(2405),
    [sym_finite_set_literal] = STATE(2405),
    [sym_set_filter] = STATE(2405),
    [sym_set_map] = STATE(2405),
    [sym_function_evaluation] = STATE(2405),
    [sym_function_literal] = STATE(2405),
    [sym_set_of_functions] = STATE(2405),
    [sym_record_literal] = STATE(2405),
    [sym_set_of_records] = STATE(2405),
    [sym_record_value] = STATE(2405),
    [sym_except] = STATE(2405),
    [sym_prev_func_val] = STATE(2405),
    [sym_tuple_literal] = STATE(2405),
    [sym_step_expr_or_stutter] = STATE(2405),
    [sym_step_expr_no_stutter] = STATE(2405),
    [sym_fairness] = STATE(2405),
    [sym_if_then_else] = STATE(2405),
    [sym_case] = STATE(2405),
    [sym_let_in] = STATE(2405),
    [sym_conj_list] = STATE(2405),
    [sym_disj_list] = STATE(2405),
    [sym_lnot] = STATE(264),
    [sym_negative] = STATE(517),
    [sym_always] = STATE(263),
    [sym_eventually] = STATE(263),
    [sym_prefix_op_symbol] = STATE(4965),
    [sym_bound_prefix_op] = STATE(2405),
    [sym_implies] = STATE(3441),
    [sym_plus_arrow] = STATE(3441),
    [sym_equiv] = STATE(3441),
    [sym_iff] = STATE(3441),
    [sym_leads_to] = STATE(3441),
    [sym_land] = STATE(3441),
    [sym_lor] = STATE(3441),
    [sym_assign] = STATE(3441),
    [sym_bnf_rule] = STATE(3441),
    [sym_eq] = STATE(3441),
    [sym_neq] = STATE(3441),
    [sym_lt] = STATE(3441),
    [sym_leq] = STATE(3441),
    [sym_geq] = STATE(3441),
    [sym_approx] = STATE(3441),
    [sym_rs_ttile] = STATE(3441),
    [sym_rd_ttile] = STATE(3441),
    [sym_ls_ttile] = STATE(3441),
    [sym_ld_ttile] = STATE(3441),
    [sym_asymp] = STATE(3441),
    [sym_cong] = STATE(3441),
    [sym_doteq] = STATE(3441),
    [sym_gg] = STATE(3441),
    [sym_ll] = STATE(3441),
    [sym_in] = STATE(3441),
    [sym_notin] = STATE(3441),
    [sym_prec] = STATE(3441),
    [sym_succ] = STATE(3441),
    [sym_preceq] = STATE(3441),
    [sym_succeq] = STATE(3441),
    [sym_propto] = STATE(3441),
    [sym_sim] = STATE(3441),
    [sym_simeq] = STATE(3441),
    [sym_sqsubset] = STATE(3441),
    [sym_sqsupset] = STATE(3441),
    [sym_sqsubseteq] = STATE(3441),
    [sym_sqsupseteq] = STATE(3441),
    [sym_subset] = STATE(3441),
    [sym_supset] = STATE(3441),
    [sym_subseteq] = STATE(3441),
    [sym_supseteq] = STATE(3441),
    [sym_cap] = STATE(3441),
    [sym_cup] = STATE(3441),
    [sym_dots_2] = STATE(3441),
    [sym_dots_3] = STATE(3441),
    [sym_plus] = STATE(3441),
    [sym_oplus] = STATE(3441),
    [sym_ominus] = STATE(3441),
    [sym_vertvert] = STATE(3441),
    [sym_minus] = STATE(3441),
    [sym_odot] = STATE(3441),
    [sym_oslash] = STATE(3441),
    [sym_otimes] = STATE(3441),
    [sym_bigcirc] = STATE(3441),
    [sym_bullet] = STATE(3441),
    [sym_div] = STATE(3441),
    [sym_circ] = STATE(3441),
    [sym_star] = STATE(3441),
    [sym_excl] = STATE(3441),
    [sym_qq] = STATE(3441),
    [sym_sqcap] = STATE(3441),
    [sym_sqcup] = STATE(3441),
    [sym_uplus] = STATE(3441),
    [sym_times] = STATE(3441),
    [sym_wr] = STATE(3441),
    [sym_cdot] = STATE(3441),
    [sym_infix_op_symbol] = STATE(5053),
    [sym_bound_infix_op] = STATE(2405),
    [sym_sup_plus] = STATE(3426),
    [sym_postfix_op_symbol] = STATE(4965),
    [sym_bound_postfix_op] = STATE(2405),
    [sym_proof_step_ref] = STATE(2378),
    [sym_identifier] = ACTIONS(321),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_DASH_DASH_DASH_DASH] = ACTIONS(324),
    [anon_sym_EQ_EQ_EQ_EQ] = ACTIONS(324),
    [anon_sym_BSLASHin] = ACTIONS(59),
    [anon_sym_u2208] = ACTIONS(61),
    [anon_sym_BSLASHA] = ACTIONS(63),
    [anon_sym_BSLASHforall] = ACTIONS(65),
    [anon_sym_u2200] = ACTIONS(65),
    [anon_sym_BSLASHE] = ACTIONS(67),
    [anon_sym_BSLASHexists] = ACTIONS(69),
    [anon_sym_u2203] = ACTIONS(69),
    [sym_temporal_forall] = ACTIONS(326),
    [sym_temporal_exists] = ACTIONS(326),
    [anon_sym_LT_LT] = ACTIONS(73),
    [anon_sym_u3008] = ACTIONS(73),
    [anon_sym_u27e8] = ACTIONS(73),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(328),
    [anon_sym_u25a1] = ACTIONS(328),
    [anon_sym_AT] = ACTIONS(331),
    [anon_sym_SLASH_BSLASH] = ACTIONS(79),
    [anon_sym_u2227] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(81),
    [anon_sym_u2228] = ACTIONS(81),
    [anon_sym_COMMA] = ACTIONS(324),
    [anon_sym_LOCAL] = ACTIONS(333),
    [anon_sym_VARIABLE] = ACTIONS(333),
    [anon_sym_VARIABLES] = ACTIONS(333),
    [anon_sym_CONSTANT] = ACTIONS(333),
    [anon_sym_CONSTANTS] = ACTIONS(333),
    [anon_sym_RECURSIVE] = ACTIONS(333),
    [anon_sym_LPAREN] = ACTIONS(335),
    [anon_sym_LBRACK] = ACTIONS(338),
    [anon_sym_INSTANCE] = ACTIONS(333),
    [anon_sym_BANG] = ACTIONS(324),
    [aux_sym_child_id_token1] = ACTIONS(340),
    [sym_real_number] = ACTIONS(342),
    [anon_sym_BSLASHb] = ACTIONS(344),
    [anon_sym_BSLASHB] = ACTIONS(346),
    [anon_sym_BSLASHo] = ACTIONS(348),
    [anon_sym_BSLASHO] = ACTIONS(350),
    [anon_sym_BSLASHh] = ACTIONS(352),
    [anon_sym_BSLASHH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_TRUE] = ACTIONS(356),
    [anon_sym_FALSE] = ACTIONS(356),
    [sym_string_set] = ACTIONS(358),
    [sym_boolean_set] = ACTIONS(358),
    [anon_sym_Nat] = ACTIONS(360),
    [anon_sym_u2115] = ACTIONS(363),
    [anon_sym_Int] = ACTIONS(366),
    [anon_sym_u2124] = ACTIONS(369),
    [anon_sym_Real] = ACTIONS(372),
    [anon_sym_u211d] = ACTIONS(375),
    [anon_sym_CHOOSE] = ACTIONS(378),
    [anon_sym_LBRACE] = ACTIONS(380),
    [anon_sym_EQ] = ACTIONS(125),
    [anon_sym_WF_] = ACTIONS(382),
    [anon_sym_SF_] = ACTIONS(382),
    [anon_sym_IF] = ACTIONS(384),
    [anon_sym_CASE] = ACTIONS(386),
    [anon_sym_LET] = ACTIONS(388),
    [anon_sym_BSLASHlnot] = ACTIONS(390),
    [anon_sym_BSLASHneg] = ACTIONS(390),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_u00ac] = ACTIONS(390),
    [sym_union] = ACTIONS(396),
    [sym_powerset] = ACTIONS(396),
    [sym_domain] = ACTIONS(396),
    [anon_sym_DASH] = ACTIONS(141),
    [sym_negative_dot] = ACTIONS(399),
    [sym_enabled] = ACTIONS(402),
    [sym_unchanged] = ACTIONS(402),
    [anon_sym_LT_GT] = ACTIONS(405),
    [anon_sym_u22c4] = ACTIONS(405),
    [anon_sym_u25c7] = ACTIONS(405),
    [anon_sym_EQ_GT] = ACTIONS(147),
    [anon_sym_u27f9] = ACTIONS(147),
    [anon_sym_u21d2] = ACTIONS(147),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(149),
    [anon_sym_u21f8] = ACTIONS(149),
    [anon_sym_u2945] = ACTIONS(149),
    [anon_sym_BSLASHequiv] = ACTIONS(151),
    [anon_sym_u2261] = ACTIONS(151),
    [anon_sym_LT_EQ_GT] = ACTIONS(153),
    [anon_sym_u27fa] = ACTIONS(153),
    [anon_sym_u21d4] = ACTIONS(153),
    [anon_sym_TILDE_GT] = ACTIONS(155),
    [anon_sym_u21dd] = ACTIONS(155),
    [anon_sym_u219d] = ACTIONS(155),
    [anon_sym_BSLASHland] = ACTIONS(79),
    [anon_sym_BSLASHlor] = ACTIONS(81),
    [anon_sym_COLON_EQ] = ACTIONS(157),
    [anon_sym_u2254] = ACTIONS(157),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(159),
    [anon_sym_u2a74] = ACTIONS(159),
    [anon_sym_SLASH_EQ] = ACTIONS(161),
    [anon_sym_POUND] = ACTIONS(163),
    [anon_sym_u2260] = ACTIONS(161),
    [anon_sym_LT] = ACTIONS(408),
    [sym_gt] = ACTIONS(167),
    [anon_sym_LT_EQ] = ACTIONS(169),
    [anon_sym_EQ_LT] = ACTIONS(171),
    [anon_sym_BSLASHleq] = ACTIONS(171),
    [anon_sym_u2264] = ACTIONS(171),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_BSLASHgeq] = ACTIONS(173),
    [anon_sym_u2265] = ACTIONS(173),
    [anon_sym_BSLASHapprox] = ACTIONS(175),
    [anon_sym_u2248] = ACTIONS(175),
    [anon_sym_PIPE_DASH] = ACTIONS(177),
    [anon_sym_u22a2] = ACTIONS(177),
    [anon_sym_PIPE_EQ] = ACTIONS(179),
    [anon_sym_u22a8] = ACTIONS(179),
    [anon_sym_DASH_PIPE] = ACTIONS(181),
    [anon_sym_u22a3] = ACTIONS(181),
    [anon_sym_EQ_PIPE] = ACTIONS(183),
    [anon_sym_u2ae4] = ACTIONS(183),
    [anon_sym_BSLASHasymp] = ACTIONS(185),
    [anon_sym_u224d] = ACTIONS(185),
    [anon_sym_BSLASHcong] = ACTIONS(187),
    [anon_sym_u2245] = ACTIONS(187),
    [anon_sym_BSLASHdoteq] = ACTIONS(189),
    [anon_sym_u2250] = ACTIONS(189),
    [anon_sym_BSLASHgg] = ACTIONS(191),
    [anon_sym_u226b] = ACTIONS(191),
    [anon_sym_BSLASHll] = ACTIONS(193),
    [anon_sym_u226a] = ACTIONS(193),
    [anon_sym_BSLASHnotin] = ACTIONS(195),
    [anon_sym_u2209] = ACTIONS(195),
    [anon_sym_BSLASHprec] = ACTIONS(197),
    [anon_sym_u227a] = ACTIONS(199),
    [anon_sym_BSLASHsucc] = ACTIONS(201),
    [anon_sym_u227b] = ACTIONS(203),
    [anon_sym_BSLASHpreceq] = ACTIONS(205),
    [anon_sym_u2aaf] = ACTIONS(205),
    [anon_sym_BSLASHsucceq] = ACTIONS(207),
    [anon_sym_u2ab0] = ACTIONS(207),
    [anon_sym_BSLASHpropto] = ACTIONS(209),
    [anon_sym_u221d] = ACTIONS(209),
    [anon_sym_BSLASHsim] = ACTIONS(211),
    [anon_sym_u223c] = ACTIONS(213),
    [anon_sym_BSLASHsimeq] = ACTIONS(215),
    [anon_sym_u2243] = ACTIONS(215),
    [anon_sym_BSLASHsqsubset] = ACTIONS(217),
    [anon_sym_u228f] = ACTIONS(219),
    [anon_sym_BSLASHsqsupset] = ACTIONS(221),
    [anon_sym_u2290] = ACTIONS(223),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(225),
    [anon_sym_u2291] = ACTIONS(225),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(227),
    [anon_sym_u2292] = ACTIONS(227),
    [anon_sym_BSLASHsubset] = ACTIONS(229),
    [anon_sym_u2282] = ACTIONS(231),
    [anon_sym_BSLASHsupset] = ACTIONS(233),
    [anon_sym_u2283] = ACTIONS(235),
    [anon_sym_BSLASHsubseteq] = ACTIONS(237),
    [anon_sym_u2286] = ACTIONS(237),
    [anon_sym_BSLASHsupseteq] = ACTIONS(239),
    [anon_sym_u2287] = ACTIONS(239),
    [sym_compose] = ACTIONS(241),
    [sym_map_to] = ACTIONS(241),
    [sym_map_from] = ACTIONS(241),
    [sym_setminus] = ACTIONS(167),
    [anon_sym_BSLASHcap] = ACTIONS(243),
    [anon_sym_BSLASHintersect] = ACTIONS(243),
    [anon_sym_u2229] = ACTIONS(243),
    [anon_sym_BSLASHcup] = ACTIONS(245),
    [anon_sym_BSLASHunion] = ACTIONS(245),
    [anon_sym_u222a] = ACTIONS(245),
    [anon_sym_DOT_DOT] = ACTIONS(247),
    [anon_sym_u2025] = ACTIONS(249),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(251),
    [anon_sym_u2026] = ACTIONS(251),
    [anon_sym_PLUS] = ACTIONS(253),
    [sym_plusplus] = ACTIONS(241),
    [anon_sym_BSLASHoplus] = ACTIONS(255),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(255),
    [anon_sym_u2295] = ACTIONS(255),
    [anon_sym_BSLASHominus] = ACTIONS(257),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(257),
    [anon_sym_u2296] = ACTIONS(257),
    [sym_mod] = ACTIONS(167),
    [sym_modmod] = ACTIONS(241),
    [sym_vert] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_u2016] = ACTIONS(259),
    [sym_minusminus] = ACTIONS(167),
    [sym_amp] = ACTIONS(167),
    [sym_ampamp] = ACTIONS(241),
    [anon_sym_BSLASHodot] = ACTIONS(261),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(261),
    [anon_sym_u2299] = ACTIONS(261),
    [anon_sym_BSLASHoslash] = ACTIONS(263),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(263),
    [anon_sym_u2298] = ACTIONS(263),
    [anon_sym_BSLASHotimes] = ACTIONS(265),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(265),
    [anon_sym_u2297] = ACTIONS(265),
    [sym_mul] = ACTIONS(167),
    [sym_mulmul] = ACTIONS(241),
    [sym_slash] = ACTIONS(167),
    [sym_slashslash] = ACTIONS(241),
    [anon_sym_BSLASHbigcirc] = ACTIONS(267),
    [anon_sym_u25ef] = ACTIONS(267),
    [anon_sym_BSLASHbullet] = ACTIONS(269),
    [anon_sym_u25cf] = ACTIONS(269),
    [anon_sym_BSLASHdiv] = ACTIONS(271),
    [anon_sym_u00f7] = ACTIONS(271),
    [anon_sym_BSLASHcirc] = ACTIONS(273),
    [anon_sym_u2218] = ACTIONS(273),
    [anon_sym_BSLASHstar] = ACTIONS(275),
    [anon_sym_u22c6] = ACTIONS(275),
    [anon_sym_u203c] = ACTIONS(277),
    [sym_hashhash] = ACTIONS(241),
    [sym_dol] = ACTIONS(167),
    [sym_doldol] = ACTIONS(241),
    [anon_sym_QMARK_QMARK] = ACTIONS(279),
    [anon_sym_u2047] = ACTIONS(279),
    [anon_sym_BSLASHsqcap] = ACTIONS(281),
    [anon_sym_u2293] = ACTIONS(281),
    [anon_sym_BSLASHsqcup] = ACTIONS(283),
    [anon_sym_u2294] = ACTIONS(283),
    [anon_sym_BSLASHuplus] = ACTIONS(285),
    [anon_sym_u228e] = ACTIONS(285),
    [anon_sym_BSLASHX] = ACTIONS(287),
    [anon_sym_BSLASHtimes] = ACTIONS(287),
    [anon_sym_u00d7] = ACTIONS(287),
    [anon_sym_BSLASHwr] = ACTIONS(289),
    [anon_sym_u2240] = ACTIONS(289),
    [anon_sym_BSLASHcdot] = ACTIONS(291),
    [anon_sym_u22c5] = ACTIONS(291),
    [sym_pow] = ACTIONS(167),
    [sym_powpow] = ACTIONS(241),
    [anon_sym_CARET_PLUS] = ACTIONS(293),
    [anon_sym_u207a] = ACTIONS(293),
    [sym_asterisk] = ACTIONS(295),
    [sym_sup_hash] = ACTIONS(295),
    [sym_prime] = ACTIONS(295),
    [anon_sym_ASSUME] = ACTIONS(333),
    [anon_sym_ASSUMPTION] = ACTIONS(333),
    [anon_sym_AXIOM] = ACTIONS(333),
    [anon_sym_THEOREM] = ACTIONS(333),
    [anon_sym_PROPOSITION] = ACTIONS(333),
    [anon_sym_LEMMA] = ACTIONS(333),
    [anon_sym_COROLLARY] = ACTIONS(333),
    [anon_sym_USE] = ACTIONS(333),
    [anon_sym_HIDE] = ACTIONS(333),
    [sym__indent] = ACTIONS(410),
    [sym__double_excl] = ACTIONS(277),
  },
  [8] = {
    [sym_block_comment] = STATE(8),
    [sym_forall] = STATE(4003),
    [sym_exists] = STATE(4003),
    [sym_langle_bracket] = STATE(54),
    [sym_subexpr_prefix] = STATE(1098),
    [sym_subexpr_component] = STATE(5469),
    [sym_bound_op] = STATE(2383),
    [sym_bound_nonfix_op] = STATE(2383),
    [sym__expr] = STATE(1240),
    [sym_prefixed_op] = STATE(2406),
    [sym__number] = STATE(2406),
    [sym_nat_number] = STATE(2459),
    [sym_binary_number] = STATE(2459),
    [sym_octal_number] = STATE(2459),
    [sym_hex_number] = STATE(2459),
    [sym_string] = STATE(2406),
    [sym_boolean] = STATE(2406),
    [sym__number_set] = STATE(2463),
    [sym__primitive_value_set] = STATE(2406),
    [sym_nat_number_set] = STATE(2400),
    [sym_int_number_set] = STATE(2400),
    [sym_real_number_set] = STATE(2400),
    [sym_label] = STATE(2406),
    [sym_subexpression] = STATE(2406),
    [sym_parentheses] = STATE(2406),
    [sym_bounded_quantification] = STATE(2406),
    [sym_unbounded_quantification] = STATE(2406),
    [sym_choose] = STATE(2406),
    [sym_finite_set_literal] = STATE(2406),
    [sym_set_filter] = STATE(2406),
    [sym_set_map] = STATE(2406),
    [sym_function_evaluation] = STATE(2406),
    [sym_function_literal] = STATE(2406),
    [sym_set_of_functions] = STATE(2406),
    [sym_record_literal] = STATE(2406),
    [sym_set_of_records] = STATE(2406),
    [sym_record_value] = STATE(2406),
    [sym_except] = STATE(2406),
    [sym_prev_func_val] = STATE(2406),
    [sym_tuple_literal] = STATE(2406),
    [sym_step_expr_or_stutter] = STATE(2406),
    [sym_step_expr_no_stutter] = STATE(2406),
    [sym_fairness] = STATE(2406),
    [sym_if_then_else] = STATE(2406),
    [sym_case] = STATE(2406),
    [sym_let_in] = STATE(2406),
    [sym_conj_list] = STATE(2406),
    [sym_disj_list] = STATE(2406),
    [sym_lnot] = STATE(292),
    [sym_negative] = STATE(807),
    [sym_always] = STATE(245),
    [sym_eventually] = STATE(245),
    [sym_prefix_op_symbol] = STATE(4944),
    [sym_bound_prefix_op] = STATE(2406),
    [sym_implies] = STATE(3441),
    [sym_plus_arrow] = STATE(3441),
    [sym_equiv] = STATE(3441),
    [sym_iff] = STATE(3441),
    [sym_leads_to] = STATE(3441),
    [sym_land] = STATE(3441),
    [sym_lor] = STATE(3441),
    [sym_assign] = STATE(3441),
    [sym_bnf_rule] = STATE(3441),
    [sym_eq] = STATE(3441),
    [sym_neq] = STATE(3441),
    [sym_lt] = STATE(3441),
    [sym_leq] = STATE(3441),
    [sym_geq] = STATE(3441),
    [sym_approx] = STATE(3441),
    [sym_rs_ttile] = STATE(3441),
    [sym_rd_ttile] = STATE(3441),
    [sym_ls_ttile] = STATE(3441),
    [sym_ld_ttile] = STATE(3441),
    [sym_asymp] = STATE(3441),
    [sym_cong] = STATE(3441),
    [sym_doteq] = STATE(3441),
    [sym_gg] = STATE(3441),
    [sym_ll] = STATE(3441),
    [sym_in] = STATE(3441),
    [sym_notin] = STATE(3441),
    [sym_prec] = STATE(3441),
    [sym_succ] = STATE(3441),
    [sym_preceq] = STATE(3441),
    [sym_succeq] = STATE(3441),
    [sym_propto] = STATE(3441),
    [sym_sim] = STATE(3441),
    [sym_simeq] = STATE(3441),
    [sym_sqsubset] = STATE(3441),
    [sym_sqsupset] = STATE(3441),
    [sym_sqsubseteq] = STATE(3441),
    [sym_sqsupseteq] = STATE(3441),
    [sym_subset] = STATE(3441),
    [sym_supset] = STATE(3441),
    [sym_subseteq] = STATE(3441),
    [sym_supseteq] = STATE(3441),
    [sym_cap] = STATE(3441),
    [sym_cup] = STATE(3441),
    [sym_dots_2] = STATE(3441),
    [sym_dots_3] = STATE(3441),
    [sym_plus] = STATE(3441),
    [sym_oplus] = STATE(3441),
    [sym_ominus] = STATE(3441),
    [sym_vertvert] = STATE(3441),
    [sym_minus] = STATE(3441),
    [sym_odot] = STATE(3441),
    [sym_oslash] = STATE(3441),
    [sym_otimes] = STATE(3441),
    [sym_bigcirc] = STATE(3441),
    [sym_bullet] = STATE(3441),
    [sym_div] = STATE(3441),
    [sym_circ] = STATE(3441),
    [sym_star] = STATE(3441),
    [sym_excl] = STATE(3441),
    [sym_qq] = STATE(3441),
    [sym_sqcap] = STATE(3441),
    [sym_sqcup] = STATE(3441),
    [sym_uplus] = STATE(3441),
    [sym_times] = STATE(3441),
    [sym_wr] = STATE(3441),
    [sym_cdot] = STATE(3441),
    [sym_infix_op_symbol] = STATE(4945),
    [sym_bound_infix_op] = STATE(2406),
    [sym_sup_plus] = STATE(3426),
    [sym_postfix_op_symbol] = STATE(4944),
    [sym_bound_postfix_op] = STATE(2406),
    [sym_proof_step_ref] = STATE(2384),
    [ts_builtin_sym_end] = ACTIONS(324),
    [sym_identifier] = ACTIONS(412),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_DASH_DASH_DASH_DASH] = ACTIONS(324),
    [anon_sym_BSLASHin] = ACTIONS(59),
    [anon_sym_u2208] = ACTIONS(61),
    [anon_sym_BSLASHA] = ACTIONS(63),
    [anon_sym_BSLASHforall] = ACTIONS(65),
    [anon_sym_u2200] = ACTIONS(65),
    [anon_sym_BSLASHE] = ACTIONS(67),
    [anon_sym_BSLASHexists] = ACTIONS(69),
    [anon_sym_u2203] = ACTIONS(69),
    [sym_temporal_forall] = ACTIONS(415),
    [sym_temporal_exists] = ACTIONS(415),
    [anon_sym_LT_LT] = ACTIONS(73),
    [anon_sym_u3008] = ACTIONS(73),
    [anon_sym_u27e8] = ACTIONS(73),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(328),
    [anon_sym_u25a1] = ACTIONS(328),
    [anon_sym_AT] = ACTIONS(417),
    [anon_sym_SLASH_BSLASH] = ACTIONS(79),
    [anon_sym_u2227] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(81),
    [anon_sym_u2228] = ACTIONS(81),
    [anon_sym_COMMA] = ACTIONS(324),
    [anon_sym_LOCAL] = ACTIONS(333),
    [anon_sym_VARIABLE] = ACTIONS(333),
    [anon_sym_VARIABLES] = ACTIONS(333),
    [anon_sym_CONSTANT] = ACTIONS(333),
    [anon_sym_CONSTANTS] = ACTIONS(333),
    [anon_sym_RECURSIVE] = ACTIONS(333),
    [anon_sym_LPAREN] = ACTIONS(419),
    [anon_sym_LBRACK] = ACTIONS(422),
    [anon_sym_INSTANCE] = ACTIONS(333),
    [anon_sym_BANG] = ACTIONS(324),
    [aux_sym_child_id_token1] = ACTIONS(424),
    [sym_real_number] = ACTIONS(426),
    [anon_sym_BSLASHb] = ACTIONS(428),
    [anon_sym_BSLASHB] = ACTIONS(430),
    [anon_sym_BSLASHo] = ACTIONS(432),
    [anon_sym_BSLASHO] = ACTIONS(434),
    [anon_sym_BSLASHh] = ACTIONS(436),
    [anon_sym_BSLASHH] = ACTIONS(436),
    [anon_sym_DQUOTE] = ACTIONS(438),
    [anon_sym_TRUE] = ACTIONS(440),
    [anon_sym_FALSE] = ACTIONS(440),
    [sym_string_set] = ACTIONS(442),
    [sym_boolean_set] = ACTIONS(442),
    [anon_sym_Nat] = ACTIONS(444),
    [anon_sym_u2115] = ACTIONS(447),
    [anon_sym_Int] = ACTIONS(450),
    [anon_sym_u2124] = ACTIONS(453),
    [anon_sym_Real] = ACTIONS(456),
    [anon_sym_u211d] = ACTIONS(459),
    [anon_sym_CHOOSE] = ACTIONS(462),
    [anon_sym_LBRACE] = ACTIONS(464),
    [anon_sym_EQ] = ACTIONS(125),
    [anon_sym_WF_] = ACTIONS(466),
    [anon_sym_SF_] = ACTIONS(466),
    [anon_sym_IF] = ACTIONS(468),
    [anon_sym_CASE] = ACTIONS(470),
    [anon_sym_LET] = ACTIONS(472),
    [anon_sym_BSLASHlnot] = ACTIONS(390),
    [anon_sym_BSLASHneg] = ACTIONS(390),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_u00ac] = ACTIONS(390),
    [sym_union] = ACTIONS(474),
    [sym_powerset] = ACTIONS(474),
    [sym_domain] = ACTIONS(474),
    [anon_sym_DASH] = ACTIONS(141),
    [sym_negative_dot] = ACTIONS(399),
    [sym_enabled] = ACTIONS(477),
    [sym_unchanged] = ACTIONS(477),
    [anon_sym_LT_GT] = ACTIONS(405),
    [anon_sym_u22c4] = ACTIONS(405),
    [anon_sym_u25c7] = ACTIONS(405),
    [anon_sym_EQ_GT] = ACTIONS(147),
    [anon_sym_u27f9] = ACTIONS(147),
    [anon_sym_u21d2] = ACTIONS(147),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(149),
    [anon_sym_u21f8] = ACTIONS(149),
    [anon_sym_u2945] = ACTIONS(149),
    [anon_sym_BSLASHequiv] = ACTIONS(151),
    [anon_sym_u2261] = ACTIONS(151),
    [anon_sym_LT_EQ_GT] = ACTIONS(153),
    [anon_sym_u27fa] = ACTIONS(153),
    [anon_sym_u21d4] = ACTIONS(153),
    [anon_sym_TILDE_GT] = ACTIONS(155),
    [anon_sym_u21dd] = ACTIONS(155),
    [anon_sym_u219d] = ACTIONS(155),
    [anon_sym_BSLASHland] = ACTIONS(79),
    [anon_sym_BSLASHlor] = ACTIONS(81),
    [anon_sym_COLON_EQ] = ACTIONS(157),
    [anon_sym_u2254] = ACTIONS(157),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(159),
    [anon_sym_u2a74] = ACTIONS(159),
    [anon_sym_SLASH_EQ] = ACTIONS(161),
    [anon_sym_POUND] = ACTIONS(163),
    [anon_sym_u2260] = ACTIONS(161),
    [anon_sym_LT] = ACTIONS(480),
    [sym_gt] = ACTIONS(167),
    [anon_sym_LT_EQ] = ACTIONS(169),
    [anon_sym_EQ_LT] = ACTIONS(171),
    [anon_sym_BSLASHleq] = ACTIONS(171),
    [anon_sym_u2264] = ACTIONS(171),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_BSLASHgeq] = ACTIONS(173),
    [anon_sym_u2265] = ACTIONS(173),
    [anon_sym_BSLASHapprox] = ACTIONS(175),
    [anon_sym_u2248] = ACTIONS(175),
    [anon_sym_PIPE_DASH] = ACTIONS(177),
    [anon_sym_u22a2] = ACTIONS(177),
    [anon_sym_PIPE_EQ] = ACTIONS(179),
    [anon_sym_u22a8] = ACTIONS(179),
    [anon_sym_DASH_PIPE] = ACTIONS(181),
    [anon_sym_u22a3] = ACTIONS(181),
    [anon_sym_EQ_PIPE] = ACTIONS(183),
    [anon_sym_u2ae4] = ACTIONS(183),
    [anon_sym_BSLASHasymp] = ACTIONS(185),
    [anon_sym_u224d] = ACTIONS(185),
    [anon_sym_BSLASHcong] = ACTIONS(187),
    [anon_sym_u2245] = ACTIONS(187),
    [anon_sym_BSLASHdoteq] = ACTIONS(189),
    [anon_sym_u2250] = ACTIONS(189),
    [anon_sym_BSLASHgg] = ACTIONS(191),
    [anon_sym_u226b] = ACTIONS(191),
    [anon_sym_BSLASHll] = ACTIONS(193),
    [anon_sym_u226a] = ACTIONS(193),
    [anon_sym_BSLASHnotin] = ACTIONS(195),
    [anon_sym_u2209] = ACTIONS(195),
    [anon_sym_BSLASHprec] = ACTIONS(197),
    [anon_sym_u227a] = ACTIONS(199),
    [anon_sym_BSLASHsucc] = ACTIONS(201),
    [anon_sym_u227b] = ACTIONS(203),
    [anon_sym_BSLASHpreceq] = ACTIONS(205),
    [anon_sym_u2aaf] = ACTIONS(205),
    [anon_sym_BSLASHsucceq] = ACTIONS(207),
    [anon_sym_u2ab0] = ACTIONS(207),
    [anon_sym_BSLASHpropto] = ACTIONS(209),
    [anon_sym_u221d] = ACTIONS(209),
    [anon_sym_BSLASHsim] = ACTIONS(211),
    [anon_sym_u223c] = ACTIONS(213),
    [anon_sym_BSLASHsimeq] = ACTIONS(215),
    [anon_sym_u2243] = ACTIONS(215),
    [anon_sym_BSLASHsqsubset] = ACTIONS(217),
    [anon_sym_u228f] = ACTIONS(219),
    [anon_sym_BSLASHsqsupset] = ACTIONS(221),
    [anon_sym_u2290] = ACTIONS(223),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(225),
    [anon_sym_u2291] = ACTIONS(225),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(227),
    [anon_sym_u2292] = ACTIONS(227),
    [anon_sym_BSLASHsubset] = ACTIONS(229),
    [anon_sym_u2282] = ACTIONS(231),
    [anon_sym_BSLASHsupset] = ACTIONS(233),
    [anon_sym_u2283] = ACTIONS(235),
    [anon_sym_BSLASHsubseteq] = ACTIONS(237),
    [anon_sym_u2286] = ACTIONS(237),
    [anon_sym_BSLASHsupseteq] = ACTIONS(239),
    [anon_sym_u2287] = ACTIONS(239),
    [sym_compose] = ACTIONS(241),
    [sym_map_to] = ACTIONS(241),
    [sym_map_from] = ACTIONS(241),
    [sym_setminus] = ACTIONS(167),
    [anon_sym_BSLASHcap] = ACTIONS(243),
    [anon_sym_BSLASHintersect] = ACTIONS(243),
    [anon_sym_u2229] = ACTIONS(243),
    [anon_sym_BSLASHcup] = ACTIONS(245),
    [anon_sym_BSLASHunion] = ACTIONS(245),
    [anon_sym_u222a] = ACTIONS(245),
    [anon_sym_DOT_DOT] = ACTIONS(247),
    [anon_sym_u2025] = ACTIONS(249),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(251),
    [anon_sym_u2026] = ACTIONS(251),
    [anon_sym_PLUS] = ACTIONS(253),
    [sym_plusplus] = ACTIONS(241),
    [anon_sym_BSLASHoplus] = ACTIONS(255),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(255),
    [anon_sym_u2295] = ACTIONS(255),
    [anon_sym_BSLASHominus] = ACTIONS(257),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(257),
    [anon_sym_u2296] = ACTIONS(257),
    [sym_mod] = ACTIONS(167),
    [sym_modmod] = ACTIONS(241),
    [sym_vert] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_u2016] = ACTIONS(259),
    [sym_minusminus] = ACTIONS(167),
    [sym_amp] = ACTIONS(167),
    [sym_ampamp] = ACTIONS(241),
    [anon_sym_BSLASHodot] = ACTIONS(261),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(261),
    [anon_sym_u2299] = ACTIONS(261),
    [anon_sym_BSLASHoslash] = ACTIONS(263),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(263),
    [anon_sym_u2298] = ACTIONS(263),
    [anon_sym_BSLASHotimes] = ACTIONS(265),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(265),
    [anon_sym_u2297] = ACTIONS(265),
    [sym_mul] = ACTIONS(167),
    [sym_mulmul] = ACTIONS(241),
    [sym_slash] = ACTIONS(167),
    [sym_slashslash] = ACTIONS(241),
    [anon_sym_BSLASHbigcirc] = ACTIONS(267),
    [anon_sym_u25ef] = ACTIONS(267),
    [anon_sym_BSLASHbullet] = ACTIONS(269),
    [anon_sym_u25cf] = ACTIONS(269),
    [anon_sym_BSLASHdiv] = ACTIONS(271),
    [anon_sym_u00f7] = ACTIONS(271),
    [anon_sym_BSLASHcirc] = ACTIONS(273),
    [anon_sym_u2218] = ACTIONS(273),
    [anon_sym_BSLASHstar] = ACTIONS(275),
    [anon_sym_u22c6] = ACTIONS(275),
    [anon_sym_u203c] = ACTIONS(277),
    [sym_hashhash] = ACTIONS(241),
    [sym_dol] = ACTIONS(167),
    [sym_doldol] = ACTIONS(241),
    [anon_sym_QMARK_QMARK] = ACTIONS(279),
    [anon_sym_u2047] = ACTIONS(279),
    [anon_sym_BSLASHsqcap] = ACTIONS(281),
    [anon_sym_u2293] = ACTIONS(281),
    [anon_sym_BSLASHsqcup] = ACTIONS(283),
    [anon_sym_u2294] = ACTIONS(283),
    [anon_sym_BSLASHuplus] = ACTIONS(285),
    [anon_sym_u228e] = ACTIONS(285),
    [anon_sym_BSLASHX] = ACTIONS(287),
    [anon_sym_BSLASHtimes] = ACTIONS(287),
    [anon_sym_u00d7] = ACTIONS(287),
    [anon_sym_BSLASHwr] = ACTIONS(289),
    [anon_sym_u2240] = ACTIONS(289),
    [anon_sym_BSLASHcdot] = ACTIONS(291),
    [anon_sym_u22c5] = ACTIONS(291),
    [sym_pow] = ACTIONS(167),
    [sym_powpow] = ACTIONS(241),
    [anon_sym_CARET_PLUS] = ACTIONS(293),
    [anon_sym_u207a] = ACTIONS(293),
    [sym_asterisk] = ACTIONS(295),
    [sym_sup_hash] = ACTIONS(295),
    [sym_prime] = ACTIONS(295),
    [anon_sym_ASSUME] = ACTIONS(333),
    [anon_sym_ASSUMPTION] = ACTIONS(333),
    [anon_sym_AXIOM] = ACTIONS(333),
    [anon_sym_THEOREM] = ACTIONS(333),
    [anon_sym_PROPOSITION] = ACTIONS(333),
    [anon_sym_LEMMA] = ACTIONS(333),
    [anon_sym_COROLLARY] = ACTIONS(333),
    [anon_sym_USE] = ACTIONS(333),
    [anon_sym_HIDE] = ACTIONS(333),
    [sym__indent] = ACTIONS(482),
    [sym__double_excl] = ACTIONS(277),
  },
  [9] = {
    [sym_block_comment] = STATE(9),
    [sym_forall] = STATE(3984),
    [sym_exists] = STATE(3984),
    [sym_langle_bracket] = STATE(76),
    [sym_subexpr_prefix] = STATE(1092),
    [sym_subexpr_component] = STATE(5469),
    [sym_bound_op] = STATE(2377),
    [sym_bound_nonfix_op] = STATE(2377),
    [sym__expr] = STATE(1281),
    [sym_prefixed_op] = STATE(2405),
    [sym__number] = STATE(2405),
    [sym_nat_number] = STATE(2399),
    [sym_binary_number] = STATE(2399),
    [sym_octal_number] = STATE(2399),
    [sym_hex_number] = STATE(2399),
    [sym_string] = STATE(2405),
    [sym_boolean] = STATE(2405),
    [sym__number_set] = STATE(2404),
    [sym__primitive_value_set] = STATE(2405),
    [sym_nat_number_set] = STATE(2490),
    [sym_int_number_set] = STATE(2490),
    [sym_real_number_set] = STATE(2490),
    [sym_label] = STATE(2405),
    [sym_subexpression] = STATE(2405),
    [sym_parentheses] = STATE(2405),
    [sym_bounded_quantification] = STATE(2405),
    [sym_unbounded_quantification] = STATE(2405),
    [sym_choose] = STATE(2405),
    [sym_finite_set_literal] = STATE(2405),
    [sym_set_filter] = STATE(2405),
    [sym_set_map] = STATE(2405),
    [sym_function_evaluation] = STATE(2405),
    [sym_function_literal] = STATE(2405),
    [sym_set_of_functions] = STATE(2405),
    [sym_record_literal] = STATE(2405),
    [sym_set_of_records] = STATE(2405),
    [sym_record_value] = STATE(2405),
    [sym_except] = STATE(2405),
    [sym_prev_func_val] = STATE(2405),
    [sym_tuple_literal] = STATE(2405),
    [sym_step_expr_or_stutter] = STATE(2405),
    [sym_step_expr_no_stutter] = STATE(2405),
    [sym_fairness] = STATE(2405),
    [sym_if_then_else] = STATE(2405),
    [sym_case] = STATE(2405),
    [sym_let_in] = STATE(2405),
    [sym_conj_list] = STATE(2405),
    [sym_disj_list] = STATE(2405),
    [sym_lnot] = STATE(264),
    [sym_negative] = STATE(517),
    [sym_always] = STATE(263),
    [sym_eventually] = STATE(263),
    [sym_prefix_op_symbol] = STATE(4965),
    [sym_bound_prefix_op] = STATE(2405),
    [sym_implies] = STATE(3441),
    [sym_plus_arrow] = STATE(3441),
    [sym_equiv] = STATE(3441),
    [sym_iff] = STATE(3441),
    [sym_leads_to] = STATE(3441),
    [sym_land] = STATE(3441),
    [sym_lor] = STATE(3441),
    [sym_assign] = STATE(3441),
    [sym_bnf_rule] = STATE(3441),
    [sym_eq] = STATE(3441),
    [sym_neq] = STATE(3441),
    [sym_lt] = STATE(3441),
    [sym_leq] = STATE(3441),
    [sym_geq] = STATE(3441),
    [sym_approx] = STATE(3441),
    [sym_rs_ttile] = STATE(3441),
    [sym_rd_ttile] = STATE(3441),
    [sym_ls_ttile] = STATE(3441),
    [sym_ld_ttile] = STATE(3441),
    [sym_asymp] = STATE(3441),
    [sym_cong] = STATE(3441),
    [sym_doteq] = STATE(3441),
    [sym_gg] = STATE(3441),
    [sym_ll] = STATE(3441),
    [sym_in] = STATE(3441),
    [sym_notin] = STATE(3441),
    [sym_prec] = STATE(3441),
    [sym_succ] = STATE(3441),
    [sym_preceq] = STATE(3441),
    [sym_succeq] = STATE(3441),
    [sym_propto] = STATE(3441),
    [sym_sim] = STATE(3441),
    [sym_simeq] = STATE(3441),
    [sym_sqsubset] = STATE(3441),
    [sym_sqsupset] = STATE(3441),
    [sym_sqsubseteq] = STATE(3441),
    [sym_sqsupseteq] = STATE(3441),
    [sym_subset] = STATE(3441),
    [sym_supset] = STATE(3441),
    [sym_subseteq] = STATE(3441),
    [sym_supseteq] = STATE(3441),
    [sym_cap] = STATE(3441),
    [sym_cup] = STATE(3441),
    [sym_dots_2] = STATE(3441),
    [sym_dots_3] = STATE(3441),
    [sym_plus] = STATE(3441),
    [sym_oplus] = STATE(3441),
    [sym_ominus] = STATE(3441),
    [sym_vertvert] = STATE(3441),
    [sym_minus] = STATE(3441),
    [sym_odot] = STATE(3441),
    [sym_oslash] = STATE(3441),
    [sym_otimes] = STATE(3441),
    [sym_bigcirc] = STATE(3441),
    [sym_bullet] = STATE(3441),
    [sym_div] = STATE(3441),
    [sym_circ] = STATE(3441),
    [sym_star] = STATE(3441),
    [sym_excl] = STATE(3441),
    [sym_qq] = STATE(3441),
    [sym_sqcap] = STATE(3441),
    [sym_sqcup] = STATE(3441),
    [sym_uplus] = STATE(3441),
    [sym_times] = STATE(3441),
    [sym_wr] = STATE(3441),
    [sym_cdot] = STATE(3441),
    [sym_infix_op_symbol] = STATE(5053),
    [sym_bound_infix_op] = STATE(2405),
    [sym_sup_plus] = STATE(3426),
    [sym_postfix_op_symbol] = STATE(4965),
    [sym_bound_postfix_op] = STATE(2405),
    [sym_proof_step_ref] = STATE(2378),
    [sym_identifier] = ACTIONS(321),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_DASH_DASH_DASH_DASH] = ACTIONS(324),
    [anon_sym_EQ_EQ_EQ_EQ] = ACTIONS(324),
    [anon_sym_BSLASHin] = ACTIONS(59),
    [anon_sym_u2208] = ACTIONS(61),
    [anon_sym_BSLASHA] = ACTIONS(63),
    [anon_sym_BSLASHforall] = ACTIONS(65),
    [anon_sym_u2200] = ACTIONS(65),
    [anon_sym_BSLASHE] = ACTIONS(67),
    [anon_sym_BSLASHexists] = ACTIONS(69),
    [anon_sym_u2203] = ACTIONS(69),
    [sym_temporal_forall] = ACTIONS(326),
    [sym_temporal_exists] = ACTIONS(326),
    [anon_sym_LT_LT] = ACTIONS(73),
    [anon_sym_u3008] = ACTIONS(73),
    [anon_sym_u27e8] = ACTIONS(73),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(328),
    [anon_sym_u25a1] = ACTIONS(328),
    [anon_sym_AT] = ACTIONS(331),
    [anon_sym_SLASH_BSLASH] = ACTIONS(79),
    [anon_sym_u2227] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(81),
    [anon_sym_u2228] = ACTIONS(81),
    [anon_sym_COMMA] = ACTIONS(324),
    [anon_sym_LOCAL] = ACTIONS(333),
    [anon_sym_VARIABLE] = ACTIONS(333),
    [anon_sym_VARIABLES] = ACTIONS(333),
    [anon_sym_CONSTANT] = ACTIONS(333),
    [anon_sym_CONSTANTS] = ACTIONS(333),
    [anon_sym_RECURSIVE] = ACTIONS(333),
    [anon_sym_LPAREN] = ACTIONS(335),
    [anon_sym_LBRACK] = ACTIONS(338),
    [anon_sym_INSTANCE] = ACTIONS(333),
    [anon_sym_BANG] = ACTIONS(324),
    [aux_sym_child_id_token1] = ACTIONS(340),
    [sym_real_number] = ACTIONS(342),
    [anon_sym_BSLASHb] = ACTIONS(344),
    [anon_sym_BSLASHB] = ACTIONS(346),
    [anon_sym_BSLASHo] = ACTIONS(348),
    [anon_sym_BSLASHO] = ACTIONS(350),
    [anon_sym_BSLASHh] = ACTIONS(352),
    [anon_sym_BSLASHH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_TRUE] = ACTIONS(356),
    [anon_sym_FALSE] = ACTIONS(356),
    [sym_string_set] = ACTIONS(358),
    [sym_boolean_set] = ACTIONS(358),
    [anon_sym_Nat] = ACTIONS(360),
    [anon_sym_u2115] = ACTIONS(363),
    [anon_sym_Int] = ACTIONS(366),
    [anon_sym_u2124] = ACTIONS(369),
    [anon_sym_Real] = ACTIONS(372),
    [anon_sym_u211d] = ACTIONS(375),
    [anon_sym_CHOOSE] = ACTIONS(378),
    [anon_sym_LBRACE] = ACTIONS(380),
    [anon_sym_EQ] = ACTIONS(125),
    [anon_sym_WF_] = ACTIONS(382),
    [anon_sym_SF_] = ACTIONS(382),
    [anon_sym_IF] = ACTIONS(384),
    [anon_sym_CASE] = ACTIONS(386),
    [anon_sym_LET] = ACTIONS(388),
    [anon_sym_BSLASHlnot] = ACTIONS(390),
    [anon_sym_BSLASHneg] = ACTIONS(390),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_u00ac] = ACTIONS(390),
    [sym_union] = ACTIONS(396),
    [sym_powerset] = ACTIONS(396),
    [sym_domain] = ACTIONS(396),
    [anon_sym_DASH] = ACTIONS(141),
    [sym_negative_dot] = ACTIONS(399),
    [sym_enabled] = ACTIONS(402),
    [sym_unchanged] = ACTIONS(402),
    [anon_sym_LT_GT] = ACTIONS(405),
    [anon_sym_u22c4] = ACTIONS(405),
    [anon_sym_u25c7] = ACTIONS(405),
    [anon_sym_EQ_GT] = ACTIONS(147),
    [anon_sym_u27f9] = ACTIONS(147),
    [anon_sym_u21d2] = ACTIONS(147),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(149),
    [anon_sym_u21f8] = ACTIONS(149),
    [anon_sym_u2945] = ACTIONS(149),
    [anon_sym_BSLASHequiv] = ACTIONS(151),
    [anon_sym_u2261] = ACTIONS(151),
    [anon_sym_LT_EQ_GT] = ACTIONS(153),
    [anon_sym_u27fa] = ACTIONS(153),
    [anon_sym_u21d4] = ACTIONS(153),
    [anon_sym_TILDE_GT] = ACTIONS(155),
    [anon_sym_u21dd] = ACTIONS(155),
    [anon_sym_u219d] = ACTIONS(155),
    [anon_sym_BSLASHland] = ACTIONS(79),
    [anon_sym_BSLASHlor] = ACTIONS(81),
    [anon_sym_COLON_EQ] = ACTIONS(157),
    [anon_sym_u2254] = ACTIONS(157),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(159),
    [anon_sym_u2a74] = ACTIONS(159),
    [anon_sym_SLASH_EQ] = ACTIONS(161),
    [anon_sym_POUND] = ACTIONS(163),
    [anon_sym_u2260] = ACTIONS(161),
    [anon_sym_LT] = ACTIONS(408),
    [sym_gt] = ACTIONS(167),
    [anon_sym_LT_EQ] = ACTIONS(169),
    [anon_sym_EQ_LT] = ACTIONS(171),
    [anon_sym_BSLASHleq] = ACTIONS(171),
    [anon_sym_u2264] = ACTIONS(171),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_BSLASHgeq] = ACTIONS(173),
    [anon_sym_u2265] = ACTIONS(173),
    [anon_sym_BSLASHapprox] = ACTIONS(175),
    [anon_sym_u2248] = ACTIONS(175),
    [anon_sym_PIPE_DASH] = ACTIONS(177),
    [anon_sym_u22a2] = ACTIONS(177),
    [anon_sym_PIPE_EQ] = ACTIONS(179),
    [anon_sym_u22a8] = ACTIONS(179),
    [anon_sym_DASH_PIPE] = ACTIONS(181),
    [anon_sym_u22a3] = ACTIONS(181),
    [anon_sym_EQ_PIPE] = ACTIONS(183),
    [anon_sym_u2ae4] = ACTIONS(183),
    [anon_sym_BSLASHasymp] = ACTIONS(185),
    [anon_sym_u224d] = ACTIONS(185),
    [anon_sym_BSLASHcong] = ACTIONS(187),
    [anon_sym_u2245] = ACTIONS(187),
    [anon_sym_BSLASHdoteq] = ACTIONS(189),
    [anon_sym_u2250] = ACTIONS(189),
    [anon_sym_BSLASHgg] = ACTIONS(191),
    [anon_sym_u226b] = ACTIONS(191),
    [anon_sym_BSLASHll] = ACTIONS(193),
    [anon_sym_u226a] = ACTIONS(193),
    [anon_sym_BSLASHnotin] = ACTIONS(195),
    [anon_sym_u2209] = ACTIONS(195),
    [anon_sym_BSLASHprec] = ACTIONS(197),
    [anon_sym_u227a] = ACTIONS(199),
    [anon_sym_BSLASHsucc] = ACTIONS(201),
    [anon_sym_u227b] = ACTIONS(203),
    [anon_sym_BSLASHpreceq] = ACTIONS(205),
    [anon_sym_u2aaf] = ACTIONS(205),
    [anon_sym_BSLASHsucceq] = ACTIONS(207),
    [anon_sym_u2ab0] = ACTIONS(207),
    [anon_sym_BSLASHpropto] = ACTIONS(209),
    [anon_sym_u221d] = ACTIONS(209),
    [anon_sym_BSLASHsim] = ACTIONS(211),
    [anon_sym_u223c] = ACTIONS(213),
    [anon_sym_BSLASHsimeq] = ACTIONS(215),
    [anon_sym_u2243] = ACTIONS(215),
    [anon_sym_BSLASHsqsubset] = ACTIONS(217),
    [anon_sym_u228f] = ACTIONS(219),
    [anon_sym_BSLASHsqsupset] = ACTIONS(221),
    [anon_sym_u2290] = ACTIONS(223),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(225),
    [anon_sym_u2291] = ACTIONS(225),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(227),
    [anon_sym_u2292] = ACTIONS(227),
    [anon_sym_BSLASHsubset] = ACTIONS(229),
    [anon_sym_u2282] = ACTIONS(231),
    [anon_sym_BSLASHsupset] = ACTIONS(233),
    [anon_sym_u2283] = ACTIONS(235),
    [anon_sym_BSLASHsubseteq] = ACTIONS(237),
    [anon_sym_u2286] = ACTIONS(237),
    [anon_sym_BSLASHsupseteq] = ACTIONS(239),
    [anon_sym_u2287] = ACTIONS(239),
    [sym_compose] = ACTIONS(241),
    [sym_map_to] = ACTIONS(241),
    [sym_map_from] = ACTIONS(241),
    [sym_setminus] = ACTIONS(167),
    [anon_sym_BSLASHcap] = ACTIONS(243),
    [anon_sym_BSLASHintersect] = ACTIONS(243),
    [anon_sym_u2229] = ACTIONS(243),
    [anon_sym_BSLASHcup] = ACTIONS(245),
    [anon_sym_BSLASHunion] = ACTIONS(245),
    [anon_sym_u222a] = ACTIONS(245),
    [anon_sym_DOT_DOT] = ACTIONS(247),
    [anon_sym_u2025] = ACTIONS(249),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(251),
    [anon_sym_u2026] = ACTIONS(251),
    [anon_sym_PLUS] = ACTIONS(253),
    [sym_plusplus] = ACTIONS(241),
    [anon_sym_BSLASHoplus] = ACTIONS(255),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(255),
    [anon_sym_u2295] = ACTIONS(255),
    [anon_sym_BSLASHominus] = ACTIONS(257),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(257),
    [anon_sym_u2296] = ACTIONS(257),
    [sym_mod] = ACTIONS(167),
    [sym_modmod] = ACTIONS(241),
    [sym_vert] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_u2016] = ACTIONS(259),
    [sym_minusminus] = ACTIONS(167),
    [sym_amp] = ACTIONS(167),
    [sym_ampamp] = ACTIONS(241),
    [anon_sym_BSLASHodot] = ACTIONS(261),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(261),
    [anon_sym_u2299] = ACTIONS(261),
    [anon_sym_BSLASHoslash] = ACTIONS(263),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(263),
    [anon_sym_u2298] = ACTIONS(263),
    [anon_sym_BSLASHotimes] = ACTIONS(265),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(265),
    [anon_sym_u2297] = ACTIONS(265),
    [sym_mul] = ACTIONS(167),
    [sym_mulmul] = ACTIONS(241),
    [sym_slash] = ACTIONS(167),
    [sym_slashslash] = ACTIONS(241),
    [anon_sym_BSLASHbigcirc] = ACTIONS(267),
    [anon_sym_u25ef] = ACTIONS(267),
    [anon_sym_BSLASHbullet] = ACTIONS(269),
    [anon_sym_u25cf] = ACTIONS(269),
    [anon_sym_BSLASHdiv] = ACTIONS(271),
    [anon_sym_u00f7] = ACTIONS(271),
    [anon_sym_BSLASHcirc] = ACTIONS(273),
    [anon_sym_u2218] = ACTIONS(273),
    [anon_sym_BSLASHstar] = ACTIONS(275),
    [anon_sym_u22c6] = ACTIONS(275),
    [anon_sym_u203c] = ACTIONS(277),
    [sym_hashhash] = ACTIONS(241),
    [sym_dol] = ACTIONS(167),
    [sym_doldol] = ACTIONS(241),
    [anon_sym_QMARK_QMARK] = ACTIONS(279),
    [anon_sym_u2047] = ACTIONS(279),
    [anon_sym_BSLASHsqcap] = ACTIONS(281),
    [anon_sym_u2293] = ACTIONS(281),
    [anon_sym_BSLASHsqcup] = ACTIONS(283),
    [anon_sym_u2294] = ACTIONS(283),
    [anon_sym_BSLASHuplus] = ACTIONS(285),
    [anon_sym_u228e] = ACTIONS(285),
    [anon_sym_BSLASHX] = ACTIONS(287),
    [anon_sym_BSLASHtimes] = ACTIONS(287),
    [anon_sym_u00d7] = ACTIONS(287),
    [anon_sym_BSLASHwr] = ACTIONS(289),
    [anon_sym_u2240] = ACTIONS(289),
    [anon_sym_BSLASHcdot] = ACTIONS(291),
    [anon_sym_u22c5] = ACTIONS(291),
    [sym_pow] = ACTIONS(167),
    [sym_powpow] = ACTIONS(241),
    [anon_sym_CARET_PLUS] = ACTIONS(293),
    [anon_sym_u207a] = ACTIONS(293),
    [sym_asterisk] = ACTIONS(295),
    [sym_sup_hash] = ACTIONS(295),
    [sym_prime] = ACTIONS(295),
    [anon_sym_ASSUME] = ACTIONS(333),
    [anon_sym_ASSUMPTION] = ACTIONS(333),
    [anon_sym_AXIOM] = ACTIONS(333),
    [anon_sym_THEOREM] = ACTIONS(333),
    [anon_sym_PROPOSITION] = ACTIONS(333),
    [anon_sym_LEMMA] = ACTIONS(333),
    [anon_sym_COROLLARY] = ACTIONS(333),
    [anon_sym_USE] = ACTIONS(333),
    [anon_sym_HIDE] = ACTIONS(333),
    [sym__indent] = ACTIONS(410),
    [sym__double_excl] = ACTIONS(277),
  },
  [10] = {
    [sym_block_comment] = STATE(10),
    [sym_forall] = STATE(4003),
    [sym_exists] = STATE(4003),
    [sym_langle_bracket] = STATE(54),
    [sym_subexpr_prefix] = STATE(1098),
    [sym_subexpr_component] = STATE(5469),
    [sym_bound_op] = STATE(2383),
    [sym_bound_nonfix_op] = STATE(2383),
    [sym__expr] = STATE(1262),
    [sym_prefixed_op] = STATE(2406),
    [sym__number] = STATE(2406),
    [sym_nat_number] = STATE(2459),
    [sym_binary_number] = STATE(2459),
    [sym_octal_number] = STATE(2459),
    [sym_hex_number] = STATE(2459),
    [sym_string] = STATE(2406),
    [sym_boolean] = STATE(2406),
    [sym__number_set] = STATE(2463),
    [sym__primitive_value_set] = STATE(2406),
    [sym_nat_number_set] = STATE(2400),
    [sym_int_number_set] = STATE(2400),
    [sym_real_number_set] = STATE(2400),
    [sym_label] = STATE(2406),
    [sym_subexpression] = STATE(2406),
    [sym_parentheses] = STATE(2406),
    [sym_bounded_quantification] = STATE(2406),
    [sym_unbounded_quantification] = STATE(2406),
    [sym_choose] = STATE(2406),
    [sym_finite_set_literal] = STATE(2406),
    [sym_set_filter] = STATE(2406),
    [sym_set_map] = STATE(2406),
    [sym_function_evaluation] = STATE(2406),
    [sym_function_literal] = STATE(2406),
    [sym_set_of_functions] = STATE(2406),
    [sym_record_literal] = STATE(2406),
    [sym_set_of_records] = STATE(2406),
    [sym_record_value] = STATE(2406),
    [sym_except] = STATE(2406),
    [sym_prev_func_val] = STATE(2406),
    [sym_tuple_literal] = STATE(2406),
    [sym_step_expr_or_stutter] = STATE(2406),
    [sym_step_expr_no_stutter] = STATE(2406),
    [sym_fairness] = STATE(2406),
    [sym_if_then_else] = STATE(2406),
    [sym_case] = STATE(2406),
    [sym_let_in] = STATE(2406),
    [sym_conj_list] = STATE(2406),
    [sym_disj_list] = STATE(2406),
    [sym_lnot] = STATE(292),
    [sym_negative] = STATE(807),
    [sym_always] = STATE(245),
    [sym_eventually] = STATE(245),
    [sym_prefix_op_symbol] = STATE(4944),
    [sym_bound_prefix_op] = STATE(2406),
    [sym_implies] = STATE(3441),
    [sym_plus_arrow] = STATE(3441),
    [sym_equiv] = STATE(3441),
    [sym_iff] = STATE(3441),
    [sym_leads_to] = STATE(3441),
    [sym_land] = STATE(3441),
    [sym_lor] = STATE(3441),
    [sym_assign] = STATE(3441),
    [sym_bnf_rule] = STATE(3441),
    [sym_eq] = STATE(3441),
    [sym_neq] = STATE(3441),
    [sym_lt] = STATE(3441),
    [sym_leq] = STATE(3441),
    [sym_geq] = STATE(3441),
    [sym_approx] = STATE(3441),
    [sym_rs_ttile] = STATE(3441),
    [sym_rd_ttile] = STATE(3441),
    [sym_ls_ttile] = STATE(3441),
    [sym_ld_ttile] = STATE(3441),
    [sym_asymp] = STATE(3441),
    [sym_cong] = STATE(3441),
    [sym_doteq] = STATE(3441),
    [sym_gg] = STATE(3441),
    [sym_ll] = STATE(3441),
    [sym_in] = STATE(3441),
    [sym_notin] = STATE(3441),
    [sym_prec] = STATE(3441),
    [sym_succ] = STATE(3441),
    [sym_preceq] = STATE(3441),
    [sym_succeq] = STATE(3441),
    [sym_propto] = STATE(3441),
    [sym_sim] = STATE(3441),
    [sym_simeq] = STATE(3441),
    [sym_sqsubset] = STATE(3441),
    [sym_sqsupset] = STATE(3441),
    [sym_sqsubseteq] = STATE(3441),
    [sym_sqsupseteq] = STATE(3441),
    [sym_subset] = STATE(3441),
    [sym_supset] = STATE(3441),
    [sym_subseteq] = STATE(3441),
    [sym_supseteq] = STATE(3441),
    [sym_cap] = STATE(3441),
    [sym_cup] = STATE(3441),
    [sym_dots_2] = STATE(3441),
    [sym_dots_3] = STATE(3441),
    [sym_plus] = STATE(3441),
    [sym_oplus] = STATE(3441),
    [sym_ominus] = STATE(3441),
    [sym_vertvert] = STATE(3441),
    [sym_minus] = STATE(3441),
    [sym_odot] = STATE(3441),
    [sym_oslash] = STATE(3441),
    [sym_otimes] = STATE(3441),
    [sym_bigcirc] = STATE(3441),
    [sym_bullet] = STATE(3441),
    [sym_div] = STATE(3441),
    [sym_circ] = STATE(3441),
    [sym_star] = STATE(3441),
    [sym_excl] = STATE(3441),
    [sym_qq] = STATE(3441),
    [sym_sqcap] = STATE(3441),
    [sym_sqcup] = STATE(3441),
    [sym_uplus] = STATE(3441),
    [sym_times] = STATE(3441),
    [sym_wr] = STATE(3441),
    [sym_cdot] = STATE(3441),
    [sym_infix_op_symbol] = STATE(4945),
    [sym_bound_infix_op] = STATE(2406),
    [sym_sup_plus] = STATE(3426),
    [sym_postfix_op_symbol] = STATE(4944),
    [sym_bound_postfix_op] = STATE(2406),
    [sym_proof_step_ref] = STATE(2384),
    [ts_builtin_sym_end] = ACTIONS(324),
    [sym_identifier] = ACTIONS(412),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_DASH_DASH_DASH_DASH] = ACTIONS(324),
    [anon_sym_BSLASHin] = ACTIONS(59),
    [anon_sym_u2208] = ACTIONS(61),
    [anon_sym_BSLASHA] = ACTIONS(63),
    [anon_sym_BSLASHforall] = ACTIONS(65),
    [anon_sym_u2200] = ACTIONS(65),
    [anon_sym_BSLASHE] = ACTIONS(67),
    [anon_sym_BSLASHexists] = ACTIONS(69),
    [anon_sym_u2203] = ACTIONS(69),
    [sym_temporal_forall] = ACTIONS(415),
    [sym_temporal_exists] = ACTIONS(415),
    [anon_sym_LT_LT] = ACTIONS(73),
    [anon_sym_u3008] = ACTIONS(73),
    [anon_sym_u27e8] = ACTIONS(73),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(328),
    [anon_sym_u25a1] = ACTIONS(328),
    [anon_sym_AT] = ACTIONS(417),
    [anon_sym_SLASH_BSLASH] = ACTIONS(79),
    [anon_sym_u2227] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(81),
    [anon_sym_u2228] = ACTIONS(81),
    [anon_sym_COMMA] = ACTIONS(324),
    [anon_sym_LOCAL] = ACTIONS(333),
    [anon_sym_VARIABLE] = ACTIONS(333),
    [anon_sym_VARIABLES] = ACTIONS(333),
    [anon_sym_CONSTANT] = ACTIONS(333),
    [anon_sym_CONSTANTS] = ACTIONS(333),
    [anon_sym_RECURSIVE] = ACTIONS(333),
    [anon_sym_LPAREN] = ACTIONS(419),
    [anon_sym_LBRACK] = ACTIONS(422),
    [anon_sym_INSTANCE] = ACTIONS(333),
    [anon_sym_BANG] = ACTIONS(324),
    [aux_sym_child_id_token1] = ACTIONS(424),
    [sym_real_number] = ACTIONS(426),
    [anon_sym_BSLASHb] = ACTIONS(428),
    [anon_sym_BSLASHB] = ACTIONS(430),
    [anon_sym_BSLASHo] = ACTIONS(432),
    [anon_sym_BSLASHO] = ACTIONS(434),
    [anon_sym_BSLASHh] = ACTIONS(436),
    [anon_sym_BSLASHH] = ACTIONS(436),
    [anon_sym_DQUOTE] = ACTIONS(438),
    [anon_sym_TRUE] = ACTIONS(440),
    [anon_sym_FALSE] = ACTIONS(440),
    [sym_string_set] = ACTIONS(442),
    [sym_boolean_set] = ACTIONS(442),
    [anon_sym_Nat] = ACTIONS(444),
    [anon_sym_u2115] = ACTIONS(447),
    [anon_sym_Int] = ACTIONS(450),
    [anon_sym_u2124] = ACTIONS(453),
    [anon_sym_Real] = ACTIONS(456),
    [anon_sym_u211d] = ACTIONS(459),
    [anon_sym_CHOOSE] = ACTIONS(462),
    [anon_sym_LBRACE] = ACTIONS(464),
    [anon_sym_EQ] = ACTIONS(125),
    [anon_sym_WF_] = ACTIONS(466),
    [anon_sym_SF_] = ACTIONS(466),
    [anon_sym_IF] = ACTIONS(468),
    [anon_sym_CASE] = ACTIONS(470),
    [anon_sym_LET] = ACTIONS(472),
    [anon_sym_BSLASHlnot] = ACTIONS(390),
    [anon_sym_BSLASHneg] = ACTIONS(390),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_u00ac] = ACTIONS(390),
    [sym_union] = ACTIONS(474),
    [sym_powerset] = ACTIONS(474),
    [sym_domain] = ACTIONS(474),
    [anon_sym_DASH] = ACTIONS(141),
    [sym_negative_dot] = ACTIONS(399),
    [sym_enabled] = ACTIONS(477),
    [sym_unchanged] = ACTIONS(477),
    [anon_sym_LT_GT] = ACTIONS(405),
    [anon_sym_u22c4] = ACTIONS(405),
    [anon_sym_u25c7] = ACTIONS(405),
    [anon_sym_EQ_GT] = ACTIONS(147),
    [anon_sym_u27f9] = ACTIONS(147),
    [anon_sym_u21d2] = ACTIONS(147),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(149),
    [anon_sym_u21f8] = ACTIONS(149),
    [anon_sym_u2945] = ACTIONS(149),
    [anon_sym_BSLASHequiv] = ACTIONS(151),
    [anon_sym_u2261] = ACTIONS(151),
    [anon_sym_LT_EQ_GT] = ACTIONS(153),
    [anon_sym_u27fa] = ACTIONS(153),
    [anon_sym_u21d4] = ACTIONS(153),
    [anon_sym_TILDE_GT] = ACTIONS(155),
    [anon_sym_u21dd] = ACTIONS(155),
    [anon_sym_u219d] = ACTIONS(155),
    [anon_sym_BSLASHland] = ACTIONS(79),
    [anon_sym_BSLASHlor] = ACTIONS(81),
    [anon_sym_COLON_EQ] = ACTIONS(157),
    [anon_sym_u2254] = ACTIONS(157),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(159),
    [anon_sym_u2a74] = ACTIONS(159),
    [anon_sym_SLASH_EQ] = ACTIONS(161),
    [anon_sym_POUND] = ACTIONS(163),
    [anon_sym_u2260] = ACTIONS(161),
    [anon_sym_LT] = ACTIONS(480),
    [sym_gt] = ACTIONS(167),
    [anon_sym_LT_EQ] = ACTIONS(169),
    [anon_sym_EQ_LT] = ACTIONS(171),
    [anon_sym_BSLASHleq] = ACTIONS(171),
    [anon_sym_u2264] = ACTIONS(171),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_BSLASHgeq] = ACTIONS(173),
    [anon_sym_u2265] = ACTIONS(173),
    [anon_sym_BSLASHapprox] = ACTIONS(175),
    [anon_sym_u2248] = ACTIONS(175),
    [anon_sym_PIPE_DASH] = ACTIONS(177),
    [anon_sym_u22a2] = ACTIONS(177),
    [anon_sym_PIPE_EQ] = ACTIONS(179),
    [anon_sym_u22a8] = ACTIONS(179),
    [anon_sym_DASH_PIPE] = ACTIONS(181),
    [anon_sym_u22a3] = ACTIONS(181),
    [anon_sym_EQ_PIPE] = ACTIONS(183),
    [anon_sym_u2ae4] = ACTIONS(183),
    [anon_sym_BSLASHasymp] = ACTIONS(185),
    [anon_sym_u224d] = ACTIONS(185),
    [anon_sym_BSLASHcong] = ACTIONS(187),
    [anon_sym_u2245] = ACTIONS(187),
    [anon_sym_BSLASHdoteq] = ACTIONS(189),
    [anon_sym_u2250] = ACTIONS(189),
    [anon_sym_BSLASHgg] = ACTIONS(191),
    [anon_sym_u226b] = ACTIONS(191),
    [anon_sym_BSLASHll] = ACTIONS(193),
    [anon_sym_u226a] = ACTIONS(193),
    [anon_sym_BSLASHnotin] = ACTIONS(195),
    [anon_sym_u2209] = ACTIONS(195),
    [anon_sym_BSLASHprec] = ACTIONS(197),
    [anon_sym_u227a] = ACTIONS(199),
    [anon_sym_BSLASHsucc] = ACTIONS(201),
    [anon_sym_u227b] = ACTIONS(203),
    [anon_sym_BSLASHpreceq] = ACTIONS(205),
    [anon_sym_u2aaf] = ACTIONS(205),
    [anon_sym_BSLASHsucceq] = ACTIONS(207),
    [anon_sym_u2ab0] = ACTIONS(207),
    [anon_sym_BSLASHpropto] = ACTIONS(209),
    [anon_sym_u221d] = ACTIONS(209),
    [anon_sym_BSLASHsim] = ACTIONS(211),
    [anon_sym_u223c] = ACTIONS(213),
    [anon_sym_BSLASHsimeq] = ACTIONS(215),
    [anon_sym_u2243] = ACTIONS(215),
    [anon_sym_BSLASHsqsubset] = ACTIONS(217),
    [anon_sym_u228f] = ACTIONS(219),
    [anon_sym_BSLASHsqsupset] = ACTIONS(221),
    [anon_sym_u2290] = ACTIONS(223),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(225),
    [anon_sym_u2291] = ACTIONS(225),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(227),
    [anon_sym_u2292] = ACTIONS(227),
    [anon_sym_BSLASHsubset] = ACTIONS(229),
    [anon_sym_u2282] = ACTIONS(231),
    [anon_sym_BSLASHsupset] = ACTIONS(233),
    [anon_sym_u2283] = ACTIONS(235),
    [anon_sym_BSLASHsubseteq] = ACTIONS(237),
    [anon_sym_u2286] = ACTIONS(237),
    [anon_sym_BSLASHsupseteq] = ACTIONS(239),
    [anon_sym_u2287] = ACTIONS(239),
    [sym_compose] = ACTIONS(241),
    [sym_map_to] = ACTIONS(241),
    [sym_map_from] = ACTIONS(241),
    [sym_setminus] = ACTIONS(167),
    [anon_sym_BSLASHcap] = ACTIONS(243),
    [anon_sym_BSLASHintersect] = ACTIONS(243),
    [anon_sym_u2229] = ACTIONS(243),
    [anon_sym_BSLASHcup] = ACTIONS(245),
    [anon_sym_BSLASHunion] = ACTIONS(245),
    [anon_sym_u222a] = ACTIONS(245),
    [anon_sym_DOT_DOT] = ACTIONS(247),
    [anon_sym_u2025] = ACTIONS(249),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(251),
    [anon_sym_u2026] = ACTIONS(251),
    [anon_sym_PLUS] = ACTIONS(253),
    [sym_plusplus] = ACTIONS(241),
    [anon_sym_BSLASHoplus] = ACTIONS(255),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(255),
    [anon_sym_u2295] = ACTIONS(255),
    [anon_sym_BSLASHominus] = ACTIONS(257),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(257),
    [anon_sym_u2296] = ACTIONS(257),
    [sym_mod] = ACTIONS(167),
    [sym_modmod] = ACTIONS(241),
    [sym_vert] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_u2016] = ACTIONS(259),
    [sym_minusminus] = ACTIONS(167),
    [sym_amp] = ACTIONS(167),
    [sym_ampamp] = ACTIONS(241),
    [anon_sym_BSLASHodot] = ACTIONS(261),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(261),
    [anon_sym_u2299] = ACTIONS(261),
    [anon_sym_BSLASHoslash] = ACTIONS(263),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(263),
    [anon_sym_u2298] = ACTIONS(263),
    [anon_sym_BSLASHotimes] = ACTIONS(265),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(265),
    [anon_sym_u2297] = ACTIONS(265),
    [sym_mul] = ACTIONS(167),
    [sym_mulmul] = ACTIONS(241),
    [sym_slash] = ACTIONS(167),
    [sym_slashslash] = ACTIONS(241),
    [anon_sym_BSLASHbigcirc] = ACTIONS(267),
    [anon_sym_u25ef] = ACTIONS(267),
    [anon_sym_BSLASHbullet] = ACTIONS(269),
    [anon_sym_u25cf] = ACTIONS(269),
    [anon_sym_BSLASHdiv] = ACTIONS(271),
    [anon_sym_u00f7] = ACTIONS(271),
    [anon_sym_BSLASHcirc] = ACTIONS(273),
    [anon_sym_u2218] = ACTIONS(273),
    [anon_sym_BSLASHstar] = ACTIONS(275),
    [anon_sym_u22c6] = ACTIONS(275),
    [anon_sym_u203c] = ACTIONS(277),
    [sym_hashhash] = ACTIONS(241),
    [sym_dol] = ACTIONS(167),
    [sym_doldol] = ACTIONS(241),
    [anon_sym_QMARK_QMARK] = ACTIONS(279),
    [anon_sym_u2047] = ACTIONS(279),
    [anon_sym_BSLASHsqcap] = ACTIONS(281),
    [anon_sym_u2293] = ACTIONS(281),
    [anon_sym_BSLASHsqcup] = ACTIONS(283),
    [anon_sym_u2294] = ACTIONS(283),
    [anon_sym_BSLASHuplus] = ACTIONS(285),
    [anon_sym_u228e] = ACTIONS(285),
    [anon_sym_BSLASHX] = ACTIONS(287),
    [anon_sym_BSLASHtimes] = ACTIONS(287),
    [anon_sym_u00d7] = ACTIONS(287),
    [anon_sym_BSLASHwr] = ACTIONS(289),
    [anon_sym_u2240] = ACTIONS(289),
    [anon_sym_BSLASHcdot] = ACTIONS(291),
    [anon_sym_u22c5] = ACTIONS(291),
    [sym_pow] = ACTIONS(167),
    [sym_powpow] = ACTIONS(241),
    [anon_sym_CARET_PLUS] = ACTIONS(293),
    [anon_sym_u207a] = ACTIONS(293),
    [sym_asterisk] = ACTIONS(295),
    [sym_sup_hash] = ACTIONS(295),
    [sym_prime] = ACTIONS(295),
    [anon_sym_ASSUME] = ACTIONS(333),
    [anon_sym_ASSUMPTION] = ACTIONS(333),
    [anon_sym_AXIOM] = ACTIONS(333),
    [anon_sym_THEOREM] = ACTIONS(333),
    [anon_sym_PROPOSITION] = ACTIONS(333),
    [anon_sym_LEMMA] = ACTIONS(333),
    [anon_sym_COROLLARY] = ACTIONS(333),
    [anon_sym_USE] = ACTIONS(333),
    [anon_sym_HIDE] = ACTIONS(333),
    [sym__indent] = ACTIONS(482),
    [sym__double_excl] = ACTIONS(277),
  },
  [11] = {
    [sym_block_comment] = STATE(11),
    [sym_forall] = STATE(4003),
    [sym_exists] = STATE(4003),
    [sym_langle_bracket] = STATE(54),
    [sym_subexpr_prefix] = STATE(1098),
    [sym_subexpr_component] = STATE(5469),
    [sym_bound_op] = STATE(2383),
    [sym_bound_nonfix_op] = STATE(2383),
    [sym__expr] = STATE(1268),
    [sym_prefixed_op] = STATE(2406),
    [sym__number] = STATE(2406),
    [sym_nat_number] = STATE(2459),
    [sym_binary_number] = STATE(2459),
    [sym_octal_number] = STATE(2459),
    [sym_hex_number] = STATE(2459),
    [sym_string] = STATE(2406),
    [sym_boolean] = STATE(2406),
    [sym__number_set] = STATE(2463),
    [sym__primitive_value_set] = STATE(2406),
    [sym_nat_number_set] = STATE(2400),
    [sym_int_number_set] = STATE(2400),
    [sym_real_number_set] = STATE(2400),
    [sym_label] = STATE(2406),
    [sym_subexpression] = STATE(2406),
    [sym_parentheses] = STATE(2406),
    [sym_bounded_quantification] = STATE(2406),
    [sym_unbounded_quantification] = STATE(2406),
    [sym_choose] = STATE(2406),
    [sym_finite_set_literal] = STATE(2406),
    [sym_set_filter] = STATE(2406),
    [sym_set_map] = STATE(2406),
    [sym_function_evaluation] = STATE(2406),
    [sym_function_literal] = STATE(2406),
    [sym_set_of_functions] = STATE(2406),
    [sym_record_literal] = STATE(2406),
    [sym_set_of_records] = STATE(2406),
    [sym_record_value] = STATE(2406),
    [sym_except] = STATE(2406),
    [sym_prev_func_val] = STATE(2406),
    [sym_tuple_literal] = STATE(2406),
    [sym_step_expr_or_stutter] = STATE(2406),
    [sym_step_expr_no_stutter] = STATE(2406),
    [sym_fairness] = STATE(2406),
    [sym_if_then_else] = STATE(2406),
    [sym_case] = STATE(2406),
    [sym_let_in] = STATE(2406),
    [sym_conj_list] = STATE(2406),
    [sym_disj_list] = STATE(2406),
    [sym_lnot] = STATE(292),
    [sym_negative] = STATE(807),
    [sym_always] = STATE(245),
    [sym_eventually] = STATE(245),
    [sym_prefix_op_symbol] = STATE(4944),
    [sym_bound_prefix_op] = STATE(2406),
    [sym_implies] = STATE(3441),
    [sym_plus_arrow] = STATE(3441),
    [sym_equiv] = STATE(3441),
    [sym_iff] = STATE(3441),
    [sym_leads_to] = STATE(3441),
    [sym_land] = STATE(3441),
    [sym_lor] = STATE(3441),
    [sym_assign] = STATE(3441),
    [sym_bnf_rule] = STATE(3441),
    [sym_eq] = STATE(3441),
    [sym_neq] = STATE(3441),
    [sym_lt] = STATE(3441),
    [sym_leq] = STATE(3441),
    [sym_geq] = STATE(3441),
    [sym_approx] = STATE(3441),
    [sym_rs_ttile] = STATE(3441),
    [sym_rd_ttile] = STATE(3441),
    [sym_ls_ttile] = STATE(3441),
    [sym_ld_ttile] = STATE(3441),
    [sym_asymp] = STATE(3441),
    [sym_cong] = STATE(3441),
    [sym_doteq] = STATE(3441),
    [sym_gg] = STATE(3441),
    [sym_ll] = STATE(3441),
    [sym_in] = STATE(3441),
    [sym_notin] = STATE(3441),
    [sym_prec] = STATE(3441),
    [sym_succ] = STATE(3441),
    [sym_preceq] = STATE(3441),
    [sym_succeq] = STATE(3441),
    [sym_propto] = STATE(3441),
    [sym_sim] = STATE(3441),
    [sym_simeq] = STATE(3441),
    [sym_sqsubset] = STATE(3441),
    [sym_sqsupset] = STATE(3441),
    [sym_sqsubseteq] = STATE(3441),
    [sym_sqsupseteq] = STATE(3441),
    [sym_subset] = STATE(3441),
    [sym_supset] = STATE(3441),
    [sym_subseteq] = STATE(3441),
    [sym_supseteq] = STATE(3441),
    [sym_cap] = STATE(3441),
    [sym_cup] = STATE(3441),
    [sym_dots_2] = STATE(3441),
    [sym_dots_3] = STATE(3441),
    [sym_plus] = STATE(3441),
    [sym_oplus] = STATE(3441),
    [sym_ominus] = STATE(3441),
    [sym_vertvert] = STATE(3441),
    [sym_minus] = STATE(3441),
    [sym_odot] = STATE(3441),
    [sym_oslash] = STATE(3441),
    [sym_otimes] = STATE(3441),
    [sym_bigcirc] = STATE(3441),
    [sym_bullet] = STATE(3441),
    [sym_div] = STATE(3441),
    [sym_circ] = STATE(3441),
    [sym_star] = STATE(3441),
    [sym_excl] = STATE(3441),
    [sym_qq] = STATE(3441),
    [sym_sqcap] = STATE(3441),
    [sym_sqcup] = STATE(3441),
    [sym_uplus] = STATE(3441),
    [sym_times] = STATE(3441),
    [sym_wr] = STATE(3441),
    [sym_cdot] = STATE(3441),
    [sym_infix_op_symbol] = STATE(4945),
    [sym_bound_infix_op] = STATE(2406),
    [sym_sup_plus] = STATE(3426),
    [sym_postfix_op_symbol] = STATE(4944),
    [sym_bound_postfix_op] = STATE(2406),
    [sym_proof_step_ref] = STATE(2384),
    [ts_builtin_sym_end] = ACTIONS(324),
    [sym_identifier] = ACTIONS(412),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_DASH_DASH_DASH_DASH] = ACTIONS(324),
    [anon_sym_BSLASHin] = ACTIONS(59),
    [anon_sym_u2208] = ACTIONS(61),
    [anon_sym_BSLASHA] = ACTIONS(63),
    [anon_sym_BSLASHforall] = ACTIONS(65),
    [anon_sym_u2200] = ACTIONS(65),
    [anon_sym_BSLASHE] = ACTIONS(67),
    [anon_sym_BSLASHexists] = ACTIONS(69),
    [anon_sym_u2203] = ACTIONS(69),
    [sym_temporal_forall] = ACTIONS(415),
    [sym_temporal_exists] = ACTIONS(415),
    [anon_sym_LT_LT] = ACTIONS(73),
    [anon_sym_u3008] = ACTIONS(73),
    [anon_sym_u27e8] = ACTIONS(73),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(328),
    [anon_sym_u25a1] = ACTIONS(328),
    [anon_sym_AT] = ACTIONS(417),
    [anon_sym_SLASH_BSLASH] = ACTIONS(79),
    [anon_sym_u2227] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(81),
    [anon_sym_u2228] = ACTIONS(81),
    [anon_sym_COMMA] = ACTIONS(324),
    [anon_sym_LOCAL] = ACTIONS(333),
    [anon_sym_VARIABLE] = ACTIONS(333),
    [anon_sym_VARIABLES] = ACTIONS(333),
    [anon_sym_CONSTANT] = ACTIONS(333),
    [anon_sym_CONSTANTS] = ACTIONS(333),
    [anon_sym_RECURSIVE] = ACTIONS(333),
    [anon_sym_LPAREN] = ACTIONS(419),
    [anon_sym_LBRACK] = ACTIONS(422),
    [anon_sym_INSTANCE] = ACTIONS(333),
    [anon_sym_BANG] = ACTIONS(324),
    [aux_sym_child_id_token1] = ACTIONS(424),
    [sym_real_number] = ACTIONS(426),
    [anon_sym_BSLASHb] = ACTIONS(428),
    [anon_sym_BSLASHB] = ACTIONS(430),
    [anon_sym_BSLASHo] = ACTIONS(432),
    [anon_sym_BSLASHO] = ACTIONS(434),
    [anon_sym_BSLASHh] = ACTIONS(436),
    [anon_sym_BSLASHH] = ACTIONS(436),
    [anon_sym_DQUOTE] = ACTIONS(438),
    [anon_sym_TRUE] = ACTIONS(440),
    [anon_sym_FALSE] = ACTIONS(440),
    [sym_string_set] = ACTIONS(442),
    [sym_boolean_set] = ACTIONS(442),
    [anon_sym_Nat] = ACTIONS(444),
    [anon_sym_u2115] = ACTIONS(447),
    [anon_sym_Int] = ACTIONS(450),
    [anon_sym_u2124] = ACTIONS(453),
    [anon_sym_Real] = ACTIONS(456),
    [anon_sym_u211d] = ACTIONS(459),
    [anon_sym_CHOOSE] = ACTIONS(462),
    [anon_sym_LBRACE] = ACTIONS(464),
    [anon_sym_EQ] = ACTIONS(125),
    [anon_sym_WF_] = ACTIONS(466),
    [anon_sym_SF_] = ACTIONS(466),
    [anon_sym_IF] = ACTIONS(468),
    [anon_sym_CASE] = ACTIONS(470),
    [anon_sym_LET] = ACTIONS(472),
    [anon_sym_BSLASHlnot] = ACTIONS(390),
    [anon_sym_BSLASHneg] = ACTIONS(390),
    [anon_sym_TILDE] = ACTIONS(393),
    [anon_sym_u00ac] = ACTIONS(390),
    [sym_union] = ACTIONS(474),
    [sym_powerset] = ACTIONS(474),
    [sym_domain] = ACTIONS(474),
    [anon_sym_DASH] = ACTIONS(141),
    [sym_negative_dot] = ACTIONS(399),
    [sym_enabled] = ACTIONS(477),
    [sym_unchanged] = ACTIONS(477),
    [anon_sym_LT_GT] = ACTIONS(405),
    [anon_sym_u22c4] = ACTIONS(405),
    [anon_sym_u25c7] = ACTIONS(405),
    [anon_sym_EQ_GT] = ACTIONS(147),
    [anon_sym_u27f9] = ACTIONS(147),
    [anon_sym_u21d2] = ACTIONS(147),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(149),
    [anon_sym_u21f8] = ACTIONS(149),
    [anon_sym_u2945] = ACTIONS(149),
    [anon_sym_BSLASHequiv] = ACTIONS(151),
    [anon_sym_u2261] = ACTIONS(151),
    [anon_sym_LT_EQ_GT] = ACTIONS(153),
    [anon_sym_u27fa] = ACTIONS(153),
    [anon_sym_u21d4] = ACTIONS(153),
    [anon_sym_TILDE_GT] = ACTIONS(155),
    [anon_sym_u21dd] = ACTIONS(155),
    [anon_sym_u219d] = ACTIONS(155),
    [anon_sym_BSLASHland] = ACTIONS(79),
    [anon_sym_BSLASHlor] = ACTIONS(81),
    [anon_sym_COLON_EQ] = ACTIONS(157),
    [anon_sym_u2254] = ACTIONS(157),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(159),
    [anon_sym_u2a74] = ACTIONS(159),
    [anon_sym_SLASH_EQ] = ACTIONS(161),
    [anon_sym_POUND] = ACTIONS(163),
    [anon_sym_u2260] = ACTIONS(161),
    [anon_sym_LT] = ACTIONS(480),
    [sym_gt] = ACTIONS(167),
    [anon_sym_LT_EQ] = ACTIONS(169),
    [anon_sym_EQ_LT] = ACTIONS(171),
    [anon_sym_BSLASHleq] = ACTIONS(171),
    [anon_sym_u2264] = ACTIONS(171),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_BSLASHgeq] = ACTIONS(173),
    [anon_sym_u2265] = ACTIONS(173),
    [anon_sym_BSLASHapprox] = ACTIONS(175),
    [anon_sym_u2248] = ACTIONS(175),
    [anon_sym_PIPE_DASH] = ACTIONS(177),
    [anon_sym_u22a2] = ACTIONS(177),
    [anon_sym_PIPE_EQ] = ACTIONS(179),
    [anon_sym_u22a8] = ACTIONS(179),
    [anon_sym_DASH_PIPE] = ACTIONS(181),
    [anon_sym_u22a3] = ACTIONS(181),
    [anon_sym_EQ_PIPE] = ACTIONS(183),
    [anon_sym_u2ae4] = ACTIONS(183),
    [anon_sym_BSLASHasymp] = ACTIONS(185),
    [anon_sym_u224d] = ACTIONS(185),
    [anon_sym_BSLASHcong] = ACTIONS(187),
    [anon_sym_u2245] = ACTIONS(187),
    [anon_sym_BSLASHdoteq] = ACTIONS(189),
    [anon_sym_u2250] = ACTIONS(189),
    [anon_sym_BSLASHgg] = ACTIONS(191),
    [anon_sym_u226b] = ACTIONS(191),
    [anon_sym_BSLASHll] = ACTIONS(193),
    [anon_sym_u226a] = ACTIONS(193),
    [anon_sym_BSLASHnotin] = ACTIONS(195),
    [anon_sym_u2209] = ACTIONS(195),
    [anon_sym_BSLASHprec] = ACTIONS(197),
    [anon_sym_u227a] = ACTIONS(199),
    [anon_sym_BSLASHsucc] = ACTIONS(201),
    [anon_sym_u227b] = ACTIONS(203),
    [anon_sym_BSLASHpreceq] = ACTIONS(205),
    [anon_sym_u2aaf] = ACTIONS(205),
    [anon_sym_BSLASHsucceq] = ACTIONS(207),
    [anon_sym_u2ab0] = ACTIONS(207),
    [anon_sym_BSLASHpropto] = ACTIONS(209),
    [anon_sym_u221d] = ACTIONS(209),
    [anon_sym_BSLASHsim] = ACTIONS(211),
    [anon_sym_u223c] = ACTIONS(213),
    [anon_sym_BSLASHsimeq] = ACTIONS(215),
    [anon_sym_u2243] = ACTIONS(215),
    [anon_sym_BSLASHsqsubset] = ACTIONS(217),
    [anon_sym_u228f] = ACTIONS(219),
    [anon_sym_BSLASHsqsupset] = ACTIONS(221),
    [anon_sym_u2290] = ACTIONS(223),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(225),
    [anon_sym_u2291] = ACTIONS(225),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(227),
    [anon_sym_u2292] = ACTIONS(227),
    [anon_sym_BSLASHsubset] = ACTIONS(229),
    [anon_sym_u2282] = ACTIONS(231),
    [anon_sym_BSLASHsupset] = ACTIONS(233),
    [anon_sym_u2283] = ACTIONS(235),
    [anon_sym_BSLASHsubseteq] = ACTIONS(237),
    [anon_sym_u2286] = ACTIONS(237),
    [anon_sym_BSLASHsupseteq] = ACTIONS(239),
    [anon_sym_u2287] = ACTIONS(239),
    [sym_compose] = ACTIONS(241),
    [sym_map_to] = ACTIONS(241),
    [sym_map_from] = ACTIONS(241),
    [sym_setminus] = ACTIONS(167),
    [anon_sym_BSLASHcap] = ACTIONS(243),
    [anon_sym_BSLASHintersect] = ACTIONS(243),
    [anon_sym_u2229] = ACTIONS(243),
    [anon_sym_BSLASHcup] = ACTIONS(245),
    [anon_sym_BSLASHunion] = ACTIONS(245),
    [anon_sym_u222a] = ACTIONS(245),
    [anon_sym_DOT_DOT] = ACTIONS(247),
    [anon_sym_u2025] = ACTIONS(249),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(251),
    [anon_sym_u2026] = ACTIONS(251),
    [anon_sym_PLUS] = ACTIONS(253),
    [sym_plusplus] = ACTIONS(241),
    [anon_sym_BSLASHoplus] = ACTIONS(255),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(255),
    [anon_sym_u2295] = ACTIONS(255),
    [anon_sym_BSLASHominus] = ACTIONS(257),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(257),
    [anon_sym_u2296] = ACTIONS(257),
    [sym_mod] = ACTIONS(167),
    [sym_modmod] = ACTIONS(241),
    [sym_vert] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_u2016] = ACTIONS(259),
    [sym_minusminus] = ACTIONS(167),
    [sym_amp] = ACTIONS(167),
    [sym_ampamp] = ACTIONS(241),
    [anon_sym_BSLASHodot] = ACTIONS(261),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(261),
    [anon_sym_u2299] = ACTIONS(261),
    [anon_sym_BSLASHoslash] = ACTIONS(263),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(263),
    [anon_sym_u2298] = ACTIONS(263),
    [anon_sym_BSLASHotimes] = ACTIONS(265),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(265),
    [anon_sym_u2297] = ACTIONS(265),
    [sym_mul] = ACTIONS(167),
    [sym_mulmul] = ACTIONS(241),
    [sym_slash] = ACTIONS(167),
    [sym_slashslash] = ACTIONS(241),
    [anon_sym_BSLASHbigcirc] = ACTIONS(267),
    [anon_sym_u25ef] = ACTIONS(267),
    [anon_sym_BSLASHbullet] = ACTIONS(269),
    [anon_sym_u25cf] = ACTIONS(269),
    [anon_sym_BSLASHdiv] = ACTIONS(271),
    [anon_sym_u00f7] = ACTIONS(271),
    [anon_sym_BSLASHcirc] = ACTIONS(273),
    [anon_sym_u2218] = ACTIONS(273),
    [anon_sym_BSLASHstar] = ACTIONS(275),
    [anon_sym_u22c6] = ACTIONS(275),
    [anon_sym_u203c] = ACTIONS(277),
    [sym_hashhash] = ACTIONS(241),
    [sym_dol] = ACTIONS(167),
    [sym_doldol] = ACTIONS(241),
    [anon_sym_QMARK_QMARK] = ACTIONS(279),
    [anon_sym_u2047] = ACTIONS(279),
    [anon_sym_BSLASHsqcap] = ACTIONS(281),
    [anon_sym_u2293] = ACTIONS(281),
    [anon_sym_BSLASHsqcup] = ACTIONS(283),
    [anon_sym_u2294] = ACTIONS(283),
    [anon_sym_BSLASHuplus] = ACTIONS(285),
    [anon_sym_u228e] = ACTIONS(285),
    [anon_sym_BSLASHX] = ACTIONS(287),
    [anon_sym_BSLASHtimes] = ACTIONS(287),
    [anon_sym_u00d7] = ACTIONS(287),
    [anon_sym_BSLASHwr] = ACTIONS(289),
    [anon_sym_u2240] = ACTIONS(289),
    [anon_sym_BSLASHcdot] = ACTIONS(291),
    [anon_sym_u22c5] = ACTIONS(291),
    [sym_pow] = ACTIONS(167),
    [sym_powpow] = ACTIONS(241),
    [anon_sym_CARET_PLUS] = ACTIONS(293),
    [anon_sym_u207a] = ACTIONS(293),
    [sym_asterisk] = ACTIONS(295),
    [sym_sup_hash] = ACTIONS(295),
    [sym_prime] = ACTIONS(295),
    [anon_sym_ASSUME] = ACTIONS(333),
    [anon_sym_ASSUMPTION] = ACTIONS(333),
    [anon_sym_AXIOM] = ACTIONS(333),
    [anon_sym_THEOREM] = ACTIONS(333),
    [anon_sym_PROPOSITION] = ACTIONS(333),
    [anon_sym_LEMMA] = ACTIONS(333),
    [anon_sym_COROLLARY] = ACTIONS(333),
    [anon_sym_USE] = ACTIONS(333),
    [anon_sym_HIDE] = ACTIONS(333),
    [sym__indent] = ACTIONS(482),
    [sym__double_excl] = ACTIONS(277),
  },
  [12] = {
    [sym_block_comment] = STATE(12),
    [sym_forall] = STATE(3979),
    [sym_exists] = STATE(3979),
    [sym_langle_bracket] = STATE(66),
    [sym_subexpr_prefix] = STATE(1100),
    [sym_subexpr_component] = STATE(5469),
    [sym_bound_op] = STATE(2531),
    [sym_bound_nonfix_op] = STATE(2531),
    [sym__expr] = STATE(1888),
    [sym_prefixed_op] = STATE(2636),
    [sym__number] = STATE(2636),
    [sym_nat_number] = STATE(2558),
    [sym_binary_number] = STATE(2558),
    [sym_octal_number] = STATE(2558),
    [sym_hex_number] = STATE(2558),
    [sym_string] = STATE(2636),
    [sym_boolean] = STATE(2636),
    [sym__number_set] = STATE(2561),
    [sym__primitive_value_set] = STATE(2636),
    [sym_nat_number_set] = STATE(2630),
    [sym_int_number_set] = STATE(2630),
    [sym_real_number_set] = STATE(2630),
    [sym_label] = STATE(2636),
    [sym_subexpression] = STATE(2636),
    [sym_parentheses] = STATE(2636),
    [sym_bounded_quantification] = STATE(2636),
    [sym_unbounded_quantification] = STATE(2636),
    [sym_choose] = STATE(2636),
    [sym_finite_set_literal] = STATE(2636),
    [sym_set_filter] = STATE(2636),
    [sym_set_map] = STATE(2636),
    [sym_function_evaluation] = STATE(2636),
    [sym_function_literal] = STATE(2636),
    [sym_set_of_functions] = STATE(2636),
    [sym_record_literal] = STATE(2636),
    [sym_set_of_records] = STATE(2636),
    [sym_record_value] = STATE(2636),
    [sym_except] = STATE(2636),
    [sym_prev_func_val] = STATE(2636),
    [sym_tuple_literal] = STATE(2636),
    [sym_step_expr_or_stutter] = STATE(2636),
    [sym_step_expr_no_stutter] = STATE(2636),
    [sym_fairness] = STATE(2636),
    [sym_if_then_else] = STATE(2636),
    [sym_case] = STATE(2636),
    [sym_let_in] = STATE(2636),
    [sym_conj_list] = STATE(2636),
    [sym_disj_list] = STATE(2636),
    [sym_lnot] = STATE(53),
    [sym_negative] = STATE(984),
    [sym_always] = STATE(52),
    [sym_eventually] = STATE(52),
    [sym_prefix_op_symbol] = STATE(4943),
    [sym_bound_prefix_op] = STATE(2636),
    [sym_implies] = STATE(3441),
    [sym_plus_arrow] = STATE(3441),
    [sym_equiv] = STATE(3441),
    [sym_iff] = STATE(3441),
    [sym_leads_to] = STATE(3441),
    [sym_land] = STATE(3441),
    [sym_lor] = STATE(3441),
    [sym_assign] = STATE(3441),
    [sym_bnf_rule] = STATE(3441),
    [sym_eq] = STATE(3441),
    [sym_neq] = STATE(3441),
    [sym_lt] = STATE(3441),
    [sym_leq] = STATE(3441),
    [sym_geq] = STATE(3441),
    [sym_approx] = STATE(3441),
    [sym_rs_ttile] = STATE(3441),
    [sym_rd_ttile] = STATE(3441),
    [sym_ls_ttile] = STATE(3441),
    [sym_ld_ttile] = STATE(3441),
    [sym_asymp] = STATE(3441),
    [sym_cong] = STATE(3441),
    [sym_doteq] = STATE(3441),
    [sym_gg] = STATE(3441),
    [sym_ll] = STATE(3441),
    [sym_in] = STATE(3441),
    [sym_notin] = STATE(3441),
    [sym_prec] = STATE(3441),
    [sym_succ] = STATE(3441),
    [sym_preceq] = STATE(3441),
    [sym_succeq] = STATE(3441),
    [sym_propto] = STATE(3441),
    [sym_sim] = STATE(3441),
    [sym_simeq] = STATE(3441),
    [sym_sqsubset] = STATE(3441),
    [sym_sqsupset] = STATE(3441),
    [sym_sqsubseteq] = STATE(3441),
    [sym_sqsupseteq] = STATE(3441),
    [sym_subset] = STATE(3441),
    [sym_supset] = STATE(3441),
    [sym_subseteq] = STATE(3441),
    [sym_supseteq] = STATE(3441),
    [sym_cap] = STATE(3441),
    [sym_cup] = STATE(3441),
    [sym_dots_2] = STATE(3441),
    [sym_dots_3] = STATE(3441),
    [sym_plus] = STATE(3441),
    [sym_oplus] = STATE(3441),
    [sym_ominus] = STATE(3441),
    [sym_vertvert] = STATE(3441),
    [sym_minus] = STATE(3441),
    [sym_odot] = STATE(3441),
    [sym_oslash] = STATE(3441),
    [sym_otimes] = STATE(3441),
    [sym_bigcirc] = STATE(3441),
    [sym_bullet] = STATE(3441),
    [sym_div] = STATE(3441),
    [sym_circ] = STATE(3441),
    [sym_star] = STATE(3441),
    [sym_excl] = STATE(3441),
    [sym_qq] = STATE(3441),
    [sym_sqcap] = STATE(3441),
    [sym_sqcup] = STATE(3441),
    [sym_uplus] = STATE(3441),
    [sym_times] = STATE(3441),
    [sym_wr] = STATE(3441),
    [sym_cdot] = STATE(3441),
    [sym_infix_op_symbol] = STATE(5043),
    [sym_bound_infix_op] = STATE(2636),
    [sym_sup_plus] = STATE(3426),
    [sym_postfix_op_symbol] = STATE(4943),
    [sym_bound_postfix_op] = STATE(2636),
    [sym_assume_prove] = STATE(4973),
    [sym_inner_assume_prove] = STATE(5014),
    [sym_new] = STATE(5014),
    [sym_statement_level] = STATE(3875),
    [sym_proof_step_ref] = STATE(2521),
    [sym_identifier] = ACTIONS(484),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(59),
    [anon_sym_u2208] = ACTIONS(61),
    [anon_sym_BSLASHA] = ACTIONS(63),
    [anon_sym_BSLASHforall] = ACTIONS(65),
    [anon_sym_u2200] = ACTIONS(65),
    [anon_sym_BSLASHE] = ACTIONS(67),
    [anon_sym_BSLASHexists] = ACTIONS(69),
    [anon_sym_u2203] = ACTIONS(69),
    [sym_temporal_forall] = ACTIONS(486),
    [sym_temporal_exists] = ACTIONS(486),
    [anon_sym_LT_LT] = ACTIONS(73),
    [anon_sym_u3008] = ACTIONS(73),
    [anon_sym_u27e8] = ACTIONS(73),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(75),
    [anon_sym_u25a1] = ACTIONS(75),
    [anon_sym_AT] = ACTIONS(488),
    [anon_sym_SLASH_BSLASH] = ACTIONS(79),
    [anon_sym_u2227] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(81),
    [anon_sym_u2228] = ACTIONS(81),
    [anon_sym_VARIABLE] = ACTIONS(490),
    [anon_sym_CONSTANT] = ACTIONS(490),
    [anon_sym_LPAREN] = ACTIONS(492),
    [anon_sym_LBRACK] = ACTIONS(494),
    [aux_sym_child_id_token1] = ACTIONS(496),
    [sym_real_number] = ACTIONS(498),
    [anon_sym_BSLASHb] = ACTIONS(500),
    [anon_sym_BSLASHB] = ACTIONS(502),
    [anon_sym_BSLASHo] = ACTIONS(504),
    [anon_sym_BSLASHO] = ACTIONS(506),
    [anon_sym_BSLASHh] = ACTIONS(508),
    [anon_sym_BSLASHH] = ACTIONS(508),
    [anon_sym_DQUOTE] = ACTIONS(510),
    [anon_sym_TRUE] = ACTIONS(512),
    [anon_sym_FALSE] = ACTIONS(512),
    [sym_string_set] = ACTIONS(514),
    [sym_boolean_set] = ACTIONS(514),
    [anon_sym_Nat] = ACTIONS(516),
    [anon_sym_u2115] = ACTIONS(518),
    [anon_sym_Int] = ACTIONS(520),
    [anon_sym_u2124] = ACTIONS(522),
    [anon_sym_Real] = ACTIONS(524),
    [anon_sym_u211d] = ACTIONS(526),
    [anon_sym_CHOOSE] = ACTIONS(528),
    [anon_sym_LBRACE] = ACTIONS(530),
    [anon_sym_EQ] = ACTIONS(125),
    [anon_sym_WF_] = ACTIONS(532),
    [anon_sym_SF_] = ACTIONS(532),
    [anon_sym_IF] = ACTIONS(534),
    [anon_sym_CASE] = ACTIONS(536),
    [anon_sym_LET] = ACTIONS(538),
    [anon_sym_BSLASHlnot] = ACTIONS(135),
    [anon_sym_BSLASHneg] = ACTIONS(135),
    [anon_sym_TILDE] = ACTIONS(137),
    [anon_sym_u00ac] = ACTIONS(135),
    [sym_union] = ACTIONS(540),
    [sym_powerset] = ACTIONS(540),
    [sym_domain] = ACTIONS(540),
    [anon_sym_DASH] = ACTIONS(141),
    [sym_negative_dot] = ACTIONS(41),
    [sym_enabled] = ACTIONS(542),
    [sym_unchanged] = ACTIONS(542),
    [anon_sym_LT_GT] = ACTIONS(145),
    [anon_sym_u22c4] = ACTIONS(145),
    [anon_sym_u25c7] = ACTIONS(145),
    [anon_sym_EQ_GT] = ACTIONS(147),
    [anon_sym_u27f9] = ACTIONS(147),
    [anon_sym_u21d2] = ACTIONS(147),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(149),
    [anon_sym_u21f8] = ACTIONS(149),
    [anon_sym_u2945] = ACTIONS(149),
    [anon_sym_BSLASHequiv] = ACTIONS(151),
    [anon_sym_u2261] = ACTIONS(151),
    [anon_sym_LT_EQ_GT] = ACTIONS(153),
    [anon_sym_u27fa] = ACTIONS(153),
    [anon_sym_u21d4] = ACTIONS(153),
    [anon_sym_TILDE_GT] = ACTIONS(155),
    [anon_sym_u21dd] = ACTIONS(155),
    [anon_sym_u219d] = ACTIONS(155),
    [anon_sym_BSLASHland] = ACTIONS(79),
    [anon_sym_BSLASHlor] = ACTIONS(81),
    [anon_sym_COLON_EQ] = ACTIONS(157),
    [anon_sym_u2254] = ACTIONS(157),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(159),
    [anon_sym_u2a74] = ACTIONS(159),
    [anon_sym_SLASH_EQ] = ACTIONS(161),
    [anon_sym_POUND] = ACTIONS(163),
    [anon_sym_u2260] = ACTIONS(161),
    [anon_sym_LT] = ACTIONS(544),
    [sym_gt] = ACTIONS(167),
    [anon_sym_LT_EQ] = ACTIONS(169),
    [anon_sym_EQ_LT] = ACTIONS(171),
    [anon_sym_BSLASHleq] = ACTIONS(171),
    [anon_sym_u2264] = ACTIONS(171),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_BSLASHgeq] = ACTIONS(173),
    [anon_sym_u2265] = ACTIONS(173),
    [anon_sym_BSLASHapprox] = ACTIONS(175),
    [anon_sym_u2248] = ACTIONS(175),
    [anon_sym_PIPE_DASH] = ACTIONS(177),
    [anon_sym_u22a2] = ACTIONS(177),
    [anon_sym_PIPE_EQ] = ACTIONS(179),
    [anon_sym_u22a8] = ACTIONS(179),
    [anon_sym_DASH_PIPE] = ACTIONS(181),
    [anon_sym_u22a3] = ACTIONS(181),
    [anon_sym_EQ_PIPE] = ACTIONS(183),
    [anon_sym_u2ae4] = ACTIONS(183),
    [anon_sym_BSLASHasymp] = ACTIONS(185),
    [anon_sym_u224d] = ACTIONS(185),
    [anon_sym_BSLASHcong] = ACTIONS(187),
    [anon_sym_u2245] = ACTIONS(187),
    [anon_sym_BSLASHdoteq] = ACTIONS(189),
    [anon_sym_u2250] = ACTIONS(189),
    [anon_sym_BSLASHgg] = ACTIONS(191),
    [anon_sym_u226b] = ACTIONS(191),
    [anon_sym_BSLASHll] = ACTIONS(193),
    [anon_sym_u226a] = ACTIONS(193),
    [anon_sym_BSLASHnotin] = ACTIONS(195),
    [anon_sym_u2209] = ACTIONS(195),
    [anon_sym_BSLASHprec] = ACTIONS(197),
    [anon_sym_u227a] = ACTIONS(199),
    [anon_sym_BSLASHsucc] = ACTIONS(201),
    [anon_sym_u227b] = ACTIONS(203),
    [anon_sym_BSLASHpreceq] = ACTIONS(205),
    [anon_sym_u2aaf] = ACTIONS(205),
    [anon_sym_BSLASHsucceq] = ACTIONS(207),
    [anon_sym_u2ab0] = ACTIONS(207),
    [anon_sym_BSLASHpropto] = ACTIONS(209),
    [anon_sym_u221d] = ACTIONS(209),
    [anon_sym_BSLASHsim] = ACTIONS(211),
    [anon_sym_u223c] = ACTIONS(213),
    [anon_sym_BSLASHsimeq] = ACTIONS(215),
    [anon_sym_u2243] = ACTIONS(215),
    [anon_sym_BSLASHsqsubset] = ACTIONS(217),
    [anon_sym_u228f] = ACTIONS(219),
    [anon_sym_BSLASHsqsupset] = ACTIONS(221),
    [anon_sym_u2290] = ACTIONS(223),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(225),
    [anon_sym_u2291] = ACTIONS(225),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(227),
    [anon_sym_u2292] = ACTIONS(227),
    [anon_sym_BSLASHsubset] = ACTIONS(229),
    [anon_sym_u2282] = ACTIONS(231),
    [anon_sym_BSLASHsupset] = ACTIONS(233),
    [anon_sym_u2283] = ACTIONS(235),
    [anon_sym_BSLASHsubseteq] = ACTIONS(237),
    [anon_sym_u2286] = ACTIONS(237),
    [anon_sym_BSLASHsupseteq] = ACTIONS(239),
    [anon_sym_u2287] = ACTIONS(239),
    [sym_compose] = ACTIONS(241),
    [sym_map_to] = ACTIONS(241),
    [sym_map_from] = ACTIONS(241),
    [sym_setminus] = ACTIONS(167),
    [anon_sym_BSLASHcap] = ACTIONS(243),
    [anon_sym_BSLASHintersect] = ACTIONS(243),
    [anon_sym_u2229] = ACTIONS(243),
    [anon_sym_BSLASHcup] = ACTIONS(245),
    [anon_sym_BSLASHunion] = ACTIONS(245),
    [anon_sym_u222a] = ACTIONS(245),
    [anon_sym_DOT_DOT] = ACTIONS(247),
    [anon_sym_u2025] = ACTIONS(249),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(251),
    [anon_sym_u2026] = ACTIONS(251),
    [anon_sym_PLUS] = ACTIONS(253),
    [sym_plusplus] = ACTIONS(241),
    [anon_sym_BSLASHoplus] = ACTIONS(255),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(255),
    [anon_sym_u2295] = ACTIONS(255),
    [anon_sym_BSLASHominus] = ACTIONS(257),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(257),
    [anon_sym_u2296] = ACTIONS(257),
    [sym_mod] = ACTIONS(167),
    [sym_modmod] = ACTIONS(241),
    [sym_vert] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_u2016] = ACTIONS(259),
    [sym_minusminus] = ACTIONS(241),
    [sym_amp] = ACTIONS(167),
    [sym_ampamp] = ACTIONS(241),
    [anon_sym_BSLASHodot] = ACTIONS(261),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(261),
    [anon_sym_u2299] = ACTIONS(261),
    [anon_sym_BSLASHoslash] = ACTIONS(263),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(263),
    [anon_sym_u2298] = ACTIONS(263),
    [anon_sym_BSLASHotimes] = ACTIONS(265),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(265),
    [anon_sym_u2297] = ACTIONS(265),
    [sym_mul] = ACTIONS(167),
    [sym_mulmul] = ACTIONS(241),
    [sym_slash] = ACTIONS(167),
    [sym_slashslash] = ACTIONS(241),
    [anon_sym_BSLASHbigcirc] = ACTIONS(267),
    [anon_sym_u25ef] = ACTIONS(267),
    [anon_sym_BSLASHbullet] = ACTIONS(269),
    [anon_sym_u25cf] = ACTIONS(269),
    [anon_sym_BSLASHdiv] = ACTIONS(271),
    [anon_sym_u00f7] = ACTIONS(271),
    [anon_sym_BSLASHcirc] = ACTIONS(273),
    [anon_sym_u2218] = ACTIONS(273),
    [anon_sym_BSLASHstar] = ACTIONS(275),
    [anon_sym_u22c6] = ACTIONS(275),
    [anon_sym_u203c] = ACTIONS(277),
    [sym_hashhash] = ACTIONS(241),
    [sym_dol] = ACTIONS(167),
    [sym_doldol] = ACTIONS(241),
    [anon_sym_QMARK_QMARK] = ACTIONS(279),
    [anon_sym_u2047] = ACTIONS(279),
    [anon_sym_BSLASHsqcap] = ACTIONS(281),
    [anon_sym_u2293] = ACTIONS(281),
    [anon_sym_BSLASHsqcup] = ACTIONS(283),
    [anon_sym_u2294] = ACTIONS(283),
    [anon_sym_BSLASHuplus] = ACTIONS(285),
    [anon_sym_u228e] = ACTIONS(285),
    [anon_sym_BSLASHX] = ACTIONS(287),
    [anon_sym_BSLASHtimes] = ACTIONS(287),
    [anon_sym_u00d7] = ACTIONS(287),
    [anon_sym_BSLASHwr] = ACTIONS(289),
    [anon_sym_u2240] = ACTIONS(289),
    [anon_sym_BSLASHcdot] = ACTIONS(291),
    [anon_sym_u22c5] = ACTIONS(291),
    [sym_pow] = ACTIONS(167),
    [sym_powpow] = ACTIONS(241),
    [anon_sym_CARET_PLUS] = ACTIONS(293),
    [anon_sym_u207a] = ACTIONS(293),
    [sym_asterisk] = ACTIONS(295),
    [sym_sup_hash] = ACTIONS(295),
    [sym_prime] = ACTIONS(295),
    [anon_sym_ASSUME] = ACTIONS(546),
    [anon_sym_NEW] = ACTIONS(548),
    [anon_sym_STATE] = ACTIONS(490),
    [anon_sym_ACTION] = ACTIONS(490),
    [anon_sym_TEMPORAL] = ACTIONS(490),
    [sym__indent] = ACTIONS(550),
    [sym__double_excl] = ACTIONS(277),
  },
  [13] = {
    [sym_block_comment] = STATE(13),
    [sym_forall] = STATE(3979),
    [sym_exists] = STATE(3979),
    [sym_langle_bracket] = STATE(66),
    [sym_subexpr_prefix] = STATE(1100),
    [sym_subexpr_component] = STATE(5469),
    [sym_bound_op] = STATE(2531),
    [sym_bound_nonfix_op] = STATE(2531),
    [sym__expr] = STATE(1854),
    [sym_prefixed_op] = STATE(2636),
    [sym__number] = STATE(2636),
    [sym_nat_number] = STATE(2558),
    [sym_binary_number] = STATE(2558),
    [sym_octal_number] = STATE(2558),
    [sym_hex_number] = STATE(2558),
    [sym_string] = STATE(2636),
    [sym_boolean] = STATE(2636),
    [sym__number_set] = STATE(2561),
    [sym__primitive_value_set] = STATE(2636),
    [sym_nat_number_set] = STATE(2630),
    [sym_int_number_set] = STATE(2630),
    [sym_real_number_set] = STATE(2630),
    [sym_label] = STATE(2636),
    [sym_subexpression] = STATE(2636),
    [sym_parentheses] = STATE(2636),
    [sym_bounded_quantification] = STATE(2636),
    [sym_unbounded_quantification] = STATE(2636),
    [sym_choose] = STATE(2636),
    [sym_finite_set_literal] = STATE(2636),
    [sym_set_filter] = STATE(2636),
    [sym_set_map] = STATE(2636),
    [sym_function_evaluation] = STATE(2636),
    [sym_function_literal] = STATE(2636),
    [sym_set_of_functions] = STATE(2636),
    [sym_record_literal] = STATE(2636),
    [sym_set_of_records] = STATE(2636),
    [sym_record_value] = STATE(2636),
    [sym_except] = STATE(2636),
    [sym_prev_func_val] = STATE(2636),
    [sym_tuple_literal] = STATE(2636),
    [sym_step_expr_or_stutter] = STATE(2636),
    [sym_step_expr_no_stutter] = STATE(2636),
    [sym_fairness] = STATE(2636),
    [sym_if_then_else] = STATE(2636),
    [sym_case] = STATE(2636),
    [sym_let_in] = STATE(2636),
    [sym_conj_list] = STATE(2636),
    [sym_disj_list] = STATE(2636),
    [sym_lnot] = STATE(53),
    [sym_negative] = STATE(984),
    [sym_always] = STATE(52),
    [sym_eventually] = STATE(52),
    [sym_prefix_op_symbol] = STATE(4943),
    [sym_bound_prefix_op] = STATE(2636),
    [sym_implies] = STATE(3441),
    [sym_plus_arrow] = STATE(3441),
    [sym_equiv] = STATE(3441),
    [sym_iff] = STATE(3441),
    [sym_leads_to] = STATE(3441),
    [sym_land] = STATE(3441),
    [sym_lor] = STATE(3441),
    [sym_assign] = STATE(3441),
    [sym_bnf_rule] = STATE(3441),
    [sym_eq] = STATE(3441),
    [sym_neq] = STATE(3441),
    [sym_lt] = STATE(3441),
    [sym_leq] = STATE(3441),
    [sym_geq] = STATE(3441),
    [sym_approx] = STATE(3441),
    [sym_rs_ttile] = STATE(3441),
    [sym_rd_ttile] = STATE(3441),
    [sym_ls_ttile] = STATE(3441),
    [sym_ld_ttile] = STATE(3441),
    [sym_asymp] = STATE(3441),
    [sym_cong] = STATE(3441),
    [sym_doteq] = STATE(3441),
    [sym_gg] = STATE(3441),
    [sym_ll] = STATE(3441),
    [sym_in] = STATE(3441),
    [sym_notin] = STATE(3441),
    [sym_prec] = STATE(3441),
    [sym_succ] = STATE(3441),
    [sym_preceq] = STATE(3441),
    [sym_succeq] = STATE(3441),
    [sym_propto] = STATE(3441),
    [sym_sim] = STATE(3441),
    [sym_simeq] = STATE(3441),
    [sym_sqsubset] = STATE(3441),
    [sym_sqsupset] = STATE(3441),
    [sym_sqsubseteq] = STATE(3441),
    [sym_sqsupseteq] = STATE(3441),
    [sym_subset] = STATE(3441),
    [sym_supset] = STATE(3441),
    [sym_subseteq] = STATE(3441),
    [sym_supseteq] = STATE(3441),
    [sym_cap] = STATE(3441),
    [sym_cup] = STATE(3441),
    [sym_dots_2] = STATE(3441),
    [sym_dots_3] = STATE(3441),
    [sym_plus] = STATE(3441),
    [sym_oplus] = STATE(3441),
    [sym_ominus] = STATE(3441),
    [sym_vertvert] = STATE(3441),
    [sym_minus] = STATE(3441),
    [sym_odot] = STATE(3441),
    [sym_oslash] = STATE(3441),
    [sym_otimes] = STATE(3441),
    [sym_bigcirc] = STATE(3441),
    [sym_bullet] = STATE(3441),
    [sym_div] = STATE(3441),
    [sym_circ] = STATE(3441),
    [sym_star] = STATE(3441),
    [sym_excl] = STATE(3441),
    [sym_qq] = STATE(3441),
    [sym_sqcap] = STATE(3441),
    [sym_sqcup] = STATE(3441),
    [sym_uplus] = STATE(3441),
    [sym_times] = STATE(3441),
    [sym_wr] = STATE(3441),
    [sym_cdot] = STATE(3441),
    [sym_infix_op_symbol] = STATE(5043),
    [sym_bound_infix_op] = STATE(2636),
    [sym_sup_plus] = STATE(3426),
    [sym_postfix_op_symbol] = STATE(4943),
    [sym_bound_postfix_op] = STATE(2636),
    [sym_assume_prove] = STATE(4973),
    [sym_inner_assume_prove] = STATE(4713),
    [sym_new] = STATE(4713),
    [sym_statement_level] = STATE(3875),
    [sym_proof_step_ref] = STATE(2521),
    [sym_identifier] = ACTIONS(484),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(59),
    [anon_sym_u2208] = ACTIONS(61),
    [anon_sym_BSLASHA] = ACTIONS(63),
    [anon_sym_BSLASHforall] = ACTIONS(65),
    [anon_sym_u2200] = ACTIONS(65),
    [anon_sym_BSLASHE] = ACTIONS(67),
    [anon_sym_BSLASHexists] = ACTIONS(69),
    [anon_sym_u2203] = ACTIONS(69),
    [sym_temporal_forall] = ACTIONS(486),
    [sym_temporal_exists] = ACTIONS(486),
    [anon_sym_LT_LT] = ACTIONS(73),
    [anon_sym_u3008] = ACTIONS(73),
    [anon_sym_u27e8] = ACTIONS(73),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(75),
    [anon_sym_u25a1] = ACTIONS(75),
    [anon_sym_AT] = ACTIONS(488),
    [anon_sym_SLASH_BSLASH] = ACTIONS(79),
    [anon_sym_u2227] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(81),
    [anon_sym_u2228] = ACTIONS(81),
    [anon_sym_VARIABLE] = ACTIONS(490),
    [anon_sym_CONSTANT] = ACTIONS(490),
    [anon_sym_LPAREN] = ACTIONS(492),
    [anon_sym_LBRACK] = ACTIONS(494),
    [aux_sym_child_id_token1] = ACTIONS(496),
    [sym_real_number] = ACTIONS(498),
    [anon_sym_BSLASHb] = ACTIONS(500),
    [anon_sym_BSLASHB] = ACTIONS(502),
    [anon_sym_BSLASHo] = ACTIONS(504),
    [anon_sym_BSLASHO] = ACTIONS(506),
    [anon_sym_BSLASHh] = ACTIONS(508),
    [anon_sym_BSLASHH] = ACTIONS(508),
    [anon_sym_DQUOTE] = ACTIONS(510),
    [anon_sym_TRUE] = ACTIONS(512),
    [anon_sym_FALSE] = ACTIONS(512),
    [sym_string_set] = ACTIONS(514),
    [sym_boolean_set] = ACTIONS(514),
    [anon_sym_Nat] = ACTIONS(516),
    [anon_sym_u2115] = ACTIONS(518),
    [anon_sym_Int] = ACTIONS(520),
    [anon_sym_u2124] = ACTIONS(522),
    [anon_sym_Real] = ACTIONS(524),
    [anon_sym_u211d] = ACTIONS(526),
    [anon_sym_CHOOSE] = ACTIONS(528),
    [anon_sym_LBRACE] = ACTIONS(530),
    [anon_sym_EQ] = ACTIONS(125),
    [anon_sym_WF_] = ACTIONS(532),
    [anon_sym_SF_] = ACTIONS(532),
    [anon_sym_IF] = ACTIONS(534),
    [anon_sym_CASE] = ACTIONS(536),
    [anon_sym_LET] = ACTIONS(538),
    [anon_sym_BSLASHlnot] = ACTIONS(135),
    [anon_sym_BSLASHneg] = ACTIONS(135),
    [anon_sym_TILDE] = ACTIONS(137),
    [anon_sym_u00ac] = ACTIONS(135),
    [sym_union] = ACTIONS(540),
    [sym_powerset] = ACTIONS(540),
    [sym_domain] = ACTIONS(540),
    [anon_sym_DASH] = ACTIONS(141),
    [sym_negative_dot] = ACTIONS(41),
    [sym_enabled] = ACTIONS(542),
    [sym_unchanged] = ACTIONS(542),
    [anon_sym_LT_GT] = ACTIONS(145),
    [anon_sym_u22c4] = ACTIONS(145),
    [anon_sym_u25c7] = ACTIONS(145),
    [anon_sym_EQ_GT] = ACTIONS(147),
    [anon_sym_u27f9] = ACTIONS(147),
    [anon_sym_u21d2] = ACTIONS(147),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(149),
    [anon_sym_u21f8] = ACTIONS(149),
    [anon_sym_u2945] = ACTIONS(149),
    [anon_sym_BSLASHequiv] = ACTIONS(151),
    [anon_sym_u2261] = ACTIONS(151),
    [anon_sym_LT_EQ_GT] = ACTIONS(153),
    [anon_sym_u27fa] = ACTIONS(153),
    [anon_sym_u21d4] = ACTIONS(153),
    [anon_sym_TILDE_GT] = ACTIONS(155),
    [anon_sym_u21dd] = ACTIONS(155),
    [anon_sym_u219d] = ACTIONS(155),
    [anon_sym_BSLASHland] = ACTIONS(79),
    [anon_sym_BSLASHlor] = ACTIONS(81),
    [anon_sym_COLON_EQ] = ACTIONS(157),
    [anon_sym_u2254] = ACTIONS(157),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(159),
    [anon_sym_u2a74] = ACTIONS(159),
    [anon_sym_SLASH_EQ] = ACTIONS(161),
    [anon_sym_POUND] = ACTIONS(163),
    [anon_sym_u2260] = ACTIONS(161),
    [anon_sym_LT] = ACTIONS(544),
    [sym_gt] = ACTIONS(167),
    [anon_sym_LT_EQ] = ACTIONS(169),
    [anon_sym_EQ_LT] = ACTIONS(171),
    [anon_sym_BSLASHleq] = ACTIONS(171),
    [anon_sym_u2264] = ACTIONS(171),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_BSLASHgeq] = ACTIONS(173),
    [anon_sym_u2265] = ACTIONS(173),
    [anon_sym_BSLASHapprox] = ACTIONS(175),
    [anon_sym_u2248] = ACTIONS(175),
    [anon_sym_PIPE_DASH] = ACTIONS(177),
    [anon_sym_u22a2] = ACTIONS(177),
    [anon_sym_PIPE_EQ] = ACTIONS(179),
    [anon_sym_u22a8] = ACTIONS(179),
    [anon_sym_DASH_PIPE] = ACTIONS(181),
    [anon_sym_u22a3] = ACTIONS(181),
    [anon_sym_EQ_PIPE] = ACTIONS(183),
    [anon_sym_u2ae4] = ACTIONS(183),
    [anon_sym_BSLASHasymp] = ACTIONS(185),
    [anon_sym_u224d] = ACTIONS(185),
    [anon_sym_BSLASHcong] = ACTIONS(187),
    [anon_sym_u2245] = ACTIONS(187),
    [anon_sym_BSLASHdoteq] = ACTIONS(189),
    [anon_sym_u2250] = ACTIONS(189),
    [anon_sym_BSLASHgg] = ACTIONS(191),
    [anon_sym_u226b] = ACTIONS(191),
    [anon_sym_BSLASHll] = ACTIONS(193),
    [anon_sym_u226a] = ACTIONS(193),
    [anon_sym_BSLASHnotin] = ACTIONS(195),
    [anon_sym_u2209] = ACTIONS(195),
    [anon_sym_BSLASHprec] = ACTIONS(197),
    [anon_sym_u227a] = ACTIONS(199),
    [anon_sym_BSLASHsucc] = ACTIONS(201),
    [anon_sym_u227b] = ACTIONS(203),
    [anon_sym_BSLASHpreceq] = ACTIONS(205),
    [anon_sym_u2aaf] = ACTIONS(205),
    [anon_sym_BSLASHsucceq] = ACTIONS(207),
    [anon_sym_u2ab0] = ACTIONS(207),
    [anon_sym_BSLASHpropto] = ACTIONS(209),
    [anon_sym_u221d] = ACTIONS(209),
    [anon_sym_BSLASHsim] = ACTIONS(211),
    [anon_sym_u223c] = ACTIONS(213),
    [anon_sym_BSLASHsimeq] = ACTIONS(215),
    [anon_sym_u2243] = ACTIONS(215),
    [anon_sym_BSLASHsqsubset] = ACTIONS(217),
    [anon_sym_u228f] = ACTIONS(219),
    [anon_sym_BSLASHsqsupset] = ACTIONS(221),
    [anon_sym_u2290] = ACTIONS(223),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(225),
    [anon_sym_u2291] = ACTIONS(225),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(227),
    [anon_sym_u2292] = ACTIONS(227),
    [anon_sym_BSLASHsubset] = ACTIONS(229),
    [anon_sym_u2282] = ACTIONS(231),
    [anon_sym_BSLASHsupset] = ACTIONS(233),
    [anon_sym_u2283] = ACTIONS(235),
    [anon_sym_BSLASHsubseteq] = ACTIONS(237),
    [anon_sym_u2286] = ACTIONS(237),
    [anon_sym_BSLASHsupseteq] = ACTIONS(239),
    [anon_sym_u2287] = ACTIONS(239),
    [sym_compose] = ACTIONS(241),
    [sym_map_to] = ACTIONS(241),
    [sym_map_from] = ACTIONS(241),
    [sym_setminus] = ACTIONS(167),
    [anon_sym_BSLASHcap] = ACTIONS(243),
    [anon_sym_BSLASHintersect] = ACTIONS(243),
    [anon_sym_u2229] = ACTIONS(243),
    [anon_sym_BSLASHcup] = ACTIONS(245),
    [anon_sym_BSLASHunion] = ACTIONS(245),
    [anon_sym_u222a] = ACTIONS(245),
    [anon_sym_DOT_DOT] = ACTIONS(247),
    [anon_sym_u2025] = ACTIONS(249),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(251),
    [anon_sym_u2026] = ACTIONS(251),
    [anon_sym_PLUS] = ACTIONS(253),
    [sym_plusplus] = ACTIONS(241),
    [anon_sym_BSLASHoplus] = ACTIONS(255),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(255),
    [anon_sym_u2295] = ACTIONS(255),
    [anon_sym_BSLASHominus] = ACTIONS(257),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(257),
    [anon_sym_u2296] = ACTIONS(257),
    [sym_mod] = ACTIONS(167),
    [sym_modmod] = ACTIONS(241),
    [sym_vert] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_u2016] = ACTIONS(259),
    [sym_minusminus] = ACTIONS(241),
    [sym_amp] = ACTIONS(167),
    [sym_ampamp] = ACTIONS(241),
    [anon_sym_BSLASHodot] = ACTIONS(261),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(261),
    [anon_sym_u2299] = ACTIONS(261),
    [anon_sym_BSLASHoslash] = ACTIONS(263),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(263),
    [anon_sym_u2298] = ACTIONS(263),
    [anon_sym_BSLASHotimes] = ACTIONS(265),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(265),
    [anon_sym_u2297] = ACTIONS(265),
    [sym_mul] = ACTIONS(167),
    [sym_mulmul] = ACTIONS(241),
    [sym_slash] = ACTIONS(167),
    [sym_slashslash] = ACTIONS(241),
    [anon_sym_BSLASHbigcirc] = ACTIONS(267),
    [anon_sym_u25ef] = ACTIONS(267),
    [anon_sym_BSLASHbullet] = ACTIONS(269),
    [anon_sym_u25cf] = ACTIONS(269),
    [anon_sym_BSLASHdiv] = ACTIONS(271),
    [anon_sym_u00f7] = ACTIONS(271),
    [anon_sym_BSLASHcirc] = ACTIONS(273),
    [anon_sym_u2218] = ACTIONS(273),
    [anon_sym_BSLASHstar] = ACTIONS(275),
    [anon_sym_u22c6] = ACTIONS(275),
    [anon_sym_u203c] = ACTIONS(277),
    [sym_hashhash] = ACTIONS(241),
    [sym_dol] = ACTIONS(167),
    [sym_doldol] = ACTIONS(241),
    [anon_sym_QMARK_QMARK] = ACTIONS(279),
    [anon_sym_u2047] = ACTIONS(279),
    [anon_sym_BSLASHsqcap] = ACTIONS(281),
    [anon_sym_u2293] = ACTIONS(281),
    [anon_sym_BSLASHsqcup] = ACTIONS(283),
    [anon_sym_u2294] = ACTIONS(283),
    [anon_sym_BSLASHuplus] = ACTIONS(285),
    [anon_sym_u228e] = ACTIONS(285),
    [anon_sym_BSLASHX] = ACTIONS(287),
    [anon_sym_BSLASHtimes] = ACTIONS(287),
    [anon_sym_u00d7] = ACTIONS(287),
    [anon_sym_BSLASHwr] = ACTIONS(289),
    [anon_sym_u2240] = ACTIONS(289),
    [anon_sym_BSLASHcdot] = ACTIONS(291),
    [anon_sym_u22c5] = ACTIONS(291),
    [sym_pow] = ACTIONS(167),
    [sym_powpow] = ACTIONS(241),
    [anon_sym_CARET_PLUS] = ACTIONS(293),
    [anon_sym_u207a] = ACTIONS(293),
    [sym_asterisk] = ACTIONS(295),
    [sym_sup_hash] = ACTIONS(295),
    [sym_prime] = ACTIONS(295),
    [anon_sym_ASSUME] = ACTIONS(546),
    [anon_sym_NEW] = ACTIONS(548),
    [anon_sym_STATE] = ACTIONS(490),
    [anon_sym_ACTION] = ACTIONS(490),
    [anon_sym_TEMPORAL] = ACTIONS(490),
    [sym__indent] = ACTIONS(550),
    [sym__double_excl] = ACTIONS(277),
  },
  [14] = {
    [sym_block_comment] = STATE(14),
    [sym_forall] = STATE(3979),
    [sym_exists] = STATE(3979),
    [sym_langle_bracket] = STATE(66),
    [sym_subexpr_prefix] = STATE(1100),
    [sym_subexpr_component] = STATE(5469),
    [sym_bound_op] = STATE(2531),
    [sym_bound_nonfix_op] = STATE(2531),
    [sym__expr] = STATE(1848),
    [sym_prefixed_op] = STATE(2636),
    [sym__number] = STATE(2636),
    [sym_nat_number] = STATE(2558),
    [sym_binary_number] = STATE(2558),
    [sym_octal_number] = STATE(2558),
    [sym_hex_number] = STATE(2558),
    [sym_string] = STATE(2636),
    [sym_boolean] = STATE(2636),
    [sym__number_set] = STATE(2561),
    [sym__primitive_value_set] = STATE(2636),
    [sym_nat_number_set] = STATE(2630),
    [sym_int_number_set] = STATE(2630),
    [sym_real_number_set] = STATE(2630),
    [sym_label] = STATE(2636),
    [sym_subexpression] = STATE(2636),
    [sym_parentheses] = STATE(2636),
    [sym_bounded_quantification] = STATE(2636),
    [sym_unbounded_quantification] = STATE(2636),
    [sym_choose] = STATE(2636),
    [sym_finite_set_literal] = STATE(2636),
    [sym_set_filter] = STATE(2636),
    [sym_set_map] = STATE(2636),
    [sym_function_evaluation] = STATE(2636),
    [sym_function_literal] = STATE(2636),
    [sym_set_of_functions] = STATE(2636),
    [sym_record_literal] = STATE(2636),
    [sym_set_of_records] = STATE(2636),
    [sym_record_value] = STATE(2636),
    [sym_except] = STATE(2636),
    [sym_prev_func_val] = STATE(2636),
    [sym_tuple_literal] = STATE(2636),
    [sym_step_expr_or_stutter] = STATE(2636),
    [sym_step_expr_no_stutter] = STATE(2636),
    [sym_fairness] = STATE(2636),
    [sym_if_then_else] = STATE(2636),
    [sym_case] = STATE(2636),
    [sym_let_in] = STATE(2636),
    [sym_conj_list] = STATE(2636),
    [sym_disj_list] = STATE(2636),
    [sym_lnot] = STATE(53),
    [sym_negative] = STATE(984),
    [sym_always] = STATE(52),
    [sym_eventually] = STATE(52),
    [sym_prefix_op_symbol] = STATE(4943),
    [sym_bound_prefix_op] = STATE(2636),
    [sym_implies] = STATE(3441),
    [sym_plus_arrow] = STATE(3441),
    [sym_equiv] = STATE(3441),
    [sym_iff] = STATE(3441),
    [sym_leads_to] = STATE(3441),
    [sym_land] = STATE(3441),
    [sym_lor] = STATE(3441),
    [sym_assign] = STATE(3441),
    [sym_bnf_rule] = STATE(3441),
    [sym_eq] = STATE(3441),
    [sym_neq] = STATE(3441),
    [sym_lt] = STATE(3441),
    [sym_leq] = STATE(3441),
    [sym_geq] = STATE(3441),
    [sym_approx] = STATE(3441),
    [sym_rs_ttile] = STATE(3441),
    [sym_rd_ttile] = STATE(3441),
    [sym_ls_ttile] = STATE(3441),
    [sym_ld_ttile] = STATE(3441),
    [sym_asymp] = STATE(3441),
    [sym_cong] = STATE(3441),
    [sym_doteq] = STATE(3441),
    [sym_gg] = STATE(3441),
    [sym_ll] = STATE(3441),
    [sym_in] = STATE(3441),
    [sym_notin] = STATE(3441),
    [sym_prec] = STATE(3441),
    [sym_succ] = STATE(3441),
    [sym_preceq] = STATE(3441),
    [sym_succeq] = STATE(3441),
    [sym_propto] = STATE(3441),
    [sym_sim] = STATE(3441),
    [sym_simeq] = STATE(3441),
    [sym_sqsubset] = STATE(3441),
    [sym_sqsupset] = STATE(3441),
    [sym_sqsubseteq] = STATE(3441),
    [sym_sqsupseteq] = STATE(3441),
    [sym_subset] = STATE(3441),
    [sym_supset] = STATE(3441),
    [sym_subseteq] = STATE(3441),
    [sym_supseteq] = STATE(3441),
    [sym_cap] = STATE(3441),
    [sym_cup] = STATE(3441),
    [sym_dots_2] = STATE(3441),
    [sym_dots_3] = STATE(3441),
    [sym_plus] = STATE(3441),
    [sym_oplus] = STATE(3441),
    [sym_ominus] = STATE(3441),
    [sym_vertvert] = STATE(3441),
    [sym_minus] = STATE(3441),
    [sym_odot] = STATE(3441),
    [sym_oslash] = STATE(3441),
    [sym_otimes] = STATE(3441),
    [sym_bigcirc] = STATE(3441),
    [sym_bullet] = STATE(3441),
    [sym_div] = STATE(3441),
    [sym_circ] = STATE(3441),
    [sym_star] = STATE(3441),
    [sym_excl] = STATE(3441),
    [sym_qq] = STATE(3441),
    [sym_sqcap] = STATE(3441),
    [sym_sqcup] = STATE(3441),
    [sym_uplus] = STATE(3441),
    [sym_times] = STATE(3441),
    [sym_wr] = STATE(3441),
    [sym_cdot] = STATE(3441),
    [sym_infix_op_symbol] = STATE(5043),
    [sym_bound_infix_op] = STATE(2636),
    [sym_sup_plus] = STATE(3426),
    [sym_postfix_op_symbol] = STATE(4943),
    [sym_bound_postfix_op] = STATE(2636),
    [sym_assume_prove] = STATE(4973),
    [sym_inner_assume_prove] = STATE(4610),
    [sym_new] = STATE(4610),
    [sym_statement_level] = STATE(3875),
    [sym_proof_step_ref] = STATE(2521),
    [sym_identifier] = ACTIONS(484),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(59),
    [anon_sym_u2208] = ACTIONS(61),
    [anon_sym_BSLASHA] = ACTIONS(63),
    [anon_sym_BSLASHforall] = ACTIONS(65),
    [anon_sym_u2200] = ACTIONS(65),
    [anon_sym_BSLASHE] = ACTIONS(67),
    [anon_sym_BSLASHexists] = ACTIONS(69),
    [anon_sym_u2203] = ACTIONS(69),
    [sym_temporal_forall] = ACTIONS(486),
    [sym_temporal_exists] = ACTIONS(486),
    [anon_sym_LT_LT] = ACTIONS(73),
    [anon_sym_u3008] = ACTIONS(73),
    [anon_sym_u27e8] = ACTIONS(73),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(75),
    [anon_sym_u25a1] = ACTIONS(75),
    [anon_sym_AT] = ACTIONS(488),
    [anon_sym_SLASH_BSLASH] = ACTIONS(79),
    [anon_sym_u2227] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(81),
    [anon_sym_u2228] = ACTIONS(81),
    [anon_sym_VARIABLE] = ACTIONS(490),
    [anon_sym_CONSTANT] = ACTIONS(490),
    [anon_sym_LPAREN] = ACTIONS(492),
    [anon_sym_LBRACK] = ACTIONS(494),
    [aux_sym_child_id_token1] = ACTIONS(496),
    [sym_real_number] = ACTIONS(498),
    [anon_sym_BSLASHb] = ACTIONS(500),
    [anon_sym_BSLASHB] = ACTIONS(502),
    [anon_sym_BSLASHo] = ACTIONS(504),
    [anon_sym_BSLASHO] = ACTIONS(506),
    [anon_sym_BSLASHh] = ACTIONS(508),
    [anon_sym_BSLASHH] = ACTIONS(508),
    [anon_sym_DQUOTE] = ACTIONS(510),
    [anon_sym_TRUE] = ACTIONS(512),
    [anon_sym_FALSE] = ACTIONS(512),
    [sym_string_set] = ACTIONS(514),
    [sym_boolean_set] = ACTIONS(514),
    [anon_sym_Nat] = ACTIONS(516),
    [anon_sym_u2115] = ACTIONS(518),
    [anon_sym_Int] = ACTIONS(520),
    [anon_sym_u2124] = ACTIONS(522),
    [anon_sym_Real] = ACTIONS(524),
    [anon_sym_u211d] = ACTIONS(526),
    [anon_sym_CHOOSE] = ACTIONS(528),
    [anon_sym_LBRACE] = ACTIONS(530),
    [anon_sym_EQ] = ACTIONS(125),
    [anon_sym_WF_] = ACTIONS(532),
    [anon_sym_SF_] = ACTIONS(532),
    [anon_sym_IF] = ACTIONS(534),
    [anon_sym_CASE] = ACTIONS(536),
    [anon_sym_LET] = ACTIONS(538),
    [anon_sym_BSLASHlnot] = ACTIONS(135),
    [anon_sym_BSLASHneg] = ACTIONS(135),
    [anon_sym_TILDE] = ACTIONS(137),
    [anon_sym_u00ac] = ACTIONS(135),
    [sym_union] = ACTIONS(540),
    [sym_powerset] = ACTIONS(540),
    [sym_domain] = ACTIONS(540),
    [anon_sym_DASH] = ACTIONS(141),
    [sym_negative_dot] = ACTIONS(41),
    [sym_enabled] = ACTIONS(542),
    [sym_unchanged] = ACTIONS(542),
    [anon_sym_LT_GT] = ACTIONS(145),
    [anon_sym_u22c4] = ACTIONS(145),
    [anon_sym_u25c7] = ACTIONS(145),
    [anon_sym_EQ_GT] = ACTIONS(147),
    [anon_sym_u27f9] = ACTIONS(147),
    [anon_sym_u21d2] = ACTIONS(147),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(149),
    [anon_sym_u21f8] = ACTIONS(149),
    [anon_sym_u2945] = ACTIONS(149),
    [anon_sym_BSLASHequiv] = ACTIONS(151),
    [anon_sym_u2261] = ACTIONS(151),
    [anon_sym_LT_EQ_GT] = ACTIONS(153),
    [anon_sym_u27fa] = ACTIONS(153),
    [anon_sym_u21d4] = ACTIONS(153),
    [anon_sym_TILDE_GT] = ACTIONS(155),
    [anon_sym_u21dd] = ACTIONS(155),
    [anon_sym_u219d] = ACTIONS(155),
    [anon_sym_BSLASHland] = ACTIONS(79),
    [anon_sym_BSLASHlor] = ACTIONS(81),
    [anon_sym_COLON_EQ] = ACTIONS(157),
    [anon_sym_u2254] = ACTIONS(157),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(159),
    [anon_sym_u2a74] = ACTIONS(159),
    [anon_sym_SLASH_EQ] = ACTIONS(161),
    [anon_sym_POUND] = ACTIONS(163),
    [anon_sym_u2260] = ACTIONS(161),
    [anon_sym_LT] = ACTIONS(544),
    [sym_gt] = ACTIONS(167),
    [anon_sym_LT_EQ] = ACTIONS(169),
    [anon_sym_EQ_LT] = ACTIONS(171),
    [anon_sym_BSLASHleq] = ACTIONS(171),
    [anon_sym_u2264] = ACTIONS(171),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_BSLASHgeq] = ACTIONS(173),
    [anon_sym_u2265] = ACTIONS(173),
    [anon_sym_BSLASHapprox] = ACTIONS(175),
    [anon_sym_u2248] = ACTIONS(175),
    [anon_sym_PIPE_DASH] = ACTIONS(177),
    [anon_sym_u22a2] = ACTIONS(177),
    [anon_sym_PIPE_EQ] = ACTIONS(179),
    [anon_sym_u22a8] = ACTIONS(179),
    [anon_sym_DASH_PIPE] = ACTIONS(181),
    [anon_sym_u22a3] = ACTIONS(181),
    [anon_sym_EQ_PIPE] = ACTIONS(183),
    [anon_sym_u2ae4] = ACTIONS(183),
    [anon_sym_BSLASHasymp] = ACTIONS(185),
    [anon_sym_u224d] = ACTIONS(185),
    [anon_sym_BSLASHcong] = ACTIONS(187),
    [anon_sym_u2245] = ACTIONS(187),
    [anon_sym_BSLASHdoteq] = ACTIONS(189),
    [anon_sym_u2250] = ACTIONS(189),
    [anon_sym_BSLASHgg] = ACTIONS(191),
    [anon_sym_u226b] = ACTIONS(191),
    [anon_sym_BSLASHll] = ACTIONS(193),
    [anon_sym_u226a] = ACTIONS(193),
    [anon_sym_BSLASHnotin] = ACTIONS(195),
    [anon_sym_u2209] = ACTIONS(195),
    [anon_sym_BSLASHprec] = ACTIONS(197),
    [anon_sym_u227a] = ACTIONS(199),
    [anon_sym_BSLASHsucc] = ACTIONS(201),
    [anon_sym_u227b] = ACTIONS(203),
    [anon_sym_BSLASHpreceq] = ACTIONS(205),
    [anon_sym_u2aaf] = ACTIONS(205),
    [anon_sym_BSLASHsucceq] = ACTIONS(207),
    [anon_sym_u2ab0] = ACTIONS(207),
    [anon_sym_BSLASHpropto] = ACTIONS(209),
    [anon_sym_u221d] = ACTIONS(209),
    [anon_sym_BSLASHsim] = ACTIONS(211),
    [anon_sym_u223c] = ACTIONS(213),
    [anon_sym_BSLASHsimeq] = ACTIONS(215),
    [anon_sym_u2243] = ACTIONS(215),
    [anon_sym_BSLASHsqsubset] = ACTIONS(217),
    [anon_sym_u228f] = ACTIONS(219),
    [anon_sym_BSLASHsqsupset] = ACTIONS(221),
    [anon_sym_u2290] = ACTIONS(223),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(225),
    [anon_sym_u2291] = ACTIONS(225),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(227),
    [anon_sym_u2292] = ACTIONS(227),
    [anon_sym_BSLASHsubset] = ACTIONS(229),
    [anon_sym_u2282] = ACTIONS(231),
    [anon_sym_BSLASHsupset] = ACTIONS(233),
    [anon_sym_u2283] = ACTIONS(235),
    [anon_sym_BSLASHsubseteq] = ACTIONS(237),
    [anon_sym_u2286] = ACTIONS(237),
    [anon_sym_BSLASHsupseteq] = ACTIONS(239),
    [anon_sym_u2287] = ACTIONS(239),
    [sym_compose] = ACTIONS(241),
    [sym_map_to] = ACTIONS(241),
    [sym_map_from] = ACTIONS(241),
    [sym_setminus] = ACTIONS(167),
    [anon_sym_BSLASHcap] = ACTIONS(243),
    [anon_sym_BSLASHintersect] = ACTIONS(243),
    [anon_sym_u2229] = ACTIONS(243),
    [anon_sym_BSLASHcup] = ACTIONS(245),
    [anon_sym_BSLASHunion] = ACTIONS(245),
    [anon_sym_u222a] = ACTIONS(245),
    [anon_sym_DOT_DOT] = ACTIONS(247),
    [anon_sym_u2025] = ACTIONS(249),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(251),
    [anon_sym_u2026] = ACTIONS(251),
    [anon_sym_PLUS] = ACTIONS(253),
    [sym_plusplus] = ACTIONS(241),
    [anon_sym_BSLASHoplus] = ACTIONS(255),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(255),
    [anon_sym_u2295] = ACTIONS(255),
    [anon_sym_BSLASHominus] = ACTIONS(257),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(257),
    [anon_sym_u2296] = ACTIONS(257),
    [sym_mod] = ACTIONS(167),
    [sym_modmod] = ACTIONS(241),
    [sym_vert] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_u2016] = ACTIONS(259),
    [sym_minusminus] = ACTIONS(241),
    [sym_amp] = ACTIONS(167),
    [sym_ampamp] = ACTIONS(241),
    [anon_sym_BSLASHodot] = ACTIONS(261),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(261),
    [anon_sym_u2299] = ACTIONS(261),
    [anon_sym_BSLASHoslash] = ACTIONS(263),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(263),
    [anon_sym_u2298] = ACTIONS(263),
    [anon_sym_BSLASHotimes] = ACTIONS(265),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(265),
    [anon_sym_u2297] = ACTIONS(265),
    [sym_mul] = ACTIONS(167),
    [sym_mulmul] = ACTIONS(241),
    [sym_slash] = ACTIONS(167),
    [sym_slashslash] = ACTIONS(241),
    [anon_sym_BSLASHbigcirc] = ACTIONS(267),
    [anon_sym_u25ef] = ACTIONS(267),
    [anon_sym_BSLASHbullet] = ACTIONS(269),
    [anon_sym_u25cf] = ACTIONS(269),
    [anon_sym_BSLASHdiv] = ACTIONS(271),
    [anon_sym_u00f7] = ACTIONS(271),
    [anon_sym_BSLASHcirc] = ACTIONS(273),
    [anon_sym_u2218] = ACTIONS(273),
    [anon_sym_BSLASHstar] = ACTIONS(275),
    [anon_sym_u22c6] = ACTIONS(275),
    [anon_sym_u203c] = ACTIONS(277),
    [sym_hashhash] = ACTIONS(241),
    [sym_dol] = ACTIONS(167),
    [sym_doldol] = ACTIONS(241),
    [anon_sym_QMARK_QMARK] = ACTIONS(279),
    [anon_sym_u2047] = ACTIONS(279),
    [anon_sym_BSLASHsqcap] = ACTIONS(281),
    [anon_sym_u2293] = ACTIONS(281),
    [anon_sym_BSLASHsqcup] = ACTIONS(283),
    [anon_sym_u2294] = ACTIONS(283),
    [anon_sym_BSLASHuplus] = ACTIONS(285),
    [anon_sym_u228e] = ACTIONS(285),
    [anon_sym_BSLASHX] = ACTIONS(287),
    [anon_sym_BSLASHtimes] = ACTIONS(287),
    [anon_sym_u00d7] = ACTIONS(287),
    [anon_sym_BSLASHwr] = ACTIONS(289),
    [anon_sym_u2240] = ACTIONS(289),
    [anon_sym_BSLASHcdot] = ACTIONS(291),
    [anon_sym_u22c5] = ACTIONS(291),
    [sym_pow] = ACTIONS(167),
    [sym_powpow] = ACTIONS(241),
    [anon_sym_CARET_PLUS] = ACTIONS(293),
    [anon_sym_u207a] = ACTIONS(293),
    [sym_asterisk] = ACTIONS(295),
    [sym_sup_hash] = ACTIONS(295),
    [sym_prime] = ACTIONS(295),
    [anon_sym_ASSUME] = ACTIONS(546),
    [anon_sym_NEW] = ACTIONS(548),
    [anon_sym_STATE] = ACTIONS(490),
    [anon_sym_ACTION] = ACTIONS(490),
    [anon_sym_TEMPORAL] = ACTIONS(490),
    [sym__indent] = ACTIONS(550),
    [sym__double_excl] = ACTIONS(277),
  },
  [15] = {
    [sym_block_comment] = STATE(15),
    [sym_forall] = STATE(3979),
    [sym_exists] = STATE(3979),
    [sym_langle_bracket] = STATE(66),
    [sym_subexpr_prefix] = STATE(1100),
    [sym_subexpr_component] = STATE(5469),
    [sym_bound_op] = STATE(2531),
    [sym_bound_nonfix_op] = STATE(2531),
    [sym__expr] = STATE(1849),
    [sym_prefixed_op] = STATE(2636),
    [sym__number] = STATE(2636),
    [sym_nat_number] = STATE(2558),
    [sym_binary_number] = STATE(2558),
    [sym_octal_number] = STATE(2558),
    [sym_hex_number] = STATE(2558),
    [sym_string] = STATE(2636),
    [sym_boolean] = STATE(2636),
    [sym__number_set] = STATE(2561),
    [sym__primitive_value_set] = STATE(2636),
    [sym_nat_number_set] = STATE(2630),
    [sym_int_number_set] = STATE(2630),
    [sym_real_number_set] = STATE(2630),
    [sym_label] = STATE(2636),
    [sym_subexpression] = STATE(2636),
    [sym_parentheses] = STATE(2636),
    [sym_bounded_quantification] = STATE(2636),
    [sym_unbounded_quantification] = STATE(2636),
    [sym_choose] = STATE(2636),
    [sym_finite_set_literal] = STATE(2636),
    [sym_set_filter] = STATE(2636),
    [sym_set_map] = STATE(2636),
    [sym_function_evaluation] = STATE(2636),
    [sym_function_literal] = STATE(2636),
    [sym_set_of_functions] = STATE(2636),
    [sym_record_literal] = STATE(2636),
    [sym_set_of_records] = STATE(2636),
    [sym_record_value] = STATE(2636),
    [sym_except] = STATE(2636),
    [sym_prev_func_val] = STATE(2636),
    [sym_tuple_literal] = STATE(2636),
    [sym_step_expr_or_stutter] = STATE(2636),
    [sym_step_expr_no_stutter] = STATE(2636),
    [sym_fairness] = STATE(2636),
    [sym_if_then_else] = STATE(2636),
    [sym_case] = STATE(2636),
    [sym_let_in] = STATE(2636),
    [sym_conj_list] = STATE(2636),
    [sym_disj_list] = STATE(2636),
    [sym_lnot] = STATE(53),
    [sym_negative] = STATE(984),
    [sym_always] = STATE(52),
    [sym_eventually] = STATE(52),
    [sym_prefix_op_symbol] = STATE(4943),
    [sym_bound_prefix_op] = STATE(2636),
    [sym_implies] = STATE(3441),
    [sym_plus_arrow] = STATE(3441),
    [sym_equiv] = STATE(3441),
    [sym_iff] = STATE(3441),
    [sym_leads_to] = STATE(3441),
    [sym_land] = STATE(3441),
    [sym_lor] = STATE(3441),
    [sym_assign] = STATE(3441),
    [sym_bnf_rule] = STATE(3441),
    [sym_eq] = STATE(3441),
    [sym_neq] = STATE(3441),
    [sym_lt] = STATE(3441),
    [sym_leq] = STATE(3441),
    [sym_geq] = STATE(3441),
    [sym_approx] = STATE(3441),
    [sym_rs_ttile] = STATE(3441),
    [sym_rd_ttile] = STATE(3441),
    [sym_ls_ttile] = STATE(3441),
    [sym_ld_ttile] = STATE(3441),
    [sym_asymp] = STATE(3441),
    [sym_cong] = STATE(3441),
    [sym_doteq] = STATE(3441),
    [sym_gg] = STATE(3441),
    [sym_ll] = STATE(3441),
    [sym_in] = STATE(3441),
    [sym_notin] = STATE(3441),
    [sym_prec] = STATE(3441),
    [sym_succ] = STATE(3441),
    [sym_preceq] = STATE(3441),
    [sym_succeq] = STATE(3441),
    [sym_propto] = STATE(3441),
    [sym_sim] = STATE(3441),
    [sym_simeq] = STATE(3441),
    [sym_sqsubset] = STATE(3441),
    [sym_sqsupset] = STATE(3441),
    [sym_sqsubseteq] = STATE(3441),
    [sym_sqsupseteq] = STATE(3441),
    [sym_subset] = STATE(3441),
    [sym_supset] = STATE(3441),
    [sym_subseteq] = STATE(3441),
    [sym_supseteq] = STATE(3441),
    [sym_cap] = STATE(3441),
    [sym_cup] = STATE(3441),
    [sym_dots_2] = STATE(3441),
    [sym_dots_3] = STATE(3441),
    [sym_plus] = STATE(3441),
    [sym_oplus] = STATE(3441),
    [sym_ominus] = STATE(3441),
    [sym_vertvert] = STATE(3441),
    [sym_minus] = STATE(3441),
    [sym_odot] = STATE(3441),
    [sym_oslash] = STATE(3441),
    [sym_otimes] = STATE(3441),
    [sym_bigcirc] = STATE(3441),
    [sym_bullet] = STATE(3441),
    [sym_div] = STATE(3441),
    [sym_circ] = STATE(3441),
    [sym_star] = STATE(3441),
    [sym_excl] = STATE(3441),
    [sym_qq] = STATE(3441),
    [sym_sqcap] = STATE(3441),
    [sym_sqcup] = STATE(3441),
    [sym_uplus] = STATE(3441),
    [sym_times] = STATE(3441),
    [sym_wr] = STATE(3441),
    [sym_cdot] = STATE(3441),
    [sym_infix_op_symbol] = STATE(5043),
    [sym_bound_infix_op] = STATE(2636),
    [sym_sup_plus] = STATE(3426),
    [sym_postfix_op_symbol] = STATE(4943),
    [sym_bound_postfix_op] = STATE(2636),
    [sym_assume_prove] = STATE(4973),
    [sym_inner_assume_prove] = STATE(4627),
    [sym_new] = STATE(4627),
    [sym_statement_level] = STATE(3875),
    [sym_proof_step_ref] = STATE(2521),
    [sym_identifier] = ACTIONS(484),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(59),
    [anon_sym_u2208] = ACTIONS(61),
    [anon_sym_BSLASHA] = ACTIONS(63),
    [anon_sym_BSLASHforall] = ACTIONS(65),
    [anon_sym_u2200] = ACTIONS(65),
    [anon_sym_BSLASHE] = ACTIONS(67),
    [anon_sym_BSLASHexists] = ACTIONS(69),
    [anon_sym_u2203] = ACTIONS(69),
    [sym_temporal_forall] = ACTIONS(486),
    [sym_temporal_exists] = ACTIONS(486),
    [anon_sym_LT_LT] = ACTIONS(73),
    [anon_sym_u3008] = ACTIONS(73),
    [anon_sym_u27e8] = ACTIONS(73),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(75),
    [anon_sym_u25a1] = ACTIONS(75),
    [anon_sym_AT] = ACTIONS(488),
    [anon_sym_SLASH_BSLASH] = ACTIONS(79),
    [anon_sym_u2227] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(81),
    [anon_sym_u2228] = ACTIONS(81),
    [anon_sym_VARIABLE] = ACTIONS(490),
    [anon_sym_CONSTANT] = ACTIONS(490),
    [anon_sym_LPAREN] = ACTIONS(492),
    [anon_sym_LBRACK] = ACTIONS(494),
    [aux_sym_child_id_token1] = ACTIONS(496),
    [sym_real_number] = ACTIONS(498),
    [anon_sym_BSLASHb] = ACTIONS(500),
    [anon_sym_BSLASHB] = ACTIONS(502),
    [anon_sym_BSLASHo] = ACTIONS(504),
    [anon_sym_BSLASHO] = ACTIONS(506),
    [anon_sym_BSLASHh] = ACTIONS(508),
    [anon_sym_BSLASHH] = ACTIONS(508),
    [anon_sym_DQUOTE] = ACTIONS(510),
    [anon_sym_TRUE] = ACTIONS(512),
    [anon_sym_FALSE] = ACTIONS(512),
    [sym_string_set] = ACTIONS(514),
    [sym_boolean_set] = ACTIONS(514),
    [anon_sym_Nat] = ACTIONS(516),
    [anon_sym_u2115] = ACTIONS(518),
    [anon_sym_Int] = ACTIONS(520),
    [anon_sym_u2124] = ACTIONS(522),
    [anon_sym_Real] = ACTIONS(524),
    [anon_sym_u211d] = ACTIONS(526),
    [anon_sym_CHOOSE] = ACTIONS(528),
    [anon_sym_LBRACE] = ACTIONS(530),
    [anon_sym_EQ] = ACTIONS(125),
    [anon_sym_WF_] = ACTIONS(532),
    [anon_sym_SF_] = ACTIONS(532),
    [anon_sym_IF] = ACTIONS(534),
    [anon_sym_CASE] = ACTIONS(536),
    [anon_sym_LET] = ACTIONS(538),
    [anon_sym_BSLASHlnot] = ACTIONS(135),
    [anon_sym_BSLASHneg] = ACTIONS(135),
    [anon_sym_TILDE] = ACTIONS(137),
    [anon_sym_u00ac] = ACTIONS(135),
    [sym_union] = ACTIONS(540),
    [sym_powerset] = ACTIONS(540),
    [sym_domain] = ACTIONS(540),
    [anon_sym_DASH] = ACTIONS(141),
    [sym_negative_dot] = ACTIONS(41),
    [sym_enabled] = ACTIONS(542),
    [sym_unchanged] = ACTIONS(542),
    [anon_sym_LT_GT] = ACTIONS(145),
    [anon_sym_u22c4] = ACTIONS(145),
    [anon_sym_u25c7] = ACTIONS(145),
    [anon_sym_EQ_GT] = ACTIONS(147),
    [anon_sym_u27f9] = ACTIONS(147),
    [anon_sym_u21d2] = ACTIONS(147),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(149),
    [anon_sym_u21f8] = ACTIONS(149),
    [anon_sym_u2945] = ACTIONS(149),
    [anon_sym_BSLASHequiv] = ACTIONS(151),
    [anon_sym_u2261] = ACTIONS(151),
    [anon_sym_LT_EQ_GT] = ACTIONS(153),
    [anon_sym_u27fa] = ACTIONS(153),
    [anon_sym_u21d4] = ACTIONS(153),
    [anon_sym_TILDE_GT] = ACTIONS(155),
    [anon_sym_u21dd] = ACTIONS(155),
    [anon_sym_u219d] = ACTIONS(155),
    [anon_sym_BSLASHland] = ACTIONS(79),
    [anon_sym_BSLASHlor] = ACTIONS(81),
    [anon_sym_COLON_EQ] = ACTIONS(157),
    [anon_sym_u2254] = ACTIONS(157),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(159),
    [anon_sym_u2a74] = ACTIONS(159),
    [anon_sym_SLASH_EQ] = ACTIONS(161),
    [anon_sym_POUND] = ACTIONS(163),
    [anon_sym_u2260] = ACTIONS(161),
    [anon_sym_LT] = ACTIONS(544),
    [sym_gt] = ACTIONS(167),
    [anon_sym_LT_EQ] = ACTIONS(169),
    [anon_sym_EQ_LT] = ACTIONS(171),
    [anon_sym_BSLASHleq] = ACTIONS(171),
    [anon_sym_u2264] = ACTIONS(171),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_BSLASHgeq] = ACTIONS(173),
    [anon_sym_u2265] = ACTIONS(173),
    [anon_sym_BSLASHapprox] = ACTIONS(175),
    [anon_sym_u2248] = ACTIONS(175),
    [anon_sym_PIPE_DASH] = ACTIONS(177),
    [anon_sym_u22a2] = ACTIONS(177),
    [anon_sym_PIPE_EQ] = ACTIONS(179),
    [anon_sym_u22a8] = ACTIONS(179),
    [anon_sym_DASH_PIPE] = ACTIONS(181),
    [anon_sym_u22a3] = ACTIONS(181),
    [anon_sym_EQ_PIPE] = ACTIONS(183),
    [anon_sym_u2ae4] = ACTIONS(183),
    [anon_sym_BSLASHasymp] = ACTIONS(185),
    [anon_sym_u224d] = ACTIONS(185),
    [anon_sym_BSLASHcong] = ACTIONS(187),
    [anon_sym_u2245] = ACTIONS(187),
    [anon_sym_BSLASHdoteq] = ACTIONS(189),
    [anon_sym_u2250] = ACTIONS(189),
    [anon_sym_BSLASHgg] = ACTIONS(191),
    [anon_sym_u226b] = ACTIONS(191),
    [anon_sym_BSLASHll] = ACTIONS(193),
    [anon_sym_u226a] = ACTIONS(193),
    [anon_sym_BSLASHnotin] = ACTIONS(195),
    [anon_sym_u2209] = ACTIONS(195),
    [anon_sym_BSLASHprec] = ACTIONS(197),
    [anon_sym_u227a] = ACTIONS(199),
    [anon_sym_BSLASHsucc] = ACTIONS(201),
    [anon_sym_u227b] = ACTIONS(203),
    [anon_sym_BSLASHpreceq] = ACTIONS(205),
    [anon_sym_u2aaf] = ACTIONS(205),
    [anon_sym_BSLASHsucceq] = ACTIONS(207),
    [anon_sym_u2ab0] = ACTIONS(207),
    [anon_sym_BSLASHpropto] = ACTIONS(209),
    [anon_sym_u221d] = ACTIONS(209),
    [anon_sym_BSLASHsim] = ACTIONS(211),
    [anon_sym_u223c] = ACTIONS(213),
    [anon_sym_BSLASHsimeq] = ACTIONS(215),
    [anon_sym_u2243] = ACTIONS(215),
    [anon_sym_BSLASHsqsubset] = ACTIONS(217),
    [anon_sym_u228f] = ACTIONS(219),
    [anon_sym_BSLASHsqsupset] = ACTIONS(221),
    [anon_sym_u2290] = ACTIONS(223),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(225),
    [anon_sym_u2291] = ACTIONS(225),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(227),
    [anon_sym_u2292] = ACTIONS(227),
    [anon_sym_BSLASHsubset] = ACTIONS(229),
    [anon_sym_u2282] = ACTIONS(231),
    [anon_sym_BSLASHsupset] = ACTIONS(233),
    [anon_sym_u2283] = ACTIONS(235),
    [anon_sym_BSLASHsubseteq] = ACTIONS(237),
    [anon_sym_u2286] = ACTIONS(237),
    [anon_sym_BSLASHsupseteq] = ACTIONS(239),
    [anon_sym_u2287] = ACTIONS(239),
    [sym_compose] = ACTIONS(241),
    [sym_map_to] = ACTIONS(241),
    [sym_map_from] = ACTIONS(241),
    [sym_setminus] = ACTIONS(167),
    [anon_sym_BSLASHcap] = ACTIONS(243),
    [anon_sym_BSLASHintersect] = ACTIONS(243),
    [anon_sym_u2229] = ACTIONS(243),
    [anon_sym_BSLASHcup] = ACTIONS(245),
    [anon_sym_BSLASHunion] = ACTIONS(245),
    [anon_sym_u222a] = ACTIONS(245),
    [anon_sym_DOT_DOT] = ACTIONS(247),
    [anon_sym_u2025] = ACTIONS(249),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(251),
    [anon_sym_u2026] = ACTIONS(251),
    [anon_sym_PLUS] = ACTIONS(253),
    [sym_plusplus] = ACTIONS(241),
    [anon_sym_BSLASHoplus] = ACTIONS(255),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(255),
    [anon_sym_u2295] = ACTIONS(255),
    [anon_sym_BSLASHominus] = ACTIONS(257),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(257),
    [anon_sym_u2296] = ACTIONS(257),
    [sym_mod] = ACTIONS(167),
    [sym_modmod] = ACTIONS(241),
    [sym_vert] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_u2016] = ACTIONS(259),
    [sym_minusminus] = ACTIONS(241),
    [sym_amp] = ACTIONS(167),
    [sym_ampamp] = ACTIONS(241),
    [anon_sym_BSLASHodot] = ACTIONS(261),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(261),
    [anon_sym_u2299] = ACTIONS(261),
    [anon_sym_BSLASHoslash] = ACTIONS(263),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(263),
    [anon_sym_u2298] = ACTIONS(263),
    [anon_sym_BSLASHotimes] = ACTIONS(265),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(265),
    [anon_sym_u2297] = ACTIONS(265),
    [sym_mul] = ACTIONS(167),
    [sym_mulmul] = ACTIONS(241),
    [sym_slash] = ACTIONS(167),
    [sym_slashslash] = ACTIONS(241),
    [anon_sym_BSLASHbigcirc] = ACTIONS(267),
    [anon_sym_u25ef] = ACTIONS(267),
    [anon_sym_BSLASHbullet] = ACTIONS(269),
    [anon_sym_u25cf] = ACTIONS(269),
    [anon_sym_BSLASHdiv] = ACTIONS(271),
    [anon_sym_u00f7] = ACTIONS(271),
    [anon_sym_BSLASHcirc] = ACTIONS(273),
    [anon_sym_u2218] = ACTIONS(273),
    [anon_sym_BSLASHstar] = ACTIONS(275),
    [anon_sym_u22c6] = ACTIONS(275),
    [anon_sym_u203c] = ACTIONS(277),
    [sym_hashhash] = ACTIONS(241),
    [sym_dol] = ACTIONS(167),
    [sym_doldol] = ACTIONS(241),
    [anon_sym_QMARK_QMARK] = ACTIONS(279),
    [anon_sym_u2047] = ACTIONS(279),
    [anon_sym_BSLASHsqcap] = ACTIONS(281),
    [anon_sym_u2293] = ACTIONS(281),
    [anon_sym_BSLASHsqcup] = ACTIONS(283),
    [anon_sym_u2294] = ACTIONS(283),
    [anon_sym_BSLASHuplus] = ACTIONS(285),
    [anon_sym_u228e] = ACTIONS(285),
    [anon_sym_BSLASHX] = ACTIONS(287),
    [anon_sym_BSLASHtimes] = ACTIONS(287),
    [anon_sym_u00d7] = ACTIONS(287),
    [anon_sym_BSLASHwr] = ACTIONS(289),
    [anon_sym_u2240] = ACTIONS(289),
    [anon_sym_BSLASHcdot] = ACTIONS(291),
    [anon_sym_u22c5] = ACTIONS(291),
    [sym_pow] = ACTIONS(167),
    [sym_powpow] = ACTIONS(241),
    [anon_sym_CARET_PLUS] = ACTIONS(293),
    [anon_sym_u207a] = ACTIONS(293),
    [sym_asterisk] = ACTIONS(295),
    [sym_sup_hash] = ACTIONS(295),
    [sym_prime] = ACTIONS(295),
    [anon_sym_ASSUME] = ACTIONS(546),
    [anon_sym_NEW] = ACTIONS(548),
    [anon_sym_STATE] = ACTIONS(490),
    [anon_sym_ACTION] = ACTIONS(490),
    [anon_sym_TEMPORAL] = ACTIONS(490),
    [sym__indent] = ACTIONS(550),
    [sym__double_excl] = ACTIONS(277),
  },
  [16] = {
    [sym_block_comment] = STATE(16),
    [sym_forall] = STATE(3979),
    [sym_exists] = STATE(3979),
    [sym_langle_bracket] = STATE(66),
    [sym_subexpr_prefix] = STATE(1100),
    [sym_subexpr_component] = STATE(5469),
    [sym_bound_op] = STATE(2531),
    [sym_bound_nonfix_op] = STATE(2531),
    [sym__expr] = STATE(1847),
    [sym_prefixed_op] = STATE(2636),
    [sym__number] = STATE(2636),
    [sym_nat_number] = STATE(2558),
    [sym_binary_number] = STATE(2558),
    [sym_octal_number] = STATE(2558),
    [sym_hex_number] = STATE(2558),
    [sym_string] = STATE(2636),
    [sym_boolean] = STATE(2636),
    [sym__number_set] = STATE(2561),
    [sym__primitive_value_set] = STATE(2636),
    [sym_nat_number_set] = STATE(2630),
    [sym_int_number_set] = STATE(2630),
    [sym_real_number_set] = STATE(2630),
    [sym_label] = STATE(2636),
    [sym_subexpression] = STATE(2636),
    [sym_parentheses] = STATE(2636),
    [sym_bounded_quantification] = STATE(2636),
    [sym_unbounded_quantification] = STATE(2636),
    [sym_choose] = STATE(2636),
    [sym_finite_set_literal] = STATE(2636),
    [sym_set_filter] = STATE(2636),
    [sym_set_map] = STATE(2636),
    [sym_function_evaluation] = STATE(2636),
    [sym_function_literal] = STATE(2636),
    [sym_set_of_functions] = STATE(2636),
    [sym_record_literal] = STATE(2636),
    [sym_set_of_records] = STATE(2636),
    [sym_record_value] = STATE(2636),
    [sym_except] = STATE(2636),
    [sym_prev_func_val] = STATE(2636),
    [sym_tuple_literal] = STATE(2636),
    [sym_step_expr_or_stutter] = STATE(2636),
    [sym_step_expr_no_stutter] = STATE(2636),
    [sym_fairness] = STATE(2636),
    [sym_if_then_else] = STATE(2636),
    [sym_case] = STATE(2636),
    [sym_let_in] = STATE(2636),
    [sym_conj_list] = STATE(2636),
    [sym_disj_list] = STATE(2636),
    [sym_lnot] = STATE(53),
    [sym_negative] = STATE(984),
    [sym_always] = STATE(52),
    [sym_eventually] = STATE(52),
    [sym_prefix_op_symbol] = STATE(4943),
    [sym_bound_prefix_op] = STATE(2636),
    [sym_implies] = STATE(3441),
    [sym_plus_arrow] = STATE(3441),
    [sym_equiv] = STATE(3441),
    [sym_iff] = STATE(3441),
    [sym_leads_to] = STATE(3441),
    [sym_land] = STATE(3441),
    [sym_lor] = STATE(3441),
    [sym_assign] = STATE(3441),
    [sym_bnf_rule] = STATE(3441),
    [sym_eq] = STATE(3441),
    [sym_neq] = STATE(3441),
    [sym_lt] = STATE(3441),
    [sym_leq] = STATE(3441),
    [sym_geq] = STATE(3441),
    [sym_approx] = STATE(3441),
    [sym_rs_ttile] = STATE(3441),
    [sym_rd_ttile] = STATE(3441),
    [sym_ls_ttile] = STATE(3441),
    [sym_ld_ttile] = STATE(3441),
    [sym_asymp] = STATE(3441),
    [sym_cong] = STATE(3441),
    [sym_doteq] = STATE(3441),
    [sym_gg] = STATE(3441),
    [sym_ll] = STATE(3441),
    [sym_in] = STATE(3441),
    [sym_notin] = STATE(3441),
    [sym_prec] = STATE(3441),
    [sym_succ] = STATE(3441),
    [sym_preceq] = STATE(3441),
    [sym_succeq] = STATE(3441),
    [sym_propto] = STATE(3441),
    [sym_sim] = STATE(3441),
    [sym_simeq] = STATE(3441),
    [sym_sqsubset] = STATE(3441),
    [sym_sqsupset] = STATE(3441),
    [sym_sqsubseteq] = STATE(3441),
    [sym_sqsupseteq] = STATE(3441),
    [sym_subset] = STATE(3441),
    [sym_supset] = STATE(3441),
    [sym_subseteq] = STATE(3441),
    [sym_supseteq] = STATE(3441),
    [sym_cap] = STATE(3441),
    [sym_cup] = STATE(3441),
    [sym_dots_2] = STATE(3441),
    [sym_dots_3] = STATE(3441),
    [sym_plus] = STATE(3441),
    [sym_oplus] = STATE(3441),
    [sym_ominus] = STATE(3441),
    [sym_vertvert] = STATE(3441),
    [sym_minus] = STATE(3441),
    [sym_odot] = STATE(3441),
    [sym_oslash] = STATE(3441),
    [sym_otimes] = STATE(3441),
    [sym_bigcirc] = STATE(3441),
    [sym_bullet] = STATE(3441),
    [sym_div] = STATE(3441),
    [sym_circ] = STATE(3441),
    [sym_star] = STATE(3441),
    [sym_excl] = STATE(3441),
    [sym_qq] = STATE(3441),
    [sym_sqcap] = STATE(3441),
    [sym_sqcup] = STATE(3441),
    [sym_uplus] = STATE(3441),
    [sym_times] = STATE(3441),
    [sym_wr] = STATE(3441),
    [sym_cdot] = STATE(3441),
    [sym_infix_op_symbol] = STATE(5043),
    [sym_bound_infix_op] = STATE(2636),
    [sym_sup_plus] = STATE(3426),
    [sym_postfix_op_symbol] = STATE(4943),
    [sym_bound_postfix_op] = STATE(2636),
    [sym_assume_prove] = STATE(4973),
    [sym_inner_assume_prove] = STATE(4580),
    [sym_new] = STATE(4580),
    [sym_statement_level] = STATE(3875),
    [sym_proof_step_ref] = STATE(2521),
    [sym_identifier] = ACTIONS(484),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_BSLASHin] = ACTIONS(59),
    [anon_sym_u2208] = ACTIONS(61),
    [anon_sym_BSLASHA] = ACTIONS(63),
    [anon_sym_BSLASHforall] = ACTIONS(65),
    [anon_sym_u2200] = ACTIONS(65),
    [anon_sym_BSLASHE] = ACTIONS(67),
    [anon_sym_BSLASHexists] = ACTIONS(69),
    [anon_sym_u2203] = ACTIONS(69),
    [sym_temporal_forall] = ACTIONS(486),
    [sym_temporal_exists] = ACTIONS(486),
    [anon_sym_LT_LT] = ACTIONS(73),
    [anon_sym_u3008] = ACTIONS(73),
    [anon_sym_u27e8] = ACTIONS(73),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(75),
    [anon_sym_u25a1] = ACTIONS(75),
    [anon_sym_AT] = ACTIONS(488),
    [anon_sym_SLASH_BSLASH] = ACTIONS(79),
    [anon_sym_u2227] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(81),
    [anon_sym_u2228] = ACTIONS(81),
    [anon_sym_VARIABLE] = ACTIONS(490),
    [anon_sym_CONSTANT] = ACTIONS(490),
    [anon_sym_LPAREN] = ACTIONS(492),
    [anon_sym_LBRACK] = ACTIONS(494),
    [aux_sym_child_id_token1] = ACTIONS(496),
    [sym_real_number] = ACTIONS(498),
    [anon_sym_BSLASHb] = ACTIONS(500),
    [anon_sym_BSLASHB] = ACTIONS(502),
    [anon_sym_BSLASHo] = ACTIONS(504),
    [anon_sym_BSLASHO] = ACTIONS(506),
    [anon_sym_BSLASHh] = ACTIONS(508),
    [anon_sym_BSLASHH] = ACTIONS(508),
    [anon_sym_DQUOTE] = ACTIONS(510),
    [anon_sym_TRUE] = ACTIONS(512),
    [anon_sym_FALSE] = ACTIONS(512),
    [sym_string_set] = ACTIONS(514),
    [sym_boolean_set] = ACTIONS(514),
    [anon_sym_Nat] = ACTIONS(516),
    [anon_sym_u2115] = ACTIONS(518),
    [anon_sym_Int] = ACTIONS(520),
    [anon_sym_u2124] = ACTIONS(522),
    [anon_sym_Real] = ACTIONS(524),
    [anon_sym_u211d] = ACTIONS(526),
    [anon_sym_CHOOSE] = ACTIONS(528),
    [anon_sym_LBRACE] = ACTIONS(530),
    [anon_sym_EQ] = ACTIONS(125),
    [anon_sym_WF_] = ACTIONS(532),
    [anon_sym_SF_] = ACTIONS(532),
    [anon_sym_IF] = ACTIONS(534),
    [anon_sym_CASE] = ACTIONS(536),
    [anon_sym_LET] = ACTIONS(538),
    [anon_sym_BSLASHlnot] = ACTIONS(135),
    [anon_sym_BSLASHneg] = ACTIONS(135),
    [anon_sym_TILDE] = ACTIONS(137),
    [anon_sym_u00ac] = ACTIONS(135),
    [sym_union] = ACTIONS(540),
    [sym_powerset] = ACTIONS(540),
    [sym_domain] = ACTIONS(540),
    [anon_sym_DASH] = ACTIONS(141),
    [sym_negative_dot] = ACTIONS(41),
    [sym_enabled] = ACTIONS(542),
    [sym_unchanged] = ACTIONS(542),
    [anon_sym_LT_GT] = ACTIONS(145),
    [anon_sym_u22c4] = ACTIONS(145),
    [anon_sym_u25c7] = ACTIONS(145),
    [anon_sym_EQ_GT] = ACTIONS(147),
    [anon_sym_u27f9] = ACTIONS(147),
    [anon_sym_u21d2] = ACTIONS(147),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(149),
    [anon_sym_u21f8] = ACTIONS(149),
    [anon_sym_u2945] = ACTIONS(149),
    [anon_sym_BSLASHequiv] = ACTIONS(151),
    [anon_sym_u2261] = ACTIONS(151),
    [anon_sym_LT_EQ_GT] = ACTIONS(153),
    [anon_sym_u27fa] = ACTIONS(153),
    [anon_sym_u21d4] = ACTIONS(153),
    [anon_sym_TILDE_GT] = ACTIONS(155),
    [anon_sym_u21dd] = ACTIONS(155),
    [anon_sym_u219d] = ACTIONS(155),
    [anon_sym_BSLASHland] = ACTIONS(79),
    [anon_sym_BSLASHlor] = ACTIONS(81),
    [anon_sym_COLON_EQ] = ACTIONS(157),
    [anon_sym_u2254] = ACTIONS(157),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(159),
    [anon_sym_u2a74] = ACTIONS(159),
    [anon_sym_SLASH_EQ] = ACTIONS(161),
    [anon_sym_POUND] = ACTIONS(163),
    [anon_sym_u2260] = ACTIONS(161),
    [anon_sym_LT] = ACTIONS(544),
    [sym_gt] = ACTIONS(167),
    [anon_sym_LT_EQ] = ACTIONS(169),
    [anon_sym_EQ_LT] = ACTIONS(171),
    [anon_sym_BSLASHleq] = ACTIONS(171),
    [anon_sym_u2264] = ACTIONS(171),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_BSLASHgeq] = ACTIONS(173),
    [anon_sym_u2265] = ACTIONS(173),
    [anon_sym_BSLASHapprox] = ACTIONS(175),
    [anon_sym_u2248] = ACTIONS(175),
    [anon_sym_PIPE_DASH] = ACTIONS(177),
    [anon_sym_u22a2] = ACTIONS(177),
    [anon_sym_PIPE_EQ] = ACTIONS(179),
    [anon_sym_u22a8] = ACTIONS(179),
    [anon_sym_DASH_PIPE] = ACTIONS(181),
    [anon_sym_u22a3] = ACTIONS(181),
    [anon_sym_EQ_PIPE] = ACTIONS(183),
    [anon_sym_u2ae4] = ACTIONS(183),
    [anon_sym_BSLASHasymp] = ACTIONS(185),
    [anon_sym_u224d] = ACTIONS(185),
    [anon_sym_BSLASHcong] = ACTIONS(187),
    [anon_sym_u2245] = ACTIONS(187),
    [anon_sym_BSLASHdoteq] = ACTIONS(189),
    [anon_sym_u2250] = ACTIONS(189),
    [anon_sym_BSLASHgg] = ACTIONS(191),
    [anon_sym_u226b] = ACTIONS(191),
    [anon_sym_BSLASHll] = ACTIONS(193),
    [anon_sym_u226a] = ACTIONS(193),
    [anon_sym_BSLASHnotin] = ACTIONS(195),
    [anon_sym_u2209] = ACTIONS(195),
    [anon_sym_BSLASHprec] = ACTIONS(197),
    [anon_sym_u227a] = ACTIONS(199),
    [anon_sym_BSLASHsucc] = ACTIONS(201),
    [anon_sym_u227b] = ACTIONS(203),
    [anon_sym_BSLASHpreceq] = ACTIONS(205),
    [anon_sym_u2aaf] = ACTIONS(205),
    [anon_sym_BSLASHsucceq] = ACTIONS(207),
    [anon_sym_u2ab0] = ACTIONS(207),
    [anon_sym_BSLASHpropto] = ACTIONS(209),
    [anon_sym_u221d] = ACTIONS(209),
    [anon_sym_BSLASHsim] = ACTIONS(211),
    [anon_sym_u223c] = ACTIONS(213),
    [anon_sym_BSLASHsimeq] = ACTIONS(215),
    [anon_sym_u2243] = ACTIONS(215),
    [anon_sym_BSLASHsqsubset] = ACTIONS(217),
    [anon_sym_u228f] = ACTIONS(219),
    [anon_sym_BSLASHsqsupset] = ACTIONS(221),
    [anon_sym_u2290] = ACTIONS(223),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(225),
    [anon_sym_u2291] = ACTIONS(225),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(227),
    [anon_sym_u2292] = ACTIONS(227),
    [anon_sym_BSLASHsubset] = ACTIONS(229),
    [anon_sym_u2282] = ACTIONS(231),
    [anon_sym_BSLASHsupset] = ACTIONS(233),
    [anon_sym_u2283] = ACTIONS(235),
    [anon_sym_BSLASHsubseteq] = ACTIONS(237),
    [anon_sym_u2286] = ACTIONS(237),
    [anon_sym_BSLASHsupseteq] = ACTIONS(239),
    [anon_sym_u2287] = ACTIONS(239),
    [sym_compose] = ACTIONS(241),
    [sym_map_to] = ACTIONS(241),
    [sym_map_from] = ACTIONS(241),
    [sym_setminus] = ACTIONS(167),
    [anon_sym_BSLASHcap] = ACTIONS(243),
    [anon_sym_BSLASHintersect] = ACTIONS(243),
    [anon_sym_u2229] = ACTIONS(243),
    [anon_sym_BSLASHcup] = ACTIONS(245),
    [anon_sym_BSLASHunion] = ACTIONS(245),
    [anon_sym_u222a] = ACTIONS(245),
    [anon_sym_DOT_DOT] = ACTIONS(247),
    [anon_sym_u2025] = ACTIONS(249),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(251),
    [anon_sym_u2026] = ACTIONS(251),
    [anon_sym_PLUS] = ACTIONS(253),
    [sym_plusplus] = ACTIONS(241),
    [anon_sym_BSLASHoplus] = ACTIONS(255),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(255),
    [anon_sym_u2295] = ACTIONS(255),
    [anon_sym_BSLASHominus] = ACTIONS(257),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(257),
    [anon_sym_u2296] = ACTIONS(257),
    [sym_mod] = ACTIONS(167),
    [sym_modmod] = ACTIONS(241),
    [sym_vert] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_u2016] = ACTIONS(259),
    [sym_minusminus] = ACTIONS(241),
    [sym_amp] = ACTIONS(167),
    [sym_ampamp] = ACTIONS(241),
    [anon_sym_BSLASHodot] = ACTIONS(261),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(261),
    [anon_sym_u2299] = ACTIONS(261),
    [anon_sym_BSLASHoslash] = ACTIONS(263),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(263),
    [anon_sym_u2298] = ACTIONS(263),
    [anon_sym_BSLASHotimes] = ACTIONS(265),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(265),
    [anon_sym_u2297] = ACTIONS(265),
    [sym_mul] = ACTIONS(167),
    [sym_mulmul] = ACTIONS(241),
    [sym_slash] = ACTIONS(167),
    [sym_slashslash] = ACTIONS(241),
    [anon_sym_BSLASHbigcirc] = ACTIONS(267),
    [anon_sym_u25ef] = ACTIONS(267),
    [anon_sym_BSLASHbullet] = ACTIONS(269),
    [anon_sym_u25cf] = ACTIONS(269),
    [anon_sym_BSLASHdiv] = ACTIONS(271),
    [anon_sym_u00f7] = ACTIONS(271),
    [anon_sym_BSLASHcirc] = ACTIONS(273),
    [anon_sym_u2218] = ACTIONS(273),
    [anon_sym_BSLASHstar] = ACTIONS(275),
    [anon_sym_u22c6] = ACTIONS(275),
    [anon_sym_u203c] = ACTIONS(277),
    [sym_hashhash] = ACTIONS(241),
    [sym_dol] = ACTIONS(167),
    [sym_doldol] = ACTIONS(241),
    [anon_sym_QMARK_QMARK] = ACTIONS(279),
    [anon_sym_u2047] = ACTIONS(279),
    [anon_sym_BSLASHsqcap] = ACTIONS(281),
    [anon_sym_u2293] = ACTIONS(281),
    [anon_sym_BSLASHsqcup] = ACTIONS(283),
    [anon_sym_u2294] = ACTIONS(283),
    [anon_sym_BSLASHuplus] = ACTIONS(285),
    [anon_sym_u228e] = ACTIONS(285),
    [anon_sym_BSLASHX] = ACTIONS(287),
    [anon_sym_BSLASHtimes] = ACTIONS(287),
    [anon_sym_u00d7] = ACTIONS(287),
    [anon_sym_BSLASHwr] = ACTIONS(289),
    [anon_sym_u2240] = ACTIONS(289),
    [anon_sym_BSLASHcdot] = ACTIONS(291),
    [anon_sym_u22c5] = ACTIONS(291),
    [sym_pow] = ACTIONS(167),
    [sym_powpow] = ACTIONS(241),
    [anon_sym_CARET_PLUS] = ACTIONS(293),
    [anon_sym_u207a] = ACTIONS(293),
    [sym_asterisk] = ACTIONS(295),
    [sym_sup_hash] = ACTIONS(295),
    [sym_prime] = ACTIONS(295),
    [anon_sym_ASSUME] = ACTIONS(546),
    [anon_sym_NEW] = ACTIONS(548),
    [anon_sym_STATE] = ACTIONS(490),
    [anon_sym_ACTION] = ACTIONS(490),
    [anon_sym_TEMPORAL] = ACTIONS(490),
    [sym__indent] = ACTIONS(550),
    [sym__double_excl] = ACTIONS(277),
  },
  [17] = {
    [sym_block_comment] = STATE(17),
    [sym_forall] = STATE(3984),
    [sym_exists] = STATE(3984),
    [sym_langle_bracket] = STATE(76),
    [sym_subexpr_prefix] = STATE(1092),
    [sym_subexpr_component] = STATE(5469),
    [sym_bound_op] = STATE(2377),
    [sym_bound_nonfix_op] = STATE(2377),
    [sym__expr] = STATE(1222),
    [sym_prefixed_op] = STATE(2405),
    [sym__number] = STATE(2405),
    [sym_nat_number] = STATE(2399),
    [sym_binary_number] = STATE(2399),
    [sym_octal_number] = STATE(2399),
    [sym_hex_number] = STATE(2399),
    [sym_string] = STATE(2405),
    [sym_boolean] = STATE(2405),
    [sym__number_set] = STATE(2404),
    [sym__primitive_value_set] = STATE(2405),
    [sym_nat_number_set] = STATE(2490),
    [sym_int_number_set] = STATE(2490),
    [sym_real_number_set] = STATE(2490),
    [sym_label] = STATE(2405),
    [sym_subexpression] = STATE(2405),
    [sym_parentheses] = STATE(2405),
    [sym_bounded_quantification] = STATE(2405),
    [sym_unbounded_quantification] = STATE(2405),
    [sym_choose] = STATE(2405),
    [sym_finite_set_literal] = STATE(2405),
    [sym_set_filter] = STATE(2405),
    [sym_set_map] = STATE(2405),
    [sym_function_evaluation] = STATE(2405),
    [sym_function_literal] = STATE(2405),
    [sym_set_of_functions] = STATE(2405),
    [sym_record_literal] = STATE(2405),
    [sym_set_of_records] = STATE(2405),
    [sym_record_value] = STATE(2405),
    [sym_except] = STATE(2405),
    [sym_prev_func_val] = STATE(2405),
    [sym_tuple_literal] = STATE(2405),
    [sym_step_expr_or_stutter] = STATE(2405),
    [sym_step_expr_no_stutter] = STATE(2405),
    [sym_fairness] = STATE(2405),
    [sym_if_then_else] = STATE(2405),
    [sym_case] = STATE(2405),
    [sym_let_in] = STATE(2405),
    [sym_conj_list] = STATE(2405),
    [sym_disj_list] = STATE(2405),
    [sym_lnot] = STATE(264),
    [sym_negative] = STATE(517),
    [sym_always] = STATE(263),
    [sym_eventually] = STATE(263),
    [sym_prefix_op_symbol] = STATE(4965),
    [sym_bound_prefix_op] = STATE(2405),
    [sym_implies] = STATE(3441),
    [sym_plus_arrow] = STATE(3441),
    [sym_equiv] = STATE(3441),
    [sym_iff] = STATE(3441),
    [sym_leads_to] = STATE(3441),
    [sym_land] = STATE(3441),
    [sym_lor] = STATE(3441),
    [sym_assign] = STATE(3441),
    [sym_bnf_rule] = STATE(3441),
    [sym_eq] = STATE(3441),
    [sym_neq] = STATE(3441),
    [sym_lt] = STATE(3441),
    [sym_leq] = STATE(3441),
    [sym_geq] = STATE(3441),
    [sym_approx] = STATE(3441),
    [sym_rs_ttile] = STATE(3441),
    [sym_rd_ttile] = STATE(3441),
    [sym_ls_ttile] = STATE(3441),
    [sym_ld_ttile] = STATE(3441),
    [sym_asymp] = STATE(3441),
    [sym_cong] = STATE(3441),
    [sym_doteq] = STATE(3441),
    [sym_gg] = STATE(3441),
    [sym_ll] = STATE(3441),
    [sym_in] = STATE(3441),
    [sym_notin] = STATE(3441),
    [sym_prec] = STATE(3441),
    [sym_succ] = STATE(3441),
    [sym_preceq] = STATE(3441),
    [sym_succeq] = STATE(3441),
    [sym_propto] = STATE(3441),
    [sym_sim] = STATE(3441),
    [sym_simeq] = STATE(3441),
    [sym_sqsubset] = STATE(3441),
    [sym_sqsupset] = STATE(3441),
    [sym_sqsubseteq] = STATE(3441),
    [sym_sqsupseteq] = STATE(3441),
    [sym_subset] = STATE(3441),
    [sym_supset] = STATE(3441),
    [sym_subseteq] = STATE(3441),
    [sym_supseteq] = STATE(3441),
    [sym_cap] = STATE(3441),
    [sym_cup] = STATE(3441),
    [sym_dots_2] = STATE(3441),
    [sym_dots_3] = STATE(3441),
    [sym_plus] = STATE(3441),
    [sym_oplus] = STATE(3441),
    [sym_ominus] = STATE(3441),
    [sym_vertvert] = STATE(3441),
    [sym_minus] = STATE(3441),
    [sym_odot] = STATE(3441),
    [sym_oslash] = STATE(3441),
    [sym_otimes] = STATE(3441),
    [sym_bigcirc] = STATE(3441),
    [sym_bullet] = STATE(3441),
    [sym_div] = STATE(3441),
    [sym_circ] = STATE(3441),
    [sym_star] = STATE(3441),
    [sym_excl] = STATE(3441),
    [sym_qq] = STATE(3441),
    [sym_sqcap] = STATE(3441),
    [sym_sqcup] = STATE(3441),
    [sym_uplus] = STATE(3441),
    [sym_times] = STATE(3441),
    [sym_wr] = STATE(3441),
    [sym_cdot] = STATE(3441),
    [sym_infix_op_symbol] = STATE(5053),
    [sym_bound_infix_op] = STATE(2405),
    [sym_sup_plus] = STATE(3426),
    [sym_postfix_op_symbol] = STATE(4965),
    [sym_bound_postfix_op] = STATE(2405),
    [sym_use_body] = STATE(3581),
    [sym_use_body_expr] = STATE(3533),
    [sym_use_body_def] = STATE(3587),
    [sym_module_ref] = STATE(3507),
    [sym_proof_step_ref] = STATE(2378),
    [sym_identifier] = ACTIONS(552),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(554),
    [anon_sym_BSLASHin] = ACTIONS(59),
    [anon_sym_u2208] = ACTIONS(61),
    [anon_sym_BSLASHA] = ACTIONS(63),
    [anon_sym_BSLASHforall] = ACTIONS(65),
    [anon_sym_u2200] = ACTIONS(65),
    [anon_sym_BSLASHE] = ACTIONS(67),
    [anon_sym_BSLASHexists] = ACTIONS(69),
    [anon_sym_u2203] = ACTIONS(69),
    [sym_temporal_forall] = ACTIONS(326),
    [sym_temporal_exists] = ACTIONS(326),
    [anon_sym_LT_LT] = ACTIONS(73),
    [anon_sym_u3008] = ACTIONS(73),
    [anon_sym_u27e8] = ACTIONS(73),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(75),
    [anon_sym_u25a1] = ACTIONS(75),
    [anon_sym_AT] = ACTIONS(331),
    [anon_sym_SLASH_BSLASH] = ACTIONS(79),
    [anon_sym_u2227] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(81),
    [anon_sym_u2228] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(338),
    [aux_sym_child_id_token1] = ACTIONS(340),
    [sym_real_number] = ACTIONS(342),
    [anon_sym_BSLASHb] = ACTIONS(344),
    [anon_sym_BSLASHB] = ACTIONS(346),
    [anon_sym_BSLASHo] = ACTIONS(348),
    [anon_sym_BSLASHO] = ACTIONS(350),
    [anon_sym_BSLASHh] = ACTIONS(352),
    [anon_sym_BSLASHH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_TRUE] = ACTIONS(356),
    [anon_sym_FALSE] = ACTIONS(356),
    [sym_string_set] = ACTIONS(358),
    [sym_boolean_set] = ACTIONS(358),
    [anon_sym_Nat] = ACTIONS(558),
    [anon_sym_u2115] = ACTIONS(560),
    [anon_sym_Int] = ACTIONS(562),
    [anon_sym_u2124] = ACTIONS(564),
    [anon_sym_Real] = ACTIONS(566),
    [anon_sym_u211d] = ACTIONS(568),
    [anon_sym_CHOOSE] = ACTIONS(378),
    [anon_sym_LBRACE] = ACTIONS(380),
    [anon_sym_EQ] = ACTIONS(125),
    [anon_sym_WF_] = ACTIONS(382),
    [anon_sym_SF_] = ACTIONS(382),
    [anon_sym_IF] = ACTIONS(384),
    [anon_sym_CASE] = ACTIONS(386),
    [anon_sym_LET] = ACTIONS(388),
    [anon_sym_BSLASHlnot] = ACTIONS(135),
    [anon_sym_BSLASHneg] = ACTIONS(135),
    [anon_sym_TILDE] = ACTIONS(137),
    [anon_sym_u00ac] = ACTIONS(135),
    [sym_union] = ACTIONS(570),
    [sym_powerset] = ACTIONS(570),
    [sym_domain] = ACTIONS(570),
    [anon_sym_DASH] = ACTIONS(141),
    [sym_negative_dot] = ACTIONS(41),
    [sym_enabled] = ACTIONS(572),
    [sym_unchanged] = ACTIONS(572),
    [anon_sym_LT_GT] = ACTIONS(145),
    [anon_sym_u22c4] = ACTIONS(145),
    [anon_sym_u25c7] = ACTIONS(145),
    [anon_sym_EQ_GT] = ACTIONS(147),
    [anon_sym_u27f9] = ACTIONS(147),
    [anon_sym_u21d2] = ACTIONS(147),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(149),
    [anon_sym_u21f8] = ACTIONS(149),
    [anon_sym_u2945] = ACTIONS(149),
    [anon_sym_BSLASHequiv] = ACTIONS(151),
    [anon_sym_u2261] = ACTIONS(151),
    [anon_sym_LT_EQ_GT] = ACTIONS(153),
    [anon_sym_u27fa] = ACTIONS(153),
    [anon_sym_u21d4] = ACTIONS(153),
    [anon_sym_TILDE_GT] = ACTIONS(155),
    [anon_sym_u21dd] = ACTIONS(155),
    [anon_sym_u219d] = ACTIONS(155),
    [anon_sym_BSLASHland] = ACTIONS(79),
    [anon_sym_BSLASHlor] = ACTIONS(81),
    [anon_sym_COLON_EQ] = ACTIONS(157),
    [anon_sym_u2254] = ACTIONS(157),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(159),
    [anon_sym_u2a74] = ACTIONS(159),
    [anon_sym_SLASH_EQ] = ACTIONS(161),
    [anon_sym_POUND] = ACTIONS(163),
    [anon_sym_u2260] = ACTIONS(161),
    [anon_sym_LT] = ACTIONS(408),
    [sym_gt] = ACTIONS(167),
    [anon_sym_LT_EQ] = ACTIONS(169),
    [anon_sym_EQ_LT] = ACTIONS(171),
    [anon_sym_BSLASHleq] = ACTIONS(171),
    [anon_sym_u2264] = ACTIONS(171),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_BSLASHgeq] = ACTIONS(173),
    [anon_sym_u2265] = ACTIONS(173),
    [anon_sym_BSLASHapprox] = ACTIONS(175),
    [anon_sym_u2248] = ACTIONS(175),
    [anon_sym_PIPE_DASH] = ACTIONS(177),
    [anon_sym_u22a2] = ACTIONS(177),
    [anon_sym_PIPE_EQ] = ACTIONS(179),
    [anon_sym_u22a8] = ACTIONS(179),
    [anon_sym_DASH_PIPE] = ACTIONS(181),
    [anon_sym_u22a3] = ACTIONS(181),
    [anon_sym_EQ_PIPE] = ACTIONS(183),
    [anon_sym_u2ae4] = ACTIONS(183),
    [anon_sym_BSLASHasymp] = ACTIONS(185),
    [anon_sym_u224d] = ACTIONS(185),
    [anon_sym_BSLASHcong] = ACTIONS(187),
    [anon_sym_u2245] = ACTIONS(187),
    [anon_sym_BSLASHdoteq] = ACTIONS(189),
    [anon_sym_u2250] = ACTIONS(189),
    [anon_sym_BSLASHgg] = ACTIONS(191),
    [anon_sym_u226b] = ACTIONS(191),
    [anon_sym_BSLASHll] = ACTIONS(193),
    [anon_sym_u226a] = ACTIONS(193),
    [anon_sym_BSLASHnotin] = ACTIONS(195),
    [anon_sym_u2209] = ACTIONS(195),
    [anon_sym_BSLASHprec] = ACTIONS(197),
    [anon_sym_u227a] = ACTIONS(199),
    [anon_sym_BSLASHsucc] = ACTIONS(201),
    [anon_sym_u227b] = ACTIONS(203),
    [anon_sym_BSLASHpreceq] = ACTIONS(205),
    [anon_sym_u2aaf] = ACTIONS(205),
    [anon_sym_BSLASHsucceq] = ACTIONS(207),
    [anon_sym_u2ab0] = ACTIONS(207),
    [anon_sym_BSLASHpropto] = ACTIONS(209),
    [anon_sym_u221d] = ACTIONS(209),
    [anon_sym_BSLASHsim] = ACTIONS(211),
    [anon_sym_u223c] = ACTIONS(213),
    [anon_sym_BSLASHsimeq] = ACTIONS(215),
    [anon_sym_u2243] = ACTIONS(215),
    [anon_sym_BSLASHsqsubset] = ACTIONS(217),
    [anon_sym_u228f] = ACTIONS(219),
    [anon_sym_BSLASHsqsupset] = ACTIONS(221),
    [anon_sym_u2290] = ACTIONS(223),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(225),
    [anon_sym_u2291] = ACTIONS(225),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(227),
    [anon_sym_u2292] = ACTIONS(227),
    [anon_sym_BSLASHsubset] = ACTIONS(229),
    [anon_sym_u2282] = ACTIONS(231),
    [anon_sym_BSLASHsupset] = ACTIONS(233),
    [anon_sym_u2283] = ACTIONS(235),
    [anon_sym_BSLASHsubseteq] = ACTIONS(237),
    [anon_sym_u2286] = ACTIONS(237),
    [anon_sym_BSLASHsupseteq] = ACTIONS(239),
    [anon_sym_u2287] = ACTIONS(239),
    [sym_compose] = ACTIONS(241),
    [sym_map_to] = ACTIONS(241),
    [sym_map_from] = ACTIONS(241),
    [sym_setminus] = ACTIONS(167),
    [anon_sym_BSLASHcap] = ACTIONS(243),
    [anon_sym_BSLASHintersect] = ACTIONS(243),
    [anon_sym_u2229] = ACTIONS(243),
    [anon_sym_BSLASHcup] = ACTIONS(245),
    [anon_sym_BSLASHunion] = ACTIONS(245),
    [anon_sym_u222a] = ACTIONS(245),
    [anon_sym_DOT_DOT] = ACTIONS(247),
    [anon_sym_u2025] = ACTIONS(249),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(251),
    [anon_sym_u2026] = ACTIONS(251),
    [anon_sym_PLUS] = ACTIONS(253),
    [sym_plusplus] = ACTIONS(241),
    [anon_sym_BSLASHoplus] = ACTIONS(255),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(255),
    [anon_sym_u2295] = ACTIONS(255),
    [anon_sym_BSLASHominus] = ACTIONS(257),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(257),
    [anon_sym_u2296] = ACTIONS(257),
    [sym_mod] = ACTIONS(167),
    [sym_modmod] = ACTIONS(241),
    [sym_vert] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_u2016] = ACTIONS(259),
    [sym_minusminus] = ACTIONS(241),
    [sym_amp] = ACTIONS(167),
    [sym_ampamp] = ACTIONS(241),
    [anon_sym_BSLASHodot] = ACTIONS(261),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(261),
    [anon_sym_u2299] = ACTIONS(261),
    [anon_sym_BSLASHoslash] = ACTIONS(263),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(263),
    [anon_sym_u2298] = ACTIONS(263),
    [anon_sym_BSLASHotimes] = ACTIONS(265),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(265),
    [anon_sym_u2297] = ACTIONS(265),
    [sym_mul] = ACTIONS(167),
    [sym_mulmul] = ACTIONS(241),
    [sym_slash] = ACTIONS(167),
    [sym_slashslash] = ACTIONS(241),
    [anon_sym_BSLASHbigcirc] = ACTIONS(267),
    [anon_sym_u25ef] = ACTIONS(267),
    [anon_sym_BSLASHbullet] = ACTIONS(269),
    [anon_sym_u25cf] = ACTIONS(269),
    [anon_sym_BSLASHdiv] = ACTIONS(271),
    [anon_sym_u00f7] = ACTIONS(271),
    [anon_sym_BSLASHcirc] = ACTIONS(273),
    [anon_sym_u2218] = ACTIONS(273),
    [anon_sym_BSLASHstar] = ACTIONS(275),
    [anon_sym_u22c6] = ACTIONS(275),
    [anon_sym_u203c] = ACTIONS(277),
    [sym_hashhash] = ACTIONS(241),
    [sym_dol] = ACTIONS(167),
    [sym_doldol] = ACTIONS(241),
    [anon_sym_QMARK_QMARK] = ACTIONS(279),
    [anon_sym_u2047] = ACTIONS(279),
    [anon_sym_BSLASHsqcap] = ACTIONS(281),
    [anon_sym_u2293] = ACTIONS(281),
    [anon_sym_BSLASHsqcup] = ACTIONS(283),
    [anon_sym_u2294] = ACTIONS(283),
    [anon_sym_BSLASHuplus] = ACTIONS(285),
    [anon_sym_u228e] = ACTIONS(285),
    [anon_sym_BSLASHX] = ACTIONS(287),
    [anon_sym_BSLASHtimes] = ACTIONS(287),
    [anon_sym_u00d7] = ACTIONS(287),
    [anon_sym_BSLASHwr] = ACTIONS(289),
    [anon_sym_u2240] = ACTIONS(289),
    [anon_sym_BSLASHcdot] = ACTIONS(291),
    [anon_sym_u22c5] = ACTIONS(291),
    [sym_pow] = ACTIONS(167),
    [sym_powpow] = ACTIONS(241),
    [anon_sym_CARET_PLUS] = ACTIONS(293),
    [anon_sym_u207a] = ACTIONS(293),
    [sym_asterisk] = ACTIONS(295),
    [sym_sup_hash] = ACTIONS(295),
    [sym_prime] = ACTIONS(295),
    [anon_sym_ONLY] = ACTIONS(574),
    [anon_sym_DEF] = ACTIONS(576),
    [anon_sym_DEFS] = ACTIONS(576),
    [sym__indent] = ACTIONS(410),
    [sym__double_excl] = ACTIONS(277),
  },
  [18] = {
    [sym_block_comment] = STATE(18),
    [sym_forall] = STATE(4003),
    [sym_exists] = STATE(4003),
    [sym_langle_bracket] = STATE(54),
    [sym_subexpr_prefix] = STATE(1098),
    [sym_subexpr_component] = STATE(5469),
    [sym_bound_op] = STATE(2383),
    [sym_bound_nonfix_op] = STATE(2383),
    [sym__expr] = STATE(1223),
    [sym_prefixed_op] = STATE(2406),
    [sym__number] = STATE(2406),
    [sym_nat_number] = STATE(2459),
    [sym_binary_number] = STATE(2459),
    [sym_octal_number] = STATE(2459),
    [sym_hex_number] = STATE(2459),
    [sym_string] = STATE(2406),
    [sym_boolean] = STATE(2406),
    [sym__number_set] = STATE(2463),
    [sym__primitive_value_set] = STATE(2406),
    [sym_nat_number_set] = STATE(2400),
    [sym_int_number_set] = STATE(2400),
    [sym_real_number_set] = STATE(2400),
    [sym_label] = STATE(2406),
    [sym_subexpression] = STATE(2406),
    [sym_parentheses] = STATE(2406),
    [sym_bounded_quantification] = STATE(2406),
    [sym_unbounded_quantification] = STATE(2406),
    [sym_choose] = STATE(2406),
    [sym_finite_set_literal] = STATE(2406),
    [sym_set_filter] = STATE(2406),
    [sym_set_map] = STATE(2406),
    [sym_function_evaluation] = STATE(2406),
    [sym_function_literal] = STATE(2406),
    [sym_set_of_functions] = STATE(2406),
    [sym_record_literal] = STATE(2406),
    [sym_set_of_records] = STATE(2406),
    [sym_record_value] = STATE(2406),
    [sym_except] = STATE(2406),
    [sym_prev_func_val] = STATE(2406),
    [sym_tuple_literal] = STATE(2406),
    [sym_step_expr_or_stutter] = STATE(2406),
    [sym_step_expr_no_stutter] = STATE(2406),
    [sym_fairness] = STATE(2406),
    [sym_if_then_else] = STATE(2406),
    [sym_case] = STATE(2406),
    [sym_let_in] = STATE(2406),
    [sym_conj_list] = STATE(2406),
    [sym_disj_list] = STATE(2406),
    [sym_lnot] = STATE(292),
    [sym_negative] = STATE(807),
    [sym_always] = STATE(245),
    [sym_eventually] = STATE(245),
    [sym_prefix_op_symbol] = STATE(4944),
    [sym_bound_prefix_op] = STATE(2406),
    [sym_implies] = STATE(3441),
    [sym_plus_arrow] = STATE(3441),
    [sym_equiv] = STATE(3441),
    [sym_iff] = STATE(3441),
    [sym_leads_to] = STATE(3441),
    [sym_land] = STATE(3441),
    [sym_lor] = STATE(3441),
    [sym_assign] = STATE(3441),
    [sym_bnf_rule] = STATE(3441),
    [sym_eq] = STATE(3441),
    [sym_neq] = STATE(3441),
    [sym_lt] = STATE(3441),
    [sym_leq] = STATE(3441),
    [sym_geq] = STATE(3441),
    [sym_approx] = STATE(3441),
    [sym_rs_ttile] = STATE(3441),
    [sym_rd_ttile] = STATE(3441),
    [sym_ls_ttile] = STATE(3441),
    [sym_ld_ttile] = STATE(3441),
    [sym_asymp] = STATE(3441),
    [sym_cong] = STATE(3441),
    [sym_doteq] = STATE(3441),
    [sym_gg] = STATE(3441),
    [sym_ll] = STATE(3441),
    [sym_in] = STATE(3441),
    [sym_notin] = STATE(3441),
    [sym_prec] = STATE(3441),
    [sym_succ] = STATE(3441),
    [sym_preceq] = STATE(3441),
    [sym_succeq] = STATE(3441),
    [sym_propto] = STATE(3441),
    [sym_sim] = STATE(3441),
    [sym_simeq] = STATE(3441),
    [sym_sqsubset] = STATE(3441),
    [sym_sqsupset] = STATE(3441),
    [sym_sqsubseteq] = STATE(3441),
    [sym_sqsupseteq] = STATE(3441),
    [sym_subset] = STATE(3441),
    [sym_supset] = STATE(3441),
    [sym_subseteq] = STATE(3441),
    [sym_supseteq] = STATE(3441),
    [sym_cap] = STATE(3441),
    [sym_cup] = STATE(3441),
    [sym_dots_2] = STATE(3441),
    [sym_dots_3] = STATE(3441),
    [sym_plus] = STATE(3441),
    [sym_oplus] = STATE(3441),
    [sym_ominus] = STATE(3441),
    [sym_vertvert] = STATE(3441),
    [sym_minus] = STATE(3441),
    [sym_odot] = STATE(3441),
    [sym_oslash] = STATE(3441),
    [sym_otimes] = STATE(3441),
    [sym_bigcirc] = STATE(3441),
    [sym_bullet] = STATE(3441),
    [sym_div] = STATE(3441),
    [sym_circ] = STATE(3441),
    [sym_star] = STATE(3441),
    [sym_excl] = STATE(3441),
    [sym_qq] = STATE(3441),
    [sym_sqcap] = STATE(3441),
    [sym_sqcup] = STATE(3441),
    [sym_uplus] = STATE(3441),
    [sym_times] = STATE(3441),
    [sym_wr] = STATE(3441),
    [sym_cdot] = STATE(3441),
    [sym_infix_op_symbol] = STATE(4945),
    [sym_bound_infix_op] = STATE(2406),
    [sym_sup_plus] = STATE(3426),
    [sym_postfix_op_symbol] = STATE(4944),
    [sym_bound_postfix_op] = STATE(2406),
    [sym_use_body] = STATE(3590),
    [sym_use_body_expr] = STATE(3538),
    [sym_use_body_def] = STATE(3587),
    [sym_module_ref] = STATE(3505),
    [sym_proof_step_ref] = STATE(2384),
    [sym_identifier] = ACTIONS(578),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(554),
    [anon_sym_BSLASHin] = ACTIONS(59),
    [anon_sym_u2208] = ACTIONS(61),
    [anon_sym_BSLASHA] = ACTIONS(63),
    [anon_sym_BSLASHforall] = ACTIONS(65),
    [anon_sym_u2200] = ACTIONS(65),
    [anon_sym_BSLASHE] = ACTIONS(67),
    [anon_sym_BSLASHexists] = ACTIONS(69),
    [anon_sym_u2203] = ACTIONS(69),
    [sym_temporal_forall] = ACTIONS(415),
    [sym_temporal_exists] = ACTIONS(415),
    [anon_sym_LT_LT] = ACTIONS(73),
    [anon_sym_u3008] = ACTIONS(73),
    [anon_sym_u27e8] = ACTIONS(73),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(75),
    [anon_sym_u25a1] = ACTIONS(75),
    [anon_sym_AT] = ACTIONS(417),
    [anon_sym_SLASH_BSLASH] = ACTIONS(79),
    [anon_sym_u2227] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(81),
    [anon_sym_u2228] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(580),
    [anon_sym_LBRACK] = ACTIONS(422),
    [aux_sym_child_id_token1] = ACTIONS(424),
    [sym_real_number] = ACTIONS(426),
    [anon_sym_BSLASHb] = ACTIONS(428),
    [anon_sym_BSLASHB] = ACTIONS(430),
    [anon_sym_BSLASHo] = ACTIONS(432),
    [anon_sym_BSLASHO] = ACTIONS(434),
    [anon_sym_BSLASHh] = ACTIONS(436),
    [anon_sym_BSLASHH] = ACTIONS(436),
    [anon_sym_DQUOTE] = ACTIONS(438),
    [anon_sym_TRUE] = ACTIONS(440),
    [anon_sym_FALSE] = ACTIONS(440),
    [sym_string_set] = ACTIONS(442),
    [sym_boolean_set] = ACTIONS(442),
    [anon_sym_Nat] = ACTIONS(582),
    [anon_sym_u2115] = ACTIONS(584),
    [anon_sym_Int] = ACTIONS(586),
    [anon_sym_u2124] = ACTIONS(588),
    [anon_sym_Real] = ACTIONS(590),
    [anon_sym_u211d] = ACTIONS(592),
    [anon_sym_CHOOSE] = ACTIONS(462),
    [anon_sym_LBRACE] = ACTIONS(464),
    [anon_sym_EQ] = ACTIONS(125),
    [anon_sym_WF_] = ACTIONS(466),
    [anon_sym_SF_] = ACTIONS(466),
    [anon_sym_IF] = ACTIONS(468),
    [anon_sym_CASE] = ACTIONS(470),
    [anon_sym_LET] = ACTIONS(472),
    [anon_sym_BSLASHlnot] = ACTIONS(135),
    [anon_sym_BSLASHneg] = ACTIONS(135),
    [anon_sym_TILDE] = ACTIONS(137),
    [anon_sym_u00ac] = ACTIONS(135),
    [sym_union] = ACTIONS(594),
    [sym_powerset] = ACTIONS(594),
    [sym_domain] = ACTIONS(594),
    [anon_sym_DASH] = ACTIONS(141),
    [sym_negative_dot] = ACTIONS(41),
    [sym_enabled] = ACTIONS(596),
    [sym_unchanged] = ACTIONS(596),
    [anon_sym_LT_GT] = ACTIONS(145),
    [anon_sym_u22c4] = ACTIONS(145),
    [anon_sym_u25c7] = ACTIONS(145),
    [anon_sym_EQ_GT] = ACTIONS(147),
    [anon_sym_u27f9] = ACTIONS(147),
    [anon_sym_u21d2] = ACTIONS(147),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(149),
    [anon_sym_u21f8] = ACTIONS(149),
    [anon_sym_u2945] = ACTIONS(149),
    [anon_sym_BSLASHequiv] = ACTIONS(151),
    [anon_sym_u2261] = ACTIONS(151),
    [anon_sym_LT_EQ_GT] = ACTIONS(153),
    [anon_sym_u27fa] = ACTIONS(153),
    [anon_sym_u21d4] = ACTIONS(153),
    [anon_sym_TILDE_GT] = ACTIONS(155),
    [anon_sym_u21dd] = ACTIONS(155),
    [anon_sym_u219d] = ACTIONS(155),
    [anon_sym_BSLASHland] = ACTIONS(79),
    [anon_sym_BSLASHlor] = ACTIONS(81),
    [anon_sym_COLON_EQ] = ACTIONS(157),
    [anon_sym_u2254] = ACTIONS(157),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(159),
    [anon_sym_u2a74] = ACTIONS(159),
    [anon_sym_SLASH_EQ] = ACTIONS(161),
    [anon_sym_POUND] = ACTIONS(163),
    [anon_sym_u2260] = ACTIONS(161),
    [anon_sym_LT] = ACTIONS(480),
    [sym_gt] = ACTIONS(167),
    [anon_sym_LT_EQ] = ACTIONS(169),
    [anon_sym_EQ_LT] = ACTIONS(171),
    [anon_sym_BSLASHleq] = ACTIONS(171),
    [anon_sym_u2264] = ACTIONS(171),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_BSLASHgeq] = ACTIONS(173),
    [anon_sym_u2265] = ACTIONS(173),
    [anon_sym_BSLASHapprox] = ACTIONS(175),
    [anon_sym_u2248] = ACTIONS(175),
    [anon_sym_PIPE_DASH] = ACTIONS(177),
    [anon_sym_u22a2] = ACTIONS(177),
    [anon_sym_PIPE_EQ] = ACTIONS(179),
    [anon_sym_u22a8] = ACTIONS(179),
    [anon_sym_DASH_PIPE] = ACTIONS(181),
    [anon_sym_u22a3] = ACTIONS(181),
    [anon_sym_EQ_PIPE] = ACTIONS(183),
    [anon_sym_u2ae4] = ACTIONS(183),
    [anon_sym_BSLASHasymp] = ACTIONS(185),
    [anon_sym_u224d] = ACTIONS(185),
    [anon_sym_BSLASHcong] = ACTIONS(187),
    [anon_sym_u2245] = ACTIONS(187),
    [anon_sym_BSLASHdoteq] = ACTIONS(189),
    [anon_sym_u2250] = ACTIONS(189),
    [anon_sym_BSLASHgg] = ACTIONS(191),
    [anon_sym_u226b] = ACTIONS(191),
    [anon_sym_BSLASHll] = ACTIONS(193),
    [anon_sym_u226a] = ACTIONS(193),
    [anon_sym_BSLASHnotin] = ACTIONS(195),
    [anon_sym_u2209] = ACTIONS(195),
    [anon_sym_BSLASHprec] = ACTIONS(197),
    [anon_sym_u227a] = ACTIONS(199),
    [anon_sym_BSLASHsucc] = ACTIONS(201),
    [anon_sym_u227b] = ACTIONS(203),
    [anon_sym_BSLASHpreceq] = ACTIONS(205),
    [anon_sym_u2aaf] = ACTIONS(205),
    [anon_sym_BSLASHsucceq] = ACTIONS(207),
    [anon_sym_u2ab0] = ACTIONS(207),
    [anon_sym_BSLASHpropto] = ACTIONS(209),
    [anon_sym_u221d] = ACTIONS(209),
    [anon_sym_BSLASHsim] = ACTIONS(211),
    [anon_sym_u223c] = ACTIONS(213),
    [anon_sym_BSLASHsimeq] = ACTIONS(215),
    [anon_sym_u2243] = ACTIONS(215),
    [anon_sym_BSLASHsqsubset] = ACTIONS(217),
    [anon_sym_u228f] = ACTIONS(219),
    [anon_sym_BSLASHsqsupset] = ACTIONS(221),
    [anon_sym_u2290] = ACTIONS(223),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(225),
    [anon_sym_u2291] = ACTIONS(225),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(227),
    [anon_sym_u2292] = ACTIONS(227),
    [anon_sym_BSLASHsubset] = ACTIONS(229),
    [anon_sym_u2282] = ACTIONS(231),
    [anon_sym_BSLASHsupset] = ACTIONS(233),
    [anon_sym_u2283] = ACTIONS(235),
    [anon_sym_BSLASHsubseteq] = ACTIONS(237),
    [anon_sym_u2286] = ACTIONS(237),
    [anon_sym_BSLASHsupseteq] = ACTIONS(239),
    [anon_sym_u2287] = ACTIONS(239),
    [sym_compose] = ACTIONS(241),
    [sym_map_to] = ACTIONS(241),
    [sym_map_from] = ACTIONS(241),
    [sym_setminus] = ACTIONS(167),
    [anon_sym_BSLASHcap] = ACTIONS(243),
    [anon_sym_BSLASHintersect] = ACTIONS(243),
    [anon_sym_u2229] = ACTIONS(243),
    [anon_sym_BSLASHcup] = ACTIONS(245),
    [anon_sym_BSLASHunion] = ACTIONS(245),
    [anon_sym_u222a] = ACTIONS(245),
    [anon_sym_DOT_DOT] = ACTIONS(247),
    [anon_sym_u2025] = ACTIONS(249),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(251),
    [anon_sym_u2026] = ACTIONS(251),
    [anon_sym_PLUS] = ACTIONS(253),
    [sym_plusplus] = ACTIONS(241),
    [anon_sym_BSLASHoplus] = ACTIONS(255),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(255),
    [anon_sym_u2295] = ACTIONS(255),
    [anon_sym_BSLASHominus] = ACTIONS(257),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(257),
    [anon_sym_u2296] = ACTIONS(257),
    [sym_mod] = ACTIONS(167),
    [sym_modmod] = ACTIONS(241),
    [sym_vert] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_u2016] = ACTIONS(259),
    [sym_minusminus] = ACTIONS(241),
    [sym_amp] = ACTIONS(167),
    [sym_ampamp] = ACTIONS(241),
    [anon_sym_BSLASHodot] = ACTIONS(261),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(261),
    [anon_sym_u2299] = ACTIONS(261),
    [anon_sym_BSLASHoslash] = ACTIONS(263),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(263),
    [anon_sym_u2298] = ACTIONS(263),
    [anon_sym_BSLASHotimes] = ACTIONS(265),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(265),
    [anon_sym_u2297] = ACTIONS(265),
    [sym_mul] = ACTIONS(167),
    [sym_mulmul] = ACTIONS(241),
    [sym_slash] = ACTIONS(167),
    [sym_slashslash] = ACTIONS(241),
    [anon_sym_BSLASHbigcirc] = ACTIONS(267),
    [anon_sym_u25ef] = ACTIONS(267),
    [anon_sym_BSLASHbullet] = ACTIONS(269),
    [anon_sym_u25cf] = ACTIONS(269),
    [anon_sym_BSLASHdiv] = ACTIONS(271),
    [anon_sym_u00f7] = ACTIONS(271),
    [anon_sym_BSLASHcirc] = ACTIONS(273),
    [anon_sym_u2218] = ACTIONS(273),
    [anon_sym_BSLASHstar] = ACTIONS(275),
    [anon_sym_u22c6] = ACTIONS(275),
    [anon_sym_u203c] = ACTIONS(277),
    [sym_hashhash] = ACTIONS(241),
    [sym_dol] = ACTIONS(167),
    [sym_doldol] = ACTIONS(241),
    [anon_sym_QMARK_QMARK] = ACTIONS(279),
    [anon_sym_u2047] = ACTIONS(279),
    [anon_sym_BSLASHsqcap] = ACTIONS(281),
    [anon_sym_u2293] = ACTIONS(281),
    [anon_sym_BSLASHsqcup] = ACTIONS(283),
    [anon_sym_u2294] = ACTIONS(283),
    [anon_sym_BSLASHuplus] = ACTIONS(285),
    [anon_sym_u228e] = ACTIONS(285),
    [anon_sym_BSLASHX] = ACTIONS(287),
    [anon_sym_BSLASHtimes] = ACTIONS(287),
    [anon_sym_u00d7] = ACTIONS(287),
    [anon_sym_BSLASHwr] = ACTIONS(289),
    [anon_sym_u2240] = ACTIONS(289),
    [anon_sym_BSLASHcdot] = ACTIONS(291),
    [anon_sym_u22c5] = ACTIONS(291),
    [sym_pow] = ACTIONS(167),
    [sym_powpow] = ACTIONS(241),
    [anon_sym_CARET_PLUS] = ACTIONS(293),
    [anon_sym_u207a] = ACTIONS(293),
    [sym_asterisk] = ACTIONS(295),
    [sym_sup_hash] = ACTIONS(295),
    [sym_prime] = ACTIONS(295),
    [anon_sym_ONLY] = ACTIONS(598),
    [anon_sym_DEF] = ACTIONS(600),
    [anon_sym_DEFS] = ACTIONS(600),
    [sym__indent] = ACTIONS(482),
    [sym__double_excl] = ACTIONS(277),
  },
  [19] = {
    [sym_block_comment] = STATE(19),
    [sym_forall] = STATE(4003),
    [sym_exists] = STATE(4003),
    [sym_langle_bracket] = STATE(54),
    [sym_subexpr_prefix] = STATE(1098),
    [sym_subexpr_component] = STATE(5469),
    [sym_bound_op] = STATE(2383),
    [sym_bound_nonfix_op] = STATE(2383),
    [sym__expr] = STATE(1223),
    [sym_prefixed_op] = STATE(2406),
    [sym__number] = STATE(2406),
    [sym_nat_number] = STATE(2459),
    [sym_binary_number] = STATE(2459),
    [sym_octal_number] = STATE(2459),
    [sym_hex_number] = STATE(2459),
    [sym_string] = STATE(2406),
    [sym_boolean] = STATE(2406),
    [sym__number_set] = STATE(2463),
    [sym__primitive_value_set] = STATE(2406),
    [sym_nat_number_set] = STATE(2400),
    [sym_int_number_set] = STATE(2400),
    [sym_real_number_set] = STATE(2400),
    [sym_label] = STATE(2406),
    [sym_subexpression] = STATE(2406),
    [sym_parentheses] = STATE(2406),
    [sym_bounded_quantification] = STATE(2406),
    [sym_unbounded_quantification] = STATE(2406),
    [sym_choose] = STATE(2406),
    [sym_finite_set_literal] = STATE(2406),
    [sym_set_filter] = STATE(2406),
    [sym_set_map] = STATE(2406),
    [sym_function_evaluation] = STATE(2406),
    [sym_function_literal] = STATE(2406),
    [sym_set_of_functions] = STATE(2406),
    [sym_record_literal] = STATE(2406),
    [sym_set_of_records] = STATE(2406),
    [sym_record_value] = STATE(2406),
    [sym_except] = STATE(2406),
    [sym_prev_func_val] = STATE(2406),
    [sym_tuple_literal] = STATE(2406),
    [sym_step_expr_or_stutter] = STATE(2406),
    [sym_step_expr_no_stutter] = STATE(2406),
    [sym_fairness] = STATE(2406),
    [sym_if_then_else] = STATE(2406),
    [sym_case] = STATE(2406),
    [sym_let_in] = STATE(2406),
    [sym_conj_list] = STATE(2406),
    [sym_disj_list] = STATE(2406),
    [sym_lnot] = STATE(292),
    [sym_negative] = STATE(807),
    [sym_always] = STATE(245),
    [sym_eventually] = STATE(245),
    [sym_prefix_op_symbol] = STATE(4944),
    [sym_bound_prefix_op] = STATE(2406),
    [sym_implies] = STATE(3441),
    [sym_plus_arrow] = STATE(3441),
    [sym_equiv] = STATE(3441),
    [sym_iff] = STATE(3441),
    [sym_leads_to] = STATE(3441),
    [sym_land] = STATE(3441),
    [sym_lor] = STATE(3441),
    [sym_assign] = STATE(3441),
    [sym_bnf_rule] = STATE(3441),
    [sym_eq] = STATE(3441),
    [sym_neq] = STATE(3441),
    [sym_lt] = STATE(3441),
    [sym_leq] = STATE(3441),
    [sym_geq] = STATE(3441),
    [sym_approx] = STATE(3441),
    [sym_rs_ttile] = STATE(3441),
    [sym_rd_ttile] = STATE(3441),
    [sym_ls_ttile] = STATE(3441),
    [sym_ld_ttile] = STATE(3441),
    [sym_asymp] = STATE(3441),
    [sym_cong] = STATE(3441),
    [sym_doteq] = STATE(3441),
    [sym_gg] = STATE(3441),
    [sym_ll] = STATE(3441),
    [sym_in] = STATE(3441),
    [sym_notin] = STATE(3441),
    [sym_prec] = STATE(3441),
    [sym_succ] = STATE(3441),
    [sym_preceq] = STATE(3441),
    [sym_succeq] = STATE(3441),
    [sym_propto] = STATE(3441),
    [sym_sim] = STATE(3441),
    [sym_simeq] = STATE(3441),
    [sym_sqsubset] = STATE(3441),
    [sym_sqsupset] = STATE(3441),
    [sym_sqsubseteq] = STATE(3441),
    [sym_sqsupseteq] = STATE(3441),
    [sym_subset] = STATE(3441),
    [sym_supset] = STATE(3441),
    [sym_subseteq] = STATE(3441),
    [sym_supseteq] = STATE(3441),
    [sym_cap] = STATE(3441),
    [sym_cup] = STATE(3441),
    [sym_dots_2] = STATE(3441),
    [sym_dots_3] = STATE(3441),
    [sym_plus] = STATE(3441),
    [sym_oplus] = STATE(3441),
    [sym_ominus] = STATE(3441),
    [sym_vertvert] = STATE(3441),
    [sym_minus] = STATE(3441),
    [sym_odot] = STATE(3441),
    [sym_oslash] = STATE(3441),
    [sym_otimes] = STATE(3441),
    [sym_bigcirc] = STATE(3441),
    [sym_bullet] = STATE(3441),
    [sym_div] = STATE(3441),
    [sym_circ] = STATE(3441),
    [sym_star] = STATE(3441),
    [sym_excl] = STATE(3441),
    [sym_qq] = STATE(3441),
    [sym_sqcap] = STATE(3441),
    [sym_sqcup] = STATE(3441),
    [sym_uplus] = STATE(3441),
    [sym_times] = STATE(3441),
    [sym_wr] = STATE(3441),
    [sym_cdot] = STATE(3441),
    [sym_infix_op_symbol] = STATE(4945),
    [sym_bound_infix_op] = STATE(2406),
    [sym_sup_plus] = STATE(3426),
    [sym_postfix_op_symbol] = STATE(4944),
    [sym_bound_postfix_op] = STATE(2406),
    [sym_use_body] = STATE(3581),
    [sym_use_body_expr] = STATE(3538),
    [sym_use_body_def] = STATE(3587),
    [sym_module_ref] = STATE(3505),
    [sym_proof_step_ref] = STATE(2384),
    [sym_identifier] = ACTIONS(578),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(554),
    [anon_sym_BSLASHin] = ACTIONS(59),
    [anon_sym_u2208] = ACTIONS(61),
    [anon_sym_BSLASHA] = ACTIONS(63),
    [anon_sym_BSLASHforall] = ACTIONS(65),
    [anon_sym_u2200] = ACTIONS(65),
    [anon_sym_BSLASHE] = ACTIONS(67),
    [anon_sym_BSLASHexists] = ACTIONS(69),
    [anon_sym_u2203] = ACTIONS(69),
    [sym_temporal_forall] = ACTIONS(415),
    [sym_temporal_exists] = ACTIONS(415),
    [anon_sym_LT_LT] = ACTIONS(73),
    [anon_sym_u3008] = ACTIONS(73),
    [anon_sym_u27e8] = ACTIONS(73),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(75),
    [anon_sym_u25a1] = ACTIONS(75),
    [anon_sym_AT] = ACTIONS(417),
    [anon_sym_SLASH_BSLASH] = ACTIONS(79),
    [anon_sym_u2227] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(81),
    [anon_sym_u2228] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(580),
    [anon_sym_LBRACK] = ACTIONS(422),
    [aux_sym_child_id_token1] = ACTIONS(424),
    [sym_real_number] = ACTIONS(426),
    [anon_sym_BSLASHb] = ACTIONS(428),
    [anon_sym_BSLASHB] = ACTIONS(430),
    [anon_sym_BSLASHo] = ACTIONS(432),
    [anon_sym_BSLASHO] = ACTIONS(434),
    [anon_sym_BSLASHh] = ACTIONS(436),
    [anon_sym_BSLASHH] = ACTIONS(436),
    [anon_sym_DQUOTE] = ACTIONS(438),
    [anon_sym_TRUE] = ACTIONS(440),
    [anon_sym_FALSE] = ACTIONS(440),
    [sym_string_set] = ACTIONS(442),
    [sym_boolean_set] = ACTIONS(442),
    [anon_sym_Nat] = ACTIONS(582),
    [anon_sym_u2115] = ACTIONS(584),
    [anon_sym_Int] = ACTIONS(586),
    [anon_sym_u2124] = ACTIONS(588),
    [anon_sym_Real] = ACTIONS(590),
    [anon_sym_u211d] = ACTIONS(592),
    [anon_sym_CHOOSE] = ACTIONS(462),
    [anon_sym_LBRACE] = ACTIONS(464),
    [anon_sym_EQ] = ACTIONS(125),
    [anon_sym_WF_] = ACTIONS(466),
    [anon_sym_SF_] = ACTIONS(466),
    [anon_sym_IF] = ACTIONS(468),
    [anon_sym_CASE] = ACTIONS(470),
    [anon_sym_LET] = ACTIONS(472),
    [anon_sym_BSLASHlnot] = ACTIONS(135),
    [anon_sym_BSLASHneg] = ACTIONS(135),
    [anon_sym_TILDE] = ACTIONS(137),
    [anon_sym_u00ac] = ACTIONS(135),
    [sym_union] = ACTIONS(594),
    [sym_powerset] = ACTIONS(594),
    [sym_domain] = ACTIONS(594),
    [anon_sym_DASH] = ACTIONS(141),
    [sym_negative_dot] = ACTIONS(41),
    [sym_enabled] = ACTIONS(596),
    [sym_unchanged] = ACTIONS(596),
    [anon_sym_LT_GT] = ACTIONS(145),
    [anon_sym_u22c4] = ACTIONS(145),
    [anon_sym_u25c7] = ACTIONS(145),
    [anon_sym_EQ_GT] = ACTIONS(147),
    [anon_sym_u27f9] = ACTIONS(147),
    [anon_sym_u21d2] = ACTIONS(147),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(149),
    [anon_sym_u21f8] = ACTIONS(149),
    [anon_sym_u2945] = ACTIONS(149),
    [anon_sym_BSLASHequiv] = ACTIONS(151),
    [anon_sym_u2261] = ACTIONS(151),
    [anon_sym_LT_EQ_GT] = ACTIONS(153),
    [anon_sym_u27fa] = ACTIONS(153),
    [anon_sym_u21d4] = ACTIONS(153),
    [anon_sym_TILDE_GT] = ACTIONS(155),
    [anon_sym_u21dd] = ACTIONS(155),
    [anon_sym_u219d] = ACTIONS(155),
    [anon_sym_BSLASHland] = ACTIONS(79),
    [anon_sym_BSLASHlor] = ACTIONS(81),
    [anon_sym_COLON_EQ] = ACTIONS(157),
    [anon_sym_u2254] = ACTIONS(157),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(159),
    [anon_sym_u2a74] = ACTIONS(159),
    [anon_sym_SLASH_EQ] = ACTIONS(161),
    [anon_sym_POUND] = ACTIONS(163),
    [anon_sym_u2260] = ACTIONS(161),
    [anon_sym_LT] = ACTIONS(480),
    [sym_gt] = ACTIONS(167),
    [anon_sym_LT_EQ] = ACTIONS(169),
    [anon_sym_EQ_LT] = ACTIONS(171),
    [anon_sym_BSLASHleq] = ACTIONS(171),
    [anon_sym_u2264] = ACTIONS(171),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_BSLASHgeq] = ACTIONS(173),
    [anon_sym_u2265] = ACTIONS(173),
    [anon_sym_BSLASHapprox] = ACTIONS(175),
    [anon_sym_u2248] = ACTIONS(175),
    [anon_sym_PIPE_DASH] = ACTIONS(177),
    [anon_sym_u22a2] = ACTIONS(177),
    [anon_sym_PIPE_EQ] = ACTIONS(179),
    [anon_sym_u22a8] = ACTIONS(179),
    [anon_sym_DASH_PIPE] = ACTIONS(181),
    [anon_sym_u22a3] = ACTIONS(181),
    [anon_sym_EQ_PIPE] = ACTIONS(183),
    [anon_sym_u2ae4] = ACTIONS(183),
    [anon_sym_BSLASHasymp] = ACTIONS(185),
    [anon_sym_u224d] = ACTIONS(185),
    [anon_sym_BSLASHcong] = ACTIONS(187),
    [anon_sym_u2245] = ACTIONS(187),
    [anon_sym_BSLASHdoteq] = ACTIONS(189),
    [anon_sym_u2250] = ACTIONS(189),
    [anon_sym_BSLASHgg] = ACTIONS(191),
    [anon_sym_u226b] = ACTIONS(191),
    [anon_sym_BSLASHll] = ACTIONS(193),
    [anon_sym_u226a] = ACTIONS(193),
    [anon_sym_BSLASHnotin] = ACTIONS(195),
    [anon_sym_u2209] = ACTIONS(195),
    [anon_sym_BSLASHprec] = ACTIONS(197),
    [anon_sym_u227a] = ACTIONS(199),
    [anon_sym_BSLASHsucc] = ACTIONS(201),
    [anon_sym_u227b] = ACTIONS(203),
    [anon_sym_BSLASHpreceq] = ACTIONS(205),
    [anon_sym_u2aaf] = ACTIONS(205),
    [anon_sym_BSLASHsucceq] = ACTIONS(207),
    [anon_sym_u2ab0] = ACTIONS(207),
    [anon_sym_BSLASHpropto] = ACTIONS(209),
    [anon_sym_u221d] = ACTIONS(209),
    [anon_sym_BSLASHsim] = ACTIONS(211),
    [anon_sym_u223c] = ACTIONS(213),
    [anon_sym_BSLASHsimeq] = ACTIONS(215),
    [anon_sym_u2243] = ACTIONS(215),
    [anon_sym_BSLASHsqsubset] = ACTIONS(217),
    [anon_sym_u228f] = ACTIONS(219),
    [anon_sym_BSLASHsqsupset] = ACTIONS(221),
    [anon_sym_u2290] = ACTIONS(223),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(225),
    [anon_sym_u2291] = ACTIONS(225),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(227),
    [anon_sym_u2292] = ACTIONS(227),
    [anon_sym_BSLASHsubset] = ACTIONS(229),
    [anon_sym_u2282] = ACTIONS(231),
    [anon_sym_BSLASHsupset] = ACTIONS(233),
    [anon_sym_u2283] = ACTIONS(235),
    [anon_sym_BSLASHsubseteq] = ACTIONS(237),
    [anon_sym_u2286] = ACTIONS(237),
    [anon_sym_BSLASHsupseteq] = ACTIONS(239),
    [anon_sym_u2287] = ACTIONS(239),
    [sym_compose] = ACTIONS(241),
    [sym_map_to] = ACTIONS(241),
    [sym_map_from] = ACTIONS(241),
    [sym_setminus] = ACTIONS(167),
    [anon_sym_BSLASHcap] = ACTIONS(243),
    [anon_sym_BSLASHintersect] = ACTIONS(243),
    [anon_sym_u2229] = ACTIONS(243),
    [anon_sym_BSLASHcup] = ACTIONS(245),
    [anon_sym_BSLASHunion] = ACTIONS(245),
    [anon_sym_u222a] = ACTIONS(245),
    [anon_sym_DOT_DOT] = ACTIONS(247),
    [anon_sym_u2025] = ACTIONS(249),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(251),
    [anon_sym_u2026] = ACTIONS(251),
    [anon_sym_PLUS] = ACTIONS(253),
    [sym_plusplus] = ACTIONS(241),
    [anon_sym_BSLASHoplus] = ACTIONS(255),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(255),
    [anon_sym_u2295] = ACTIONS(255),
    [anon_sym_BSLASHominus] = ACTIONS(257),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(257),
    [anon_sym_u2296] = ACTIONS(257),
    [sym_mod] = ACTIONS(167),
    [sym_modmod] = ACTIONS(241),
    [sym_vert] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_u2016] = ACTIONS(259),
    [sym_minusminus] = ACTIONS(241),
    [sym_amp] = ACTIONS(167),
    [sym_ampamp] = ACTIONS(241),
    [anon_sym_BSLASHodot] = ACTIONS(261),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(261),
    [anon_sym_u2299] = ACTIONS(261),
    [anon_sym_BSLASHoslash] = ACTIONS(263),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(263),
    [anon_sym_u2298] = ACTIONS(263),
    [anon_sym_BSLASHotimes] = ACTIONS(265),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(265),
    [anon_sym_u2297] = ACTIONS(265),
    [sym_mul] = ACTIONS(167),
    [sym_mulmul] = ACTIONS(241),
    [sym_slash] = ACTIONS(167),
    [sym_slashslash] = ACTIONS(241),
    [anon_sym_BSLASHbigcirc] = ACTIONS(267),
    [anon_sym_u25ef] = ACTIONS(267),
    [anon_sym_BSLASHbullet] = ACTIONS(269),
    [anon_sym_u25cf] = ACTIONS(269),
    [anon_sym_BSLASHdiv] = ACTIONS(271),
    [anon_sym_u00f7] = ACTIONS(271),
    [anon_sym_BSLASHcirc] = ACTIONS(273),
    [anon_sym_u2218] = ACTIONS(273),
    [anon_sym_BSLASHstar] = ACTIONS(275),
    [anon_sym_u22c6] = ACTIONS(275),
    [anon_sym_u203c] = ACTIONS(277),
    [sym_hashhash] = ACTIONS(241),
    [sym_dol] = ACTIONS(167),
    [sym_doldol] = ACTIONS(241),
    [anon_sym_QMARK_QMARK] = ACTIONS(279),
    [anon_sym_u2047] = ACTIONS(279),
    [anon_sym_BSLASHsqcap] = ACTIONS(281),
    [anon_sym_u2293] = ACTIONS(281),
    [anon_sym_BSLASHsqcup] = ACTIONS(283),
    [anon_sym_u2294] = ACTIONS(283),
    [anon_sym_BSLASHuplus] = ACTIONS(285),
    [anon_sym_u228e] = ACTIONS(285),
    [anon_sym_BSLASHX] = ACTIONS(287),
    [anon_sym_BSLASHtimes] = ACTIONS(287),
    [anon_sym_u00d7] = ACTIONS(287),
    [anon_sym_BSLASHwr] = ACTIONS(289),
    [anon_sym_u2240] = ACTIONS(289),
    [anon_sym_BSLASHcdot] = ACTIONS(291),
    [anon_sym_u22c5] = ACTIONS(291),
    [sym_pow] = ACTIONS(167),
    [sym_powpow] = ACTIONS(241),
    [anon_sym_CARET_PLUS] = ACTIONS(293),
    [anon_sym_u207a] = ACTIONS(293),
    [sym_asterisk] = ACTIONS(295),
    [sym_sup_hash] = ACTIONS(295),
    [sym_prime] = ACTIONS(295),
    [anon_sym_ONLY] = ACTIONS(602),
    [anon_sym_DEF] = ACTIONS(600),
    [anon_sym_DEFS] = ACTIONS(600),
    [sym__indent] = ACTIONS(482),
    [sym__double_excl] = ACTIONS(277),
  },
  [20] = {
    [sym_block_comment] = STATE(20),
    [sym_forall] = STATE(4013),
    [sym_exists] = STATE(4013),
    [sym_langle_bracket] = STATE(80),
    [sym_subexpr_prefix] = STATE(1094),
    [sym_subexpr_component] = STATE(5469),
    [sym_bound_op] = STATE(3105),
    [sym_bound_nonfix_op] = STATE(3105),
    [sym__expr] = STATE(1753),
    [sym_prefixed_op] = STATE(3194),
    [sym__number] = STATE(3194),
    [sym_nat_number] = STATE(3313),
    [sym_binary_number] = STATE(3313),
    [sym_octal_number] = STATE(3313),
    [sym_hex_number] = STATE(3313),
    [sym_string] = STATE(3194),
    [sym_boolean] = STATE(3194),
    [sym__number_set] = STATE(3336),
    [sym__primitive_value_set] = STATE(3194),
    [sym_nat_number_set] = STATE(3303),
    [sym_int_number_set] = STATE(3303),
    [sym_real_number_set] = STATE(3303),
    [sym_label] = STATE(3194),
    [sym_subexpression] = STATE(3194),
    [sym_parentheses] = STATE(3194),
    [sym_bounded_quantification] = STATE(3194),
    [sym_unbounded_quantification] = STATE(3194),
    [sym_choose] = STATE(3194),
    [sym_finite_set_literal] = STATE(3194),
    [sym_set_filter] = STATE(3194),
    [sym_set_map] = STATE(3194),
    [sym_function_evaluation] = STATE(3194),
    [sym_function_literal] = STATE(3194),
    [sym_set_of_functions] = STATE(3194),
    [sym_record_literal] = STATE(3194),
    [sym_set_of_records] = STATE(3194),
    [sym_record_value] = STATE(3194),
    [sym_except] = STATE(3194),
    [sym_prev_func_val] = STATE(3194),
    [sym_tuple_literal] = STATE(3194),
    [sym_step_expr_or_stutter] = STATE(3194),
    [sym_step_expr_no_stutter] = STATE(3194),
    [sym_fairness] = STATE(3194),
    [sym_if_then_else] = STATE(3194),
    [sym_case] = STATE(3194),
    [sym_let_in] = STATE(3194),
    [sym_conj_list] = STATE(3194),
    [sym_disj_list] = STATE(3194),
    [sym_lnot] = STATE(280),
    [sym_negative] = STATE(630),
    [sym_always] = STATE(279),
    [sym_eventually] = STATE(279),
    [sym_prefix_op_symbol] = STATE(4989),
    [sym_bound_prefix_op] = STATE(3194),
    [sym_implies] = STATE(3441),
    [sym_plus_arrow] = STATE(3441),
    [sym_equiv] = STATE(3441),
    [sym_iff] = STATE(3441),
    [sym_leads_to] = STATE(3441),
    [sym_land] = STATE(3441),
    [sym_lor] = STATE(3441),
    [sym_assign] = STATE(3441),
    [sym_bnf_rule] = STATE(3441),
    [sym_eq] = STATE(3441),
    [sym_neq] = STATE(3441),
    [sym_lt] = STATE(3441),
    [sym_leq] = STATE(3441),
    [sym_geq] = STATE(3441),
    [sym_approx] = STATE(3441),
    [sym_rs_ttile] = STATE(3441),
    [sym_rd_ttile] = STATE(3441),
    [sym_ls_ttile] = STATE(3441),
    [sym_ld_ttile] = STATE(3441),
    [sym_asymp] = STATE(3441),
    [sym_cong] = STATE(3441),
    [sym_doteq] = STATE(3441),
    [sym_gg] = STATE(3441),
    [sym_ll] = STATE(3441),
    [sym_in] = STATE(3441),
    [sym_notin] = STATE(3441),
    [sym_prec] = STATE(3441),
    [sym_succ] = STATE(3441),
    [sym_preceq] = STATE(3441),
    [sym_succeq] = STATE(3441),
    [sym_propto] = STATE(3441),
    [sym_sim] = STATE(3441),
    [sym_simeq] = STATE(3441),
    [sym_sqsubset] = STATE(3441),
    [sym_sqsupset] = STATE(3441),
    [sym_sqsubseteq] = STATE(3441),
    [sym_sqsupseteq] = STATE(3441),
    [sym_subset] = STATE(3441),
    [sym_supset] = STATE(3441),
    [sym_subseteq] = STATE(3441),
    [sym_supseteq] = STATE(3441),
    [sym_cap] = STATE(3441),
    [sym_cup] = STATE(3441),
    [sym_dots_2] = STATE(3441),
    [sym_dots_3] = STATE(3441),
    [sym_plus] = STATE(3441),
    [sym_oplus] = STATE(3441),
    [sym_ominus] = STATE(3441),
    [sym_vertvert] = STATE(3441),
    [sym_minus] = STATE(3441),
    [sym_odot] = STATE(3441),
    [sym_oslash] = STATE(3441),
    [sym_otimes] = STATE(3441),
    [sym_bigcirc] = STATE(3441),
    [sym_bullet] = STATE(3441),
    [sym_div] = STATE(3441),
    [sym_circ] = STATE(3441),
    [sym_star] = STATE(3441),
    [sym_excl] = STATE(3441),
    [sym_qq] = STATE(3441),
    [sym_sqcap] = STATE(3441),
    [sym_sqcup] = STATE(3441),
    [sym_uplus] = STATE(3441),
    [sym_times] = STATE(3441),
    [sym_wr] = STATE(3441),
    [sym_cdot] = STATE(3441),
    [sym_infix_op_symbol] = STATE(5057),
    [sym_bound_infix_op] = STATE(3194),
    [sym_sup_plus] = STATE(3426),
    [sym_postfix_op_symbol] = STATE(4989),
    [sym_bound_postfix_op] = STATE(3194),
    [sym_use_body] = STATE(5331),
    [sym_use_body_expr] = STATE(4374),
    [sym_use_body_def] = STATE(5535),
    [sym_module_ref] = STATE(4195),
    [sym_proof_step_ref] = STATE(3091),
    [sym_identifier] = ACTIONS(604),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(606),
    [anon_sym_BSLASHin] = ACTIONS(59),
    [anon_sym_u2208] = ACTIONS(61),
    [anon_sym_BSLASHA] = ACTIONS(63),
    [anon_sym_BSLASHforall] = ACTIONS(65),
    [anon_sym_u2200] = ACTIONS(65),
    [anon_sym_BSLASHE] = ACTIONS(67),
    [anon_sym_BSLASHexists] = ACTIONS(69),
    [anon_sym_u2203] = ACTIONS(69),
    [sym_temporal_forall] = ACTIONS(608),
    [sym_temporal_exists] = ACTIONS(608),
    [anon_sym_LT_LT] = ACTIONS(73),
    [anon_sym_u3008] = ACTIONS(73),
    [anon_sym_u27e8] = ACTIONS(73),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(75),
    [anon_sym_u25a1] = ACTIONS(75),
    [anon_sym_AT] = ACTIONS(610),
    [anon_sym_SLASH_BSLASH] = ACTIONS(79),
    [anon_sym_u2227] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(81),
    [anon_sym_u2228] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(612),
    [anon_sym_LBRACK] = ACTIONS(614),
    [aux_sym_child_id_token1] = ACTIONS(616),
    [sym_real_number] = ACTIONS(618),
    [anon_sym_BSLASHb] = ACTIONS(620),
    [anon_sym_BSLASHB] = ACTIONS(622),
    [anon_sym_BSLASHo] = ACTIONS(624),
    [anon_sym_BSLASHO] = ACTIONS(626),
    [anon_sym_BSLASHh] = ACTIONS(628),
    [anon_sym_BSLASHH] = ACTIONS(628),
    [anon_sym_DQUOTE] = ACTIONS(630),
    [anon_sym_TRUE] = ACTIONS(632),
    [anon_sym_FALSE] = ACTIONS(632),
    [sym_string_set] = ACTIONS(634),
    [sym_boolean_set] = ACTIONS(634),
    [anon_sym_Nat] = ACTIONS(636),
    [anon_sym_u2115] = ACTIONS(638),
    [anon_sym_Int] = ACTIONS(640),
    [anon_sym_u2124] = ACTIONS(642),
    [anon_sym_Real] = ACTIONS(644),
    [anon_sym_u211d] = ACTIONS(646),
    [anon_sym_CHOOSE] = ACTIONS(648),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(125),
    [anon_sym_WF_] = ACTIONS(652),
    [anon_sym_SF_] = ACTIONS(652),
    [anon_sym_IF] = ACTIONS(654),
    [anon_sym_CASE] = ACTIONS(656),
    [anon_sym_LET] = ACTIONS(658),
    [anon_sym_BSLASHlnot] = ACTIONS(135),
    [anon_sym_BSLASHneg] = ACTIONS(135),
    [anon_sym_TILDE] = ACTIONS(137),
    [anon_sym_u00ac] = ACTIONS(135),
    [sym_union] = ACTIONS(660),
    [sym_powerset] = ACTIONS(660),
    [sym_domain] = ACTIONS(660),
    [anon_sym_DASH] = ACTIONS(141),
    [sym_negative_dot] = ACTIONS(41),
    [sym_enabled] = ACTIONS(662),
    [sym_unchanged] = ACTIONS(662),
    [anon_sym_LT_GT] = ACTIONS(145),
    [anon_sym_u22c4] = ACTIONS(145),
    [anon_sym_u25c7] = ACTIONS(145),
    [anon_sym_EQ_GT] = ACTIONS(147),
    [anon_sym_u27f9] = ACTIONS(147),
    [anon_sym_u21d2] = ACTIONS(147),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(149),
    [anon_sym_u21f8] = ACTIONS(149),
    [anon_sym_u2945] = ACTIONS(149),
    [anon_sym_BSLASHequiv] = ACTIONS(151),
    [anon_sym_u2261] = ACTIONS(151),
    [anon_sym_LT_EQ_GT] = ACTIONS(153),
    [anon_sym_u27fa] = ACTIONS(153),
    [anon_sym_u21d4] = ACTIONS(153),
    [anon_sym_TILDE_GT] = ACTIONS(155),
    [anon_sym_u21dd] = ACTIONS(155),
    [anon_sym_u219d] = ACTIONS(155),
    [anon_sym_BSLASHland] = ACTIONS(79),
    [anon_sym_BSLASHlor] = ACTIONS(81),
    [anon_sym_COLON_EQ] = ACTIONS(157),
    [anon_sym_u2254] = ACTIONS(157),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(159),
    [anon_sym_u2a74] = ACTIONS(159),
    [anon_sym_SLASH_EQ] = ACTIONS(161),
    [anon_sym_POUND] = ACTIONS(163),
    [anon_sym_u2260] = ACTIONS(161),
    [anon_sym_LT] = ACTIONS(664),
    [sym_gt] = ACTIONS(167),
    [anon_sym_LT_EQ] = ACTIONS(169),
    [anon_sym_EQ_LT] = ACTIONS(171),
    [anon_sym_BSLASHleq] = ACTIONS(171),
    [anon_sym_u2264] = ACTIONS(171),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_BSLASHgeq] = ACTIONS(173),
    [anon_sym_u2265] = ACTIONS(173),
    [anon_sym_BSLASHapprox] = ACTIONS(175),
    [anon_sym_u2248] = ACTIONS(175),
    [anon_sym_PIPE_DASH] = ACTIONS(177),
    [anon_sym_u22a2] = ACTIONS(177),
    [anon_sym_PIPE_EQ] = ACTIONS(179),
    [anon_sym_u22a8] = ACTIONS(179),
    [anon_sym_DASH_PIPE] = ACTIONS(181),
    [anon_sym_u22a3] = ACTIONS(181),
    [anon_sym_EQ_PIPE] = ACTIONS(183),
    [anon_sym_u2ae4] = ACTIONS(183),
    [anon_sym_BSLASHasymp] = ACTIONS(185),
    [anon_sym_u224d] = ACTIONS(185),
    [anon_sym_BSLASHcong] = ACTIONS(187),
    [anon_sym_u2245] = ACTIONS(187),
    [anon_sym_BSLASHdoteq] = ACTIONS(189),
    [anon_sym_u2250] = ACTIONS(189),
    [anon_sym_BSLASHgg] = ACTIONS(191),
    [anon_sym_u226b] = ACTIONS(191),
    [anon_sym_BSLASHll] = ACTIONS(193),
    [anon_sym_u226a] = ACTIONS(193),
    [anon_sym_BSLASHnotin] = ACTIONS(195),
    [anon_sym_u2209] = ACTIONS(195),
    [anon_sym_BSLASHprec] = ACTIONS(197),
    [anon_sym_u227a] = ACTIONS(199),
    [anon_sym_BSLASHsucc] = ACTIONS(201),
    [anon_sym_u227b] = ACTIONS(203),
    [anon_sym_BSLASHpreceq] = ACTIONS(205),
    [anon_sym_u2aaf] = ACTIONS(205),
    [anon_sym_BSLASHsucceq] = ACTIONS(207),
    [anon_sym_u2ab0] = ACTIONS(207),
    [anon_sym_BSLASHpropto] = ACTIONS(209),
    [anon_sym_u221d] = ACTIONS(209),
    [anon_sym_BSLASHsim] = ACTIONS(211),
    [anon_sym_u223c] = ACTIONS(213),
    [anon_sym_BSLASHsimeq] = ACTIONS(215),
    [anon_sym_u2243] = ACTIONS(215),
    [anon_sym_BSLASHsqsubset] = ACTIONS(217),
    [anon_sym_u228f] = ACTIONS(219),
    [anon_sym_BSLASHsqsupset] = ACTIONS(221),
    [anon_sym_u2290] = ACTIONS(223),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(225),
    [anon_sym_u2291] = ACTIONS(225),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(227),
    [anon_sym_u2292] = ACTIONS(227),
    [anon_sym_BSLASHsubset] = ACTIONS(229),
    [anon_sym_u2282] = ACTIONS(231),
    [anon_sym_BSLASHsupset] = ACTIONS(233),
    [anon_sym_u2283] = ACTIONS(235),
    [anon_sym_BSLASHsubseteq] = ACTIONS(237),
    [anon_sym_u2286] = ACTIONS(237),
    [anon_sym_BSLASHsupseteq] = ACTIONS(239),
    [anon_sym_u2287] = ACTIONS(239),
    [sym_compose] = ACTIONS(241),
    [sym_map_to] = ACTIONS(241),
    [sym_map_from] = ACTIONS(241),
    [sym_setminus] = ACTIONS(167),
    [anon_sym_BSLASHcap] = ACTIONS(243),
    [anon_sym_BSLASHintersect] = ACTIONS(243),
    [anon_sym_u2229] = ACTIONS(243),
    [anon_sym_BSLASHcup] = ACTIONS(245),
    [anon_sym_BSLASHunion] = ACTIONS(245),
    [anon_sym_u222a] = ACTIONS(245),
    [anon_sym_DOT_DOT] = ACTIONS(247),
    [anon_sym_u2025] = ACTIONS(249),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(251),
    [anon_sym_u2026] = ACTIONS(251),
    [anon_sym_PLUS] = ACTIONS(253),
    [sym_plusplus] = ACTIONS(241),
    [anon_sym_BSLASHoplus] = ACTIONS(255),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(255),
    [anon_sym_u2295] = ACTIONS(255),
    [anon_sym_BSLASHominus] = ACTIONS(257),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(257),
    [anon_sym_u2296] = ACTIONS(257),
    [sym_mod] = ACTIONS(167),
    [sym_modmod] = ACTIONS(241),
    [sym_vert] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_u2016] = ACTIONS(259),
    [sym_minusminus] = ACTIONS(241),
    [sym_amp] = ACTIONS(167),
    [sym_ampamp] = ACTIONS(241),
    [anon_sym_BSLASHodot] = ACTIONS(261),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(261),
    [anon_sym_u2299] = ACTIONS(261),
    [anon_sym_BSLASHoslash] = ACTIONS(263),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(263),
    [anon_sym_u2298] = ACTIONS(263),
    [anon_sym_BSLASHotimes] = ACTIONS(265),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(265),
    [anon_sym_u2297] = ACTIONS(265),
    [sym_mul] = ACTIONS(167),
    [sym_mulmul] = ACTIONS(241),
    [sym_slash] = ACTIONS(167),
    [sym_slashslash] = ACTIONS(241),
    [anon_sym_BSLASHbigcirc] = ACTIONS(267),
    [anon_sym_u25ef] = ACTIONS(267),
    [anon_sym_BSLASHbullet] = ACTIONS(269),
    [anon_sym_u25cf] = ACTIONS(269),
    [anon_sym_BSLASHdiv] = ACTIONS(271),
    [anon_sym_u00f7] = ACTIONS(271),
    [anon_sym_BSLASHcirc] = ACTIONS(273),
    [anon_sym_u2218] = ACTIONS(273),
    [anon_sym_BSLASHstar] = ACTIONS(275),
    [anon_sym_u22c6] = ACTIONS(275),
    [anon_sym_u203c] = ACTIONS(277),
    [sym_hashhash] = ACTIONS(241),
    [sym_dol] = ACTIONS(167),
    [sym_doldol] = ACTIONS(241),
    [anon_sym_QMARK_QMARK] = ACTIONS(279),
    [anon_sym_u2047] = ACTIONS(279),
    [anon_sym_BSLASHsqcap] = ACTIONS(281),
    [anon_sym_u2293] = ACTIONS(281),
    [anon_sym_BSLASHsqcup] = ACTIONS(283),
    [anon_sym_u2294] = ACTIONS(283),
    [anon_sym_BSLASHuplus] = ACTIONS(285),
    [anon_sym_u228e] = ACTIONS(285),
    [anon_sym_BSLASHX] = ACTIONS(287),
    [anon_sym_BSLASHtimes] = ACTIONS(287),
    [anon_sym_u00d7] = ACTIONS(287),
    [anon_sym_BSLASHwr] = ACTIONS(289),
    [anon_sym_u2240] = ACTIONS(289),
    [anon_sym_BSLASHcdot] = ACTIONS(291),
    [anon_sym_u22c5] = ACTIONS(291),
    [sym_pow] = ACTIONS(167),
    [sym_powpow] = ACTIONS(241),
    [anon_sym_CARET_PLUS] = ACTIONS(293),
    [anon_sym_u207a] = ACTIONS(293),
    [sym_asterisk] = ACTIONS(295),
    [sym_sup_hash] = ACTIONS(295),
    [sym_prime] = ACTIONS(295),
    [anon_sym_ONLY] = ACTIONS(666),
    [anon_sym_DEF] = ACTIONS(668),
    [anon_sym_DEFS] = ACTIONS(668),
    [sym__indent] = ACTIONS(670),
    [sym__double_excl] = ACTIONS(277),
  },
  [21] = {
    [sym_block_comment] = STATE(21),
    [sym_forall] = STATE(3984),
    [sym_exists] = STATE(3984),
    [sym_langle_bracket] = STATE(76),
    [sym_subexpr_prefix] = STATE(1092),
    [sym_subexpr_component] = STATE(5469),
    [sym_bound_op] = STATE(2377),
    [sym_bound_nonfix_op] = STATE(2377),
    [sym__expr] = STATE(1222),
    [sym_prefixed_op] = STATE(2405),
    [sym__number] = STATE(2405),
    [sym_nat_number] = STATE(2399),
    [sym_binary_number] = STATE(2399),
    [sym_octal_number] = STATE(2399),
    [sym_hex_number] = STATE(2399),
    [sym_string] = STATE(2405),
    [sym_boolean] = STATE(2405),
    [sym__number_set] = STATE(2404),
    [sym__primitive_value_set] = STATE(2405),
    [sym_nat_number_set] = STATE(2490),
    [sym_int_number_set] = STATE(2490),
    [sym_real_number_set] = STATE(2490),
    [sym_label] = STATE(2405),
    [sym_subexpression] = STATE(2405),
    [sym_parentheses] = STATE(2405),
    [sym_bounded_quantification] = STATE(2405),
    [sym_unbounded_quantification] = STATE(2405),
    [sym_choose] = STATE(2405),
    [sym_finite_set_literal] = STATE(2405),
    [sym_set_filter] = STATE(2405),
    [sym_set_map] = STATE(2405),
    [sym_function_evaluation] = STATE(2405),
    [sym_function_literal] = STATE(2405),
    [sym_set_of_functions] = STATE(2405),
    [sym_record_literal] = STATE(2405),
    [sym_set_of_records] = STATE(2405),
    [sym_record_value] = STATE(2405),
    [sym_except] = STATE(2405),
    [sym_prev_func_val] = STATE(2405),
    [sym_tuple_literal] = STATE(2405),
    [sym_step_expr_or_stutter] = STATE(2405),
    [sym_step_expr_no_stutter] = STATE(2405),
    [sym_fairness] = STATE(2405),
    [sym_if_then_else] = STATE(2405),
    [sym_case] = STATE(2405),
    [sym_let_in] = STATE(2405),
    [sym_conj_list] = STATE(2405),
    [sym_disj_list] = STATE(2405),
    [sym_lnot] = STATE(264),
    [sym_negative] = STATE(517),
    [sym_always] = STATE(263),
    [sym_eventually] = STATE(263),
    [sym_prefix_op_symbol] = STATE(4965),
    [sym_bound_prefix_op] = STATE(2405),
    [sym_implies] = STATE(3441),
    [sym_plus_arrow] = STATE(3441),
    [sym_equiv] = STATE(3441),
    [sym_iff] = STATE(3441),
    [sym_leads_to] = STATE(3441),
    [sym_land] = STATE(3441),
    [sym_lor] = STATE(3441),
    [sym_assign] = STATE(3441),
    [sym_bnf_rule] = STATE(3441),
    [sym_eq] = STATE(3441),
    [sym_neq] = STATE(3441),
    [sym_lt] = STATE(3441),
    [sym_leq] = STATE(3441),
    [sym_geq] = STATE(3441),
    [sym_approx] = STATE(3441),
    [sym_rs_ttile] = STATE(3441),
    [sym_rd_ttile] = STATE(3441),
    [sym_ls_ttile] = STATE(3441),
    [sym_ld_ttile] = STATE(3441),
    [sym_asymp] = STATE(3441),
    [sym_cong] = STATE(3441),
    [sym_doteq] = STATE(3441),
    [sym_gg] = STATE(3441),
    [sym_ll] = STATE(3441),
    [sym_in] = STATE(3441),
    [sym_notin] = STATE(3441),
    [sym_prec] = STATE(3441),
    [sym_succ] = STATE(3441),
    [sym_preceq] = STATE(3441),
    [sym_succeq] = STATE(3441),
    [sym_propto] = STATE(3441),
    [sym_sim] = STATE(3441),
    [sym_simeq] = STATE(3441),
    [sym_sqsubset] = STATE(3441),
    [sym_sqsupset] = STATE(3441),
    [sym_sqsubseteq] = STATE(3441),
    [sym_sqsupseteq] = STATE(3441),
    [sym_subset] = STATE(3441),
    [sym_supset] = STATE(3441),
    [sym_subseteq] = STATE(3441),
    [sym_supseteq] = STATE(3441),
    [sym_cap] = STATE(3441),
    [sym_cup] = STATE(3441),
    [sym_dots_2] = STATE(3441),
    [sym_dots_3] = STATE(3441),
    [sym_plus] = STATE(3441),
    [sym_oplus] = STATE(3441),
    [sym_ominus] = STATE(3441),
    [sym_vertvert] = STATE(3441),
    [sym_minus] = STATE(3441),
    [sym_odot] = STATE(3441),
    [sym_oslash] = STATE(3441),
    [sym_otimes] = STATE(3441),
    [sym_bigcirc] = STATE(3441),
    [sym_bullet] = STATE(3441),
    [sym_div] = STATE(3441),
    [sym_circ] = STATE(3441),
    [sym_star] = STATE(3441),
    [sym_excl] = STATE(3441),
    [sym_qq] = STATE(3441),
    [sym_sqcap] = STATE(3441),
    [sym_sqcup] = STATE(3441),
    [sym_uplus] = STATE(3441),
    [sym_times] = STATE(3441),
    [sym_wr] = STATE(3441),
    [sym_cdot] = STATE(3441),
    [sym_infix_op_symbol] = STATE(5053),
    [sym_bound_infix_op] = STATE(2405),
    [sym_sup_plus] = STATE(3426),
    [sym_postfix_op_symbol] = STATE(4965),
    [sym_bound_postfix_op] = STATE(2405),
    [sym_use_body] = STATE(3590),
    [sym_use_body_expr] = STATE(3533),
    [sym_use_body_def] = STATE(3587),
    [sym_module_ref] = STATE(3507),
    [sym_proof_step_ref] = STATE(2378),
    [sym_identifier] = ACTIONS(552),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(554),
    [anon_sym_BSLASHin] = ACTIONS(59),
    [anon_sym_u2208] = ACTIONS(61),
    [anon_sym_BSLASHA] = ACTIONS(63),
    [anon_sym_BSLASHforall] = ACTIONS(65),
    [anon_sym_u2200] = ACTIONS(65),
    [anon_sym_BSLASHE] = ACTIONS(67),
    [anon_sym_BSLASHexists] = ACTIONS(69),
    [anon_sym_u2203] = ACTIONS(69),
    [sym_temporal_forall] = ACTIONS(326),
    [sym_temporal_exists] = ACTIONS(326),
    [anon_sym_LT_LT] = ACTIONS(73),
    [anon_sym_u3008] = ACTIONS(73),
    [anon_sym_u27e8] = ACTIONS(73),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(75),
    [anon_sym_u25a1] = ACTIONS(75),
    [anon_sym_AT] = ACTIONS(331),
    [anon_sym_SLASH_BSLASH] = ACTIONS(79),
    [anon_sym_u2227] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(81),
    [anon_sym_u2228] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(338),
    [aux_sym_child_id_token1] = ACTIONS(340),
    [sym_real_number] = ACTIONS(342),
    [anon_sym_BSLASHb] = ACTIONS(344),
    [anon_sym_BSLASHB] = ACTIONS(346),
    [anon_sym_BSLASHo] = ACTIONS(348),
    [anon_sym_BSLASHO] = ACTIONS(350),
    [anon_sym_BSLASHh] = ACTIONS(352),
    [anon_sym_BSLASHH] = ACTIONS(352),
    [anon_sym_DQUOTE] = ACTIONS(354),
    [anon_sym_TRUE] = ACTIONS(356),
    [anon_sym_FALSE] = ACTIONS(356),
    [sym_string_set] = ACTIONS(358),
    [sym_boolean_set] = ACTIONS(358),
    [anon_sym_Nat] = ACTIONS(558),
    [anon_sym_u2115] = ACTIONS(560),
    [anon_sym_Int] = ACTIONS(562),
    [anon_sym_u2124] = ACTIONS(564),
    [anon_sym_Real] = ACTIONS(566),
    [anon_sym_u211d] = ACTIONS(568),
    [anon_sym_CHOOSE] = ACTIONS(378),
    [anon_sym_LBRACE] = ACTIONS(380),
    [anon_sym_EQ] = ACTIONS(125),
    [anon_sym_WF_] = ACTIONS(382),
    [anon_sym_SF_] = ACTIONS(382),
    [anon_sym_IF] = ACTIONS(384),
    [anon_sym_CASE] = ACTIONS(386),
    [anon_sym_LET] = ACTIONS(388),
    [anon_sym_BSLASHlnot] = ACTIONS(135),
    [anon_sym_BSLASHneg] = ACTIONS(135),
    [anon_sym_TILDE] = ACTIONS(137),
    [anon_sym_u00ac] = ACTIONS(135),
    [sym_union] = ACTIONS(570),
    [sym_powerset] = ACTIONS(570),
    [sym_domain] = ACTIONS(570),
    [anon_sym_DASH] = ACTIONS(141),
    [sym_negative_dot] = ACTIONS(41),
    [sym_enabled] = ACTIONS(572),
    [sym_unchanged] = ACTIONS(572),
    [anon_sym_LT_GT] = ACTIONS(145),
    [anon_sym_u22c4] = ACTIONS(145),
    [anon_sym_u25c7] = ACTIONS(145),
    [anon_sym_EQ_GT] = ACTIONS(147),
    [anon_sym_u27f9] = ACTIONS(147),
    [anon_sym_u21d2] = ACTIONS(147),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(149),
    [anon_sym_u21f8] = ACTIONS(149),
    [anon_sym_u2945] = ACTIONS(149),
    [anon_sym_BSLASHequiv] = ACTIONS(151),
    [anon_sym_u2261] = ACTIONS(151),
    [anon_sym_LT_EQ_GT] = ACTIONS(153),
    [anon_sym_u27fa] = ACTIONS(153),
    [anon_sym_u21d4] = ACTIONS(153),
    [anon_sym_TILDE_GT] = ACTIONS(155),
    [anon_sym_u21dd] = ACTIONS(155),
    [anon_sym_u219d] = ACTIONS(155),
    [anon_sym_BSLASHland] = ACTIONS(79),
    [anon_sym_BSLASHlor] = ACTIONS(81),
    [anon_sym_COLON_EQ] = ACTIONS(157),
    [anon_sym_u2254] = ACTIONS(157),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(159),
    [anon_sym_u2a74] = ACTIONS(159),
    [anon_sym_SLASH_EQ] = ACTIONS(161),
    [anon_sym_POUND] = ACTIONS(163),
    [anon_sym_u2260] = ACTIONS(161),
    [anon_sym_LT] = ACTIONS(408),
    [sym_gt] = ACTIONS(167),
    [anon_sym_LT_EQ] = ACTIONS(169),
    [anon_sym_EQ_LT] = ACTIONS(171),
    [anon_sym_BSLASHleq] = ACTIONS(171),
    [anon_sym_u2264] = ACTIONS(171),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_BSLASHgeq] = ACTIONS(173),
    [anon_sym_u2265] = ACTIONS(173),
    [anon_sym_BSLASHapprox] = ACTIONS(175),
    [anon_sym_u2248] = ACTIONS(175),
    [anon_sym_PIPE_DASH] = ACTIONS(177),
    [anon_sym_u22a2] = ACTIONS(177),
    [anon_sym_PIPE_EQ] = ACTIONS(179),
    [anon_sym_u22a8] = ACTIONS(179),
    [anon_sym_DASH_PIPE] = ACTIONS(181),
    [anon_sym_u22a3] = ACTIONS(181),
    [anon_sym_EQ_PIPE] = ACTIONS(183),
    [anon_sym_u2ae4] = ACTIONS(183),
    [anon_sym_BSLASHasymp] = ACTIONS(185),
    [anon_sym_u224d] = ACTIONS(185),
    [anon_sym_BSLASHcong] = ACTIONS(187),
    [anon_sym_u2245] = ACTIONS(187),
    [anon_sym_BSLASHdoteq] = ACTIONS(189),
    [anon_sym_u2250] = ACTIONS(189),
    [anon_sym_BSLASHgg] = ACTIONS(191),
    [anon_sym_u226b] = ACTIONS(191),
    [anon_sym_BSLASHll] = ACTIONS(193),
    [anon_sym_u226a] = ACTIONS(193),
    [anon_sym_BSLASHnotin] = ACTIONS(195),
    [anon_sym_u2209] = ACTIONS(195),
    [anon_sym_BSLASHprec] = ACTIONS(197),
    [anon_sym_u227a] = ACTIONS(199),
    [anon_sym_BSLASHsucc] = ACTIONS(201),
    [anon_sym_u227b] = ACTIONS(203),
    [anon_sym_BSLASHpreceq] = ACTIONS(205),
    [anon_sym_u2aaf] = ACTIONS(205),
    [anon_sym_BSLASHsucceq] = ACTIONS(207),
    [anon_sym_u2ab0] = ACTIONS(207),
    [anon_sym_BSLASHpropto] = ACTIONS(209),
    [anon_sym_u221d] = ACTIONS(209),
    [anon_sym_BSLASHsim] = ACTIONS(211),
    [anon_sym_u223c] = ACTIONS(213),
    [anon_sym_BSLASHsimeq] = ACTIONS(215),
    [anon_sym_u2243] = ACTIONS(215),
    [anon_sym_BSLASHsqsubset] = ACTIONS(217),
    [anon_sym_u228f] = ACTIONS(219),
    [anon_sym_BSLASHsqsupset] = ACTIONS(221),
    [anon_sym_u2290] = ACTIONS(223),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(225),
    [anon_sym_u2291] = ACTIONS(225),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(227),
    [anon_sym_u2292] = ACTIONS(227),
    [anon_sym_BSLASHsubset] = ACTIONS(229),
    [anon_sym_u2282] = ACTIONS(231),
    [anon_sym_BSLASHsupset] = ACTIONS(233),
    [anon_sym_u2283] = ACTIONS(235),
    [anon_sym_BSLASHsubseteq] = ACTIONS(237),
    [anon_sym_u2286] = ACTIONS(237),
    [anon_sym_BSLASHsupseteq] = ACTIONS(239),
    [anon_sym_u2287] = ACTIONS(239),
    [sym_compose] = ACTIONS(241),
    [sym_map_to] = ACTIONS(241),
    [sym_map_from] = ACTIONS(241),
    [sym_setminus] = ACTIONS(167),
    [anon_sym_BSLASHcap] = ACTIONS(243),
    [anon_sym_BSLASHintersect] = ACTIONS(243),
    [anon_sym_u2229] = ACTIONS(243),
    [anon_sym_BSLASHcup] = ACTIONS(245),
    [anon_sym_BSLASHunion] = ACTIONS(245),
    [anon_sym_u222a] = ACTIONS(245),
    [anon_sym_DOT_DOT] = ACTIONS(247),
    [anon_sym_u2025] = ACTIONS(249),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(251),
    [anon_sym_u2026] = ACTIONS(251),
    [anon_sym_PLUS] = ACTIONS(253),
    [sym_plusplus] = ACTIONS(241),
    [anon_sym_BSLASHoplus] = ACTIONS(255),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(255),
    [anon_sym_u2295] = ACTIONS(255),
    [anon_sym_BSLASHominus] = ACTIONS(257),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(257),
    [anon_sym_u2296] = ACTIONS(257),
    [sym_mod] = ACTIONS(167),
    [sym_modmod] = ACTIONS(241),
    [sym_vert] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_u2016] = ACTIONS(259),
    [sym_minusminus] = ACTIONS(241),
    [sym_amp] = ACTIONS(167),
    [sym_ampamp] = ACTIONS(241),
    [anon_sym_BSLASHodot] = ACTIONS(261),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(261),
    [anon_sym_u2299] = ACTIONS(261),
    [anon_sym_BSLASHoslash] = ACTIONS(263),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(263),
    [anon_sym_u2298] = ACTIONS(263),
    [anon_sym_BSLASHotimes] = ACTIONS(265),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(265),
    [anon_sym_u2297] = ACTIONS(265),
    [sym_mul] = ACTIONS(167),
    [sym_mulmul] = ACTIONS(241),
    [sym_slash] = ACTIONS(167),
    [sym_slashslash] = ACTIONS(241),
    [anon_sym_BSLASHbigcirc] = ACTIONS(267),
    [anon_sym_u25ef] = ACTIONS(267),
    [anon_sym_BSLASHbullet] = ACTIONS(269),
    [anon_sym_u25cf] = ACTIONS(269),
    [anon_sym_BSLASHdiv] = ACTIONS(271),
    [anon_sym_u00f7] = ACTIONS(271),
    [anon_sym_BSLASHcirc] = ACTIONS(273),
    [anon_sym_u2218] = ACTIONS(273),
    [anon_sym_BSLASHstar] = ACTIONS(275),
    [anon_sym_u22c6] = ACTIONS(275),
    [anon_sym_u203c] = ACTIONS(277),
    [sym_hashhash] = ACTIONS(241),
    [sym_dol] = ACTIONS(167),
    [sym_doldol] = ACTIONS(241),
    [anon_sym_QMARK_QMARK] = ACTIONS(279),
    [anon_sym_u2047] = ACTIONS(279),
    [anon_sym_BSLASHsqcap] = ACTIONS(281),
    [anon_sym_u2293] = ACTIONS(281),
    [anon_sym_BSLASHsqcup] = ACTIONS(283),
    [anon_sym_u2294] = ACTIONS(283),
    [anon_sym_BSLASHuplus] = ACTIONS(285),
    [anon_sym_u228e] = ACTIONS(285),
    [anon_sym_BSLASHX] = ACTIONS(287),
    [anon_sym_BSLASHtimes] = ACTIONS(287),
    [anon_sym_u00d7] = ACTIONS(287),
    [anon_sym_BSLASHwr] = ACTIONS(289),
    [anon_sym_u2240] = ACTIONS(289),
    [anon_sym_BSLASHcdot] = ACTIONS(291),
    [anon_sym_u22c5] = ACTIONS(291),
    [sym_pow] = ACTIONS(167),
    [sym_powpow] = ACTIONS(241),
    [anon_sym_CARET_PLUS] = ACTIONS(293),
    [anon_sym_u207a] = ACTIONS(293),
    [sym_asterisk] = ACTIONS(295),
    [sym_sup_hash] = ACTIONS(295),
    [sym_prime] = ACTIONS(295),
    [anon_sym_ONLY] = ACTIONS(672),
    [anon_sym_DEF] = ACTIONS(576),
    [anon_sym_DEFS] = ACTIONS(576),
    [sym__indent] = ACTIONS(410),
    [sym__double_excl] = ACTIONS(277),
  },
  [22] = {
    [sym_block_comment] = STATE(22),
    [sym_forall] = STATE(4013),
    [sym_exists] = STATE(4013),
    [sym_langle_bracket] = STATE(80),
    [sym_subexpr_prefix] = STATE(1094),
    [sym_subexpr_component] = STATE(5469),
    [sym_bound_op] = STATE(3105),
    [sym_bound_nonfix_op] = STATE(3105),
    [sym__expr] = STATE(1753),
    [sym_prefixed_op] = STATE(3194),
    [sym__number] = STATE(3194),
    [sym_nat_number] = STATE(3313),
    [sym_binary_number] = STATE(3313),
    [sym_octal_number] = STATE(3313),
    [sym_hex_number] = STATE(3313),
    [sym_string] = STATE(3194),
    [sym_boolean] = STATE(3194),
    [sym__number_set] = STATE(3336),
    [sym__primitive_value_set] = STATE(3194),
    [sym_nat_number_set] = STATE(3303),
    [sym_int_number_set] = STATE(3303),
    [sym_real_number_set] = STATE(3303),
    [sym_label] = STATE(3194),
    [sym_subexpression] = STATE(3194),
    [sym_parentheses] = STATE(3194),
    [sym_bounded_quantification] = STATE(3194),
    [sym_unbounded_quantification] = STATE(3194),
    [sym_choose] = STATE(3194),
    [sym_finite_set_literal] = STATE(3194),
    [sym_set_filter] = STATE(3194),
    [sym_set_map] = STATE(3194),
    [sym_function_evaluation] = STATE(3194),
    [sym_function_literal] = STATE(3194),
    [sym_set_of_functions] = STATE(3194),
    [sym_record_literal] = STATE(3194),
    [sym_set_of_records] = STATE(3194),
    [sym_record_value] = STATE(3194),
    [sym_except] = STATE(3194),
    [sym_prev_func_val] = STATE(3194),
    [sym_tuple_literal] = STATE(3194),
    [sym_step_expr_or_stutter] = STATE(3194),
    [sym_step_expr_no_stutter] = STATE(3194),
    [sym_fairness] = STATE(3194),
    [sym_if_then_else] = STATE(3194),
    [sym_case] = STATE(3194),
    [sym_let_in] = STATE(3194),
    [sym_conj_list] = STATE(3194),
    [sym_disj_list] = STATE(3194),
    [sym_lnot] = STATE(280),
    [sym_negative] = STATE(630),
    [sym_always] = STATE(279),
    [sym_eventually] = STATE(279),
    [sym_prefix_op_symbol] = STATE(4989),
    [sym_bound_prefix_op] = STATE(3194),
    [sym_implies] = STATE(3441),
    [sym_plus_arrow] = STATE(3441),
    [sym_equiv] = STATE(3441),
    [sym_iff] = STATE(3441),
    [sym_leads_to] = STATE(3441),
    [sym_land] = STATE(3441),
    [sym_lor] = STATE(3441),
    [sym_assign] = STATE(3441),
    [sym_bnf_rule] = STATE(3441),
    [sym_eq] = STATE(3441),
    [sym_neq] = STATE(3441),
    [sym_lt] = STATE(3441),
    [sym_leq] = STATE(3441),
    [sym_geq] = STATE(3441),
    [sym_approx] = STATE(3441),
    [sym_rs_ttile] = STATE(3441),
    [sym_rd_ttile] = STATE(3441),
    [sym_ls_ttile] = STATE(3441),
    [sym_ld_ttile] = STATE(3441),
    [sym_asymp] = STATE(3441),
    [sym_cong] = STATE(3441),
    [sym_doteq] = STATE(3441),
    [sym_gg] = STATE(3441),
    [sym_ll] = STATE(3441),
    [sym_in] = STATE(3441),
    [sym_notin] = STATE(3441),
    [sym_prec] = STATE(3441),
    [sym_succ] = STATE(3441),
    [sym_preceq] = STATE(3441),
    [sym_succeq] = STATE(3441),
    [sym_propto] = STATE(3441),
    [sym_sim] = STATE(3441),
    [sym_simeq] = STATE(3441),
    [sym_sqsubset] = STATE(3441),
    [sym_sqsupset] = STATE(3441),
    [sym_sqsubseteq] = STATE(3441),
    [sym_sqsupseteq] = STATE(3441),
    [sym_subset] = STATE(3441),
    [sym_supset] = STATE(3441),
    [sym_subseteq] = STATE(3441),
    [sym_supseteq] = STATE(3441),
    [sym_cap] = STATE(3441),
    [sym_cup] = STATE(3441),
    [sym_dots_2] = STATE(3441),
    [sym_dots_3] = STATE(3441),
    [sym_plus] = STATE(3441),
    [sym_oplus] = STATE(3441),
    [sym_ominus] = STATE(3441),
    [sym_vertvert] = STATE(3441),
    [sym_minus] = STATE(3441),
    [sym_odot] = STATE(3441),
    [sym_oslash] = STATE(3441),
    [sym_otimes] = STATE(3441),
    [sym_bigcirc] = STATE(3441),
    [sym_bullet] = STATE(3441),
    [sym_div] = STATE(3441),
    [sym_circ] = STATE(3441),
    [sym_star] = STATE(3441),
    [sym_excl] = STATE(3441),
    [sym_qq] = STATE(3441),
    [sym_sqcap] = STATE(3441),
    [sym_sqcup] = STATE(3441),
    [sym_uplus] = STATE(3441),
    [sym_times] = STATE(3441),
    [sym_wr] = STATE(3441),
    [sym_cdot] = STATE(3441),
    [sym_infix_op_symbol] = STATE(5057),
    [sym_bound_infix_op] = STATE(3194),
    [sym_sup_plus] = STATE(3426),
    [sym_postfix_op_symbol] = STATE(4989),
    [sym_bound_postfix_op] = STATE(3194),
    [sym_use_body] = STATE(5445),
    [sym_use_body_expr] = STATE(4374),
    [sym_use_body_def] = STATE(5535),
    [sym_module_ref] = STATE(4195),
    [sym_proof_step_ref] = STATE(3091),
    [sym_identifier] = ACTIONS(604),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(606),
    [anon_sym_BSLASHin] = ACTIONS(59),
    [anon_sym_u2208] = ACTIONS(61),
    [anon_sym_BSLASHA] = ACTIONS(63),
    [anon_sym_BSLASHforall] = ACTIONS(65),
    [anon_sym_u2200] = ACTIONS(65),
    [anon_sym_BSLASHE] = ACTIONS(67),
    [anon_sym_BSLASHexists] = ACTIONS(69),
    [anon_sym_u2203] = ACTIONS(69),
    [sym_temporal_forall] = ACTIONS(608),
    [sym_temporal_exists] = ACTIONS(608),
    [anon_sym_LT_LT] = ACTIONS(73),
    [anon_sym_u3008] = ACTIONS(73),
    [anon_sym_u27e8] = ACTIONS(73),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(75),
    [anon_sym_u25a1] = ACTIONS(75),
    [anon_sym_AT] = ACTIONS(610),
    [anon_sym_SLASH_BSLASH] = ACTIONS(79),
    [anon_sym_u2227] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(81),
    [anon_sym_u2228] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(612),
    [anon_sym_LBRACK] = ACTIONS(614),
    [aux_sym_child_id_token1] = ACTIONS(616),
    [sym_real_number] = ACTIONS(618),
    [anon_sym_BSLASHb] = ACTIONS(620),
    [anon_sym_BSLASHB] = ACTIONS(622),
    [anon_sym_BSLASHo] = ACTIONS(624),
    [anon_sym_BSLASHO] = ACTIONS(626),
    [anon_sym_BSLASHh] = ACTIONS(628),
    [anon_sym_BSLASHH] = ACTIONS(628),
    [anon_sym_DQUOTE] = ACTIONS(630),
    [anon_sym_TRUE] = ACTIONS(632),
    [anon_sym_FALSE] = ACTIONS(632),
    [sym_string_set] = ACTIONS(634),
    [sym_boolean_set] = ACTIONS(634),
    [anon_sym_Nat] = ACTIONS(636),
    [anon_sym_u2115] = ACTIONS(638),
    [anon_sym_Int] = ACTIONS(640),
    [anon_sym_u2124] = ACTIONS(642),
    [anon_sym_Real] = ACTIONS(644),
    [anon_sym_u211d] = ACTIONS(646),
    [anon_sym_CHOOSE] = ACTIONS(648),
    [anon_sym_LBRACE] = ACTIONS(650),
    [anon_sym_EQ] = ACTIONS(125),
    [anon_sym_WF_] = ACTIONS(652),
    [anon_sym_SF_] = ACTIONS(652),
    [anon_sym_IF] = ACTIONS(654),
    [anon_sym_CASE] = ACTIONS(656),
    [anon_sym_LET] = ACTIONS(658),
    [anon_sym_BSLASHlnot] = ACTIONS(135),
    [anon_sym_BSLASHneg] = ACTIONS(135),
    [anon_sym_TILDE] = ACTIONS(137),
    [anon_sym_u00ac] = ACTIONS(135),
    [sym_union] = ACTIONS(660),
    [sym_powerset] = ACTIONS(660),
    [sym_domain] = ACTIONS(660),
    [anon_sym_DASH] = ACTIONS(141),
    [sym_negative_dot] = ACTIONS(41),
    [sym_enabled] = ACTIONS(662),
    [sym_unchanged] = ACTIONS(662),
    [anon_sym_LT_GT] = ACTIONS(145),
    [anon_sym_u22c4] = ACTIONS(145),
    [anon_sym_u25c7] = ACTIONS(145),
    [anon_sym_EQ_GT] = ACTIONS(147),
    [anon_sym_u27f9] = ACTIONS(147),
    [anon_sym_u21d2] = ACTIONS(147),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(149),
    [anon_sym_u21f8] = ACTIONS(149),
    [anon_sym_u2945] = ACTIONS(149),
    [anon_sym_BSLASHequiv] = ACTIONS(151),
    [anon_sym_u2261] = ACTIONS(151),
    [anon_sym_LT_EQ_GT] = ACTIONS(153),
    [anon_sym_u27fa] = ACTIONS(153),
    [anon_sym_u21d4] = ACTIONS(153),
    [anon_sym_TILDE_GT] = ACTIONS(155),
    [anon_sym_u21dd] = ACTIONS(155),
    [anon_sym_u219d] = ACTIONS(155),
    [anon_sym_BSLASHland] = ACTIONS(79),
    [anon_sym_BSLASHlor] = ACTIONS(81),
    [anon_sym_COLON_EQ] = ACTIONS(157),
    [anon_sym_u2254] = ACTIONS(157),
    [anon_sym_COLON_COLON_EQ] = ACTIONS(159),
    [anon_sym_u2a74] = ACTIONS(159),
    [anon_sym_SLASH_EQ] = ACTIONS(161),
    [anon_sym_POUND] = ACTIONS(163),
    [anon_sym_u2260] = ACTIONS(161),
    [anon_sym_LT] = ACTIONS(664),
    [sym_gt] = ACTIONS(167),
    [anon_sym_LT_EQ] = ACTIONS(169),
    [anon_sym_EQ_LT] = ACTIONS(171),
    [anon_sym_BSLASHleq] = ACTIONS(171),
    [anon_sym_u2264] = ACTIONS(171),
    [anon_sym_GT_EQ] = ACTIONS(173),
    [anon_sym_BSLASHgeq] = ACTIONS(173),
    [anon_sym_u2265] = ACTIONS(173),
    [anon_sym_BSLASHapprox] = ACTIONS(175),
    [anon_sym_u2248] = ACTIONS(175),
    [anon_sym_PIPE_DASH] = ACTIONS(177),
    [anon_sym_u22a2] = ACTIONS(177),
    [anon_sym_PIPE_EQ] = ACTIONS(179),
    [anon_sym_u22a8] = ACTIONS(179),
    [anon_sym_DASH_PIPE] = ACTIONS(181),
    [anon_sym_u22a3] = ACTIONS(181),
    [anon_sym_EQ_PIPE] = ACTIONS(183),
    [anon_sym_u2ae4] = ACTIONS(183),
    [anon_sym_BSLASHasymp] = ACTIONS(185),
    [anon_sym_u224d] = ACTIONS(185),
    [anon_sym_BSLASHcong] = ACTIONS(187),
    [anon_sym_u2245] = ACTIONS(187),
    [anon_sym_BSLASHdoteq] = ACTIONS(189),
    [anon_sym_u2250] = ACTIONS(189),
    [anon_sym_BSLASHgg] = ACTIONS(191),
    [anon_sym_u226b] = ACTIONS(191),
    [anon_sym_BSLASHll] = ACTIONS(193),
    [anon_sym_u226a] = ACTIONS(193),
    [anon_sym_BSLASHnotin] = ACTIONS(195),
    [anon_sym_u2209] = ACTIONS(195),
    [anon_sym_BSLASHprec] = ACTIONS(197),
    [anon_sym_u227a] = ACTIONS(199),
    [anon_sym_BSLASHsucc] = ACTIONS(201),
    [anon_sym_u227b] = ACTIONS(203),
    [anon_sym_BSLASHpreceq] = ACTIONS(205),
    [anon_sym_u2aaf] = ACTIONS(205),
    [anon_sym_BSLASHsucceq] = ACTIONS(207),
    [anon_sym_u2ab0] = ACTIONS(207),
    [anon_sym_BSLASHpropto] = ACTIONS(209),
    [anon_sym_u221d] = ACTIONS(209),
    [anon_sym_BSLASHsim] = ACTIONS(211),
    [anon_sym_u223c] = ACTIONS(213),
    [anon_sym_BSLASHsimeq] = ACTIONS(215),
    [anon_sym_u2243] = ACTIONS(215),
    [anon_sym_BSLASHsqsubset] = ACTIONS(217),
    [anon_sym_u228f] = ACTIONS(219),
    [anon_sym_BSLASHsqsupset] = ACTIONS(221),
    [anon_sym_u2290] = ACTIONS(223),
    [anon_sym_BSLASHsqsubseteq] = ACTIONS(225),
    [anon_sym_u2291] = ACTIONS(225),
    [anon_sym_BSLASHsqsupseteq] = ACTIONS(227),
    [anon_sym_u2292] = ACTIONS(227),
    [anon_sym_BSLASHsubset] = ACTIONS(229),
    [anon_sym_u2282] = ACTIONS(231),
    [anon_sym_BSLASHsupset] = ACTIONS(233),
    [anon_sym_u2283] = ACTIONS(235),
    [anon_sym_BSLASHsubseteq] = ACTIONS(237),
    [anon_sym_u2286] = ACTIONS(237),
    [anon_sym_BSLASHsupseteq] = ACTIONS(239),
    [anon_sym_u2287] = ACTIONS(239),
    [sym_compose] = ACTIONS(241),
    [sym_map_to] = ACTIONS(241),
    [sym_map_from] = ACTIONS(241),
    [sym_setminus] = ACTIONS(167),
    [anon_sym_BSLASHcap] = ACTIONS(243),
    [anon_sym_BSLASHintersect] = ACTIONS(243),
    [anon_sym_u2229] = ACTIONS(243),
    [anon_sym_BSLASHcup] = ACTIONS(245),
    [anon_sym_BSLASHunion] = ACTIONS(245),
    [anon_sym_u222a] = ACTIONS(245),
    [anon_sym_DOT_DOT] = ACTIONS(247),
    [anon_sym_u2025] = ACTIONS(249),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(251),
    [anon_sym_u2026] = ACTIONS(251),
    [anon_sym_PLUS] = ACTIONS(253),
    [sym_plusplus] = ACTIONS(241),
    [anon_sym_BSLASHoplus] = ACTIONS(255),
    [anon_sym_LPAREN_PLUS_RPAREN] = ACTIONS(255),
    [anon_sym_u2295] = ACTIONS(255),
    [anon_sym_BSLASHominus] = ACTIONS(257),
    [anon_sym_LPAREN_DASH_RPAREN] = ACTIONS(257),
    [anon_sym_u2296] = ACTIONS(257),
    [sym_mod] = ACTIONS(167),
    [sym_modmod] = ACTIONS(241),
    [sym_vert] = ACTIONS(167),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_u2016] = ACTIONS(259),
    [sym_minusminus] = ACTIONS(241),
    [sym_amp] = ACTIONS(167),
    [sym_ampamp] = ACTIONS(241),
    [anon_sym_BSLASHodot] = ACTIONS(261),
    [anon_sym_LPAREN_DOT_RPAREN] = ACTIONS(261),
    [anon_sym_u2299] = ACTIONS(261),
    [anon_sym_BSLASHoslash] = ACTIONS(263),
    [anon_sym_LPAREN_SLASH_RPAREN] = ACTIONS(263),
    [anon_sym_u2298] = ACTIONS(263),
    [anon_sym_BSLASHotimes] = ACTIONS(265),
    [anon_sym_LPAREN_BSLASHX_RPAREN] = ACTIONS(265),
    [anon_sym_u2297] = ACTIONS(265),
    [sym_mul] = ACTIONS(167),
    [sym_mulmul] = ACTIONS(241),
    [sym_slash] = ACTIONS(167),
    [sym_slashslash] = ACTIONS(241),
    [anon_sym_BSLASHbigcirc] = ACTIONS(267),
    [anon_sym_u25ef] = ACTIONS(267),
    [anon_sym_BSLASHbullet] = ACTIONS(269),
    [anon_sym_u25cf] = ACTIONS(269),
    [anon_sym_BSLASHdiv] = ACTIONS(271),
    [anon_sym_u00f7] = ACTIONS(271),
    [anon_sym_BSLASHcirc] = ACTIONS(273),
    [anon_sym_u2218] = ACTIONS(273),
    [anon_sym_BSLASHstar] = ACTIONS(275),
    [anon_sym_u22c6] = ACTIONS(275),
    [anon_sym_u203c] = ACTIONS(277),
    [sym_hashhash] = ACTIONS(241),
    [sym_dol] = ACTIONS(167),
    [sym_doldol] = ACTIONS(241),
    [anon_sym_QMARK_QMARK] = ACTIONS(279),
    [anon_sym_u2047] = ACTIONS(279),
    [anon_sym_BSLASHsqcap] = ACTIONS(281),
    [anon_sym_u2293] = ACTIONS(281),
    [anon_sym_BSLASHsqcup] = ACTIONS(283),
    [anon_sym_u2294] = ACTIONS(283),
    [anon_sym_BSLASHuplus] = ACTIONS(285),
    [anon_sym_u228e] = ACTIONS(285),
    [anon_sym_BSLASHX] = ACTIONS(287),
    [anon_sym_BSLASHtimes] = ACTIONS(287),
    [anon_sym_u00d7] = ACTIONS(287),
    [anon_sym_BSLASHwr] = ACTIONS(289),
    [anon_sym_u2240] = ACTIONS(289),
    [anon_sym_BSLASHcdot] = ACTIONS(291),
    [anon_sym_u22c5] = ACTIONS(291),
    [sym_pow] = ACTIONS(167),
    [sym_powpow] = ACTIONS(241),
    [anon_sym_CARET_PLUS] = ACTIONS(293),
    [anon_sym_u207a] = ACTIONS(293),
    [sym_asterisk] = ACTIONS(295),
    [sym_sup_hash] = ACTIONS(295),
    [sym_prime] = ACTIONS(295),
    [anon_sym_ONLY] = ACTIONS(674),
    [anon_sym_DEF] = ACTIONS(668),
    [anon_sym_DEFS] = ACTIONS(668),
    [sym__indent] = ACTIONS(670),
    [sym__double_excl] = ACTIONS(277),
  },
  [23] = {
    [sym_block_comment] = STATE(23),
    [sym_forall] = STATE(4003),
    [sym_exists] = STATE(4003),
    [sym_langle_bracket] = STATE(54),
    [sym_subexpr_prefix] = STATE(1098),
    [sym_subexpr_component] = STATE(5469),
    [sym_bound_op] = STATE(2383),
    [sym_bound_nonfix_op] = STATE(2383),
    [sym__expr] = STATE(1223),
    [sym_prefixed_op] = STATE(2406),
    [sym__number] = STATE(2406),
    [sym_nat_number] = STATE(2459),
    [sym_binary_number] = STATE(2459),
    [sym_octal_number] = STATE(2459),
    [sym_hex_number] = STATE(2459),
    [sym_string] = STATE(2406),
    [sym_boolean] = STATE(2406),
    [sym__number_set] = STATE(2463),
    [sym__primitive_value_set] = STATE(2406),
    [sym_nat_number_set] = STATE(2400),
    [sym_int_number_set] = STATE(2400),
    [sym_real_number_set] = STATE(2400),
    [sym_label] = STATE(2406),
    [sym_subexpression] = STATE(2406),
    [sym_parentheses] = STATE(2406),
    [sym_bounded_quantification] = STATE(2406),
    [sym_unbounded_quantification] = STATE(2406),
    [sym_choose] = STATE(2406),
    [sym_finite_set_literal] = STATE(2406),
    [sym_set_filter] = STATE(2406),
    [sym_set_map] = STATE(2406),
    [sym_function_evaluation] = STATE(2406),
    [sym_function_literal] = STATE(2406),
    [sym_set_of_functions] = STATE(2406),
    [sym_record_literal] = STATE(2406),
    [sym_set_of_records] = STATE(2406),
    [sym_record_value] = STATE(2406),
    [sym_except] = STATE(2406),
    [sym_prev_func_val] = STATE(2406),
    [sym_tuple_literal] = STATE(2406),
    [sym_step_expr_or_stutter] = STATE(2406),
    [sym_step_expr_no_stutter] = STATE(2406),
    [sym_fairness] = STATE(2406),
    [sym_if_then_else] = STATE(2406),
    [sym_case] = STATE(2406),
    [sym_let_in] = STATE(2406),
    [sym_conj_list] = STATE(2406),
    [sym_disj_list] = STATE(2406),
    [sym_lnot] = STATE(292),
    [sym_negative] = STATE(807),
    [sym_always] = STATE(245),
    [sym_eventually] = STATE(245),
    [sym_prefix_op_symbol] = STATE(4944),
    [sym_bound_prefix_op] = STATE(2406),
    [sym_implies] = STATE(3441),
    [sym_plus_arrow] = STATE(3441),
    [sym_equiv] = STATE(3441),
    [sym_iff] = STATE(3441),
    [sym_leads_to] = STATE(3441),
    [sym_land] = STATE(3441),
    [sym_lor] = STATE(3441),
    [sym_assign] = STATE(3441),
    [sym_bnf_rule] = STATE(3441),
    [sym_eq] = STATE(3441),
    [sym_neq] = STATE(3441),
    [sym_lt] = STATE(3441),
    [sym_leq] = STATE(3441),
    [sym_geq] = STATE(3441),
    [sym_approx] = STATE(3441),
    [sym_rs_ttile] = STATE(3441),
    [sym_rd_ttile] = STATE(3441),
    [sym_ls_ttile] = STATE(3441),
    [sym_ld_ttile] = STATE(3441),
    [sym_asymp] = STATE(3441),
    [sym_cong] = STATE(3441),
    [sym_doteq] = STATE(3441),
    [sym_gg] = STATE(3441),
    [sym_ll] = STATE(3441),
    [sym_in] = STATE(3441),
    [sym_notin] = STATE(3441),
    [sym_prec] = STATE(3441),
    [sym_succ] = STATE(3441),
    [sym_preceq] = STATE(3441),
    [sym_succeq] = STATE(3441),
    [sym_propto] = STATE(3441),
    [sym_sim] = STATE(3441),
    [sym_simeq] = STATE(3441),
    [sym_sqsubset] = STATE(3441),
    [sym_sqsupset] = STATE(3441),
    [sym_sqsubseteq] = STATE(3441),
    [sym_sqsupseteq] = STATE(3441),
    [sym_subset] = STATE(3441),
    [sym_supset] = STATE(3441),
    [sym_subseteq] = STATE(3441),
    [sym_supseteq] = STATE(3441),
    [sym_cap] = STATE(3441),
    [sym_cup] = STATE(3441),
    [sym_dots_2] = STATE(3441),
    [sym_dots_3] = STATE(3441),
    [sym_plus] = STATE(3441),
    [sym_oplus] = STATE(3441),
    [sym_ominus] = STATE(3441),
    [sym_vertvert] = STATE(3441),
    [sym_minus] = STATE(3441),
    [sym_odot] = STATE(3441),
    [sym_oslash] = STATE(3441),
    [sym_otimes] = STATE(3441),
    [sym_bigcirc] = STATE(3441),
    [sym_bullet] = STATE(3441),
    [sym_div] = STATE(3441),
    [sym_circ] = STATE(3441),
    [sym_star] = STATE(3441),
    [sym_excl] = STATE(3441),
    [sym_qq] = STATE(3441),
    [sym_sqcap] = STATE(3441),
    [sym_sqcup] = STATE(3441),
    [sym_uplus] = STATE(3441),
    [sym_times] = STATE(3441),
    [sym_wr] = STATE(3441),
    [sym_cdot] = STATE(3441),
    [sym_infix_op_symbol] = STATE(4945),
    [sym_bound_infix_op] = STATE(2406),
    [sym_sup_plus] = STATE(3426),
    [sym_postfix_op_symbol] = STATE(4944),
    [sym_bound_postfix_op] = STATE(2406),
    [sym_use_body] = STATE(3581),
    [sym_use_body_expr] = STATE(3538),
    [sym_use_body_def] = STATE(3587),
    [sym_module_ref] = STATE(3505),
    [sym_proof_step_ref] = STATE(2384),
    [sym_identifier] = ACTIONS(578),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LPAREN_STAR] = ACTIONS(5),
    [anon_sym_MODULE] = ACTIONS(554),
    [anon_sym_BSLASHin] = ACTIONS(59),
    [anon_sym_u2208] = ACTIONS(61),
    [anon_sym_BSLASHA] = ACTIONS(63),
    [anon_sym_BSLASHforall] = ACTIONS(65),
    [anon_sym_u2200] = ACTIONS(65),
    [anon_sym_BSLASHE] = ACTIONS(67),
    [anon_sym_BSLASHexists] = ACTIONS(69),
    [anon_sym_u2203] = ACTIONS(69),
    [sym_temporal_forall] = ACTIONS(415),
    [sym_temporal_exists] = ACTIONS(415),
    [anon_sym_LT_LT] = ACTIONS(73),
    [anon_sym_u3008] = ACTIONS(73),
    [anon_sym_u27e8] = ACTIONS(73),
    [anon_sym_LBRACK_RBRACK] = ACTIONS(75),
    [anon_sym_u25a1] = ACTIONS(75),
    [anon_sym_AT] = ACTIONS(417),
    [anon_sym_SLASH_BSLASH] = ACTIONS(79),
    [anon_sym_u2227] = ACTIONS(79),
    [anon_sym_BSLASH_SLASH] = ACTIONS(81),
    [anon_sym_u2228] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(580),
    [anon_sym_LBRACK] = ACTIONS(422),
    [aux_sym_child_id_token1] = ACTIONS(424),
    [sym_real_number] = ACTIONS(426),
    [anon_sym_BSLASHb] = ACTIONS(428),
    [anon_sym_BSLASHB] = ACTIONS(430),
    [anon_sym_BSLASHo] = ACTIONS(432),
    [anon_sym_BSLASHO] = ACTIONS(434),
    [anon_sym_BSLASHh] = ACTIONS(436),
    [anon_sym_BSLASHH] = ACTIONS(436),
    [anon_sym_DQUOTE] = ACTIONS(438),
    [anon_sym_TRUE] = ACTIONS(440),
    [anon_sym_FALSE] = ACTIONS(440),
    [sym_string_set] = ACTIONS(442),
    [sym_boolean_set] = ACTIONS(442),
    [anon_sym_Nat] = ACTIONS(582),
    [anon_sym_u2115] = ACTIONS(584),
    [anon_sym_Int] = ACTIONS(586),
    [anon_sym_u2124] = ACTIONS(588),
    [anon_sym_Real] = ACTIONS(590),
    [anon_sym_u211d] = ACTIONS(592),
    [anon_sym_CHOOSE] = ACTIONS(462),
    [anon_sym_LBRACE] = ACTIONS(464),
    [anon_sym_EQ] = ACTIONS(125),
    [anon_sym_WF_] = ACTIONS(466),
    [anon_sym_SF_] = ACTIONS(466),
    [anon_sym_IF] = ACTIONS(468),
    [anon_sym_CASE] = ACTIONS(470),
    [anon_sym_LET] = ACTIONS(472),
    [anon_sym_BSLASHlnot] = ACTIONS(135),
    [anon_sym_BSLASHneg] = ACTIONS(135),
    [anon_sym_TILDE] = ACTIONS(137),
    [anon_sym_u00ac] = ACTIONS(135),
    [sym_union] = ACTIONS(594),
    [sym_powerset] = ACTIONS(594),
    [sym_domain] = ACTIONS(594),
    [anon_sym_DASH] = ACTIONS(141),
    [sym_negative_dot] = ACTIONS(41),
    [sym_enabled] = ACTIONS(596),
    [sym_unchanged] = ACTIONS(596),
    [anon_sym_LT_GT] = ACTIONS(145),
    [anon_sym_u22c4] = ACTIONS(145),
    [anon_sym_u25c7] = ACTIONS(145),
    [anon_sym_EQ_GT] = ACTIONS(147),
    [anon_sym_u27f9] = ACTIONS(147),
    [anon_sym_u21d2] = ACTIONS(147),
    [anon_sym_DASH_PLUS_DASH_GT] = ACTIONS(149),
    [anon_sym_u21f8] = ACTIONS(149),
    [anon_sym_u2945] = ACTIONS(149),
    [anon_sym_BSLASHequiv] = ACTIONS(151),
    [anon_sym_u2261] = ACTIONS(151),
    [anon_sym_LT_EQ_GT] = ACTIONS(153),
    [anon_sym_u27fa] = ACTIONS(153),
    [anon_sym_u21d4] = ACTIONS(153),
    [anon_sym_TILDE_GT] = ACTION