/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.auth.offline;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import org.jackhuang.hmcl.auth.AccountFactory;
import org.jackhuang.hmcl.auth.CharacterSelector;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorArtifactProvider;
import org.jackhuang.hmcl.auth.offline.OfflineAccount;
import org.jackhuang.hmcl.auth.offline.Skin;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.gson.UUIDTypeAdapter;

public final class OfflineAccountFactory
extends AccountFactory<OfflineAccount> {
    private final AuthlibInjectorArtifactProvider downloader;

    public OfflineAccountFactory(AuthlibInjectorArtifactProvider downloader) {
        this.downloader = downloader;
    }

    @Override
    public AccountFactory.AccountLoginType getLoginType() {
        return AccountFactory.AccountLoginType.USERNAME;
    }

    public OfflineAccount create(String username, UUID uuid) {
        return new OfflineAccount(this.downloader, username, uuid, null);
    }

    @Override
    public OfflineAccount create(CharacterSelector selector, String username, String password, AccountFactory.ProgressCallback progressCallback, Object additionalData) {
        Skin skin;
        UUID uuid;
        if (additionalData != null) {
            AdditionalData data = (AdditionalData)additionalData;
            uuid = data.uuid == null ? OfflineAccountFactory.getUUIDFromUserName(username) : data.uuid;
            skin = data.skin;
        } else {
            uuid = OfflineAccountFactory.getUUIDFromUserName(username);
            skin = null;
        }
        return new OfflineAccount(this.downloader, username, uuid, skin);
    }

    @Override
    public OfflineAccount fromStorage(Map<Object, Object> storage) {
        String username = Lang.tryCast(storage.get("username"), String.class).orElseThrow(() -> new IllegalStateException("Offline account configuration malformed."));
        UUID uuid = Lang.tryCast(storage.get("uuid"), String.class).map(UUIDTypeAdapter::fromString).orElse(OfflineAccountFactory.getUUIDFromUserName(username));
        Skin skin = Skin.fromStorage(Lang.tryCast(storage.get("skin"), Map.class).orElse(null));
        return new OfflineAccount(this.downloader, username, uuid, skin);
    }

    public static UUID getUUIDFromUserName(String username) {
        return UUID.nameUUIDFromBytes(("OfflinePlayer:" + username).getBytes(StandardCharsets.UTF_8));
    }

    public static class AdditionalData {
        private final UUID uuid;
        private final Skin skin;

        public AdditionalData(UUID uuid, Skin skin) {
            this.uuid = uuid;
            this.skin = skin;
        }
    }
}

