/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.game.GameRepository;
import org.jackhuang.hmcl.mod.LocalMod;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.ModLoaderType;
import org.jackhuang.hmcl.mod.modinfo.FabricModMetadata;
import org.jackhuang.hmcl.mod.modinfo.ForgeNewModMetadata;
import org.jackhuang.hmcl.mod.modinfo.ForgeOldModMetadata;
import org.jackhuang.hmcl.mod.modinfo.LiteModMetadata;
import org.jackhuang.hmcl.mod.modinfo.PackMcMeta;
import org.jackhuang.hmcl.mod.modinfo.QuiltModMetadata;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.versioning.VersionNumber;
import org.jetbrains.annotations.Unmodifiable;

public final class ModManager {
    private static final Map<String, List<Pair<ModMetadataReader, ModLoaderType>>> READERS;
    private final GameRepository repository;
    private final String id;
    private final TreeSet<LocalModFile> localModFiles = new TreeSet();
    private final HashMap<Pair<String, ModLoaderType>, LocalMod> localMods = new HashMap();
    private LibraryAnalyzer analyzer;
    private boolean loaded = false;
    public static final String DISABLED_EXTENSION = ".disabled";
    public static final String OLD_EXTENSION = ".old";

    public ModManager(GameRepository repository, String id) {
        this.repository = repository;
        this.id = id;
    }

    public GameRepository getRepository() {
        return this.repository;
    }

    public String getInstanceId() {
        return this.id;
    }

    public Path getModsDirectory() {
        return this.repository.getModsDirectory(this.id);
    }

    public LibraryAnalyzer getLibraryAnalyzer() {
        return this.analyzer;
    }

    public LocalMod getLocalMod(String modId, ModLoaderType modLoaderType) {
        return this.localMods.computeIfAbsent(Pair.pair(modId, modLoaderType), x -> new LocalMod((String)x.getKey(), (ModLoaderType)((Object)((Object)x.getValue()))));
    }

    public boolean hasMod(String modId, ModLoaderType modLoaderType) {
        return this.localMods.containsKey(Pair.pair(modId, modLoaderType));
    }

    private void addModInfo(Path file) {
        ArrayList<Exception> exceptions;
        LocalModFile modInfo;
        String extension;
        block20: {
            String fileName = StringUtils.removeSuffix(FileUtils.getName(file), DISABLED_EXTENSION, OLD_EXTENSION);
            extension = fileName.substring(fileName.lastIndexOf(".") + 1);
            List<Pair<ModMetadataReader, ModLoaderType>> readersMap = READERS.get(extension);
            if (readersMap == null) {
                return;
            }
            Set<ModLoaderType> modLoaderTypes = this.analyzer.getModLoaders();
            ArrayList<ModMetadataReader> supportedReaders = new ArrayList<ModMetadataReader>();
            ArrayList<ModMetadataReader> unsupportedReaders = new ArrayList<ModMetadataReader>();
            for (Pair<ModMetadataReader, ModLoaderType> reader : readersMap) {
                if (modLoaderTypes.contains((Object)reader.getValue())) {
                    supportedReaders.add(reader.getKey());
                    continue;
                }
                unsupportedReaders.add(reader.getKey());
            }
            modInfo = null;
            exceptions = new ArrayList<Exception>();
            try (FileSystem fs = CompressingUtils.createReadOnlyZipFileSystem(file);){
                for (ModMetadataReader reader : supportedReaders) {
                    try {
                        modInfo = reader.fromFile(this, file, fs);
                        break;
                    }
                    catch (Exception e) {
                        exceptions.add(e);
                    }
                }
                if (modInfo != null) break block20;
                for (ModMetadataReader reader : unsupportedReaders) {
                    try {
                        modInfo = reader.fromFile(this, file, fs);
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            catch (Exception e) {
                Logger.LOG.warning("Failed to open mod file " + String.valueOf(file), e);
            }
        }
        if (modInfo == null) {
            Exception exception = new Exception("Failed to read mod metadata");
            for (Exception e : exceptions) {
                exception.addSuppressed(e);
            }
            Logger.LOG.warning("Failed to read mod metadata", exception);
            String fileNameWithoutExtension = FileUtils.getNameWithoutExtension(file);
            modInfo = new LocalModFile(this, this.getLocalMod(fileNameWithoutExtension, ModLoaderType.UNKNOWN), file, fileNameWithoutExtension, new LocalModFile.Description("litemod".equals(extension) ? "LiteLoader Mod" : ""));
        }
        if (!modInfo.isOld()) {
            this.localModFiles.add(modInfo);
        }
    }

    public void refreshMods() throws IOException {
        this.localModFiles.clear();
        this.localMods.clear();
        this.analyzer = LibraryAnalyzer.analyze(this.getRepository().getResolvedPreservingPatchesVersion(this.id), null);
        if (Files.isDirectory(this.getModsDirectory(), new LinkOption[0])) {
            try (DirectoryStream<Path> modsDirectoryStream = Files.newDirectoryStream(this.getModsDirectory());){
                for (Path subitem : modsDirectoryStream) {
                    if (Files.isDirectory(subitem, new LinkOption[0]) && VersionNumber.isIntVersionNumber(FileUtils.getName(subitem))) {
                        DirectoryStream<Path> subitemDirectoryStream = Files.newDirectoryStream(subitem);
                        try {
                            for (Path subsubitem : subitemDirectoryStream) {
                                this.addModInfo(subsubitem);
                            }
                            continue;
                        }
                        finally {
                            if (subitemDirectoryStream != null) {
                                subitemDirectoryStream.close();
                            }
                            continue;
                        }
                    }
                    this.addModInfo(subitem);
                }
            }
        }
        this.loaded = true;
    }

    public @Unmodifiable List<LocalModFile> getMods() throws IOException {
        if (!this.loaded) {
            this.refreshMods();
        }
        return List.copyOf(this.localModFiles);
    }

    public void addMod(Path file) throws IOException {
        if (!ModManager.isFileNameMod(file)) {
            throw new IllegalArgumentException("File " + String.valueOf(file) + " is not a valid mod file.");
        }
        if (!this.loaded) {
            this.refreshMods();
        }
        Path modsDirectory = this.getModsDirectory();
        Files.createDirectories(modsDirectory, new FileAttribute[0]);
        Path newFile = modsDirectory.resolve(file.getFileName());
        FileUtils.copyFile(file, newFile);
        this.addModInfo(newFile);
    }

    public void removeMods(LocalModFile ... localModFiles) throws IOException {
        for (LocalModFile localModFile : localModFiles) {
            Files.deleteIfExists(localModFile.getFile());
        }
    }

    public void rollback(LocalModFile from, LocalModFile to) throws IOException {
        if (!this.loaded) {
            throw new IllegalStateException("ModManager Not loaded");
        }
        if (!this.localModFiles.contains(from)) {
            throw new IllegalStateException("Rolling back an unknown mod " + from.getFileName());
        }
        if (from.isOld()) {
            throw new IllegalArgumentException("Rolling back an old mod " + from.getFileName());
        }
        if (!to.isOld()) {
            throw new IllegalArgumentException("Rolling back to an old path " + to.getFileName());
        }
        if (from.getFileName().equals(to.getFileName())) {
            return;
        }
        LocalMod mod = Objects.requireNonNull(from.getMod());
        if (mod != to.getMod()) {
            throw new IllegalArgumentException("Rolling back mod " + from.getFileName() + " to a different mod " + to.getFileName());
        }
        if (!mod.getFiles().contains(from) || !mod.getOldFiles().contains(to)) {
            throw new IllegalStateException("LocalMod state corrupt");
        }
        boolean active = from.isActive();
        from.setActive(true);
        from.setOld(true);
        to.setOld(false);
        to.setActive(active);
    }

    private Path backupMod(Path file) throws IOException {
        Path newPath = file.resolveSibling(StringUtils.addSuffix(StringUtils.removeSuffix(FileUtils.getName(file), DISABLED_EXTENSION), OLD_EXTENSION));
        if (Files.exists(file, new LinkOption[0])) {
            Files.move(file, newPath, StandardCopyOption.REPLACE_EXISTING);
        }
        return newPath;
    }

    private Path restoreMod(Path file) throws IOException {
        Path newPath = file.resolveSibling(StringUtils.removeSuffix(FileUtils.getName(file), OLD_EXTENSION));
        if (Files.exists(file, new LinkOption[0])) {
            Files.move(file, newPath, StandardCopyOption.REPLACE_EXISTING);
        }
        return newPath;
    }

    public Path setOld(LocalModFile modFile, boolean old) throws IOException {
        Path newPath;
        if (old) {
            newPath = this.backupMod(modFile.getFile());
            this.localModFiles.remove(modFile);
        } else {
            newPath = this.restoreMod(modFile.getFile());
            this.localModFiles.add(modFile);
        }
        return newPath;
    }

    public Path disableMod(Path file) throws IOException {
        if (this.isOld(file)) {
            return file;
        }
        String fileName = FileUtils.getName(file);
        if (fileName.endsWith(DISABLED_EXTENSION)) {
            return file;
        }
        Path disabled = file.resolveSibling(fileName + DISABLED_EXTENSION);
        if (Files.exists(file, new LinkOption[0])) {
            Files.move(file, disabled, StandardCopyOption.REPLACE_EXISTING);
        }
        return disabled;
    }

    public Path enableMod(Path file) throws IOException {
        if (this.isOld(file)) {
            return file;
        }
        Path enabled = file.resolveSibling(StringUtils.removeSuffix(FileUtils.getName(file), DISABLED_EXTENSION));
        if (Files.exists(file, new LinkOption[0])) {
            Files.move(file, enabled, StandardCopyOption.REPLACE_EXISTING);
        }
        return enabled;
    }

    public static String getModName(Path file) {
        return StringUtils.removeSuffix(FileUtils.getName(file), DISABLED_EXTENSION, OLD_EXTENSION);
    }

    public boolean isOld(Path file) {
        return FileUtils.getName(file).endsWith(OLD_EXTENSION);
    }

    public boolean isDisabled(Path file) {
        return FileUtils.getName(file).endsWith(DISABLED_EXTENSION);
    }

    public static boolean isFileNameMod(Path file) {
        String name = ModManager.getModName(file);
        return name.endsWith(".zip") || name.endsWith(".jar") || name.endsWith(".litemod");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isFileMod(Path modFile) {
        try (FileSystem fs = CompressingUtils.createReadOnlyZipFileSystem(modFile);){
            if (Files.exists(fs.getPath("mcmod.info", new String[0]), new LinkOption[0]) || Files.exists(fs.getPath("META-INF/mods.toml", new String[0]), new LinkOption[0])) {
                boolean bl = true;
                return bl;
            }
            if (Files.exists(fs.getPath("fabric.mod.json", new String[0]), new LinkOption[0])) {
                boolean bl = true;
                return bl;
            }
            if (Files.exists(fs.getPath("quilt.mod.json", new String[0]), new LinkOption[0])) {
                boolean bl = true;
                return bl;
            }
            if (Files.exists(fs.getPath("litemod.json", new String[0]), new LinkOption[0])) {
                boolean bl = true;
                return bl;
            }
            if (Files.exists(fs.getPath("pack.mcmeta", new String[0]), new LinkOption[0])) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean hasSimpleMod(String fileName) {
        return Files.exists(this.getModsDirectory().resolve(StringUtils.removeSuffix(fileName, DISABLED_EXTENSION)), new LinkOption[0]) || Files.exists(this.getModsDirectory().resolve(StringUtils.addSuffix(fileName, DISABLED_EXTENSION)), new LinkOption[0]);
    }

    public Path getSimpleModPath(String fileName) {
        return this.getModsDirectory().resolve(fileName);
    }

    static {
        HashMap<String, List<Pair<ModMetadataReader, ModLoaderType>>> map = new HashMap<String, List<Pair<ModMetadataReader, ModLoaderType>>>();
        List<Pair<ModMetadataReader, ModLoaderType>> zipReaders = List.of(Pair.pair(ForgeNewModMetadata::fromForgeFile, ModLoaderType.FORGE), Pair.pair(ForgeNewModMetadata::fromNeoForgeFile, ModLoaderType.NEO_FORGED), Pair.pair(ForgeOldModMetadata::fromFile, ModLoaderType.FORGE), Pair.pair(FabricModMetadata::fromFile, ModLoaderType.FABRIC), Pair.pair(QuiltModMetadata::fromFile, ModLoaderType.QUILT), Pair.pair(PackMcMeta::fromFile, ModLoaderType.PACK));
        map.put("zip", zipReaders);
        map.put("jar", zipReaders);
        map.put("litemod", List.of(Pair.pair(LiteModMetadata::fromFile, ModLoaderType.LITE_LOADER)));
        READERS = map;
    }

    @FunctionalInterface
    private static interface ModMetadataReader {
        public LocalModFile fromFile(ModManager var1, Path var2, FileSystem var3) throws IOException, JsonParseException;
    }
}

