/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.text.DecimalFormat;

public enum DataSizeUnit {
    BYTES,
    KILOBYTES,
    MEGABYTES,
    GIGABYTES,
    TERABYTES;

    private static final DataSizeUnit[] VALUES;
    private static final DecimalFormat FORMAT;
    private final long bytes = 1L << this.ordinal() * 10;
    private final char abbreviationChar = this.name().charAt(0);
    private final String abbreviation = this.abbreviationChar == 'B' ? "B" : this.abbreviationChar + "iB";

    public static String format(long bytes) {
        for (int i = VALUES.length - 1; i > 0; --i) {
            DataSizeUnit unit = VALUES[i];
            if (bytes < unit.bytes) continue;
            return unit.formatBytes(bytes);
        }
        return bytes == 1L ? "1 byte" : bytes + " bytes";
    }

    public double convertFromBytes(long bytes) {
        return (double)bytes / (double)this.bytes;
    }

    public long convertToBytes(double amount) {
        return (long)(amount * (double)this.bytes);
    }

    private String format(double amount) {
        return FORMAT.format(amount) + " " + this.abbreviation;
    }

    public String formatBytes(long bytes) {
        return this.format(this.convertFromBytes(bytes));
    }

    static {
        VALUES = DataSizeUnit.values();
        FORMAT = new DecimalFormat("#.##");
    }
}

