// Generated with hyprwayland-scanner 0.4.5. Made with vaxry's keyboard and ❤️.
// text_input_unstable_v3

/*
 This protocol's authors' copyright notice is:


    Copyright © 2012, 2013 Intel Corporation
    Copyright © 2015, 2016 Jan Arne Petersen
    Copyright © 2017, 2018 Red Hat, Inc.
    Copyright © 2018       Purism SPC

    Permission to use, copy, modify, distribute, and sell this
    software and its documentation for any purpose is hereby granted
    without fee, provided that the above copyright notice appear in
    all copies and that both that copyright notice and this permission
    notice appear in supporting documentation, and that the name of
    the copyright holders not be used in advertising or publicity
    pertaining to distribution of the software without specific,
    written prior permission.  The copyright holders make no
    representations about the suitability of this software for any
    purpose.  It is provided "as is" without express or implied
    warranty.

    THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
    SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
    FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
    SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
    WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
    AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
    ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
    THIS SOFTWARE.
  
*/

#define private public
#define HYPRWAYLAND_SCANNER_NO_INTERFACES
#include "text-input-unstable-v3.hpp"
#undef private
#define F std::function

static const wl_interface* textInputUnstableV3_dummyTypes[] = { nullptr };

// Reference all other interfaces.
// The reason why this is in snake is to
// be able to cooperate with existing
// wayland_scanner interfaces (they are interop)
extern const wl_interface zwp_text_input_v3_interface;
extern const wl_interface zwp_text_input_manager_v3_interface;
extern const wl_interface wl_surface_interface;
extern const wl_interface wl_seat_interface;

static void _CZwpTextInputV3Enter(void* data, void* resource, wl_proxy* surface) {
    const auto PO = (CCZwpTextInputV3*)data;
    if (PO && PO->requests.enter)
        PO->requests.enter(PO, surface);
}

static void _CZwpTextInputV3Leave(void* data, void* resource, wl_proxy* surface) {
    const auto PO = (CCZwpTextInputV3*)data;
    if (PO && PO->requests.leave)
        PO->requests.leave(PO, surface);
}

static void _CZwpTextInputV3PreeditString(void* data, void* resource, const char* text, int32_t cursor_begin, int32_t cursor_end) {
    const auto PO = (CCZwpTextInputV3*)data;
    if (PO && PO->requests.preeditString)
        PO->requests.preeditString(PO, text, cursor_begin, cursor_end);
}

static void _CZwpTextInputV3CommitString(void* data, void* resource, const char* text) {
    const auto PO = (CCZwpTextInputV3*)data;
    if (PO && PO->requests.commitString)
        PO->requests.commitString(PO, text);
}

static void _CZwpTextInputV3DeleteSurroundingText(void* data, void* resource, uint32_t before_length, uint32_t after_length) {
    const auto PO = (CCZwpTextInputV3*)data;
    if (PO && PO->requests.deleteSurroundingText)
        PO->requests.deleteSurroundingText(PO, before_length, after_length);
}

static void _CZwpTextInputV3Done(void* data, void* resource, uint32_t serial) {
    const auto PO = (CCZwpTextInputV3*)data;
    if (PO && PO->requests.done)
        PO->requests.done(PO, serial);
}

static const void* _CCZwpTextInputV3VTable[] = {
    (void*)_CZwpTextInputV3Enter,
    (void*)_CZwpTextInputV3Leave,
    (void*)_CZwpTextInputV3PreeditString,
    (void*)_CZwpTextInputV3CommitString,
    (void*)_CZwpTextInputV3DeleteSurroundingText,
    (void*)_CZwpTextInputV3Done,
};

void CCZwpTextInputV3::sendDestroy() {
    if (!pResource)
        return;
    destroyed = true;

    auto proxy = wl_proxy_marshal_flags(pResource, 0, nullptr, wl_proxy_get_version(pResource), 1);
    proxy;
}

void CCZwpTextInputV3::sendEnable() {
    if (!pResource)
        return;

    auto proxy = wl_proxy_marshal_flags(pResource, 1, nullptr, wl_proxy_get_version(pResource), 0);
    proxy;
}

void CCZwpTextInputV3::sendDisable() {
    if (!pResource)
        return;

    auto proxy = wl_proxy_marshal_flags(pResource, 2, nullptr, wl_proxy_get_version(pResource), 0);
    proxy;
}

void CCZwpTextInputV3::sendSetSurroundingText(const char* text, int32_t cursor, int32_t anchor) {
    if (!pResource)
        return;

    auto proxy = wl_proxy_marshal_flags(pResource, 3, nullptr, wl_proxy_get_version(pResource), 0, text, cursor, anchor);
    proxy;
}

void CCZwpTextInputV3::sendSetTextChangeCause(zwpTextInputV3ChangeCause cause) {
    if (!pResource)
        return;

    auto proxy = wl_proxy_marshal_flags(pResource, 4, nullptr, wl_proxy_get_version(pResource), 0, cause);
    proxy;
}

void CCZwpTextInputV3::sendSetContentType(zwpTextInputV3ContentHint hint, zwpTextInputV3ContentPurpose purpose) {
    if (!pResource)
        return;

    auto proxy = wl_proxy_marshal_flags(pResource, 5, nullptr, wl_proxy_get_version(pResource), 0, hint, purpose);
    proxy;
}

void CCZwpTextInputV3::sendSetCursorRectangle(int32_t x, int32_t y, int32_t width, int32_t height) {
    if (!pResource)
        return;

    auto proxy = wl_proxy_marshal_flags(pResource, 6, nullptr, wl_proxy_get_version(pResource), 0, x, y, width, height);
    proxy;
}

void CCZwpTextInputV3::sendCommit() {
    if (!pResource)
        return;

    auto proxy = wl_proxy_marshal_flags(pResource, 7, nullptr, wl_proxy_get_version(pResource), 0);
    proxy;
}
static const wl_interface* _CZwpTextInputV3SetSurroundingTextTypes[] = {
    nullptr,
    nullptr,
    nullptr,
};
static const wl_interface* _CZwpTextInputV3SetTextChangeCauseTypes[] = {
    nullptr,
};
static const wl_interface* _CZwpTextInputV3SetContentTypeTypes[] = {
    nullptr,
    nullptr,
};
static const wl_interface* _CZwpTextInputV3SetCursorRectangleTypes[] = {
    nullptr,
    nullptr,
    nullptr,
    nullptr,
};
static const wl_interface* _CZwpTextInputV3EnterTypes[] = {
    &wl_surface_interface,
};
static const wl_interface* _CZwpTextInputV3LeaveTypes[] = {
    &wl_surface_interface,
};
static const wl_interface* _CZwpTextInputV3PreeditStringTypes[] = {
    nullptr,
    nullptr,
    nullptr,
};
static const wl_interface* _CZwpTextInputV3CommitStringTypes[] = {
    nullptr,
};
static const wl_interface* _CZwpTextInputV3DeleteSurroundingTextTypes[] = {
    nullptr,
    nullptr,
};
static const wl_interface* _CZwpTextInputV3DoneTypes[] = {
    nullptr,
};

static const wl_message _CZwpTextInputV3Requests[] = {
    { .name = "destroy", .signature = "", .types = textInputUnstableV3_dummyTypes + 0},
    { .name = "enable", .signature = "", .types = textInputUnstableV3_dummyTypes + 0},
    { .name = "disable", .signature = "", .types = textInputUnstableV3_dummyTypes + 0},
    { .name = "set_surrounding_text", .signature = "sii", .types = _CZwpTextInputV3SetSurroundingTextTypes + 0},
    { .name = "set_text_change_cause", .signature = "u", .types = _CZwpTextInputV3SetTextChangeCauseTypes + 0},
    { .name = "set_content_type", .signature = "uu", .types = _CZwpTextInputV3SetContentTypeTypes + 0},
    { .name = "set_cursor_rectangle", .signature = "iiii", .types = _CZwpTextInputV3SetCursorRectangleTypes + 0},
    { .name = "commit", .signature = "", .types = textInputUnstableV3_dummyTypes + 0},
};

static const wl_message _CZwpTextInputV3Events[] = {
    { .name = "enter", .signature = "o", .types = _CZwpTextInputV3EnterTypes + 0},
    { .name = "leave", .signature = "o", .types = _CZwpTextInputV3LeaveTypes + 0},
    { .name = "preedit_string", .signature = "?sii", .types = _CZwpTextInputV3PreeditStringTypes + 0},
    { .name = "commit_string", .signature = "?s", .types = _CZwpTextInputV3CommitStringTypes + 0},
    { .name = "delete_surrounding_text", .signature = "uu", .types = _CZwpTextInputV3DeleteSurroundingTextTypes + 0},
    { .name = "done", .signature = "u", .types = _CZwpTextInputV3DoneTypes + 0},
};

const wl_interface zwp_text_input_v3_interface = {
    .name = "zwp_text_input_v3", .version = 1,
    .method_count = 8, .methods = _CZwpTextInputV3Requests,
    .event_count = 6, .events = _CZwpTextInputV3Events,
};

CCZwpTextInputV3::CCZwpTextInputV3(wl_proxy* resource) : pResource(resource) {

    if (!pResource)
        return;

    wl_proxy_add_listener(pResource, (void (**)(void))&_CCZwpTextInputV3VTable, this);
}

CCZwpTextInputV3::~CCZwpTextInputV3() {
    if (!destroyed)
        sendDestroy();
}

void CCZwpTextInputV3::setEnter(F<void(CCZwpTextInputV3*, wl_proxy*)> handler) {
    requests.enter = handler;
}

void CCZwpTextInputV3::setLeave(F<void(CCZwpTextInputV3*, wl_proxy*)> handler) {
    requests.leave = handler;
}

void CCZwpTextInputV3::setPreeditString(F<void(CCZwpTextInputV3*, const char*, int32_t, int32_t)> handler) {
    requests.preeditString = handler;
}

void CCZwpTextInputV3::setCommitString(F<void(CCZwpTextInputV3*, const char*)> handler) {
    requests.commitString = handler;
}

void CCZwpTextInputV3::setDeleteSurroundingText(F<void(CCZwpTextInputV3*, uint32_t, uint32_t)> handler) {
    requests.deleteSurroundingText = handler;
}

void CCZwpTextInputV3::setDone(F<void(CCZwpTextInputV3*, uint32_t)> handler) {
    requests.done = handler;
}

static const void* _CCZwpTextInputManagerV3VTable[] = {
    nullptr,
};

void CCZwpTextInputManagerV3::sendDestroy() {
    if (!pResource)
        return;
    destroyed = true;

    auto proxy = wl_proxy_marshal_flags(pResource, 0, nullptr, wl_proxy_get_version(pResource), 1);
    proxy;
}

wl_proxy* CCZwpTextInputManagerV3::sendGetTextInput(wl_proxy* seat) {
    if (!pResource)
        return nullptr;

    auto proxy = wl_proxy_marshal_flags(pResource, 1, &zwp_text_input_v3_interface, wl_proxy_get_version(pResource), 0, nullptr, seat);

    return proxy;
}
static const wl_interface* _CZwpTextInputManagerV3GetTextInputTypes[] = {
    &zwp_text_input_v3_interface,
    &wl_seat_interface,
};

static const wl_message _CZwpTextInputManagerV3Requests[] = {
    { .name = "destroy", .signature = "", .types = textInputUnstableV3_dummyTypes + 0},
    { .name = "get_text_input", .signature = "no", .types = _CZwpTextInputManagerV3GetTextInputTypes + 0},
};

const wl_interface zwp_text_input_manager_v3_interface = {
    .name = "zwp_text_input_manager_v3", .version = 1,
    .method_count = 2, .methods = _CZwpTextInputManagerV3Requests,
    .event_count = 0, .events = nullptr,
};

CCZwpTextInputManagerV3::CCZwpTextInputManagerV3(wl_proxy* resource) : pResource(resource) {

    if (!pResource)
        return;

    wl_proxy_add_listener(pResource, (void (**)(void))&_CCZwpTextInputManagerV3VTable, this);
}

CCZwpTextInputManagerV3::~CCZwpTextInputManagerV3() {
    if (!destroyed)
        sendDestroy();
}

#undef F
