/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ec4j.core.model.Ec4jPath;
import org.ec4j.core.model.Property;
import org.ec4j.core.model.PropertyType;

public class ResourceProperties {
    private final Map<String, Property> properties;
    private final List<Ec4jPath> editorConfigFiles;

    public static Builder builder() {
        return new Builder();
    }

    ResourceProperties(Map<String, Property> properties2, List<Ec4jPath> editorConfigFiles) {
        this.properties = properties2;
        this.editorConfigFiles = editorConfigFiles;
    }

    public Map<String, Property> getProperties() {
        return this.properties;
    }

    public <T> T getValue(PropertyType<T> type2, T defaultValue, boolean throwInvalid) {
        return this.getValue(type2.getName(), defaultValue, throwInvalid);
    }

    public <T> T getValue(String name2, T defaultValue, boolean throwInvalid) {
        Property prop = this.properties.get(name2);
        if (prop == null) {
            return defaultValue;
        }
        if (throwInvalid || prop.isValid()) {
            return prop.getValueAs();
        }
        return defaultValue;
    }

    public List<Ec4jPath> getEditorConfigFiles() {
        return this.editorConfigFiles;
    }

    public static class Builder {
        private Map<String, Property> properties = new LinkedHashMap<String, Property>();
        private List<Ec4jPath> editorConfigFiles = new ArrayList<Ec4jPath>();

        public ResourceProperties build() {
            Map<String, Property> useProps = this.properties.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(this.properties);
            this.properties = null;
            List<Ec4jPath> useEcFiles = this.editorConfigFiles.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(this.editorConfigFiles);
            this.editorConfigFiles = null;
            return new ResourceProperties(useProps, useEcFiles);
        }

        public Builder properties(Collection<Property> properties2) {
            for (Property property2 : properties2) {
                this.properties.put(property2.getName(), property2);
            }
            return this;
        }

        public Builder properties(Map<String, Property> properties2) {
            this.properties.putAll(properties2);
            return this;
        }

        public Builder properties(Property ... properties2) {
            for (Property property2 : properties2) {
                this.properties.put(property2.getName(), property2);
            }
            return this;
        }

        public Builder property(Property property2) {
            this.properties.put(property2.getName(), property2);
            return this;
        }

        public Builder removeProperty(Property property2) {
            this.properties.remove(property2.getName());
            return this;
        }

        public Builder editorConfigFile(Ec4jPath ec4jPath) {
            this.editorConfigFiles.add(ec4jPath);
            return this;
        }

        public Builder editorConfigFiles(Collection<Ec4jPath> ec4jPaths) {
            this.editorConfigFiles.addAll(ec4jPaths);
            return this;
        }

        public Builder editorConfigFiles(Ec4jPath ... ec4jPaths) {
            for (Ec4jPath ec4jPath : ec4jPaths) {
                this.editorConfigFiles.add(ec4jPath);
            }
            return this;
        }
    }
}

