/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedConstructor;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedDeclaration;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedFunction;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedModule;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedNamespace;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedObject;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedParameter;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedProperty;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedRegularClass;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedType;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedVisibility;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.serialization.js.ModuleKind;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\fH\u0002J\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\fJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001c\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020&H\u0002J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J\u0012\u00100\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0010\u00101\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u000202H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010$\u001a\u0012\u0012\u0004\u0012\u00020&0%j\b\u0012\u0004\u0012\u00020&`'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u00103\u001a\u000204*\u0002058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00106\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/export/ExportModelGenerator;", "", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "excludedFromExport", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "collectAllTheDeclarationsToExport", "", "modules", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "generateExport", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedModule;", "exportDeclaration", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedDeclaration;", "declaration", "exportFunction", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedFunction;", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "exportConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "exportProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "specializeType", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedType;", "exportParameter", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedParameter;", "parameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "currentlyProcessedTypes", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lkotlin/collections/HashSet;", "exportType", "type", "exportTypeArgument", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "exportTypeParameter", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedType$TypeParameter;", "typeParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "exportMemberDeclaration", "exportClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "isInterface", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "(Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;)Z", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nExportModelGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExportModelGenerator.kt\norg/jetbrains/kotlin/backend/wasm/export/ExportModelGenerator\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 6 MemoryOptimizedCollectionUtil.kt\norg/jetbrains/kotlin/utils/MemoryOptimizedCollectionUtilKt\n*L\n1#1,331:1\n1321#2,2:332\n1617#3,9:334\n1869#3:343\n1870#3:345\n1626#3:346\n1634#3,3:349\n774#3:352\n865#3,2:353\n1634#3,3:356\n774#3:360\n865#3,2:361\n1634#3,3:364\n1634#3,3:368\n1634#3,3:372\n2783#3,7:375\n1634#3,3:383\n774#3:386\n865#3,2:387\n1563#3:389\n1634#3,3:390\n865#3,2:394\n1625#3:397\n1869#3:398\n1870#3:400\n1626#3:401\n1#4:344\n1#4:359\n1#4:399\n233#5:347\n16#6:348\n16#6:355\n16#6:363\n16#6:367\n16#6:371\n16#6:382\n48#6:393\n32#6:396\n*S KotlinDebug\n*F\n+ 1 ExportModelGenerator.kt\norg/jetbrains/kotlin/backend/wasm/export/ExportModelGenerator\n*L\n52#1:332,2\n114#1:334,9\n114#1:343\n114#1:345\n114#1:346\n131#1:349,3\n137#1:352\n137#1:353,2\n138#1:356,3\n144#1:360\n144#1:361,2\n146#1:364,3\n206#1:368,3\n228#1:372,3\n265#1:375,7\n282#1:383,3\n290#1:386\n290#1:387,2\n291#1:389\n291#1:390,3\n292#1:394,2\n295#1:397\n295#1:398\n295#1:400\n295#1:401\n114#1:344\n295#1:399\n126#1:347\n131#1:348\n138#1:355\n146#1:363\n206#1:367\n228#1:371\n282#1:382\n292#1:393\n295#1:396\n*E\n"})
public final class ExportModelGenerator {
    @NotNull
    private final WasmBackendContext context;
    @NotNull
    private final Set<IrDeclaration> excludedFromExport;
    @NotNull
    private final HashSet<IrType> currentlyProcessedTypes;

    public ExportModelGenerator(@NotNull WasmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        IrDeclaration[] irDeclarationArray = new IrDeclaration[]{this.context.getWasmSymbols().getJsRelatedSymbols().getJsReferenceClass().getOwner(), IrTypesKt.getClassOrFail(this.context.getWasmSymbols().getJsRelatedSymbols().getJsAnyType()).getOwner(), IrTypesKt.getClassOrFail(this.context.getWasmSymbols().getJsRelatedSymbols().getJsNumberType()).getOwner(), IrTypesKt.getClassOrFail(this.context.getWasmSymbols().getJsRelatedSymbols().getJsStringType()).getOwner(), IrTypesKt.getClassOrFail(this.context.getWasmSymbols().getJsRelatedSymbols().getJsBooleanType()).getOwner(), IrTypesKt.getClassOrFail(this.context.getWasmSymbols().getJsRelatedSymbols().getJsBigIntType()).getOwner()};
        this.excludedFromExport = SetsKt.setOf(irDeclarationArray);
        this.currentlyProcessedTypes = new HashSet();
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<IrDeclaration> collectAllTheDeclarationsToExport(Iterable<? extends IrModuleFragment> modules2) {
        void $this$forEach$iv;
        ArrayDeque<IrDeclaration> arrayDeque;
        Set declarationsToExport = new LinkedHashSet();
        ArrayDeque<IrDeclaration> $this$collectAllTheDeclarationsToExport_u24lambda_u240 = arrayDeque = new ArrayDeque<IrDeclaration>();
        boolean bl = false;
        Sequence<IrDeclaration> sequence2 = SequencesKt.filter(SequencesKt.flatMapIterable(SequencesKt.flatMapIterable(CollectionsKt.asSequence(modules2), ExportModelGenerator::collectAllTheDeclarationsToExport$lambda$0$0), ExportModelGenerator::collectAllTheDeclarationsToExport$lambda$0$1), ExportModelGenerator::collectAllTheDeclarationsToExport$lambda$0$2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrDeclaration it = (IrDeclaration)element$iv;
            boolean bl2 = false;
            declarationsToExport.add(it);
            $this$collectAllTheDeclarationsToExport_u24lambda_u240.addLast(it);
        }
        ArrayDeque<IrDeclaration> queue = arrayDeque;
        IrVisitorVoid declarationVisitor2 = new IrVisitorVoid(this, declarationsToExport, queue){
            final /* synthetic */ ExportModelGenerator this$0;
            final /* synthetic */ Set<IrDeclaration> $declarationsToExport;
            final /* synthetic */ ArrayDeque<IrDeclaration> $queue;
            {
                this.this$0 = $receiver;
                this.$declarationsToExport = $declarationsToExport;
                this.$queue = $queue;
            }

            public void visitFunction(IrFunction declaration) {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                this.visitType(declaration.getReturnType());
                Iterable $this$forEach$iv = declaration.getTypeParameters();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    IrTypeParameter p0 = (IrTypeParameter)element$iv;
                    boolean bl = false;
                    this.visitTypeParameter(p0);
                }
                $this$forEach$iv = declaration.getParameters();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    IrValueParameter it = (IrValueParameter)element$iv;
                    boolean bl = false;
                    if (it.getKind() == IrParameterKind.DispatchReceiver) continue;
                    this.visitValueParameter(it);
                }
            }

            public void visitClass(IrClass declaration) {
                IrAnnotationContainer p0;
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                Iterable $this$forEach$iv = declaration.getSuperTypes();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    p0 = (IrType)element$iv;
                    boolean bl = false;
                    this.visitType((IrType)p0);
                }
                $this$forEach$iv = declaration.getTypeParameters();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    p0 = (IrTypeParameter)element$iv;
                    boolean bl = false;
                    this.visitTypeParameter((IrTypeParameter)p0);
                }
                $this$forEach$iv = declaration.getDeclarations();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    IrDeclaration it = (IrDeclaration)element$iv;
                    boolean bl = false;
                    IrVisitorsKt.acceptVoid((IrElement)it, this);
                }
            }

            public void visitProperty(IrProperty declaration) {
                block1: {
                    IrDeclarationBase p0;
                    Intrinsics.checkNotNullParameter(declaration, "declaration");
                    IrField irField = declaration.getBackingField();
                    if (irField != null) {
                        p0 = irField;
                        boolean bl = false;
                        this.visitField((IrField)p0);
                    }
                    IrSimpleFunction irSimpleFunction = declaration.getGetter();
                    if (irSimpleFunction == null) break block1;
                    p0 = irSimpleFunction;
                    boolean bl = false;
                    this.visitFunction((IrFunction)p0);
                }
            }

            public void visitField(IrField declaration) {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                this.visitType(declaration.getType());
            }

            public void visitValueParameter(IrValueParameter declaration) {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                this.visitType(declaration.getType());
            }

            public void visitTypeParameter(IrTypeParameter declaration) {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                Iterable $this$forEach$iv = declaration.getSuperTypes();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    IrType p0 = (IrType)element$iv;
                    boolean bl = false;
                    this.visitType(p0);
                }
            }

            private final void visitType(IrType type2) {
                if (!(type2 instanceof IrSimpleType)) {
                    return;
                }
                IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)type2).getClassifier();
                IrClassSymbol irClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
                if (irClassSymbol == null) {
                    return;
                }
                IrClassSymbol classifier2 = irClassSymbol;
                IrClass klass = (IrClass)classifier2.getOwner();
                if (!klass.isExternal() || ExportModelGenerator.access$getExcludedFromExport$p(this.this$0).contains(klass) || this.$declarationsToExport.contains(klass)) {
                    return;
                }
                this.$queue.add(klass);
                this.$declarationsToExport.add(klass);
                Iterable $this$forEach$iv = ((IrSimpleType)type2).getArguments();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    IrType p0;
                    IrTypeArgument it = (IrTypeArgument)element$iv;
                    boolean bl = false;
                    if (IrTypesKt.getTypeOrNull(it) == null) continue;
                    boolean bl2 = false;
                    this.visitType(p0);
                }
            }
        };
        while (!((Collection)queue).isEmpty()) {
            IrDeclaration declaration = queue.removeFirst();
            IrVisitorsKt.acceptVoid((IrElement)declaration, declarationVisitor2);
        }
        return declarationsToExport;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ExportedModule generateExport(@NotNull Iterable<? extends IrModuleFragment> modules2) {
        List list;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(modules2, "modules");
        String string = this.context.getConfiguration().get(CommonConfigurationKeys.MODULE_NAME);
        Intrinsics.checkNotNull(string);
        Iterable<IrDeclaration> iterable = this.collectAllTheDeclarationsToExport(modules2);
        ModuleKind moduleKind = ModuleKind.ES;
        String string2 = string;
        boolean $i$f$mapNotNull = false;
        void var4_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ExportedDeclaration it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrDeclaration p0 = (IrDeclaration)element$iv$iv;
            boolean bl2 = false;
            if (this.exportDeclaration(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = list = (List)destination$iv$iv;
        ModuleKind moduleKind2 = moduleKind;
        String string3 = string2;
        return new ExportedModule(string3, moduleKind2, list2);
    }

    private final ExportedDeclaration exportDeclaration(IrDeclaration declaration) {
        ExportedDeclaration exportedDeclaration;
        IrDeclaration irDeclaration = declaration;
        if (irDeclaration instanceof IrSimpleFunction) {
            exportedDeclaration = this.exportFunction((IrSimpleFunction)declaration);
        } else if (irDeclaration instanceof IrClass) {
            exportedDeclaration = this.exportClass((IrClass)declaration);
        } else {
            throw new IllegalStateException(("Can't export declaration " + declaration).toString());
        }
        ExportedDeclaration exportedDeclaration2 = exportedDeclaration;
        return exportedDeclaration2 != null ? ExportModelGeneratorKt.withAttributesFor(exportedDeclaration2, declaration) : null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ExportedFunction exportFunction(IrSimpleFunction function2) {
        void $this$mapTo$iv$iv;
        void $this$memoryOptimizedMap$iv;
        IrValueParameter it;
        Iterable $this$filterTo$iv$iv;
        Iterable p0;
        Collection collection;
        void $this$mapTo$iv$iv2;
        if (function2.getCorrespondingPropertySymbol() != null) return null;
        IrClass irClass = IrUtilsKt.getParentClassOrNull(IrResolveUtilsKt.getRealOverrideTarget(function2));
        if (Intrinsics.areEqual(irClass != null ? irClass.getSymbol() : null, this.context.getIrBuiltIns().getAnyClass())) return null;
        boolean bl = true;
        boolean condition$iv = bl;
        boolean $i$f$runIf = false;
        if (!condition$iv) return null;
        boolean bl2 = false;
        IrClass parentClass = IrUtilsKt.getParentClassOrNull(function2);
        String string = ExportModelGeneratorKt.getExportedIdentifier(function2);
        ExportedType exportedType = this.exportType(function2.getReturnType());
        Collection $this$memoryOptimizedMap$iv2 = function2.getTypeParameters();
        boolean $i$f$memoryOptimizedMap = false;
        Iterable iterable = $this$memoryOptimizedMap$iv2;
        Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv2.size());
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(this.exportTypeParameter((IrTypeParameter)((Object)p0)));
        }
        List<ExportedType.TypeParameter> list = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv);
        boolean bl4 = parentClass != null;
        boolean bl5 = IrDeclarationsKt.isStaticMethodOfClass(function2);
        boolean bl6 = Intrinsics.areEqual(function2.getVisibility(), DescriptorVisibilities.PROTECTED);
        boolean bl7 = parentClass != null && !IrUtilsKt.isInterface(parentClass) && function2.getModality() == Modality.ABSTRACT;
        Iterable $this$filter$iv = function2.getParameters();
        boolean $i$f$filter = false;
        p0 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrValueParameter)element$iv$iv;
            boolean bl8 = false;
            if (!(it.getKind() != IrParameterKind.DispatchReceiver)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$memoryOptimizedMap2 = false;
        $this$filterTo$iv$iv = (Iterable)$this$memoryOptimizedMap$iv;
        destination$iv$iv2 = new ArrayList($this$memoryOptimizedMap$iv.size());
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IrValueParameter)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl9 = false;
            collection.add(this.exportParameter(it));
        }
        List<ExportedParameter> list2 = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv2);
        ExportedFunction exportedFunction = new ExportedFunction(string, exportedType, list2, list, bl4, bl5, bl7, bl6, function2);
        return exportedFunction;
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedDeclaration exportConstructor(IrConstructor constructor) {
        void $this$mapTo$iv$iv;
        IrValueParameter it;
        Iterable $this$filterTo$iv$iv;
        boolean bl = constructor.isPrimary();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-ExportModelGenerator$exportConstructor$22 = false;
            String $i$a$-assert-ExportModelGenerator$exportConstructor$22 = "Can't export not-primary constructor";
            throw new AssertionError((Object)$i$a$-assert-ExportModelGenerator$exportConstructor$22);
        }
        Iterable $this$filter$iv = constructor.getParameters();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrValueParameter)element$iv$iv;
            boolean bl2 = false;
            if (!(it.getKind() != IrParameterKind.DispatchReceiver)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allValueParameters = (List)destination$iv$iv;
        Collection $this$memoryOptimizedMap$iv = allValueParameters;
        boolean $i$f$memoryOptimizedMap = false;
        $this$filterTo$iv$iv = $this$memoryOptimizedMap$iv;
        destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(this.exportParameter(it));
        }
        ExportedVisibility exportedVisibility = ExportModelGeneratorKt.toExportedVisibility(constructor.getVisibility());
        List<ExportedParameter> list = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv);
        return new ExportedConstructor(list, exportedVisibility);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final ExportedDeclaration exportProperty(IrProperty property, ExportedType specializeType) {
        var4_3 = property.getParent();
        v0 = parentClass = var4_3 instanceof IrClass != false ? (IrClass)var4_3 : null;
        if (parentClass == null) ** GOTO lbl-1000
        v1 /* !! */  = property.getGetter();
        v2 = v1 /* !! */  != null && (v1 /* !! */  = v1 /* !! */ .getReturnType()) != null ? IrTypeUtilsKt.isNullable((IrType)v1 /* !! */ ) : false;
        if (v2) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        isOptional = v3;
        var5_6 = ExportModelGeneratorKt.getExportedIdentifier(property);
        v4 = specializeType;
        if (v4 == null) {
            v5 = property.getGetter();
            Intrinsics.checkNotNull(v5);
            v4 = this.exportType(v5.getReturnType());
        }
        var6_7 = v4;
        var7_8 = property.isVar();
        var8_9 = parentClass != null;
        v6 = parentClass;
        var9_10 = (v6 != null ? !IrUtilsKt.isInterface(v6) : false) != false && property.getModality() == Modality.ABSTRACT;
        var10_11 = Intrinsics.areEqual(property.getVisibility(), DescriptorVisibilities.PROTECTED);
        v7 = parentClass;
        var11_12 = v7 != null ? IrUtilsKt.isInterface(v7) : false;
        var12_13 = property.getGetter();
        var13_14 = property.getSetter();
        v8 = property.getGetter();
        if (v8 == null) {
            v8 = property.getSetter();
        }
        var14_15 = v8 != null ? IrDeclarationsKt.isStaticMethodOfClass(v8) : false;
        return new ExportedProperty(var5_6, var6_7, var7_8, var8_9, var14_15, var9_10, var10_11, var11_12, var12_13, var13_14, isOptional, false, 2048, null);
    }

    static /* synthetic */ ExportedDeclaration exportProperty$default(ExportModelGenerator exportModelGenerator, IrProperty irProperty, ExportedType exportedType, int n2, Object object) {
        if ((n2 & 2) != 0) {
            exportedType = null;
        }
        return exportModelGenerator.exportProperty(irProperty, exportedType);
    }

    private final ExportedParameter exportParameter(IrValueParameter parameter) {
        String string = parameter.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
        return new ExportedParameter(string, this.exportType(parameter.getType()), parameter.getDefaultValue() != null);
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedType exportType(IrType type2) {
        ExportedType exportedType;
        ExportedType exportedType2;
        boolean isMarkedNullable;
        block11: {
            IrClassifierSymbol classifier2;
            block19: {
                Object object;
                WasmSymbols.JsRelatedSymbols jsRelatedSymbols;
                block18: {
                    block17: {
                        void $this$mapTo$iv$iv;
                        IrSimpleType nonNullType;
                        block16: {
                            block15: {
                                block14: {
                                    block13: {
                                        block12: {
                                            block10: {
                                                if (this.currentlyProcessedTypes.contains(type2)) {
                                                    return ExportedType.Primitive.Unknown.INSTANCE;
                                                }
                                                if (!(type2 instanceof IrSimpleType)) {
                                                    return new ExportedType.ErrorType("NonSimpleType " + RenderIrElementKt.render$default(type2, null, 1, null));
                                                }
                                                this.currentlyProcessedTypes.add(type2);
                                                classifier2 = ((IrSimpleType)type2).getClassifier();
                                                isMarkedNullable = IrTypePredicatesKt.isMarkedNullable((IrSimpleType)type2);
                                                IrType irType = IrTypesKt.makeNotNull(type2);
                                                Intrinsics.checkNotNull(irType, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
                                                nonNullType = (IrSimpleType)irType;
                                                jsRelatedSymbols = this.context.getWasmSymbols().getJsRelatedSymbols();
                                                if (!IrTypePredicatesKt.isBoolean(nonNullType) && !Intrinsics.areEqual(nonNullType, jsRelatedSymbols.getJsBooleanType())) break block10;
                                                exportedType2 = ExportedType.Primitive.Boolean.INSTANCE;
                                                break block11;
                                            }
                                            if (!IrTypePredicatesKt.isLong(nonNullType) && !IrTypePredicatesKt.isULong(nonNullType) && !Intrinsics.areEqual(nonNullType, jsRelatedSymbols.getJsBigIntType())) break block12;
                                            exportedType2 = ExportedType.Primitive.BigInt.INSTANCE;
                                            break block11;
                                        }
                                        if (!IrTypePredicatesKt.isPrimitiveType$default(nonNullType, false, 1, null) && !IrTypePredicatesKt.isUByte(nonNullType) && !IrTypePredicatesKt.isUShort(nonNullType) && !IrTypePredicatesKt.isUInt(nonNullType) && !Intrinsics.areEqual(nonNullType, jsRelatedSymbols.getJsNumberType())) break block13;
                                        exportedType2 = ExportedType.Primitive.Number.INSTANCE;
                                        break block11;
                                    }
                                    if (!IrTypePredicatesKt.isString(nonNullType) && !Intrinsics.areEqual(nonNullType, jsRelatedSymbols.getJsStringType())) break block14;
                                    exportedType2 = ExportedType.Primitive.String.INSTANCE;
                                    break block11;
                                }
                                if (!Intrinsics.areEqual(nonNullType, jsRelatedSymbols.getJsAnyType())) break block15;
                                exportedType2 = ExportedType.Primitive.Unknown.INSTANCE;
                                break block11;
                            }
                            if (!IrTypePredicatesKt.isUnit(nonNullType) && !Intrinsics.areEqual(nonNullType, this.context.getWasmSymbols().getVoidType())) break block16;
                            exportedType2 = ExportedType.Primitive.Unit.INSTANCE;
                            break block11;
                        }
                        if (!IrTypeUtilsKt.isFunction(nonNullType)) break block17;
                        Collection $this$memoryOptimizedMap$iv = CollectionsKt.dropLast(nonNullType.getArguments(), 1);
                        boolean $i$f$memoryOptimizedMap = false;
                        Iterable iterable = $this$memoryOptimizedMap$iv;
                        Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
                            object = destination$iv$iv;
                            boolean bl = false;
                            object.add(this.exportTypeArgument((IrTypeArgument)it));
                        }
                        ExportedType exportedType3 = this.exportTypeArgument(CollectionsKt.last(nonNullType.getArguments()));
                        List list = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv);
                        exportedType2 = new ExportedType.Function(list, exportedType3);
                        break block11;
                    }
                    if (!(classifier2 instanceof IrTypeParameterSymbol)) break block18;
                    String string = ((IrTypeParameter)((IrTypeParameterSymbol)classifier2).getOwner()).getName().getIdentifier();
                    Intrinsics.checkNotNullExpressionValue(string, "getIdentifier(...)");
                    exportedType2 = new ExportedType.TypeParameter(string, null, 2, null);
                    break block11;
                }
                if (!(classifier2 instanceof IrClassSymbol)) break block19;
                IrClass klass = (IrClass)((IrClassSymbol)classifier2).getOwner();
                if (Intrinsics.areEqual(klass.getSymbol(), jsRelatedSymbols.getJsReferenceClass())) {
                    return ExportedType.Primitive.Unknown.INSTANCE;
                }
                if (!klass.isExternal()) {
                    boolean $i$a$-require-ExportModelGenerator$exportType$exportedType$32 = false;
                    String $i$a$-require-ExportModelGenerator$exportType$exportedType$32 = "Unexpected non-external class: " + IrUtilsKt.getFqNameWhenAvailable(klass);
                    throw new IllegalArgumentException($i$a$-require-ExportModelGenerator$exportType$exportedType$32.toString());
                }
                String name2 = "not.exported." + IrJsUtilsKt.getFqNameWithJsNameWhenAvailable(klass, true).asString();
                switch (WhenMappings.$EnumSwitchMapping$0[klass.getKind().ordinal()]) {
                    case 1: {
                        exportedType2 = new ExportedType.TypeOf(new ExportedType.ClassType(name2, CollectionsKt.emptyList(), klass));
                        break block11;
                    }
                    case 2: 
                    case 3: {
                        void $this$mapTo$iv$iv;
                        void $this$memoryOptimizedMap$iv;
                        Object item$iv$iv;
                        Collection $i$f$mapTo = ((IrSimpleType)type2).getArguments();
                        object = name2;
                        boolean $i$f$memoryOptimizedMap = false;
                        item$iv$iv = (Iterable)$this$memoryOptimizedMap$iv;
                        Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
                        boolean $i$f$mapTo2 = false;
                        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                            void it;
                            IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv2;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(this.exportTypeArgument((IrTypeArgument)it));
                        }
                        IrClass irClass = klass;
                        List list = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv);
                        Object object2 = object;
                        exportedType2 = new ExportedType.ClassType((String)object2, list, irClass);
                        break block11;
                    }
                    default: {
                        throw new IllegalStateException(("Unexpected class kind " + (Object)((Object)klass.getKind())).toString());
                    }
                }
            }
            throw new IllegalStateException(("Unexpected classifier " + classifier2).toString());
        }
        ExportedType exportedType4 = exportedType2;
        ExportedType it = exportedType = exportedType4.withNullability(isMarkedNullable);
        boolean bl = false;
        this.currentlyProcessedTypes.remove(type2);
        return exportedType;
    }

    private final ExportedType exportTypeArgument(IrTypeArgument type2) {
        if (type2 instanceof IrTypeProjection) {
            return this.exportType(((IrTypeProjection)type2).getType());
        }
        if (type2 instanceof IrType) {
            return this.exportType((IrType)type2);
        }
        return new ExportedType.ErrorType("UnknownType " + RenderIrElementKt.render$default(type2, null, 1, null));
    }

    /*
     * WARNING - void declaration
     */
    private final ExportedType.TypeParameter exportTypeParameter(IrTypeParameter typeParameter) {
        ExportedType exportedType;
        void $this$exportTypeParameter_u24lambda_u243;
        List<ExportedType> constraint = SequencesKt.toList(SequencesKt.filter(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)typeParameter.getSuperTypes()), arg_0 -> ExportModelGenerator.exportTypeParameter$lambda$0(this, arg_0)), arg_0 -> ExportModelGenerator.exportTypeParameter$lambda$1(this, arg_0)), ExportModelGenerator::exportTypeParameter$lambda$2));
        String string = typeParameter.getName().getIdentifier();
        Intrinsics.checkNotNullExpressionValue(string, "getIdentifier(...)");
        List<ExportedType> list = constraint;
        String string2 = string;
        boolean bl = false;
        switch ($this$exportTypeParameter_u24lambda_u243.size()) {
            case 0: {
                exportedType = null;
                break;
            }
            case 1: {
                exportedType = (ExportedType)CollectionsKt.single($this$exportTypeParameter_u24lambda_u243);
                break;
            }
            default: {
                Iterable $this$reduce$iv = (Iterable)$this$exportTypeParameter_u24lambda_u243;
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void p1;
                    ExportedType exportedType2 = (ExportedType)iterator$iv.next();
                    ExportedType p0 = (ExportedType)accumulator$iv;
                    boolean bl2 = false;
                    accumulator$iv = new ExportedType.IntersectionType(p0, (ExportedType)p1);
                }
                exportedType = (ExportedType)accumulator$iv;
            }
        }
        ExportedType exportedType3 = exportedType;
        String string3 = string2;
        return new ExportedType.TypeParameter(string3, exportedType3);
    }

    private final ExportedDeclaration exportMemberDeclaration(IrDeclaration declaration) {
        if (!(declaration instanceof IrDeclarationWithVisibility) || Intrinsics.areEqual(((IrDeclarationWithVisibility)declaration).getVisibility(), DescriptorVisibilities.PRIVATE)) {
            return null;
        }
        IrDeclarationWithVisibility irDeclarationWithVisibility = (IrDeclarationWithVisibility)declaration;
        ExportedDeclaration exportedDeclaration = irDeclarationWithVisibility instanceof IrSimpleFunction ? (ExportedDeclaration)this.exportFunction((IrSimpleFunction)declaration) : (irDeclarationWithVisibility instanceof IrConstructor ? this.exportConstructor((IrConstructor)declaration) : (irDeclarationWithVisibility instanceof IrProperty ? ExportModelGenerator.exportProperty$default(this, (IrProperty)declaration, null, 2, null) : null));
        return exportedDeclaration != null ? ExportModelGeneratorKt.withAttributesFor(exportedDeclaration, declaration) : null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final ExportedDeclaration exportClass(IrClass declaration) {
        block13: {
            $this$memoryOptimizedMap$iv = declaration.getTypeParameters();
            $i$f$memoryOptimizedMap = false;
            var5_5 = $this$memoryOptimizedMap$iv;
            destination$iv$iv = new ArrayList<E>($this$memoryOptimizedMap$iv.size());
            $i$f$mapTo = false;
            var8_11 /* !! */  = $this$mapTo$iv$iv.iterator();
            while (var8_11 /* !! */ .hasNext()) {
                item$iv$iv = var8_11 /* !! */ .next();
                var10_21 = (IrTypeParameter)item$iv$iv;
                var22_17 = destination$iv$iv;
                $i$a$-memoryOptimizedMap-ExportModelGenerator$exportClass$typeParameters$1 = false;
                var22_17.add(this.exportTypeParameter((IrTypeParameter)p0));
            }
            typeParameters = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv);
            destination$iv$iv = declaration.getSuperTypes();
            $i$f$mapTo = destination$iv$iv.iterator();
            while ($i$f$mapTo.hasNext()) {
                var8_11 /* !! */  = $i$f$mapTo.next();
                it = (IrType)var8_11 /* !! */ ;
                $i$a$-find-ExportModelGenerator$exportClass$superClass$1 = false;
                if (!(Intrinsics.areEqual(it, this.context.getIrBuiltIns().getAnyType()) == false && this.isInterface(IrTypesKt.getClassifierOrFail(it)) == false)) continue;
                v0 /* !! */  = var8_11 /* !! */ ;
                break block13;
            }
            v0 /* !! */  = null;
        }
        $i$f$memoryOptimizedMap = (IrType)v0 /* !! */ ;
        if ($i$f$memoryOptimizedMap == null) ** GOTO lbl-1000
        p0 = $i$f$memoryOptimizedMap;
        $i$a$-let-ExportModelGenerator$exportClass$superClass$2 = false;
        $this$mapTo$iv$iv = this.exportType(p0);
        if ($this$mapTo$iv$iv != null) {
            it = destination$iv$iv = $this$mapTo$iv$iv;
            $i$a$-takeIf-ExportModelGenerator$exportClass$superClass$3 = false;
            v1 = it instanceof ExportedType.ErrorType == false ? destination$iv$iv : null;
        } else lbl-1000:
        // 2 sources

        {
            v1 = null;
        }
        superClass = v1;
        $this$mapTo$iv$iv = declaration.getSuperTypes();
        $i$f$filter = false;
        it = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrType)element$iv$iv;
            $i$a$-filter-ExportModelGenerator$exportClass$superInterfaces$1 = false;
            if (!(Intrinsics.areEqual(it, this.context.getWasmSymbols().getJsRelatedSymbols().getJsAnyType()) == false && this.isInterface(IrTypesKt.getClassifierOrFail((IrType)it)) != false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            it = (IrType)item$iv$iv;
            var22_17 = destination$iv$iv;
            $i$a$-map-ExportModelGenerator$exportClass$superInterfaces$2 = false;
            var22_17.add(this.exportType((IrType)p0));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$memoryOptimizedFilter = false;
        $this$mapTo$iv$iv = (Iterable)$this$memoryOptimizedFilter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (ExportedType)element$iv$iv;
            $i$a$-memoryOptimizedFilter-ExportModelGenerator$exportClass$superInterfaces$3 = false;
            if (!(it instanceof ExportedType.ErrorType == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        superInterfaces = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv);
        name = ExportModelGeneratorKt.getExportedIdentifier(declaration);
        $this$memoryOptimizedMapNotNull$iv = declaration.getDeclarations();
        $i$f$memoryOptimizedMapNotNull = false;
        $i$f$filterTo = $this$memoryOptimizedMapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var14_33 = $this$forEach$iv$iv$iv.iterator();
        while (var14_33.hasNext()) {
            element$iv$iv = element$iv$iv$iv = var14_33.next();
            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
            p0 = (IrDeclaration)element$iv$iv;
            $i$a$-memoryOptimizedMapNotNull-ExportModelGenerator$exportClass$members$1 = false;
            if (this.exportMemberDeclaration(p0) == null) continue;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        members = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv);
        if (declaration.getKind() == ClassKind.OBJECT) {
            $i$f$memoryOptimizedMapNotNull = CollectionsKt.listOfNotNull(superClass);
            var9_20 = CollectionsKt.emptyList();
            v2 = new ExportedObject(name, $i$f$memoryOptimizedMapNotNull, superInterfaces, members, var9_20, declaration, null, null, 192, null);
        } else {
            v2 = new ExportedRegularClass(name, IrUtilsKt.isInterface(declaration), declaration.getModality() == Modality.ABSTRACT || declaration.getModality() == Modality.SEALED, false, CollectionsKt.listOfNotNull(superClass), superInterfaces, typeParameters, members, CollectionsKt.emptyList(), declaration, 8, null);
        }
        exportedDeclaration = v2;
        parentFqName = FqNamesUtilKt.parentOrNull(IrJsUtilsKt.getFqNameWithJsNameWhenAvailable(declaration, true));
        v3 = new StringBuilder().append("not.exported");
        v4 = parentFqName;
        if (v4 == null || (v4 = v4.asString()) == null) ** GOTO lbl-1000
        $this$forEach$iv$iv$iv = var11_29 = v4;
        var23_41 = v3;
        $i$a$-takeIf-ExportModelGenerator$exportClass$1 = false;
        var24_42 = ((CharSequence)it).length() > 0;
        v3 = var23_41;
        v4 = var24_42 != false ? var11_29 : null;
        if (v4 != null) {
            it = v4;
            var23_41 = v3;
            $i$a$-let-ExportModelGenerator$exportClass$2 = false;
            v5 = '.' + (String)it;
            v3 = var23_41;
        } else lbl-1000:
        // 2 sources

        {
            v5 = v6 = null;
        }
        if (v5 == null) {
            v6 = "";
        }
        var25_43 = true;
        var26_44 = CollectionsKt.listOf(exportedDeclaration);
        var27_45 = v3.append(v6).toString();
        return new ExportedNamespace(var27_45, var26_44, var25_43);
    }

    private final boolean isInterface(IrClassifierSymbol $this$isInterface) {
        IrSymbolOwner irSymbolOwner = $this$isInterface.getOwner();
        IrClass irClass = irSymbolOwner instanceof IrClass ? (IrClass)irSymbolOwner : null;
        return irClass != null ? IrUtilsKt.isInterface(irClass) : false;
    }

    private static final Iterable collectAllTheDeclarationsToExport$lambda$0$0(IrModuleFragment it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getFiles();
    }

    private static final Iterable collectAllTheDeclarationsToExport$lambda$0$1(IrFile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getDeclarations();
    }

    private static final boolean collectAllTheDeclarationsToExport$lambda$0$2(IrDeclaration it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return AnnotationUtilsKt.isJsExport(it);
    }

    private static final boolean exportTypeParameter$lambda$0(ExportModelGenerator this$0, IrType it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !IrTypeUtilsKt.isNullable(it) || !Intrinsics.areEqual(IrTypesKt.makeNotNull(it), this$0.context.getWasmSymbols().getJsRelatedSymbols().getJsAnyType());
    }

    private static final ExportedType exportTypeParameter$lambda$1(ExportModelGenerator this$0, IrType it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.exportType(it);
    }

    private static final boolean exportTypeParameter$lambda$2(ExportedType it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !(it instanceof ExportedType.ErrorType);
    }

    public static final /* synthetic */ Set access$getExcludedFromExport$p(ExportModelGenerator $this) {
        return $this.excludedFromExport;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.OBJECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.CLASS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClassKind.INTERFACE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

