/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentationProviders;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Attachment;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.ui.Queryable;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaParserFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiSyntheticClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypes;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.augment.PsiAugmentProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.CheckUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.ElementPresentationUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiClassImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiVariableEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiFieldStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiMemberStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.JavaStubPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.JavaResolveCache;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.search.SearchScope;
import org.jetbrains.kotlin.com.intellij.psi.stub.JavaStubImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.kotlin.com.intellij.ui.IconManager;
import org.jetbrains.kotlin.com.intellij.ui.PlatformIcons;
import org.jetbrains.kotlin.com.intellij.ui.icons.RowIcon;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class PsiFieldImpl
extends JavaStubPsiElement<PsiFieldStub>
implements Queryable,
PsiField,
PsiVariableEx {
    private static final Logger LOG = Logger.getInstance(PsiFieldImpl.class);
    private volatile Reference<PsiType> myCachedType;

    public PsiFieldImpl(PsiFieldStub stub) {
        this(stub, (IStubElementType)JavaStubElementTypes.FIELD);
    }

    protected PsiFieldImpl(PsiFieldStub stub, IStubElementType type2) {
        super(stub, type2);
    }

    public PsiFieldImpl(ASTNode node) {
        super(node);
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.dropCached();
    }

    private void dropCached() {
        this.myCachedType = null;
    }

    @Override
    protected Object clone() {
        PsiFieldImpl clone = (PsiFieldImpl)super.clone();
        clone.dropCached();
        return clone;
    }

    @Override
    public PsiClass getContainingClass() {
        PsiElement parent2 = this.getParent();
        return parent2 instanceof PsiClass ? (PsiClass)parent2 : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this, PsiSyntheticClass.class);
    }

    @Override
    public PsiElement getContext() {
        PsiClass cc = this.getContainingClass();
        return cc != null ? cc : super.getContext();
    }

    @Override
    @NotNull
    public CompositeElement getNode() {
        CompositeElement compositeElement = (CompositeElement)super.getNode();
        if (compositeElement == null) {
            PsiFieldImpl.$$$reportNull$$$0(0);
        }
        return compositeElement;
    }

    @Override
    @NotNull
    public PsiIdentifier getNameIdentifier() {
        PsiIdentifier psiIdentifier = (PsiIdentifier)this.getNode().findChildByRoleAsPsiElement(9);
        if (psiIdentifier == null) {
            PsiFieldImpl.$$$reportNull$$$0(1);
        }
        return psiIdentifier;
    }

    @Override
    @NotNull
    public String getName() {
        PsiFieldStub stub = (PsiFieldStub)this.getGreenStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                PsiFieldImpl.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = this.getNameIdentifier().getText();
        if (string == null) {
            PsiFieldImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            PsiFieldImpl.$$$reportNull$$$0(4);
        }
        PsiImplUtil.setName(this.getNameIdentifier(), name2);
        return this;
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiFieldStub stub = (PsiFieldStub)this.getStub();
        if (stub != null) {
            PsiType type2 = org.jetbrains.kotlin.com.intellij.reference.SoftReference.dereference(this.myCachedType);
            if (type2 == null) {
                type2 = JavaSharedImplUtil.createTypeFromStub(this, stub.getType());
                this.myCachedType = new SoftReference<PsiType>(type2);
            }
            PsiType psiType = type2;
            if (psiType == null) {
                PsiFieldImpl.$$$reportNull$$$0(5);
            }
            return psiType;
        }
        this.myCachedType = null;
        PsiTypeElement typeElement = this.getTypeElement();
        if (typeElement == null) {
            LOG.error("No type element found for field; children classes = " + StringUtil.join(this.getChildren(), e2 -> e2.getClass().getName(), ", "), new Attachment("tree.txt", DebugUtil.psiTreeToString(this, true)));
            PsiType psiType = PsiTypes.nullType();
            if (psiType == null) {
                PsiFieldImpl.$$$reportNull$$$0(6);
            }
            return psiType;
        }
        PsiType psiType = JavaSharedImplUtil.getType(typeElement, this.getNameIdentifier());
        if (psiType == null) {
            PsiFieldImpl.$$$reportNull$$$0(7);
        }
        return psiType;
    }

    @Override
    public PsiTypeElement getTypeElement() {
        PsiField firstField = this.findFirstFieldInDeclaration();
        if (firstField != this) {
            return firstField.getTypeElement();
        }
        return (PsiTypeElement)this.getNode().findChildByRoleAsPsiElement(10);
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList selfModifierList = this.getSelfModifierList();
        if (selfModifierList != null) {
            PsiModifierList psiModifierList = selfModifierList;
            if (psiModifierList == null) {
                PsiFieldImpl.$$$reportNull$$$0(8);
            }
            return psiModifierList;
        }
        PsiField firstField = this.findFirstFieldInDeclaration();
        if (firstField == this) {
            if (!this.isValid()) {
                throw new PsiInvalidElementAccessException(this);
            }
            PsiField lastResort = this.findFirstFieldByTree();
            if (lastResort == this) {
                throw new IllegalStateException("Missing modifier list for sequence of fields: '" + this.getText() + "'");
            }
            firstField = lastResort;
        }
        PsiModifierList psiModifierList = firstField.getModifierList();
        if (psiModifierList == null) {
            PsiFieldImpl.$$$reportNull$$$0(9);
        }
        return psiModifierList;
    }

    @Nullable
    private PsiModifierList getSelfModifierList() {
        return this.getStubOrPsiChild(JavaStubElementTypes.MODIFIER_LIST);
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name2) {
        if (name2 == null) {
            PsiFieldImpl.$$$reportNull$$$0(10);
        }
        return this.getModifierList().hasModifierProperty(name2);
    }

    private PsiField findFirstFieldInDeclaration() {
        if (this.getSelfModifierList() != null) {
            return this;
        }
        PsiFieldStub stub = (PsiFieldStub)this.getGreenStub();
        if (stub != null) {
            List<StubElement> siblings2 = stub.getParentStub().getChildrenStubs();
            int idx = siblings2.indexOf(stub);
            assert (idx >= 0);
            for (int i2 = idx - 1; i2 >= 0 && siblings2.get(i2) instanceof PsiFieldStub; --i2) {
                PsiFieldStub prevField = (PsiFieldStub)siblings2.get(i2);
                PsiFieldImpl prevFieldPsi = (PsiFieldImpl)prevField.getPsi();
                if (prevFieldPsi.getSelfModifierList() == null) continue;
                return prevFieldPsi;
            }
        }
        return this.findFirstFieldByTree();
    }

    private PsiField findFirstFieldByTree() {
        CompositeElement treeElement = this.getNode();
        ASTNode modifierList2 = treeElement.findChildByRole(8);
        if (modifierList2 == null) {
            ASTNode prevField;
            for (prevField = treeElement.getTreePrev(); prevField != null && prevField.getElementType() != JavaElementType.FIELD; prevField = prevField.getTreePrev()) {
            }
            if (prevField == null) {
                return this;
            }
            return ((PsiFieldImpl)SourceTreeToPsiMap.treeElementToPsi(prevField)).findFirstFieldInDeclaration();
        }
        return this;
    }

    @Override
    public PsiExpression getInitializer() {
        return (PsiExpression)this.getNode().findChildByRoleAsPsiElement(21);
    }

    @Nullable
    public static PsiExpression getDetachedInitializer(@NotNull PsiVariable variable) {
        if (variable == null) {
            PsiFieldImpl.$$$reportNull$$$0(11);
        }
        return variable instanceof PsiFieldImpl ? ((PsiFieldImpl)variable).getDetachedInitializer() : variable.getInitializer();
    }

    @Nullable
    private PsiExpression getDetachedInitializer() {
        PsiExpression initializer;
        PsiFieldStub stub = (PsiFieldStub)this.getGreenStub();
        if (stub == null) {
            initializer = this.getInitializer();
        } else {
            String initializerText = stub.getInitializerText();
            if (StringUtil.isEmpty(initializerText)) {
                return null;
            }
            if (";INITIALIZER_NOT_STORED;".equals(initializerText) || ";INITIALIZER_TOO_LONG;".equals(initializerText)) {
                initializer = this.getInitializer();
            } else {
                PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
                initializer = parserFacade.createExpressionFromText(initializerText, this);
                ((LightVirtualFile)initializer.getContainingFile().getViewProvider().getVirtualFile()).setWritable(false);
            }
        }
        return initializer;
    }

    @Override
    public boolean hasInitializer() {
        PsiFieldStub stub = (PsiFieldStub)this.getGreenStub();
        if (stub != null) {
            return stub.getInitializerText() != null;
        }
        return this.getInitializer() != null;
    }

    @Override
    public Icon getElementIcon(int flags) {
        IconManager iconManager = IconManager.getInstance();
        RowIcon baseIcon = iconManager.createLayeredIcon(this, this.getBaseIcon(), ElementPresentationUtil.getFlags(this, false));
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Override
    @NotNull
    protected Icon getBaseIcon() {
        IconManager iconManager = IconManager.getInstance();
        Icon icon = iconManager.getPlatformIcon(PlatformIcons.Field);
        if (icon == null) {
            PsiFieldImpl.$$$reportNull$$$0(12);
        }
        return icon;
    }

    @Nullable
    private Object _computeConstantValue(@Nullable Set<PsiVariable> visitedVars) {
        PsiType type2 = this.getType();
        if (!(type2 instanceof PsiPrimitiveType) && !type2.equalsToText("java.lang.String")) {
            return null;
        }
        PsiExpression initializer = this.getDetachedInitializer();
        if (initializer == null) {
            return null;
        }
        if (!PsiAugmentProvider.canTrustFieldInitializer(this)) {
            return null;
        }
        return PsiConstantEvaluationHelperImpl.computeCastTo(initializer, type2, visitedVars);
    }

    @Override
    public Object computeConstantValue() {
        return this.computeConstantValue(new HashSet<PsiVariable>(2));
    }

    @Override
    public Object computeConstantValue(Set<PsiVariable> visitedVars) {
        if (!this.hasModifierProperty("final")) {
            return null;
        }
        return JavaResolveCache.getInstance(this.getProject()).computeConstantValueWithCaching(this, OurConstValueComputer.INSTANCE, visitedVars);
    }

    @Override
    public boolean isDeprecated() {
        return JavaStubImplUtil.isMemberDeprecated(this, (PsiMemberStub)this.getGreenStub());
    }

    @Override
    public PsiDocComment getDocComment() {
        ASTNode prevField;
        PsiFieldStub stub = (PsiFieldStub)this.getGreenStub();
        if (stub != null && !stub.hasDocComment()) {
            return null;
        }
        CompositeElement treeElement = this.getNode();
        if (this.getTypeElement() != null) {
            PsiElement element = treeElement.findChildByRoleAsPsiElement(7);
            return element instanceof PsiDocComment ? (PsiDocComment)element : null;
        }
        for (prevField = treeElement.getTreePrev(); prevField != null && prevField.getElementType() != JavaElementType.FIELD; prevField = prevField.getTreePrev()) {
        }
        if (prevField == null) {
            return null;
        }
        return ((PsiField)SourceTreeToPsiMap.treeElementToPsi(prevField)).getDocComment();
    }

    @Override
    public void normalizeDeclaration() throws IncorrectOperationException {
        ASTNode nextField;
        ASTNode comma;
        CheckUtil.checkWritable(this);
        PsiTypeElement type2 = this.getTypeElement();
        PsiModifierList modifierList2 = this.getModifierList();
        ASTNode field = SourceTreeToPsiMap.psiElementToTree(type2.getParent());
        while ((comma = PsiImplUtil.skipWhitespaceAndComments(field.getTreeNext())) != null && comma.getElementType() == JavaTokenType.COMMA && (nextField = PsiImplUtil.skipWhitespaceAndComments(comma.getTreeNext())) != null && nextField.getElementType() == JavaElementType.FIELD) {
            LeafElement semicolon = Factory.createSingleLeafElement(JavaTokenType.SEMICOLON, ";", 0, 1, null, this.getManager());
            CodeEditUtil.addChild(field, semicolon, null);
            CodeEditUtil.removeChild(comma.getTreeParent(), comma);
            PsiElement typeClone = type2.copy();
            CodeEditUtil.addChild(nextField, SourceTreeToPsiMap.psiElementToTree(typeClone), nextField.getFirstChildNode());
            PsiElement modifierListClone = modifierList2.copy();
            CodeEditUtil.addChild(nextField, SourceTreeToPsiMap.psiElementToTree(modifierListClone), nextField.getFirstChildNode());
            field = nextField;
        }
        JavaSharedImplUtil.normalizeBrackets(this);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiFieldImpl.$$$reportNull$$$0(13);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitField(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            PsiFieldImpl.$$$reportNull$$$0(14);
        }
        if (state == null) {
            PsiFieldImpl.$$$reportNull$$$0(15);
        }
        if (place == null) {
            PsiFieldImpl.$$$reportNull$$$0(16);
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        return true;
    }

    @Override
    public String toString() {
        return "PsiField:" + this.getName();
    }

    @Override
    public PsiElement getOriginalElement() {
        PsiField originalField;
        PsiClass containingClass = this.getContainingClass();
        if (containingClass != null && (originalField = ((PsiClass)containingClass.getOriginalElement()).findFieldByName(this.getName(), false)) != null) {
            return originalField;
        }
        return this;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public void setInitializer(PsiExpression initializer) throws IncorrectOperationException {
        JavaSharedImplUtil.setInitializer(this, initializer);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isFieldEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiImplUtil.getMemberUseScope(this);
        if (searchScope == null) {
            PsiFieldImpl.$$$reportNull$$$0(17);
        }
        return searchScope;
    }

    @Override
    public void putInfo(@NotNull Map<? super String, ? super String> info) {
        if (info == null) {
            PsiFieldImpl.$$$reportNull$$$0(18);
        }
        info.put("fieldName", this.getName());
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiFieldImpl";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameIdentifier";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiFieldImpl";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifierList";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseIcon";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDetachedInitializer";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class OurConstValueComputer
    implements JavaResolveCache.ConstValueComputer {
        private static final OurConstValueComputer INSTANCE = new OurConstValueComputer();

        private OurConstValueComputer() {
        }

        @Override
        public Object execute(@NotNull PsiVariable variable, Set<PsiVariable> visitedVars) {
            if (variable == null) {
                OurConstValueComputer.$$$reportNull$$$0(0);
            }
            return ((PsiFieldImpl)variable)._computeConstantValue(visitedVars);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiFieldImpl$OurConstValueComputer", "execute"));
        }
    }
}

