/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.daemon.common.RemoteInputStream;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/daemon/RemoteInputStreamClient;", "Ljava/io/InputStream;", "remote", "Lorg/jetbrains/kotlin/daemon/common/RemoteInputStream;", "profiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "<init>", "(Lorg/jetbrains/kotlin/daemon/common/RemoteInputStream;Lorg/jetbrains/kotlin/daemon/common/Profiler;)V", "getRemote", "()Lorg/jetbrains/kotlin/daemon/common/RemoteInputStream;", "getProfiler", "()Lorg/jetbrains/kotlin/daemon/common/Profiler;", "read", "", "data", "", "offset", "length", "kotlin-daemon"})
@SourceDebugExtension(value={"SMAP\nRemoteInputStreamClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteInputStreamClient.kt\norg/jetbrains/kotlin/daemon/RemoteInputStreamClient\n+ 2 PerfUtils.kt\norg/jetbrains/kotlin/daemon/common/PerfUtilsKt\n*L\n1#1,39:1\n44#2,4:40\n44#2,4:44\n*S KotlinDebug\n*F\n+ 1 RemoteInputStreamClient.kt\norg/jetbrains/kotlin/daemon/RemoteInputStreamClient\n*L\n29#1:40,4\n37#1:44,4\n*E\n"})
public final class RemoteInputStreamClient
extends InputStream {
    @NotNull
    private final RemoteInputStream remote;
    @NotNull
    private final Profiler profiler;

    public RemoteInputStreamClient(@NotNull RemoteInputStream remote, @NotNull Profiler profiler) {
        Intrinsics.checkNotNullParameter(remote, "remote");
        Intrinsics.checkNotNullParameter(profiler, "profiler");
        this.remote = remote;
        this.profiler = profiler;
    }

    public /* synthetic */ RemoteInputStreamClient(RemoteInputStream remoteInputStream, Profiler profiler, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            profiler = new DummyProfiler();
        }
        this(remoteInputStream, profiler);
    }

    @NotNull
    public final RemoteInputStream getRemote() {
        return this.remote;
    }

    @NotNull
    public final Profiler getProfiler() {
        return this.profiler;
    }

    @Override
    public int read(@NotNull byte[] data2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        return this.read(data2, 0, data2.length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(@NotNull byte[] data2, int offset, int length) {
        boolean bl;
        void $this$withMeasure$iv;
        Intrinsics.checkNotNullParameter(data2, "data");
        Profiler profiler = this.profiler;
        RemoteInputStreamClient obj$iv = this;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(obj$iv);
        boolean bl2 = false;
        byte[] bytes = this.remote.read(length);
        boolean bl3 = bl = bytes.length <= length;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        System.arraycopy(bytes, 0, data2, offset, length);
        int res$iv = bytes.length;
        $this$withMeasure$iv.endMeasure(obj$iv, startState$iv);
        return res$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read() {
        void $this$withMeasure$iv;
        Profiler profiler = this.profiler;
        RemoteInputStreamClient obj$iv = this;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(obj$iv);
        boolean bl = false;
        int res$iv = this.remote.read();
        $this$withMeasure$iv.endMeasure(obj$iv, startState$iv);
        return res$iv;
    }
}

