/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.codec.png;

import io.sf.carte.echosvg.ext.awt.image.codec.png.PNGDecodeParam;
import io.sf.carte.echosvg.ext.awt.image.codec.png.PNGImage;
import io.sf.carte.echosvg.ext.awt.image.codec.util.ImageDecodeParam;
import io.sf.carte.echosvg.ext.awt.image.codec.util.ImageDecoderImpl;
import io.sf.carte.echosvg.ext.awt.image.codec.util.PropertyUtil;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;

public class PNGImageDecoder
extends ImageDecoderImpl {
    public PNGImageDecoder(InputStream input, PNGDecodeParam param) {
        super(input, (ImageDecodeParam)param);
    }

    @Override
    public void setParam(ImageDecodeParam param) {
        if (!(param instanceof PNGDecodeParam)) {
            throw new IllegalArgumentException("param must be a PNGDecodeParam.");
        }
        super.setParam(param);
    }

    @Override
    public PNGDecodeParam getParam() {
        return (PNGDecodeParam)super.getParam();
    }

    @Override
    public RenderedImage decodeAsRenderedImage(int page) throws IOException {
        if (page != 0) {
            throw new IOException(PropertyUtil.formatMessage("PNGImageDecoder.unknown.page", new Object[]{page}));
        }
        return new PNGImage(this.input, (PNGDecodeParam)this.param);
    }
}

