/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics;

import gov.nasa.giss.graphics.ColorTableFactory;
import gov.nasa.giss.util.reslist.ResourceListEntry;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ColorTableResourceListEntry
extends ResourceListEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ColorTableResourceListEntry(ResourceListEntry.LocType loctype, Object link, Object item) {
        super(loctype, link, item);
    }

    @Override
    protected void load(File f) {
        LOGGER.debug("file {}", (Object)this.getName());
        if (this.isInvalid()) {
            LOGGER.warn("Previous attempt to load resource " + this.getName() + " failed; skipping");
            return;
        }
        try {
            this.item_ = ColorTableFactory.open(f);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not load color table resource {}, {}", (Object)f, (Object)exc.toString());
            this.setInvalid();
        }
    }

    @Override
    protected void load(URL url) {
        LOGGER.debug("url {}", (Object)this.getName());
        if (this.isInvalid()) {
            LOGGER.warn("Previous attempt to load resource " + this.getName() + " failed; skipping");
            return;
        }
        try {
            this.item_ = ColorTableFactory.open(url);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not load color table resource {}, {}", (Object)url, (Object)exc.toString());
            this.setInvalid();
        }
    }
}

