/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics;

import java.awt.GraphicsEnvironment;
import java.util.Objects;

public final class FontUtils {
    private static String[] fnames_;

    public static boolean isFontFamilyAvailable(String name) {
        Objects.requireNonNull(name, "Family name cannot be null.");
        if (fnames_ == null) {
            GraphicsEnvironment g = GraphicsEnvironment.getLocalGraphicsEnvironment();
            fnames_ = g.getAvailableFontFamilyNames();
        }
        for (String f : fnames_) {
            if (!f.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private FontUtils() {
    }
}

