/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.map.proj.QuadSymmetricProjection;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class GlobalCylindric
extends QuadSymmetricProjection {
    public static final int PROPERTIES = 4;

    protected GlobalCylindric(String name, int properties, int width, int height, int xmargin, int ymargin, double widthFactor, double heightFactor) {
        super(name, properties, width, height, xmargin, ymargin, widthFactor, heightFactor);
    }

    @Override
    public boolean canLabelGrid() {
        return true;
    }

    @Override
    public boolean canPruneMeridians() {
        return false;
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        ProjGraphicUtils.drawRectBorder(g2d, this.outCenterX_ - this.dxMax_, this.outCenterY_ - this.dyMax_, 2.0 * (double)this.dxMax_, 2.0 * (double)this.dyMax_);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        Point2D.Double dot1 = this.transformLL2XY(this.lambdaC_ - 179.99999, lat);
        Point2D.Double dot2 = this.transformLL2XY(this.lambdaC_ + 179.99999, lat);
        if (dot1 == null || dot2 == null) {
            return;
        }
        if (label == null || label.length() == 0) {
            GraphicUtils.drawLine(g2d, dot1, dot2);
            return;
        }
        FontMetrics fm = g2d.getFontMetrics();
        int w = fm.stringWidth(label);
        int des = fm.getDescent();
        int fh = fm.getHeight();
        int fh2 = fh / 2;
        int fh4 = fh / 4;
        float labelx = (float)(dot2.x - (double)fh2 - (double)w);
        g2d.drawString(label, labelx, (float)(dot1.y + (double)fh2 - (double)((float)des * 0.5f)));
        Graphics2D g2x = (Graphics2D)g2d.create();
        Shape oldclip = g2x.getClip();
        if (oldclip == null) {
            oldclip = this.getMarginRectClose();
        }
        Rectangle2D.Double textRect = new Rectangle2D.Double(labelx - (float)fh4, dot1.y - (double)fh2, w + fh2, fh);
        Area clipArea = new Area(oldclip);
        Area textArea = new Area(textRect);
        clipArea.subtract(textArea);
        g2x.setClip(clipArea);
        GraphicUtils.drawLine(g2x, dot1, dot2);
        g2x.dispose();
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        double dlon = MapUtils.normalize360(lon - this.lambdaC_);
        if (Math.abs(dlon - 180.0) < 1.0E-5) {
            return;
        }
        Point2D.Double dotLabel = this.transformLL2XY(lon, -67.0);
        if (dotLabel == null) {
            return;
        }
        Point2D.Double dotN = this.transformLL2XY(lon, maxLat);
        Point2D.Double dotS = this.transformLL2XY(lon, -maxLat);
        if (dotN == null || dotS == null) {
            return;
        }
        if (label == null || label.length() == 0) {
            GraphicUtils.drawLine(g2d, dotN, dotS);
            return;
        }
        FontMetrics fm = g2d.getFontMetrics();
        int w = fm.stringWidth(label);
        int des = fm.getDescent();
        int fh = fm.getHeight();
        int fh2 = fh / 2;
        int fh4 = fh / 4;
        float labelx = (float)(dotLabel.x - 0.5 * (double)w);
        g2d.drawString(label, labelx, (float)(dotLabel.y - (double)des));
        Graphics2D g2x = (Graphics2D)g2d.create();
        Shape oldclip = g2x.getClip();
        if (oldclip == null) {
            oldclip = this.getMarginRectClose();
        }
        Rectangle2D.Double textRect = new Rectangle2D.Double(labelx - (float)fh4, dotLabel.y - (double)fh, w + fh2, fh);
        Area clipArea = new Area(oldclip);
        Area textArea = new Area(textRect);
        clipArea.subtract(textArea);
        g2x.setClip(clipArea);
        GraphicUtils.drawLine(g2x, dotN, dotS);
        g2x.dispose();
    }
}

