/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.about;

import gov.nasa.giss.panoply.action.PanShowHelpPageAction;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.ui.ClickableLinkMouseListener;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.ScaledIconComponent;
import gov.nasa.giss.ui.label.MultiLineLabel;
import gov.nasa.giss.util.PlatformUtils;
import gov.nasa.giss.util.PropertyList;
import java.awt.Color;
import java.awt.Font;
import java.lang.invoke.MethodHandles;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanAboutFrame
extends PanFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final PropertyList ABOUT_PROPS = PanProperties.ABOUT_PROPS;
    private static final PropertyList VERSION_PROPS = PanProperties.VERSION_PROPS;
    private boolean launched_;

    public static synchronized PanAboutFrame getSharedInstance() {
        return Singleton.INSTANCE;
    }

    private PanAboutFrame() {
        this.setTitle(ABOUT_PROPS.getString("about-title"));
        this.setName(this.getTitle());
        this.setResizable(false);
        this.setUndecorated(true);
        this.createLayout();
        this.placeOnScreen();
    }

    private void createLayout() {
        Font lfont = UIManager.getDefaults().getFont("Label.font");
        Font plain10 = lfont.deriveFont(0, 10.0f);
        Font plain12 = lfont.deriveFont(0, 12.0f);
        Font plain16 = lfont.deriveFont(0, 16.0f);
        Font plain18 = lfont.deriveFont(0, 18.0f);
        Font plain32 = lfont.deriveFont(0, 32.0f);
        ScaledIconComponent iconComp = null;
        try {
            ImageIcon icon = new ImageIcon(this.getClass().getResource("panoply_320x320.png"));
            iconComp = new ScaledIconComponent(icon, 0.5f);
        }
        catch (Exception exc) {
            LOGGER.warn("Could not load splash icon: {}", (Object)exc.toString());
        }
        JLabel titleLabel = new JLabel(VERSION_PROPS.getString("application-name"), 0);
        JLabel versionLabel = new JLabel(VERSION_PROPS.getString("version-word") + " " + VERSION_PROPS.getString("version"), 0);
        JLabel buildLabel = new JLabel(VERSION_PROPS.getString("build-word") + " " + VERSION_PROPS.getString("build-id") + " \u2014 " + VERSION_PROPS.getString("build-date"), 0);
        JLabel gissLabel = new JLabel("NASA/GISS", 0);
        MultiLineLabel addressLabel = new MultiLineLabel(ABOUT_PROPS.getString("address"), 0);
        MultiLineLabel creditsLabel = new MultiLineLabel(ABOUT_PROPS.getString("credits"), 0);
        StringBuilder osJavaSB = new StringBuilder(System.getProperty("os.name")).append(' ').append(System.getProperty("os.version")).append(" (").append(System.getProperty("os.arch")).append(") \u2014 Java ").append(System.getProperty("java.version"));
        JLabel osJavaLabal = new JLabel(osJavaSB.toString(), 0);
        JLabel memLabel = new JLabel("Max memory " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + " MiB", 0);
        Box leftBox = Box.createVerticalBox();
        if (iconComp != null) {
            leftBox.add(iconComp);
        }
        Box rightBox = Box.createVerticalBox();
        rightBox.add(Box.createVerticalGlue());
        rightBox.add(titleLabel);
        rightBox.add(Box.createVerticalStrut(12));
        rightBox.add(versionLabel);
        rightBox.add(Box.createVerticalStrut(4));
        rightBox.add(buildLabel);
        rightBox.add(Box.createVerticalStrut(12));
        rightBox.add(gissLabel);
        rightBox.add(Box.createVerticalStrut(4));
        rightBox.add(addressLabel);
        rightBox.add(Box.createVerticalStrut(12));
        rightBox.add(creditsLabel);
        rightBox.add(Box.createVerticalStrut(12));
        rightBox.add(osJavaLabal);
        rightBox.add(memLabel);
        rightBox.add(Box.createVerticalGlue());
        if (PlatformUtils.isMacintoshDarkMode()) {
            GuiUtils.applyHudUI(rightBox);
        } else if (PlatformUtils.isMacintosh()) {
            GuiUtils.applyEmphasizedUI(rightBox);
        }
        titleLabel.setOpaque(false);
        versionLabel.setOpaque(false);
        gissLabel.setOpaque(false);
        addressLabel.setOpaque(false);
        creditsLabel.setOpaque(false);
        osJavaLabal.setOpaque(false);
        memLabel.setOpaque(false);
        titleLabel.setFont(plain32);
        versionLabel.setFont(plain16);
        buildLabel.setFont(plain10);
        gissLabel.setFont(plain18);
        addressLabel.setFont(plain12);
        creditsLabel.setFont(plain12);
        osJavaLabal.setFont(plain10);
        memLabel.setFont(plain10);
        titleLabel.setAlignmentX(0.5f);
        versionLabel.setAlignmentX(0.5f);
        buildLabel.setAlignmentX(0.5f);
        gissLabel.setAlignmentX(0.5f);
        addressLabel.setAlignmentX(0.5f);
        creditsLabel.setAlignmentX(0.5f);
        osJavaLabal.setAlignmentX(0.5f);
        memLabel.setAlignmentX(0.5f);
        Box contentBox = new Box(0);
        if (iconComp != null) {
            contentBox.add(iconComp);
            contentBox.add(Box.createHorizontalStrut(32));
        }
        contentBox.add(rightBox);
        contentBox.setOpaque(true);
        Border innerBorder = BorderFactory.createEmptyBorder(19, 19, 19, 19);
        if (PlatformUtils.isMacintoshDarkMode()) {
            contentBox.setBackground(new Color(50, 52, 57));
            contentBox.setBorder(new CompoundBorder(BorderFactory.createLineBorder(Color.GRAY, 1), innerBorder));
        } else {
            contentBox.setBackground(new Color(250, 250, 250));
            contentBox.setBorder(new CompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1), innerBorder));
        }
        this.getContentPane().add(contentBox);
        this.pack();
        gissLabel.addMouseListener(new ClickableLinkMouseListener(ABOUT_PROPS.getString("giss-url")));
        creditsLabel.addMouseListener(new PanShowHelpPageAction(ABOUT_PROPS.getString("credits-url")));
    }

    public void setLaunched(boolean launched) {
        this.launched_ = launched;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && this.launched_ && this.getPanMenuBar() == null) {
            this.setPanMenuBar(new PanMenuBar(this));
            this.pack();
        }
        super.setVisible(visible);
    }

    private static class Singleton {
        private static final PanAboutFrame INSTANCE = new PanAboutFrame();

        private Singleton() {
        }
    }
}

