/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.panoply.dialog.PanExportKmzDialog;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.task.PanExportKmzTask;
import gov.nasa.giss.panoply.util.PanExportKmlOption;
import gov.nasa.giss.panoply.util.PanProperties;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanExportKmzAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String KMZ_EXT = "kmz";
    private static final String ACTION_NAME = PanProperties.MENU_PROPS.getString("export-kmz");
    private final PanPlotFrame parent_;
    private String fnameRoot_;

    public PanExportKmzAction(PanPlotFrame parent) {
        super(ACTION_NAME);
        this.parent_ = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File file;
        PanExportKmzDialog dlog = new PanExportKmzDialog(this.parent_);
        dlog.setVisible(true);
        if (!dlog.isSuccessful()) {
            this.showWindoids();
            return;
        }
        if (this.fnameRoot_ == null) {
            this.fnameRoot_ = this.parent_.getTitle();
        }
        if ((file = PanFileUtils.showSingleTypeSaveFileChooser(this.parent_, "Export as\u2026", this.fnameRoot_, KMZ_EXT)) == null) {
            this.showWindoids();
            return;
        }
        this.fnameRoot_ = FileUtils.extractFnameRoot(file);
        Hashtable<PanExportKmlOption, Object> opts = dlog.getOptions();
        PanExportKmzTask exportTask = new PanExportKmzTask(this.parent_, file, opts);
        this.parent_.addTask(exportTask);
    }

    private void showWindoids() {
        EventQueue.invokeLater(() -> this.parent_.setWindoidsVisible(true));
    }
}

