/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.panoply.action.PanPlotZoomInAction;
import gov.nasa.giss.panoply.action.PanPlotZoomOutAction;
import gov.nasa.giss.panoply.action.PanPlotZoomResetAction;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanCommonXAxisControls;
import gov.nasa.giss.panoply.plotui.PanCommonYAxisControls;
import gov.nasa.giss.panoply.plotui.PanGridControls;
import gov.nasa.giss.panoply.ui.PanCheckBox;
import gov.nasa.giss.panoply.ui.PanGuiUtils;
import gov.nasa.giss.panoply.ui.PanIntSpinner;
import gov.nasa.giss.panoply.util.PanAxisTickColor;
import gov.nasa.giss.panoply.util.PanStrokePattern;
import gov.nasa.giss.ui.DescribedEnumComboBox;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.color.ColorComboBox;
import gov.nasa.giss.ui.menu.GissMenu;
import gov.nasa.giss.ui.panel.PanelSection;
import java.awt.Color;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanGridControlsCC
extends PanGridControls {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PanCommonXAxisControls xaxisCtrls_;
    private PanCommonYAxisControls yaxisCtrls_;
    private DescribedEnumComboBox gridStyleCombo_;
    private ColorComboBox gridColorCombo_;
    private PanIntSpinner gridWeightSpinner_;
    private PanCheckBox axesOffsetCB_;
    private PanIntSpinner tickWeightSpinner_;
    private DescribedEnumComboBox tickColorCombo_;
    private boolean refreshing_;

    public PanGridControlsCC(PanPlotMeta pmeta, PanMenuBar mbar) {
        super(pmeta, mbar);
        this.createActions(mbar);
        this.createLayout();
        this.refreshPrivate();
        this.attachListeners();
    }

    private void createActions(PanMenuBar mbar) {
        GissMenu plotMenu = mbar.getMenuForName("plot-menu");
        AbstractAction a = new PanPlotZoomResetAction(this);
        this.pmeta_.putAction("reset-bounds", a);
        plotMenu.getItemForName("reset-bounds").setAction(a);
        a = new PanPlotZoomInAction(this);
        this.pmeta_.putAction("zoom-plot-in", a);
        plotMenu.getItemForName("zoom-plot-in").setAction(a);
        a = new PanPlotZoomOutAction(this);
        this.pmeta_.putAction("zoom-plot-out", a);
        plotMenu.getItemForName("zoom-plot-out").setAction(a);
    }

    private void createLayout() {
        switch (this.ptype_) {
            case LAT_VERT: 
            case LON_VERT: 
            case LAT_TIME: 
            case LON_TIME: 
            case TIME_LAT: 
            case TIME_VERT: 
            case GENERAL_CC: {
                this.xaxisCtrls_ = new PanCommonXAxisControls(this.pmeta_, this.mbar_);
                this.yaxisCtrls_ = new PanCommonYAxisControls(this.pmeta_, this.mbar_);
                break;
            }
            default: {
                LOGGER.error("I cannot create axes grid controls for {}.", (Object)this.ptype_);
                LOGGER.error("Does not look like a 2D contour color plot type.");
            }
        }
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.createTopBox());
        this.add(new PanelSection("X Axis", this.xaxisCtrls_));
        this.add(new PanelSection("Y Axis", this.yaxisCtrls_));
    }

    private JPanel createTopBox() {
        JLabel label11 = new JLabel("Stroke:\u2009");
        this.gridStyleCombo_ = new DescribedEnumComboBox(PanStrokePattern.class);
        this.gridStyleCombo_.setName("grid.style");
        JLabel gColorLabel = new JLabel("\u2014 Color:\u2009");
        this.gridColorCombo_ = new ColorComboBox();
        this.gridColorCombo_.setName("grid.color");
        JLabel gWeightLabel = new JLabel("\u2014 Weight:\u2009");
        this.gridWeightSpinner_ = PanIntSpinner.smallWeight("grid.weight", this.pmeta_.getInt("grid.weight"), 0, 200);
        JLabel gPctLabel = new JLabel("%");
        QuickBox line1 = QuickBox.createLeftBox(label11, this.gridStyleCombo_, gColorLabel, this.gridColorCombo_, gWeightLabel, this.gridWeightSpinner_, gPctLabel);
        JLabel label21 = new JLabel(" ");
        this.axesOffsetCB_ = PanCheckBox.create("axes.offset", "Offset axes from grid edges", this.pmeta_.getBoolean("axes.offset"));
        QuickBox line2 = QuickBox.createLeftBox(label21, this.axesOffsetCB_);
        JLabel label31 = new JLabel("Ticks: ");
        JLabel tickColorLabel = new JLabel("Color:\u2009");
        this.tickColorCombo_ = new DescribedEnumComboBox(PanAxisTickColor.class);
        this.tickColorCombo_.setName("axes.tickmark.color");
        JLabel tickWeightLabel = new JLabel("\u2014 Weight");
        this.tickWeightSpinner_ = PanIntSpinner.smallWeight("axes.tickmark.weight", this.pmeta_.getInt("axes.tickmark.weight"), 25, 200);
        JLabel tickPctLabel = new JLabel("%");
        QuickBox line3 = QuickBox.createLeftBox(label31, tickColorLabel, this.tickColorCombo_, tickWeightLabel, this.tickWeightSpinner_, tickPctLabel);
        GuiUtils.matchLabelWidths(label11, label21, label31);
        JPanel jp = new JPanel();
        jp.setLayout(new BoxLayout(jp, 1));
        jp.setBorder(PanGuiUtils.WINDOID_SECT_BORDER);
        jp.setOpaque(false);
        jp.add(line1);
        jp.add(Box.createVerticalStrut(1));
        jp.add(line2);
        jp.add(Box.createVerticalStrut(1));
        jp.add(line3);
        GuiUtils.setSizeSmall(jp);
        return jp;
    }

    private void attachListeners() {
        this.gridStyleCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.put("grid.style", (Object)this.gridStyleCombo_.getEnumName());
        });
        this.gridColorCombo_.addItemListener(e -> {
            Color cold;
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            Color cnew = this.gridColorCombo_.getSelectedColor();
            if (!cnew.equals(cold = this.pmeta_.getColor("grid.color"))) {
                this.pmeta_.setColor("grid.color", cnew);
            }
        });
        this.gridWeightSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setInt("grid.weight", this.gridWeightSpinner_.getIntValue());
        });
        this.axesOffsetCB_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            boolean checked = this.axesOffsetCB_.isSelected();
            this.pmeta_.setBoolean("axes.offset", checked);
            this.tickColorCombo_.setEnabled(!checked);
            this.tickWeightSpinner_.setEnabled(!checked);
        });
        this.tickColorCombo_.addItemListener(e -> {
            if (this.refreshing_) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            this.pmeta_.put("axes.tickmark.color", (Object)this.tickColorCombo_.getEnumName());
        });
        this.tickWeightSpinner_.addChangeListener(e -> {
            if (this.refreshing_) {
                return;
            }
            this.pmeta_.setInt("axes.tickmark.weight", this.tickWeightSpinner_.getIntValue());
        });
    }

    @Override
    public void refreshZoomEnabling() {
    }

    @Override
    public void recenter(double x, double y) {
        this.xaxisCtrls_.recenter(x);
        this.yaxisCtrls_.recenter(y);
    }

    @Override
    public void zoomIn() {
        this.zoom(1.5);
    }

    @Override
    public void zoomOut() {
        this.zoom(0.6666666666666666);
    }

    @Override
    public void zoomIn(double centerx, double centery) {
        this.zoom(1.5, centerx, centery);
    }

    @Override
    public void zoomOut(double centerx, double centery) {
        this.zoom(0.6666666666666666, centerx, centery);
    }

    @Override
    public void zoom(double factor) {
        this.xaxisCtrls_.zoom(factor);
        this.yaxisCtrls_.zoom(factor);
    }

    @Override
    public void zoom(double factor, double centerx, double centery) {
        this.xaxisCtrls_.zoom(factor, centerx);
        this.yaxisCtrls_.zoom(factor, centery);
    }

    @Override
    public void dragZoom(double centerx, double centery, double leftx, double topy, double rightx, double bottomy) {
        this.xaxisCtrls_.setAxisBounds(leftx, rightx);
        this.yaxisCtrls_.setAxisBounds(bottomy, topy);
    }

    @Override
    public void resetGridBounds() {
        this.xaxisCtrls_.resetAxisBounds();
        this.yaxisCtrls_.resetAxisBounds();
    }

    @Override
    public void refresh() {
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        this.gridStyleCombo_.setSelItemMatching(this.pmeta_.getString("grid.style"));
        this.gridColorCombo_.setSelectedColor(this.pmeta_.getColor("grid.color"));
        this.gridWeightSpinner_.setValue(this.pmeta_.getInt("grid.weight"));
        this.axesOffsetCB_.setSelected(this.pmeta_.getBoolean("axes.offset"));
        this.tickColorCombo_.setEnabled(!this.axesOffsetCB_.isSelected());
        this.tickColorCombo_.setSelItemMatching(this.pmeta_.getString("axes.tickmark.color"));
        this.tickWeightSpinner_.setEnabled(!this.axesOffsetCB_.isSelected());
        this.refreshing_ = false;
    }
}

