/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.data.nc.NcConfig;
import gov.nasa.giss.data.nc.NcUnitUtils;
import gov.nasa.giss.panoply.authentication.PanCredentialsProvider;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.util.PlatformUtils;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanNcUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static synchronized void initNetcdf(Hashtable<Key, Object> opts) {
        boolean isDesktop;
        PanPreferences prefs;
        block14: {
            LOGGER.trace("");
            prefs = PanPreferences.getSharedInstance();
            if (opts.containsKey((Object)Key.DEVO_MODE) && ((Boolean)opts.get((Object)Key.DEVO_MODE)).booleanValue()) {
                LOGGER.trace("Set NcConfig devo");
                NcConfig.setDevo();
            }
            NcConfig.disableRemotePreload();
            boolean serverMode = opts.containsKey((Object)Key.SERVER_MODE) && (Boolean)opts.get((Object)Key.SERVER_MODE) != false;
            boolean headless = opts.containsKey((Object)Key.HEADLESS) && (Boolean)opts.get((Object)Key.HEADLESS) != false || PlatformUtils.isHeadless();
            isDesktop = !serverMode && !headless;
            PanCredentialsProvider pam = isDesktop ? new PanCredentialsProvider() : null;
            NcConfig.initHttpClient(System.getProperty("http.agent"), pam);
            try {
                NcConfig.initCache("Panoply", "gov.nasa.giss");
            }
            catch (Exception exc) {
                LOGGER.warn("Unable to access cache directory.");
                LOGGER.warn("This could be because your process does not have write access to cache location.");
            }
            boolean loadNjConfig = false;
            loadNjConfig = opts.containsKey((Object)Key.LOAD_NJCONFIG) ? ((Boolean)opts.get((Object)Key.LOAD_NJCONFIG)).booleanValue() : prefs.getBoolean("files:load-njconfig");
            if (loadNjConfig) {
                boolean configRead = false;
                try {
                    configRead = NcConfig.readNj22Config();
                    if (configRead) {
                        LOGGER.info("Successfully read NJ config file");
                    } else {
                        LOGGER.info("Could not read NJ config file; possibly it doesn't exist");
                    }
                }
                catch (Exception exc) {
                    LOGGER.warn("Unable to read NJ config file: {}", (Object)exc.getMessage());
                }
                if (configRead) {
                    try {
                        boolean success = NcConfig.isCLibraryPresent();
                        LOGGER.trace("netCDF-C library loaded, {}", (Object)success);
                    }
                    catch (Error err) {
                        LOGGER.warn("Err loading netCDF-C library, {}", (Object)err.getMessage());
                        if (!LOGGER.isTraceEnabled()) break block14;
                        err.printStackTrace();
                    }
                }
            }
        }
        boolean gribStrict = true;
        gribStrict = opts.containsKey((Object)Key.GRIB1_STRICT) ? ((Boolean)opts.get((Object)Key.GRIB1_STRICT)).booleanValue() : prefs.getBoolean("files:grib1-strict");
        try {
            NcConfig.initGribHandling(gribStrict);
        }
        catch (Exception exc) {
            LOGGER.warn("Unable to initialize GRIB handling.");
            LOGGER.debug("There could be errors if you are working with GRIB data and your");
            LOGGER.debug("process does not have write access to disk.");
        }
        boolean showInvalidVals = false;
        showInvalidVals = opts.containsKey((Object)Key.SHOW_INVALID_VALS) ? ((Boolean)opts.get((Object)Key.SHOW_INVALID_VALS)).booleanValue() : prefs.getBoolean("files:show-invalid-vals");
        NcConfig.showInvalidValues(showInvalidVals);
        if (isDesktop) {
            PanNcUtils.updateAltUnits();
        }
    }

    public static void updateAltUnits() {
        PanPreferences prefs = PanPreferences.getSharedInstance();
        NcUnitUtils.setAltEnabled(true);
        if (prefs.getBoolean("units:c_is_celsius")) {
            NcUnitUtils.addAlternative("C", "celsius");
        } else {
            NcUnitUtils.removeAlternative("C");
        }
        if (prefs.getBoolean("units:mb_is_millibar")) {
            NcUnitUtils.addAlternative("mb", "millibar");
        } else {
            NcUnitUtils.removeAlternative("mb");
        }
        if (prefs.getBoolean("units:fraction_is_percent")) {
            NcUnitUtils.addAlternative("fraction", "percent");
        } else {
            NcUnitUtils.removeAlternative("fraction");
        }
    }

    private PanNcUtils() {
    }

    public static enum Key {
        DEVO_MODE("DevoMode"),
        HEADLESS("Headless"),
        SERVER_MODE("ServerMode"),
        LOAD_NJCONFIG("LoadNjConfig"),
        GRIB1_STRICT("Grib1Strict"),
        SHOW_INVALID_VALS("ShowInvalidVals");


        private Key(String value) {
        }
    }
}

