/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.panel;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.panel.PseudoPalette;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class HudPseudoPalette
extends PseudoPalette {
    private static final Color BACKGROUND = new Color(0, 0, 0, 204);
    private static final Color HIGHLIGHT = new Color(255, 255, 255, 59);
    private static final Color HIGHLIGHT_BOTTOM = new Color(255, 255, 255, 25);
    private static final Color TOP_BACKGROUND_TOP = new Color(255, 255, 255, 59);
    private static final Color TOP_BACKGROUND_MIDDLE = new Color(196, 196, 196, 59);
    private static final Color BOTTOM_BACKGROUND = new Color(255, 255, 255, 30);
    private static final int TITLE_HEIGHT = 22;
    private static final int CORNER_DIAMETER = 16;
    private String title_;
    private int titleWidth_;
    private int lineHeight_;
    private int lineAscent_;
    private boolean expanded_ = true;
    private Border innerBorder_;
    private final Border outerBorder_;

    public HudPseudoPalette() {
        this.setTitle("HudPseudoPalette");
        this.setOpaque(false);
        this.setFont(UIManager.getDefaults().getFont("Label.font"));
        this.setBorder(null);
        this.outerBorder_ = BorderFactory.createEmptyBorder(26, 4, 4, 4);
        this.setInnerBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    public final void setInnerBorder(Border b) {
        this.innerBorder_ = b;
        super.setBorder(BorderFactory.createCompoundBorder(this.outerBorder_, this.innerBorder_));
    }

    public Border getInnerBorder() {
        return this.innerBorder_;
    }

    @Override
    protected void paintBorder(Graphics g) {
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        int w = this.getWidth();
        int h = this.getHeight();
        GradientPaint paint = new GradientPaint(0.0f, 0.0f, HIGHLIGHT, 0.0f, h, HIGHLIGHT_BOTTOM);
        g2d.setPaint(paint);
        g2d.drawRoundRect(0, 0, w - 1, h - 1, 16, 16);
        g2d.dispose();
        super.paintBorder(g);
    }

    @Override
    public void paintChildren(Graphics g) {
        if (!this.expanded_) {
            return;
        }
        super.paintChildren(g);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        int w = this.getWidth();
        int h = this.getHeight();
        g2d.setColor(BACKGROUND);
        g2d.fillRoundRect(0, 0, w, h, 16, 16);
        if (GuiUtils.isParentWindowFocused(this) && this.getParent().getComponentZOrder(this) == 0) {
            Area titleBottom;
            Area titleRoundRect = new Area(new RoundRectangle2D.Double(0.0, 0.0, w, 22.0, 16.0, 16.0));
            Area titleTopRect = new Area(new Rectangle(0, 0, w, 11));
            Area titleBottomRect = new Area(new Rectangle(0, 11, w, 11));
            Area titleTop = (Area)titleRoundRect.clone();
            titleTop.subtract(titleBottomRect);
            if (this.expanded_) {
                titleBottom = titleBottomRect;
            } else {
                titleBottom = (Area)titleRoundRect.clone();
                titleBottom.subtract(titleTopRect);
            }
            GradientPaint paint = new GradientPaint(0.0f, 0.0f, TOP_BACKGROUND_TOP, 0.0f, 11.0f, TOP_BACKGROUND_MIDDLE);
            g2d.setPaint(paint);
            g2d.fill(titleTop);
            g2d.setColor(BOTTOM_BACKGROUND);
            g2d.fill(titleBottom);
            g2d.setColor(HIGHLIGHT_BOTTOM);
        } else {
            g2d.setColor(HIGHLIGHT);
        }
        g2d.drawLine(0, 21, w, 21);
        if (this.titleWidth_ > 0) {
            int x = Math.max(0, (w - this.titleWidth_) / 2);
            int y = (22 - this.lineHeight_) / 2 + this.lineAscent_;
            g2d.setColor(Color.WHITE);
            g2d.drawString(this.title_, x, y);
        }
        g2d.dispose();
    }
}

