/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.tabbedpane;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.ui.BrushMetalUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.border.FocusStateMatteBorder;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderTabbedPane
extends JComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Color PANE_TOP_COLOR = new Color(237, 237, 237);
    private static final Color PANE_BOTTOM_COLOR = new Color(230, 230, 230);
    private static final Color SELECTED_TAB_TOP = new Color(248, 248, 248);
    private static final Color SELECTED_TAB_BOTTOM = PANE_TOP_COLOR;
    private static final Color UNSELECTED_TAB_TOP = new Color(228, 228, 228);
    private static final Color UNSELECTED_TAB_BOTTOM = new Color(220, 220, 220);
    private static final Color FOCUSED_TEXT_COLOR = Color.BLACK;
    private static final Color UNFOCUSED_TEXT_COLOR = new Color(58, 58, 58);
    private static final Color TEXT_EMPHASIS_COLOR = new Color(255, 255, 255, 110);
    private static final Color FOCUSED_SHADOW_COLOR = BrushMetalUtils.getShadowColor(true);
    private static final Color UNFOCUSED_SHADOW_COLOR = BrushMetalUtils.getShadowColor(false);
    private static final Color HIGHLIGHT_COLOR = BrushMetalUtils.getHighlightColor();
    private static final int TAB_BAR_HEIGHT = 24;
    private final DefaultSingleSelectionModel model_;
    private final ArrayList<TabPage> tabPages_;
    private Border innerBorder_;
    private Font buttonFont_;
    private int pressedIndex_ = -1;
    private boolean tooManyTabs_;
    private int firstVisibleTab_ = -1;
    private int lastVisibleTab_ = -1;
    private boolean fixedButtonWidth_ = true;
    private boolean backgroundIsDraggable_;

    public FolderTabbedPane() {
        if (PlatformUtils.isMacintosh()) {
            this.setOpaque(false);
        } else {
            this.setOpaque(true);
            Color cc = UIManager.getColor("Panel.background");
            if (cc == null) {
                cc = new Color(240, 240, 240);
            }
            this.setBackground(cc);
        }
        this.model_ = new DefaultSingleSelectionModel();
        this.model_.addChangeListener(new ModelListener());
        this.tabPages_ = new ArrayList(20);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setInnerBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        TabMouseListener ml = new TabMouseListener();
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
        this.buttonFont_ = UIManager.getDefaults().getFont("Label.font").deriveFont(1, 11.0f);
    }

    public boolean isBackgroundDraggable() {
        return this.backgroundIsDraggable_;
    }

    public void setBackgroundDraggable(boolean draggable) {
        this.backgroundIsDraggable_ = draggable;
    }

    public void setLowerBorder(boolean on) {
        if (on) {
            Color focusedColor = BrushMetalUtils.getShadowColor(true);
            Color unfocusedColor = BrushMetalUtils.getShadowColor(false);
            FocusStateMatteBorder fsmb = new FocusStateMatteBorder(0, 0, 1, 0, focusedColor, unfocusedColor);
            this.setBorder(fsmb);
        } else {
            this.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    @Override
    public Font getFont() {
        return this.buttonFont_;
    }

    @Override
    public void setFont(Font f) {
        this.buttonFont_ = f;
    }

    public final Border getInnerBorder() {
        return this.innerBorder_;
    }

    public final void setInnerBorder(Border border) {
        this.innerBorder_ = border;
    }

    public boolean getFixedButtonWidth() {
        return this.fixedButtonWidth_;
    }

    public void setFixedButtonWidth(boolean fixed) {
        this.fixedButtonWidth_ = fixed;
        this.repaint();
    }

    public int getTabCount() {
        return this.tabPages_.size();
    }

    @Override
    public Component add(Component c) {
        this.add(c, this.tabPages_.size());
        return c;
    }

    @Override
    public Component add(Component c, int index) {
        this.insertTab(c.getName(), null, c, null, index);
        return c;
    }

    @Override
    public Component add(String title, Component c) {
        this.insertTab(title, null, c, null, this.tabPages_.size());
        return c;
    }

    public void addTab(String title, Component c) {
        this.insertTab(title, null, c, null, this.tabPages_.size());
    }

    public void addTab(String title, Icon icon, Component c) {
        this.insertTab(title, icon, c, null, this.tabPages_.size());
    }

    public void addTab(String title, Icon icon, Component c, String tip) {
        this.insertTab(title, icon, c, tip, this.tabPages_.size());
    }

    public void insertTab(String title, Icon icon, Component c, String tip, int index) {
        Objects.requireNonNull(title, "Title cannot be null.");
        Objects.requireNonNull(c, "Component cannot be null.");
        if (index < 0 || index > this.tabPages_.size()) {
            throw new IndexOutOfBoundsException("Tab index out of range");
        }
        Component selComp = this.getSelectedComponent();
        int oldIndex = this.indexOfComponent(c);
        if (oldIndex >= 0) {
            this.removeTabAt(oldIndex);
        }
        this.tabPages_.add(index, new TabPage(title, c));
        if (selComp == null) {
            this.setSelectedIndex(0);
        } else {
            this.setSelectedComponent(selComp);
        }
        this.calculateTabRects();
        super.add(c);
    }

    public Component[] getTabComponents() {
        int isize = this.tabPages_.size();
        Component[] result = new Component[isize];
        for (int i = 0; i < isize; ++i) {
            result[i] = this.tabPages_.get(i).getComponent();
        }
        return result;
    }

    public int getSelectedIndex() {
        return this.model_.getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        if (index == -1) {
            index = 0;
        }
        this.verifyIndex(index);
        this.model_.setSelectedIndex(index);
        this.doLayout();
        this.repaint();
    }

    public Component getSelectedComponent() {
        int index = this.getSelectedIndex();
        try {
            return index != -1 ? this.getComponentAt(index) : null;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public void setSelectedComponent(Component c) {
        if (c == null) {
            return;
        }
        int isize = this.tabPages_.size();
        for (int i = 0; i < isize; ++i) {
            Component tc = this.tabPages_.get(i).getComponent();
            if (c != tc) continue;
            this.setSelectedIndex(i);
            return;
        }
    }

    public void removeTabAt(int index) {
        if (index < 0 || index >= this.tabPages_.size()) {
            LOGGER.warn("There is no tab at index {}", (Object)index);
            return;
        }
        int sindex = this.getSelectedIndex();
        super.remove(this.getComponentAt(index));
        this.tabPages_.remove(index);
        if (sindex > index) {
            --sindex;
        } else if (sindex == index && (sindex = 0) >= this.tabPages_.size()) {
            --sindex;
        }
        this.calculateTabRects();
        this.setSelectedIndex(sindex);
        this.repaint();
    }

    public Component getComponentAt(int index) {
        this.verifyIndex(index);
        return this.tabPages_.get(index).getComponent();
    }

    public void setComponentAt(int index, Component component) {
        Component old = this.getComponentAt(index);
        this.remove(old);
        this.add(component);
        this.tabPages_.get(index).setComponent(component);
        this.repaint();
    }

    public void setTitleAt(int index, String title) {
        this.verifyIndex(index);
        this.tabPages_.get(index).setTitle(title);
        this.repaint();
    }

    public int indexOfComponent(Component c) {
        if (c == null) {
            return -1;
        }
        int isize = this.tabPages_.size();
        for (int i = 0; i < isize; ++i) {
            Component tc = this.tabPages_.get(i).getComponent();
            if (c != tc) continue;
            return i;
        }
        return -1;
    }

    public int indexOfTab(String title) {
        if (title == null) {
            return -1;
        }
        int isize = this.tabPages_.size();
        for (int i = 0; i < isize; ++i) {
            String tt = this.tabPages_.get(i).getTitle();
            if (tt == null || !tt.equals(title)) continue;
            return i;
        }
        return -1;
    }

    private void verifyIndex(int index) {
        if (index < 0 || index >= this.tabPages_.size()) {
            throw new IndexOutOfBoundsException("There is no tab at index " + index);
        }
    }

    @Override
    public void setLayout(LayoutManager ignored) {
    }

    @Override
    public LayoutManager getLayout() {
        return null;
    }

    @Override
    public void doLayout() {
        this.placeSelectedComponent();
        this.calculateTabRects();
        super.doLayout();
    }

    private void placeSelectedComponent() {
        Insets outerIns = this.getInsets();
        Insets innerIns = this.innerBorder_ != null ? this.innerBorder_.getBorderInsets(this) : new Insets(0, 0, 0, 0);
        int w = this.getWidth();
        int h = this.getHeight();
        int iw = w - outerIns.left - outerIns.right - innerIns.left - innerIns.right;
        int ih = h - outerIns.top - outerIns.bottom - innerIns.top - innerIns.bottom - 24;
        int cTop = outerIns.top + 24;
        Component selected = this.getSelectedComponent();
        for (TabPage tab : this.tabPages_) {
            Component c;
            c.setVisible((c = tab.getComponent()) == selected);
            if (c == selected) {
                Dimension d1 = null;
                try {
                    d1 = c.getMaximumSize();
                }
                catch (Exception exc) {
                    LOGGER.error("Exception {} getting max size of {}, {}", exc, c.getName(), c);
                }
                if (d1 != null) {
                    iw = Math.min(iw, d1.width);
                    ih = Math.min(ih, d1.height);
                }
                c.setBounds(outerIns.left + innerIns.left, cTop + innerIns.top, iw, ih);
            } else {
                c.setBounds(0, 0, 0, 0);
            }
            c.invalidate();
            try {
                c.validate();
            }
            catch (Exception exc) {
                LOGGER.warn("Exception validating tab {}", (Object)tab.getTitle());
                LOGGER.warn("Exception is {}", (Object)exc.toString());
            }
        }
    }

    private void calculateTabRects() {
        int isize = this.tabPages_.size();
        Insets outerIns = this.getInsets();
        int tabTop = outerIns.top;
        if (this.buttonFont_ == null) {
            return;
        }
        FontMetrics fm = this.getFontMetrics(this.buttonFont_);
        int maxTwidth = 0;
        if (this.fixedButtonWidth_) {
            for (TabPage tab : this.tabPages_) {
                maxTwidth = Math.max(maxTwidth, fm.stringWidth(tab.getTitle()));
            }
        }
        int boffset = 0;
        for (TabPage tab : this.tabPages_) {
            int w = this.fixedButtonWidth_ ? 18 + maxTwidth + 3 + 15 : 18 + fm.stringWidth(tab.getTitle()) + 3 + 15;
            int x = boffset == 0 ? 0 : boffset - 3 - 10;
            tab.setTabBounds(outerIns.left + x, tabTop, w, 24);
            boffset = x + w;
        }
        this.tooManyTabs_ = false;
        if (!this.tooManyTabs_) {
            this.firstVisibleTab_ = 0;
            this.lastVisibleTab_ = isize - 1;
        }
        if (this.firstVisibleTab_ < 1) {
            this.firstVisibleTab_ = 0;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        int w = 0;
        int h = 0;
        for (TabPage tab : this.tabPages_) {
            Component c = tab.getComponent();
            try {
                Dimension d = c.getPreferredSize();
                w = Math.max(w, d.width);
                h = Math.max(h, d.height);
            }
            catch (Exception exc) {
                LOGGER.warn("Exception getting preferred size of {}", (Object)tab.getTitle());
                LOGGER.warn("{}", (Object)exc.toString());
                if (!LOGGER.isDebugEnabled()) continue;
                exc.printStackTrace();
            }
        }
        int isize = this.tabPages_.size();
        TabPage tp = this.tabPages_.get(isize - 1);
        Rectangle r = tp.getTabBounds();
        int ww = r.x + r.width;
        w = Math.max(w, ww);
        h += 24;
        Insets outerIns = this.getInsets();
        Insets innerIns = this.innerBorder_ != null ? this.innerBorder_.getBorderInsets(this) : new Insets(0, 0, 0, 0);
        w += outerIns.left + outerIns.right;
        h += outerIns.top + outerIns.bottom;
        return new Dimension(w += innerIns.left + innerIns.right, h += innerIns.top + innerIns.bottom);
    }

    @Override
    public void paintComponent(Graphics g) {
        TabPage tab;
        int i;
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        Insets outerIns = this.getInsets();
        int ww = this.getWidth();
        int hh = this.getHeight();
        int iw = this.getWidth() - outerIns.left - outerIns.right;
        int ih = this.getHeight() - outerIns.top - outerIns.bottom;
        if (this.isOpaque()) {
            g2d.setColor(this.getBackground());
            g2d.fillRect(0, 0, ww, hh);
        }
        int t = outerIns.top + 24;
        int b = hh - outerIns.bottom;
        GradientPaint paint = new GradientPaint(0.0f, t, PANE_TOP_COLOR, 0.0f, b, PANE_BOTTOM_COLOR);
        g2d.setPaint(paint);
        g2d.fillRect(0, t, ww, b);
        if (this.innerBorder_ != null) {
            this.innerBorder_.paintBorder(this, g, outerIns.left, outerIns.top + 24, iw, ih - 24);
        }
        int selIndex = this.model_.getSelectedIndex();
        for (i = this.lastVisibleTab_; i >= this.firstVisibleTab_; --i) {
            if (i == selIndex || i == this.pressedIndex_) continue;
            tab = this.tabPages_.get(i);
            this.paintTabButton(g2d, tab, false);
        }
        if (this.pressedIndex_ == -1) {
            this.paintBottomLines(g2d);
        }
        for (i = this.firstVisibleTab_; i <= this.lastVisibleTab_; ++i) {
            if (i != selIndex) continue;
            tab = this.tabPages_.get(i);
            this.paintTabButton(g2d, tab, true);
            break;
        }
        if (this.pressedIndex_ > -1) {
            this.paintBottomLines(g2d);
            for (i = this.firstVisibleTab_; i <= this.lastVisibleTab_; ++i) {
                if (i != this.pressedIndex_) continue;
                tab = this.tabPages_.get(i);
                this.paintTabButton(g2d, tab, true);
                break;
            }
        }
    }

    private void paintBottomLines(Graphics2D g2d) {
        Insets outerIns = this.getInsets();
        int ww = this.getWidth();
        if (GuiUtils.isParentWindowFocused(this)) {
            g2d.setColor(FOCUSED_SHADOW_COLOR);
        } else {
            g2d.setColor(UNFOCUSED_SHADOW_COLOR);
        }
        g2d.drawLine(outerIns.left, outerIns.top + 24 - 1, ww - outerIns.right, outerIns.top + 24 - 1);
        g2d.setColor(HIGHLIGHT_COLOR);
        g2d.drawLine(outerIns.left, outerIns.top + 24, ww - outerIns.right, outerIns.top + 24);
    }

    protected void paintTabButton(Graphics2D g2d, TabPage tab, boolean selected) {
        Rectangle rect = tab.getTabBounds();
        String text = tab.getTitle();
        this.paintTabButtonBackground(g2d, rect, selected);
        FontMetrics fm = g2d.getFontMetrics(this.buttonFont_);
        int tw = fm.stringWidth(text);
        int x = rect.x + (rect.width - tw) / 2;
        int y = rect.y + (rect.height - fm.getHeight()) / 2;
        g2d.setFont(this.buttonFont_);
        if (GuiUtils.isParentWindowFocused(this)) {
            g2d.setColor(TEXT_EMPHASIS_COLOR);
            g2d.drawString(text, x, y + fm.getAscent());
            g2d.setColor(FOCUSED_TEXT_COLOR);
        } else {
            g2d.setColor(UNFOCUSED_TEXT_COLOR);
        }
        g2d.drawString(text, x, y + fm.getAscent() + 1);
    }

    private void paintTabButtonBackground(Graphics2D g2d, Rectangle rect, boolean isSelected) {
        g2d.translate(rect.x, rect.y);
        int w = rect.width;
        int h = rect.height;
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, h);
        path.lineTo(0.0f, h - 2);
        path.curveTo(10.0f, h - 2, 5.0f, 1.0f, 15.0f, 1.0f);
        path.lineTo(w - 15, 1.0f);
        path.curveTo(w - 5, 1.0f, w - 10, h - 2, w, h - 2);
        path.lineTo(w, h);
        path.closePath();
        if (isSelected) {
            GradientPaint paint = new GradientPaint(0.0f, 0.0f, SELECTED_TAB_TOP, 0.0f, h, SELECTED_TAB_BOTTOM);
            g2d.setPaint(paint);
        } else {
            GradientPaint paint = new GradientPaint(0.0f, 0.0f, UNSELECTED_TAB_TOP, 0.0f, h, UNSELECTED_TAB_BOTTOM);
            g2d.setPaint(paint);
        }
        g2d.fill(path);
        g2d.translate(0.0, 0.5);
        path = new GeneralPath();
        path.moveTo(0.0f, h - 2);
        path.curveTo(10.0f, h - 2, 5.0f, 1.0f, 15.0f, 1.0f);
        path.lineTo(w - 15, 1.0f);
        path.curveTo(w - 5, 1.0f, w - 10, h - 2, w, h - 2);
        if (GuiUtils.isParentWindowFocused(this)) {
            g2d.setColor(FOCUSED_SHADOW_COLOR);
        } else {
            g2d.setColor(UNFOCUSED_SHADOW_COLOR);
        }
        g2d.draw(path);
        g2d.translate(0, 1);
        g2d.setColor(HIGHLIGHT_COLOR);
        g2d.draw(path);
        g2d.translate(0, -1);
        g2d.translate(0.0, -0.5);
        g2d.translate(-rect.x, -rect.y);
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireChangeEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ChangeEvent e = new ChangeEvent(this);
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }

    private int getTabButtonAtPoint(Point p) {
        if (p == null) {
            LOGGER.warn("Null Point passed");
            return -1;
        }
        int sindex = this.model_.getSelectedIndex();
        if (sindex > -1 && this.tabPages_.get(sindex).contains(p)) {
            return sindex;
        }
        for (int i = this.firstVisibleTab_; i <= this.lastVisibleTab_; ++i) {
            if (i == sindex || !this.tabPages_.get(i).contains(p)) continue;
            return i;
        }
        return -1;
    }

    class TabMouseListener
    extends MouseInputAdapter {
        private boolean dragInProgress_;
        private Point windowPoint_;
        private Point mousePoint_;

        TabMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                FolderTabbedPane.this.pressedIndex_ = -1;
                return;
            }
            Point p = e.getPoint();
            FolderTabbedPane.this.pressedIndex_ = FolderTabbedPane.this.getTabButtonAtPoint(p);
            FolderTabbedPane.this.repaint();
            if (FolderTabbedPane.this.pressedIndex_ > -1) {
                return;
            }
            if (PlatformUtils.isMacintosh() && FolderTabbedPane.this.backgroundIsDraggable_) {
                Window parent = SwingUtilities.getWindowAncestor(FolderTabbedPane.this);
                if (parent == null) {
                    return;
                }
                Insets ins = FolderTabbedPane.this.getInsets();
                if (p.y < ins.top || p.y > ins.top + 24) {
                    return;
                }
                if (p.x < ins.left || p.x > FolderTabbedPane.this.getWidth() - ins.right) {
                    return;
                }
                this.dragInProgress_ = true;
                this.windowPoint_ = parent.getLocation();
                this.mousePoint_ = e.getPoint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (FolderTabbedPane.this.pressedIndex_ == -1) {
                if (PlatformUtils.isMacintosh() && this.dragInProgress_) {
                    this.moveWindow(e.getPoint());
                    this.dragInProgress_ = false;
                }
                return;
            }
            int buttonReleased = FolderTabbedPane.this.getTabButtonAtPoint(e.getPoint());
            if (buttonReleased != -1 && buttonReleased == FolderTabbedPane.this.pressedIndex_) {
                if (FolderTabbedPane.this.pressedIndex_ == -101) {
                    --FolderTabbedPane.this.firstVisibleTab_;
                } else if (FolderTabbedPane.this.pressedIndex_ == -102) {
                    ++FolderTabbedPane.this.firstVisibleTab_;
                } else if (buttonReleased != FolderTabbedPane.this.getSelectedIndex()) {
                    FolderTabbedPane.this.setSelectedIndex(buttonReleased);
                }
                FolderTabbedPane.this.doLayout();
            }
            FolderTabbedPane.this.repaint();
            FolderTabbedPane.this.pressedIndex_ = -1;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (PlatformUtils.isMacintosh() && this.dragInProgress_) {
                this.moveWindow(e.getPoint());
            }
        }

        private void moveWindow(Point p) {
            if (!this.dragInProgress_) {
                return;
            }
            int dx = p.x - this.mousePoint_.x;
            int dy = p.y - this.mousePoint_.y;
            this.windowPoint_.translate(dx, dy);
            Window parent = SwingUtilities.getWindowAncestor(FolderTabbedPane.this);
            if (parent == null) {
                return;
            }
            parent.setLocation(this.windowPoint_);
        }
    }

    protected class TabPage {
        private String title_;
        private Component component_;
        private final Rectangle tabRect_;
        private GeneralPath bpath_;

        public TabPage(String title, Component c) {
            this.title_ = title;
            this.component_ = c;
            this.tabRect_ = new Rectangle(0, 0, 0, 0);
        }

        public String getTitle() {
            return this.title_;
        }

        public void setTitle(String title) {
            this.title_ = title;
        }

        public Component getComponent() {
            return this.component_;
        }

        public void setComponent(Component c) {
            this.component_ = c;
        }

        public void setTabBounds(int x, int y, int w, int h) {
            this.tabRect_.x = x;
            this.tabRect_.y = y;
            this.tabRect_.width = w;
            this.tabRect_.height = h;
            this.bpath_ = new GeneralPath();
            this.bpath_.moveTo(x + 0, y + h + 1);
            this.bpath_.lineTo(x + 0, y + h - 2);
            this.bpath_.curveTo(x + 10, y + h - 2, x + 15 - 10, y + 1, x + 15, y + 1);
            this.bpath_.lineTo(x + w - 15, y + 1);
            this.bpath_.curveTo(x + w - 5, y + 1, x + w - 10, y + h - 2, x + w, y + h - 2);
            this.bpath_.lineTo(x + w, y + h + 1);
            this.bpath_.closePath();
        }

        public Point getTabLocation() {
            return new Point(this.tabRect_.x, this.tabRect_.y);
        }

        public Dimension getTabSize() {
            return new Dimension(this.tabRect_.width, this.tabRect_.height);
        }

        public Rectangle getTabBounds() {
            return this.tabRect_;
        }

        public boolean contains(Point p) {
            return this.bpath_.contains((double)p.x + 0.5, (double)p.y + 0.5);
        }
    }

    protected class ModelListener
    implements ChangeListener {
        protected ModelListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            FolderTabbedPane.this.fireChangeEvent();
        }
    }
}

