/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.audio;

import java.nio.FloatBuffer;
import org.jcodec.audio.Audio;
import org.jcodec.audio.AudioFilter;
import org.jcodec.platform.Platform;

public class FilterSocket {
    private FloatBuffer[] buffers;
    private long[] positions;
    private int[] delays;
    private AudioFilter[] filters;
    private int totalInputs;
    private int totalOutputs;

    public static FilterSocket createFilterSocket(AudioFilter ... arguments) {
        int i;
        FilterSocket fs = new FilterSocket();
        fs.totalInputs = 0;
        fs.totalOutputs = 0;
        for (i = 0; i < arguments.length; ++i) {
            fs.totalInputs += arguments[i].getNInputs();
            fs.totalOutputs += arguments[i].getNOutputs();
        }
        fs.buffers = new FloatBuffer[fs.totalInputs];
        fs.positions = new long[fs.totalInputs];
        fs.delays = new int[fs.totalInputs];
        int b = 0;
        for (i = 0; i < arguments.length; ++i) {
            int j = 0;
            while (j < arguments[i].getNInputs()) {
                fs.delays[b] = arguments[i].getDelay();
                ++j;
                ++b;
            }
        }
        fs.filters = arguments;
        return fs;
    }

    public void allocateBuffers(int bufferSize) {
        for (int i = 0; i < this.totalInputs; ++i) {
            this.buffers[i] = FloatBuffer.allocate(bufferSize + this.delays[i] * 2);
            this.buffers[i].position(this.delays[i]);
        }
    }

    public static FilterSocket createFilterSocket2(AudioFilter filter, FloatBuffer[] buffers, long[] positions) {
        FilterSocket fs = new FilterSocket();
        fs.filters = new AudioFilter[]{filter};
        fs.buffers = buffers;
        fs.positions = positions;
        fs.delays = new int[]{filter.getDelay()};
        fs.totalInputs = filter.getNInputs();
        fs.totalOutputs = filter.getNOutputs();
        return fs;
    }

    private FilterSocket() {
    }

    public void filter(FloatBuffer[] outputs) {
        if (outputs.length != this.totalOutputs) {
            throw new IllegalArgumentException("Can not output to provided filter socket inputs != outputs (" + outputs.length + "!=" + this.totalOutputs + ")");
        }
        int ii = 0;
        int oi = 0;
        for (int i = 0; i < this.filters.length; ++i) {
            this.filters[i].filter(Platform.copyOfRangeO(this.buffers, ii, this.filters[i].getNInputs() + ii), Platform.copyOfRangeL(this.positions, ii, this.filters[i].getNInputs() + ii), Platform.copyOfRangeO(outputs, oi, this.filters[i].getNOutputs() + oi));
            ii += this.filters[i].getNInputs();
            oi += this.filters[i].getNOutputs();
        }
    }

    FloatBuffer[] getBuffers() {
        return this.buffers;
    }

    public void rotate() {
        for (int i = 0; i < this.buffers.length; ++i) {
            int n = i;
            this.positions[n] = this.positions[n] + (long)this.buffers[i].position();
            Audio.rotate(this.buffers[i]);
        }
    }

    public void setBuffers(FloatBuffer[] ins, long[] pos) {
        if (ins.length != this.totalInputs) {
            throw new IllegalArgumentException("Number of input buffers provided is less then the number of filter inputs.");
        }
        if (pos.length != this.totalInputs) {
            throw new IllegalArgumentException("Number of input buffer positions provided is less then the number of filter inputs.");
        }
        this.buffers = ins;
        this.positions = pos;
    }

    public int getTotalInputs() {
        return this.totalInputs;
    }

    public int getTotalOutputs() {
        return this.totalOutputs;
    }

    AudioFilter[] getFilters() {
        return this.filters;
    }

    public long[] getPositions() {
        return this.positions;
    }
}

