/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.clut;

import gov.nasa.giss.graphics.ColorUtils;
import gov.nasa.giss.graphics.clut.AbstractColorTable;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PyRgbColorTable
extends AbstractColorTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public PyRgbColorTable() {
        this(256);
    }

    public PyRgbColorTable(int count) {
        this.initiateFixedSizeArray(count);
        for (int i = 0; i < count; ++i) {
            float bright = (float)i / (float)(count - 1);
            this.setColorAt(i, new Color(bright, bright, bright));
        }
        this.setName("untitled");
        this.setType("RGB");
    }

    public PyRgbColorTable(File f) throws FileNotFoundException, IOException, ParseException {
        Objects.requireNonNull(f, "File cannot be null.");
        if (!f.exists()) {
            throw new FileNotFoundException("File does not exist.");
        }
        this.setURL(f.toURI().toURL());
        try (FileReader fr = new FileReader(f);
             BufferedReader br = new BufferedReader(fr);){
            this.parseColorTable(br);
        }
    }

    public PyRgbColorTable(URL url) throws IOException, FileNotFoundException, ParseException {
        Objects.requireNonNull(url, "URL cannot be null.");
        this.setURL(url);
        try (InputStream is = url.openStream();
             BufferedInputStream bis = new BufferedInputStream(is);
             InputStreamReader isr = new InputStreamReader(bis);
             BufferedReader br = new BufferedReader(isr);){
            this.parseColorTable(br);
        }
    }

    @Override
    public AbstractColorTable copy() throws IOException {
        PyRgbColorTable c = new PyRgbColorTable(256);
        c.setName("Copy of " + this.getName());
        return c;
    }

    private void parseColorTable(BufferedReader bReader) throws IOException, ParseException {
        String aline;
        ArrayList<Color> colors = new ArrayList<Color>(256);
        Object oneLongLine = "";
        while ((aline = bReader.readLine()) != null) {
            if (aline.length() == 0 || aline.charAt(0) == '#' || aline.startsWith("//")) continue;
            oneLongLine = (String)oneLongLine + aline;
        }
        LOGGER.trace("Stripping whitespace from {}", oneLongLine);
        oneLongLine = ((String)oneLongLine).replaceAll("\\s", "");
        LOGGER.trace("Stripping leading 'var name' from {}", oneLongLine);
        oneLongLine = ((String)oneLongLine).replaceFirst("^.*=", "");
        LOGGER.trace("Stripping leading bracket from {}", oneLongLine);
        oneLongLine = ((String)oneLongLine).replaceFirst("^\\[", "");
        LOGGER.trace("Stripping closing semi-colon (if any) from {}", oneLongLine);
        oneLongLine = ((String)oneLongLine).replaceFirst(";$", "");
        LOGGER.trace("Stripping closing bracket from {}", oneLongLine);
        oneLongLine = ((String)oneLongLine).replaceFirst("\\]$", "");
        LOGGER.trace("Stripping all quote marks from {}", oneLongLine);
        oneLongLine = ((String)oneLongLine).replaceAll("\"", "");
        oneLongLine = ((String)oneLongLine).replaceAll("'", "");
        String[] tokens = ((String)oneLongLine).split(",");
        int tokenNum = 0;
        for (String token : tokens) {
            ++tokenNum;
            if (!token.matches("^#[a-fA-F0-9][a-fA-F0-9][a-fA-F0-9][a-fA-F0-9][a-fA-F0-9][a-fA-F0-9]$")) {
                LOGGER.debug("Token {} is not of form #XXXXXX", (Object)tokenNum);
                throw new ParseException("Exception parsing Py/JS RGB file at token ", tokenNum);
            }
            LOGGER.trace("Parsing color {} from {}", (Object)tokenNum, (Object)token);
            Color c = ColorUtils.parseColor(token);
            colors.add(c);
        }
        int count = colors.size();
        this.initiateFixedSizeArray(count);
        for (int i = 0; i < count; ++i) {
            this.setColorAt(i, (Color)colors.get(i));
        }
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public boolean saveAs(File f) throws IOException, FileNotFoundException {
        block13: {
            String outdesc = f.getName().replaceFirst(".pyrgb$", "");
            try (FileWriter fw = new FileWriter(f);
                 BufferedWriter out = new BufferedWriter(fw);){
                out.write(outdesc + " = [");
                int ccount = this.getColorCount();
                for (int i = 0; i < ccount; ++i) {
                    Color c = this.getColorAt(i);
                    String cstr = ColorUtils.colorToHexString(c);
                    out.write("'" + cstr + "'");
                    if (i >= ccount - 1) continue;
                    out.write(",");
                }
                out.write("]\n");
            }
            catch (Exception exc) {
                LOGGER.error("Failed to save Py/JS RGB color table due to {}", exc);
                if (!LOGGER.isTraceEnabled()) break block13;
                exc.printStackTrace();
            }
        }
        return false;
    }
}

