/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Baranyi6
extends GlobalPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Baranyi VI";
    public static final int PROPERTIES = 8;
    private static final double CY = 2.032795;
    private static final double C1 = 0.499123734;
    private static final double C3 = 0.0724243966;
    private static final double C5 = 0.030702408;
    private static final double C7 = -0.0305975162;
    private static final double C9 = 0.0062459788;
    private static final double THREE_C3 = 0.2172731898;
    private static final double FIVE_C5 = 0.15351204000000002;
    private static final double SEVEN_C7 = -0.2141826134;
    private static final double NINE_C9 = 0.056213809200000006;
    private static final double B1 = 0.3409950753;
    private static final double B3 = -0.0087713573;
    private static final double B5 = 0.0024098046;
    private static final double B7 = -3.04625E-4;
    private static final double B9 = 1.28588E-5;
    private static final double THREE_B3 = -0.0263140719;
    private static final double FIVE_B5 = 0.012049022999999999;
    private static final double SEVEN_B7 = -0.0021323749999999997;
    private static final double NINE_B9 = 1.157292E-4;
    private static final double B11 = 2.795571;
    private static final double B31 = 1.469597;
    private static final double B12 = 2.032795;
    private static final double B32 = 4.573849;
    private static final double JOIN_PHI = 75.059298;
    private static final double JOIN_PHIRAD = Math.toRadians(75.059298);
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 2.032795;

    public Baranyi6(int width, int height) {
        this(width, height, 0, 0);
    }

    public Baranyi6(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, Math.PI, 2.032795);
        this.finishConstruction();
        LOGGER.trace("fPhi(pi/2) {}", (Object)Baranyi6.getFPhi(1.5707963267948966));
        LOGGER.trace("lLambda(pi) {}", (Object)Baranyi6.getLLambda(Math.PI));
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double absPhiRad = Math.abs(Math.toRadians(lat));
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLambdaRad = Math.abs(lambdaRad);
        double y = 2.032795 * Baranyi6.getFPhi(absPhiRad);
        double x = 0.0;
        double lLambda = Baranyi6.getLLambda(absLambdaRad);
        x = absPhiRad < JOIN_PHIRAD ? lLambda * (Math.sqrt(2.795571 - y * y) + 1.469597) : lLambda * (2.032795 - y) * 4.573849;
        if (lambdaRad < 0.0) {
            x = -x;
        }
        if (lat < 0.0) {
            y = -y;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absx = Math.abs(x);
        double absy = Math.abs(y);
        if (absx > (double)this.dxMax_ || absy > (double)this.dyMax_) {
            return null;
        }
        double absXOverRS = absx * this.invRS_;
        double absYOverRS = absy * this.invRS_;
        double phiRad = this.iteratePhiRad(absYOverRS);
        double lLambda = phiRad < JOIN_PHIRAD ? absXOverRS / (Math.sqrt(2.795571 - absYOverRS * absYOverRS) + 1.469597) : absXOverRS / ((2.032795 - absYOverRS) * 4.573849);
        double lambdaRad = this.iterateLambdaRad(lLambda, absXOverRS);
        if (lambdaRad > Math.PI) {
            return null;
        }
        double phi = y < 0.0 ? -Math.toDegrees(phiRad) : Math.toDegrees(phiRad);
        double lambda = x < 0.0 ? -Math.toDegrees(lambdaRad) : Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Baranyi6 baranyi6 = this;
        synchronized (baranyi6) {
            block3: for (int iy = 0; iy < this.dyMax_; ++iy) {
                double x;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                double phiRad = this.iteratePhiRad(yOverRS);
                double phiTerm = phiRad < JOIN_PHIRAD ? 1.0 / (Math.sqrt(2.795571 - yOverRS * yOverRS) + 1.469597) : 1.0 / ((2.032795 - yOverRS) * 4.573849);
                for (int ix = 0; ix < this.dxMax_ && !((x = (double)ix + 0.5) > (double)this.dxMax_); ++ix) {
                    double xOverRS = x * this.invRS_;
                    double lLambda = xOverRS * phiTerm;
                    double lambdaRad = this.iterateLambdaRad(lLambda, xOverRS);
                    if (Double.isNaN(lambdaRad)) {
                        LOGGER.trace("Got NaN lambda for x {}, dxMax_ {}", (Object)x, (Object)this.dxMax_);
                        continue block3;
                    }
                    if (lambdaRad > Math.PI) continue block3;
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    private static double getFPhi(double phiRad) {
        double phiRad2 = phiRad * phiRad;
        return phiRad * (0.499123734 + phiRad2 * (0.0724243966 + phiRad2 * (0.030702408 + phiRad2 * (-0.0305975162 + phiRad2 * 0.0062459788))));
    }

    private static double getLLambda(double lambdaRad) {
        double lambdaRad2 = lambdaRad * lambdaRad;
        return lambdaRad * (0.3409950753 + lambdaRad2 * (-0.0087713573 + lambdaRad2 * (0.0024098046 + lambdaRad2 * (-3.04625E-4 + lambdaRad2 * 1.28588E-5))));
    }

    private double iteratePhiRad(double yOverRS) {
        double phiRad = 1.5707963267948966 * yOverRS / 2.032795;
        for (int iter = 0; iter < 33; ++iter) {
            double phiRad2 = phiRad * phiRad;
            double func = 2.032795 * Baranyi6.getFPhi(phiRad) - yOverRS;
            double dfunc = 2.032795 * (0.499123734 + phiRad2 * (0.2172731898 + phiRad2 * (0.15351204000000002 + phiRad2 * (-0.2141826134 + 0.056213809200000006 * phiRad2))));
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        return phiRad;
    }

    private double iterateLambdaRad(double lLambda, double xOverRS) {
        double lambdaRad = xOverRS * Math.PI / Math.PI;
        for (int iter = 0; iter < 33; ++iter) {
            double lambdaRad2 = lambdaRad * lambdaRad;
            double func = Baranyi6.getLLambda(lambdaRad) - lLambda;
            double dfunc = 0.3409950753 + lambdaRad2 * (-0.0263140719 + lambdaRad2 * (0.012049022999999999 + lambdaRad2 * (-0.0021323749999999997 + 1.157292E-4 * lambdaRad2)));
            double dlambdaRad = -func / dfunc;
            lambdaRad += dlambdaRad;
            if (Math.abs(dlambdaRad) < 1.0E-5) break;
        }
        return lambdaRad;
    }
}

