/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.InterruptedPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class BoggsEumorphic
extends InterruptedPseudocylindric {
    public static final String PROJECTION_NAME = "Boggs Eumorphic";
    private static final double CONST_K = 1.00138;
    private static final double CONST_L = 1.11072;
    private static final double TWO_K = 2.00276;
    private static final double INV_TWO_K = 0.4993109508877749;
    private static final double ONE_PLUS_L = 2.1107199999999997;
    private static final double MAX_X_OVER_RS = 2.980905142749154;
    private static final double MAX_Y_OVER_RS = 1.4904481261698814;
    private double xFactor0_;

    public BoggsEumorphic(int width, int height) {
        this(width, height, 0, 0);
    }

    public BoggsEumorphic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x1000008, width, height, xmargin, ymargin, 2.980905142749154, 1.4904481261698814);
        this.finishConstruction();
    }

    @Override
    protected final void finishScaling() {
        this.xFactor0_ = this.invRS_ * 0.4993109508877749 * 2.1107199999999997;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x;
        if (lat > 89.99999) {
            if (this.isInterrupted()) {
                return this.transformLL2XYIgnoreMargins(lon, 89.99999);
            }
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ - 1.4904481261698814 * this.rS_);
        }
        if (lat < -89.99999) {
            if (this.isInterrupted()) {
                return this.transformLL2XYIgnoreMargins(lon, -89.99999);
            }
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ + 1.4904481261698814 * this.rS_);
        }
        double phiRad = Math.toRadians(lat);
        double piSinPhi = Math.PI * Math.sin(phiRad);
        double thetaRad = phiRad;
        for (int iter = 0; iter < 33; ++iter) {
            double twoThetaRad = 2.0 * thetaRad;
            double func = twoThetaRad + Math.sin(twoThetaRad) - piSinPhi;
            double dfunc = 2.0 + 2.0 * Math.cos(twoThetaRad);
            double dthetaRad = -func / dfunc;
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        double y = 0.4993109508877749 * (phiRad + 1.4142135623730951 * Math.sin(thetaRad));
        double secPhi = 1.0 / Math.cos(phiRad);
        double secTheta = 1.0 / Math.cos(thetaRad);
        double twoKOverSecants = 2.00276 / (secPhi + 1.11072 * secTheta);
        if (this.isInterrupted()) {
            double[] gore = this.getGore(lon, lat);
            double nlon = MapUtils.normalizeMP180(lon);
            double dlon = nlon - gore[1];
            double dx = twoKOverSecants * Math.toRadians(dlon);
            double cx = this.lonToLambdaRad(gore[1]) / 1.0539056102578441;
            x = cx + dx;
        } else {
            x = twoKOverSecants * this.lonToLambdaRad(lon);
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (Math.abs(y) > this.ymRS_) {
            return null;
        }
        double thetaRad = this.thetaRadForY(y);
        double phiRad = 2.00276 * y * this.invRS_ - 1.4142135623730951 * Math.sin(thetaRad);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double xFactor = this.invRS_ * 0.4993109508877749 * (1.0 / Math.cos(phiRad) + 1.11072 / Math.cos(thetaRad));
        double lon = this.getLongitudeForX(x, xFactor, this.xFactor0_, phiRad > 0.0);
        if (Double.isNaN(lon)) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        return new PointLL(lon, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        BoggsEumorphic boggsEumorphic = this;
        synchronized (boggsEumorphic) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                double thetaRad = this.thetaRadForY(y);
                double phiRad = 2.00276 * yOverRS - 1.4142135623730951 * Math.sin(thetaRad);
                if (phiRad < -1.5707963267948966) continue;
                if (phiRad > 1.5707963267948966) break;
                double phi = Math.toDegrees(phiRad);
                double xFactor = this.invRS_ * 0.4993109508877749 * (1.0 / Math.cos(phiRad) + 1.11072 / Math.cos(thetaRad));
                for (int ix = -this.dxMax_; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double lon = this.getLongitudeForX(x, xFactor, this.xFactor0_, phi > 0.0);
                    if (Double.isNaN(lon)) continue;
                    this.setInvPoint(ix, iy, lon, phi);
                }
            }
        }
    }

    private double thetaRadForY(double y) {
        double twoKYOverR = 2.00276 * y * this.invRS_;
        double thetaRad = (y > 0.0 ? 45.0 : -45.0) * (Math.PI / 180);
        for (int iter = 0; iter < 33; ++iter) {
            double twoThetaRad = 2.0 * thetaRad;
            double phiTerm = twoKYOverR - 1.4142135623730951 * Math.sin(thetaRad);
            double func = Math.sin(twoThetaRad) + twoThetaRad - Math.PI * Math.sin(phiTerm);
            double dfunc = 2.0 * Math.cos(twoThetaRad) + 2.0 + Math.PI * Math.cos(phiTerm) * 1.4142135623730951 * Math.cos(thetaRad);
            double dthetaRad = -func / dfunc;
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        return thetaRad;
    }
}

