/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.LonLatRotator;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ObliqueEllipseProjection
extends AbstractProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ProjDoubleParameter rotateParam_;
    private double thirdRotation_;
    private LonLatRotator rotMatrices_;

    public ObliqueEllipseProjection(String name, int properties, int width, int height, int xmargin, int ymargin, double widthFactor, double heightFactor) {
        super(name, properties, width, height, xmargin, ymargin, widthFactor, heightFactor);
        this.rotMatrices_ = new LonLatRotator(this.lambdaC_, this.phiC_, 90.0);
        this.rotateParam_ = new ProjDoubleParameter("Azimuth (clockwise)", "Azimuth", "\u00b0 ", this.thirdRotation_, -360.0, 360.0, true, true);
        this.addParameter(this.rotateParam_);
    }

    @Override
    public void setCenter(double lon, double lat) {
        super.setCenter(lon, lat);
        if (this.rotMatrices_ != null) {
            this.rotMatrices_.setAngles(lon, lat, this.thirdRotation_);
        }
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        super.parameterChanged(e);
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p.equals(this.rotateParam_)) {
            this.setPlagalRotation(this.rotateParam_.getValue());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    protected void setPlagalRotation(double angle) {
        this.thirdRotation_ = angle;
        this.rotMatrices_.setAngles(this.lambdaC_, this.phiC_, this.thirdRotation_);
        this.autoscale();
    }

    protected double[] lonlat2lonlatP(double lon, double lat) {
        return this.rotMatrices_.rotate(lon, lat);
    }

    protected double[] lonlatP2lonlat(double lambdaP, double phiP) {
        return this.rotMatrices_.inverse(lambdaP, phiP);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        double absPhiC = Math.abs(this.phiC_);
        if (lat == 0.0 && absPhiC < 1.0E-5 && (Math.abs(this.thirdRotation_) == 90.0 || Math.abs(this.thirdRotation_) == 270.0)) {
            Point2D.Double p1 = this.transformLL2XYIgnoreMargins(this.lambdaC_ - 89.99999, 0.0);
            Point2D.Double p2 = this.transformLL2XYIgnoreMargins(this.lambdaC_ + 89.99999, 0.0);
            if (p1 != null && p2 != null) {
                GraphicUtils.drawLine(g2d, p1, p2);
            }
        } else {
            super.drawParallel(g2d, lat, label);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        double absPhiC = Math.abs(this.phiC_);
        double signPhiC = Math.signum(this.phiC_);
        double lambda = this.lonToLambda(lon);
        double absLambda = Math.abs(lambda);
        Point2D.Double dot1 = null;
        Point2D.Double dot2 = null;
        if (absPhiC > 89.99999) {
            double rotlon;
            double d = rotlon = this.phiC_ > 0.0 ? MapUtils.normalizeMP180(lambda + this.thirdRotation_) : MapUtils.normalizeMP180(lambda - this.thirdRotation_);
            if (rotlon % 90.0 == 0.0) {
                double phiCC = signPhiC * Math.min(maxLat, 89.99999);
                dot1 = this.transformLL2XYIgnoreMargins(lon, phiCC);
                dot2 = rotlon % 180.0 == 0.0 ? this.transformLL2XYIgnoreMargins(lon, signPhiC * 1.0E-5) : this.transformLL2XYIgnoreMargins(lon, -phiCC);
                GraphicUtils.drawLine(g2d, dot1, dot2);
            } else {
                super.drawMeridian(g2d, lon, maxLat, label);
            }
            return;
        }
        if (absPhiC < 1.0E-5 && this.thirdRotation_ % 90.0 == 0.0) {
            if (absLambda < 1.0E-5) {
                dot1 = this.transformLL2XYIgnoreMargins(lon, maxLat);
                dot2 = this.transformLL2XYIgnoreMargins(lon, -maxLat);
                GraphicUtils.drawLine(g2d, dot1, dot2);
                return;
            }
            if (absLambda > 179.99999) {
                return;
            }
        }
        if (this.thirdRotation_ % 180.0 == 0.0) {
            double endLat = Math.min(maxLat, 90.0 - absPhiC) - 1.0E-5;
            if (absLambda < 1.0E-5) {
                dot1 = this.transformLL2XYIgnoreMargins(lon, signPhiC * maxLat);
                dot2 = this.transformLL2XYIgnoreMargins(lon, -signPhiC * endLat);
                GraphicUtils.drawLine(g2d, dot1, dot2);
                return;
            }
            if (absLambda > 179.99999) {
                if (maxLat < endLat) {
                    return;
                }
                dot1 = this.transformLL2XYIgnoreMargins(lon, signPhiC * maxLat);
                dot2 = this.transformLL2XYIgnoreMargins(lon, signPhiC * endLat);
                GraphicUtils.drawLine(g2d, dot1, dot2);
                return;
            }
        } else if (this.thirdRotation_ % 90.0 == 0.0) {
            if (absLambda < 1.0E-5) {
                dot1 = this.transformLL2XYIgnoreMargins(lon, maxLat);
                dot2 = this.transformLL2XYIgnoreMargins(lon, -maxLat);
                GraphicUtils.drawLine(g2d, dot1, dot2);
                return;
            }
            if (absLambda > 179.99999) {
                double endLat1 = Math.min(maxLat, absPhiC) - 1.0E-5;
                dot1 = this.transformLL2XYIgnoreMargins(lon, signPhiC * maxLat);
                dot2 = this.transformLL2XYIgnoreMargins(lon, -signPhiC * endLat1);
                GraphicUtils.drawLine(g2d, dot1, dot2);
                if (maxLat > absPhiC) {
                    double endLat2 = absPhiC + 1.0E-5;
                    dot1 = this.transformLL2XYIgnoreMargins(lon, -signPhiC * maxLat);
                    dot2 = this.transformLL2XYIgnoreMargins(lon, -signPhiC * endLat2);
                    GraphicUtils.drawLine(g2d, dot1, dot2);
                }
                return;
            }
        }
        super.drawMeridian(g2d, lon, maxLat, label);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        ProjGraphicUtils.drawEllipse(g2d, this.outCenterX_, this.outCenterY_, this.xmRS_, this.ymRS_);
    }
}

