/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.map.proj.ProjBooleanParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrteliusOval
extends GlobalPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Ortelius Oval";
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 1.5707963267948966;
    private final ProjBooleanParameter globalParam_ = new ProjBooleanParameter("Show full globe rather than hemisphere", "Global", true);

    public OrteliusOval(int width, int height) {
        this(width, height, 0, 0);
    }

    public OrteliusOval(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.addParameter(this.globalParam_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p.equals(this.globalParam_)) {
            this.setGlobal(this.globalParam_.isSelected());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setGlobal(boolean global) {
        super.setGlobalProj(global);
    }

    @Override
    protected final void prepareScaling() {
        if (this.isGlobal()) {
            this.setMaxXYOverRS(Math.PI, 1.5707963267948966);
        } else {
            this.setMaxXYOverRS(1.5707963267948966);
        }
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double phiRad = Math.toRadians(lat);
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLambdaRad = Math.abs(lambdaRad);
        double x = 1.0;
        if (lambdaRad == 0.0) {
            x = 0.0;
        } else {
            if (!this.isGlobal() && absLambdaRad > 1.5707963267948966) {
                return null;
            }
            double f = absLambdaRad <= 1.5707963267948966 ? 0.5 * (absLambdaRad + 2.4674011002723395 / absLambdaRad) : 1.5707963267948966;
            x = absLambdaRad - f + Math.sqrt(f * f - phiRad * phiRad);
            if (lambdaRad < 0.0) {
                x *= -1.0;
            }
        }
        double y = phiRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absx = Math.abs(x);
        double absy = Math.abs(y);
        if (absx > (double)this.dxMax_ || absy > (double)this.dyMax_) {
            return null;
        }
        double absXOverRS = absx * this.invRS_;
        double absYOverRS = absy * this.invRS_;
        double phiRad = absYOverRS;
        if (phiRad > 1.5707963267948966) {
            return null;
        }
        double rho2 = x * x + y * y;
        double rhoMax = this.ymRS_;
        double rhoMax2 = rhoMax * rhoMax;
        double r2s2 = this.rS_ * this.rS_;
        if (x == 0.0) {
            lambdaRad = 0.0;
        } else if (y == 0.0) {
            lambdaRad = absXOverRS;
        } else if (rho2 > rhoMax2) {
            lambdaRad = absXOverRS + 1.5707963267948966 - Math.sqrt(2.4674011002723395 - phiRad * phiRad);
        } else {
            double b = -(rho2 - r2s2 * 2.4674011002723395) / absXOverRS;
            double c = -2.4674011002723395;
            lambdaRad = 0.5 * (-b + Math.sqrt(b * b - -9.869604401089358));
        }
        if (lambdaRad > Math.PI) {
            return null;
        }
        if (!this.isGlobal() && lambdaRad > 1.5707963267948966) {
            return null;
        }
        double phi = Math.signum(y) * Math.toDegrees(phiRad);
        double lambda = Math.signum(x) * Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        double rhoMax = this.ymRS_;
        double rhoMax2 = rhoMax * rhoMax;
        double r2s2 = this.rS_ * this.rS_;
        OrteliusOval orteliusOval = this;
        synchronized (orteliusOval) {
            block3: for (int iy = 0; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double y2 = y * y;
                double phiRad = y * this.invRS_;
                if (phiRad > 1.5707963267948966) continue;
                double phi = Math.toDegrees(phiRad);
                double phiRad2 = phiRad * phiRad;
                double xFactor = 1.5707963267948966 - Math.sqrt(2.4674011002723395 - phiRad2);
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double lambdaRad;
                    double x = (double)ix + 0.5;
                    double rho2 = x * x + y2;
                    if (x == 0.0) {
                        lambdaRad = 0.0;
                    } else if (y == 0.0) {
                        lambdaRad = x * this.invRS_;
                    } else if (rho2 > rhoMax2) {
                        lambdaRad = x * this.invRS_ + xFactor;
                    } else {
                        double b = -(rho2 - r2s2 * 2.4674011002723395) / (x * this.rS_);
                        double c = -2.4674011002723395;
                        lambdaRad = 0.5 * (-b + Math.sqrt(b * b - -9.869604401089358));
                    }
                    if (lambdaRad > Math.PI) continue;
                    if (!this.isGlobal() && lambdaRad > 1.5707963267948966) continue block3;
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        if (this.isGlobal()) {
            super.drawBorderLines(g2d);
            return;
        }
        ProjGraphicUtils.drawEllipse(g2d, this.outCenterX_, this.outCenterY_, this.ymRS_, this.ymRS_);
    }

    @Override
    protected void drawMeridianNoLabel(Graphics2D g2d, double lon, double maxLat) {
        double lambdaRad = this.lonToLambdaRad(lon);
        double xlat = Math.min(maxLat, 89.99999);
        Point2D.Double dotN = this.transformLL2XY(lon, xlat);
        Point2D.Double dotS = this.transformLL2XY(lon, -xlat);
        if (dotN == null || dotS == null) {
            LOGGER.trace("got null dot at max lat for lon {}");
            return;
        }
        if (Math.abs(lambdaRad) < 1.0E-5) {
            GraphicUtils.drawLine(g2d, dotN, dotS);
        } else {
            Point2D.Double dotEq = this.transformLL2XY(lon, 0.0);
            if (dotEq == null) {
                return;
            }
            GraphicUtils.drawCircularArc(g2d, dotN, dotEq, dotS);
        }
    }
}

