/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.panoply.data.PanData2D;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanPlotScaleMeta;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanDataImage
extends BufferedImage {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanPlotMeta pmeta_;

    public PanDataImage(PanPlotMeta pmeta, PanData2D data) {
        super(data.getWidth(), data.getHeight(), 2);
        this.pmeta_ = pmeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintData(boolean knockout) {
        PanDataImage panDataImage = this;
        synchronized (panDataImage) {
            PanPlotScaleMeta smeta = this.pmeta_.getScaleMeta();
            smeta.prepareColorTable(knockout);
            PanData2D data2D = (PanData2D)this.pmeta_.getData();
            Graphics2D g2d = this.createGraphics();
            int iwidth = this.getWidth();
            int jheight = this.getHeight();
            Color bg = this.pmeta_.getColor("color.background");
            if (knockout) {
                int ibg = bg.getRGB() & 0x999999;
                bg = new Color(ibg, true);
            }
            g2d.setColor(bg);
            GraphicUtils.fillRect(g2d, 0.0, 0.0, iwidth, jheight);
            for (int j = 0; j < jheight; ++j) {
                for (int i = 0; i < iwidth; ++i) {
                    double value = data2D.valueAt(i, j);
                    this.setRGB(i, j, smeta.rgbaForValue(value));
                }
            }
            g2d.dispose();
        }
    }
}

