/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plotui;

import gov.nasa.giss.graphics.plot.PlotPropertyEvent;
import gov.nasa.giss.graphics.plot.PlotPropertyListener;
import gov.nasa.giss.panoply.menu.PanMenuBar;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanScaleControls;
import gov.nasa.giss.panoply.ui.PanButton;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.QuickBox;
import gov.nasa.giss.ui.menu.GissMenu;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;

public class PanScaleControls1D
extends PanScaleControls
implements PlotPropertyListener {
    private static final PrintfFormat PFORMAT_10G = new PrintfFormat("%.10g");
    private PanButton swapBtn_;
    private Action swapAction_;
    private boolean refreshing_;

    public PanScaleControls1D(PanPlotMeta pmeta, PanMenuBar mbar) {
        super(pmeta, mbar);
        if (!this.ptype_.isLinePlot()) {
            throw new IllegalArgumentException("Plot type is not line plot.");
        }
        this.createActions(mbar);
        this.createLayout();
        this.refreshPrivate();
    }

    private void createActions(PanMenuBar mbar) {
        GissMenu plotMenu = mbar.getMenuForName("plot-menu");
        switch (this.ptype_) {
            case HORZ_LINE: 
            case LL_ZONAL: {
                this.swapAction_ = new SwapBoundsAction("swap-ybounds");
                this.pmeta_.putAction("swap-ybounds", this.swapAction_);
                plotMenu.getItemForName("swap-ybounds").setAction(this.swapAction_);
                plotMenu.getItemForName("swap-ybounds").setEnabled(true);
                plotMenu.getItemForName("log-scale").setEnabled(true);
                break;
            }
            case VERT_LINE: {
                this.swapAction_ = new SwapBoundsAction("swap-xbounds");
                this.pmeta_.putAction("swap-xbounds", this.swapAction_);
                plotMenu.getItemForName("swap-xbounds").setAction(this.swapAction_);
                plotMenu.getItemForName("swap-xbounds").setEnabled(true);
                plotMenu.getItemForName("log-scale").setEnabled(false);
                break;
            }
            default: {
                throw new RuntimeException("Bad plot type specified for a line plot.");
            }
        }
    }

    private void createLayout() {
        JLabel axLabel2;
        JLabel axLabel1;
        switch (this.ptype_) {
            case HORZ_LINE: 
            case LL_ZONAL: {
                axLabel1 = new JLabel("Bottom:\u2009");
                axLabel2 = new JLabel(", Top:\u2009");
                this.swapBtn_ = PanButton.small("swap-ybounds", this.swapAction_, "Swap B/T");
                break;
            }
            case VERT_LINE: {
                axLabel1 = new JLabel("Left:\u2009");
                axLabel2 = new JLabel(", Right:\u2009");
                this.swapBtn_ = PanButton.small("swap-xbounds", this.swapAction_, "Swap L/R");
                break;
            }
            default: {
                throw new RuntimeException("Bad plot type specified for a line plot.");
            }
        }
        this.fitToDataBtn_.setText("Reset");
        QuickBox rangeBox = QuickBox.createLeftBox(axLabel1, this.val1TF_, axLabel2, this.val2TF_, this.swapBtn_, this.fitToDataBtn_, Box.createVerticalStrut(12));
        JLabel unitsLabel1 = new JLabel("Units:\u2009");
        JLabel unitsLabel2 = new JLabel("of\u2009");
        JLabel scalingLabel = new JLabel("\u00d7 ");
        JLabel tenLabel = new JLabel("\u00d7 10^");
        QuickBox unitsBox = QuickBox.createLeftBox(unitsLabel1, this.methodCombo_, unitsLabel2, this.unitsCombo_, scalingLabel, this.coeffTF_, tenLabel, this.expSpinner_);
        JLabel formatLabel1 = new JLabel("Ticks:\u2009");
        JLabel formatLabel2 = new JLabel("Format:\u2009");
        JLabel formatLabel3 = new JLabel("\u2014 ");
        JLabel formatLabel4 = new JLabel("Divisions: Major:\u2009");
        JLabel formatLabel5 = new JLabel(", Minor:\u2009");
        JLabel formatLabel6 = new JLabel("\u2014 Size:\u2009");
        QuickBox divBox = QuickBox.createLeftBox(formatLabel1, formatLabel2, this.tickFormatCombo_, formatLabel3, formatLabel4, this.majorDivSpinner_, formatLabel5, this.minorDivSpinner_, formatLabel6, this.tickSizeCombo_);
        JLabel captionLabel1 = new JLabel("Caption:\u2009");
        JLabel captionLabel2 = new JLabel("\u2014 Size:\u2009");
        QuickBox captionBox = QuickBox.createLeftBox(captionLabel1, this.dfltCapBtn_, this.customCapBtn_, this.captionTF_, captionLabel2, this.captionSizeCombo_);
        int tfh = this.captionTF_.getPreferredSize().height;
        this.captionTF_.setMinimumSize(new Dimension(150, tfh));
        this.captionTF_.setPreferredSize(new Dimension(225, tfh));
        this.captionTF_.setMaximumSize(new Dimension(1000, tfh));
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 1));
        this.add(rangeBox);
        this.add(Box.createVerticalStrut(1));
        this.add(unitsBox);
        this.add(Box.createVerticalStrut(1));
        this.add(divBox);
        this.add(Box.createVerticalStrut(1));
        this.add(captionBox);
        GuiUtils.setSizeSmall(this);
        GuiUtils.matchLabelWidths(axLabel1, unitsLabel1, formatLabel1, captionLabel1);
    }

    private void swapExtrema() {
        double oldval1 = this.pmeta_.getDouble("scale.min");
        double oldval2 = this.pmeta_.getDouble("scale.max");
        String bstr = this.val2TF_.getText();
        String tstr = this.val1TF_.getText();
        this.val2TF_.setText(tstr);
        this.val1TF_.setText(bstr);
        this.pmeta_.setGroup({"scale.min", oldval2}, {"scale.max", oldval1});
    }

    @Override
    public void setScaleRange(double val1, double val2) {
        this.val1TF_.setText(PFORMAT_10G.sprintfx(val1));
        this.val2TF_.setText(PFORMAT_10G.sprintfx(val2));
        this.pmeta_.setGroup({"scale.min", val1}, {"scale.max", val2});
    }

    public void zoom(double factor) {
        double oldval1 = this.pmeta_.getDouble("scale.min");
        double oldval2 = this.pmeta_.getDouble("scale.max");
        double center = 0.5 * (oldval1 + oldval2);
        double diff = oldval2 - oldval1;
        double newdiff = diff / factor;
        double halfdiff = 0.5 * newdiff;
        double newval1 = center - halfdiff;
        double newval2 = center + halfdiff;
        this.setScaleRange(newval1, newval2);
    }

    public void zoom(double factor, double center) {
        double oldval1 = this.pmeta_.getDouble("scale.min");
        double oldval2 = this.pmeta_.getDouble("scale.max");
        double diff = oldval2 - oldval1;
        double newdiff = diff / factor;
        double halfdiff = 0.5 * newdiff;
        double newval1 = center - halfdiff;
        double newval2 = center + halfdiff;
        this.setScaleRange(newval1, newval2);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshPrivate();
    }

    private void refreshPrivate() {
        if (this.refreshing_) {
            return;
        }
        this.refreshing_ = true;
        boolean autoScaleOn = this.pmeta_.getBoolean("scale.autofit");
        this.swapBtn_.setEnabled(!autoScaleOn);
        this.refreshing_ = false;
    }

    @Override
    public void plotPropertyChanged(PlotPropertyEvent e) {
        boolean changeAll;
        if (e == null) {
            return;
        }
        super.plotPropertyChanged(e);
        String pname = e.getMessage();
        boolean bl = changeAll = pname == null || "all".equals(pname);
        if (changeAll || pname.contains("scale.autofit")) {
            this.scheduleRefreshTask();
        }
        this.repaint();
    }

    class SwapBoundsAction
    extends AbstractAction {
        private boolean busy_;

        SwapBoundsAction(String actionID) {
            super(PanProperties.MENU_PROPS.getString(actionID));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.busy_) {
                return;
            }
            this.busy_ = true;
            PanScaleControls1D.this.swapExtrema();
            this.busy_ = false;
        }
    }
}

