/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.data.nc.NcConfig;
import gov.nasa.giss.panoply.log.PanLoggingUtils;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.prefs.PanSavedSettingsHandler;
import gov.nasa.giss.panoply.server.PanServer;
import gov.nasa.giss.panoply.util.PanUtils;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanQuitHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static boolean enabled_ = true;
    private static boolean quitting_;

    public static void setEnabled(boolean enabled) {
        LOGGER.trace("{}", (Object)enabled);
        enabled_ = enabled;
    }

    public static void quit() {
        block14: {
            block13: {
                block12: {
                    LOGGER.trace("{}, {}", (Object)enabled_, (Object)quitting_);
                    if (!enabled_) {
                        return;
                    }
                    if (quitting_) {
                        return;
                    }
                    quitting_ = true;
                    LOGGER.info("Panoply is shutting down.");
                    if (PanUtils.isDevoSavedSettings()) {
                        try {
                            LOGGER.trace("Saving saved settings.");
                            PanSavedSettingsHandler.getSharedInstance().save();
                        }
                        catch (Exception exc) {
                            LOGGER.warn("Failed to save preferences due to exception: {}.", exc);
                            if (!LOGGER.isDebugEnabled()) break block12;
                            exc.printStackTrace();
                        }
                    }
                }
                try {
                    LOGGER.trace("Saving prefs.");
                    PanPreferences.getSharedInstance().save();
                }
                catch (Exception exc) {
                    LOGGER.warn("Failed to save preferences due to exception: {}.", exc);
                    if (!LOGGER.isDebugEnabled()) break block13;
                    exc.printStackTrace();
                }
            }
            try {
                if (PanServer.instanceExists()) {
                    LOGGER.trace("Shutting down server instance.");
                    PanServer.getSharedInstance().close();
                }
            }
            catch (Exception exc) {
                LOGGER.warn("Failed to halt 'server' instance due to exception: {}.", exc);
                if (!LOGGER.isDebugEnabled()) break block14;
                exc.printStackTrace();
            }
        }
        try {
            LOGGER.trace("Clearing NJ cache.");
            NcConfig.clearCache();
        }
        catch (Exception exc) {
            LOGGER.warn("Failed to clear NJ cache due to exception: {}.", exc);
        }
        LOGGER.trace("Closing log (if opened). Good-bye.");
        PanLoggingUtils.closeLoggers();
        System.exit(0);
    }

    public static boolean isQuitting() {
        LOGGER.trace("{}", (Object)quitting_);
        return quitting_;
    }

    private PanQuitHandler() {
    }
}

