/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui;

import gov.nasa.giss.graphics.GraphicUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.border.Border;

public final class ArrowButton
extends JButton {
    protected static final Color TRANSPARENT = new Color(255, 255, 255, 0);
    private static final int BTN_SIZE = 16;
    private static final Path2D.Float ARROW = new Path2D.Float();
    private Direction direction_;

    public ArrowButton(Direction direction, String name, Action action) {
        super(action);
        this.direction_ = direction;
        if (name != null) {
            super.setName(name);
        }
        super.setBorder(null);
        super.setText(" ");
        Dimension bdd = new Dimension(16, 16);
        super.setPreferredSize(bdd);
        super.setMaximumSize(bdd);
        super.setMinimumSize(bdd);
    }

    @Override
    public final void setBorder(Border b) {
    }

    @Override
    public void setText(String text) {
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        Composite oldComp = g2d.getComposite();
        g2d.setComposite(AlphaComposite.getInstance(3, 0.25f));
        super.paintComponent(g2d);
        g2d.setComposite(oldComp);
        g2d.translate(8.0, 8.0);
        switch (this.direction_) {
            case NORTH: {
                break;
            }
            case SOUTH: {
                g2d.rotate(Math.PI);
                break;
            }
            case EAST: {
                g2d.rotate(1.5707963267948966);
                break;
            }
            case WEST: {
                g2d.rotate(-1.5707963267948966);
            }
        }
        g2d.fill(ARROW);
        g2d.dispose();
    }

    static {
        ARROW.moveTo(0.0f, -3.75f);
        ARROW.lineTo(4.3f, 3.75f);
        ARROW.lineTo(-4.3f, 3.75f);
        ARROW.closePath();
    }

    public static enum Direction {
        NORTH,
        SOUTH,
        EAST,
        WEST;

    }
}

