/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.panel;

import gov.nasa.giss.ui.border.CheckBoxBorder;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Objects;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class CheckBoxBorderPanel
extends JPanel {
    private JCheckBox checkbox_;
    private JPanel content_;

    public CheckBoxBorderPanel(JCheckBox jcb) {
        this(jcb, null);
    }

    public CheckBoxBorderPanel(JCheckBox checkbox, JPanel content) {
        Objects.requireNonNull(checkbox, "Checkbox cannot be null.");
        this.checkbox_ = checkbox;
        this.content_ = content == null ? new JPanel() : content;
        this.setBorder(new CheckBoxBorder(checkbox));
        this.setLayout(null);
        super.add(this.checkbox_);
        super.add(this.content_);
    }

    public JCheckBox getCheckBox() {
        return this.checkbox_;
    }

    public JPanel getContentPanel() {
        return this.content_;
    }

    @Override
    public void validate() {
        Insets ins = this.getInsets();
        this.content_.setBounds(ins.left, ins.top, this.getWidth() - ins.left - ins.right, this.getHeight() - ins.top - ins.bottom);
        super.validate();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension csize = this.content_.getPreferredSize();
        Insets ins = this.getInsets();
        return new Dimension(csize.width + ins.left + ins.right, csize.height + ins.top + ins.bottom);
    }
}

