/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.btn.ability.impl;

import com.ghostchu.peerbanhelper.btn.BtnNetwork;
import com.ghostchu.peerbanhelper.btn.ability.AbstractBtnAbility;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.google.common.net.InetAddresses;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.SocketFactory;
import lombok.Generated;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.NetworkIF;

public final class BtnAbilityHeartBeat
extends AbstractBtnAbility {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BtnAbilityHeartBeat.class);
    private final BtnNetwork btnNetwork;
    private final long interval;
    private final long randomInitialDelay;
    private final String endpoint;
    private final boolean multiIf;
    private String lastResult = "No information";

    public BtnAbilityHeartBeat(BtnNetwork btnNetwork, JsonObject ability) {
        this.btnNetwork = btnNetwork;
        this.interval = ability.get("interval").getAsLong();
        this.endpoint = ability.get("endpoint").getAsString();
        this.multiIf = ability.get("multi_if").getAsBoolean();
        this.randomInitialDelay = ability.get("random_initial_delay").getAsLong();
    }

    @Override
    public String getName() {
        return "BtnAbilityHeartBeat";
    }

    @Override
    public TranslationComponent getDisplayName() {
        return new TranslationComponent(Lang.BTN_HEARTBEAT_TITLE);
    }

    @Override
    public TranslationComponent getDescription() {
        return new TranslationComponent(Lang.BTN_HEARTBEAT_DESCRIPTION, this.lastResult);
    }

    @Override
    public void load() {
        this.setLastStatus(true, new TranslationComponent(Lang.BTN_STAND_BY));
        this.btnNetwork.getScheduler().scheduleWithFixedDelay(this::sendHeartBeat, this.interval + ThreadLocalRandom.current().nextLong(this.randomInitialDelay), this.interval, TimeUnit.MILLISECONDS);
    }

    private void sendHeartBeat() {
        if (this.multiIf) {
            this.sendHeartBeatMultiIf();
        } else {
            this.sendHeartBeatDefaultIf();
        }
    }

    private void sendHeartBeatDefaultIf() {
        RequestBody body = RequestBody.create((String)JsonUtil.standard().toJson(Map.of("ifaddr", "default")), (MediaType)MediaType.parse((String)"application/json"));
        Request.Builder request = new Request.Builder().url(this.endpoint).post(body);
        try (Response resp = this.btnNetwork.getHttpUtil().newBuilder().build().newCall(request.build()).execute();){
            if (!resp.isSuccessful()) {
                this.setLastStatus(true, new TranslationComponent(Lang.BTN_HEARTBEAT_FAILED));
                this.lastResult = "default -> Failed: " + resp.code() + " - " + resp.body().string();
            } else {
                this.setLastStatus(true, new TranslationComponent(Lang.BTN_HEARTBEAT_SUCCESS));
                ServerResponse data = (ServerResponse)JsonUtil.standard().fromJson(resp.body().charStream(), ServerResponse.class);
                this.lastResult = data != null && data.getExternalIp() != null ? "default -> " + data.getExternalIp() : "default -> No External IP returned";
            }
        }
        catch (IOException | JSONException e) {
            this.lastResult = "default -> Failed: " + e.getClass().getName() + ": " + e.getMessage();
            this.setLastStatus(true, new TranslationComponent(Lang.BTN_HEARTBEAT_FAILED));
        }
    }

    private void sendHeartBeatMultiIf() {
        List<CompletableFuture> futures = Collections.synchronizedList(new ArrayList());
        AtomicBoolean anySuccess = new AtomicBoolean(false);
        ArrayList<String> ifNets = new ArrayList<String>();
        for (NetworkIF networkIF : new SystemInfo().getHardware().getNetworkIFs()) {
            String[] ipv4 = networkIF.getIPv4addr();
            String[] ipv6 = networkIF.getIPv6addr();
            ifNets.addAll(Arrays.asList(ipv4));
            ifNets.addAll(Arrays.asList(ipv6));
        }
        Map result = Collections.synchronizedMap(new TreeMap());
        try (ExecutorService executorService = Executors.newVirtualThreadPerTaskExecutor();){
            ifNets.forEach(ip -> futures.add(CompletableFuture.runAsync(() -> {
                OkHttpClient client = this.createHttpClient((String)ip);
                RequestBody body = RequestBody.create((String)JsonUtil.standard().toJson(Map.of("ifaddr", ip)), (MediaType)MediaType.parse((String)"application/json"));
                Request.Builder request = new Request.Builder().url(this.endpoint).post(body);
                try (Response resp = client.newCall(request.build()).execute();){
                    if (!resp.isSuccessful()) {
                        result.put(ip, "Failed: " + resp.code() + ": " + resp.message());
                    } else {
                        ServerResponse data = (ServerResponse)JsonUtil.standard().fromJson(resp.body().charStream(), ServerResponse.class);
                        if (data != null && data.getExternalIp() != null) {
                            result.put(ip, data.getExternalIp());
                            anySuccess.set(true);
                        } else {
                            result.put(ip, "Failed: No external IP returned");
                        }
                    }
                }
                catch (IOException | JSONException e) {
                    result.put(ip, "Failed: " + e.getClass().getName() + ": " + e.getMessage());
                }
            }, executorService)));
        }
        for (CompletableFuture future : futures) {
            try {
                future.get(30L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                log.warn("Heartbeat request timed out");
                future.cancel(true);
            }
            catch (InterruptedException | ExecutionException e) {
                log.warn("Heartbeat request failed", (Throwable)e);
            }
        }
        if (anySuccess.get()) {
            this.setLastStatus(true, new TranslationComponent(Lang.BTN_HEARTBEAT_SUCCESS));
        } else {
            this.setLastStatus(false, new TranslationComponent(Lang.BTN_HEARTBEAT_FAILED));
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry pair : result.entrySet()) {
            builder.append((String)pair.getKey()).append(" -> ").append((String)pair.getValue()).append("\n");
        }
        this.lastResult = builder.toString();
    }

    private OkHttpClient createHttpClient(final String ifNet) {
        return this.btnNetwork.getHttpUtil().newBuilder().socketFactory(new SocketFactory(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public Socket createSocket(String host, int port) throws IOException {
                try {
                    return new Socket(host, port, InetAddresses.forString((String)ifNet), 0);
                }
                catch (IllegalArgumentException e) {
                    throw new IOException("Invalid local IP address: " + ifNet, e);
                }
            }

            @Override
            public Socket createSocket(InetAddress address, int port) throws IOException {
                try {
                    return new Socket(address, port, InetAddresses.forString((String)ifNet), 0);
                }
                catch (IllegalArgumentException e) {
                    throw new IOException("Invalid local IP address: " + ifNet, e);
                }
            }

            @Override
            public Socket createSocket(String host, int port, InetAddress clientAddress, int clientPort) throws IOException {
                return new Socket(host, port, clientAddress, clientPort);
            }

            @Override
            public Socket createSocket(InetAddress address, int port, InetAddress clientAddress, int clientPort) throws IOException {
                return new Socket(address, port, clientAddress, clientPort);
            }
        }).build();
    }

    @Override
    public void unload() {
    }

    static class ServerResponse {
        @SerializedName(value="external_ip")
        private String externalIp;

        @Generated
        public ServerResponse(String externalIp) {
            this.externalIp = externalIp;
        }

        @Generated
        public String getExternalIp() {
            return this.externalIp;
        }

        @Generated
        public void setExternalIp(String externalIp) {
            this.externalIp = externalIp;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServerResponse)) {
                return false;
            }
            ServerResponse other = (ServerResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$externalIp = this.getExternalIp();
            String other$externalIp = other.getExternalIp();
            return !(this$externalIp == null ? other$externalIp != null : !this$externalIp.equals(other$externalIp));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ServerResponse;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $externalIp = this.getExternalIp();
            result = result * 59 + ($externalIp == null ? 43 : $externalIp.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BtnAbilityHeartBeat.ServerResponse(externalIp=" + this.getExternalIp() + ")";
        }
    }
}

