/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.monitor;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.database.dao.impl.tmp.TrackedSwarmDao;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.module.AbstractFeatureModule;
import com.ghostchu.peerbanhelper.module.MonitorFeatureModule;
import com.ghostchu.peerbanhelper.util.CommonUtil;
import com.ghostchu.peerbanhelper.util.query.Orderable;
import com.ghostchu.peerbanhelper.util.query.Page;
import com.ghostchu.peerbanhelper.util.query.Pageable;
import com.ghostchu.peerbanhelper.web.JavalinWebContainer;
import com.ghostchu.peerbanhelper.web.Role;
import com.ghostchu.peerbanhelper.web.wrapper.StdResp;
import io.javalin.http.Context;
import io.javalin.security.RouteRole;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class SwarmTrackingModule
extends AbstractFeatureModule
implements MonitorFeatureModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SwarmTrackingModule.class);
    @Autowired
    private TrackedSwarmDao trackedSwarmDao;
    @Autowired
    private JavalinWebContainer javalinWebContainer;

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        return "Swarm Tracking Module";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "peer-analyse-service.swarm-tracking";
    }

    @Override
    public void onEnable() {
        Main.getEventBus().register((Object)this);
        this.javalinWebContainer.javalin().get("/api/modules/swarm-tracking", this::handleWebAPI, new RouteRole[]{Role.USER_READ});
        this.javalinWebContainer.javalin().get("/api/modules/swarm-tracking/details", this::handleDetails, new RouteRole[]{Role.USER_READ});
        CommonUtil.getScheduler().scheduleWithFixedDelay(this.trackedSwarmDao::flushAll, 0L, this.getConfig().getLong("data-flush-interval"), TimeUnit.MILLISECONDS);
    }

    private void handleDetails(@NotNull Context context) {
        Pageable pageable = new Pageable(context);
        try {
            Page page = this.trackedSwarmDao.queryByPaging(new Orderable(Map.of(), context).apply(this.trackedSwarmDao.queryBuilder()), pageable);
            context.json((Object)new StdResp(true, null, page));
        }
        catch (SQLException e) {
            log.error("Unable to retrieve tracked swarm data", (Throwable)e);
            context.json((Object)new StdResp(false, "Unable to retrieve tracked swarm data", null));
        }
    }

    private void handleWebAPI(@NotNull Context context) {
        HashMap<String, Long> response = new HashMap<String, Long>();
        try {
            response.put("trackedSwarmSize", this.trackedSwarmDao.countOf());
            context.json(response);
        }
        catch (SQLException e) {
            log.error("Unable to retrieve tracked swarm data", (Throwable)e);
            context.status(500).json((Object)new StdResp(false, "Unable to retrieve tracked swarm data", null));
        }
    }

    @Override
    public void onDisable() {
        Main.getEventBus().unregister((Object)this);
        this.trackedSwarmDao.flushAll();
    }

    @Override
    public void onTorrentPeersRetrieved(@NotNull Downloader downloader, @NotNull Torrent torrent, @NotNull List<Peer> peers) {
        try {
            for (Peer peer : peers) {
                if (peer.isHandshaking()) continue;
                this.trackedSwarmDao.syncPeers(downloader, torrent, peer);
            }
        }
        catch (ExecutionException e) {
            log.error("Unable update tracked peers in SQLite temporary table", (Throwable)e);
        }
    }
}

