# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RecycleDetails(object):
    """
    Shows details about the last recycle performed on this host.
    """

    #: A constant which can be used with the recycle_level property of a RecycleDetails.
    #: This constant has a value of "SKIP_RECYCLE"
    RECYCLE_LEVEL_SKIP_RECYCLE = "SKIP_RECYCLE"

    #: A constant which can be used with the recycle_level property of a RecycleDetails.
    #: This constant has a value of "FULL_RECYCLE"
    RECYCLE_LEVEL_FULL_RECYCLE = "FULL_RECYCLE"

    def __init__(self, **kwargs):
        """
        Initializes a new RecycleDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param recycle_level:
            The value to assign to the recycle_level property of this RecycleDetails.
            Allowed values for this property are: "SKIP_RECYCLE", "FULL_RECYCLE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type recycle_level: str

        :param compute_host_group_id:
            The value to assign to the compute_host_group_id property of this RecycleDetails.
        :type compute_host_group_id: str

        """
        self.swagger_types = {
            'recycle_level': 'str',
            'compute_host_group_id': 'str'
        }
        self.attribute_map = {
            'recycle_level': 'recycleLevel',
            'compute_host_group_id': 'computeHostGroupId'
        }
        self._recycle_level = None
        self._compute_host_group_id = None

    @property
    def recycle_level(self):
        """
        Gets the recycle_level of this RecycleDetails.
        Preferred recycle level for hosts associated with the reservation config.
        * `SKIP_RECYCLE` - Skips host wipe.
        * `FULL_RECYCLE` - Does not skip host wipe. This is the default behavior.

        Allowed values for this property are: "SKIP_RECYCLE", "FULL_RECYCLE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The recycle_level of this RecycleDetails.
        :rtype: str
        """
        return self._recycle_level

    @recycle_level.setter
    def recycle_level(self, recycle_level):
        """
        Sets the recycle_level of this RecycleDetails.
        Preferred recycle level for hosts associated with the reservation config.
        * `SKIP_RECYCLE` - Skips host wipe.
        * `FULL_RECYCLE` - Does not skip host wipe. This is the default behavior.


        :param recycle_level: The recycle_level of this RecycleDetails.
        :type: str
        """
        allowed_values = ["SKIP_RECYCLE", "FULL_RECYCLE"]
        if not value_allowed_none_or_none_sentinel(recycle_level, allowed_values):
            recycle_level = 'UNKNOWN_ENUM_VALUE'
        self._recycle_level = recycle_level

    @property
    def compute_host_group_id(self):
        """
        Gets the compute_host_group_id of this RecycleDetails.
        The `OCID`__ of the compute host group this host was attached to at the time of recycle.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compute_host_group_id of this RecycleDetails.
        :rtype: str
        """
        return self._compute_host_group_id

    @compute_host_group_id.setter
    def compute_host_group_id(self, compute_host_group_id):
        """
        Sets the compute_host_group_id of this RecycleDetails.
        The `OCID`__ of the compute host group this host was attached to at the time of recycle.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compute_host_group_id: The compute_host_group_id of this RecycleDetails.
        :type: str
        """
        self._compute_host_group_id = compute_host_group_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
