# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CloudAsmConfiguration(object):
    """
    The configuration details of an ASM.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CloudAsmConfiguration object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param init_parameters:
            The value to assign to the init_parameters property of this CloudAsmConfiguration.
        :type init_parameters: list[oci.database_management.models.CloudAsmInstanceParameters]

        """
        self.swagger_types = {
            'init_parameters': 'list[CloudAsmInstanceParameters]'
        }
        self.attribute_map = {
            'init_parameters': 'initParameters'
        }
        self._init_parameters = None

    @property
    def init_parameters(self):
        """
        **[Required]** Gets the init_parameters of this CloudAsmConfiguration.
        An array of initialization parameters for the cloud ASM instances.


        :return: The init_parameters of this CloudAsmConfiguration.
        :rtype: list[oci.database_management.models.CloudAsmInstanceParameters]
        """
        return self._init_parameters

    @init_parameters.setter
    def init_parameters(self, init_parameters):
        """
        Sets the init_parameters of this CloudAsmConfiguration.
        An array of initialization parameters for the cloud ASM instances.


        :param init_parameters: The init_parameters of this CloudAsmConfiguration.
        :type: list[oci.database_management.models.CloudAsmInstanceParameters]
        """
        self._init_parameters = init_parameters

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
