# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ManagedMySqlDatabaseInboundReplicationCollection(object):
    """
    The collection of inbound replication records for a specific MySQL server.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ManagedMySqlDatabaseInboundReplicationCollection object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param inbound_replications_count:
            The value to assign to the inbound_replications_count property of this ManagedMySqlDatabaseInboundReplicationCollection.
        :type inbound_replications_count: int

        :param replica_uuid:
            The value to assign to the replica_uuid property of this ManagedMySqlDatabaseInboundReplicationCollection.
        :type replica_uuid: str

        :param replica_server_id:
            The value to assign to the replica_server_id property of this ManagedMySqlDatabaseInboundReplicationCollection.
        :type replica_server_id: int

        :param parallel_workers:
            The value to assign to the parallel_workers property of this ManagedMySqlDatabaseInboundReplicationCollection.
        :type parallel_workers: int

        :param preserve_commit_order:
            The value to assign to the preserve_commit_order property of this ManagedMySqlDatabaseInboundReplicationCollection.
        :type preserve_commit_order: str

        :param items:
            The value to assign to the items property of this ManagedMySqlDatabaseInboundReplicationCollection.
        :type items: list[oci.database_management.models.ManagedMySqlDatabaseInboundReplicationSummary]

        """
        self.swagger_types = {
            'inbound_replications_count': 'int',
            'replica_uuid': 'str',
            'replica_server_id': 'int',
            'parallel_workers': 'int',
            'preserve_commit_order': 'str',
            'items': 'list[ManagedMySqlDatabaseInboundReplicationSummary]'
        }
        self.attribute_map = {
            'inbound_replications_count': 'inboundReplicationsCount',
            'replica_uuid': 'replicaUuid',
            'replica_server_id': 'replicaServerId',
            'parallel_workers': 'parallelWorkers',
            'preserve_commit_order': 'preserveCommitOrder',
            'items': 'items'
        }
        self._inbound_replications_count = None
        self._replica_uuid = None
        self._replica_server_id = None
        self._parallel_workers = None
        self._preserve_commit_order = None
        self._items = None

    @property
    def inbound_replications_count(self):
        """
        Gets the inbound_replications_count of this ManagedMySqlDatabaseInboundReplicationCollection.
        The number of sources this server is replicating from.


        :return: The inbound_replications_count of this ManagedMySqlDatabaseInboundReplicationCollection.
        :rtype: int
        """
        return self._inbound_replications_count

    @inbound_replications_count.setter
    def inbound_replications_count(self, inbound_replications_count):
        """
        Sets the inbound_replications_count of this ManagedMySqlDatabaseInboundReplicationCollection.
        The number of sources this server is replicating from.


        :param inbound_replications_count: The inbound_replications_count of this ManagedMySqlDatabaseInboundReplicationCollection.
        :type: int
        """
        self._inbound_replications_count = inbound_replications_count

    @property
    def replica_uuid(self):
        """
        Gets the replica_uuid of this ManagedMySqlDatabaseInboundReplicationCollection.
        The Universally Unique Identifier (UUID) value of this replica server.


        :return: The replica_uuid of this ManagedMySqlDatabaseInboundReplicationCollection.
        :rtype: str
        """
        return self._replica_uuid

    @replica_uuid.setter
    def replica_uuid(self, replica_uuid):
        """
        Sets the replica_uuid of this ManagedMySqlDatabaseInboundReplicationCollection.
        The Universally Unique Identifier (UUID) value of this replica server.


        :param replica_uuid: The replica_uuid of this ManagedMySqlDatabaseInboundReplicationCollection.
        :type: str
        """
        self._replica_uuid = replica_uuid

    @property
    def replica_server_id(self):
        """
        Gets the replica_server_id of this ManagedMySqlDatabaseInboundReplicationCollection.
        The server ID value of this replica.


        :return: The replica_server_id of this ManagedMySqlDatabaseInboundReplicationCollection.
        :rtype: int
        """
        return self._replica_server_id

    @replica_server_id.setter
    def replica_server_id(self, replica_server_id):
        """
        Sets the replica_server_id of this ManagedMySqlDatabaseInboundReplicationCollection.
        The server ID value of this replica.


        :param replica_server_id: The replica_server_id of this ManagedMySqlDatabaseInboundReplicationCollection.
        :type: int
        """
        self._replica_server_id = replica_server_id

    @property
    def parallel_workers(self):
        """
        Gets the parallel_workers of this ManagedMySqlDatabaseInboundReplicationCollection.
        The number of applier threads for executing replication transactions in parallel.


        :return: The parallel_workers of this ManagedMySqlDatabaseInboundReplicationCollection.
        :rtype: int
        """
        return self._parallel_workers

    @parallel_workers.setter
    def parallel_workers(self, parallel_workers):
        """
        Sets the parallel_workers of this ManagedMySqlDatabaseInboundReplicationCollection.
        The number of applier threads for executing replication transactions in parallel.


        :param parallel_workers: The parallel_workers of this ManagedMySqlDatabaseInboundReplicationCollection.
        :type: int
        """
        self._parallel_workers = parallel_workers

    @property
    def preserve_commit_order(self):
        """
        Gets the preserve_commit_order of this ManagedMySqlDatabaseInboundReplicationCollection.
        For multi-threaded replicas, indicates if transactions are executed and committed on the replica in the same order as they appear in the relay log.


        :return: The preserve_commit_order of this ManagedMySqlDatabaseInboundReplicationCollection.
        :rtype: str
        """
        return self._preserve_commit_order

    @preserve_commit_order.setter
    def preserve_commit_order(self, preserve_commit_order):
        """
        Sets the preserve_commit_order of this ManagedMySqlDatabaseInboundReplicationCollection.
        For multi-threaded replicas, indicates if transactions are executed and committed on the replica in the same order as they appear in the relay log.


        :param preserve_commit_order: The preserve_commit_order of this ManagedMySqlDatabaseInboundReplicationCollection.
        :type: str
        """
        self._preserve_commit_order = preserve_commit_order

    @property
    def items(self):
        """
        **[Required]** Gets the items of this ManagedMySqlDatabaseInboundReplicationCollection.
        A list of ManagedMySqlDatabaseInboundReplicationSummary records.


        :return: The items of this ManagedMySqlDatabaseInboundReplicationCollection.
        :rtype: list[oci.database_management.models.ManagedMySqlDatabaseInboundReplicationSummary]
        """
        return self._items

    @items.setter
    def items(self, items):
        """
        Sets the items of this ManagedMySqlDatabaseInboundReplicationCollection.
        A list of ManagedMySqlDatabaseInboundReplicationSummary records.


        :param items: The items of this ManagedMySqlDatabaseInboundReplicationCollection.
        :type: list[oci.database_management.models.ManagedMySqlDatabaseInboundReplicationSummary]
        """
        self._items = items

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
