# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class EndpointDetails(object):
    """
    Details to provision Endpoint for the GenAi dedicated cluster.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new EndpointDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param endpoint_name:
            The value to assign to the endpoint_name property of this EndpointDetails.
        :type endpoint_name: str

        :param is_content_moderation_enabled:
            The value to assign to the is_content_moderation_enabled property of this EndpointDetails.
        :type is_content_moderation_enabled: bool

        """
        self.swagger_types = {
            'endpoint_name': 'str',
            'is_content_moderation_enabled': 'bool'
        }
        self.attribute_map = {
            'endpoint_name': 'endpointName',
            'is_content_moderation_enabled': 'isContentModerationEnabled'
        }
        self._endpoint_name = None
        self._is_content_moderation_enabled = None

    @property
    def endpoint_name(self):
        """
        **[Required]** Gets the endpoint_name of this EndpointDetails.
        Identifier for each endpoint.


        :return: The endpoint_name of this EndpointDetails.
        :rtype: str
        """
        return self._endpoint_name

    @endpoint_name.setter
    def endpoint_name(self, endpoint_name):
        """
        Sets the endpoint_name of this EndpointDetails.
        Identifier for each endpoint.


        :param endpoint_name: The endpoint_name of this EndpointDetails.
        :type: str
        """
        self._endpoint_name = endpoint_name

    @property
    def is_content_moderation_enabled(self):
        """
        **[Required]** Gets the is_content_moderation_enabled of this EndpointDetails.
        Helps remove toxic and biased content from responses.


        :return: The is_content_moderation_enabled of this EndpointDetails.
        :rtype: bool
        """
        return self._is_content_moderation_enabled

    @is_content_moderation_enabled.setter
    def is_content_moderation_enabled(self, is_content_moderation_enabled):
        """
        Sets the is_content_moderation_enabled of this EndpointDetails.
        Helps remove toxic and biased content from responses.


        :param is_content_moderation_enabled: The is_content_moderation_enabled of this EndpointDetails.
        :type: bool
        """
        self._is_content_moderation_enabled = is_content_moderation_enabled

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
