# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GgcsUserDetail(object):
    """
    Ggcs user credentials to be created or updated.
    """

    #: A constant which can be used with the action property of a GgcsUserDetail.
    #: This constant has a value of "CREATE"
    ACTION_CREATE = "CREATE"

    #: A constant which can be used with the action property of a GgcsUserDetail.
    #: This constant has a value of "UPDATE"
    ACTION_UPDATE = "UPDATE"

    def __init__(self, **kwargs):
        """
        Initializes a new GgcsUserDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param user_name:
            The value to assign to the user_name property of this GgcsUserDetail.
        :type user_name: str

        :param secret_id:
            The value to assign to the secret_id property of this GgcsUserDetail.
        :type secret_id: str

        :param user_type:
            The value to assign to the user_type property of this GgcsUserDetail.
        :type user_type: str

        :param action:
            The value to assign to the action property of this GgcsUserDetail.
            Allowed values for this property are: "CREATE", "UPDATE"
        :type action: str

        """
        self.swagger_types = {
            'user_name': 'str',
            'secret_id': 'str',
            'user_type': 'str',
            'action': 'str'
        }
        self.attribute_map = {
            'user_name': 'userName',
            'secret_id': 'secretId',
            'user_type': 'userType',
            'action': 'action'
        }
        self._user_name = None
        self._secret_id = None
        self._user_type = None
        self._action = None

    @property
    def user_name(self):
        """
        **[Required]** Gets the user_name of this GgcsUserDetail.
        username for the user.


        :return: The user_name of this GgcsUserDetail.
        :rtype: str
        """
        return self._user_name

    @user_name.setter
    def user_name(self, user_name):
        """
        Sets the user_name of this GgcsUserDetail.
        username for the user.


        :param user_name: The user_name of this GgcsUserDetail.
        :type: str
        """
        self._user_name = user_name

    @property
    def secret_id(self):
        """
        **[Required]** Gets the secret_id of this GgcsUserDetail.
        Vault OCID containing password for existing or new user.


        :return: The secret_id of this GgcsUserDetail.
        :rtype: str
        """
        return self._secret_id

    @secret_id.setter
    def secret_id(self, secret_id):
        """
        Sets the secret_id of this GgcsUserDetail.
        Vault OCID containing password for existing or new user.


        :param secret_id: The secret_id of this GgcsUserDetail.
        :type: str
        """
        self._secret_id = secret_id

    @property
    def user_type(self):
        """
        **[Required]** Gets the user_type of this GgcsUserDetail.
        Type of GoldenGate user. Allowed values are \"OPERATOR\".


        :return: The user_type of this GgcsUserDetail.
        :rtype: str
        """
        return self._user_type

    @user_type.setter
    def user_type(self, user_type):
        """
        Sets the user_type of this GgcsUserDetail.
        Type of GoldenGate user. Allowed values are \"OPERATOR\".


        :param user_type: The user_type of this GgcsUserDetail.
        :type: str
        """
        self._user_type = user_type

    @property
    def action(self):
        """
        **[Required]** Gets the action of this GgcsUserDetail.
        Action to be done over the user. Allowed values are \"CREATE\" or \"UPDATE\".

        Allowed values for this property are: "CREATE", "UPDATE"


        :return: The action of this GgcsUserDetail.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """
        Sets the action of this GgcsUserDetail.
        Action to be done over the user. Allowed values are \"CREATE\" or \"UPDATE\".


        :param action: The action of this GgcsUserDetail.
        :type: str
        """
        allowed_values = ["CREATE", "UPDATE"]
        if not value_allowed_none_or_none_sentinel(action, allowed_values):
            raise ValueError(
                f"Invalid value for `action`, must be None or one of {allowed_values}"
            )
        self._action = action

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
