# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateAutomaticDrConfigurationDetails(object):
    """
    The details for updating an Automatic DR configuration.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateAutomaticDrConfigurationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateAutomaticDrConfigurationDetails.
        :type display_name: str

        :param members:
            The value to assign to the members property of this UpdateAutomaticDrConfigurationDetails.
        :type members: list[oci.disaster_recovery.models.UpdateAutomaticDrConfigurationMemberDetails]

        :param default_switchover_dr_plan_id:
            The value to assign to the default_switchover_dr_plan_id property of this UpdateAutomaticDrConfigurationDetails.
        :type default_switchover_dr_plan_id: str

        :param default_failover_dr_plan_id:
            The value to assign to the default_failover_dr_plan_id property of this UpdateAutomaticDrConfigurationDetails.
        :type default_failover_dr_plan_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateAutomaticDrConfigurationDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateAutomaticDrConfigurationDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'members': 'list[UpdateAutomaticDrConfigurationMemberDetails]',
            'default_switchover_dr_plan_id': 'str',
            'default_failover_dr_plan_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'members': 'members',
            'default_switchover_dr_plan_id': 'defaultSwitchoverDrPlanId',
            'default_failover_dr_plan_id': 'defaultFailoverDrPlanId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._members = None
        self._default_switchover_dr_plan_id = None
        self._default_failover_dr_plan_id = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateAutomaticDrConfigurationDetails.
        The display name of the Automatic DR configuration being updated.

        Example: `Automatic DR Configuration`


        :return: The display_name of this UpdateAutomaticDrConfigurationDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateAutomaticDrConfigurationDetails.
        The display name of the Automatic DR configuration being updated.

        Example: `Automatic DR Configuration`


        :param display_name: The display_name of this UpdateAutomaticDrConfigurationDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def members(self):
        """
        Gets the members of this UpdateAutomaticDrConfigurationDetails.
        A list of members for Automatic DR configuration.


        :return: The members of this UpdateAutomaticDrConfigurationDetails.
        :rtype: list[oci.disaster_recovery.models.UpdateAutomaticDrConfigurationMemberDetails]
        """
        return self._members

    @members.setter
    def members(self, members):
        """
        Sets the members of this UpdateAutomaticDrConfigurationDetails.
        A list of members for Automatic DR configuration.


        :param members: The members of this UpdateAutomaticDrConfigurationDetails.
        :type: list[oci.disaster_recovery.models.UpdateAutomaticDrConfigurationMemberDetails]
        """
        self._members = members

    @property
    def default_switchover_dr_plan_id(self):
        """
        Gets the default_switchover_dr_plan_id of this UpdateAutomaticDrConfigurationDetails.
        The unique id of a Switchover DR Plan.

        Example: `ocid1.drplan.oc1..uniqueID`


        :return: The default_switchover_dr_plan_id of this UpdateAutomaticDrConfigurationDetails.
        :rtype: str
        """
        return self._default_switchover_dr_plan_id

    @default_switchover_dr_plan_id.setter
    def default_switchover_dr_plan_id(self, default_switchover_dr_plan_id):
        """
        Sets the default_switchover_dr_plan_id of this UpdateAutomaticDrConfigurationDetails.
        The unique id of a Switchover DR Plan.

        Example: `ocid1.drplan.oc1..uniqueID`


        :param default_switchover_dr_plan_id: The default_switchover_dr_plan_id of this UpdateAutomaticDrConfigurationDetails.
        :type: str
        """
        self._default_switchover_dr_plan_id = default_switchover_dr_plan_id

    @property
    def default_failover_dr_plan_id(self):
        """
        Gets the default_failover_dr_plan_id of this UpdateAutomaticDrConfigurationDetails.
        The unique id of a Failover DR Plan.

        Example: `ocid1.drplan.oc1..uniqueID`


        :return: The default_failover_dr_plan_id of this UpdateAutomaticDrConfigurationDetails.
        :rtype: str
        """
        return self._default_failover_dr_plan_id

    @default_failover_dr_plan_id.setter
    def default_failover_dr_plan_id(self, default_failover_dr_plan_id):
        """
        Sets the default_failover_dr_plan_id of this UpdateAutomaticDrConfigurationDetails.
        The unique id of a Failover DR Plan.

        Example: `ocid1.drplan.oc1..uniqueID`


        :param default_failover_dr_plan_id: The default_failover_dr_plan_id of this UpdateAutomaticDrConfigurationDetails.
        :type: str
        """
        self._default_failover_dr_plan_id = default_failover_dr_plan_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateAutomaticDrConfigurationDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.

        Example: `{\"Department\": \"Finance\"}`


        :return: The freeform_tags of this UpdateAutomaticDrConfigurationDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateAutomaticDrConfigurationDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.

        Example: `{\"Department\": \"Finance\"}`


        :param freeform_tags: The freeform_tags of this UpdateAutomaticDrConfigurationDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateAutomaticDrConfigurationDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`


        :return: The defined_tags of this UpdateAutomaticDrConfigurationDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateAutomaticDrConfigurationDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`


        :param defined_tags: The defined_tags of this UpdateAutomaticDrConfigurationDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
