# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RunOnDetails(object):
    """
    The runon conditions
    """

    #: A constant which can be used with the kind property of a RunOnDetails.
    #: This constant has a value of "SCHEDULED_INSTANCES"
    KIND_SCHEDULED_INSTANCES = "SCHEDULED_INSTANCES"

    #: A constant which can be used with the kind property of a RunOnDetails.
    #: This constant has a value of "SELF_HOSTED_INSTANCES"
    KIND_SELF_HOSTED_INSTANCES = "SELF_HOSTED_INSTANCES"

    #: A constant which can be used with the kind property of a RunOnDetails.
    #: This constant has a value of "PREVIOUS_TASK_INSTANCES"
    KIND_PREVIOUS_TASK_INSTANCES = "PREVIOUS_TASK_INSTANCES"

    #: A constant which can be used with the kind property of a RunOnDetails.
    #: This constant has a value of "SCHEDULE_INSTANCE_TARGETS"
    KIND_SCHEDULE_INSTANCE_TARGETS = "SCHEDULE_INSTANCE_TARGETS"

    def __init__(self, **kwargs):
        """
        Initializes a new RunOnDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.fleet_apps_management.models.SelfHostedInstanceRunOnDetails`
        * :class:`~oci.fleet_apps_management.models.ScheduleInstanceRunOnDetails`
        * :class:`~oci.fleet_apps_management.models.PreviousTaskInstanceRunOnDetails`
        * :class:`~oci.fleet_apps_management.models.ScheduleInstanceTargetRunOnDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param kind:
            The value to assign to the kind property of this RunOnDetails.
            Allowed values for this property are: "SCHEDULED_INSTANCES", "SELF_HOSTED_INSTANCES", "PREVIOUS_TASK_INSTANCES", "SCHEDULE_INSTANCE_TARGETS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type kind: str

        """
        self.swagger_types = {
            'kind': 'str'
        }
        self.attribute_map = {
            'kind': 'kind'
        }
        self._kind = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['kind']

        if type == 'SELF_HOSTED_INSTANCES':
            return 'SelfHostedInstanceRunOnDetails'

        if type == 'SCHEDULE_INSTANCES':
            return 'ScheduleInstanceRunOnDetails'

        if type == 'PREVIOUS_TASK_INSTANCES':
            return 'PreviousTaskInstanceRunOnDetails'

        if type == 'SCHEDULE_INSTANCE_TARGETS':
            return 'ScheduleInstanceTargetRunOnDetails'
        else:
            return 'RunOnDetails'

    @property
    def kind(self):
        """
        **[Required]** Gets the kind of this RunOnDetails.
        Run on based On.

        Allowed values for this property are: "SCHEDULED_INSTANCES", "SELF_HOSTED_INSTANCES", "PREVIOUS_TASK_INSTANCES", "SCHEDULE_INSTANCE_TARGETS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The kind of this RunOnDetails.
        :rtype: str
        """
        return self._kind

    @kind.setter
    def kind(self, kind):
        """
        Sets the kind of this RunOnDetails.
        Run on based On.


        :param kind: The kind of this RunOnDetails.
        :type: str
        """
        allowed_values = ["SCHEDULED_INSTANCES", "SELF_HOSTED_INSTANCES", "PREVIOUS_TASK_INSTANCES", "SCHEDULE_INSTANCE_TARGETS"]
        if not value_allowed_none_or_none_sentinel(kind, allowed_values):
            kind = 'UNKNOWN_ENUM_VALUE'
        self._kind = kind

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
