# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpcomingSchedule(object):
    """
    Enables notification on upcoming schedule.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpcomingSchedule object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param on_upcoming_schedule:
            The value to assign to the on_upcoming_schedule property of this UpcomingSchedule.
        :type on_upcoming_schedule: bool

        :param notify_before:
            The value to assign to the notify_before property of this UpcomingSchedule.
        :type notify_before: str

        """
        self.swagger_types = {
            'on_upcoming_schedule': 'bool',
            'notify_before': 'str'
        }
        self.attribute_map = {
            'on_upcoming_schedule': 'onUpcomingSchedule',
            'notify_before': 'notifyBefore'
        }
        self._on_upcoming_schedule = None
        self._notify_before = None

    @property
    def on_upcoming_schedule(self):
        """
        Gets the on_upcoming_schedule of this UpcomingSchedule.
        Enables notification on upcoming schedule.


        :return: The on_upcoming_schedule of this UpcomingSchedule.
        :rtype: bool
        """
        return self._on_upcoming_schedule

    @on_upcoming_schedule.setter
    def on_upcoming_schedule(self, on_upcoming_schedule):
        """
        Sets the on_upcoming_schedule of this UpcomingSchedule.
        Enables notification on upcoming schedule.


        :param on_upcoming_schedule: The on_upcoming_schedule of this UpcomingSchedule.
        :type: bool
        """
        self._on_upcoming_schedule = on_upcoming_schedule

    @property
    def notify_before(self):
        """
        Gets the notify_before of this UpcomingSchedule.
        Specify when the notification should be sent.


        :return: The notify_before of this UpcomingSchedule.
        :rtype: str
        """
        return self._notify_before

    @notify_before.setter
    def notify_before(self, notify_before):
        """
        Sets the notify_before of this UpcomingSchedule.
        Specify when the notification should be sent.


        :param notify_before: The notify_before of this UpcomingSchedule.
        :type: str
        """
        self._notify_before = notify_before

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
