# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from .tool_output import ToolOutput
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GenericToolOutput(ToolOutput):
    """
    Specifies an output format for tools that return freeform or unstructured JSON content.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GenericToolOutput object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_agent_runtime.models.GenericToolOutput.tool_output_type` attribute
        of this class is ``GENERIC_TOOL_OUTPUT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param tool_id:
            The value to assign to the tool_id property of this GenericToolOutput.
        :type tool_id: str

        :param tool_name:
            The value to assign to the tool_name property of this GenericToolOutput.
        :type tool_name: str

        :param tool_output_type:
            The value to assign to the tool_output_type property of this GenericToolOutput.
            Allowed values for this property are: "GENERIC_TOOL_OUTPUT", "SQL_TOOL_OUTPUT", "RAG_TOOL_OUTPUT"
        :type tool_output_type: str

        :param output:
            The value to assign to the output property of this GenericToolOutput.
        :type output: object

        """
        self.swagger_types = {
            'tool_id': 'str',
            'tool_name': 'str',
            'tool_output_type': 'str',
            'output': 'object'
        }
        self.attribute_map = {
            'tool_id': 'toolId',
            'tool_name': 'toolName',
            'tool_output_type': 'toolOutputType',
            'output': 'output'
        }
        self._tool_id = None
        self._tool_name = None
        self._tool_output_type = None
        self._output = None
        self._tool_output_type = 'GENERIC_TOOL_OUTPUT'

    @property
    def output(self):
        """
        **[Required]** Gets the output of this GenericToolOutput.
        Specifies the freeform JSON object containing the tool\u2019s output.


        :return: The output of this GenericToolOutput.
        :rtype: object
        """
        return self._output

    @output.setter
    def output(self, output):
        """
        Sets the output of this GenericToolOutput.
        Specifies the freeform JSON object containing the tool\u2019s output.


        :param output: The output of this GenericToolOutput.
        :type: object
        """
        self._output = output

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
