# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateAttachmentDetails(object):
    """
    An attachment uploaded by the Publisher to be attached to an Offer.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateAttachmentDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param file_base64_encoded:
            The value to assign to the file_base64_encoded property of this CreateAttachmentDetails.
        :type file_base64_encoded: str

        :param display_name:
            The value to assign to the display_name property of this CreateAttachmentDetails.
        :type display_name: str

        :param type:
            The value to assign to the type property of this CreateAttachmentDetails.
        :type type: str

        """
        self.swagger_types = {
            'file_base64_encoded': 'str',
            'display_name': 'str',
            'type': 'str'
        }
        self.attribute_map = {
            'file_base64_encoded': 'fileBase64Encoded',
            'display_name': 'displayName',
            'type': 'type'
        }
        self._file_base64_encoded = None
        self._display_name = None
        self._type = None

    @property
    def file_base64_encoded(self):
        """
        **[Required]** Gets the file_base64_encoded of this CreateAttachmentDetails.
        Base64-encoded file to attach to the Offer. File must be a PDF with maximum size of 1 MB


        :return: The file_base64_encoded of this CreateAttachmentDetails.
        :rtype: str
        """
        return self._file_base64_encoded

    @file_base64_encoded.setter
    def file_base64_encoded(self, file_base64_encoded):
        """
        Sets the file_base64_encoded of this CreateAttachmentDetails.
        Base64-encoded file to attach to the Offer. File must be a PDF with maximum size of 1 MB


        :param file_base64_encoded: The file_base64_encoded of this CreateAttachmentDetails.
        :type: str
        """
        self._file_base64_encoded = file_base64_encoded

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateAttachmentDetails.
        The name used to refer to the uploaded data.


        :return: The display_name of this CreateAttachmentDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateAttachmentDetails.
        The name used to refer to the uploaded data.


        :param display_name: The display_name of this CreateAttachmentDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def type(self):
        """
        **[Required]** Gets the type of this CreateAttachmentDetails.
        The type of offer attachment.


        :return: The type of this CreateAttachmentDetails.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CreateAttachmentDetails.
        The type of offer attachment.


        :param type: The type of this CreateAttachmentDetails.
        :type: str
        """
        self._type = type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
