# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OpensearchClusterInternalDetails(object):
    """
    This is the ClusterLoadBalancer which can store the State of the cluster, opensearchLoadbalancerIps, remoteLoadbalancerIps
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OpensearchClusterInternalDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param state:
            The value to assign to the state property of this OpensearchClusterInternalDetails.
        :type state: str

        :param elastic_load_balancer_ips:
            The value to assign to the elastic_load_balancer_ips property of this OpensearchClusterInternalDetails.
        :type elastic_load_balancer_ips: list[str]

        :param remote_load_balancer_ips:
            The value to assign to the remote_load_balancer_ips property of this OpensearchClusterInternalDetails.
        :type remote_load_balancer_ips: list[str]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this OpensearchClusterInternalDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this OpensearchClusterInternalDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this OpensearchClusterInternalDetails.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'state': 'str',
            'elastic_load_balancer_ips': 'list[str]',
            'remote_load_balancer_ips': 'list[str]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'state': 'state',
            'elastic_load_balancer_ips': 'elasticLoadBalancerIps',
            'remote_load_balancer_ips': 'remoteLoadBalancerIps',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._state = None
        self._elastic_load_balancer_ips = None
        self._remote_load_balancer_ips = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def state(self):
        """
        **[Required]** Gets the state of this OpensearchClusterInternalDetails.
        The state of the cluster.


        :return: The state of this OpensearchClusterInternalDetails.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this OpensearchClusterInternalDetails.
        The state of the cluster.


        :param state: The state of this OpensearchClusterInternalDetails.
        :type: str
        """
        self._state = state

    @property
    def elastic_load_balancer_ips(self):
        """
        **[Required]** Gets the elastic_load_balancer_ips of this OpensearchClusterInternalDetails.
        List of OpenSearch elastic LoadbalancerIps


        :return: The elastic_load_balancer_ips of this OpensearchClusterInternalDetails.
        :rtype: list[str]
        """
        return self._elastic_load_balancer_ips

    @elastic_load_balancer_ips.setter
    def elastic_load_balancer_ips(self, elastic_load_balancer_ips):
        """
        Sets the elastic_load_balancer_ips of this OpensearchClusterInternalDetails.
        List of OpenSearch elastic LoadbalancerIps


        :param elastic_load_balancer_ips: The elastic_load_balancer_ips of this OpensearchClusterInternalDetails.
        :type: list[str]
        """
        self._elastic_load_balancer_ips = elastic_load_balancer_ips

    @property
    def remote_load_balancer_ips(self):
        """
        **[Required]** Gets the remote_load_balancer_ips of this OpensearchClusterInternalDetails.
        List of OpenSearch remote LoadbalancerIps


        :return: The remote_load_balancer_ips of this OpensearchClusterInternalDetails.
        :rtype: list[str]
        """
        return self._remote_load_balancer_ips

    @remote_load_balancer_ips.setter
    def remote_load_balancer_ips(self, remote_load_balancer_ips):
        """
        Sets the remote_load_balancer_ips of this OpensearchClusterInternalDetails.
        List of OpenSearch remote LoadbalancerIps


        :param remote_load_balancer_ips: The remote_load_balancer_ips of this OpensearchClusterInternalDetails.
        :type: list[str]
        """
        self._remote_load_balancer_ips = remote_load_balancer_ips

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this OpensearchClusterInternalDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this OpensearchClusterInternalDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this OpensearchClusterInternalDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this OpensearchClusterInternalDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this OpensearchClusterInternalDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this OpensearchClusterInternalDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this OpensearchClusterInternalDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this OpensearchClusterInternalDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this OpensearchClusterInternalDetails.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this OpensearchClusterInternalDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this OpensearchClusterInternalDetails.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this OpensearchClusterInternalDetails.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
