/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.14.0
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtBluetooth.h"

#line 24 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtBluetooth/qpybluetooth_quint128.sip"
#include <qbluetoothuuid.h>
#line 29 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtBluetooth/sipQtBluetoothquint128.cpp"



extern "C" {static void assign_quint128(void *, Py_ssize_t, void *);}
static void assign_quint128(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::quint128 *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::quint128 *>(sipSrc);
}


extern "C" {static void *array_quint128(Py_ssize_t);}
static void *array_quint128(Py_ssize_t sipNrElem)
{
    return new ::quint128[sipNrElem];
}


extern "C" {static void *copy_quint128(const void *, Py_ssize_t);}
static void *copy_quint128(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::quint128(reinterpret_cast<const ::quint128 *>(sipSrc)[sipSrcIdx]);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_quint128(void *, int);}
static void release_quint128(void *sipCppV, int)
{
    ::quint128 *sipCpp = reinterpret_cast< ::quint128 *>(sipCppV);
    delete sipCpp;
}



extern "C" {static int convertTo_quint128(PyObject *, void **, int *, PyObject *);}
static int convertTo_quint128(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj)
{
    ::quint128 **sipCppPtr = reinterpret_cast< ::quint128 **>(sipCppPtrV);

#line 53 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtBluetooth/qpybluetooth_quint128.sip"
    if (!sipIsErr)
        return (PySequence_Check(sipPy)
#if PY_MAJOR_VERSION < 3
                && !PyString_Check(sipPy)
#endif
                && !PyUnicode_Check(sipPy));

    Py_ssize_t len = PySequence_Size(sipPy);

    if (len != 16)
    {
        // A negative length should only be an internal error so let the
        // original exception stand.
        if (len >= 0)
            PyErr_Format(PyExc_TypeError,
                    "sequence has %zd elements but 16 elements are expected",
                    len);

        *sipIsErr = 1;

        return 0;
    }

    quint128 *qv = new quint128;

    for (Py_ssize_t i = 0; i < 16; ++i)
    {
        PyObject *itm = PySequence_GetItem(sipPy, i);

        if (!itm)
        {
            delete qv;
            *sipIsErr = 1;

            return 0;
        }

        PyErr_Clear();
        unsigned long val = PyLong_AsUnsignedLongMask(itm);

        if (PyErr_Occurred())
        {
            PyErr_Format(PyExc_TypeError,
                    "element %zd has type '%s' but 'int' is expected", i,
                    sipPyTypeName(Py_TYPE(itm)));

            Py_DECREF(itm);
            delete qv;
            *sipIsErr = 1;

            return 0;
        }

        qv->data[i] = val;

        Py_DECREF(itm);
    }

    *sipCppPtr = qv;

    return sipGetState(sipTransferObj);
#line 131 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtBluetooth/sipQtBluetoothquint128.cpp"
}


extern "C" {static PyObject *convertFrom_quint128(void *, PyObject *);}
static PyObject *convertFrom_quint128(void *sipCppV, PyObject *)
{
    ::quint128 *sipCpp = reinterpret_cast< ::quint128 *>(sipCppV);

#line 28 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtBluetooth/qpybluetooth_quint128.sip"
    PyObject *t = PyTuple_New(16);

    if (!t)
        return 0;

    for (Py_ssize_t i = 0; i < 16; ++i)
    {
        // Convert to a Python long to make sure it doesn't get interpreted as
        // a signed value.
        PyObject *pobj = PyLong_FromUnsignedLong(sipCpp->data[i]);

        if (!pobj)
        {
            Py_DECREF(t);

            return 0;
        }

        PyTuple_SetItem(t, i, pobj);
    }

    return t;
#line 163 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtBluetooth/sipQtBluetoothquint128.cpp"
}


sipMappedTypeDef sipTypeDef_QtBluetooth_quint128 = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_MAPPED,
        sipNameNr_quint128,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        -1,
        {0, 0, 1},
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR}
    },
    assign_quint128,
    array_quint128,
    copy_quint128,
    release_quint128,
    convertTo_quint128,
    convertFrom_quint128
};
